/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert2.transforms;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.concurrent.ConcurrentHashMap;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction$;
import org.locationtech.geomesa.convert2.transforms.TransformerFunctionFactory;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.text.WKBUtils$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.concurrent.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u001b\t9r)Z8nKR\u0014\u0018PR;oGRLwN\u001c$bGR|'/\u001f\u0006\u0003\u0007\u0011\t!\u0002\u001e:b]N4wN]7t\u0015\t)a!\u0001\u0005d_:4XM\u001d;3\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011AA\u0005\u0003/\t\u0011!\u0004\u0016:b]N4wN]7fe\u001a+hn\u0019;j_:4\u0015m\u0019;pefDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005U\u0001\u0001\"B\u000f\u0001\t\u0003r\u0012!\u00034v]\u000e$\u0018n\u001c8t+\u0005y\u0002c\u0001\u0011$K5\t\u0011E\u0003\u0002#!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0011\n#aA*fcB\u0011QCJ\u0005\u0003O\t\u00111\u0003\u0016:b]N4wN]7fe\u001a+hn\u0019;j_:Dq!\u000b\u0001C\u0002\u0013%!&\u0001\u0002hMV\t1\u0006\u0005\u0002-k5\tQF\u0003\u0002/_\u0005!q-Z8n\u0015\t\u0001\u0014'A\u0002kiNT!AM\u001a\u0002\u001dYLg/\u001b3t_2,H/[8og*\tA'A\u0002d_6L!AN\u0017\u0003\u001f\u001d+w.\\3uef4\u0015m\u0019;pefDa\u0001\u000f\u0001!\u0002\u0013Y\u0013aA4gA!9!\b\u0001b\u0001\n\u0013Y\u0014!\u00049pS:$\b+\u0019:tKJ4e.F\u0001&\u0011\u0019i\u0004\u0001)A\u0005K\u0005q\u0001o\\5oiB\u000b'o]3s\r:\u0004\u0003bB \u0001\u0005\u0004%IaO\u0001\u0013[VdG/\u001b)pS:$\b+\u0019:tKJ4e\u000e\u0003\u0004B\u0001\u0001\u0006I!J\u0001\u0014[VdG/\u001b)pS:$\b+\u0019:tKJ4e\u000e\t\u0005\b\u0007\u0002\u0011\r\u0011\"\u0003<\u0003Ia\u0017N\\3TiJLgn\u001a)beN,'O\u00128\t\r\u0015\u0003\u0001\u0015!\u0003&\u0003Ma\u0017N\\3TiJLgn\u001a)beN,'O\u00128!\u0011\u001d9\u0005A1A\u0005\nm\nq#\\;mi&d\u0015N\\3TiJLgn\u001a)beN,'O\u00128\t\r%\u0003\u0001\u0015!\u0003&\u0003aiW\u000f\u001c;j\u0019&tWm\u0015;sS:<\u0007+\u0019:tKJ4e\u000e\t\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003<\u0003=\u0001x\u000e\\=h_:\u0004\u0016M]:fe\u001as\u0007BB'\u0001A\u0003%Q%\u0001\tq_2Lxm\u001c8QCJ\u001cXM\u001d$oA!9q\n\u0001b\u0001\n\u0013Y\u0014\u0001F7vYRL\u0007k\u001c7zO>t\u0007+\u0019:tKJ4e\u000e\u0003\u0004R\u0001\u0001\u0006I!J\u0001\u0016[VdG/\u001b)pYf<wN\u001c)beN,'O\u00128!\u0011\u001d\u0019\u0006A1A\u0005\nm\n!dZ3p[\u0016$(/_\"pY2,7\r^5p]B\u000b'o]3s\r:Da!\u0016\u0001!\u0002\u0013)\u0013aG4f_6,GO]=D_2dWm\u0019;j_:\u0004\u0016M]:fe\u001as\u0007\u0005C\u0004X\u0001\t\u0007I\u0011B\u001e\u0002!\u001d,w.\\3uef\u0004\u0016M]:fe\u001as\u0007BB-\u0001A\u0003%Q%A\thK>lW\r\u001e:z!\u0006\u00148/\u001a:G]\u0002Bqa\u0017\u0001C\u0002\u0013%A,A\nqe>TWm\u0019;Ge>l\u0007+\u0019:tKJ4e.F\u0001^!\tqfN\u0004\u0002`Y:\u0011\u0001m\u001b\b\u0003C*t!AY5\u000f\u0005\rDgB\u00013h\u001b\u0005)'B\u00014\r\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\n\u00055\u0014\u0011a\u0005+sC:\u001chm\u001c:nKJ4UO\\2uS>t\u0017BA8q\u0005aq\u0015-\\3e)J\fgn\u001d4pe6,'OR;oGRLwN\u001c\u0006\u0003[\nAaA\u001d\u0001!\u0002\u0013i\u0016\u0001\u00069s_*,7\r\u001e$s_6\u0004\u0016M]:fe\u001as\u0007\u0005")
public class GeometryFunctionFactory
implements TransformerFunctionFactory {
    private final GeometryFactory org$locationtech$geomesa$convert2$transforms$GeometryFunctionFactory$$gf = JTSFactoryFinder.getGeometryFactory();
    private final TransformerFunction pointParserFn = TransformerFunction$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;
        private final /* synthetic */ GeometryFunctionFactory $outer;

        public final Object apply(Object[] x0$1) {
            Object[] objectArray;
            block7: {
                Point point;
                block3: {
                    Object g;
                    block6: {
                        Object g2;
                        Option option;
                        block5: {
                            Option option2;
                            block4: {
                                block2: {
                                    Point point2;
                                    Object g3;
                                    objectArray = x0$1;
                                    Option option3 = Array$.MODULE$.unapplySeq((Object)objectArray);
                                    if (option3.isEmpty() || option3.get() == null || ((SeqLike)option3.get()).lengthCompare(1) != 0 || !((g3 = ((SeqLike)option3.get()).apply(0)) instanceof Point)) break block2;
                                    point = point2 = (Point)g3;
                                    break block3;
                                }
                                Option option4 = Array$.MODULE$.unapplySeq((Object)objectArray);
                                if (option4.isEmpty() || option4.get() == null || ((SeqLike)option4.get()).lengthCompare(2) != 0) break block4;
                                Object x = ((SeqLike)option4.get()).apply(0);
                                Object y = ((SeqLike)option4.get()).apply(1);
                                if (!(x instanceof Float)) break block4;
                                float f = BoxesRunTime.unboxToFloat((Object)x);
                                if (!(y instanceof Float)) break block4;
                                float f2 = BoxesRunTime.unboxToFloat((Object)y);
                                point = this.$outer.org$locationtech$geomesa$convert2$transforms$GeometryFunctionFactory$$gf().createPoint(new Coordinate((double)f, (double)f2));
                                break block3;
                            }
                            if ((option2 = Array$.MODULE$.unapplySeq((Object)objectArray)).isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(2) != 0) break block5;
                            Object x = ((SeqLike)option2.get()).apply(0);
                            Object y = ((SeqLike)option2.get()).apply(1);
                            if (!(x instanceof Double)) break block5;
                            double d = BoxesRunTime.unboxToDouble((Object)x);
                            if (!(y instanceof Double)) break block5;
                            double d2 = BoxesRunTime.unboxToDouble((Object)y);
                            point = this.$outer.org$locationtech$geomesa$convert2$transforms$GeometryFunctionFactory$$gf().createPoint(new Coordinate(d, d2));
                            break block3;
                        }
                        if ((option = Array$.MODULE$.unapplySeq((Object)objectArray)).isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g2 = ((SeqLike)option.get()).apply(0)) instanceof String)) break block6;
                        String string = (String)g2;
                        point = (Point)WKTUtils$.MODULE$.read(string);
                        break block3;
                    }
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g = ((SeqLike)option.get()).apply(0)) instanceof byte[])) break block7;
                    byte[] byArray = (byte[])g;
                    point = (Point)WKBUtils$.MODULE$.read(byArray);
                }
                return point;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid point conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)objectArray).mkString(",")})));
        }
        {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    });
    private final TransformerFunction multiPointParserFn = TransformerFunction$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"multipoint"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] x0$2) {
            Object[] objectArray;
            block5: {
                MultiPoint multiPoint;
                block3: {
                    Object g;
                    block4: {
                        Object g2;
                        block2: {
                            MultiPoint multiPoint2;
                            Object g3;
                            objectArray = x0$2;
                            Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g3 = ((SeqLike)option.get()).apply(0)) instanceof MultiPoint)) break block2;
                            multiPoint = multiPoint2 = (MultiPoint)g3;
                            break block3;
                        }
                        Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g2 = ((SeqLike)option.get()).apply(0)) instanceof String)) break block4;
                        String string = (String)g2;
                        multiPoint = (MultiPoint)WKTUtils$.MODULE$.read(string);
                        break block3;
                    }
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g = ((SeqLike)option.get()).apply(0)) instanceof byte[])) break block5;
                    byte[] byArray = (byte[])g;
                    multiPoint = (MultiPoint)WKBUtils$.MODULE$.read(byArray);
                }
                return multiPoint;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid multipoint conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)objectArray).mkString(",")})));
        }
    });
    private final TransformerFunction lineStringParserFn = TransformerFunction$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"linestring"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] x0$3) {
            Object[] objectArray;
            block5: {
                LineString lineString;
                block3: {
                    Object g;
                    block4: {
                        Object g2;
                        block2: {
                            LineString lineString2;
                            Object g3;
                            objectArray = x0$3;
                            Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g3 = ((SeqLike)option.get()).apply(0)) instanceof LineString)) break block2;
                            lineString = lineString2 = (LineString)g3;
                            break block3;
                        }
                        Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g2 = ((SeqLike)option.get()).apply(0)) instanceof String)) break block4;
                        String string = (String)g2;
                        lineString = (LineString)WKTUtils$.MODULE$.read(string);
                        break block3;
                    }
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g = ((SeqLike)option.get()).apply(0)) instanceof byte[])) break block5;
                    byte[] byArray = (byte[])g;
                    lineString = (LineString)WKBUtils$.MODULE$.read(byArray);
                }
                return lineString;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid linestring conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)objectArray).mkString(",")})));
        }
    });
    private final TransformerFunction multiLineStringParserFn = TransformerFunction$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"multilinestring"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] x0$4) {
            Object[] objectArray;
            block5: {
                MultiLineString multiLineString;
                block3: {
                    Object g;
                    block4: {
                        Object g2;
                        block2: {
                            MultiLineString multiLineString2;
                            Object g3;
                            objectArray = x0$4;
                            Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g3 = ((SeqLike)option.get()).apply(0)) instanceof MultiLineString)) break block2;
                            multiLineString = multiLineString2 = (MultiLineString)g3;
                            break block3;
                        }
                        Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g2 = ((SeqLike)option.get()).apply(0)) instanceof String)) break block4;
                        String string = (String)g2;
                        multiLineString = (MultiLineString)WKTUtils$.MODULE$.read(string);
                        break block3;
                    }
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g = ((SeqLike)option.get()).apply(0)) instanceof byte[])) break block5;
                    byte[] byArray = (byte[])g;
                    multiLineString = WKBUtils$.MODULE$.read(byArray);
                }
                return multiLineString;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid multilinestring conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)objectArray).mkString(",")})));
        }
    });
    private final TransformerFunction polygonParserFn = TransformerFunction$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"polygon"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] x0$5) {
            Object[] objectArray;
            block5: {
                Polygon polygon;
                block3: {
                    Object g;
                    block4: {
                        Object g2;
                        block2: {
                            Polygon polygon2;
                            Object g3;
                            objectArray = x0$5;
                            Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g3 = ((SeqLike)option.get()).apply(0)) instanceof Polygon)) break block2;
                            polygon = polygon2 = (Polygon)g3;
                            break block3;
                        }
                        Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g2 = ((SeqLike)option.get()).apply(0)) instanceof String)) break block4;
                        String string = (String)g2;
                        polygon = (Polygon)WKTUtils$.MODULE$.read(string);
                        break block3;
                    }
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g = ((SeqLike)option.get()).apply(0)) instanceof byte[])) break block5;
                    byte[] byArray = (byte[])g;
                    polygon = (Polygon)WKBUtils$.MODULE$.read(byArray);
                }
                return polygon;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid polygon conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)objectArray).mkString(",")})));
        }
    });
    private final TransformerFunction multiPolygonParserFn = TransformerFunction$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"multipolygon"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] x0$6) {
            Object[] objectArray;
            block5: {
                MultiPolygon multiPolygon;
                block3: {
                    Object g;
                    block4: {
                        Object g2;
                        block2: {
                            MultiPolygon multiPolygon2;
                            Object g3;
                            objectArray = x0$6;
                            Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g3 = ((SeqLike)option.get()).apply(0)) instanceof MultiPolygon)) break block2;
                            multiPolygon = multiPolygon2 = (MultiPolygon)g3;
                            break block3;
                        }
                        Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g2 = ((SeqLike)option.get()).apply(0)) instanceof String)) break block4;
                        String string = (String)g2;
                        multiPolygon = (MultiPolygon)WKTUtils$.MODULE$.read(string);
                        break block3;
                    }
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g = ((SeqLike)option.get()).apply(0)) instanceof byte[])) break block5;
                    byte[] byArray = (byte[])g;
                    multiPolygon = (MultiPolygon)WKBUtils$.MODULE$.read(byArray);
                }
                return multiPolygon;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid multipolygon conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)objectArray).mkString(",")})));
        }
    });
    private final TransformerFunction geometryCollectionParserFn = TransformerFunction$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"geometrycollection"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] x0$7) {
            Object[] objectArray;
            block5: {
                GeometryCollection geometryCollection;
                block3: {
                    Object g;
                    block4: {
                        Object g2;
                        block2: {
                            GeometryCollection geometryCollection2;
                            Object g3;
                            objectArray = x0$7;
                            Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g3 = ((SeqLike)option.get()).apply(0)) instanceof GeometryCollection)) break block2;
                            geometryCollection = geometryCollection2 = (GeometryCollection)g3;
                            break block3;
                        }
                        Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g2 = ((SeqLike)option.get()).apply(0)) instanceof String)) break block4;
                        String string = (String)g2;
                        geometryCollection = (GeometryCollection)WKTUtils$.MODULE$.read(string);
                        break block3;
                    }
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g = ((SeqLike)option.get()).apply(0)) instanceof byte[])) break block5;
                    byte[] byArray = (byte[])g;
                    geometryCollection = WKBUtils$.MODULE$.read(byArray);
                }
                return geometryCollection;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid geometrycollection conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)objectArray).mkString(",")})));
        }
    });
    private final TransformerFunction geometryParserFn = TransformerFunction$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"geometry"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] x0$8) {
            Object[] objectArray;
            block5: {
                Geometry geometry;
                block3: {
                    Object g;
                    block4: {
                        Object g2;
                        block2: {
                            Geometry geometry2;
                            Object g3;
                            objectArray = x0$8;
                            Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g3 = ((SeqLike)option.get()).apply(0)) instanceof Geometry)) break block2;
                            geometry = geometry2 = (Geometry)g3;
                            break block3;
                        }
                        Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g2 = ((SeqLike)option.get()).apply(0)) instanceof String)) break block4;
                        String string = (String)g2;
                        geometry = WKTUtils$.MODULE$.read(string);
                        break block3;
                    }
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g = ((SeqLike)option.get()).apply(0)) instanceof byte[])) break block5;
                    byte[] byArray = (byte[])g;
                    geometry = WKBUtils$.MODULE$.read(byArray);
                }
                return geometry;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid geometry conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)objectArray).mkString(",")})));
        }
    });
    private final TransformerFunction.NamedTransformerFunction projectFromParserFn = new TransformerFunction.NamedTransformerFunction(this){
        private final Map<String, MathTransform> cache;

        private Map<String, MathTransform> cache() {
            return this.cache;
        }

        public Object eval(Object[] args, EvaluationContext ctx) {
            String epsg = (String)args[0];
            Geometry geom = (Geometry)args[1];
            boolean lenient = args.length > 2 ? Boolean.parseBoolean(args[2].toString()) : true;
            MathTransform transform2 = (MathTransform)this.cache().getOrElseUpdate((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{epsg, BoxesRunTime.boxToBoolean((boolean)lenient)})), (Function0)new Serializable(this, epsg, lenient){
                public static final long serialVersionUID = 0L;
                private final String epsg$1;
                private final boolean lenient$1;

                public final MathTransform apply() {
                    return CRS.findMathTransform((CoordinateReferenceSystem)CRS.decode((String)this.epsg$1), (CoordinateReferenceSystem)package$.MODULE$.CRS_EPSG_4326(), (boolean)this.lenient$1);
                }
                {
                    this.epsg$1 = epsg$1;
                    this.lenient$1 = lenient$1;
                }
            });
            return JTS.transform((Geometry)geom, (MathTransform)transform2);
        }
        {
            this.cache = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap<K, V>()).asScala();
        }
    };

    @Override
    public Seq<TransformerFunction> functions() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransformerFunction[]{this.pointParserFn(), this.multiPointParserFn(), this.lineStringParserFn(), this.multiLineStringParserFn(), this.polygonParserFn(), this.multiPolygonParserFn(), this.geometryCollectionParserFn(), this.geometryParserFn(), this.projectFromParserFn()}));
    }

    public GeometryFactory org$locationtech$geomesa$convert2$transforms$GeometryFunctionFactory$$gf() {
        return this.org$locationtech$geomesa$convert2$transforms$GeometryFunctionFactory$$gf;
    }

    private TransformerFunction pointParserFn() {
        return this.pointParserFn;
    }

    private TransformerFunction multiPointParserFn() {
        return this.multiPointParserFn;
    }

    private TransformerFunction lineStringParserFn() {
        return this.lineStringParserFn;
    }

    private TransformerFunction multiLineStringParserFn() {
        return this.multiLineStringParserFn;
    }

    private TransformerFunction polygonParserFn() {
        return this.polygonParserFn;
    }

    private TransformerFunction multiPolygonParserFn() {
        return this.multiPolygonParserFn;
    }

    private TransformerFunction geometryCollectionParserFn() {
        return this.geometryCollectionParserFn;
    }

    private TransformerFunction geometryParserFn() {
        return this.geometryParserFn;
    }

    private TransformerFunction.NamedTransformerFunction projectFromParserFn() {
        return this.projectFromParserFn;
    }
}

