/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert2.transforms;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.Locale;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction$;
import org.locationtech.geomesa.convert2.transforms.TransformerFunctionFactory;
import org.locationtech.geomesa.utils.text.DateParsing$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001B\u0001\u0003\u00015\u00111\u0003R1uK\u001a+hn\u0019;j_:4\u0015m\u0019;pefT!a\u0001\u0003\u0002\u0015Q\u0014\u0018M\\:g_Jl7O\u0003\u0002\u0006\r\u0005A1m\u001c8wKJ$(G\u0003\u0002\b\u0011\u00059q-Z8nKN\f'BA\u0005\u000b\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u00035Q\u0013\u0018M\\:g_JlWM\u001d$v]\u000e$\u0018n\u001c8GC\u000e$xN]=\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002CA\u000b\u0001\u0011\u0015i\u0002\u0001\"\u0011\u001f\u0003%1WO\\2uS>t7/F\u0001 !\r\u0001\u0003f\u000b\b\u0003C\u0019r!AI\u0013\u000e\u0003\rR!\u0001\n\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012BA\u0014\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u000b\u0016\u0003\u0007M+\u0017O\u0003\u0002(!A\u0011Q\u0003L\u0005\u0003[\t\u00111\u0003\u0016:b]N4wN]7fe\u001a+hn\u0019;j_:Dqa\f\u0001C\u0002\u0013%\u0001'A\u0002o_^,\u0012a\u000b\u0005\u0007e\u0001\u0001\u000b\u0011B\u0016\u0002\t9|w\u000f\t\u0005\bi\u0001\u0011\r\u0011\"\u00031\u00031i\u0017\u000e\u001c7jgR{G)\u0019;f\u0011\u00191\u0004\u0001)A\u0005W\u0005iQ.\u001b7mSN$v\u000eR1uK\u0002Bq\u0001\u000f\u0001C\u0002\u0013%\u0001'\u0001\u0006tK\u000e\u001cHk\u001c#bi\u0016DaA\u000f\u0001!\u0002\u0013Y\u0013aC:fGN$v\u000eR1uK\u0002Bq\u0001\u0010\u0001C\u0002\u0013%Q(\u0001\u0005eCR,G/[7f+\u0005q\u0004CA R\u001d\t\u0001%J\u0004\u0002B\u0013:\u0011!\t\u0013\b\u0003\u0007\u001es!\u0001\u0012$\u000f\u0005\t*\u0015\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t\u001d)1J\u0001E\u0001\u0019\u0006\u0019B)\u0019;f\rVt7\r^5p]\u001a\u000b7\r^8ssB\u0011Q#\u0014\u0004\u0006\u0003\tA\tAT\n\u0003\u001b:AQ!G'\u0005\u0002A#\u0012\u0001\u0014\u0004\u0006%6\u000b\ta\u0015\u0002\u0013'R\fg\u000eZ1sI\u0012\u000bG/\u001a)beN,'o\u0005\u0002R)B\u0011Q\u000b\u0017\b\u0003\u0001ZK!a\u0016\u0002\u0002'Q\u0013\u0018M\\:g_JlWM\u001d$v]\u000e$\u0018n\u001c8\n\u0005eS&\u0001\u0007(b[\u0016$GK]1og\u001a|'/\\3s\rVt7\r^5p]*\u0011qK\u0001\u0005\n9F\u0013\t\u0011)A\u0005;\u0016\fQA\\1nKN\u00042\u0001\t\u0015_!\ty&M\u0004\u0002\u0010A&\u0011\u0011\rE\u0001\u0007!J,G-\u001a4\n\u0005\r$'AB*ue&twM\u0003\u0002b!%\u0011A\f\u0017\u0005\u00063E#\ta\u001a\u000b\u0003Q*\u0004\"![)\u000e\u00035CQ\u0001\u00184A\u0002uCq\u0001\\)C\u0002\u001b\u0005Q.\u0001\u0004g_Jl\u0017\r^\u000b\u0002]B\u0011q.^\u0007\u0002a*\u0011A.\u001d\u0006\u0003eN\fA\u0001^5nK*\tA/\u0001\u0003kCZ\f\u0017B\u0001<q\u0005E!\u0015\r^3US6,gi\u001c:nCR$XM\u001d\u0005\u0006qF#\t%_\u0001\u0005KZ\fG\u000eF\u0002{\u0003\u001b!\"a\u001f@\u0011\u0005=a\u0018BA?\u0011\u0005\r\te.\u001f\u0005\u0007\u007f^\u0004\u001d!!\u0001\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9AB\u0001\bG>tg/\u001a:u\u0013\u0011\tY!!\u0002\u0003#\u00153\u0018\r\\;bi&|gnQ8oi\u0016DH\u000fC\u0004\u0002\u0010]\u0004\r!!\u0005\u0002\t\u0005\u0014xm\u001d\t\u0005\u001f\u0005M10C\u0002\u0002\u0016A\u0011Q!\u0011:sCf4a!!\u0007N\u0001\u0005m!AF\"vgR|WNR8s[\u0006$H)\u0019;f!\u0006\u00148/\u001a:\u0014\u0007\u0005]A\u000bC\u0004\u001a\u0003/!\t!a\b\u0015\u0005\u0005\u0005\u0002cA5\u0002\u0018!QA.a\u0006A\u0002\u0003\u0007I\u0011B7\t\u0019\u0005\u001d\u0012q\u0003a\u0001\u0002\u0004%I!!\u000b\u0002\u0015\u0019|'/\\1u?\u0012*\u0017\u000f\u0006\u0003\u0002,\u0005E\u0002cA\b\u0002.%\u0019\u0011q\u0006\t\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003g\t)#!AA\u00029\f1\u0001\u001f\u00132\u0011!\t9$a\u0006!B\u0013q\u0017a\u00024pe6\fG\u000f\t\u0005\t\u0003w\t9\u0002\"\u0011\u0002>\u0005Yq-\u001a;J]N$\u0018M\\2f+\t\t\t\u0003C\u0004y\u0003/!\t%!\u0011\u0015\t\u0005\r\u0013q\t\u000b\u0004w\u0006\u0015\u0003bB@\u0002@\u0001\u000f\u0011\u0011\u0001\u0005\t\u0003\u001f\ty\u00041\u0001\u0002\u0012\u00191\u00111J'\u0001\u0003\u001b\u0012A\u0002R1uKR{7\u000b\u001e:j]\u001e\u001c2!!\u0013U\u0011\u001dI\u0012\u0011\nC\u0001\u0003#\"\"!a\u0015\u0011\u0007%\fI\u0005\u0003\u0006m\u0003\u0013\u0002\r\u00111A\u0005\n5DA\"a\n\u0002J\u0001\u0007\t\u0019!C\u0005\u00033\"B!a\u000b\u0002\\!I\u00111GA,\u0003\u0003\u0005\rA\u001c\u0005\t\u0003o\tI\u0005)Q\u0005]\"A\u00111HA%\t\u0003\n\t'\u0006\u0002\u0002T!9\u00010!\u0013\u0005B\u0005\u0015D\u0003BA4\u0003W\"2a_A5\u0011\u001dy\u00181\ra\u0002\u0003\u0003A\u0001\"a\u0004\u0002d\u0001\u0007\u0011\u0011\u0003\u0005\b\u0003_\u0002\u0001\u0015!\u0003?\u0003%!\u0017\r^3uS6,\u0007\u0005\u0003\u0005\u0002t\u0001\u0011\r\u0011\"\u0003>\u00031\u0011\u0017m]5d\u0013N|G)\u0019;f\u0011\u001d\t9\b\u0001Q\u0001\ny\nQBY1tS\u000eL5o\u001c#bi\u0016\u0004\u0003\u0002CA>\u0001\t\u0007I\u0011B\u001f\u0002\u0019%\u001cx\u000eT8dC2$\u0015\r^3\t\u000f\u0005}\u0004\u0001)A\u0005}\u0005i\u0011n]8M_\u000e\fG\u000eR1uK\u0002B\u0001\"a!\u0001\u0005\u0004%I!P\u0001\u0011SN|Gj\\2bY\u0012\u000bG/\u001a+j[\u0016Dq!a\"\u0001A\u0003%a(A\tjg>dunY1m\t\u0006$X\rV5nK\u0002B\u0001\"a#\u0001\u0005\u0004%I!P\u0001\u0012SN|wJ\u001a4tKR$\u0015\r^3US6,\u0007bBAH\u0001\u0001\u0006IAP\u0001\u0013SN|wJ\u001a4tKR$\u0015\r^3US6,\u0007\u0005\u0003\u0005\u0002\u0014\u0002\u0011\r\u0011\"\u0003>\u0003A\u0011\u0017m]5d\u0013N|G)\u0019;f)&lW\rC\u0004\u0002\u0018\u0002\u0001\u000b\u0011\u0002 \u0002#\t\f7/[2Jg>$\u0015\r^3US6,\u0007\u0005\u0003\u0005\u0002\u001c\u0002\u0011\r\u0011\"\u0003>\u0003U\u0011\u0017m]5d\t\u0006$X\rV5nK:{W*\u001b7mSNDq!a(\u0001A\u0003%a(\u0001\fcCNL7\rR1uKRKW.\u001a(p\u001b&dG.[:!\u0011!\t\u0019\u000b\u0001b\u0001\n\u0013i\u0014A\u00073bi\u0016Du.\u001e:NS:,H/Z*fG>tG-T5mY&\u001c\bbBAT\u0001\u0001\u0006IAP\u0001\u001cI\u0006$X\rS8ve6Kg.\u001e;f'\u0016\u001cwN\u001c3NS2d\u0017n\u001d\u0011\t\u0013\u0005-\u0006A1A\u0005\n\u00055\u0016AF2vgR|WNR8s[\u0006$H)\u0019;f!\u0006\u00148/\u001a:\u0016\u0005\u0005=\u0006cA \u0002\u0018!A\u00111\u0017\u0001!\u0002\u0013\ty+A\fdkN$x.\u001c$pe6\fG\u000fR1uKB\u000b'o]3sA!I\u0011q\u0017\u0001C\u0002\u0013%\u0011\u0011X\u0001\rI\u0006$X\rV8TiJLgnZ\u000b\u0003\u0003w\u00032aPA%\u0011!\ty\f\u0001Q\u0001\n\u0005m\u0016!\u00043bi\u0016$vn\u0015;sS:<\u0007\u0005")
public class DateFunctionFactory
implements TransformerFunctionFactory {
    private final TransformerFunction now = TransformerFunction$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"now"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Date apply(Object[] x$1) {
            return Date.from(ZonedDateTime.now(ZoneOffset.UTC).toInstant());
        }
    });
    private final TransformerFunction millisToDate = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"millisToDate"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Date apply(Object[] args) {
            return new Date(BoxesRunTime.unboxToLong((Object)args[0]));
        }
    });
    private final TransformerFunction secsToDate = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"secsToDate"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Date apply(Object[] args) {
            return new Date(BoxesRunTime.unboxToLong((Object)args[0]) * 1000L);
        }
    });
    private final StandardDateParser datetime = new StandardDateParser(this){
        private final DateTimeFormatter format;

        public DateTimeFormatter format() {
            return this.format;
        }
        {
            this.format = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).parseLenient().appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalStart().appendOffsetId().toFormatter(Locale.US).withZone(ZoneOffset.UTC);
        }
    };
    private final StandardDateParser basicIsoDate = new StandardDateParser(this){
        private final DateTimeFormatter format;

        public DateTimeFormatter format() {
            return this.format;
        }
        {
            this.format = DateTimeFormatter.BASIC_ISO_DATE.withZone(ZoneOffset.UTC);
        }
    };
    private final StandardDateParser isoLocalDate = new StandardDateParser(this){
        private final DateTimeFormatter format;

        public DateTimeFormatter format() {
            return this.format;
        }
        {
            this.format = DateTimeFormatter.ISO_LOCAL_DATE.withZone(ZoneOffset.UTC);
        }
    };
    private final StandardDateParser isoLocalDateTime = new StandardDateParser(this){
        private final DateTimeFormatter format;

        public DateTimeFormatter format() {
            return this.format;
        }
        {
            this.format = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneOffset.UTC);
        }
    };
    private final StandardDateParser isoOffsetDateTime = new StandardDateParser(this){
        private final DateTimeFormatter format;

        public DateTimeFormatter format() {
            return this.format;
        }
        {
            this.format = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneOffset.UTC);
        }
    };
    private final StandardDateParser basicIsoDateTime = new StandardDateParser(this){
        private final DateTimeFormatter format;

        public DateTimeFormatter format() {
            return this.format;
        }
        {
            this.format = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalStart().appendOffsetId().toFormatter(Locale.US).withZone(ZoneOffset.UTC);
        }
    };
    private final StandardDateParser basicDateTimeNoMillis = new StandardDateParser(this){
        private final DateTimeFormatter format;

        public DateTimeFormatter format() {
            return this.format;
        }
        {
            this.format = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendOffsetId().toFormatter(Locale.US).withZone(ZoneOffset.UTC);
        }
    };
    private final StandardDateParser dateHourMinuteSecondMillis = new StandardDateParser(this){
        private final DateTimeFormatter format;

        public DateTimeFormatter format() {
            return this.format;
        }
        {
            this.format = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).parseLenient().appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).toFormatter(Locale.US).withZone(ZoneOffset.UTC);
        }
    };
    private final CustomFormatDateParser customFormatDateParser = new CustomFormatDateParser();
    private final DateToString dateToString = new DateToString();

    @Override
    public Seq<TransformerFunction> functions() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransformerFunction[]{this.now(), this.customFormatDateParser(), this.datetime(), this.basicDateTimeNoMillis(), this.basicIsoDate(), this.basicIsoDateTime(), this.isoLocalDate(), this.isoLocalDateTime(), this.isoOffsetDateTime(), this.dateHourMinuteSecondMillis(), this.millisToDate(), this.secsToDate(), this.dateToString()}));
    }

    private TransformerFunction now() {
        return this.now;
    }

    private TransformerFunction millisToDate() {
        return this.millisToDate;
    }

    private TransformerFunction secsToDate() {
        return this.secsToDate;
    }

    private StandardDateParser datetime() {
        return this.datetime;
    }

    private StandardDateParser basicIsoDate() {
        return this.basicIsoDate;
    }

    private StandardDateParser isoLocalDate() {
        return this.isoLocalDate;
    }

    private StandardDateParser isoLocalDateTime() {
        return this.isoLocalDateTime;
    }

    private StandardDateParser isoOffsetDateTime() {
        return this.isoOffsetDateTime;
    }

    private StandardDateParser basicIsoDateTime() {
        return this.basicIsoDateTime;
    }

    private StandardDateParser basicDateTimeNoMillis() {
        return this.basicDateTimeNoMillis;
    }

    private StandardDateParser dateHourMinuteSecondMillis() {
        return this.dateHourMinuteSecondMillis;
    }

    private CustomFormatDateParser customFormatDateParser() {
        return this.customFormatDateParser;
    }

    private DateToString dateToString() {
        return this.dateToString;
    }

    public static class DateToString
    extends TransformerFunction.NamedTransformerFunction {
        private DateTimeFormatter format;

        private DateTimeFormatter format() {
            return this.format;
        }

        private void format_$eq(DateTimeFormatter x$1) {
            this.format = x$1;
        }

        @Override
        public DateToString getInstance() {
            return new DateToString();
        }

        @Override
        public Object eval(Object[] args, EvaluationContext ctx) {
            if (this.format() == null) {
                this.format_$eq(DateTimeFormatter.ofPattern((String)args[0]).withZone(ZoneOffset.UTC));
            }
            return DateParsing$.MODULE$.formatDate((Date)args[1], this.format());
        }

        public DateToString() {
            super((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dateToString"}))), true);
        }
    }

    public static abstract class StandardDateParser
    extends TransformerFunction.NamedTransformerFunction {
        public abstract DateTimeFormatter format();

        @Override
        public Object eval(Object[] args, EvaluationContext ctx) {
            return DateParsing$.MODULE$.parseDate(args[0].toString(), this.format());
        }

        public StandardDateParser(Seq<String> names2) {
            super(names2, true);
        }
    }

    public static class CustomFormatDateParser
    extends TransformerFunction.NamedTransformerFunction {
        private DateTimeFormatter format;

        private DateTimeFormatter format() {
            return this.format;
        }

        private void format_$eq(DateTimeFormatter x$1) {
            this.format = x$1;
        }

        @Override
        public CustomFormatDateParser getInstance() {
            return new CustomFormatDateParser();
        }

        @Override
        public Object eval(Object[] args, EvaluationContext ctx) {
            if (this.format() == null) {
                this.format_$eq(DateTimeFormatter.ofPattern((String)args[0]).withZone(ZoneOffset.UTC));
            }
            return DateParsing$.MODULE$.parseDate(args[1].toString(), this.format());
        }

        public CustomFormatDateParser() {
            super((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"date"}))), true);
        }
    }
}

