/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert2;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.Collections;
import org.locationtech.geomesa.convert2.validators.HasDtgValidatorFactory$;
import org.locationtech.geomesa.convert2.validators.HasGeoValidatorFactory$;
import org.locationtech.geomesa.features.serialization.ObjectType$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class AbstractConverterFactory$
implements LazyLogging {
    public static final AbstractConverterFactory$ MODULE$;
    private final GeoMesaSystemProperties.SystemProperty InferSampleSize;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new AbstractConverterFactory$();
    }

    private Logger logger$lzycompute() {
        AbstractConverterFactory$ abstractConverterFactory$ = this;
        synchronized (abstractConverterFactory$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public GeoMesaSystemProperties.SystemProperty InferSampleSize() {
        return this.InferSampleSize;
    }

    public int inferSampleSize() {
        return BoxesRunTime.unboxToInt((Object)this.InferSampleSize().toInt().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("Could not determine sample size from system property");
            }
        }));
    }

    public boolean validateInferredType(SimpleFeatureType sft, Seq<Enumeration.Value> types, boolean raiseError) {
        boolean bl;
        Buffer existing;
        Buffer buffer = existing = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Enumeration.Value> apply(AttributeDescriptor descriptor) {
                return ObjectType$.MODULE$.selectType(descriptor);
            }
        }, Buffer$.MODULE$.canBuildFrom())).collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Seq<Enumeration.Value>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Some some = Seq$.MODULE$.unapplySeq(A1);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Enumeration.Value value = (Enumeration.Value)((SeqLike)some.get()).apply(0);
                    Enumeration.Value subtype = (Enumeration.Value)((SeqLike)some.get()).apply(1);
                    Enumeration.Value value2 = ObjectType$.MODULE$.GEOMETRY();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        object = subtype;
                        return (B1)object;
                    }
                }
                object = A1.head();
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Seq<Enumeration.Value> x1) {
                Seq<Enumeration.Value> seq = x1;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (some.isEmpty()) return true;
                if (some.get() == null) return true;
                if (((SeqLike)some.get()).lengthCompare(2) != 0) return true;
                Enumeration.Value value = (Enumeration.Value)((SeqLike)some.get()).apply(0);
                Enumeration.Value value2 = ObjectType$.MODULE$.GEOMETRY();
                Enumeration.Value value3 = value;
                if (value2 != null) {
                    if (!value2.equals(value3)) return true;
                    return true;
                }
                if (value3 == null) return true;
                return true;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Seq<Enumeration.Value> seq = types;
        if (!(buffer != null ? !buffer.equals(seq) : seq != null)) {
            bl = true;
        } else {
            if (raiseError) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Simple feature type does not match inferred schema: "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n\\tExisting types: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{existing.mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n\\tInferred types: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{types.mkString(", ")}))).toString());
            }
            bl = false;
        }
        return bl;
    }

    public boolean validateInferredType$default$3() {
        return true;
    }

    public Config standardDefaults(Config conf, Function0<Logger> logger) {
        ArrayBuffer updates = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        if (conf.hasPath("options.validation-mode")) {
            BoxedUnit boxedUnit;
            if (((Logger)logger.apply()).underlying().isWarnEnabled()) {
                ((Logger)logger.apply()).underlying().warn("Using deprecated option 'validation-mode'. Prefer 'error-mode'");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            updates.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(conf){
                public static final long serialVersionUID = 0L;
                private final Config conf$2;

                public final Config apply(Config c) {
                    return c.withValue("options.error-mode", this.conf$2.getValue("options.validation-mode"));
                }
                {
                    this.conf$2 = conf$2;
                }
            }}));
        }
        if (conf.hasPath("options.validating")) {
            BoxedUnit boxedUnit;
            if (((Logger)logger.apply()).underlying().isWarnEnabled()) {
                ((Logger)logger.apply()).underlying().warn("Using deprecated validation key 'validating'");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            ConfigList validators = conf.getBoolean("options.validating") ? ConfigValueFactory.fromIterable((Iterable)((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{HasGeoValidatorFactory$.MODULE$.Name(), HasDtgValidatorFactory$.MODULE$.Name()}))).asJava())) : ConfigValueFactory.fromIterable(Collections.emptyList());
            updates.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(validators){
                public static final long serialVersionUID = 0L;
                private final ConfigList validators$1;

                public final Config apply(Config c) {
                    return c.withValue("options.validators", (ConfigValue)this.validators$1);
                }
                {
                    this.validators$1 = validators$1;
                }
            }}));
        }
        return ((Config)updates.foldLeft((Object)conf, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Config apply(Config c, Function1<Config, Config> mod) {
                return (Config)mod.apply((Object)c);
            }
        })).withFallback((ConfigMergeable)ConfigFactory.load((String)"base-converter-defaults"));
    }

    private AbstractConverterFactory$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.InferSampleSize = new GeoMesaSystemProperties.SystemProperty("geomesa.convert.infer.sample", "100");
    }
}

