/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.locationtech.geomesa.convert.ConfArgs;
import org.locationtech.geomesa.convert.ConverterConfigLoader$;
import org.locationtech.geomesa.convert.SimpleConverterConfigParser$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.conf.ArgResolver;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.package;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class ConverterConfigResolver$
implements ArgResolver<Config, ConfArgs> {
    public static final ConverterConfigResolver$ MODULE$;
    private final String fileNameReg;
    private final Seq<String> confStrings;
    private final List<Function1<ConfArgs, Either<Tuple3<String, Throwable, Enumeration.Value>, Config>>> parseMethodList;
    private final ConfigParseOptions parseOpts;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ConverterConfigResolver$();
    }

    public ConfigParseOptions parseOpts() {
        return this.parseOpts;
    }

    public void org$locationtech$geomesa$utils$conf$ArgResolver$_setter_$parseOpts_$eq(ConfigParseOptions x$1) {
        this.parseOpts = x$1;
    }

    public Either getArg(Object args) {
        return ArgResolver.class.getArg((ArgResolver)this, (Object)args);
    }

    private Logger logger$lzycompute() {
        ConverterConfigResolver$ converterConfigResolver$ = this;
        synchronized (converterConfigResolver$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private String fileNameReg() {
        return this.fileNameReg;
    }

    private Seq<String> confStrings() {
        return this.confStrings;
    }

    public Enumeration.Value argType(ConfArgs args) {
        return this.confStrings().exists((Function1)new Serializable(args){
            public static final long serialVersionUID = 0L;
            private final ConfArgs args$1;

            public final boolean apply(CharSequence x$1) {
                return this.args$1.config().contains(x$1);
            }
            {
                this.args$1 = args$1;
            }
        }) ? ArgResolver.ArgTypes$.MODULE$.CONFSTR() : (args.config().matches(this.fileNameReg()) || args.config().contains("/") ? ArgResolver.ArgTypes$.MODULE$.PATH() : ArgResolver.ArgTypes$.MODULE$.NAME());
    }

    public List<Function1<ConfArgs, Either<Tuple3<String, Throwable, Enumeration.Value>, Config>>> parseMethodList() {
        return this.parseMethodList;
    }

    public Either<Tuple3<String, Throwable, Enumeration.Value>, Config> getLoadedConf(ConfArgs args) {
        Option option;
        block4: {
            Right right;
            block3: {
                block2: {
                    option = ConverterConfigLoader$.MODULE$.confs().find((Function1)new Serializable(args){
                        public static final long serialVersionUID = 0L;
                        private final ConfArgs args$2;

                        public final boolean apply(Tuple2<String, Config> x$1) {
                            Object object = x$1._1();
                            String string = this.args$2.config();
                            return !(object != null ? !object.equals(string) : string != null);
                        }
                        {
                            this.args$2 = args$2;
                        }
                    }).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Config apply(Tuple2<String, Config> x$2) {
                            return (Config)x$2._2();
                        }
                    });
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Config conf = (Config)some.x();
                    right = package$.MODULE$.Right().apply((Object)conf);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                right = package$.MODULE$.Left().apply((Object)new Tuple3((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to get loaded conf ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args.config()})), (Object)new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " was not found in the loaded confs"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args.config()}))), (Object)ArgResolver.ArgTypes$.MODULE$.NAME()));
            }
            return right;
        }
        throw new MatchError((Object)option);
    }

    public Either<Tuple3<String, Throwable, Enumeration.Value>, Config> parseString(ConfArgs args) {
        Right right;
        try {
            BoxedUnit boxedUnit;
            Map<String, Config> confs2 = SimpleConverterConfigParser$.MODULE$.parseConf(ConfigFactory.parseString((String)args.config(), (ConfigParseOptions)this.parseOpts()).resolve());
            if (confs2.size() > 1) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Found more than one SFT conf in arg '{}'", new Object[]{args.config()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            right = package$.MODULE$.Right().apply(confs2.values().head());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            Left left = package$.MODULE$.Left().apply((Object)new Tuple3((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to parse config from string ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args.config()})), (Object)e, (Object)ArgResolver.ArgTypes$.MODULE$.CONFSTR()));
            right = left;
        }
        return right;
    }

    public Either<Tuple3<String, Throwable, Enumeration.Value>, Config> parseFile(ConfArgs args) {
        Either either;
        try {
            FileSystemDelegate.FileHandle handle = (FileSystemDelegate.FileHandle)PathUtils$.MODULE$.interpretPath(args.config()).headOption().getOrElse((Function0)new Serializable(args){
                public static final long serialVersionUID = 0L;
                private final ConfArgs args$3;

                public final Nothing$ apply() {
                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not read file at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.args$3.config()})));
                }
                {
                    this.args$3 = args$3;
                }
            });
            either = (Either)package.WithClose$.MODULE$.apply((Object)handle.open(), (Function1)new Serializable(args){
                public static final long serialVersionUID = 0L;
                private final ConfArgs args$3;

                public final Either<Tuple3<String, Throwable, Enumeration.Value>, Config> apply(CloseableIterator<Tuple2<Option<String>, InputStream>> is) {
                    if (is.hasNext()) {
                        BoxedUnit boxedUnit;
                        InputStreamReader reader = new InputStreamReader((InputStream)((Tuple2)is.next())._2(), StandardCharsets.UTF_8);
                        Map<String, Config> confs2 = SimpleConverterConfigParser$.MODULE$.parseConf(ConfigFactory.parseReader((Reader)reader, (ConfigParseOptions)ConverterConfigResolver$.MODULE$.parseOpts()).resolve());
                        if (confs2.size() > 1) {
                            if (ConverterConfigResolver$.MODULE$.logger().underlying().isWarnEnabled()) {
                                ConverterConfigResolver$.MODULE$.logger().underlying().warn("Found more than one SFT conf in arg '{}'", new Object[]{this.args$3.config()});
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return package$.MODULE$.Right().apply(confs2.values().head());
                    }
                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not read file at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.args$3.config()})));
                }
                {
                    this.args$3 = args$3;
                }
            }, IsCloseable$.MODULE$.closeableIsCloseable());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            Left left = package$.MODULE$.Left().apply((Object)new Tuple3((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to parse config from file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args.config()})), (Object)e, (Object)ArgResolver.ArgTypes$.MODULE$.PATH()));
            either = left;
        }
        return either;
    }

    private ConverterConfigResolver$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        ArgResolver.class.$init$((ArgResolver)this);
        this.fileNameReg = "([^.]*)\\.([^.]*)";
        this.confStrings = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"geomesa{", "geomesa {", "geomesa.converters"}));
        this.parseMethodList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Either<Tuple3<String, Throwable, Enumeration.Value>, Config> apply(ConfArgs args) {
                return ConverterConfigResolver$.MODULE$.getLoadedConf(args);
            }
        }, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Either<Tuple3<String, Throwable, Enumeration.Value>, Config> apply(ConfArgs args) {
                return ConverterConfigResolver$.MODULE$.parseFile(args);
            }
        }, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Either<Tuple3<String, Throwable, Enumeration.Value>, Config> apply(ConfArgs args) {
                return ConverterConfigResolver$.MODULE$.parseString(args);
            }
        }}));
    }
}

