/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert2.transforms;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction$;
import org.locationtech.geomesa.convert2.transforms.TransformerFunctionFactory;
import org.locationtech.geomesa.curve.TimePeriod$;
import org.locationtech.geomesa.utils.uuid.Z3UuidGenerator$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u0001\u0003\u00015\u0011\u0011#\u00133Gk:\u001cG/[8o\r\u0006\u001cGo\u001c:z\u0015\t\u0019A!\u0001\u0006ue\u0006t7OZ8s[NT!!\u0002\u0004\u0002\u0011\r|gN^3siJR!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0019!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u001b)J\fgn\u001d4pe6,'OR;oGRLwN\u001c$bGR|'/\u001f\t\u00033\u0001j\u0011A\u0007\u0006\u00037q\tAb]2bY\u0006dwnZ4j]\u001eT!!\b\u0010\u0002\u0011QL\b/Z:bM\u0016T\u0011aH\u0001\u0004G>l\u0017BA\u0011\u001b\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u000b\r\u0002A\u0011\u0001\u0013\u0002\rqJg.\u001b;?)\u0005)\u0003CA\u000b\u0001\u0011\u00159\u0003\u0001\"\u0011)\u0003%1WO\\2uS>t7/F\u0001*!\rQ#'\u000e\b\u0003WAr!\u0001L\u0018\u000e\u00035R!A\f\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012BA\u0019\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L!a\r\u001b\u0003\u0007M+\u0017O\u0003\u00022!A\u0011QCN\u0005\u0003o\t\u00111\u0003\u0016:b]N4wN]7fe\u001a+hn\u0019;j_:Dq!\u000f\u0001C\u0002\u0013%!(\u0001\nnkJlWO]\u001a`cIB\u0004*Y:iS:<W#A\u001e\u0011\u0005q\u001aU\"A\u001f\u000b\u0005yz\u0014\u0001\u00025bg\"T!\u0001Q!\u0002\r\r|W.\\8o\u0015\t\u0011e$\u0001\u0004h_><G.Z\u0005\u0003\tv\u0012A\u0002S1tQ\u001a+hn\u0019;j_:DaA\u0012\u0001!\u0002\u0013Y\u0014aE7ve6,(oM02eaB\u0015m\u001d5j]\u001e\u0004\u0003b\u0002%\u0001\u0005\u0004%I!S\u0001\rgR\u0014\u0018N\\43\u0005f$Xm]\u000b\u0002k!11\n\u0001Q\u0001\nU\nQb\u001d;sS:<'GQ=uKN\u0004\u0003bB'\u0001\u0005\u0004%I!S\u0001\u0005kVLG\r\u0003\u0004P\u0001\u0001\u0006I!N\u0001\u0006kVLG\r\t\u0005\b#\u0002\u0011\r\u0011\"\u0003J\u0003\u0019)X/\u001b3[g!11\u000b\u0001Q\u0001\nU\nq!^;jIj\u001b\u0004\u0005C\u0004V\u0001\t\u0007I\u0011B%\u0002\u001dU,\u0018\u000e\u001a.4\u0007\u0016tGO]8jI\"1q\u000b\u0001Q\u0001\nU\nq\"^;jIj\u001b4)\u001a8ue>LG\r\t\u0005\b3\u0002\u0011\r\u0011\"\u0003J\u0003\u0019\u0011\u0017m]37i!\"\u0001l\u00170a!\tyA,\u0003\u0002^!\tQA-\u001a9sK\u000e\fG/\u001a3\"\u0003}\u000b!DU3qY\u0006\u001cW\r\u001a\u0011xSRD\u0007EY1tKZ\"TI\\2pI\u0016\fTaI1iY&\u0004\"AY3\u000f\u0005=\u0019\u0017B\u00013\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011am\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011\u0004\u0012BA5k\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e)\u00111\u000eE\u0001\u000bI\u0016\u0004(/Z2bi\u0016$\u0017'B\u0012n]>\\gBA\bo\u0013\tY\u0007#\r\u0003#\u001fA\u0001(!B:dC2\f\u0007B\u0002:\u0001A\u0003%Q'A\u0004cCN,g\u0007\u000e\u0011\t\u000fQ\u0004!\u0019!C\u0005\u0013\u0006\u0019Q\u000eZ\u001b\t\rY\u0004\u0001\u0015!\u00036\u0003\u0011iG-\u000e\u0011\t\u000fa\u0004!\u0019!C\u0005\u0013\u0006QQ.\u001e:nkJ\u001ctl\r\u001a\t\ri\u0004\u0001\u0015!\u00036\u0003-iWO]7veNz6G\r\u0011\t\u000fq\u0004!\u0019!C\u0005\u0013\u0006QQ.\u001e:nkJ\u001ctL\u000e\u001b\t\ry\u0004\u0001\u0015!\u00036\u0003-iWO]7veNzf\u0007\u000e\u0011\t\u0011\u0005\u0005\u0001A1A\u0005\n%\u000b1\"\\;s[V\u00148gX\u00193q!9\u0011Q\u0001\u0001!\u0002\u0013)\u0014\u0001D7ve6,(oM02ea\u0002\u0003")
public class IdFunctionFactory
implements TransformerFunctionFactory,
LazyLogging {
    private final HashFunction org$locationtech$geomesa$convert2$transforms$IdFunctionFactory$$murmur3_128Hashing;
    private final TransformerFunction string2Bytes;
    private final TransformerFunction uuid;
    private final TransformerFunction uuidZ3;
    private final TransformerFunction uuidZ3Centroid;
    private final TransformerFunction base64;
    private final TransformerFunction md5;
    private final TransformerFunction murmur3_32;
    private final TransformerFunction murmur3_64;
    private final TransformerFunction murmur3_128;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        IdFunctionFactory idFunctionFactory = this;
        synchronized (idFunctionFactory) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public Seq<TransformerFunction> functions() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransformerFunction[]{this.string2Bytes(), this.md5(), this.uuid(), this.uuidZ3(), this.uuidZ3Centroid(), this.base64(), this.murmur3_32(), this.murmur3_64(), this.murmur3_128()}));
    }

    public HashFunction org$locationtech$geomesa$convert2$transforms$IdFunctionFactory$$murmur3_128Hashing() {
        return this.org$locationtech$geomesa$convert2$transforms$IdFunctionFactory$$murmur3_128Hashing;
    }

    private TransformerFunction string2Bytes() {
        return this.string2Bytes;
    }

    private TransformerFunction uuid() {
        return this.uuid;
    }

    private TransformerFunction uuidZ3() {
        return this.uuidZ3;
    }

    private TransformerFunction uuidZ3Centroid() {
        return this.uuidZ3Centroid;
    }

    private TransformerFunction base64() {
        return this.base64;
    }

    private TransformerFunction md5() {
        return this.md5;
    }

    private TransformerFunction murmur3_32() {
        return this.murmur3_32;
    }

    private TransformerFunction murmur3_64() {
        return this.murmur3_64;
    }

    private TransformerFunction murmur3_128() {
        return this.murmur3_128;
    }

    public IdFunctionFactory() {
        LazyLogging.class.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$convert2$transforms$IdFunctionFactory$$murmur3_128Hashing = Hashing.murmur3_128();
        this.string2Bytes = TransformerFunction$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string2bytes", "stringToBytes"}), (Function1<Object[], Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Object[] args) {
                return ((String)args[0]).getBytes(StandardCharsets.UTF_8);
            }
        });
        this.uuid = TransformerFunction$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uuid"}), (Function1<Object[], Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object[] x$1) {
                return UUID.randomUUID().toString();
            }
        });
        this.uuidZ3 = TransformerFunction$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uuidZ3"}), (Function1<Object[], Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IdFunctionFactory $outer;

            public final Object apply(Object[] args) {
                String string;
                Point geom = (Point)args[0];
                Date date = (Date)args[1];
                Enumeration.Value interval = TimePeriod$.MODULE$.withName((String)args[2]);
                try {
                    string = Z3UuidGenerator$.MODULE$.createUuid(geom, date.getTime(), interval).toString();
                }
                catch (Throwable throwable) {
                    String string2;
                    BoxedUnit boxedUnit;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("Invalid z3 values for UUID: {} {} {}: {}", new Object[]{geom, date, interval, e});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    string = string2 = UUID.randomUUID().toString();
                }
                return string;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.uuidZ3Centroid = TransformerFunction$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uuidZ3Centroid"}), (Function1<Object[], Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IdFunctionFactory $outer;

            public final Object apply(Object[] args) {
                String string;
                Geometry geom = (Geometry)args[0];
                Date date = (Date)args[1];
                Enumeration.Value interval = TimePeriod$.MODULE$.withName((String)args[2]);
                try {
                    string = Z3UuidGenerator$.MODULE$.createUuid(geom, date.getTime(), interval).toString();
                }
                catch (Throwable throwable) {
                    String string2;
                    BoxedUnit boxedUnit;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("Invalid z3 values for UUID: {} {} {}: {}", new Object[]{geom, date, interval, e});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    string = string2 = UUID.randomUUID().toString();
                }
                return string;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.base64 = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"base64"}), (Function1<Object[], Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object[] args) {
                return Base64.encodeBase64URLSafeString((byte[])((byte[])args[0]));
            }
        });
        this.md5 = new TransformerFunction.NamedTransformerFunction(this){
            private final HashFunction hasher;

            private HashFunction hasher() {
                return this.hasher;
            }

            public Object apply(Object[] args) {
                return this.hasher().hashBytes((byte[])args[0]).toString();
            }
            {
                this.hasher = Hashing.md5();
            }
        };
        this.murmur3_32 = new TransformerFunction.NamedTransformerFunction(this){
            private final HashFunction hasher;

            private HashFunction hasher() {
                return this.hasher;
            }

            public Object apply(Object[] args) {
                return this.hasher().hashString((CharSequence)args[0].toString(), StandardCharsets.UTF_8);
            }
            {
                this.hasher = Hashing.murmur3_32();
            }
        };
        this.murmur3_64 = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"murmur3_128", "murmur3_64"}), (Function1<Object[], Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IdFunctionFactory $outer;

            public final Long apply(Object[] args) {
                Object object;
                block4: {
                    HashCode hashCode;
                    block3: {
                        block2: {
                            object = args[0];
                            if (!(object instanceof String)) break block2;
                            String string = (String)object;
                            hashCode = this.$outer.org$locationtech$geomesa$convert2$transforms$IdFunctionFactory$$murmur3_128Hashing().hashBytes(string.getBytes(StandardCharsets.UTF_8));
                            break block3;
                        }
                        if (!(object instanceof byte[])) break block4;
                        byte[] byArray = (byte[])object;
                        hashCode = this.$outer.org$locationtech$geomesa$convert2$transforms$IdFunctionFactory$$murmur3_128Hashing().hashBytes(byArray);
                    }
                    HashCode hash = hashCode;
                    return BoxesRunTime.boxToLong((long)hash.asLong());
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected String or byte[] but got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{object})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.murmur3_128 = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"murmurHash3"}), (Function1<Object[], Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IdFunctionFactory $outer;

            public final Object apply(Object[] args) {
                Object object;
                block4: {
                    String string;
                    block3: {
                        block2: {
                            object = args[0];
                            if (!(object instanceof String)) break block2;
                            String string2 = (String)object;
                            string = this.$outer.org$locationtech$geomesa$convert2$transforms$IdFunctionFactory$$murmur3_128Hashing().hashBytes(string2.getBytes(StandardCharsets.UTF_8)).toString();
                            break block3;
                        }
                        if (!(object instanceof byte[])) break block4;
                        byte[] byArray = (byte[])object;
                        string = this.$outer.org$locationtech$geomesa$convert2$transforms$IdFunctionFactory$$murmur3_128Hashing().hashBytes(byArray).toString();
                    }
                    return string;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected String or byte[] but got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{object})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

