/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert2.transforms;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.locationtech.geomesa.convert2.transforms.GeometryFunctionFactory$;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction$;
import org.locationtech.geomesa.convert2.transforms.TransformerFunctionFactory;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.text.WKBUtils$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.concurrent.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u00015\u0011qcR3p[\u0016$(/\u001f$v]\u000e$\u0018n\u001c8GC\u000e$xN]=\u000b\u0005\r!\u0011A\u0003;sC:\u001chm\u001c:ng*\u0011QAB\u0001\tG>tg/\u001a:ue)\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!A\u0007+sC:\u001chm\u001c:nKJ4UO\\2uS>tg)Y2u_JL\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\t)\u0002\u0001C\u0003\u001e\u0001\u0011\u0005c$A\u0005gk:\u001cG/[8ogV\tq\u0004E\u0002!Q-r!!\t\u0014\u000f\u0005\t*S\"A\u0012\u000b\u0005\u0011b\u0011A\u0002\u001fs_>$h(C\u0001\u0012\u0013\t9\u0003#A\u0004qC\u000e\\\u0017mZ3\n\u0005%R#aA*fc*\u0011q\u0005\u0005\t\u0003+1J!!\f\u0002\u0003'Q\u0013\u0018M\\:g_JlWM\u001d$v]\u000e$\u0018n\u001c8\t\u000f=\u0002!\u0019!C\u0005a\u0005\u0011qMZ\u000b\u0002cA\u0011!gN\u0007\u0002g)\u0011A'N\u0001\u0005O\u0016|WN\u0003\u00027\u0011\u0005\u0019!\u000e^:\n\u0005a\u001a$aD$f_6,GO]=GC\u000e$xN]=\t\ri\u0002\u0001\u0015!\u00032\u0003\r9g\r\t\u0005\by\u0001\u0011\r\u0011\"\u0003>\u00035\u0001x.\u001b8u!\u0006\u00148/\u001a:G]V\t1\u0006\u0003\u0004@\u0001\u0001\u0006IaK\u0001\u000fa>Lg\u000e\u001e)beN,'O\u00128!\u0011\u001d\t\u0005A1A\u0005\nu\na\u0002]8j]Rl\u0005+\u0019:tKJ4e\u000e\u0003\u0004D\u0001\u0001\u0006IaK\u0001\u0010a>Lg\u000e^'QCJ\u001cXM\u001d$oA!9Q\t\u0001b\u0001\n\u0013i\u0014AE7vYRL\u0007k\\5oiB\u000b'o]3s\r:Daa\u0012\u0001!\u0002\u0013Y\u0013aE7vYRL\u0007k\\5oiB\u000b'o]3s\r:\u0004\u0003bB%\u0001\u0005\u0004%I!P\u0001\u0013Y&tWm\u0015;sS:<\u0007+\u0019:tKJ4e\u000e\u0003\u0004L\u0001\u0001\u0006IaK\u0001\u0014Y&tWm\u0015;sS:<\u0007+\u0019:tKJ4e\u000e\t\u0005\b\u001b\u0002\u0011\r\u0011\"\u0003>\u0003]iW\u000f\u001c;j\u0019&tWm\u0015;sS:<\u0007+\u0019:tKJ4e\u000e\u0003\u0004P\u0001\u0001\u0006IaK\u0001\u0019[VdG/\u001b'j]\u0016\u001cFO]5oOB\u000b'o]3s\r:\u0004\u0003bB)\u0001\u0005\u0004%I!P\u0001\u0010a>d\u0017pZ8o!\u0006\u00148/\u001a:G]\"11\u000b\u0001Q\u0001\n-\n\u0001\u0003]8ms\u001e|g\u000eU1sg\u0016\u0014hI\u001c\u0011\t\u000fU\u0003!\u0019!C\u0005{\u0005!R.\u001e7uSB{G._4p]B\u000b'o]3s\r:Daa\u0016\u0001!\u0002\u0013Y\u0013!F7vYRL\u0007k\u001c7zO>t\u0007+\u0019:tKJ4e\u000e\t\u0005\b3\u0002\u0011\r\u0011\"\u0003>\u0003i9Wm\\7fiJL8i\u001c7mK\u000e$\u0018n\u001c8QCJ\u001cXM\u001d$o\u0011\u0019Y\u0006\u0001)A\u0005W\u0005Yr-Z8nKR\u0014\u0018pQ8mY\u0016\u001cG/[8o!\u0006\u00148/\u001a:G]\u0002Bq!\u0018\u0001C\u0002\u0013%Q(\u0001\thK>lW\r\u001e:z!\u0006\u00148/\u001a:G]\"1q\f\u0001Q\u0001\n-\n\u0011cZ3p[\u0016$(/\u001f)beN,'O\u00128!\u0011\u001d\t\u0007A1A\u0005\nu\n1\u0003\u001d:pU\u0016\u001cGO\u0012:p[B\u000b'o]3s\r:Daa\u0019\u0001!\u0002\u0013Y\u0013\u0001\u00069s_*,7\r\u001e$s_6\u0004\u0016M]:fe\u001as\u0007eB\u0003f\u0005!\u0005a-A\fHK>lW\r\u001e:z\rVt7\r^5p]\u001a\u000b7\r^8ssB\u0011Qc\u001a\u0004\u0006\u0003\tA\t\u0001[\n\u0003O:AQ!G4\u0005\u0002)$\u0012A\u001a\u0005\u0006Y\u001e$I!\\\u0001\u0006G>|'\u000f\u001a\u000b\u0004]F\\\bC\u0001\u001ap\u0013\t\u00018G\u0001\u0006D_>\u0014H-\u001b8bi\u0016DQA]6A\u0002M\f\u0011\u0001\u001f\t\u0003ifl\u0011!\u001e\u0006\u0003m^\fA\u0001\\1oO*\t\u00010\u0001\u0003kCZ\f\u0017B\u0001>v\u0005\u0019qU/\u001c2fe\")Ap\u001ba\u0001g\u0006\t\u0011\u0010C\u0003\u007fO\u0012%q0\u0001\u0004d_>\u0014HM\u0017\u000b\b]\u0006\u0005\u00111AA\u0003\u0011\u0015\u0011X\u00101\u0001t\u0011\u0015aX\u00101\u0001t\u0011\u0019\t9! a\u0001g\u0006\t!\u0010C\u0004\u0002\f\u001d$I!!\u0004\u0002\r\r|wN\u001d3N)\u001dq\u0017qBA\t\u0003'AaA]A\u0005\u0001\u0004\u0019\bB\u0002?\u0002\n\u0001\u00071\u000fC\u0004\u0002\u0016\u0005%\u0001\u0019A:\u0002\u00035Dq!!\u0007h\t\u0013\tY\"A\u0004d_>\u0014HMW'\u0015\u00139\fi\"a\b\u0002\"\u0005\r\u0002B\u0002:\u0002\u0018\u0001\u00071\u000f\u0003\u0004}\u0003/\u0001\ra\u001d\u0005\b\u0003\u000f\t9\u00021\u0001t\u0011\u001d\t)\"a\u0006A\u0002M\u0004")
public class GeometryFunctionFactory
implements TransformerFunctionFactory {
    private final GeometryFactory org$locationtech$geomesa$convert2$transforms$GeometryFunctionFactory$$gf = JTSFactoryFinder.getGeometryFactory();
    private final TransformerFunction pointParserFn = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;
        private final /* synthetic */ GeometryFunctionFactory $outer;

        public final Object apply(Object[] x0$1) {
            Object[] objectArray;
            block9: {
                Point point;
                block3: {
                    block8: {
                        Object g;
                        block7: {
                            Object g2;
                            Option option;
                            block6: {
                                Option option2;
                                block5: {
                                    Option option3;
                                    block4: {
                                        block2: {
                                            Point point2;
                                            Object g3;
                                            objectArray = x0$1;
                                            Option option4 = Array$.MODULE$.unapplySeq((Object)objectArray);
                                            if (option4.isEmpty() || option4.get() == null || ((SeqLike)option4.get()).lengthCompare(1) != 0 || !((g3 = ((SeqLike)option4.get()).apply(0)) instanceof Point)) break block2;
                                            point = point2 = (Point)g3;
                                            break block3;
                                        }
                                        Option option5 = Array$.MODULE$.unapplySeq((Object)objectArray);
                                        if (option5.isEmpty() || option5.get() == null || ((SeqLike)option5.get()).lengthCompare(2) != 0) break block4;
                                        Object x = ((SeqLike)option5.get()).apply(0);
                                        Object y = ((SeqLike)option5.get()).apply(1);
                                        if (!(x instanceof Number)) break block4;
                                        Number number = (Number)x;
                                        if (!(y instanceof Number)) break block4;
                                        Number number2 = (Number)y;
                                        point = this.$outer.org$locationtech$geomesa$convert2$transforms$GeometryFunctionFactory$$gf().createPoint(GeometryFunctionFactory$.MODULE$.org$locationtech$geomesa$convert2$transforms$GeometryFunctionFactory$$coord(number, number2));
                                        break block3;
                                    }
                                    if ((option3 = Array$.MODULE$.unapplySeq((Object)objectArray)).isEmpty() || option3.get() == null || ((SeqLike)option3.get()).lengthCompare(3) != 0) break block5;
                                    Object x = ((SeqLike)option3.get()).apply(0);
                                    Object y = ((SeqLike)option3.get()).apply(1);
                                    Object z = ((SeqLike)option3.get()).apply(2);
                                    if (!(x instanceof Number)) break block5;
                                    Number number = (Number)x;
                                    if (!(y instanceof Number)) break block5;
                                    Number number3 = (Number)y;
                                    if (!(z instanceof Number)) break block5;
                                    Number number4 = (Number)z;
                                    point = this.$outer.org$locationtech$geomesa$convert2$transforms$GeometryFunctionFactory$$gf().createPoint(GeometryFunctionFactory$.MODULE$.org$locationtech$geomesa$convert2$transforms$GeometryFunctionFactory$$coordZ(number, number3, number4));
                                    break block3;
                                }
                                if ((option2 = Array$.MODULE$.unapplySeq((Object)objectArray)).isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(4) != 0) break block6;
                                Object x = ((SeqLike)option2.get()).apply(0);
                                Object y = ((SeqLike)option2.get()).apply(1);
                                Object z = ((SeqLike)option2.get()).apply(2);
                                Object m = ((SeqLike)option2.get()).apply(3);
                                if (!(x instanceof Number)) break block6;
                                Number number = (Number)x;
                                if (!(y instanceof Number)) break block6;
                                Number number5 = (Number)y;
                                if (!(z instanceof Number)) break block6;
                                Number number6 = (Number)z;
                                if (!(m instanceof Number)) break block6;
                                Number number7 = (Number)m;
                                point = this.$outer.org$locationtech$geomesa$convert2$transforms$GeometryFunctionFactory$$gf().createPoint(GeometryFunctionFactory$.MODULE$.org$locationtech$geomesa$convert2$transforms$GeometryFunctionFactory$$coordZM(number, number5, number6, number7));
                                break block3;
                            }
                            if ((option = Array$.MODULE$.unapplySeq((Object)objectArray)).isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g2 = ((SeqLike)option.get()).apply(0)) instanceof String)) break block7;
                            String string = (String)g2;
                            point = (Point)WKTUtils$.MODULE$.read(string);
                            break block3;
                        }
                        Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g = ((SeqLike)option.get()).apply(0)) instanceof byte[])) break block8;
                        byte[] byArray = (byte[])g;
                        point = (Point)WKBUtils$.MODULE$.read(byArray);
                        break block3;
                    }
                    if (!Predef$.MODULE$.genericArrayOps((Object)objectArray).nonEmpty() || Predef$.MODULE$.genericArrayOps((Object)objectArray).lengthCompare(4) > 0 || !Predef$.MODULE$.genericArrayOps((Object)objectArray).forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Object x$1) {
                            return x$1 == null;
                        }
                    })) break block9;
                    point = null;
                }
                return point;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid point conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)objectArray).mkString(",")})));
        }
        {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    });
    private final TransformerFunction pointMParserFn = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pointM"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;
        private final /* synthetic */ GeometryFunctionFactory $outer;

        public final Object apply(Object[] x0$2) {
            Object[] objectArray;
            block4: {
                Point point;
                block3: {
                    Option option;
                    block2: {
                        objectArray = x0$2;
                        Option option2 = Array$.MODULE$.unapplySeq((Object)objectArray);
                        if (option2.isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(3) != 0) break block2;
                        Object x = ((SeqLike)option2.get()).apply(0);
                        Object y = ((SeqLike)option2.get()).apply(1);
                        Object m = ((SeqLike)option2.get()).apply(2);
                        if (!(x instanceof Number)) break block2;
                        Number number = (Number)x;
                        if (!(y instanceof Number)) break block2;
                        Number number2 = (Number)y;
                        if (!(m instanceof Number)) break block2;
                        Number number3 = (Number)m;
                        point = this.$outer.org$locationtech$geomesa$convert2$transforms$GeometryFunctionFactory$$gf().createPoint(GeometryFunctionFactory$.MODULE$.org$locationtech$geomesa$convert2$transforms$GeometryFunctionFactory$$coordM(number, number2, number3));
                        break block3;
                    }
                    if ((option = Array$.MODULE$.unapplySeq((Object)objectArray)).isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(3) != 0) break block4;
                    Object object = ((SeqLike)option.get()).apply(0);
                    Object object2 = ((SeqLike)option.get()).apply(1);
                    Object object3 = ((SeqLike)option.get()).apply(2);
                    if (object != null || object2 != null || object3 != null) break block4;
                    point = null;
                }
                return point;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid pointM conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)objectArray).mkString(",")})));
        }
        {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    });
    private final TransformerFunction multiPointParserFn = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"multipoint"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;
        private final /* synthetic */ GeometryFunctionFactory $outer;

        public final Object apply(Object[] x0$3) {
            Object[] objectArray;
            block8: {
                MultiPoint multiPoint;
                block4: {
                    Object object;
                    Option option;
                    block7: {
                        block6: {
                            Object g;
                            block5: {
                                Object g2;
                                block3: {
                                    MultiPoint multiPoint2;
                                    Object g3;
                                    objectArray = x0$3;
                                    Option option2 = Array$.MODULE$.unapplySeq((Object)objectArray);
                                    if (option2.isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(1) != 0 || !((g3 = ((SeqLike)option2.get()).apply(0)) instanceof MultiPoint)) break block3;
                                    multiPoint = multiPoint2 = (MultiPoint)g3;
                                    break block4;
                                }
                                Option option3 = Array$.MODULE$.unapplySeq((Object)objectArray);
                                if (option3.isEmpty() || option3.get() == null || ((SeqLike)option3.get()).lengthCompare(1) != 0 || !((g2 = ((SeqLike)option3.get()).apply(0)) instanceof String)) break block5;
                                String string = (String)g2;
                                multiPoint = (MultiPoint)WKTUtils$.MODULE$.read(string);
                                break block4;
                            }
                            Option option4 = Array$.MODULE$.unapplySeq((Object)objectArray);
                            if (option4.isEmpty() || option4.get() == null || ((SeqLike)option4.get()).lengthCompare(1) != 0 || !((g = ((SeqLike)option4.get()).apply(0)) instanceof byte[])) break block6;
                            byte[] byArray = (byte[])g;
                            multiPoint = (MultiPoint)WKBUtils$.MODULE$.read(byArray);
                            break block4;
                        }
                        Option option5 = Array$.MODULE$.unapplySeq((Object)objectArray);
                        if (option5.isEmpty() || option5.get() == null || ((SeqLike)option5.get()).lengthCompare(2) != 0) break block7;
                        Object x = ((SeqLike)option5.get()).apply(0);
                        Object y = ((SeqLike)option5.get()).apply(1);
                        if (!(x instanceof List)) break block7;
                        List list = (List)x;
                        if (!(y instanceof List)) break block7;
                        List list2 = (List)y;
                        Coordinate[] coords = (Coordinate[])Array$.MODULE$.ofDim(list.size(), ClassTag$.MODULE$.apply(Coordinate.class));
                        for (int i = 0; i < coords.length; ++i) {
                            coords[i] = new Coordinate(((Number)list.get(i)).doubleValue(), ((Number)list2.get(i)).doubleValue());
                        }
                        multiPoint = this.$outer.org$locationtech$geomesa$convert2$transforms$GeometryFunctionFactory$$gf().createMultiPointFromCoords(coords);
                        break block4;
                    }
                    if ((option = Array$.MODULE$.unapplySeq((Object)objectArray)).isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || (object = ((SeqLike)option.get()).apply(0)) != null) break block8;
                    multiPoint = null;
                }
                return multiPoint;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid multipoint conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)objectArray).mkString(",")})));
        }
        {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    });
    private final TransformerFunction lineStringParserFn = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"linestring"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;
        private final /* synthetic */ GeometryFunctionFactory $outer;

        public final Object apply(Object[] x0$4) {
            Object[] objectArray;
            block8: {
                LineString lineString;
                block4: {
                    Object object;
                    Option option;
                    block7: {
                        block6: {
                            Object g;
                            block5: {
                                Object g2;
                                block3: {
                                    LineString lineString2;
                                    Object g3;
                                    objectArray = x0$4;
                                    Option option2 = Array$.MODULE$.unapplySeq((Object)objectArray);
                                    if (option2.isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(1) != 0 || !((g3 = ((SeqLike)option2.get()).apply(0)) instanceof LineString)) break block3;
                                    lineString = lineString2 = (LineString)g3;
                                    break block4;
                                }
                                Option option3 = Array$.MODULE$.unapplySeq((Object)objectArray);
                                if (option3.isEmpty() || option3.get() == null || ((SeqLike)option3.get()).lengthCompare(1) != 0 || !((g2 = ((SeqLike)option3.get()).apply(0)) instanceof String)) break block5;
                                String string = (String)g2;
                                lineString = (LineString)WKTUtils$.MODULE$.read(string);
                                break block4;
                            }
                            Option option4 = Array$.MODULE$.unapplySeq((Object)objectArray);
                            if (option4.isEmpty() || option4.get() == null || ((SeqLike)option4.get()).lengthCompare(1) != 0 || !((g = ((SeqLike)option4.get()).apply(0)) instanceof byte[])) break block6;
                            byte[] byArray = (byte[])g;
                            lineString = (LineString)WKBUtils$.MODULE$.read(byArray);
                            break block4;
                        }
                        Option option5 = Array$.MODULE$.unapplySeq((Object)objectArray);
                        if (option5.isEmpty() || option5.get() == null || ((SeqLike)option5.get()).lengthCompare(2) != 0) break block7;
                        Object x = ((SeqLike)option5.get()).apply(0);
                        Object y = ((SeqLike)option5.get()).apply(1);
                        if (!(x instanceof List)) break block7;
                        List list = (List)x;
                        if (!(y instanceof List)) break block7;
                        List list2 = (List)y;
                        Coordinate[] coords = (Coordinate[])Array$.MODULE$.ofDim(list.size(), ClassTag$.MODULE$.apply(Coordinate.class));
                        for (int i = 0; i < coords.length; ++i) {
                            coords[i] = new Coordinate(((Number)list.get(i)).doubleValue(), ((Number)list2.get(i)).doubleValue());
                        }
                        lineString = this.$outer.org$locationtech$geomesa$convert2$transforms$GeometryFunctionFactory$$gf().createLineString(coords);
                        break block4;
                    }
                    if ((option = Array$.MODULE$.unapplySeq((Object)objectArray)).isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || (object = ((SeqLike)option.get()).apply(0)) != null) break block8;
                    lineString = null;
                }
                return lineString;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid linestring conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)objectArray).mkString(",")})));
        }
        {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    });
    private final TransformerFunction multiLineStringParserFn = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"multilinestring"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] x0$5) {
            Object[] objectArray;
            block6: {
                MultiLineString multiLineString;
                block3: {
                    Object object;
                    block5: {
                        Object g;
                        block4: {
                            Object g2;
                            block2: {
                                MultiLineString multiLineString2;
                                Object g3;
                                objectArray = x0$5;
                                Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                                if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g3 = ((SeqLike)option.get()).apply(0)) instanceof MultiLineString)) break block2;
                                multiLineString = multiLineString2 = (MultiLineString)g3;
                                break block3;
                            }
                            Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g2 = ((SeqLike)option.get()).apply(0)) instanceof String)) break block4;
                            String string = (String)g2;
                            multiLineString = (MultiLineString)WKTUtils$.MODULE$.read(string);
                            break block3;
                        }
                        Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g = ((SeqLike)option.get()).apply(0)) instanceof byte[])) break block5;
                        byte[] byArray = (byte[])g;
                        multiLineString = WKBUtils$.MODULE$.read(byArray);
                        break block3;
                    }
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || (object = ((SeqLike)option.get()).apply(0)) != null) break block6;
                    multiLineString = null;
                }
                return multiLineString;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid multilinestring conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)objectArray).mkString(",")})));
        }
    });
    private final TransformerFunction polygonParserFn = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"polygon"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] x0$6) {
            Object[] objectArray;
            block6: {
                Polygon polygon;
                block3: {
                    Object object;
                    block5: {
                        Object g;
                        block4: {
                            Object g2;
                            block2: {
                                Polygon polygon2;
                                Object g3;
                                objectArray = x0$6;
                                Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                                if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g3 = ((SeqLike)option.get()).apply(0)) instanceof Polygon)) break block2;
                                polygon = polygon2 = (Polygon)g3;
                                break block3;
                            }
                            Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g2 = ((SeqLike)option.get()).apply(0)) instanceof String)) break block4;
                            String string = (String)g2;
                            polygon = (Polygon)WKTUtils$.MODULE$.read(string);
                            break block3;
                        }
                        Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g = ((SeqLike)option.get()).apply(0)) instanceof byte[])) break block5;
                        byte[] byArray = (byte[])g;
                        polygon = (Polygon)WKBUtils$.MODULE$.read(byArray);
                        break block3;
                    }
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || (object = ((SeqLike)option.get()).apply(0)) != null) break block6;
                    polygon = null;
                }
                return polygon;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid polygon conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)objectArray).mkString(",")})));
        }
    });
    private final TransformerFunction multiPolygonParserFn = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"multipolygon"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] x0$7) {
            Object[] objectArray;
            block6: {
                MultiPolygon multiPolygon;
                block3: {
                    Object object;
                    block5: {
                        Object g;
                        block4: {
                            Object g2;
                            block2: {
                                MultiPolygon multiPolygon2;
                                Object g3;
                                objectArray = x0$7;
                                Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                                if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g3 = ((SeqLike)option.get()).apply(0)) instanceof MultiPolygon)) break block2;
                                multiPolygon = multiPolygon2 = (MultiPolygon)g3;
                                break block3;
                            }
                            Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g2 = ((SeqLike)option.get()).apply(0)) instanceof String)) break block4;
                            String string = (String)g2;
                            multiPolygon = (MultiPolygon)WKTUtils$.MODULE$.read(string);
                            break block3;
                        }
                        Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g = ((SeqLike)option.get()).apply(0)) instanceof byte[])) break block5;
                        byte[] byArray = (byte[])g;
                        multiPolygon = (MultiPolygon)WKBUtils$.MODULE$.read(byArray);
                        break block3;
                    }
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || (object = ((SeqLike)option.get()).apply(0)) != null) break block6;
                    multiPolygon = null;
                }
                return multiPolygon;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid multipolygon conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)objectArray).mkString(",")})));
        }
    });
    private final TransformerFunction geometryCollectionParserFn = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"geometrycollection"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] x0$8) {
            Object[] objectArray;
            block6: {
                GeometryCollection geometryCollection;
                block3: {
                    Object object;
                    block5: {
                        Object g;
                        block4: {
                            Object g2;
                            block2: {
                                GeometryCollection geometryCollection2;
                                Object g3;
                                objectArray = x0$8;
                                Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                                if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g3 = ((SeqLike)option.get()).apply(0)) instanceof GeometryCollection)) break block2;
                                geometryCollection = geometryCollection2 = (GeometryCollection)g3;
                                break block3;
                            }
                            Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g2 = ((SeqLike)option.get()).apply(0)) instanceof String)) break block4;
                            String string = (String)g2;
                            geometryCollection = (GeometryCollection)WKTUtils$.MODULE$.read(string);
                            break block3;
                        }
                        Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g = ((SeqLike)option.get()).apply(0)) instanceof byte[])) break block5;
                        byte[] byArray = (byte[])g;
                        geometryCollection = WKBUtils$.MODULE$.read(byArray);
                        break block3;
                    }
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || (object = ((SeqLike)option.get()).apply(0)) != null) break block6;
                    geometryCollection = null;
                }
                return geometryCollection;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid geometrycollection conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)objectArray).mkString(",")})));
        }
    });
    private final TransformerFunction geometryParserFn = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"geometry"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] x0$9) {
            Object[] objectArray;
            block6: {
                Geometry geometry;
                block3: {
                    Object object;
                    block5: {
                        Object g;
                        block4: {
                            Object g2;
                            block2: {
                                Geometry geometry2;
                                Object g3;
                                objectArray = x0$9;
                                Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                                if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g3 = ((SeqLike)option.get()).apply(0)) instanceof Geometry)) break block2;
                                geometry = geometry2 = (Geometry)g3;
                                break block3;
                            }
                            Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g2 = ((SeqLike)option.get()).apply(0)) instanceof String)) break block4;
                            String string = (String)g2;
                            geometry = WKTUtils$.MODULE$.read(string);
                            break block3;
                        }
                        Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || !((g = ((SeqLike)option.get()).apply(0)) instanceof byte[])) break block5;
                        byte[] byArray = (byte[])g;
                        geometry = WKBUtils$.MODULE$.read(byArray);
                        break block3;
                    }
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0 || (object = ((SeqLike)option.get()).apply(0)) != null) break block6;
                    geometry = null;
                }
                return geometry;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid geometry conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)objectArray).mkString(",")})));
        }
    });
    private final TransformerFunction projectFromParserFn = new TransformerFunction.NamedTransformerFunction(this){
        private final Map<String, MathTransform> cache;

        private Map<String, MathTransform> cache() {
            return this.cache;
        }

        public Object apply(Object[] args) {
            Geometry geometry;
            Geometry geom = (Geometry)args[1];
            if (geom == null) {
                geometry = null;
            } else {
                String epsg = (String)args[0];
                boolean lenient = args.length > 2 ? Boolean.parseBoolean(args[2].toString()) : true;
                MathTransform transform = (MathTransform)this.cache().getOrElseUpdate((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{epsg, BoxesRunTime.boxToBoolean((boolean)lenient)})), (Function0)new Serializable(this, epsg, lenient){
                    public static final long serialVersionUID = 0L;
                    private final String epsg$1;
                    private final boolean lenient$1;

                    public final MathTransform apply() {
                        return CRS.findMathTransform((CoordinateReferenceSystem)CRS.decode((String)this.epsg$1), (CoordinateReferenceSystem)package$.MODULE$.CRS_EPSG_4326(), (boolean)this.lenient$1);
                    }
                    {
                        this.epsg$1 = epsg$1;
                        this.lenient$1 = lenient$1;
                    }
                });
                geometry = JTS.transform((Geometry)geom, (MathTransform)transform);
            }
            return geometry;
        }
        {
            this.cache = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap<K, V>()).asScala();
        }
    };

    @Override
    public Seq<TransformerFunction> functions() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransformerFunction[]{this.pointParserFn(), this.pointMParserFn(), this.multiPointParserFn(), this.lineStringParserFn(), this.multiLineStringParserFn(), this.polygonParserFn(), this.multiPolygonParserFn(), this.geometryCollectionParserFn(), this.geometryParserFn(), this.projectFromParserFn()}));
    }

    public GeometryFactory org$locationtech$geomesa$convert2$transforms$GeometryFunctionFactory$$gf() {
        return this.org$locationtech$geomesa$convert2$transforms$GeometryFunctionFactory$$gf;
    }

    private TransformerFunction pointParserFn() {
        return this.pointParserFn;
    }

    private TransformerFunction pointMParserFn() {
        return this.pointMParserFn;
    }

    private TransformerFunction multiPointParserFn() {
        return this.multiPointParserFn;
    }

    private TransformerFunction lineStringParserFn() {
        return this.lineStringParserFn;
    }

    private TransformerFunction multiLineStringParserFn() {
        return this.multiLineStringParserFn;
    }

    private TransformerFunction polygonParserFn() {
        return this.polygonParserFn;
    }

    private TransformerFunction multiPolygonParserFn() {
        return this.multiPolygonParserFn;
    }

    private TransformerFunction geometryCollectionParserFn() {
        return this.geometryCollectionParserFn;
    }

    private TransformerFunction geometryParserFn() {
        return this.geometryParserFn;
    }

    private TransformerFunction projectFromParserFn() {
        return this.projectFromParserFn;
    }
}

