/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert2.transforms;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.locationtech.geomesa.convert2.transforms.ScriptingFunctionFactory$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class ScriptingFunctionFactory$
implements LazyLogging {
    public static final ScriptingFunctionFactory$ MODULE$;
    private final String ConvertScriptsPathProperty;
    private final String ConvertScriptsClassPath;
    private final GeoMesaSystemProperties.SystemProperty ConvertScriptsPath;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ScriptingFunctionFactory$();
    }

    private Logger logger$lzycompute() {
        ScriptingFunctionFactory$ scriptingFunctionFactory$ = this;
        synchronized (scriptingFunctionFactory$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String ConvertScriptsPathProperty() {
        return this.ConvertScriptsPathProperty;
    }

    public String ConvertScriptsClassPath() {
        return this.ConvertScriptsClassPath;
    }

    public GeoMesaSystemProperties.SystemProperty ConvertScriptsPath() {
        return this.ConvertScriptsPath;
    }

    public Seq<URI> loadScriptsFromEnvironment() {
        return (Seq)((TraversableLike)Option$.MODULE$.option2Iterable(this.ConvertScriptsPath().option()).toSeq().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String x$2) {
                return Predef$.MODULE$.refArrayOps((Object[])x$2.split(":"));
            }
        }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<URI> apply(String path) {
                File f = new File(path);
                return f.exists() && f.canRead() ? (f.isDirectory() ? (f.canExecute() ? (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(FileUtils.listFiles((File)f, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)TrueFileFilter.TRUE)).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final URI apply(File x$3) {
                        return x$3.toURI();
                    }
                }, Iterable$.MODULE$.canBuildFrom()) : (Iterable)Seq$.MODULE$.empty()) : (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new URI[]{f.toURI()}))) : (Iterable)Seq$.MODULE$.empty();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<URI> loadScripts(ClassLoader loader) {
        return (Seq)((TraversableLike)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(loader.getResources(new StringBuilder().append((Object)this.ConvertScriptsClassPath()).append((Object)"/").toString())).asScala())).toSeq().flatten((Function1)Predef$.MODULE$.$conforms())).flatMap((Function1)new Serializable(loader){
            public static final long serialVersionUID = 0L;
            public final ClassLoader loader$1;

            public final Seq<URI> apply(URL url) {
                String string;
                block7: {
                    Seq seq;
                    block6: {
                        block5: {
                            BoxedUnit boxedUnit;
                            URI uri = url.toURI();
                            string = uri.getScheme();
                            if (!"jar".equals(string)) break block5;
                            FileSystem fs = FileSystems.newFileSystem(uri, Collections.<K, V>emptyMap(), this.loader$1);
                            Path p = fs.getPath(new StringBuilder().append((Object)ScriptingFunctionFactory$.MODULE$.ConvertScriptsClassPath()).append((Object)"/").toString(), new String[0]);
                            Seq uris = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(p, new FileVisitOption[0]).iterator()).asScala()).toSeq();
                            Seq files = (Seq)((TraversableLike)uris.filterNot((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Path x$4) {
                                    return Files.isDirectory(x$4, new LinkOption[0]);
                                }
                            })).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final URI apply(Path x$5) {
                                    return x$5.toUri();
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            if (ScriptingFunctionFactory$.MODULE$.logger().underlying().isDebugEnabled()) {
                                ScriptingFunctionFactory$.MODULE$.logger().underlying().debug("Loaded scripts {} from jar {}", (Object[])new String[]{files.mkString(","), uri.toString()});
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            seq = files;
                            break block6;
                        }
                        if (!"file".equals(string)) break block7;
                        seq = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(IOUtils.readLines((InputStream)url.openStream(), (String)"UTF-8")).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.loadScripts.1 $outer;

                            public final URI apply(String s) {
                                return this.$outer.loader$1.getResource(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ScriptingFunctionFactory$.MODULE$.ConvertScriptsClassPath(), s}))).toURI();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Buffer$.MODULE$.canBuildFrom());
                    }
                    return seq;
                }
                throw new MatchError((Object)string);
            }
            {
                this.loader$1 = loader$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private ScriptingFunctionFactory$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.ConvertScriptsPathProperty = "geomesa.convert.scripts.path";
        this.ConvertScriptsClassPath = "geomesa-convert-scripts";
        this.ConvertScriptsPath = new GeoMesaSystemProperties.SystemProperty(this.ConvertScriptsPathProperty(), GeoMesaSystemProperties.SystemProperty$.MODULE$.apply$default$2());
    }
}

