/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert2.transforms;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.Locale;
import org.locationtech.geomesa.convert2.transforms.Expression;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction$;
import org.locationtech.geomesa.convert2.transforms.TransformerFunctionFactory;
import org.locationtech.geomesa.utils.text.DateParsing$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001B\u0001\u0003\u00015\u00111\u0003R1uK\u001a+hn\u0019;j_:4\u0015m\u0019;pefT!a\u0001\u0003\u0002\u0015Q\u0014\u0018M\\:g_Jl7O\u0003\u0002\u0006\r\u0005A1m\u001c8wKJ$(G\u0003\u0002\b\u0011\u00059q-Z8nKN\f'BA\u0005\u000b\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u00035Q\u0013\u0018M\\:g_JlWM\u001d$v]\u000e$\u0018n\u001c8GC\u000e$xN]=\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002CA\u000b\u0001\u0011\u0015i\u0002\u0001\"\u0011\u001f\u0003%1WO\\2uS>t7/F\u0001 !\r\u0001\u0003f\u000b\b\u0003C\u0019r!AI\u0013\u000e\u0003\rR!\u0001\n\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012BA\u0014\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u000b\u0016\u0003\u0007M+\u0017O\u0003\u0002(!A\u0011Q\u0003L\u0005\u0003[\t\u00111\u0003\u0016:b]N4wN]7fe\u001a+hn\u0019;j_:Dqa\f\u0001C\u0002\u0013%\u0001'A\u0002o_^,\u0012a\u000b\u0005\u0007e\u0001\u0001\u000b\u0011B\u0016\u0002\t9|w\u000f\t\u0005\bi\u0001\u0011\r\u0011\"\u00031\u00031i\u0017\u000e\u001c7jgR{G)\u0019;f\u0011\u00191\u0004\u0001)A\u0005W\u0005iQ.\u001b7mSN$v\u000eR1uK\u0002Bq\u0001\u000f\u0001C\u0002\u0013%\u0001'\u0001\u0006tK\u000e\u001cHk\u001c#bi\u0016DaA\u000f\u0001!\u0002\u0013Y\u0013aC:fGN$v\u000eR1uK\u0002Bq\u0001\u0010\u0001C\u0002\u0013%Q(\u0001\u0005eCR,G/[7f+\u0005q\u0004CA R\u001d\t\u0001%J\u0004\u0002B\u0013:\u0011!\t\u0013\b\u0003\u0007\u001es!\u0001\u0012$\u000f\u0005\t*\u0015\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t\u001d)1J\u0001E\u0001\u0019\u0006\u0019B)\u0019;f\rVt7\r^5p]\u001a\u000b7\r^8ssB\u0011Q#\u0014\u0004\u0006\u0003\tA\tAT\n\u0003\u001b:AQ!G'\u0005\u0002A#\u0012\u0001\u0014\u0004\u0006%6\u000b\ta\u0015\u0002\u0013'R\fg\u000eZ1sI\u0012\u000bG/\u001a)beN,'o\u0005\u0002R)B\u0011Q\u000b\u0017\b\u0003\u0001ZK!a\u0016\u0002\u0002'Q\u0013\u0018M\\:g_JlWM\u001d$v]\u000e$\u0018n\u001c8\n\u0005eS&\u0001\u0007(b[\u0016$GK]1og\u001a|'/\\3s\rVt7\r^5p]*\u0011qK\u0001\u0005\n9F\u0013\t\u0011)A\u0005;\u0016\fQA\\1nKN\u00042\u0001\t\u0015_!\ty&M\u0004\u0002\u0010A&\u0011\u0011\rE\u0001\u0007!J,G-\u001a4\n\u0005\r$'AB*ue&twM\u0003\u0002b!%\u0011A\f\u0017\u0005\u00063E#\ta\u001a\u000b\u0003Q*\u0004\"![)\u000e\u00035CQ\u0001\u00184A\u0002uCq\u0001\\)C\u0002\u001b\u0005Q.\u0001\u0004g_Jl\u0017\r^\u000b\u0002]B\u0011q.^\u0007\u0002a*\u0011A.\u001d\u0006\u0003eN\fA\u0001^5nK*\tA/\u0001\u0003kCZ\f\u0017B\u0001<q\u0005E!\u0015\r^3US6,gi\u001c:nCR$XM\u001d\u0005\u0006qF#\t%_\u0001\u0006CB\u0004H.\u001f\u000b\u0003\u001diDQa_<A\u0002q\fA!\u0019:hgB\u0019q\" \b\n\u0005y\u0004\"!B!se\u0006LhABA\u0001\u001b\u0002\t\u0019A\u0001\fDkN$x.\u001c$pe6\fG\u000fR1uKB\u000b'o]3s'\tyH\u000b\u0003\u0005m\u007f\n\u0005\t\u0015!\u0003o\u0011\u0019Ir\u0010\"\u0001\u0002\nQ!\u00111BA\u0007!\tIw\u0010\u0003\u0004m\u0003\u000f\u0001\rA\u001c\u0005\b\u0003#yH\u0011IA\n\u0003-9W\r^%ogR\fgnY3\u0015\t\u0005-\u0011Q\u0003\u0005\bw\u0006=\u0001\u0019AA\f!\u0015\u0001\u0013\u0011DA\u000f\u0013\r\tYB\u000b\u0002\u0005\u0019&\u001cH\u000fE\u0002\u0016\u0003?I1!!\t\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0007q~$\t%!\n\u0015\u00079\t9\u0003\u0003\u0004|\u0003G\u0001\r\u0001 \u0004\u0007\u0003Wi\u0005!!\f\u0003\u0019\u0011\u000bG/\u001a+p'R\u0014\u0018N\\4\u0014\u0007\u0005%B\u000bC\u0005m\u0003S\u0011\t\u0011)A\u0005]\"9\u0011$!\u000b\u0005\u0002\u0005MB\u0003BA\u001b\u0003o\u00012![A\u0015\u0011\u0019a\u0017\u0011\u0007a\u0001]\"A\u0011\u0011CA\u0015\t\u0003\nY\u0004\u0006\u0003\u00026\u0005u\u0002bB>\u0002:\u0001\u0007\u0011q\u0003\u0005\bq\u0006%B\u0011IA!)\rq\u00111\t\u0005\u0007w\u0006}\u0002\u0019\u0001?\t\u000f\u0005\u001d\u0003\u0001)A\u0005}\u0005IA-\u0019;fi&lW\r\t\u0005\t\u0003\u0017\u0002!\u0019!C\u0005{\u0005a!-Y:jG&\u001bx\u000eR1uK\"9\u0011q\n\u0001!\u0002\u0013q\u0014!\u00042bg&\u001c\u0017j]8ECR,\u0007\u0005\u0003\u0005\u0002T\u0001\u0011\r\u0011\"\u0003>\u0003\u001dI7o\u001c#bi\u0016Dq!a\u0016\u0001A\u0003%a(\u0001\u0005jg>$\u0015\r^3!\u0011!\tY\u0006\u0001b\u0001\n\u0013i\u0014\u0001D5t_2{7-\u00197ECR,\u0007bBA0\u0001\u0001\u0006IAP\u0001\u000eSN|Gj\\2bY\u0012\u000bG/\u001a\u0011\t\u0011\u0005\r\u0004A1A\u0005\nu\n\u0001#[:p\u0019>\u001c\u0017\r\u001c#bi\u0016$\u0016.\\3\t\u000f\u0005\u001d\u0004\u0001)A\u0005}\u0005\t\u0012n]8M_\u000e\fG\u000eR1uKRKW.\u001a\u0011\t\u0011\u0005-\u0004A1A\u0005\nu\n\u0011#[:p\u001f\u001a47/\u001a;ECR,G+[7f\u0011\u001d\ty\u0007\u0001Q\u0001\ny\n!#[:p\u001f\u001a47/\u001a;ECR,G+[7fA!A\u00111\u000f\u0001C\u0002\u0013%Q(A\u0006jg>$\u0015\r^3US6,\u0007bBA<\u0001\u0001\u0006IAP\u0001\rSN|G)\u0019;f)&lW\r\t\u0005\t\u0003w\u0002!\u0019!C\u0005{\u0005i!-Y:jG\u0012\u000bG/\u001a+j[\u0016Dq!a \u0001A\u0003%a(\u0001\bcCNL7\rR1uKRKW.\u001a\u0011\t\u0011\u0005\r\u0005A1A\u0005\nu\nQCY1tS\u000e$\u0015\r^3US6,gj\\'jY2L7\u000fC\u0004\u0002\b\u0002\u0001\u000b\u0011\u0002 \u0002-\t\f7/[2ECR,G+[7f\u001d>l\u0015\u000e\u001c7jg\u0002B\u0001\"a#\u0001\u0005\u0004%I!P\u0001\u001bI\u0006$X\rS8ve6Kg.\u001e;f'\u0016\u001cwN\u001c3NS2d\u0017n\u001d\u0005\b\u0003\u001f\u0003\u0001\u0015!\u0003?\u0003m!\u0017\r^3I_V\u0014X*\u001b8vi\u0016\u001cVmY8oI6KG\u000e\\5tA!I\u00111\u0013\u0001C\u0002\u0013%\u0011QS\u0001\u0017GV\u001cHo\\7G_Jl\u0017\r\u001e#bi\u0016\u0004\u0016M]:feV\u0011\u0011q\u0013\t\u0003\u007f}D\u0001\"a'\u0001A\u0003%\u0011qS\u0001\u0018GV\u001cHo\\7G_Jl\u0017\r\u001e#bi\u0016\u0004\u0016M]:fe\u0002B\u0011\"a(\u0001\u0005\u0004%I!!)\u0002\u0019\u0011\fG/\u001a+p'R\u0014\u0018N\\4\u0016\u0005\u0005\r\u0006cA \u0002*!A\u0011q\u0015\u0001!\u0002\u0013\t\u0019+A\u0007eCR,Gk\\*ue&tw\r\t\u0005\t\u0003W\u0003!\u0019!C\u0005a\u0005aA-\u0019;f)>l\u0015\u000e\u001c7jg\"9\u0011q\u0016\u0001!\u0002\u0013Y\u0013!\u00043bi\u0016$v.T5mY&\u001c\b\u0005")
public class DateFunctionFactory
implements TransformerFunctionFactory {
    private final TransformerFunction now = TransformerFunction$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"now"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Date apply(Object[] x$1) {
            return Date.from(ZonedDateTime.now(ZoneOffset.UTC).toInstant());
        }
    });
    private final TransformerFunction millisToDate = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"millisToDate"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            Object object;
            block4: {
                Date date;
                block3: {
                    block2: {
                        object = args[0];
                        if (object != null) break block2;
                        date = null;
                        break block3;
                    }
                    if (!(object instanceof Number)) break block4;
                    Number number = (Number)object;
                    date = new Date(number.longValue());
                }
                return date;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid millisecond: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{object})));
        }
    });
    private final TransformerFunction secsToDate = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"secsToDate"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            Object object;
            block4: {
                Date date;
                block3: {
                    block2: {
                        object = args[0];
                        if (object != null) break block2;
                        date = null;
                        break block3;
                    }
                    if (!(object instanceof Number)) break block4;
                    Number number = (Number)object;
                    date = new Date(number.longValue() * 1000L);
                }
                return date;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid second: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{object})));
        }
    });
    private final StandardDateParser datetime = new StandardDateParser(this){
        private final DateTimeFormatter format;

        public DateTimeFormatter format() {
            return this.format;
        }
        {
            this.format = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).parseLenient().appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalStart().appendOffsetId().toFormatter(Locale.US).withZone(ZoneOffset.UTC);
        }
    };
    private final StandardDateParser basicIsoDate = new StandardDateParser(this){
        private final DateTimeFormatter format;

        public DateTimeFormatter format() {
            return this.format;
        }
        {
            this.format = DateTimeFormatter.BASIC_ISO_DATE.withZone(ZoneOffset.UTC);
        }
    };
    private final StandardDateParser isoDate = new StandardDateParser(this){
        private final DateTimeFormatter format;

        public DateTimeFormatter format() {
            return this.format;
        }
        {
            this.format = DateTimeFormatter.ISO_DATE.withZone(ZoneOffset.UTC);
        }
    };
    private final StandardDateParser isoLocalDate = new StandardDateParser(this){
        private final DateTimeFormatter format;

        public DateTimeFormatter format() {
            return this.format;
        }
        {
            this.format = DateTimeFormatter.ISO_LOCAL_DATE.withZone(ZoneOffset.UTC);
        }
    };
    private final StandardDateParser isoLocalDateTime = new StandardDateParser(this){
        private final DateTimeFormatter format;

        public DateTimeFormatter format() {
            return this.format;
        }
        {
            this.format = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneOffset.UTC);
        }
    };
    private final StandardDateParser isoOffsetDateTime = new StandardDateParser(this){
        private final DateTimeFormatter format;

        public DateTimeFormatter format() {
            return this.format;
        }
        {
            this.format = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneOffset.UTC);
        }
    };
    private final StandardDateParser isoDateTime = new StandardDateParser(this){
        private final DateTimeFormatter format;

        public DateTimeFormatter format() {
            return this.format;
        }
        {
            this.format = DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneOffset.UTC);
        }
    };
    private final StandardDateParser basicDateTime = new StandardDateParser(this){
        private final DateTimeFormatter format;

        public DateTimeFormatter format() {
            return this.format;
        }
        {
            this.format = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalStart().appendOffsetId().toFormatter(Locale.US).withZone(ZoneOffset.UTC);
        }
    };
    private final StandardDateParser basicDateTimeNoMillis = new StandardDateParser(this){
        private final DateTimeFormatter format;

        public DateTimeFormatter format() {
            return this.format;
        }
        {
            this.format = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendOffsetId().toFormatter(Locale.US).withZone(ZoneOffset.UTC);
        }
    };
    private final StandardDateParser dateHourMinuteSecondMillis = new StandardDateParser(this){
        private final DateTimeFormatter format;

        public DateTimeFormatter format() {
            return this.format;
        }
        {
            this.format = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).parseLenient().appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).toFormatter(Locale.US).withZone(ZoneOffset.UTC);
        }
    };
    private final CustomFormatDateParser customFormatDateParser = new CustomFormatDateParser(null);
    private final DateToString dateToString = new DateToString(null);
    private final TransformerFunction dateToMillis = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dateToMillis"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            return args[0] == null ? null : BoxesRunTime.boxToLong((long)((Date)args[0]).getTime());
        }
    });

    @Override
    public Seq<TransformerFunction> functions() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransformerFunction[]{this.now(), this.customFormatDateParser(), this.datetime(), this.basicDateTimeNoMillis(), this.basicIsoDate(), this.basicDateTime(), this.isoDate(), this.isoLocalDate(), this.isoLocalDateTime(), this.isoOffsetDateTime(), this.isoDateTime(), this.dateHourMinuteSecondMillis(), this.millisToDate(), this.secsToDate(), this.dateToString(), this.dateToMillis()}));
    }

    private TransformerFunction now() {
        return this.now;
    }

    private TransformerFunction millisToDate() {
        return this.millisToDate;
    }

    private TransformerFunction secsToDate() {
        return this.secsToDate;
    }

    private StandardDateParser datetime() {
        return this.datetime;
    }

    private StandardDateParser basicIsoDate() {
        return this.basicIsoDate;
    }

    private StandardDateParser isoDate() {
        return this.isoDate;
    }

    private StandardDateParser isoLocalDate() {
        return this.isoLocalDate;
    }

    private StandardDateParser isoLocalDateTime() {
        return this.isoLocalDateTime;
    }

    private StandardDateParser isoOffsetDateTime() {
        return this.isoOffsetDateTime;
    }

    private StandardDateParser isoDateTime() {
        return this.isoDateTime;
    }

    private StandardDateParser basicDateTime() {
        return this.basicDateTime;
    }

    private StandardDateParser basicDateTimeNoMillis() {
        return this.basicDateTimeNoMillis;
    }

    private StandardDateParser dateHourMinuteSecondMillis() {
        return this.dateHourMinuteSecondMillis;
    }

    private CustomFormatDateParser customFormatDateParser() {
        return this.customFormatDateParser;
    }

    private DateToString dateToString() {
        return this.dateToString;
    }

    private TransformerFunction dateToMillis() {
        return this.dateToMillis;
    }

    public static class DateToString
    extends TransformerFunction.NamedTransformerFunction {
        private final DateTimeFormatter format;

        @Override
        public DateToString getInstance(List<Expression> args) {
            .colon.colon colon2;
            Expression expression2;
            List<Expression> list = args;
            if (list instanceof .colon.colon && (expression2 = (Expression)(colon2 = (.colon.colon)list).head()) instanceof Expression.LiteralString) {
                DateTimeFormatter dateTimeFormatter;
                Expression.LiteralString literalString = (Expression.LiteralString)expression2;
                String s = literalString.value();
                DateTimeFormatter format = dateTimeFormatter = DateTimeFormatter.ofPattern(s).withZone(ZoneOffset.UTC);
                return new DateToString(format);
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected date pattern but got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args.headOption().orNull(Predef$.MODULE$.$conforms())})));
        }

        @Override
        public Object apply(Object[] args) {
            return DateParsing$.MODULE$.formatDate((Date)args[1], this.format);
        }

        public DateToString(DateTimeFormatter format) {
            this.format = format;
            super((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dateToString"}))), true);
        }
    }

    public static abstract class StandardDateParser
    extends TransformerFunction.NamedTransformerFunction {
        public abstract DateTimeFormatter format();

        @Override
        public Object apply(Object[] args) {
            Date date;
            Object object = args[0];
            if (object == null) {
                date = null;
            } else if (object instanceof String) {
                String string = (String)object;
                date = DateParsing$.MODULE$.parseDate(string, this.format());
            } else {
                date = DateParsing$.MODULE$.parseDate(object.toString(), this.format());
            }
            return date;
        }

        public StandardDateParser(Seq<String> names) {
            super(names, true);
        }
    }

    public static class CustomFormatDateParser
    extends TransformerFunction.NamedTransformerFunction {
        private final DateTimeFormatter format;

        @Override
        public CustomFormatDateParser getInstance(List<Expression> args) {
            .colon.colon colon2;
            Expression expression2;
            List<Expression> list = args;
            if (list instanceof .colon.colon && (expression2 = (Expression)(colon2 = (.colon.colon)list).head()) instanceof Expression.LiteralString) {
                DateTimeFormatter dateTimeFormatter;
                Expression.LiteralString literalString = (Expression.LiteralString)expression2;
                String s = literalString.value();
                DateTimeFormatter format = dateTimeFormatter = DateTimeFormatter.ofPattern(s).withZone(ZoneOffset.UTC);
                return new CustomFormatDateParser(format);
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected date pattern but got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args.headOption().orNull(Predef$.MODULE$.$conforms())})));
        }

        @Override
        public Object apply(Object[] args) {
            Date date;
            Object object = args[1];
            if (object == null) {
                date = null;
            } else if (object instanceof String) {
                String string = (String)object;
                date = DateParsing$.MODULE$.parseDate(string, this.format);
            } else {
                date = DateParsing$.MODULE$.parseDate(object.toString(), this.format);
            }
            return date;
        }

        public CustomFormatDateParser(DateTimeFormatter format) {
            this.format = format;
            super((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"date"}))), true);
        }
    }
}

