/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert2.transforms;

import org.apache.commons.lang3.StringUtils;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction$;
import org.locationtech.geomesa.convert2.transforms.TransformerFunctionFactory;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001\u001b\t)2\u000b\u001e:j]\u001e4UO\\2uS>tg)Y2u_JL(BA\u0002\u0005\u0003)!(/\u00198tM>\u0014Xn\u001d\u0006\u0003\u000b\u0019\t\u0001bY8om\u0016\u0014HO\r\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005i!&/\u00198tM>\u0014X.\u001a:Gk:\u001cG/[8o\r\u0006\u001cGo\u001c:z\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u0016\u0001!)Q\u0004\u0001C!=\u0005Ia-\u001e8di&|gn]\u000b\u0002?A\u0019\u0001\u0005K\u0016\u000f\u0005\u00052cB\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\r\u0003\u0019a$o\\8u}%\t\u0011#\u0003\u0002(!\u00059\u0001/Y2lC\u001e,\u0017BA\u0015+\u0005\r\u0019V-\u001d\u0006\u0003OA\u0001\"!\u0006\u0017\n\u00055\u0012!a\u0005+sC:\u001chm\u001c:nKJ4UO\\2uS>t\u0007bB\u0018\u0001\u0005\u0004%I\u0001M\u0001\u0007gR\u0014\u0018N\\4\u0016\u0003-BaA\r\u0001!\u0002\u0013Y\u0013aB:ue&tw\r\t\u0005\bi\u0001\u0011\r\u0011\"\u00031\u0003-\u0019HO]5q#V|G/Z:\t\rY\u0002\u0001\u0015!\u0003,\u00031\u0019HO]5q#V|G/Z:!\u0011\u001dA\u0004A1A\u0005\nA\nQa\u001d;sSBDaA\u000f\u0001!\u0002\u0013Y\u0013AB:ue&\u0004\b\u0005C\u0004=\u0001\t\u0007I\u0011\u0002\u0019\u0002\u0017M$(/\u001b9Qe\u00164\u0017\u000e\u001f\u0005\u0007}\u0001\u0001\u000b\u0011B\u0016\u0002\u0019M$(/\u001b9Qe\u00164\u0017\u000e\u001f\u0011\t\u000f\u0001\u0003!\u0019!C\u0005a\u0005Y1\u000f\u001e:jaN+hMZ5y\u0011\u0019\u0011\u0005\u0001)A\u0005W\u0005a1\u000f\u001e:jaN+hMZ5yA!9A\t\u0001b\u0001\n\u0013\u0001\u0014a\u0002:fa2\f7-\u001a\u0005\u0007\r\u0002\u0001\u000b\u0011B\u0016\u0002\u0011I,\u0007\u000f\\1dK\u0002Bq\u0001\u0013\u0001C\u0002\u0013%\u0001'\u0001\u0004sK6|g/\u001a\u0005\u0007\u0015\u0002\u0001\u000b\u0011B\u0016\u0002\u000fI,Wn\u001c<fA!9A\n\u0001b\u0001\n\u0013\u0001\u0014\u0001\u0002;sS6DaA\u0014\u0001!\u0002\u0013Y\u0013!\u0002;sS6\u0004\u0003b\u0002)\u0001\u0005\u0004%I\u0001M\u0001\u000bG\u0006\u0004\u0018\u000e^1mSj,\u0007B\u0002*\u0001A\u0003%1&A\u0006dCBLG/\u00197ju\u0016\u0004\u0003b\u0002+\u0001\u0005\u0004%I\u0001M\u0001\nY><XM]2bg\u0016DaA\u0016\u0001!\u0002\u0013Y\u0013A\u00037po\u0016\u00148-Y:fA!9\u0001\f\u0001b\u0001\n\u0013\u0001\u0014!C;qa\u0016\u00148-Y:f\u0011\u0019Q\u0006\u0001)A\u0005W\u0005QQ\u000f\u001d9fe\u000e\f7/\u001a\u0011\t\u000fq\u0003!\u0019!C\u0005a\u000511m\u001c8dCRDaA\u0018\u0001!\u0002\u0013Y\u0013aB2p]\u000e\fG\u000f\t\u0005\bA\u0002\u0011\r\u0011\"\u00031\u0003!i7n\u001d;sS:<\u0007B\u00022\u0001A\u0003%1&A\u0005nWN$(/\u001b8hA!9A\r\u0001b\u0001\n\u0013\u0001\u0014aC3naRLHk\u001c(vY2DaA\u001a\u0001!\u0002\u0013Y\u0013\u0001D3naRLHk\u001c(vY2\u0004\u0003b\u00025\u0001\u0005\u0004%I\u0001M\u0001\re\u0016<W\r\u001f*fa2\f7-\u001a\u0005\u0007U\u0002\u0001\u000b\u0011B\u0016\u0002\u001bI,w-\u001a=SKBd\u0017mY3!\u0011\u001da\u0007A1A\u0005\nA\naa];cgR\u0014\bB\u00028\u0001A\u0003%1&A\u0004tk\n\u001cHO\u001d\u0011\t\u000fA\u0004!\u0019!C\u0005a\u000511\u000f\u001e:MK:DaA\u001d\u0001!\u0002\u0013Y\u0013aB:ue2+g\u000e\t\u0005\bi\u0002\u0011\r\u0011\"\u00031\u0003\u0019\u0001(/\u001b8uM\"1a\u000f\u0001Q\u0001\n-\nq\u0001\u001d:j]R4\u0007\u0005")
public class StringFunctionFactory
implements TransformerFunctionFactory {
    private final TransformerFunction string = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"toString"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            return args[0] == null ? null : args[0].toString();
        }
    });
    private final TransformerFunction stripQuotes = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stripQuotes"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            String string;
            if (args[0] == null) {
                string = null;
            } else {
                String string2;
                Object object = args[0];
                String string3 = object instanceof String ? (string2 = (String)object) : object.toString();
                String s = string3;
                string = StringUtils.strip((String)s, (String)"'\"");
            }
            return string;
        }
    });
    private final TransformerFunction strip = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"strip"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            String string;
            if (args[0] == null) {
                string = null;
            } else {
                String string2;
                Object object = args[0];
                String string3 = object instanceof String ? (string2 = (String)object) : object.toString();
                String s = string3;
                String toStrip = args.length == 1 ? null : (String)args[1];
                string = StringUtils.strip((String)s, (String)toStrip);
            }
            return string;
        }
    });
    private final TransformerFunction stripPrefix = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stripPrefix"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            String string;
            if (args[0] == null) {
                string = null;
            } else {
                String string2;
                Object object = args[0];
                String string3 = object instanceof String ? (string2 = (String)object) : object.toString();
                String s = string3;
                String toStrip = (String)args[1];
                string = StringUtils.stripStart((String)s, (String)toStrip);
            }
            return string;
        }
    });
    private final TransformerFunction stripSuffix = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stripSuffix"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            String string;
            if (args[0] == null) {
                string = null;
            } else {
                String string2;
                Object object = args[0];
                String string3 = object instanceof String ? (string2 = (String)object) : object.toString();
                String s = string3;
                String toStrip = (String)args[1];
                string = StringUtils.stripEnd((String)s, (String)toStrip);
            }
            return string;
        }
    });
    private final TransformerFunction replace = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"replace"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            String string;
            if (args[0] == null) {
                string = null;
            } else {
                String string2;
                Object object = args[0];
                String string3 = object instanceof String ? (string2 = (String)object) : object.toString();
                String s = string3;
                String toRemove = (String)args[1];
                String replacement = (String)args[2];
                string = new StringOps(Predef$.MODULE$.augmentString(s)).replaceAllLiterally(toRemove, replacement);
            }
            return string;
        }
    });
    private final TransformerFunction remove = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"remove"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            String string;
            if (args[0] == null) {
                string = null;
            } else {
                String string2;
                Object object = args[0];
                String string3 = object instanceof String ? (string2 = (String)object) : object.toString();
                String s = string3;
                String toRemove = (String)args[1];
                string = StringUtils.remove((String)s, (String)toRemove);
            }
            return string;
        }
    });
    private final TransformerFunction trim = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"trim"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            String string;
            if (args[0] == null) {
                string = null;
            } else {
                String string2;
                Object object = args[0];
                String string3 = object instanceof String ? (string2 = (String)object) : object.toString();
                String s = string3;
                string = s.trim();
            }
            return string;
        }
    });
    private final TransformerFunction capitalize = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"capitalize"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            String string;
            if (args[0] == null) {
                string = null;
            } else {
                String string2;
                Object object = args[0];
                String string3 = object instanceof String ? (string2 = (String)object) : object.toString();
                String s = string3;
                string = new StringOps(Predef$.MODULE$.augmentString(s)).capitalize();
            }
            return string;
        }
    });
    private final TransformerFunction lowercase = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lowercase"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            String string;
            if (args[0] == null) {
                string = null;
            } else {
                String string2;
                Object object = args[0];
                String string3 = object instanceof String ? (string2 = (String)object) : object.toString();
                String s = string3;
                string = s.toLowerCase();
            }
            return string;
        }
    });
    private final TransformerFunction uppercase = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uppercase"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            String string;
            if (args[0] == null) {
                string = null;
            } else {
                String string2;
                Object object = args[0];
                String string3 = object instanceof String ? (string2 = (String)object) : object.toString();
                String s = string3;
                string = s.toUpperCase();
            }
            return string;
        }
    });
    private final TransformerFunction concat = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"concat", "concatenate"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final String apply(Object[] args) {
            String[] strings = (String[])Predef$.MODULE$.genericArrayOps((Object)args).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Object x0$1) {
                    String string;
                    Object object = x0$1;
                    String string2 = object instanceof String ? (string = (String)object) : (object == null ? "null" : object.toString());
                    return string2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            return Predef$.MODULE$.refArrayOps((Object[])strings).mkString();
        }
    });
    private final TransformerFunction mkstring = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mkstring"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final String apply(Object[] args) {
            String delim = (String)args[0];
            String[] strings = (String[])Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)args).drop(1)).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Object x0$2) {
                    String string;
                    Object object = x0$2;
                    String string2 = object instanceof String ? (string = (String)object) : (object == null ? "null" : object.toString());
                    return string2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            return Predef$.MODULE$.refArrayOps((Object[])strings).mkString(delim);
        }
    });
    private final TransformerFunction emptyToNull = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"emptyToNull"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            return args[0] == null || args[0].toString().trim().isEmpty() ? null : args[0];
        }
    });
    private final TransformerFunction regexReplace = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"regexReplace"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            String string;
            if (args[2] == null) {
                string = null;
            } else {
                String string2;
                Object object = args[2];
                String string3 = object instanceof String ? (string2 = (String)object) : object.toString();
                String s = string3;
                Regex regex = (Regex)args[0];
                String replacement = (String)args[1];
                string = regex.replaceAllIn((CharSequence)s, replacement);
            }
            return string;
        }
    });
    private final TransformerFunction substr = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"substr", "substring"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            String string;
            if (args[0] == null) {
                string = null;
            } else {
                String string2;
                Object object = args[0];
                String string3 = object instanceof String ? (string2 = (String)object) : object.toString();
                String s = string3;
                int from2 = BoxesRunTime.unboxToInt((Object)args[1]);
                int to2 = BoxesRunTime.unboxToInt((Object)args[2]);
                string = s.substring(from2, to2);
            }
            return string;
        }
    });
    private final TransformerFunction strLen = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"strlen", "stringLength", "length"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final int apply(Object[] args) {
            String string;
            Object object = args[0];
            String string2 = object instanceof String ? (string = (String)object) : (object == null ? "" : object.toString());
            String s = string2;
            return s.length();
        }
    });
    private final TransformerFunction printf = TransformerFunction$.MODULE$.pure((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"printf"}), (Function1<Object[], Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final String apply(Object[] args) {
            return String.format(args[0].toString(), (Object[])Predef$.MODULE$.genericArrayOps((Object)args).drop(1));
        }
    });

    @Override
    public Seq<TransformerFunction> functions() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransformerFunction[]{this.stripQuotes(), this.strip(), this.stripPrefix(), this.stripSuffix(), this.replace(), this.remove(), this.strLen(), this.trim(), this.capitalize(), this.lowercase(), this.uppercase(), this.regexReplace(), this.concat(), this.substr(), this.string(), this.mkstring(), this.emptyToNull(), this.printf()}));
    }

    private TransformerFunction string() {
        return this.string;
    }

    private TransformerFunction stripQuotes() {
        return this.stripQuotes;
    }

    private TransformerFunction strip() {
        return this.strip;
    }

    private TransformerFunction stripPrefix() {
        return this.stripPrefix;
    }

    private TransformerFunction stripSuffix() {
        return this.stripSuffix;
    }

    private TransformerFunction replace() {
        return this.replace;
    }

    private TransformerFunction remove() {
        return this.remove;
    }

    private TransformerFunction trim() {
        return this.trim;
    }

    private TransformerFunction capitalize() {
        return this.capitalize;
    }

    private TransformerFunction lowercase() {
        return this.lowercase;
    }

    private TransformerFunction uppercase() {
        return this.uppercase;
    }

    private TransformerFunction concat() {
        return this.concat;
    }

    private TransformerFunction mkstring() {
        return this.mkstring;
    }

    private TransformerFunction emptyToNull() {
        return this.emptyToNull;
    }

    private TransformerFunction regexReplace() {
        return this.regexReplace;
    }

    private TransformerFunction substr() {
        return this.substr;
    }

    private TransformerFunction strLen() {
        return this.strLen;
    }

    private TransformerFunction printf() {
        return this.printf;
    }
}

