/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.osm;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import de.topobyte.osm4j.core.access.OsmIterator;
import de.topobyte.osm4j.core.model.iface.EntityContainer;
import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import de.topobyte.osm4j.core.model.impl.Node;
import de.topobyte.osm4j.pbf.seq.PbfIterator;
import de.topobyte.osm4j.xml.dynsax.OsmXmlIterator;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.locationtech.geomesa.convert.ConvertParseOpts;
import org.locationtech.geomesa.convert.Counter;
import org.locationtech.geomesa.convert.EnrichmentCache;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert.Field;
import org.locationtech.geomesa.convert.SimpleFeatureConverter;
import org.locationtech.geomesa.convert.ToSimpleFeatureConverter;
import org.locationtech.geomesa.convert.Transformers;
import org.locationtech.geomesa.convert.osm.OsmField$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\t5c\u0001B\u0001\u0003\u00015\u0011\u0001cT:n/\u0006L8oQ8om\u0016\u0014H/\u001a:\u000b\u0005\r!\u0011aA8t[*\u0011QAB\u0001\bG>tg/\u001a:u\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qaC\u000b\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0019q\u0003\u0007\u000e\u000e\u0003\u0011I!!\u0007\u0003\u00031Q{7+[7qY\u00164U-\u0019;ve\u0016\u001cuN\u001c<feR,'\u000f\u0005\u0002\u001cQ5\tAD\u0003\u0002\u001e=\u0005)\u0011NZ1dK*\u0011q\u0004I\u0001\u0006[>$W\r\u001c\u0006\u0003C\t\nAaY8sK*\u00111\u0005J\u0001\u0006_NlGG\u001b\u0006\u0003K\u0019\n\u0001\u0002^8q_\nLH/\u001a\u0006\u0002O\u0005\u0011A-Z\u0005\u0003Sq\u0011aaT:n/\u0006L\bCA\u00163\u001b\u0005a#BA\u0017/\u00031\u00198-\u00197bY><w-\u001b8h\u0015\ty\u0003'\u0001\u0005usB,7/\u00194f\u0015\u0005\t\u0014aA2p[&\u00111\u0007\f\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\r\u0003\u00056\u0001\t\u0015\r\u0011\"\u00017\u0003%!\u0018M]4fiN3E+F\u00018!\tAt(D\u0001:\u0015\tQ4(\u0001\u0004tS6\u0004H.\u001a\u0006\u0003yu\nqAZ3biV\u0014XM\u0003\u0002?\u0015\u00059q\u000e]3oO&\u001c\u0018B\u0001!:\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005o\u0005QA/\u0019:hKR\u001cf\t\u0016\u0011\t\u0011\u0011\u0003!Q1A\u0005\u0002\u0015\u000b\u0011\"\u001b3Ck&dG-\u001a:\u0016\u0003\u0019\u0003\"aR+\u000f\u0005!\u001bfBA%S\u001d\tQ\u0015K\u0004\u0002L!:\u0011AjT\u0007\u0002\u001b*\u0011a\nD\u0001\u0007yI|w\u000e\u001e \n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t!F!\u0001\u0007Ue\u0006t7OZ8s[\u0016\u00148/\u0003\u0002W/\n!Q\t\u001f9s\u0015\t!F\u0001\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003G\u0003)IGMQ;jY\u0012,'\u000f\t\u0005\t7\u0002\u0011)\u0019!C\u00019\u0006Y\u0011N\u001c9vi\u001aKW\r\u001c3t+\u0005i\u0006c\u00010fO6\tqL\u0003\u0002aC\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003E\u000e\f!bY8mY\u0016\u001cG/[8o\u0015\u0005!\u0017!B:dC2\f\u0017B\u00014`\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\t\u0003/!L!!\u001b\u0003\u0003\u000b\u0019KW\r\u001c3\t\u0011-\u0004!\u0011!Q\u0001\nu\u000bA\"\u001b8qkR4\u0015.\u001a7eg\u0002B\u0001\"\u001c\u0001\u0003\u0006\u0004%\tA\\\u0001\u0010kN,'\u000fR1uC\n+\u0018\u000e\u001c3feV\tq\u000e\u0005\u0003qi^4eBA9s\u001b\u0005\u0019\u0017BA:d\u0003\u0019\u0001&/\u001a3fM&\u0011QO\u001e\u0002\u0004\u001b\u0006\u0004(BA:d!\t\u0001\b0\u0003\u0002zm\n11\u000b\u001e:j]\u001eD\u0001b\u001f\u0001\u0003\u0002\u0003\u0006Ia\\\u0001\u0011kN,'\u000fR1uC\n+\u0018\u000e\u001c3fe\u0002B\u0001\" \u0001\u0003\u0006\u0004%\tA`\u0001\u0007G\u0006\u001c\u0007.Z:\u0016\u0003}\u0004R\u0001\u001d;x\u0003\u0003\u00012aFA\u0002\u0013\r\t)\u0001\u0002\u0002\u0010\u000b:\u0014\u0018n\u00195nK:$8)Y2iK\"I\u0011\u0011\u0002\u0001\u0003\u0002\u0003\u0006Ia`\u0001\bG\u0006\u001c\u0007.Z:!\u0011)\ti\u0001\u0001BC\u0002\u0013\u0005\u0011qB\u0001\na\u0006\u00148/Z(qiN,\"!!\u0005\u0011\u0007]\t\u0019\"C\u0002\u0002\u0016\u0011\u0011\u0001cQ8om\u0016\u0014H\u000fU1sg\u0016|\u0005\u000f^:\t\u0015\u0005e\u0001A!A!\u0002\u0013\t\t\"\u0001\u0006qCJ\u001cXm\u00149ug\u0002B!\"!\b\u0001\u0005\u000b\u0007I\u0011AA\u0010\u0003\r\u0001(MZ\u000b\u0003\u0003C\u00012!]A\u0012\u0013\r\t)c\u0019\u0002\b\u0005>|G.Z1o\u0011)\tI\u0003\u0001B\u0001B\u0003%\u0011\u0011E\u0001\u0005a\n4\u0007\u0005\u0003\u0006\u0002.\u0001\u0011)\u0019!C\u0001\u0003?\tQB\\3fINlU\r^1eCR\f\u0007BCA\u0019\u0001\t\u0005\t\u0015!\u0003\u0002\"\u0005qa.Z3eg6+G/\u00193bi\u0006\u0004\u0003BCA\u001b\u0001\t\u0005\t\u0015!\u0003\u00028\u0005Q1m\u001c8oK\u000e$\u0018n\u001c8\u0011\t\u0005e\u0012qH\u0007\u0003\u0003wQ1!!\u0010\u0013\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003\u0003\nYD\u0001\u0006D_:tWm\u0019;j_:Dq!!\u0012\u0001\t\u0003\t9%\u0001\u0004=S:LGO\u0010\u000b\u0015\u0003\u0013\ni%a\u0014\u0002R\u0005M\u0013QKA,\u00033\nY&!\u0018\u0011\u0007\u0005-\u0003!D\u0001\u0003\u0011\u0019)\u00141\ta\u0001o!1A)a\u0011A\u0002\u0019CaaWA\"\u0001\u0004i\u0006BB7\u0002D\u0001\u0007q\u000e\u0003\u0004~\u0003\u0007\u0002\ra \u0005\t\u0003\u001b\t\u0019\u00051\u0001\u0002\u0012!A\u0011QDA\"\u0001\u0004\t\t\u0003\u0003\u0005\u0002.\u0005\r\u0003\u0019AA\u0011\u0011!\t)$a\u0011A\u0002\u0005]\u0002bBA1\u0001\u0011%\u00111M\u0001\u0003O\u001a,\"!!\u001a\u0011\t\u0005\u001d\u0014QO\u0007\u0003\u0003SRA!a\u001b\u0002n\u0005!q-Z8n\u0015\u0011\ty'!\u001d\u0002\u0007)$8OC\u0002\u0002tA\naB^5wS\u0012\u001cx\u000e\\;uS>t7/\u0003\u0003\u0002x\u0005%$aD$f_6,GO]=GC\u000e$xN]=\t\u0013\u0005m\u0004A1A\u0005\n\u0005u\u0014a\u0002;p\u0003J\u0014\u0018-_\u000b\u0003\u0003\u007f\u0002\u0012\"]AA\u0003\u000b\u000bY)!%\n\u0007\u0005\r5MA\u0005Gk:\u001cG/[8oeA\u00191$a\"\n\u0007\u0005%EDA\u0005Pg6,e\u000e^5usB!\u0011qMAG\u0013\u0011\ty)!\u001b\u0003\u0011\u001d+w.\\3uef\u0004R!]AJ\u0003/K1!!&d\u0005\u0015\t%O]1z!\r\t\u0018\u0011T\u0005\u0004\u00037\u001b'aA!os\"A\u0011q\u0014\u0001!\u0002\u0013\ty(\u0001\u0005u_\u0006\u0013(/Y=!\u0011%\t\u0019\u000b\u0001b\u0001\n\u0013\t)+A\bj]N,'\u000f^*uCR,W.\u001a8u+\t\t9\u000b\u0005\u0003\u0002:\u0005%\u0016\u0002BAV\u0003w\u0011\u0011\u0003\u0015:fa\u0006\u0014X\rZ*uCR,W.\u001a8u\u0011!\ty\u000b\u0001Q\u0001\n\u0005\u001d\u0016\u0001E5og\u0016\u0014Ho\u0015;bi\u0016lWM\u001c;!\u0011\u001d\t\u0019\f\u0001C!\u0003k\u000bQB\u001a:p[&s\u0007/\u001e;UsB,GCBA\\\u0003\u0013\fi\r\u0005\u0004\u0002:\u0006\r\u0017\u0011\u0013\b\u0005\u0003w\u000byLD\u0002M\u0003{K\u0011\u0001Z\u0005\u0004\u0003\u0003\u001c\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003\u000b\f9M\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\t\tm\u0019\u0005\b\u0003\u0017\f\t\f1\u0001\u001b\u0003\u0005I\u0007\u0002CAh\u0003c\u0003\r!!5\u0002\u0005\u0015\u001c\u0007cA\f\u0002T&\u0019\u0011Q\u001b\u0003\u0003#\u00153\u0018\r\\;bi&|gnQ8oi\u0016DH\u000fC\u0004\u0002Z\u0002!\t%a7\u0002\u000fA\u0014xnY3tgR1\u0011Q\\As\u0003k\u0004b!!/\u0002D\u0006}\u0007c\u0001\u001d\u0002b&\u0019\u00111]\u001d\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0011!\t9/a6A\u0002\u0005%\u0018AA5t!\u0011\tY/!=\u000e\u0005\u00055(bAAx%\u0005\u0011\u0011n\\\u0005\u0005\u0003g\fiOA\u0006J]B,Ho\u0015;sK\u0006l\u0007BCAh\u0003/\u0004\n\u00111\u0001\u0002R\"9\u0011\u0011 \u0001\u0005\n\u0005m\u0018\u0001E2sK\u0006$XMT8eKN$\u0016M\u00197f)\t\ti\u0010E\u0002r\u0003\u007fL1A!\u0001d\u0005\u0011)f.\u001b;\t\u000f\t\u0015\u0001\u0001\"\u0003\u0003\b\u0005Q\u0011N\\:feRtu\u000eZ3\u0015\t\u0005u(\u0011\u0002\u0005\t\u0005\u0017\u0011\u0019\u00011\u0001\u0003\u000e\u0005!an\u001c3f!\rY\"qB\u0005\u0004\u0005#a\"aB(t[:{G-\u001a\u0005\b\u0005+\u0001A\u0011\u0002B\f\u0003-\u0019X\r\\3di:{G-Z:\u0015\t\te!\u0011\u0005\t\u0007aR\u0014YB!\u0004\u0011\u0007E\u0014i\"C\u0002\u0003 \r\u0014A\u0001T8oO\"A!1\u0005B\n\u0001\u0004\u0011)#A\u0002jIN\u0004b!!/\u0003(\tm\u0011\u0002\u0002B\u0015\u0003\u000f\u00141aU3r\u0011\u001d\u0011i\u0003\u0001C\t\u0003w\fa\u0002\u001a:pa:{G-Z:UC\ndW\rC\u0004\u00032\u0001!\t%a?\u0002\u000b\rdwn]3\t\u0013\tU\u0002!%A\u0005B\t]\u0012!\u00059s_\u000e,7o\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\b\u0016\u0005\u0003#\u0014Yd\u000b\u0002\u0003>A!!q\bB%\u001b\t\u0011\tE\u0003\u0003\u0003D\t\u0015\u0013!C;oG\",7m[3e\u0015\r\u00119eY\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B&\u0005\u0003\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class OsmWaysConverter
implements ToSimpleFeatureConverter<OsmWay> {
    private final SimpleFeatureType targetSFT;
    private final Transformers.Expr idBuilder;
    private final IndexedSeq<Field> inputFields;
    private final Map<String, Transformers.Expr> userDataBuilder;
    private final Map<String, EnrichmentCache> caches;
    private final ConvertParseOpts parseOpts;
    private final boolean pbf;
    private final boolean needsMetadata;
    public final Connection org$locationtech$geomesa$convert$osm$OsmWaysConverter$$connection;
    private final Function2<OsmEntity, Geometry, Object[]> toArray;
    private final PreparedStatement insertStatement;
    private final Function2<SimpleFeature, EvaluationContext, SimpleFeature> validate;
    private final IndexedSeq<Field> requiredFields;
    private final int requiredFieldsCount;
    private final IndexedSeq<Object> requiredFieldsIndices;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public Function2<SimpleFeature, EvaluationContext, SimpleFeature> validate() {
        return this.validate;
    }

    public IndexedSeq<Field> requiredFields() {
        return this.requiredFields;
    }

    public int requiredFieldsCount() {
        return this.requiredFieldsCount;
    }

    public IndexedSeq<Object> requiredFieldsIndices() {
        return this.requiredFieldsIndices;
    }

    public void org$locationtech$geomesa$convert$ToSimpleFeatureConverter$_setter_$validate_$eq(Function2 x$1) {
        this.validate = x$1;
    }

    public void org$locationtech$geomesa$convert$ToSimpleFeatureConverter$_setter_$requiredFields_$eq(IndexedSeq x$1) {
        this.requiredFields = x$1;
    }

    public void org$locationtech$geomesa$convert$ToSimpleFeatureConverter$_setter_$requiredFieldsCount_$eq(int x$1) {
        this.requiredFieldsCount = x$1;
    }

    public void org$locationtech$geomesa$convert$ToSimpleFeatureConverter$_setter_$requiredFieldsIndices_$eq(IndexedSeq x$1) {
        this.requiredFieldsIndices = x$1;
    }

    public SimpleFeature convert(Object[] t, EvaluationContext ec) {
        return ToSimpleFeatureConverter.class.convert((ToSimpleFeatureConverter)this, (Object[])t, (EvaluationContext)ec);
    }

    public Iterator processSingleInput(Object i, EvaluationContext ec) {
        return ToSimpleFeatureConverter.class.processSingleInput((ToSimpleFeatureConverter)this, (Object)i, (EvaluationContext)ec);
    }

    public EvaluationContext createEvaluationContext(Map<String, Object> globalParams, Counter counter) {
        return ToSimpleFeatureConverter.class.createEvaluationContext((ToSimpleFeatureConverter)this, globalParams, (Counter)counter);
    }

    public Iterator<SimpleFeature> processInput(Iterator<OsmWay> is, EvaluationContext ec) {
        return ToSimpleFeatureConverter.class.processInput((ToSimpleFeatureConverter)this, is, (EvaluationContext)ec);
    }

    private Logger logger$lzycompute() {
        OsmWaysConverter osmWaysConverter = this;
        synchronized (osmWaysConverter) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Map<String, Object> createEvaluationContext$default$1() {
        return SimpleFeatureConverter.class.createEvaluationContext$default$1((SimpleFeatureConverter)this);
    }

    public Counter createEvaluationContext$default$2() {
        return SimpleFeatureConverter.class.createEvaluationContext$default$2((SimpleFeatureConverter)this);
    }

    public EvaluationContext processInput$default$2() {
        return SimpleFeatureConverter.class.processInput$default$2((SimpleFeatureConverter)this);
    }

    public EvaluationContext processSingleInput$default$2() {
        return SimpleFeatureConverter.class.processSingleInput$default$2((SimpleFeatureConverter)this);
    }

    public SimpleFeatureType targetSFT() {
        return this.targetSFT;
    }

    public Transformers.Expr idBuilder() {
        return this.idBuilder;
    }

    public IndexedSeq<Field> inputFields() {
        return this.inputFields;
    }

    public Map<String, Transformers.Expr> userDataBuilder() {
        return this.userDataBuilder;
    }

    public Map<String, EnrichmentCache> caches() {
        return this.caches;
    }

    public ConvertParseOpts parseOpts() {
        return this.parseOpts;
    }

    public boolean pbf() {
        return this.pbf;
    }

    public boolean needsMetadata() {
        return this.needsMetadata;
    }

    private GeometryFactory gf() {
        return JTSFactoryFinder.getGeometryFactory();
    }

    private Function2<OsmEntity, Geometry, Object[]> toArray() {
        return this.toArray;
    }

    private PreparedStatement insertStatement() {
        return this.insertStatement;
    }

    public Iterator<Object[]> fromInputType(OsmWay i, EvaluationContext ec) {
        Iterator iterator;
        BoxedUnit boxedUnit;
        Map<Object, OsmNode> selected;
        Seq nodeIds = (Seq)((TraversableLike)Seq$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)i.getNumberOfNodes()), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1)new Serializable(this, i){
            public static final long serialVersionUID = 0L;
            private final OsmWay i$1;

            public final long apply(int x$1) {
                return this.apply$mcJI$sp(x$1);
            }

            public long apply$mcJI$sp(int x$1) {
                return this.i$1.getNodeId(x$1);
            }
            {
                this.i$1 = i$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq nodes = (Seq)nodeIds.flatMap((Function1)new Serializable(this, selected = this.selectNodes((Seq<Object>)nodeIds)){
            public static final long serialVersionUID = 0L;
            private final Map selected$1;

            public final Iterable<OsmNode> apply(long key) {
                return Option$.MODULE$.option2Iterable(this.selected$1.get((Object)BoxesRunTime.boxToLong((long)key)));
            }
            {
                this.selected$1 = selected$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (nodes.size() != nodeIds.length()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dropping references to non-existing nodes in way '", "': "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)i.getId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)nodeIds.filterNot((Function1)new Serializable(this, nodes){
                    public static final long serialVersionUID = 0L;
                    private final Seq nodes$1;

                    public final boolean apply(Object elem) {
                        return this.nodes$1.contains(elem);
                    }
                    {
                        this.nodes$1 = nodes$1;
                    }
                })).mkString(", ")}))).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (nodes.size() < 2) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dropping way '", "' because it does not have enough valid nodes to form a linestring"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)i.getId())})));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            iterator = package$.MODULE$.Iterator().empty();
        } else {
            Seq coords = (Seq)nodes.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Coordinate apply(OsmNode n) {
                    return new Coordinate(n.getLongitude(), n.getLatitude());
                }
            }, Seq$.MODULE$.canBuildFrom());
            iterator = package$.MODULE$.Iterator().single(this.toArray().apply((Object)i, (Object)this.gf().createLineString((Coordinate[])coords.toArray(ClassTag$.MODULE$.apply(Coordinate.class)))));
        }
        return iterator;
    }

    public Iterator<SimpleFeature> process(InputStream is, EvaluationContext ec) {
        PbfIterator iterator = this.pbf() ? new PbfIterator(is, this.needsMetadata()) : new OsmXmlIterator(is, this.needsMetadata());
        ObjectRef element = ObjectRef.create((Object)this.org$locationtech$geomesa$convert$osm$OsmWaysConverter$$nextElement$1((OsmIterator)iterator));
        while ((EntityContainer)element.elem != null) {
            EntityType entityType = ((EntityContainer)element.elem).getType();
            EntityType entityType2 = EntityType.Node;
            if (entityType != null ? !entityType.equals(entityType2) : entityType2 != null) break;
            this.insertNode((OsmNode)((EntityContainer)element.elem).getEntity());
            element.elem = this.org$locationtech$geomesa$convert$osm$OsmWaysConverter$$nextElement$1((OsmIterator)iterator);
        }
        Iterator<OsmWay> entities = new Iterator<OsmWay>(this, (OsmIterator)iterator, element){
            private final /* synthetic */ OsmWaysConverter $outer;
            private final OsmIterator iterator$1;
            private final ObjectRef element$1;

            public Iterator<OsmWay> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<OsmWay> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<OsmWay> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<OsmWay> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<OsmWay, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<OsmWay, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<OsmWay> filter(Function1<OsmWay, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<OsmWay, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<OsmWay> withFilter(Function1<OsmWay, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<OsmWay> filterNot(Function1<OsmWay, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<OsmWay, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, OsmWay, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<OsmWay, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<OsmWay> takeWhile(Function1<OsmWay, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<OsmWay>, Iterator<OsmWay>> partition(Function1<OsmWay, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<OsmWay>, Iterator<OsmWay>> span(Function1<OsmWay, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<OsmWay> dropWhile(Function1<OsmWay, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<OsmWay, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<OsmWay, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<OsmWay, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<OsmWay, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<OsmWay, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<OsmWay> find(Function1<OsmWay, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<OsmWay, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<OsmWay> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.class.grouped((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<OsmWay>, Iterator<OsmWay>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<OsmWay> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<OsmWay> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<OsmWay> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<OsmWay> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<OsmWay, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<OsmWay, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, OsmWay, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<OsmWay, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, OsmWay, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<OsmWay, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, OsmWay, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<OsmWay, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, OsmWay, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<OsmWay, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, OsmWay, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<OsmWay> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<OsmWay> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<OsmWay> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<OsmWay> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<OsmWay> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, OsmWay, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<OsmWay, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if ((EntityContainer)this.element$1.elem == null) return false;
                EntityType entityType = ((EntityContainer)this.element$1.elem).getType();
                EntityType entityType2 = EntityType.Way;
                if (entityType != null) {
                    if (!entityType.equals(entityType2)) return false;
                    return true;
                }
                if (entityType2 == null) return true;
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public OsmWay next() {
                void var1_1;
                OsmWay ret = (OsmWay)((EntityContainer)this.element$1.elem).getEntity();
                this.element$1.elem = this.$outer.org$locationtech$geomesa$convert$osm$OsmWaysConverter$$nextElement$1(this.iterator$1);
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.iterator$1 = iterator$1;
                this.element$1 = element$1;
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
            }
        };
        return this.processInput(entities, ec);
    }

    public EvaluationContext process$default$2() {
        return this.createEvaluationContext(this.createEvaluationContext$default$1(), this.createEvaluationContext$default$2());
    }

    private void createNodesTable() {
        String sql = "create table nodes(id BIGINT NOT NULL PRIMARY KEY, lon DOUBLE, lat DOUBLE);";
        PreparedStatement stmt = this.org$locationtech$geomesa$convert$osm$OsmWaysConverter$$connection.prepareStatement(sql);
        stmt.execute();
        stmt.close();
    }

    private void insertNode(OsmNode node) {
        this.insertStatement().setLong(1, node.getId());
        this.insertStatement().setDouble(2, node.getLongitude());
        this.insertStatement().setDouble(3, node.getLatitude());
        this.insertStatement().executeUpdate();
    }

    private Map<Object, OsmNode> selectNodes(Seq<Object> ids) {
        scala.collection.mutable.Map map = Map$.MODULE$.empty();
        ids.grouped(99).foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OsmWaysConverter $outer;
            private final scala.collection.mutable.Map map$1;

            public final void apply(Seq<Object> group) {
                CallableStatement statement = this.$outer.org$locationtech$geomesa$convert$osm$OsmWaysConverter$$connection.prepareCall(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM nodes WHERE id IN(", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{group.mkString(",")})));
                ResultSet results = statement.executeQuery();
                while (results.next()) {
                    Node node = new Node(results.getLong(1), results.getDouble(2), results.getDouble(3));
                    this.map$1.put((Object)BoxesRunTime.boxToLong((long)node.getId()), (Object)node);
                }
                results.close();
                statement.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$1 = map$1;
            }
        });
        return map.toMap(Predef$.MODULE$.$conforms());
    }

    public void dropNodesTable() {
        String sql = "drop table nodes;";
        PreparedStatement stmt = this.org$locationtech$geomesa$convert$osm$OsmWaysConverter$$connection.prepareStatement(sql);
        stmt.execute();
        stmt.close();
    }

    public void close() {
        this.insertStatement().close();
        this.dropNodesTable();
        this.org$locationtech$geomesa$convert$osm$OsmWaysConverter$$connection.close();
    }

    public final EntityContainer org$locationtech$geomesa$convert$osm$OsmWaysConverter$$nextElement$1(OsmIterator iterator$1) {
        return iterator$1.hasNext() ? (EntityContainer)iterator$1.next() : null;
    }

    public OsmWaysConverter(SimpleFeatureType targetSFT, Transformers.Expr idBuilder, IndexedSeq<Field> inputFields, Map<String, Transformers.Expr> userDataBuilder, Map<String, EnrichmentCache> caches, ConvertParseOpts parseOpts, boolean pbf, boolean needsMetadata, Connection connection) {
        this.targetSFT = targetSFT;
        this.idBuilder = idBuilder;
        this.inputFields = inputFields;
        this.userDataBuilder = userDataBuilder;
        this.caches = caches;
        this.parseOpts = parseOpts;
        this.pbf = pbf;
        this.needsMetadata = needsMetadata;
        this.org$locationtech$geomesa$convert$osm$OsmWaysConverter$$connection = connection;
        SimpleFeatureConverter.class.$init$((SimpleFeatureConverter)this);
        LazyLogging.class.$init$((LazyLogging)this);
        ToSimpleFeatureConverter.class.$init$((ToSimpleFeatureConverter)this);
        this.toArray = needsMetadata ? new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object[] apply(OsmEntity entity, Geometry geometry) {
                return OsmField$.MODULE$.toArrayWithMetadata(entity, geometry);
            }
        } : new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object[] apply(OsmEntity entity, Geometry geometry) {
                return OsmField$.MODULE$.toArrayNoMetadata(entity, geometry);
            }
        };
        this.createNodesTable();
        this.insertStatement = connection.prepareStatement("INSERT INTO nodes(id, lon, lat) VALUES (?, ?, ?);");
    }
}

