/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.osm;

import com.typesafe.config.Config;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import org.locationtech.geomesa.convert.AbstractSimpleFeatureConverterFactory;
import org.locationtech.geomesa.convert.ConvertParseOpts;
import org.locationtech.geomesa.convert.EnrichmentCache;
import org.locationtech.geomesa.convert.Field;
import org.locationtech.geomesa.convert.SimpleFeatureConverter;
import org.locationtech.geomesa.convert.Transformers;
import org.locationtech.geomesa.convert.osm.OsmField$;
import org.locationtech.geomesa.convert.osm.OsmWaysConverter;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0001\u0003\u00015\u0011qcT:n/\u0006L8oQ8om\u0016\u0014H/\u001a:GC\u000e$xN]=\u000b\u0005\r!\u0011aA8t[*\u0011QAB\u0001\bG>tg/\u001a:u\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001cA\b\u0011%5\tA!\u0003\u0002\u0012\t\t)\u0013IY:ue\u0006\u001cGoU5na2,g)Z1ukJ,7i\u001c8wKJ$XM\u001d$bGR|'/\u001f\t\u0003'\u0001j\u0011\u0001\u0006\u0006\u0003+Y\tQ!\u001b4bG\u0016T!a\u0006\r\u0002\u000b5|G-\u001a7\u000b\u0005eQ\u0012\u0001B2pe\u0016T!a\u0007\u000f\u0002\u000b=\u001cX\u000e\u000e6\u000b\u0005uq\u0012\u0001\u0003;pa>\u0014\u0017\u0010^3\u000b\u0003}\t!\u0001Z3\n\u0005\u0005\"\"AB(t[^\u000b\u0017\u0010C\u0003$\u0001\u0011\u0005A%\u0001\u0004=S:LGO\u0010\u000b\u0002KA\u0011a\u0005A\u0007\u0002\u0005!9\u0001\u0006\u0001b\u0001\n#J\u0013!\u0004;za\u0016$v\u000e\u0015:pG\u0016\u001c8/F\u0001+!\tY\u0003'D\u0001-\u0015\tic&\u0001\u0003mC:<'\"A\u0018\u0002\t)\fg/Y\u0005\u0003c1\u0012aa\u0015;sS:<\u0007BB\u001a\u0001A\u0003%!&\u0001\busB,Gk\u001c)s_\u000e,7o\u001d\u0011\t\u000bU\u0002A\u0011\u000b\u001c\u0002\u001d\t,\u0018\u000e\u001c3D_:4XM\u001d;feRQqG\u000f$SMV\f\u0019!a\u0004\u0011\u0007=A$#\u0003\u0002:\t\t12+[7qY\u00164U-\u0019;ve\u0016\u001cuN\u001c<feR,'\u000fC\u0003<i\u0001\u0007A(A\u0002tMR\u0004\"!\u0010#\u000e\u0003yR!a\u0010!\u0002\rMLW\u000e\u001d7f\u0015\t\t%)A\u0004gK\u0006$XO]3\u000b\u0005\rS\u0011aB8qK:<\u0017n]\u0005\u0003\u000bz\u0012\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0011\u00159E\u00071\u0001I\u0003\u0011\u0019wN\u001c4\u0011\u0005%\u0003V\"\u0001&\u000b\u0005-c\u0015AB2p]\u001aLwM\u0003\u0002N\u001d\u0006AA/\u001f9fg\u00064WMC\u0001P\u0003\r\u0019w.\\\u0005\u0003#*\u0013aaQ8oM&<\u0007\"B*5\u0001\u0004!\u0016!C5e\u0005VLG\u000eZ3s!\t)6M\u0004\u0002WC:\u0011q\u000b\u0019\b\u00031~s!!\u00170\u000f\u0005ikV\"A.\u000b\u0005qc\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003E\u0012\tA\u0002\u0016:b]N4wN]7feNL!\u0001Z3\u0003\t\u0015C\bO\u001d\u0006\u0003E\u0012AQa\u001a\u001bA\u0002!\faAZ5fY\u0012\u001c\bcA5qe6\t!N\u0003\u0002lY\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003[:\f!bY8mY\u0016\u001cG/[8o\u0015\u0005y\u0017!B:dC2\f\u0017BA9k\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\t\u0003\u001fML!\u0001\u001e\u0003\u0003\u000b\u0019KW\r\u001c3\t\u000bY$\u0004\u0019A<\u0002\u001fU\u001cXM\u001d#bi\u0006\u0014U/\u001b7eKJ\u0004B\u0001\u001f?\u0000):\u0011\u0011P_\u0007\u0002]&\u00111P\\\u0001\u0007!J,G-\u001a4\n\u0005ut(aA'ba*\u00111P\u001c\t\u0004q\u0006\u0005\u0011BA\u0019\u007f\u0011\u001d\t)\u0001\u000ea\u0001\u0003\u000f\tQbY1dQ\u0016\u001cVM\u001d<jG\u0016\u001c\b#\u0002=}\u007f\u0006%\u0001cA\b\u0002\f%\u0019\u0011Q\u0002\u0003\u0003\u001f\u0015s'/[2i[\u0016tGoQ1dQ\u0016Dq!!\u00055\u0001\u0004\t\u0019\"A\u0005qCJ\u001cXm\u00149ugB\u0019q\"!\u0006\n\u0007\u0005]AA\u0001\tD_:4XM\u001d;QCJ\u001cXm\u00149ug\"9\u00111\u0004\u0001\u0005R\u0005u\u0011A\u00032vS2$g)[3mIR\u0019!/a\b\t\u000f\u0005\u0005\u0012\u0011\u0004a\u0001\u0011\u0006)a-[3mI\u0002")
public class OsmWaysConverterFactory
extends AbstractSimpleFeatureConverterFactory<OsmWay> {
    private final String typeToProcess;

    public String typeToProcess() {
        return this.typeToProcess;
    }

    public SimpleFeatureConverter<OsmWay> buildConverter(SimpleFeatureType sft, Config conf, Transformers.Expr idBuilder, IndexedSeq<Field> fields, Map<String, Transformers.Expr> userDataBuilder, Map<String, EnrichmentCache> cacheServices, ConvertParseOpts parseOpts) {
        OsmWaysConverter osmWaysConverter;
        boolean pbf = conf.hasPath("format") ? conf.getString("format").toLowerCase().trim().equals("pbf") : false;
        boolean needsMetadata = OsmField$.MODULE$.requiresMetadata((Seq<Field>)fields);
        if (conf.hasPath("jdbc")) {
            Connection connection = DriverManager.getConnection(conf.getString("jdbc"));
            osmWaysConverter = new OsmWaysConverter(sft, idBuilder, fields, userDataBuilder, cacheServices, parseOpts, pbf, needsMetadata, connection);
        } else {
            File h2Dir = Files.createTempDirectory("geomesa-convert-h2", new FileAttribute[0]).toFile();
            Class.forName("org.h2.Driver");
            Connection connection = DriverManager.getConnection(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdbc:h2:split:", "/osm"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{h2Dir.getAbsolutePath()})));
            osmWaysConverter = new OsmWaysConverter(this, sft, idBuilder, fields, userDataBuilder, cacheServices, parseOpts, pbf, needsMetadata, h2Dir, connection){
                private final File h2Dir$1;

                public void dropNodesTable() {
                    PathUtils$.MODULE$.deleteRecursively(this.h2Dir$1.toPath());
                }
                {
                    this.h2Dir$1 = h2Dir$1;
                    super(sft$1, idBuilder$1, (IndexedSeq<Field>)fields$1, (Map<String, Transformers.Expr>)userDataBuilder$1, (Map<String, EnrichmentCache>)cacheServices$1, parseOpts$1, pbf$1, needsMetadata$1, connection$1);
                }
            };
        }
        return osmWaysConverter;
    }

    public Field buildField(Config field) {
        return OsmField$.MODULE$.build(field);
    }

    public OsmWaysConverterFactory() {
        this.typeToProcess = "osm-ways";
    }
}

