/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.parquet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.locationtech.geomesa.convert.parquet.AvroReadSupport$;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.fs.storage.parquet.io.SimpleFeatureParquetSchema;
import org.locationtech.geomesa.fs.storage.parquet.io.SimpleFeatureParquetSchema$;
import org.locationtech.geomesa.fs.storage.parquet.io.SimpleFeatureReadSupport;
import org.locationtech.geomesa.fs.storage.parquet.io.SimpleFeatureReadSupport$;
import org.locationtech.geomesa.utils.geotools.ObjectType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011-c\u0001\u00028p\u0001iDq!!\b\u0001\t\u0003\ty\u0002C\u0005\u0002&\u0001\u0001\r\u0011\"\u0003\u0002(!I\u00111\n\u0001A\u0002\u0013%\u0011Q\n\u0005\t\u00033\u0002\u0001\u0015)\u0003\u0002*!9\u00111\f\u0001\u0005B\u0005u\u0003bBAI\u0001\u0011\u0005\u00131\u0013\u0005\b\u0003#\u0003A\u0011IAu\u000f\u001d\tip\u001cE\u0001\u0003\u007f4aA\\8\t\u0002\t\u0005\u0001bBA\u000f\u0013\u0011\u0005!\u0011\u0002\u0004\u0007\u0005\u0017I\u0001A!\u0004\t\u0015\u0005e7B!A!\u0002\u0013\tY\u000e\u0003\u0006\u0002&-\u0011\t\u0011)A\u0005\u0003SAq!!\b\f\t\u0003\u0011y\u0001C\u0005\u0003\u001a-\u0011\r\u0011\"\u0003\u0003\u001c!A!QZ\u0006!\u0002\u0013\u0011i\u0002C\u0004\u0003P.!\tEa3\t\u000f\tE7\u0002\"\u0011\u0003T\u001a1!qD\u0005\u0005\u0005CA!\"!7\u0014\u0005\u0003\u0005\u000b\u0011BAn\u0011)\t)c\u0005B\u0001B\u0003%\u0011\u0011\u0006\u0005\b\u0003;\u0019B\u0011\u0001B(\u0011%\u0011)f\u0005b\u0001\n\u0013\u00119\u0006\u0003\u0005\u0003bM\u0001\u000b\u0011\u0002B-\u0011%\u0011\u0019g\u0005b\u0001\n\u0013\u0011)\u0007\u0003\u0005\u0003zM\u0001\u000b\u0011\u0002B4\u0011%\u0011Yh\u0005b\u0001\n\u0013\u0011i\b\u0003\u0005\u0003\u0016N\u0001\u000b\u0011\u0002B@\u0011-\u0011\tk\u0005a\u0001\u0002\u0004%IAa)\t\u0017\t\u00156\u00031AA\u0002\u0013%!q\u0015\u0005\f\u0005W\u001b\u0002\u0019!A!B\u0013\ti\u0001C\u0004\u0003.N!\tEa,\t\u000f\t\u00057\u0003\"\u0011\u0003D\"9!QY\n\u0005B\t\r\u0007b\u0002Bd'\u0011\u0005#1\u0019\u0005\b\u0005\u0013\u001cB\u0011\tBf\u0011\u001d\u0011).\u0003C\u0005\u0005/4aA!:\n\t\t\u001d\bB\u0003B|M\t\u0005\t\u0015!\u0003\u0003z\"9\u0011Q\u0004\u0014\u0005\u0002\r%\u0001bCB\u000eM\u0001\u0007\t\u0019!C\u0005\u0007;A1ba\b'\u0001\u0004\u0005\r\u0011\"\u0003\u0004\"!Y1Q\u0005\u0014A\u0002\u0003\u0005\u000b\u0015\u0002By\u0011\u001d\u00199C\nC!\u0007SAqa!\u000e'\t\u0003\u001a9\u0004C\u0004\u0004B\u0019\"\tea\u0011\t\u000f\r\u001dc\u0005\"\u0011\u0004J!911\u000b\u0014\u0005B\rU\u0003bBB0M\u0011\u00053\u0011\r\u0005\b\u0007W2C\u0011\u0002Bb\u0011\u001d\u00119M\nC!\u0005\u0007DqA!3'\t\u0003\u001aiG\u0002\u0004\u0004p%!1\u0011\u000f\u0005\b\u0003;)D\u0011AB>\u0011%\u0019i#\u000ea\u0001\n\u0013\u0019y\bC\u0005\u0004\u0002V\u0002\r\u0011\"\u0003\u0004\u0004\"A1qQ\u001b!B\u0013\u0011Y\fC\u0005\u0004\nV\u0002\r\u0011\"\u0003\u0004\f\"I1QR\u001bA\u0002\u0013%1q\u0012\u0005\t\u0007'+\u0004\u0015)\u0003\u0004<!91\u0011I\u001b\u0005B\rU\u0005b\u0002Bdk\u0011\u0005#1\u0019\u0005\b\u0005\u0013,D\u0011IBM\r\u0019\u0019Y*\u0003\u0003\u0004\u001e\"9\u0011Q\u0004!\u0005\u0002\r}\u0005\"CB\u0017\u0001\u0002\u0007I\u0011BBR\u0011%\u0019\t\t\u0011a\u0001\n\u0013\u0019)\u000b\u0003\u0005\u0004\b\u0002\u0003\u000b\u0015BB-\u0011%\u0019I\t\u0011a\u0001\n\u0013\u0019Y\tC\u0005\u0004\u000e\u0002\u0003\r\u0011\"\u0003\u0004*\"A11\u0013!!B\u0013\u0019Y\u0004C\u0004\u0004T\u0001#\te!,\t\u000f\t\u001d\u0007\t\"\u0011\u0003D\"9!\u0011\u001a!\u0005B\reuaBBY\u0013!%51\u0017\u0004\b\u0007kK\u0001\u0012RB\\\u0011\u001d\ti\u0002\u0014C\u0001\u0007\u000fDqaa\nM\t\u0003\u001aI\rC\u0004\u000461#\te!4\t\u000f\r}C\n\"\u0011\u0004R\"91q\t'\u0005B\rU\u0007bBB!\u0019\u0012\u00053\u0011\u001c\u0005\b\u0007'bE\u0011IBo\u0011\u001d\u00119\r\u0014C!\u0005\u0007DqA!3M\t\u0003\u001a\t\u000fC\u0005\u0004d2\u000b\t\u0011\"\u0011\u0004f\"I1\u0011\u001f'\u0002\u0002\u0013\u00051q\u0010\u0005\n\u0007gd\u0015\u0011!C\u0001\u0007kD\u0011ba@M\u0003\u0003%\t\u0005\"\u0001\t\u0013\u0011%A*!A\u0005\u0002\u0011-\u0001\"\u0003C\b\u0019\u0006\u0005I\u0011\tC\t\u0011%!\u0019\u0002TA\u0001\n\u0003\")\u0002C\u0005\u0005\u00181\u000b\t\u0011\"\u0003\u0005\u001a\u00191A\u0011E\u0005\u0005\tGAq!!\b_\t\u0003!)\u0003C\u0005\u0004.y\u0003\r\u0011\"\u0003\u0005*!I1\u0011\u00110A\u0002\u0013%A1\u0006\u0005\t\u0007\u000fs\u0006\u0015)\u0003\u0004x\"I1\u0011\u00120A\u0002\u0013%11\u0012\u0005\n\u0007\u001bs\u0006\u0019!C\u0005\t_A\u0001ba%_A\u0003&11\b\u0005\b\u0007OqF\u0011\tC\u001a\u0011\u001d\u0019)D\u0018C!\toAqaa\u0018_\t\u0003\"Y\u0004C\u0004\u0004Hy#\t\u0005b\u0010\t\u000f\r\u0005c\f\"\u0011\u0005D!911\u000b0\u0005B\u0011\u001d\u0003b\u0002Bd=\u0012\u0005#1\u0019\u0005\b\u0005\u0013tF\u0011IBq\u0005=\teO]8SK\u0006$7+\u001e9q_J$(B\u00019r\u0003\u001d\u0001\u0018M]9vKRT!A]:\u0002\u000f\r|gN^3si*\u0011A/^\u0001\bO\u0016|W.Z:b\u0015\t1x/\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001y\u0003\ry'oZ\u0002\u0001'\t\u00011\u0010E\u0003}\u0003\u0013\ti!D\u0001~\u0015\tqx0A\u0002ba&TA!!\u0001\u0002\u0004\u00051\u0001.\u00193p_BT1\u0001]A\u0003\u0015\r\t9a^\u0001\u0007CB\f7\r[3\n\u0007\u0005-QPA\u0006SK\u0006$7+\u001e9q_J$\b\u0003BA\b\u00033i!!!\u0005\u000b\t\u0005M\u0011QC\u0001\bO\u0016tWM]5d\u0015\u0011\t9\"!\u0002\u0002\t\u00054(o\\\u0005\u0005\u00037\t\tBA\u0007HK:,'/[2SK\u000e|'\u000fZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005\u0005\u0002cAA\u0012\u00015\tq.\u0001\u0004tG\",W.Y\u000b\u0003\u0003S\u0001b!a\u000b\u00022\u0005URBAA\u0017\u0015\t\ty#A\u0003tG\u0006d\u0017-\u0003\u0003\u00024\u00055\"AB(qi&|g\u000e\u0005\u0003\u00028\u0005\u001dSBAA\u001d\u0015\u0011\tY$!\u0010\u0002\u0005%|'b\u00019\u0002@)!\u0011\u0011IA\"\u0003\u001d\u0019Ho\u001c:bO\u0016T1!!\u0012t\u0003\t17/\u0003\u0003\u0002J\u0005e\"AG*j[BdWMR3biV\u0014X\rU1scV,GoU2iK6\f\u0017AC:dQ\u0016l\u0017m\u0018\u0013fcR!\u0011qJA+!\u0011\tY#!\u0015\n\t\u0005M\u0013Q\u0006\u0002\u0005+:LG\u000fC\u0005\u0002X\r\t\t\u00111\u0001\u0002*\u0005\u0019\u0001\u0010J\u0019\u0002\u000fM\u001c\u0007.Z7bA\u0005!\u0011N\\5u)\u0011\ty&a\"\u0011\t\u0005\u0005\u0014\u0011\u0011\b\u0005\u0003G\niH\u0004\u0003\u0002f\u0005md\u0002BA4\u0003srA!!\u001b\u0002x9!\u00111NA;\u001d\u0011\ti'a\u001d\u000e\u0005\u0005=$bAA9s\u00061AH]8pizJ\u0011\u0001_\u0005\u0004\u0003\u000f9\u0018b\u00019\u0002\u0006%!\u0011\u0011AA\u0002\u0013\tqx0C\u0002\u0002\u0000u\f1BU3bIN+\b\u000f]8si&!\u00111QAC\u0005-\u0011V-\u00193D_:$X\r\u001f;\u000b\u0007\u0005}T\u0010C\u0004\u0002\n\u0016\u0001\r!a#\u0002\u000f\r|g\u000e^3yiB\u0019A0!$\n\u0007\u0005=UPA\u0006J]&$8i\u001c8uKb$\u0018A\u00049sKB\f'/\u001a$peJ+\u0017\r\u001a\u000b\u000b\u0003+\u000b\t+a-\u0002X\u0006\u0015\bCBAL\u0003;\u000bi!\u0004\u0002\u0002\u001a*\u0019a0a'\u000b\t\u0005m\u00121A\u0005\u0005\u0003?\u000bIJ\u0001\nSK\u000e|'\u000fZ'bi\u0016\u0014\u0018.\u00197ju\u0016\u0014\bbBAR\r\u0001\u0007\u0011QU\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\t\u0005\u001d\u0016qV\u0007\u0003\u0003SSA!a+\u0002.\u0006!1m\u001c8g\u0015\u0011\t\t!!\u0002\n\t\u0005E\u0016\u0011\u0016\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u0005Uf\u00011\u0001\u00028\u0006\u00012.Z=WC2,X-T3uC\u0012\u000bG/\u0019\t\t\u0003s\u000b\u0019-a2\u0002H6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,\u0001\u0003vi&d'BAAa\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00171\u0018\u0002\u0004\u001b\u0006\u0004\b\u0003BAe\u0003#tA!a3\u0002NB!\u0011QNA\u0017\u0013\u0011\ty-!\f\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019.!6\u0003\rM#(/\u001b8h\u0015\u0011\ty-!\f\t\u000f\u0005eg\u00011\u0001\u0002\\\u0006Qa-\u001b7f'\u000eDW-\\1\u0011\t\u0005u\u0017\u0011]\u0007\u0003\u0003?TA!!\n\u0002\u0004%!\u00111]Ap\u0005-iUm]:bO\u0016$\u0016\u0010]3\t\u000f\u0005\u001dh\u00011\u0001\u0002`\u0005Y!/Z1e\u0007>tG/\u001a=u))\t)*a;\u0002x\u0006e\u00181 \u0005\b\u0003G;\u0001\u0019AAw!\u0011\ty/a=\u000e\u0005\u0005E(\u0002BAV\u0003\u0007IA!!>\u0002r\n!\u0002+\u0019:rk\u0016$8i\u001c8gS\u001e,(/\u0019;j_:Dq!!.\b\u0001\u0004\t9\fC\u0004\u0002Z\u001e\u0001\r!a7\t\u000f\u0005\u001dx\u00011\u0001\u0002`\u0005y\u0011I\u001e:p%\u0016\fGmU;qa>\u0014H\u000fE\u0002\u0002$%\u00192!\u0003B\u0002!\u0011\tYC!\u0002\n\t\t\u001d\u0011Q\u0006\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005}(AF!we>\u0014VmY8sI6\u000bG/\u001a:jC2L'0\u001a:\u0014\u0007-\t)\n\u0006\u0004\u0003\u0012\tU!q\u0003\t\u0004\u0005'YQ\"A\u0005\t\u000f\u0005eg\u00021\u0001\u0002\\\"9\u0011Q\u0005\bA\u0002\u0005%\u0012\u0001\u0002:p_R,\"A!\b\u0011\u0007\tM1CA\u000bHK:,'/[2He>,\boQ8om\u0016\u0014H/\u001a:\u0014\u000bM\u0011\u0019C!\u000b\u0011\t\u0005]%QE\u0005\u0005\u0005O\tIJ\u0001\bHe>,\boQ8om\u0016\u0014H/\u001a:\u0011\r\t-\"\u0011JA\u0007\u001d\u0011\u0011iC!\u0012\u000f\t\t=\"1\t\b\u0005\u0005c\u0011\tE\u0004\u0003\u00034\t}b\u0002\u0002B\u001b\u0005{qAAa\u000e\u0003<9!\u00111\u000eB\u001d\u0013\t1x/\u0003\u0002uk&\u0019\u0011QI:\n\t\u0005\u0005\u00131I\u0005\u0004a\u0006}\u0012\u0002BA\u001e\u0003{IAAa\u0012\u0002:\u0005A2+[7qY\u00164U-\u0019;ve\u0016\u0014V-\u00193TkB\u0004xN\u001d;\n\t\t-#Q\n\u0002\u0012-\u0006dW/Z'bi\u0016\u0014\u0018.\u00197ju\u0016\u0014(\u0002\u0002B$\u0003s!bA!\b\u0003R\tM\u0003bBAm-\u0001\u0007\u00111\u001c\u0005\b\u0003K1\u0002\u0019AA\u0015\u0003)\tgO]8TG\",W.Y\u000b\u0003\u00053\u0002BAa\u0017\u0003^5\u0011\u0011QC\u0005\u0005\u0005?\n)B\u0001\u0004TG\",W.Y\u0001\fCZ\u0014xnU2iK6\f\u0007%\u0001\u0004gS\u0016dGm]\u000b\u0003\u0005O\u0002bA!\u001b\u0003p\tMTB\u0001B6\u0015\u0011\u0011i'!\f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003r\t-$aA*fcB!\u0011Q\u001cB;\u0013\u0011\u00119(a8\u0003\tQK\b/Z\u0001\bM&,G\u000eZ:!\u0003)\u0019wN\u001c<feR,'o]\u000b\u0003\u0005\u007f\u0002b!a\u000b\u0003\u0002\n\u0015\u0015\u0002\u0002BB\u0003[\u0011Q!\u0011:sCf\u0004DAa\"\u0003\u000eB1!1\u0006B%\u0005\u0013\u0003BAa#\u0003\u000e2\u0001A\u0001\u0004BH\u0005#\u000b\t\u0011!A\u0003\u0002\te%aA0%c!I!1\u0013\u000f\u0002\u0002\u0003\u0005!qS\u0001\tI\u0005twN\u001c4v]\u0006Y1m\u001c8wKJ$XM]:!\u0017\u0001\tBAa'\u0003\u0004A!\u00111\u0006BO\u0013\u0011\u0011y*!\f\u0003\u000f9{G\u000f[5oO\u0006\u0019!/Z2\u0016\u0005\u00055\u0011a\u0002:fG~#S-\u001d\u000b\u0005\u0003\u001f\u0012I\u000bC\u0005\u0002Xy\t\t\u00111\u0001\u0002\u000e\u0005!!/Z2!\u000319W\r^\"p]Z,'\u000f^3s)\u0011\u0011\tLa.\u0011\t\u0005]%1W\u0005\u0005\u0005k\u000bIJA\u0005D_:4XM\u001d;fe\"9!\u0011\u0018\u0011A\u0002\tm\u0016A\u00034jK2$\u0017J\u001c3fqB!\u00111\u0006B_\u0013\u0011\u0011y,!\f\u0003\u0007%sG/A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0002P\u0005\u0019QM\u001c3\u0002\u000bI,7/\u001a;\u0002\u00175\fG/\u001a:jC2L'0\u001a\u000b\u0003\u0003\u001b\tQA]8pi\u0002\n\u0001cZ3u\u0007V\u0014(/\u001a8u%\u0016\u001cwN\u001d3\u0002!\u001d,GOU8pi\u000e{gN^3si\u0016\u0014HC\u0001B\u0012\u0003%\u0019wN\u001c<feR,'\u000f\u0006\u0003\u0003Z\n\u0005\b\u0007\u0002Bn\u0005?\u0004bAa\u000b\u0003J\tu\u0007\u0003\u0002BF\u0005?$1Ba$&\u0003\u0003\u0005\tQ!\u0001\u0003\u001a\"9!1]\u0013A\u0002\tM\u0014!\u00024jK2$'A\u0007*fa\u0016\fG/\u001a3Qe&l\u0017\u000e^5wK\u000e{gN^3si\u0016\u00148#\u0002\u0014\u0003j\n=\b\u0003BAL\u0005WLAA!<\u0002\u001a\n\u0011\u0002K]5nSRLg/Z\"p]Z,'\u000f^3s!\u0019\u0011YC!\u0013\u0003rB1\u0011\u0011\u0018Bz\u0005\u0007IAA!>\u0002<\n!A*[:u\u0003!!W\r\\3hCR,'C\u0002B~\u0005S\u0014yP\u0002\u0004\u0003~&\u0001!\u0011 \u0002\ryI,g-\u001b8f[\u0016tGO\u0010\u0019\u0005\u0007\u0003\u0019)\u0001\u0005\u0004\u0003,\t%31\u0001\t\u0005\u0005\u0017\u001b)\u0001B\u0006\u0004\b\u001d\n\t\u0011!A\u0003\u0002\te%aA0%eQ!11BB\u0007!\r\u0011\u0019B\n\u0005\b\u0005oD\u0003\u0019AB\b%\u0019\u0019\tB!;\u0004\u0014\u00191!Q`\u0005\u0001\u0007\u001f\u0001Da!\u0006\u0004\u001aA1!1\u0006B%\u0007/\u0001BAa#\u0004\u001a\u0011a1qAB\u0007\u0003\u0003\u0005\tQ!\u0001\u0003\u001a\u0006!A.[:u+\t\u0011\t0\u0001\u0005mSN$x\fJ3r)\u0011\tyea\t\t\u0013\u0005]#&!AA\u0002\tE\u0018!\u00027jgR\u0004\u0013!C1eI\nKg.\u0019:z)\u0011\tyea\u000b\t\u000f\r5B\u00061\u0001\u00040\u0005)a/\u00197vKB!\u0011qSB\u0019\u0013\u0011\u0019\u0019$!'\u0003\r\tKg.\u0019:z\u0003)\tG\r\u001a\"p_2,\u0017M\u001c\u000b\u0005\u0003\u001f\u001aI\u0004C\u0004\u0004.5\u0002\raa\u000f\u0011\t\u0005-2QH\u0005\u0005\u0007\u007f\tiCA\u0004C_>dW-\u00198\u0002\r\u0005$G-\u00138u)\u0011\tye!\u0012\t\u000f\r5b\u00061\u0001\u0003<\u0006A\u0011\r\u001a3GY>\fG\u000f\u0006\u0003\u0002P\r-\u0003bBB\u0017_\u0001\u00071Q\n\t\u0005\u0003W\u0019y%\u0003\u0003\u0004R\u00055\"!\u0002$m_\u0006$\u0018aB1eI2{gn\u001a\u000b\u0005\u0003\u001f\u001a9\u0006C\u0004\u0004.A\u0002\ra!\u0017\u0011\t\u0005-21L\u0005\u0005\u0007;\niC\u0001\u0003M_:<\u0017!C1eI\u0012{WO\u00197f)\u0011\tyea\u0019\t\u000f\r5\u0012\u00071\u0001\u0004fA!\u00111FB4\u0013\u0011\u0019I'!\f\u0003\r\u0011{WO\u00197f\u0003)\tG\rZ#mK6,g\u000e\u001e\u000b\u0003\u0005c\u0014Q\u0002R1zg\u000e{gN^3si\u0016\u00148#B\u001b\u0003j\u000eM\u0004C\u0002B\u0016\u0005\u0013\u001a)\b\u0005\u0003\u0002:\u000e]\u0014\u0002BB=\u0003w\u0013A\u0001R1uKR\u00111Q\u0010\t\u0004\u0005')TC\u0001B^\u0003%1\u0018\r\\;f?\u0012*\u0017\u000f\u0006\u0003\u0002P\r\u0015\u0005\"CA,q\u0005\u0005\t\u0019\u0001B^\u0003\u00191\u0018\r\\;fA\u0005\u00191/\u001a;\u0016\u0005\rm\u0012aB:fi~#S-\u001d\u000b\u0005\u0003\u001f\u001a\t\nC\u0005\u0002Xm\n\t\u00111\u0001\u0004<\u0005!1/\u001a;!)\u0011\tyea&\t\u000f\r5R\b1\u0001\u0003<R\u00111Q\u000f\u0002\u000f\u001d\u0006twn]\"p]Z,'\u000f^3s'\u0015\u0001%\u0011^B:)\t\u0019\t\u000bE\u0002\u0003\u0014\u0001+\"a!\u0017\u0015\t\u0005=3q\u0015\u0005\n\u0003/\u001a\u0015\u0011!a\u0001\u00073\"B!a\u0014\u0004,\"I\u0011q\u000b$\u0002\u0002\u0003\u000711\b\u000b\u0005\u0003\u001f\u001ay\u000bC\u0004\u0004.!\u0003\ra!\u0017\u0002-9+H\u000e\u001c)sS6LG/\u001b<f\u0007>tg/\u001a:uKJ\u00042Aa\u0005M\u0005YqU\u000f\u001c7Qe&l\u0017\u000e^5wK\u000e{gN^3si\u0016\u00148#\u0003'\u0003j\u000ee61XBa!\u0019\u0011YC!\u0013\u0003\u0004A!\u00111FB_\u0013\u0011\u0019y,!\f\u0003\u000fA\u0013x\u000eZ;diB!\u00111FBb\u0013\u0011\u0019)-!\f\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\rMF\u0003BA(\u0007\u0017Dqa!\fO\u0001\u0004\u0019y\u0003\u0006\u0003\u0002P\r=\u0007bBB\u0017\u001f\u0002\u000711\b\u000b\u0005\u0003\u001f\u001a\u0019\u000eC\u0004\u0004.A\u0003\ra!\u001a\u0015\t\u0005=3q\u001b\u0005\b\u0007[\t\u0006\u0019AB')\u0011\tyea7\t\u000f\r5\"\u000b1\u0001\u0003<R!\u0011qJBp\u0011\u001d\u0019ic\u0015a\u0001\u00073\"\"Aa\u0001\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u00199\u000f\u0005\u0003\u0004j\u000e=XBABv\u0015\u0011\u0019i/a0\u0002\t1\fgnZ\u0005\u0005\u0003'\u001cY/\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\r]8Q \t\u0005\u0003W\u0019I0\u0003\u0003\u0004|\u00065\"aA!os\"I\u0011q\u000b-\u0002\u0002\u0003\u0007!1X\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011A1\u0001\t\u0007\u0005S\")aa>\n\t\u0011\u001d!1\u000e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0004<\u00115\u0001\"CA,5\u0006\u0005\t\u0019AB|\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B^\u0003!!xn\u0015;sS:<GCABt\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0011m\u0001\u0003BBu\t;IA\u0001b\b\u0004l\n1qJ\u00196fGR\u0014\u0011dR3oKJ\fG\u000e\u0015:j[&$\u0018N^3D_:4XM\u001d;feN)aL!;\u0004:R\u0011Aq\u0005\t\u0004\u0005'qVCAB|)\u0011\ty\u0005\"\f\t\u0013\u0005]\u0013-!AA\u0002\r]H\u0003BA(\tcA\u0011\"a\u0016e\u0003\u0003\u0005\raa\u000f\u0015\t\u0005=CQ\u0007\u0005\b\u0007[1\u0007\u0019AB\u0018)\u0011\ty\u0005\"\u000f\t\u000f\r5r\r1\u0001\u0004<Q!\u0011q\nC\u001f\u0011\u001d\u0019i\u0003\u001ba\u0001\u0007K\"B!a\u0014\u0005B!91QF5A\u0002\r5C\u0003BA(\t\u000bBqa!\fk\u0001\u0004\u0011Y\f\u0006\u0003\u0002P\u0011%\u0003bBB\u0017W\u0002\u00071\u0011\f")
public class AvroReadSupport
extends ReadSupport<GenericRecord> {
    private Option<SimpleFeatureParquetSchema> schema = None$.MODULE$;

    private Option<SimpleFeatureParquetSchema> schema() {
        return this.schema;
    }

    private void schema_$eq(Option<SimpleFeatureParquetSchema> x$1) {
        this.schema = x$1;
    }

    public ReadSupport.ReadContext init(InitContext context) {
        this.schema_$eq((Option<SimpleFeatureParquetSchema>)SimpleFeatureParquetSchema$.MODULE$.read(context));
        return new ReadSupport.ReadContext(context.getFileSchema(), (Map)this.schema().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.metadata()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Collections.emptyMap()));
    }

    public RecordMaterializer<GenericRecord> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return new AvroRecordMaterializer(fileSchema, this.schema());
    }

    public RecordMaterializer<GenericRecord> prepareForRead(ParquetConfiguration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return new AvroRecordMaterializer(fileSchema, this.schema());
    }

    public static class AvroRecordMaterializer
    extends RecordMaterializer<GenericRecord> {
        private final GenericGroupConverter root;

        private GenericGroupConverter root() {
            return this.root;
        }

        public GenericRecord getCurrentRecord() {
            return this.root().materialize();
        }

        public GroupConverter getRootConverter() {
            return this.root();
        }

        public AvroRecordMaterializer(MessageType fileSchema, Option<SimpleFeatureParquetSchema> schema) {
            this.root = new GenericGroupConverter(fileSchema, schema);
        }
    }

    private static class DaysConverter
    extends PrimitiveConverter
    implements SimpleFeatureReadSupport.ValueMaterializer<Date> {
        private int value = -1;
        private boolean set = false;

        private int value() {
            return this.value;
        }

        private void value_$eq(int x$1) {
            this.value = x$1;
        }

        private boolean set() {
            return this.set;
        }

        private void set_$eq(boolean x$1) {
            this.set = x$1;
        }

        public void addInt(int value) {
            this.value_$eq(value);
            this.set_$eq(true);
        }

        public void reset() {
            this.set_$eq(false);
        }

        public Date materialize() {
            if (this.set()) {
                return Date.from(BinnedTime$.MODULE$.Epoch().plusDays(this.value()).toInstant());
            }
            return null;
        }
    }

    private static class GeneralPrimitiveConverter
    extends PrimitiveConverter
    implements SimpleFeatureReadSupport.ValueMaterializer<Object> {
        private Object value = BoxesRunTime.boxToInteger((int)-1);
        private boolean set = false;

        private Object value() {
            return this.value;
        }

        private void value_$eq(Object x$1) {
            this.value = x$1;
        }

        private boolean set() {
            return this.set;
        }

        private void set_$eq(boolean x$1) {
            this.set = x$1;
        }

        public void addBinary(Binary value) {
            if (value != null) {
                this.value_$eq(value.getBytes());
                this.set_$eq(true);
                return;
            }
        }

        public void addBoolean(boolean value) {
            this.value_$eq(BoxesRunTime.boxToBoolean((boolean)value));
            this.set_$eq(true);
        }

        public void addDouble(double value) {
            this.value_$eq(BoxesRunTime.boxToDouble((double)value));
            this.set_$eq(true);
        }

        public void addFloat(float value) {
            this.value_$eq(BoxesRunTime.boxToFloat((float)value));
            this.set_$eq(true);
        }

        public void addInt(int value) {
            this.value_$eq(BoxesRunTime.boxToInteger((int)value));
            this.set_$eq(true);
        }

        public void addLong(long value) {
            this.value_$eq(BoxesRunTime.boxToLong((long)value));
            this.set_$eq(true);
        }

        public void reset() {
            this.set_$eq(false);
        }

        public Object materialize() {
            if (this.set()) {
                return this.value();
            }
            return null;
        }
    }

    private static class GenericGroupConverter
    extends GroupConverter
    implements SimpleFeatureReadSupport.ValueMaterializer<GenericRecord> {
        private final Schema avroSchema;
        private final Seq<Type> fields;
        private final SimpleFeatureReadSupport.ValueMaterializer<?>[] converters;
        private GenericRecord rec;

        private Schema avroSchema() {
            return this.avroSchema;
        }

        private Seq<Type> fields() {
            return this.fields;
        }

        private SimpleFeatureReadSupport.ValueMaterializer<?>[] converters() {
            return this.converters;
        }

        private GenericRecord rec() {
            return this.rec;
        }

        private void rec_$eq(GenericRecord x$1) {
            this.rec = x$1;
        }

        public Converter getConverter(int fieldIndex) {
            return (Converter)this.converters()[fieldIndex];
        }

        public void start() {
            this.rec_$eq((GenericRecord)new GenericData.Record(this.avroSchema()));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.converters())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.reset();
                return BoxedUnit.UNIT;
            });
        }

        public void end() {
            for (int i = 0; i < this.fields().length(); ++i) {
                this.rec().put(i, this.converters()[i].materialize());
            }
        }

        public void reset() {
            this.rec_$eq(null);
        }

        public GenericRecord materialize() {
            return this.rec();
        }

        public GenericGroupConverter(MessageType fileSchema, Option<SimpleFeatureParquetSchema> schema) {
            SimpleFeatureReadSupport.ValueMaterializer[] valueMaterializerArray;
            this.avroSchema = new AvroSchemaConverter().convert(fileSchema);
            this.fields = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(fileSchema.getFields()).asScala()).toSeq();
            Option<SimpleFeatureParquetSchema> option = schema;
            if (None$.MODULE$.equals(option)) {
                valueMaterializerArray = (SimpleFeatureReadSupport.ValueMaterializer[])Array$.MODULE$.tabulate(this.fields().length(), (Function1 & Serializable & scala.Serializable)i -> AvroReadSupport$.MODULE$.org$locationtech$geomesa$convert$parquet$AvroReadSupport$$converter((Type)this.fields().apply(BoxesRunTime.unboxToInt((Object)i))), ClassTag$.MODULE$.apply(SimpleFeatureReadSupport.ValueMaterializer.class));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                SimpleFeatureParquetSchema s = (SimpleFeatureParquetSchema)some.value();
                Buffer attributes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(s.sft().getAttributeDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)d -> SimpleFeatureReadSupport$.MODULE$.attribute(ObjectType$.MODULE$.selectType(d), s.encodings()), Buffer$.MODULE$.canBuildFrom());
                SimpleFeatureReadSupport.ValueMaterializer[] remaining = (SimpleFeatureReadSupport.ValueMaterializer[])((TraversableOnce)((TraversableLike)this.fields().drop(s.sft().getAttributeCount())).map((Function1 & Serializable & scala.Serializable)field -> AvroReadSupport$.MODULE$.org$locationtech$geomesa$convert$parquet$AvroReadSupport$$converter((Type)field), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleFeatureReadSupport.ValueMaterializer.class));
                valueMaterializerArray = (SimpleFeatureReadSupport.ValueMaterializer[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])attributes.toArray(ClassTag$.MODULE$.apply(SimpleFeatureReadSupport.ValueMaterializer.class)))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])remaining)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SimpleFeatureReadSupport.ValueMaterializer.class)));
            } else {
                throw new MatchError(option);
            }
            this.converters = valueMaterializerArray;
        }
    }

    private static class NanosConverter
    extends PrimitiveConverter
    implements SimpleFeatureReadSupport.ValueMaterializer<Date> {
        private long value = -1L;
        private boolean set = false;

        private long value() {
            return this.value;
        }

        private void value_$eq(long x$1) {
            this.value = x$1;
        }

        private boolean set() {
            return this.set;
        }

        private void set_$eq(boolean x$1) {
            this.set = x$1;
        }

        public void addLong(long value) {
            this.value_$eq(value);
            this.set_$eq(true);
        }

        public void reset() {
            this.set_$eq(false);
        }

        public Date materialize() {
            if (this.set()) {
                return new Date(this.value() / 1000000L);
            }
            return null;
        }
    }

    private static class RepeatedPrimitiveConverter
    extends PrimitiveConverter
    implements SimpleFeatureReadSupport.ValueMaterializer<List<Object>> {
        private final PrimitiveConverter delegate;
        private List<Object> list;

        private List<Object> list() {
            return this.list;
        }

        private void list_$eq(List<Object> x$1) {
            this.list = x$1;
        }

        public void addBinary(Binary value) {
            this.delegate.addBinary(value);
            this.addElement();
        }

        public void addBoolean(boolean value) {
            this.delegate.addBoolean(value);
            this.addElement();
        }

        public void addInt(int value) {
            this.delegate.addInt(value);
            this.addElement();
        }

        public void addFloat(float value) {
            this.delegate.addFloat(value);
            this.addElement();
        }

        public void addLong(long value) {
            this.delegate.addLong(value);
            this.addElement();
        }

        public void addDouble(double value) {
            this.delegate.addDouble(value);
            this.addElement();
        }

        private void addElement() {
            if (this.list() == null) {
                this.list_$eq(new ArrayList<Object>());
            }
            this.list().add(((SimpleFeatureReadSupport.ValueMaterializer)this.delegate).materialize());
            ((SimpleFeatureReadSupport.ValueMaterializer)this.delegate).reset();
        }

        public void reset() {
            this.list_$eq(null);
        }

        public List<Object> materialize() {
            return this.list();
        }

        public RepeatedPrimitiveConverter(PrimitiveConverter delegate) {
            this.delegate = delegate;
        }
    }
}

