/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.parquet;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.locationtech.geomesa.convert2.TypeInference;
import org.locationtech.geomesa.convert2.TypeInference$;
import org.locationtech.geomesa.fs.storage.parquet.io.GeoParquetMetadata;
import org.locationtech.geomesa.fs.storage.parquet.io.GeoParquetMetadata$;
import org.locationtech.geomesa.fs.storage.parquet.io.GeometrySchema;
import org.locationtech.geomesa.fs.storage.parquet.io.GeometrySchema$;
import org.locationtech.geomesa.utils.geotools.ObjectType$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class ParquetConverterFactory$
implements LazyLogging {
    public static ParquetConverterFactory$ MODULE$;
    private final String TypeToProcess;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ParquetConverterFactory$();
    }

    private Logger logger$lzycompute() {
        ParquetConverterFactory$ parquetConverterFactory$ = this;
        synchronized (parquetConverterFactory$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String TypeToProcess() {
        return this.TypeToProcess;
    }

    public Option<GroupType> getListElementType(GroupType group) {
        return new Some((Object)group).withFilter((Function1 & Serializable & scala.Serializable)g -> BoxesRunTime.boxToBoolean((boolean)ParquetConverterFactory$.$anonfun$getListElementType$1(g))).map((Function1 & Serializable & scala.Serializable)g -> {
            GroupType list = g.getType(0).asGroupType();
            return new Tuple2(g, (Object)list);
        }).withFilter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ParquetConverterFactory$.$anonfun$getListElementType$3(x$5))).map((Function1 & Serializable & scala.Serializable)x$6 -> {
            Tuple2 tuple2 = x$6;
            if (tuple2 != null) {
                GroupType list = (GroupType)tuple2._2();
                return list.getType(0).asGroupType();
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Option<Tuple2<Type, Type>> getMapKeyValueTypes(GroupType map) {
        return new Some((Object)map).withFilter((Function1 & Serializable & scala.Serializable)mapGroup -> BoxesRunTime.boxToBoolean((boolean)ParquetConverterFactory$.$anonfun$getMapKeyValueTypes$1(mapGroup))).map((Function1 & Serializable & scala.Serializable)mapGroup -> {
            Type tuples = mapGroup.getType(0);
            return new Tuple2(mapGroup, (Object)tuples);
        }).withFilter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ParquetConverterFactory$.$anonfun$getMapKeyValueTypes$3(x$7))).map((Function1 & Serializable & scala.Serializable)x$9 -> {
            Tuple2 tuple2 = x$9;
            if (tuple2 != null) {
                Type tuples = (Type)tuple2._2();
                GroupType tuplesGroup = tuples.asGroupType();
                return new Tuple2((Object)tuple2, (Object)tuplesGroup);
            }
            throw new MatchError((Object)tuple2);
        }).withFilter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ParquetConverterFactory$.$anonfun$getMapKeyValueTypes$5(x$10))).map((Function1 & Serializable & scala.Serializable)x$11 -> {
            Tuple2 tuple2 = x$11;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                GroupType tuplesGroup = (GroupType)tuple2._2();
                if (tuple22 != null) {
                    return new Tuple2((Object)tuplesGroup.getType(0), (Object)tuplesGroup.getType(1));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Seq<TypeInference.InferredType> org$locationtech$geomesa$convert$parquet$ParquetConverterFactory$$schemaTypes(FileMetaData fileMetaData) {
        TypeInference.Namer namer = new TypeInference.Namer(TypeInference.Namer$.MODULE$.$lessinit$greater$default$1());
        Option geos = Option$.MODULE$.apply(fileMetaData.getKeyValueMetaData().get(GeoParquetMetadata$.MODULE$.GeoParquetMetadataKey())).map((Function1 & Serializable & scala.Serializable)json -> GeoParquetMetadata$.MODULE$.fromJson(json));
        Seq types = ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fileMetaData.getSchema().getFields()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$12 -> MODULE$.mapField((Type)x$12, namer, (Option<GeoParquetMetadata>)geos), Buffer$.MODULE$.canBuildFrom())).toSeq();
        Option geom = TypeInference$.MODULE$.deriveGeometry(types, (Function1)namer);
        return (Seq)types.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(geom), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<TypeInference.InferredType> mapField(Type field, TypeInference.Namer namer, Option<GeoParquetMetadata> geos) {
        if (geos.exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)ParquetConverterFactory$.$anonfun$mapField$1(field, x$13)))) {
            return (Seq)Nil$.MODULE$;
        }
        Option option = geos.flatMap((Function1 & Serializable & scala.Serializable)x$15 -> x$15.geometries().find((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ParquetConverterFactory$.$anonfun$mapField$4(field, x$16))));
        if (None$.MODULE$.equals(option)) {
            return this.mapNormalField(field, namer, this.mapNormalField$default$3());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            GeoParquetMetadata.ColumnMetadata geo = (GeoParquetMetadata.ColumnMetadata)some.value();
            return this.mapGeoField(field, namer, geo);
        }
        throw new MatchError((Object)option);
    }

    private Seq<TypeInference.InferredType> mapNormalField(Type field, TypeInference.Namer namer, String path) {
        LazyRef name$lzy = new LazyRef();
        String fieldPath = new StringBuilder(1).append(path).append("/").append(field.getName()).toString();
        TypeInference.FunctionTransform transform = new TypeInference.FunctionTransform("avroPath(", new StringBuilder(4).append(",'").append(fieldPath).append("')").toString());
        LogicalTypeAnnotation logical = field.getLogicalTypeAnnotation();
        if (field.isPrimitive()) {
            LazyRef intOrDate$lzy = new LazyRef();
            LazyRef longOrTimestamp$lzy = new LazyRef();
            LazyRef stringOrBytes$lzy = new LazyRef();
            PrimitiveType.PrimitiveTypeName primitiveTypeName = field.asPrimitiveType().getPrimitiveTypeName();
            if (PrimitiveType.PrimitiveTypeName.BINARY.equals(primitiveTypeName)) {
                return (Seq)new .colon.colon((Object)ParquetConverterFactory$.stringOrBytes$1(stringOrBytes$lzy, logical, transform, name$lzy, namer, fieldPath), (List)Nil$.MODULE$);
            }
            if (PrimitiveType.PrimitiveTypeName.INT32.equals(primitiveTypeName)) {
                return (Seq)new .colon.colon((Object)ParquetConverterFactory$.intOrDate$1(intOrDate$lzy, logical, transform, name$lzy, namer, fieldPath), (List)Nil$.MODULE$);
            }
            if (PrimitiveType.PrimitiveTypeName.INT64.equals(primitiveTypeName)) {
                return (Seq)new .colon.colon((Object)ParquetConverterFactory$.longOrTimestamp$1(longOrTimestamp$lzy, logical, transform, name$lzy, namer, fieldPath), (List)Nil$.MODULE$);
            }
            if (PrimitiveType.PrimitiveTypeName.FLOAT.equals(primitiveTypeName)) {
                return (Seq)new .colon.colon((Object)new TypeInference.InferredType(ParquetConverterFactory$.name$1(name$lzy, namer, fieldPath), ObjectType$.MODULE$.FLOAT(), (TypeInference.InferredTransform)transform), (List)Nil$.MODULE$);
            }
            if (PrimitiveType.PrimitiveTypeName.DOUBLE.equals(primitiveTypeName)) {
                return (Seq)new .colon.colon((Object)new TypeInference.InferredType(ParquetConverterFactory$.name$1(name$lzy, namer, fieldPath), ObjectType$.MODULE$.DOUBLE(), (TypeInference.InferredTransform)transform), (List)Nil$.MODULE$);
            }
            if (PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(primitiveTypeName)) {
                return (Seq)new .colon.colon((Object)new TypeInference.InferredType(ParquetConverterFactory$.name$1(name$lzy, namer, fieldPath), ObjectType$.MODULE$.BOOLEAN(), (TypeInference.InferredTransform)transform), (List)Nil$.MODULE$);
            }
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(primitiveTypeName)) {
                return (Seq)new .colon.colon((Object)new TypeInference.InferredType(ParquetConverterFactory$.name$1(name$lzy, namer, fieldPath), ObjectType$.MODULE$.BYTES(), (TypeInference.InferredTransform)transform), (List)Nil$.MODULE$);
            }
            return (Seq)Nil$.MODULE$;
        }
        GroupType group = field.asGroupType();
        LogicalTypeAnnotation logicalTypeAnnotation = logical;
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) {
            if (this.getListElementType(group).exists((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ParquetConverterFactory$.$anonfun$mapNormalField$1(e)))) {
                return (Seq)new .colon.colon((Object)new TypeInference.InferredType(ParquetConverterFactory$.name$1(name$lzy, namer, fieldPath), ObjectType$.MODULE$.LIST(), (TypeInference.InferredTransform)transform), (List)Nil$.MODULE$);
            }
            return (Seq)new .colon.colon((Object)new TypeInference.InferredType(ParquetConverterFactory$.name$1(name$lzy, namer, fieldPath), ObjectType$.MODULE$.JSON(), (TypeInference.InferredTransform)ParquetConverterFactory$.jsonTransform$1(transform)), (List)Nil$.MODULE$);
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.MapLogicalTypeAnnotation) {
            if (this.getMapKeyValueTypes(group).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ParquetConverterFactory$.$anonfun$mapNormalField$2(x0$1)))) {
                return (Seq)new .colon.colon((Object)new TypeInference.InferredType(ParquetConverterFactory$.name$1(name$lzy, namer, fieldPath), ObjectType$.MODULE$.MAP(), (TypeInference.InferredTransform)transform), (List)Nil$.MODULE$);
            }
            return (Seq)new .colon.colon((Object)new TypeInference.InferredType(ParquetConverterFactory$.name$1(name$lzy, namer, fieldPath), ObjectType$.MODULE$.JSON(), (TypeInference.InferredTransform)ParquetConverterFactory$.jsonTransform$1(transform)), (List)Nil$.MODULE$);
        }
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(group.getFields()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$17 -> MODULE$.mapNormalField((Type)x$17, namer, fieldPath), Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    private String mapNormalField$default$3() {
        return "";
    }

    private Seq<TypeInference.InferredType> mapGeoField(Type field, TypeInference.Namer namer, GeoParquetMetadata.ColumnMetadata geo) {
        block7: {
            Enumeration.Value objectType;
            LazyRef name$lzy;
            block6: {
                name$lzy = new LazyRef();
                Enumeration.Value value = geo.encoding();
                Enumeration.Value value2 = GeoParquetMetadata.GeoParquetColumnEncoding$.MODULE$.WKB();
                if (!(value != null ? !value.equals(value2) : value2 != null)) {
                    if (this.isWkbType(field)) {
                        return (Seq)new .colon.colon((Object)new TypeInference.InferredType(ParquetConverterFactory$.name$2(name$lzy, namer, field), GeoParquetMetadata.GeoParquetColumnType$.MODULE$.toObjectType(geo.types()), (TypeInference.InferredTransform)ParquetConverterFactory$.geomTransform$1("geometry", field)), (List)Nil$.MODULE$);
                    }
                    return this.mismatch$1(field, namer);
                }
                objectType = GeoParquetMetadata.GeoParquetColumnEncoding$.MODULE$.toObjectType(geo.encoding());
                if (geo.types().isEmpty()) break block6;
                Enumeration.Value value3 = GeoParquetMetadata.GeoParquetColumnType$.MODULE$.toObjectType(geo.types());
                Enumeration.Value value4 = objectType;
                if (value3 != null ? !value3.equals(value4) : value4 != null) break block7;
            }
            if (this.isNativeType(field, objectType)) {
                return (Seq)new .colon.colon((Object)new TypeInference.InferredType(ParquetConverterFactory$.name$2(name$lzy, namer, field), objectType, (TypeInference.InferredTransform)ParquetConverterFactory$.geomTransform$1(geo.encoding().toString(), field)), (List)Nil$.MODULE$);
            }
        }
        return this.mismatch$1(field, namer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isWkbType(Type field) {
        if (field.isRepetition(Type.Repetition.REPEATED)) return false;
        if (!field.isPrimitive()) return false;
        PrimitiveType.PrimitiveTypeName primitiveTypeName = field.asPrimitiveType().getPrimitiveTypeName();
        PrimitiveType.PrimitiveTypeName primitiveTypeName2 = PrimitiveType.PrimitiveTypeName.BINARY;
        if (primitiveTypeName != null) {
            if (!primitiveTypeName.equals(primitiveTypeName2)) return false;
            return true;
        }
        if (primitiveTypeName2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isNativeType(Type field, Enumeration.Value objectType) {
        if (field.isRepetition(Type.Repetition.REPEATED)) return false;
        java.util.List list = field.asGroupType().getFields();
        java.util.List list2 = ((Type)GeometrySchema$.MODULE$.apply(objectType, (GeometrySchema.GeometryEncoding)GeometrySchema.GeometryEncoding$.GeoParquetNative$.MODULE$).named(field.getName())).asGroupType().getFields();
        if (list != null) {
            if (!((Object)list).equals(list2)) return false;
            return true;
        }
        if (list2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$getListElementType$1(GroupType g) {
        return g.getFieldCount() == 1 && !g.getType(0).isPrimitive();
    }

    public static final /* synthetic */ boolean $anonfun$getListElementType$3(Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 != null) {
            GroupType list = (GroupType)tuple2._2();
            return list.getFieldCount() == 1 && list.isRepetition(Type.Repetition.REPEATED) && !list.getType(0).isPrimitive();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getMapKeyValueTypes$1(GroupType mapGroup) {
        return mapGroup.getFieldCount() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$getMapKeyValueTypes$3(Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        if (tuple2 != null) {
            Type tuples = (Type)tuple2._2();
            return !tuples.isPrimitive();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getMapKeyValueTypes$5(Tuple2 x$10) {
        Tuple2 tuple2 = x$10;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            GroupType tuplesGroup = (GroupType)tuple2._2();
            if (tuple22 != null) {
                return tuplesGroup.getFieldCount() == 2 && tuplesGroup.isRepetition(Type.Repetition.REPEATED);
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$mapField$2(Type field$1, GeoParquetMetadata.ColumnMetadata x$14) {
        return x$14.covering().contains((Object)field$1.getName());
    }

    public static final /* synthetic */ boolean $anonfun$mapField$1(Type field$1, GeoParquetMetadata x$13) {
        return x$13.geometries().exists((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ParquetConverterFactory$.$anonfun$mapField$2(field$1, x$14)));
    }

    public static final /* synthetic */ boolean $anonfun$mapField$4(Type field$1, GeoParquetMetadata.ColumnMetadata x$16) {
        String string = x$16.name();
        String string2 = field$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final /* synthetic */ String name$lzycompute$1(LazyRef name$lzy$1, TypeInference.Namer namer$2, String fieldPath$1) {
        String string;
        LazyRef lazyRef = name$lzy$1;
        synchronized (lazyRef) {
            string = name$lzy$1.initialized() ? (String)name$lzy$1.value() : (String)name$lzy$1.initialize((Object)namer$2.apply(fieldPath$1));
        }
        return string;
    }

    private static final String name$1(LazyRef name$lzy$1, TypeInference.Namer namer$2, String fieldPath$1) {
        if (name$lzy$1.initialized()) {
            return (String)name$lzy$1.value();
        }
        return ParquetConverterFactory$.name$lzycompute$1(name$lzy$1, namer$2, fieldPath$1);
    }

    private static final /* synthetic */ TypeInference.InferredType intOrDate$lzycompute$1(LazyRef intOrDate$lzy$1, LogicalTypeAnnotation logical$1, TypeInference.FunctionTransform transform$1, LazyRef name$lzy$1, TypeInference.Namer namer$2, String fieldPath$1) {
        TypeInference.InferredType inferredType;
        LazyRef lazyRef = intOrDate$lzy$1;
        synchronized (lazyRef) {
            LogicalTypeAnnotation logicalTypeAnnotation;
            inferredType = intOrDate$lzy$1.initialized() ? (TypeInference.InferredType)intOrDate$lzy$1.value() : (TypeInference.InferredType)intOrDate$lzy$1.initialize((Object)((logicalTypeAnnotation = logical$1) instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation ? new TypeInference.InferredType(ParquetConverterFactory$.name$1(name$lzy$1, namer$2, fieldPath$1), ObjectType$.MODULE$.DATE(), (TypeInference.InferredTransform)transform$1) : new TypeInference.InferredType(ParquetConverterFactory$.name$1(name$lzy$1, namer$2, fieldPath$1), ObjectType$.MODULE$.INT(), (TypeInference.InferredTransform)transform$1)));
        }
        return inferredType;
    }

    private static final TypeInference.InferredType intOrDate$1(LazyRef intOrDate$lzy$1, LogicalTypeAnnotation logical$1, TypeInference.FunctionTransform transform$1, LazyRef name$lzy$1, TypeInference.Namer namer$2, String fieldPath$1) {
        if (intOrDate$lzy$1.initialized()) {
            return (TypeInference.InferredType)intOrDate$lzy$1.value();
        }
        return ParquetConverterFactory$.intOrDate$lzycompute$1(intOrDate$lzy$1, logical$1, transform$1, name$lzy$1, namer$2, fieldPath$1);
    }

    /*
     * Unable to fully structure code
     */
    private static final /* synthetic */ TypeInference.InferredType longOrTimestamp$lzycompute$1(LazyRef longOrTimestamp$lzy$1, LogicalTypeAnnotation logical$1, TypeInference.FunctionTransform transform$1, LazyRef name$lzy$1, TypeInference.Namer namer$2, String fieldPath$1) {
        var7_6 = longOrTimestamp$lzy$1;
        synchronized (var7_6) {
            block6: {
                block8: {
                    block7: {
                        block5: {
                            if (!longOrTimestamp$lzy$1.initialized()) break block5;
                            v0 = (TypeInference.InferredType)longOrTimestamp$lzy$1.value();
                            break block6;
                        }
                        var9_7 = false;
                        var10_8 = null;
                        var11_9 = logical$1;
                        if (!(var11_9 instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)) break block7;
                        var9_7 = true;
                        var10_8 = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)var11_9;
                        v1 = var10_8.getUnit();
                        var12_10 = LogicalTypeAnnotation.TimeUnit.MILLIS;
                        if (v1 != null ? v1.equals(var12_10) == false : var12_10 != null) break block7;
                        v2 = new TypeInference.InferredType(ParquetConverterFactory$.name$1(name$lzy$1, namer$2, fieldPath$1), ObjectType$.MODULE$.DATE(), (TypeInference.InferredTransform)transform$1);
                        break block8;
                    }
                    if (!var9_7) ** GOTO lbl-1000
                    v3 = var10_8.getUnit();
                    var13_11 = LogicalTypeAnnotation.TimeUnit.MICROS;
                    if (!(v3 != null ? v3.equals(var13_11) == false : var13_11 != null)) {
                        v2 = new TypeInference.InferredType(ParquetConverterFactory$.name$1(name$lzy$1, namer$2, fieldPath$1), ObjectType$.MODULE$.DATE(), (TypeInference.InferredTransform)transform$1);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = new TypeInference.InferredType(ParquetConverterFactory$.name$1(name$lzy$1, namer$2, fieldPath$1), ObjectType$.MODULE$.LONG(), (TypeInference.InferredTransform)transform$1);
                    }
                }
                v0 = (TypeInference.InferredType)longOrTimestamp$lzy$1.initialize((Object)v2);
            }
            var8_12 = v0;
        }
        return var8_12;
    }

    private static final TypeInference.InferredType longOrTimestamp$1(LazyRef longOrTimestamp$lzy$1, LogicalTypeAnnotation logical$1, TypeInference.FunctionTransform transform$1, LazyRef name$lzy$1, TypeInference.Namer namer$2, String fieldPath$1) {
        if (longOrTimestamp$lzy$1.initialized()) {
            return (TypeInference.InferredType)longOrTimestamp$lzy$1.value();
        }
        return ParquetConverterFactory$.longOrTimestamp$lzycompute$1(longOrTimestamp$lzy$1, logical$1, transform$1, name$lzy$1, namer$2, fieldPath$1);
    }

    private static final /* synthetic */ TypeInference.InferredType stringOrBytes$lzycompute$1(LazyRef stringOrBytes$lzy$1, LogicalTypeAnnotation logical$1, TypeInference.FunctionTransform transform$1, LazyRef name$lzy$1, TypeInference.Namer namer$2, String fieldPath$1) {
        TypeInference.InferredType inferredType;
        LazyRef lazyRef = stringOrBytes$lzy$1;
        synchronized (lazyRef) {
            LogicalTypeAnnotation logicalTypeAnnotation;
            inferredType = stringOrBytes$lzy$1.initialized() ? (TypeInference.InferredType)stringOrBytes$lzy$1.value() : (TypeInference.InferredType)stringOrBytes$lzy$1.initialize((Object)((logicalTypeAnnotation = logical$1) instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation ? new TypeInference.InferredType(ParquetConverterFactory$.name$1(name$lzy$1, namer$2, fieldPath$1), ObjectType$.MODULE$.STRING(), (TypeInference.InferredTransform)transform$1) : new TypeInference.InferredType(ParquetConverterFactory$.name$1(name$lzy$1, namer$2, fieldPath$1), ObjectType$.MODULE$.BYTES(), (TypeInference.InferredTransform)transform$1)));
        }
        return inferredType;
    }

    private static final TypeInference.InferredType stringOrBytes$1(LazyRef stringOrBytes$lzy$1, LogicalTypeAnnotation logical$1, TypeInference.FunctionTransform transform$1, LazyRef name$lzy$1, TypeInference.Namer namer$2, String fieldPath$1) {
        if (stringOrBytes$lzy$1.initialized()) {
            return (TypeInference.InferredType)stringOrBytes$lzy$1.value();
        }
        return ParquetConverterFactory$.stringOrBytes$lzycompute$1(stringOrBytes$lzy$1, logical$1, transform$1, name$lzy$1, namer$2, fieldPath$1);
    }

    private static final TypeInference.FunctionTransform jsonTransform$1(TypeInference.FunctionTransform transform$1) {
        return new TypeInference.FunctionTransform(new StringBuilder(11).append("avroToJson(").append(transform$1.prefix()).toString(), new StringBuilder(1).append(transform$1.suffix()).append(")").toString());
    }

    public static final /* synthetic */ boolean $anonfun$mapNormalField$1(GroupType e) {
        return e.getFieldCount() == 1 && e.getType(0).isPrimitive();
    }

    public static final /* synthetic */ boolean $anonfun$mapNormalField$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Type k = (Type)tuple2._1();
            Type v = (Type)tuple2._2();
            return k.isPrimitive() && v.isPrimitive();
        }
        throw new MatchError((Object)tuple2);
    }

    private static final /* synthetic */ String name$lzycompute$2(LazyRef name$lzy$2, TypeInference.Namer namer$3, Type field$2) {
        String string;
        LazyRef lazyRef = name$lzy$2;
        synchronized (lazyRef) {
            string = name$lzy$2.initialized() ? (String)name$lzy$2.value() : (String)name$lzy$2.initialize((Object)namer$3.apply(field$2.getName()));
        }
        return string;
    }

    private static final String name$2(LazyRef name$lzy$2, TypeInference.Namer namer$3, Type field$2) {
        if (name$lzy$2.initialized()) {
            return (String)name$lzy$2.value();
        }
        return ParquetConverterFactory$.name$lzycompute$2(name$lzy$2, namer$3, field$2);
    }

    private static final TypeInference.FunctionTransform geomTransform$1(String fn, Type field$2) {
        return new TypeInference.FunctionTransform(new StringBuilder(10).append(fn).append("(avroPath(").toString(), new StringBuilder(6).append(",'/").append(field$2.getName()).append("'))").toString());
    }

    private final Seq mismatch$1(Type field$2, TypeInference.Namer namer$3) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Found GeoParquet metadata for column '{}' but the schema does not match the expected type", new Object[]{field$2.getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.mapNormalField(field$2, namer$3, this.mapNormalField$default$3());
    }

    private ParquetConverterFactory$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.TypeToProcess = "parquet";
    }
}

