/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.shp;

import java.io.InputStream;
import org.geotools.data.Query;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert.EvaluationContext$;
import org.locationtech.geomesa.convert.shp.ShapefileConverter$;
import org.locationtech.geomesa.convert.shp.ShapefileFunctionFactory;
import org.locationtech.geomesa.convert.shp.ShapefileFunctionFactory$;
import org.locationtech.geomesa.convert2.AbstractConverter;
import org.locationtech.geomesa.convert2.package;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.text.TextTools$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0001\u0003\u00015\u0011!c\u00155ba\u00164\u0017\u000e\\3D_:4XM\u001d;fe*\u00111\u0001B\u0001\u0004g\"\u0004(BA\u0003\u0007\u0003\u001d\u0019wN\u001c<feRT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0007\u001fI!b\u0004M\u001a\u000e\u0003AQ!!\u0005\u0004\u0002\u0011\r|gN^3siJJ!a\u0005\t\u0003#\u0005\u00137\u000f\u001e:bGR\u001cuN\u001c<feR,'\u000f\u0005\u0002\u001695\taC\u0003\u0002\u00181\u000511/[7qY\u0016T!!\u0007\u000e\u0002\u000f\u0019,\u0017\r^;sK*\u00111DC\u0001\b_B,gnZ5t\u0013\tibCA\u0007TS6\u0004H.\u001a$fCR,(/\u001a\t\u0003?5r!\u0001I\u0016\u000f\u0005\u0005RcB\u0001\u0012*\u001d\t\u0019\u0003F\u0004\u0002%O5\tQE\u0003\u0002'\u0019\u00051AH]8pizJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005E1\u0011B\u0001\u0017\u0011\u0003E\t%m\u001d;sC\u000e$8i\u001c8wKJ$XM]\u0005\u0003]=\u00121BQ1tS\u000e\u001cuN\u001c4jO*\u0011A\u0006\u0005\t\u0003?EJ!AM\u0018\u0003\u0015\t\u000b7/[2GS\u0016dG\r\u0005\u0002 i%\u0011Qg\f\u0002\r\u0005\u0006\u001c\u0018nY(qi&|gn\u001d\u0005\no\u0001\u0011\t\u0011)A\u0005qm\n1a\u001d4u!\t)\u0012(\u0003\u0002;-\t\t2+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3\n\u0005]\u0012\u0002\"C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010?\u0003\u0019\u0019wN\u001c4jO&\u0011QH\u0005\u0005\n\u0001\u0002\u0011\t\u0011)A\u0005\u00032\u000baAZ5fY\u0012\u001c\bc\u0001\"Ja9\u00111I\u0012\b\u0003I\u0011K\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\"\u000bq\u0001]1dW\u0006<WMC\u0001F\u0013\tQ5JA\u0002TKFT!a\u0012%\n\u0005\u0001\u0013\u0002\"\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B\u001aP\u0003\u001dy\u0007\u000f^5p]NL!A\u0014\n\t\u000bE\u0003A\u0011\u0001*\u0002\rqJg.\u001b;?)\u0015\u0019VKV,Y!\t!\u0006!D\u0001\u0003\u0011\u00159\u0004\u000b1\u00019\u0011\u0015i\u0004\u000b1\u0001\u001f\u0011\u0015\u0001\u0005\u000b1\u0001B\u0011\u0015q\u0005\u000b1\u00014\u0011\u0015Q\u0006\u0001\"\u0011\\\u0003]\u0019'/Z1uK\u00163\u0018\r\\;bi&|gnQ8oi\u0016DH\u000f\u0006\u0002]AB\u0011QLX\u0007\u0002\t%\u0011q\f\u0002\u0002\u0012\u000bZ\fG.^1uS>t7i\u001c8uKb$\bbB1Z!\u0003\u0005\rAY\u0001\rO2|'-\u00197QCJ\fWn\u001d\t\u0005G\u001eTWN\u0004\u0002eK6\t\u0001*\u0003\u0002g\u0011\u00061\u0001K]3eK\u001aL!\u0001[5\u0003\u00075\u000b\u0007O\u0003\u0002g\u0011B\u00111m[\u0005\u0003Y&\u0014aa\u0015;sS:<\u0007C\u00013o\u0013\ty\u0007JA\u0002B]fDQ!\u001d\u0001\u0005RI\fQ\u0001]1sg\u0016$Ba]>\u0002\fA\u0019A/\u001f\u000b\u000e\u0003UT!A^<\u0002\u0015\r|G\u000e\\3di&|gN\u0003\u0002y\r\u0005)Q\u000f^5mg&\u0011!0\u001e\u0002\u0012\u00072|7/Z1cY\u0016LE/\u001a:bi>\u0014\b\"\u0002?q\u0001\u0004i\u0018AA5t!\rq\u0018qA\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\tIwN\u0003\u0002\u0002\u0006\u0005!!.\u0019<b\u0013\r\tIa \u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0004\u0002\u000eA\u0004\r\u0001X\u0001\u0003K\u000eDq!!\u0005\u0001\t#\n\u0019\"\u0001\u0004wC2,Xm\u001d\u000b\u0007\u0003+\ti\"!\t\u0011\tQL\u0018q\u0003\t\u0005I\u0006eQ.C\u0002\u0002\u001c!\u0013Q!\u0011:sCfDq!a\b\u0002\u0010\u0001\u00071/\u0001\u0004qCJ\u001cX\r\u001a\u0005\b\u0003\u001b\ty\u00011\u0001]\u000f\u001d\t)C\u0001E\u0001\u0003O\t!c\u00155ba\u00164\u0017\u000e\\3D_:4XM\u001d;feB\u0019A+!\u000b\u0007\r\u0005\u0011\u0001\u0012AA\u0016'\u0011\tI#!\f\u0011\u0007\u0011\fy#C\u0002\u00022!\u0013a!\u00118z%\u00164\u0007bB)\u0002*\u0011\u0005\u0011Q\u0007\u000b\u0003\u0003OA\u0001\"!\u000f\u0002*\u0011\u0005\u00111H\u0001\rO\u0016$H)\u0019;b'R|'/\u001a\u000b\u0005\u0003{\t\t\u0006\u0005\u0003\u0002@\u00055SBAA!\u0015\u0011\t\u0019%!\u0012\u0002\u0013MD\u0017\r]3gS2,'\u0002BA$\u0003\u0013\nA\u0001Z1uC*\u0019\u00111\n\u0006\u0002\u0011\u001d,w\u000e^8pYNLA!a\u0014\u0002B\t\u00112\u000b[1qK\u001aLG.\u001a#bi\u0006\u001cFo\u001c:f\u0011\u001d\t\u0019&a\u000eA\u0002)\fA\u0001]1uQ\u0002")
public class ShapefileConverter
extends AbstractConverter<SimpleFeature, AbstractConverter.BasicConfig, AbstractConverter.BasicField, AbstractConverter.BasicOptions> {
    public static ShapefileDataStore getDataStore(String string) {
        return ShapefileConverter$.MODULE$.getDataStore(string);
    }

    public EvaluationContext createEvaluationContext(Map<String, Object> globalParams) {
        Map shpParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ShapefileFunctionFactory$.MODULE$.InputSchemaKey()), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ShapefileFunctionFactory$.MODULE$.InputValuesKey()), Array$.MODULE$.empty(ClassTag$.MODULE$.Any()))}));
        return super.createEvaluationContext(globalParams.$plus$plus((GenTraversableOnce)shpParams));
    }

    public CloseableIterator<SimpleFeature> parse(InputStream is, EvaluationContext ec) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        package.CloseWithLogging$.MODULE$.apply((Object)is, IsCloseable$.MODULE$.closeableIsCloseable());
        String path = (String)EvaluationContext.RichEvaluationContext$.MODULE$.getInputFilePath$extension(EvaluationContext$.MODULE$.RichEvaluationContext(ec)).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Shapefile converter requires '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EvaluationContext$.MODULE$.InputFilePathKey()}))).append((Object)"to be set in the evaluation context").toString());
            }
        });
        ShapefileDataStore ds = ShapefileConverter$.MODULE$.getDataStore(path);
        SimpleFeatureType schema = ds.getSchema();
        String[] names = (String[])Array$.MODULE$.tabulate(schema.getAttributeCount(), (Function1)new Serializable(this, schema){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType schema$1;

            public final String apply(int i) {
                return this.schema$1.getDescriptor(i).getLocalName();
            }
            {
                this.schema$1 = schema$1;
            }
        }, ClassTag$.MODULE$.apply(String.class));
        Object[] array = (Object[])Array$.MODULE$.ofDim(schema.getAttributeCount() + 1, ClassTag$.MODULE$.Any());
        int i = ec.indexOf(ShapefileFunctionFactory$.MODULE$.InputSchemaKey());
        int j = ec.indexOf(ShapefileFunctionFactory$.MODULE$.InputValuesKey());
        if (i == -1 || j == -1) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder().append((Object)"Input schema not found in evaluation context, shapefile functions ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " will not be available"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.wordList((Iterable)new ShapefileFunctionFactory().functions().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(TransformerFunction x$1) {
                        return (String)x$1.names().head();
                    }
                }, Seq$.MODULE$.canBuildFrom()))}))).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            ec.set(i, (Object)names);
            ec.set(j, (Object)array);
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Query q = new Query();
        if (ds.getSchema().getCoordinateReferenceSystem() == null) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Shapefile does not have CRS info");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            q.setCoordinateSystemReproject(package$.MODULE$.CRS_EPSG_4326());
            boxedUnit = BoxedUnit.UNIT;
        }
        CloseableIterator reader = CloseableIterator$.MODULE$.apply(ds.getFeatureSource().getReader(q)).map((Function1)new Serializable(this, ec){
            public static final long serialVersionUID = 0L;
            private final EvaluationContext ec$1;

            public final SimpleFeature apply(SimpleFeature f) {
                this.ec$1.line_$eq(this.ec$1.line() + 1L);
                return f;
            }
            {
                this.ec$1 = ec$1;
            }
        });
        return CloseableIterator$.MODULE$.apply((Iterator)reader, (Function0)new Serializable(this, ds, reader){
            public static final long serialVersionUID = 0L;
            private final ShapefileDataStore ds$1;
            private final CloseableIterator reader$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                package.CloseWithLogging$.MODULE$.apply((Object)this.reader$1, IsCloseable$.MODULE$.closeableIsCloseable());
                this.ds$1.dispose();
            }
            {
                this.ds$1 = ds$1;
                this.reader$1 = reader$1;
            }
        });
    }

    public CloseableIterator<Object[]> values(CloseableIterator<SimpleFeature> parsed, EvaluationContext ec) {
        CloseableIterator closeableIterator;
        BoxedUnit boxedUnit;
        int i = ec.indexOf(ShapefileFunctionFactory$.MODULE$.InputValuesKey());
        int j = ec.indexOf(ShapefileFunctionFactory$.MODULE$.InputSchemaKey());
        if (i == -1 || j == -1) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder().append((Object)"Input schema not found in evaluation context, shapefile functions ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " will not be available"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.wordList((Iterable)new ShapefileFunctionFactory().functions().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(TransformerFunction x$2) {
                        return (String)x$2.names().head();
                    }
                }, Seq$.MODULE$.canBuildFrom()))}))).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (i == -1) {
            ObjectRef array = ObjectRef.create(null);
            closeableIterator = parsed.map((Function1)new Serializable(this, array){
                public static final long serialVersionUID = 0L;
                private final ObjectRef array$1;

                public final Object[] apply(SimpleFeature feature) {
                    if ((Object[])this.array$1.elem == null) {
                        this.array$1.elem = (Object[])Array$.MODULE$.ofDim(feature.getAttributeCount() + 1, ClassTag$.MODULE$.Any());
                    }
                    for (int i = 1; i < ((Object[])this.array$1.elem).length; ++i) {
                        ((Object[])this.array$1.elem)[i] = feature.getAttribute(i - 1);
                    }
                    ((Object[])this.array$1.elem)[0] = feature.getID();
                    return (Object[])this.array$1.elem;
                }
                {
                    this.array$1 = array$1;
                }
            });
        } else {
            Object[] array = (Object[])ec.get(i);
            closeableIterator = parsed.map((Function1)new Serializable(this, array){
                public static final long serialVersionUID = 0L;
                private final Object[] array$2;

                public final Object[] apply(SimpleFeature feature) {
                    for (int i = 1; i < this.array$2.length; ++i) {
                        this.array$2[i] = feature.getAttribute(i - 1);
                    }
                    this.array$2[0] = feature.getID();
                    return this.array$2;
                }
                {
                    this.array$2 = array$2;
                }
            });
        }
        return closeableIterator;
    }

    public ShapefileConverter(SimpleFeatureType sft, AbstractConverter.BasicConfig config, Seq<AbstractConverter.BasicField> fields, AbstractConverter.BasicOptions options) {
        super(sft, (package.ConverterConfig)config, fields, (package.ConverterOptions)options);
    }
}

