/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.shp;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.locationtech.geomesa.utils.io.PathUtils$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;

public final class ShapefileConverter$
implements LazyLogging {
    public static final ShapefileConverter$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ShapefileConverter$();
    }

    private Logger logger$lzycompute() {
        ShapefileConverter$ shapefileConverter$ = this;
        synchronized (shapefileConverter$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    /*
     * WARNING - void declaration
     */
    public ShapefileDataStore getDataStore(String path) {
        Option<Charset> option;
        block6: {
            void var3_3;
            ShapefileDataStore ds;
            block5: {
                block4: {
                    Map<String, URL> params = Collections.singletonMap(ShapefileDataStoreFactory.URLP.key, PathUtils$.MODULE$.getUrl(path));
                    ds = (ShapefileDataStore)DataStoreFinder.getDataStore(params);
                    option = this.tryInferCharsetFromCPG(path);
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    Charset charset = (Charset)some.x();
                    ds.setCharset(charset);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (!None$.MODULE$.equals(option)) break block6;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (ds == null) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not read shapefile using path '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
            }
            return var3_3;
        }
        throw new MatchError(option);
    }

    private Option<Charset> tryInferCharsetFromCPG(String path) {
        None$ none$;
        block8: {
            Tuple2 tuple2;
            block9: {
                block10: {
                    Path shpDirPath = Paths.get(path, new String[0]).getParent();
                    tuple2 = PathUtils$.MODULE$.getBaseNameAndExtension(path, PathUtils$.MODULE$.getBaseNameAndExtension$default$2());
                    if (tuple2 == null) break block9;
                    String baseName = (String)tuple2._1();
                    String string = baseName;
                    String baseName2 = string;
                    Path cpgPath = shpDirPath.resolve(new StringBuilder().append((Object)baseName2).append((Object)".cpg").toString());
                    if (!Files.isRegularFile(cpgPath, new LinkOption[0])) break block10;
                    BufferedSource source = Source$.MODULE$.fromFile(cpgPath.toFile(), Codec$.MODULE$.fallbackSystemCodec());
                    try {
                        List list;
                        block13: {
                            None$ none$2;
                            block12: {
                                block11: {
                                    list = source.getLines().take(1).toList();
                                    if (!Nil$.MODULE$.equals(list)) break block11;
                                    none$2 = None$.MODULE$;
                                    break block12;
                                }
                                if (!(list instanceof .colon.colon)) break block13;
                                .colon.colon colon2 = (.colon.colon)list;
                                String charsetName = (String)colon2.head();
                                none$2 = new Some((Object)Charset.forName(charsetName.trim()));
                            }
                            none$ = none$2;
                            break block8;
                        }
                        throw new MatchError((Object)list);
                    }
                    catch (Exception exception) {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Can't figure out charset from cpg file, will use default charset");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        none$ = None$.MODULE$;
                        break block8;
                    }
                    finally {
                        source.close();
                    }
                }
                none$ = None$.MODULE$;
                break block8;
            }
            throw new MatchError((Object)tuple2);
        }
        return none$;
    }

    private ShapefileConverter$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

