/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.shp;

import java.io.InputStream;
import java.io.Serializable;
import org.geotools.data.Query;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert.EvaluationContext$;
import org.locationtech.geomesa.convert.shp.ShapefileConverter$;
import org.locationtech.geomesa.convert.shp.ShapefileFunctionFactory;
import org.locationtech.geomesa.convert.shp.ShapefileFunctionFactory$;
import org.locationtech.geomesa.convert2.AbstractConverter;
import org.locationtech.geomesa.convert2.package;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.text.TextTools$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0007\u000f\u0001eA\u0011B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011$\t\u0013\u001d\u0003!\u0011!Q\u0001\n)B\u0005\"C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002&V\u0011%1\u0006A!A!\u0002\u0013yt\u000bC\u0003Y\u0001\u0011\u0005\u0011\fC\u0003a\u0001\u0011\u0005\u0013\rC\u0003x\u0001\u0011E\u0003\u0010C\u0004\u0002\u001c\u0001!\t&!\b\b\u000f\u00055b\u0002#\u0001\u00020\u00191QB\u0004E\u0001\u0003cAa\u0001\u0017\u0006\u0005\u0002\u0005e\u0002bBA\u001e\u0015\u0011\u0005\u0011Q\b\u0002\u0013'\"\f\u0007/\u001a4jY\u0016\u001cuN\u001c<feR,'O\u0003\u0002\u0010!\u0005\u00191\u000f\u001b9\u000b\u0005E\u0011\u0012aB2p]Z,'\u000f\u001e\u0006\u0003'Q\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\u0016-\u0005aAn\\2bi&|g\u000e^3dQ*\tq#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00015A11D\b\u0011+y}j\u0011\u0001\b\u0006\u0003;I\t\u0001bY8om\u0016\u0014HOM\u0005\u0003?q\u0011\u0011#\u00112tiJ\f7\r^\"p]Z,'\u000f^3s!\t\t\u0003&D\u0001#\u0015\t\u0019C%\u0001\u0004tS6\u0004H.\u001a\u0006\u0003K\u0019\nqAZ3biV\u0014XM\u0003\u0002(-\u00059q\u000e]3oO&\u001c\u0018BA\u0015#\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKB\u00111&\u000f\b\u0003Y]r!!\f\u001c\u000f\u00059*dBA\u00185\u001d\t\u00014'D\u00012\u0015\t\u0011\u0004$\u0001\u0004=e>|GOP\u0005\u0002/%\u0011QCF\u0005\u0003'QI!!\b\n\n\u0005ab\u0012!E!cgR\u0014\u0018m\u0019;D_:4XM\u001d;fe&\u0011!h\u000f\u0002\f\u0005\u0006\u001c\u0018nY\"p]\u001aLwM\u0003\u000299A\u00111&P\u0005\u0003}m\u0012!BQ1tS\u000e4\u0015.\u001a7e!\tY\u0003)\u0003\u0002Bw\ta!)Y:jG>\u0003H/[8og\u0006\u00191O\u001a;\u0011\u0005\u0005\"\u0015BA##\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/Z\u0005\u0003\u0005z\taaY8oM&<\u0017BA$\u001f\u0003\u00191\u0017.\u001a7egB\u00191J\u0015\u001f\u000f\u00051{eB\u0001\u0019N\u0013\u0005q\u0015!B:dC2\f\u0017B\u0001)R\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011AT\u0005\u0003'R\u00131aU3r\u0015\t\u0001\u0016+\u0003\u0002J=\u00059q\u000e\u001d;j_:\u001c\u0018B\u0001,\u001f\u0003\u0019a\u0014N\\5u}Q)!\fX/_?B\u00111\fA\u0007\u0002\u001d!)!)\u0002a\u0001\u0007\")q)\u0002a\u0001U!)\u0011*\u0002a\u0001\u0015\")a+\u0002a\u0001\u007f\u000592M]3bi\u0016,e/\u00197vCRLwN\\\"p]R,\u0007\u0010\u001e\u000b\u0003E\u001a\u0004\"a\u00193\u000e\u0003AI!!\u001a\t\u0003#\u00153\u0018\r\\;bi&|gnQ8oi\u0016DH\u000fC\u0004h\rA\u0005\t\u0019\u00015\u0002\u0019\u001ddwNY1m!\u0006\u0014\u0018-\\:\u0011\t%l\u0007o\u001d\b\u0003U.\u0004\"\u0001M)\n\u00051\f\u0016A\u0002)sK\u0012,g-\u0003\u0002o_\n\u0019Q*\u00199\u000b\u00051\f\u0006CA5r\u0013\t\u0011xN\u0001\u0004TiJLgn\u001a\t\u0003iVl\u0011!U\u0005\u0003mF\u00131!\u00118z\u0003\u0015\u0001\u0018M]:f)\u0015I\u00181AA\f!\rQx\u0010I\u0007\u0002w*\u0011A0`\u0001\u000bG>dG.Z2uS>t'B\u0001@\u0013\u0003\u0015)H/\u001b7t\u0013\r\t\ta\u001f\u0002\u0012\u00072|7/Z1cY\u0016LE/\u001a:bi>\u0014\bbBA\u0003\u000f\u0001\u0007\u0011qA\u0001\u0003SN\u0004B!!\u0003\u0002\u00145\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!\u0001\u0002j_*\u0011\u0011\u0011C\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0016\u0005-!aC%oaV$8\u000b\u001e:fC6Da!!\u0007\b\u0001\u0004\u0011\u0017AA3d\u0003\u00191\u0018\r\\;fgR1\u0011qDA\u0014\u0003W\u0001BA_@\u0002\"A!A/a\tt\u0013\r\t)#\u0015\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0007\u0003SA\u0001\u0019A=\u0002\rA\f'o]3e\u0011\u0019\tI\u0002\u0003a\u0001E\u0006\u00112\u000b[1qK\u001aLG.Z\"p]Z,'\u000f^3s!\tY&bE\u0002\u000b\u0003g\u00012\u0001^A\u001b\u0013\r\t9$\u0015\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005=\u0012\u0001D4fi\u0012\u000bG/Y*u_J,G\u0003BA \u0003'\u0002B!!\u0011\u0002P5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%A\u0005tQ\u0006\u0004XMZ5mK*!\u0011\u0011JA&\u0003\u0011!\u0017\r^1\u000b\u0007\u00055c#\u0001\u0005hK>$xn\u001c7t\u0013\u0011\t\t&a\u0011\u0003%MC\u0017\r]3gS2,G)\u0019;b'R|'/\u001a\u0005\u0007\u0003+b\u0001\u0019\u00019\u0002\tA\fG\u000f\u001b")
public class ShapefileConverter
extends AbstractConverter<SimpleFeature, AbstractConverter.BasicConfig, AbstractConverter.BasicField, AbstractConverter.BasicOptions> {
    public static ShapefileDataStore getDataStore(String string) {
        return ShapefileConverter$.MODULE$.getDataStore(string);
    }

    public EvaluationContext createEvaluationContext(Map<String, Object> globalParams) {
        Map shpParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ShapefileFunctionFactory$.MODULE$.InputSchemaKey()), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ShapefileFunctionFactory$.MODULE$.InputValuesKey()), Array$.MODULE$.empty(ClassTag$.MODULE$.Any()))}));
        return super.createEvaluationContext(globalParams.$plus$plus((GenTraversableOnce)shpParams));
    }

    public CloseableIterator<SimpleFeature> parse(InputStream is, EvaluationContext ec) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        package.CloseWithLogging$.MODULE$.apply((Object)is, IsCloseable$.MODULE$.closeableIsCloseable());
        String path = (String)EvaluationContext.RichEvaluationContext$.MODULE$.getInputFilePath$extension(EvaluationContext$.MODULE$.RichEvaluationContext(ec)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(67).append("Shapefile converter requires '").append(EvaluationContext$.MODULE$.InputFilePathKey()).append("' ").append("to be set in the evaluation context").toString());
        });
        ShapefileDataStore ds = ShapefileConverter$.MODULE$.getDataStore(path);
        SimpleFeatureType schema = ds.getSchema();
        String[] names = (String[])Array$.MODULE$.tabulate(schema.getAttributeCount(), (Function1 & Serializable & scala.Serializable)i -> ShapefileConverter.$anonfun$parse$2(schema, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(String.class));
        Object[] array = (Object[])Array$.MODULE$.ofDim(schema.getAttributeCount() + 1, ClassTag$.MODULE$.Any());
        int i2 = ec.indexOf(ShapefileFunctionFactory$.MODULE$.InputSchemaKey());
        int j = ec.indexOf(ShapefileFunctionFactory$.MODULE$.InputValuesKey());
        if (i2 == -1 || j == -1) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(88).append("Input schema not found in evaluation context, shapefile functions ").append(TextTools$.MODULE$.wordList((Iterable)new ShapefileFunctionFactory().functions().map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1.names().head(), Seq$.MODULE$.canBuildFrom()))).append(" will not be available").toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            ec.set(i2, (Object)names);
            ec.set(j, (Object)array);
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Query q = new Query();
        if (ds.getSchema().getCoordinateReferenceSystem() != null) {
            q.setCoordinateSystemReproject(package$.MODULE$.CRS_EPSG_4326());
            boxedUnit = BoxedUnit.UNIT;
        } else if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Shapefile does not have CRS info");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        CloseableIterator reader = CloseableIterator$.MODULE$.apply(ds.getFeatureSource().getReader(q)).map((Function1 & Serializable & scala.Serializable)f -> {
            ec.line_$eq(ec.line() + 1L);
            return f;
        });
        return CloseableIterator$.MODULE$.apply((Iterator)reader, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            package.CloseWithLogging$.MODULE$.apply((Object)reader, IsCloseable$.MODULE$.closeableIsCloseable());
            ds.dispose();
        });
    }

    public CloseableIterator<Object[]> values(CloseableIterator<SimpleFeature> parsed, EvaluationContext ec) {
        CloseableIterator closeableIterator;
        BoxedUnit boxedUnit;
        int i = ec.indexOf(ShapefileFunctionFactory$.MODULE$.InputValuesKey());
        int j = ec.indexOf(ShapefileFunctionFactory$.MODULE$.InputSchemaKey());
        if (i == -1 || j == -1) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(88).append("Input schema not found in evaluation context, shapefile functions ").append(TextTools$.MODULE$.wordList((Iterable)new ShapefileFunctionFactory().functions().map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.names().head(), Seq$.MODULE$.canBuildFrom()))).append(" will not be available").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (i == -1) {
            ObjectRef array = ObjectRef.create(null);
            closeableIterator = parsed.map((Function1 & Serializable & scala.Serializable)feature -> {
                if ((Object[])array$1.elem == null) {
                    array$1.elem = (Object[])Array$.MODULE$.ofDim(feature.getAttributeCount() + 1, ClassTag$.MODULE$.Any());
                }
                for (int i = 1; i < ((Object[])array$1.elem).length; ++i) {
                    ((Object[])array$1.elem)[i] = feature.getAttribute(i - 1);
                }
                ((Object[])array$1.elem)[0] = feature.getID();
                return (Object[])array$1.elem;
            });
        } else {
            Object[] array = (Object[])ec.get(i);
            closeableIterator = parsed.map((Function1 & Serializable & scala.Serializable)feature -> {
                for (int i = 1; i < array.length; ++i) {
                    array$2[i] = feature.getAttribute(i - 1);
                }
                array$2[0] = feature.getID();
                return array;
            });
        }
        return closeableIterator;
    }

    public static final /* synthetic */ String $anonfun$parse$2(SimpleFeatureType schema$1, int i) {
        return schema$1.getDescriptor(i).getLocalName();
    }

    public ShapefileConverter(SimpleFeatureType sft, AbstractConverter.BasicConfig config, Seq<AbstractConverter.BasicField> fields, AbstractConverter.BasicOptions options) {
        super(sft, (package.ConverterConfig)config, fields, (package.ConverterOptions)options);
    }
}

