/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.shp;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.locationtech.geomesa.utils.io.PathUtils$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;

public final class ShapefileConverter$
implements LazyLogging {
    public static ShapefileConverter$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ShapefileConverter$();
    }

    private Logger logger$lzycompute() {
        ShapefileConverter$ shapefileConverter$ = this;
        synchronized (shapefileConverter$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public ShapefileDataStore getDataStore(String path) {
        Map<String, URL> params = Collections.singletonMap(ShapefileDataStoreFactory.URLP.key, PathUtils$.MODULE$.getUrl(path));
        ShapefileDataStore ds = (ShapefileDataStore)DataStoreFinder.getDataStore(params);
        Option<Charset> option = this.tryInferCharsetFromCPG(path);
        if (option instanceof Some) {
            Some some = (Some)option;
            Charset charset = (Charset)some.value();
            ds.setCharset(charset);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        if (ds == null) {
            throw new IllegalArgumentException(new StringBuilder(38).append("Could not read shapefile using path '").append(path).append("'").toString());
        }
        return ds;
    }

    private Option<Charset> tryInferCharsetFromCPG(String path) {
        None$ none$;
        String baseName;
        Path shpDirPath = Paths.get(path, new String[0]).getParent();
        Tuple2 tuple2 = PathUtils$.MODULE$.getBaseNameAndExtension(path, PathUtils$.MODULE$.getBaseNameAndExtension$default$2());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String string = baseName = (String)tuple2._1();
        String baseName2 = string;
        Path cpgPath = shpDirPath.resolve(new StringBuilder(4).append(baseName2).append(".cpg").toString());
        if (!Files.isRegularFile(cpgPath, new LinkOption[0])) {
            none$ = None$.MODULE$;
        } else {
            try (BufferedSource source = Source$.MODULE$.fromFile(cpgPath.toFile(), Codec$.MODULE$.fallbackSystemCodec());){
                try {
                    None$ none$2;
                    List list = source.getLines().take(1).toList();
                    if (Nil$.MODULE$.equals(list)) {
                        none$2 = None$.MODULE$;
                    } else if (list instanceof .colon.colon) {
                        .colon.colon colon2 = (.colon.colon)list;
                        String charsetName = (String)colon2.head();
                        none$2 = new Some((Object)Charset.forName(charsetName.trim()));
                    } else {
                        throw new MatchError((Object)list);
                    }
                    none$ = none$2;
                }
                catch (Exception e) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Can't figure out charset from cpg file, will use default charset");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    none$ = None$.MODULE$;
                }
            }
        }
        return none$;
    }

    private ShapefileConverter$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

