/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.shp;

import com.codahale.metrics.Counter;
import java.io.InputStream;
import java.io.Serializable;
import org.geotools.data.Query;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert.EvaluationContext$;
import org.locationtech.geomesa.convert.shp.ShapefileConverter$;
import org.locationtech.geomesa.convert.shp.ShapefileFunctionFactory;
import org.locationtech.geomesa.convert.shp.ShapefileFunctionFactory$;
import org.locationtech.geomesa.convert2.AbstractConverter;
import org.locationtech.geomesa.convert2.package;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.text.TextTools$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\b\u0011\u0001mA\u0011\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012%\t\u0013%\u0003!\u0011!Q\u0001\n1R\u0005\"C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'X\u0011%A\u0006A!A!\u0002\u0013\t\u0015\fC\u0003[\u0001\u0011\u00051\fC\u0003c\u0001\u0011\u00053\rC\u0003c\u0001\u0011\u0005\u0013\u0010C\u0004\u0002\u0014\u0001!\t&!\u0006\t\u000f\u0005}\u0002\u0001\"\u0015\u0002B\u001d9\u0011\u0011\u000b\t\t\u0002\u0005McAB\b\u0011\u0011\u0003\t)\u0006\u0003\u0004[\u0017\u0011\u0005\u0011Q\u000e\u0005\b\u0003_ZA\u0011AA9\u0011\u001d\tYi\u0003C\u0005\u0003\u001b\u0013!c\u00155ba\u00164\u0017\u000e\\3D_:4XM\u001d;fe*\u0011\u0011CE\u0001\u0004g\"\u0004(BA\n\u0015\u0003\u001d\u0019wN\u001c<feRT!!\u0006\f\u0002\u000f\u001d,w.\\3tC*\u0011q\u0003G\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u00023\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\b\t\u0007;\u0001\u0012CFP!\u000e\u0003yQ!a\b\u000b\u0002\u0011\r|gN^3siJJ!!\t\u0010\u0003#\u0005\u00137\u000f\u001e:bGR\u001cuN\u001c<feR,'\u000f\u0005\u0002$U5\tAE\u0003\u0002&M\u000511/[7qY\u0016T!a\n\u0015\u0002\u000f\u0019,\u0017\r^;sK*\u0011\u0011\u0006G\u0001\b_B,gnZ5t\u0013\tYCEA\u0007TS6\u0004H.\u001a$fCR,(/\u001a\t\u0003[mr!AL\u001d\u000f\u0005=BdB\u0001\u00198\u001d\t\tdG\u0004\u00023k5\t1G\u0003\u000255\u00051AH]8pizJ\u0011!G\u0005\u0003/aI!!\u0006\f\n\u0005}!\u0012B\u0001\u001e\u001f\u0003E\t%m\u001d;sC\u000e$8i\u001c8wKJ$XM]\u0005\u0003yu\u00121BQ1tS\u000e\u001cuN\u001c4jO*\u0011!H\b\t\u0003[}J!\u0001Q\u001f\u0003\u0015\t\u000b7/[2GS\u0016dG\r\u0005\u0002.\u0005&\u00111)\u0010\u0002\r\u0005\u0006\u001c\u0018nY(qi&|gn]\u0001\u0004g\u001a$\bCA\u0012G\u0013\t9EEA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016L!\u0001\u0012\u0011\u0002\r\r|gNZ5h\u0013\tI\u0005%\u0001\u0004gS\u0016dGm\u001d\t\u0004\u001bRsdB\u0001(R\u001d\t\u0011t*C\u0001Q\u0003\u0015\u00198-\u00197b\u0013\t\u00116+A\u0004qC\u000e\\\u0017mZ3\u000b\u0003AK!!\u0016,\u0003\u0007M+\u0017O\u0003\u0002S'&\u00111\nI\u0001\b_B$\u0018n\u001c8t\u0013\tA\u0006%\u0001\u0004=S:LGO\u0010\u000b\u00069z{\u0006-\u0019\t\u0003;\u0002i\u0011\u0001\u0005\u0005\u0006\t\u0016\u0001\r!\u0012\u0005\u0006\u0013\u0016\u0001\r\u0001\f\u0005\u0006\u0017\u0016\u0001\r\u0001\u0014\u0005\u00061\u0016\u0001\r!Q\u0001\u0018GJ,\u0017\r^3Fm\u0006dW/\u0019;j_:\u001cuN\u001c;fqR$\"\u0001\u001a5\u0011\u0005\u00154W\"\u0001\n\n\u0005\u001d\u0014\"!E#wC2,\u0018\r^5p]\u000e{g\u000e^3yi\"9\u0011N\u0002I\u0001\u0002\u0004Q\u0017\u0001D4m_\n\fG\u000eU1sC6\u001c\b\u0003B6peVt!\u0001\\7\u0011\u0005I\u001a\u0016B\u00018T\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001/\u001d\u0002\u0004\u001b\u0006\u0004(B\u00018T!\tY7/\u0003\u0002uc\n11\u000b\u001e:j]\u001e\u0004\"A^<\u000e\u0003MK!\u0001_*\u0003\u0007\u0005s\u0017\u0010F\u0003eun\fy\u0001C\u0003j\u000f\u0001\u0007!\u000eC\u0003}\u000f\u0001\u0007Q0A\u0004tk\u000e\u001cWm]:\u0011\u0007y\fY!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\u000f5,GO]5dg*!\u0011QAA\u0004\u0003!\u0019w\u000eZ1iC2,'BAA\u0005\u0003\r\u0019w.\\\u0005\u0004\u0003\u001by(aB\"pk:$XM\u001d\u0005\u0007\u0003#9\u0001\u0019A?\u0002\u000f\u0019\f\u0017\u000e\\;sK\u0006)\u0001/\u0019:tKR1\u0011qCA\u0014\u0003w\u0001R!!\u0007\u0002$\tj!!a\u0007\u000b\t\u0005u\u0011qD\u0001\u000bG>dG.Z2uS>t'bAA\u0011)\u0005)Q\u000f^5mg&!\u0011QEA\u000e\u0005E\u0019En\\:fC\ndW-\u0013;fe\u0006$xN\u001d\u0005\b\u0003SA\u0001\u0019AA\u0016\u0003\tI7\u000f\u0005\u0003\u0002.\u0005]RBAA\u0018\u0015\u0011\t\t$a\r\u0002\u0005%|'BAA\u001b\u0003\u0011Q\u0017M^1\n\t\u0005e\u0012q\u0006\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0004\u0002>!\u0001\r\u0001Z\u0001\u0003K\u000e\faA^1mk\u0016\u001cHCBA\"\u0003\u0017\ny\u0005\u0005\u0004\u0002\u001a\u0005\r\u0012Q\t\t\u0005m\u0006\u001dS/C\u0002\u0002JM\u0013Q!\u0011:sCfDq!!\u0014\n\u0001\u0004\t9\"\u0001\u0004qCJ\u001cX\r\u001a\u0005\u0007\u0003{I\u0001\u0019\u00013\u0002%MC\u0017\r]3gS2,7i\u001c8wKJ$XM\u001d\t\u0003;.\u0019RaCA,\u0003;\u00022A^A-\u0013\r\tYf\u0015\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005}\u0013\u0011N\u0007\u0003\u0003CRA!a\u0019\u0002f\u0005a1oY1mC2|wmZ5oO*!\u0011qMA\u0004\u0003!!\u0018\u0010]3tC\u001a,\u0017\u0002BA6\u0003C\u00121\u0002T1{s2{wmZ5oOR\u0011\u00111K\u0001\rO\u0016$H)\u0019;b'R|'/\u001a\u000b\u0005\u0003g\n9\t\u0005\u0003\u0002v\u0005\rUBAA<\u0015\u0011\tI(a\u001f\u0002\u0013MD\u0017\r]3gS2,'\u0002BA?\u0003\u007f\nA\u0001Z1uC*\u0019\u0011\u0011\u0011\r\u0002\u0011\u001d,w\u000e^8pYNLA!!\"\u0002x\t\u00112\u000b[1qK\u001aLG.\u001a#bi\u0006\u001cFo\u001c:f\u0011\u0019\tI)\u0004a\u0001e\u0006!\u0001/\u0019;i\u0003Y!(/_%oM\u0016\u00148\t[1sg\u0016$hI]8n\u0007B;E\u0003BAH\u0003K\u0003RA^AI\u0003+K1!a%T\u0005\u0019y\u0005\u000f^5p]B!\u0011qSAQ\u001b\t\tIJ\u0003\u0003\u0002\u001c\u0006u\u0015aB2iCJ\u001cX\r\u001e\u0006\u0005\u0003?\u000b\u0019$A\u0002oS>LA!a)\u0002\u001a\n91\t[1sg\u0016$\bBBAE\u001d\u0001\u0007!\u000f")
public class ShapefileConverter
extends AbstractConverter<SimpleFeature, AbstractConverter.BasicConfig, AbstractConverter.BasicField, AbstractConverter.BasicOptions> {
    public static ShapefileDataStore getDataStore(String string) {
        return ShapefileConverter$.MODULE$.getDataStore(string);
    }

    public EvaluationContext createEvaluationContext(Map<String, Object> globalParams) {
        Map shpParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ShapefileFunctionFactory$.MODULE$.InputSchemaKey()), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ShapefileFunctionFactory$.MODULE$.InputValuesKey()), Array$.MODULE$.empty(ClassTag$.MODULE$.Any()))}));
        return super.createEvaluationContext(globalParams.$plus$plus((GenTraversableOnce)shpParams));
    }

    public EvaluationContext createEvaluationContext(Map<String, Object> globalParams, Counter success, Counter failure) {
        Map shpParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ShapefileFunctionFactory$.MODULE$.InputSchemaKey()), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ShapefileFunctionFactory$.MODULE$.InputValuesKey()), Array$.MODULE$.empty(ClassTag$.MODULE$.Any()))}));
        return super.createEvaluationContext(globalParams.$plus$plus((GenTraversableOnce)shpParams), success, failure);
    }

    public CloseableIterator<SimpleFeature> parse(InputStream is, EvaluationContext ec) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        package.CloseWithLogging$.MODULE$.apply((Object)is, IsCloseable$.MODULE$.closeableIsCloseable());
        String path = (String)EvaluationContext.RichEvaluationContext$.MODULE$.getInputFilePath$extension(EvaluationContext$.MODULE$.RichEvaluationContext(ec)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(67).append("Shapefile converter requires '").append(EvaluationContext$.MODULE$.InputFilePathKey()).append("' ").append("to be set in the evaluation context").toString());
        });
        ShapefileDataStore ds = ShapefileConverter$.MODULE$.getDataStore(path);
        SimpleFeatureType schema = ds.getSchema();
        String[] names = (String[])Array$.MODULE$.tabulate(schema.getAttributeCount(), (Function1 & Serializable & scala.Serializable)i -> ShapefileConverter.$anonfun$parse$2(schema, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(String.class));
        Object[] array = (Object[])Array$.MODULE$.ofDim(schema.getAttributeCount() + 1, ClassTag$.MODULE$.Any());
        int i2 = ec.indexOf(ShapefileFunctionFactory$.MODULE$.InputSchemaKey());
        int j = ec.indexOf(ShapefileFunctionFactory$.MODULE$.InputValuesKey());
        if (i2 == -1 || j == -1) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(88).append("Input schema not found in evaluation context, shapefile functions ").append(TextTools$.MODULE$.wordList((Iterable)new ShapefileFunctionFactory().functions().map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1.names().head(), Seq$.MODULE$.canBuildFrom()))).append(" will not be available").toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            ec.set(i2, (Object)names);
            ec.set(j, (Object)array);
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Query q = new Query();
        if (ds.getSchema().getCoordinateReferenceSystem() != null) {
            q.setCoordinateSystemReproject(package$.MODULE$.CRS_EPSG_4326());
            boxedUnit = BoxedUnit.UNIT;
        } else if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Shapefile does not have CRS info");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        CloseableIterator reader = CloseableIterator$.MODULE$.apply(ds.getFeatureSource().getReader(q)).map((Function1 & Serializable & scala.Serializable)f -> {
            ec.line_$eq(ec.line() + 1L);
            return f;
        });
        return CloseableIterator$.MODULE$.apply((Iterator)reader, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            package.CloseWithLogging$.MODULE$.apply((Object)reader, IsCloseable$.MODULE$.closeableIsCloseable());
            ds.dispose();
        });
    }

    public CloseableIterator<Object[]> values(CloseableIterator<SimpleFeature> parsed, EvaluationContext ec) {
        CloseableIterator closeableIterator;
        BoxedUnit boxedUnit;
        int i = ec.indexOf(ShapefileFunctionFactory$.MODULE$.InputValuesKey());
        int j = ec.indexOf(ShapefileFunctionFactory$.MODULE$.InputSchemaKey());
        if (i == -1 || j == -1) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(88).append("Input schema not found in evaluation context, shapefile functions ").append(TextTools$.MODULE$.wordList((Iterable)new ShapefileFunctionFactory().functions().map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.names().head(), Seq$.MODULE$.canBuildFrom()))).append(" will not be available").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (i == -1) {
            ObjectRef array = ObjectRef.create(null);
            closeableIterator = parsed.map((Function1 & Serializable & scala.Serializable)feature -> {
                if ((Object[])array$1.elem == null) {
                    array$1.elem = (Object[])Array$.MODULE$.ofDim(feature.getAttributeCount() + 1, ClassTag$.MODULE$.Any());
                }
                for (int i = 1; i < ((Object[])array$1.elem).length; ++i) {
                    ((Object[])array$1.elem)[i] = feature.getAttribute(i - 1);
                }
                ((Object[])array$1.elem)[0] = feature.getID();
                return (Object[])array$1.elem;
            });
        } else {
            Object[] array = (Object[])ec.get(i);
            closeableIterator = parsed.map((Function1 & Serializable & scala.Serializable)feature -> {
                for (int i = 1; i < array.length; ++i) {
                    array$2[i] = feature.getAttribute(i - 1);
                }
                array$2[0] = feature.getID();
                return array;
            });
        }
        return closeableIterator;
    }

    public static final /* synthetic */ String $anonfun$parse$2(SimpleFeatureType schema$1, int i) {
        return schema$1.getDescriptor(i).getLocalName();
    }

    public ShapefileConverter(SimpleFeatureType sft, AbstractConverter.BasicConfig config, Seq<AbstractConverter.BasicField> fields, AbstractConverter.BasicOptions options) {
        super(sft, (package.ConverterConfig)config, fields, (package.ConverterOptions)options);
    }
}

