/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.shp;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.locationtech.geomesa.utils.io.PathUtils$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;

public final class ShapefileConverter$
implements LazyLogging {
    public static final ShapefileConverter$ MODULE$ = new ShapefileConverter$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        ShapefileConverter$ shapefileConverter$ = this;
        synchronized (shapefileConverter$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public ShapefileDataStore getDataStore(String path, Charset charset) {
        Map<String, Charset> params = Map.of(ShapefileDataStoreFactory.URLP.key, PathUtils$.MODULE$.getUrl(path), ShapefileDataStoreFactory.DBFCHARSET.key, charset);
        ShapefileDataStore ds = (ShapefileDataStore)DataStoreFinder.getDataStore(params);
        if (ds == null) {
            throw new IllegalArgumentException(new StringBuilder(38).append("Could not read shapefile using path '").append(path).append("'").toString());
        }
        this.tryInferCharsetFromCPG(path).foreach((Function1 & Serializable)x$1 -> {
            ds.setCharset(x$1);
            return BoxedUnit.UNIT;
        });
        return ds;
    }

    private Option<Charset> tryInferCharsetFromCPG(String path) {
        None$ none$;
        block11: {
            Path shpDirPath = Paths.get(path, new String[0]).getParent();
            Tuple2 tuple2 = PathUtils$.MODULE$.getBaseNameAndExtension(path, PathUtils$.MODULE$.getBaseNameAndExtension$default$2());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String baseName = (String)tuple2._1();
            String baseName2 = baseName;
            Path cpgPath = shpDirPath.resolve(new StringBuilder(4).append(baseName2).append(".cpg").toString());
            if (!Files.isRegularFile(cpgPath, new LinkOption[0])) {
                return None$.MODULE$;
            }
            try (BufferedSource source = Source$.MODULE$.fromFile(cpgPath.toFile(), Codec$.MODULE$.fallbackSystemCodec());){
                try {
                    List list = source.getLines().take(1).toList();
                    if (Nil$.MODULE$.equals(list)) {
                        none$ = None$.MODULE$;
                        break block11;
                    }
                    if (list instanceof .colon.colon) {
                        .colon.colon colon2 = (.colon.colon)list;
                        String charsetName = (String)colon2.head();
                        none$ = new Some((Object)Charset.forName(charsetName.trim()));
                        break block11;
                    }
                    throw new MatchError((Object)list);
                }
                catch (Exception exception) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Can't figure out charset from cpg file, will use default charset");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    none$ = None$.MODULE$;
                }
            }
        }
        return none$;
    }

    private ShapefileConverter$() {
    }
}

