/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.text;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.geotools.util.Converters;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert.text.DelimitedTextConverter;
import org.locationtech.geomesa.convert.text.DelimitedTextConverter$Formats$;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.converters.StringCollectionConverterFactory$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Stream;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

public final class DelimitedTextConverter$ {
    public static DelimitedTextConverter$ MODULE$;
    private final Map<String, CSVFormat> formats;
    private final Stream<CSVFormat> inferences;

    static {
        new DelimitedTextConverter$();
    }

    public CSVFormat createFormat(String name, DelimitedTextConverter.DelimitedTextOptions options) {
        ObjectRef format = ObjectRef.create((Object)((CSVFormat)this.formats().getOrElse((Object)name.toUpperCase(Locale.US), (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(32).append("Unknown delimited text format '").append(name).append("'").toString());
        })));
        options.quote().foreach((Function1 & Serializable & scala.Serializable)c -> {
            format.elem = ((CSVFormat)format.elem).withQuote(c);
            return BoxedUnit.UNIT;
        });
        options.escape().foreach((Function1 & Serializable & scala.Serializable)c -> {
            format.elem = ((CSVFormat)format.elem).withEscape(c);
            return BoxedUnit.UNIT;
        });
        options.delimiter().foreach((Function1 & Serializable & scala.Serializable)c -> {
            format.elem = ((CSVFormat)format.elem).withDelimiter(BoxesRunTime.unboxToChar((Object)c));
            return BoxedUnit.UNIT;
        });
        return (CSVFormat)format.elem;
    }

    public CloseableIterator<CSVRecord> iterator(CSVFormat format, InputStream is, Charset encoding, int skip, EvaluationContext ec) {
        return new DelimitedTextConverter.CsvIterator(format, is, encoding, skip, ec);
    }

    /*
     * Unable to fully structure code
     */
    public CloseableIterator<SimpleFeature> magicParsing(String typeName, InputStream is, CSVFormat format) {
        parser = format.parse((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
        records = parser.iterator();
        v0 = header = records.hasNext() != false ? (CSVRecord)records.next() : null;
        if (header == null) ** GOTO lbl-1000
        v1 = header.get(0);
        var7_7 = "id";
        if (!(v1 != null ? v1.equals(var7_7) == false : var7_7 != null)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        Predef$.MODULE$.require(v2, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$magicParsing$1(), ()Ljava/lang/String;)());
        sftString = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), header.size()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$magicParsing$2$adapted(org.apache.commons.csv.CSVRecord java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)((CSVRecord)header), IndexedSeq$.MODULE$.canBuildFrom())).mkString(",");
        sft = SimpleFeatureTypes$.MODULE$.createType(typeName, sftString);
        converters = (Tuple2[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$magicParsing$3(org.opengis.feature.type.AttributeDescriptor ), (Lorg/opengis/feature/type/AttributeDescriptor;)Lscala/Tuple2;)(), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        features = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(records).asScala()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$magicParsing$4(org.opengis.feature.simple.SimpleFeatureType scala.Tuple2[] org.apache.commons.csv.CSVRecord ), (Lorg/apache/commons/csv/CSVRecord;)Lorg/locationtech/geomesa/features/ScalaSimpleFeature;)((SimpleFeatureType)sft, (Tuple2[])converters));
        return CloseableIterator$.MODULE$.apply(features, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$magicParsing$5(org.apache.commons.csv.CSVParser ), ()V)((CSVParser)parser));
    }

    public CSVFormat magicParsing$default$3() {
        return DelimitedTextConverter$Formats$.MODULE$.QuotedMinimal();
    }

    public Map<String, CSVFormat> formats() {
        return this.formats;
    }

    public Stream<CSVFormat> inferences() {
        return this.inferences;
    }

    public static final /* synthetic */ String $anonfun$magicParsing$1() {
        return "Badly formatted file detected - expected header row with attributes";
    }

    public static final /* synthetic */ Tuple2 $anonfun$magicParsing$3(AttributeDescriptor ad) {
        Object object;
        Hints hints = GeoTools.getDefaultHints();
        if (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(ad))) {
            object = hints.put((Object)StringCollectionConverterFactory$.MODULE$.ListTypeKey(), (Object)RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(ad)));
        } else if (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isMap$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(ad))) {
            Tuple2 tuple2 = RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getMapTypes$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(ad));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Class k = (Class)tuple2._1();
            Class v = (Class)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k, (Object)v);
            Tuple2 tuple23 = tuple22;
            Class k2 = (Class)tuple23._1();
            Class v2 = (Class)tuple23._2();
            hints.put((Object)StringCollectionConverterFactory$.MODULE$.MapKeyTypeKey(), (Object)k2);
            object = hints.put((Object)StringCollectionConverterFactory$.MODULE$.MapValueTypeKey(), (Object)v2);
        } else {
            object = BoxedUnit.UNIT;
        }
        return new Tuple2((Object)ad.getType().getBinding(), (Object)hints);
    }

    public static final /* synthetic */ ScalaSimpleFeature $anonfun$magicParsing$4(SimpleFeatureType sft$1, Tuple2[] converters$1, CSVRecord record) {
        Object[] attributes = (Object[])Array$.MODULE$.ofDim(sft$1.getAttributeCount(), ClassTag$.MODULE$.AnyRef());
        for (int i = 1; i < record.size(); ++i) {
            Tuple2 tuple2 = converters$1[i - 1];
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Class clas = (Class)tuple2._1();
            Hints hints = (Hints)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)clas, (Object)hints);
            Tuple2 tuple23 = tuple22;
            Class clas2 = (Class)tuple23._1();
            Hints hints2 = (Hints)tuple23._2();
            attributes[i - 1] = Converters.convert((Object)record.get(i), (Class)clas2, (Hints)hints2);
        }
        return new ScalaSimpleFeature(sft$1, record.get(0), attributes, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
    }

    public static final /* synthetic */ void $anonfun$magicParsing$5(CSVParser parser$1) {
        parser$1.close();
    }

    private DelimitedTextConverter$() {
        MODULE$ = this;
        this.formats = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CSV"), (Object)DelimitedTextConverter$Formats$.MODULE$.Default()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DEFAULT"), (Object)DelimitedTextConverter$Formats$.MODULE$.Default()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"EXCEL"), (Object)DelimitedTextConverter$Formats$.MODULE$.Excel()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MYSQL"), (Object)DelimitedTextConverter$Formats$.MODULE$.MySql()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TDF"), (Object)DelimitedTextConverter$Formats$.MODULE$.Tabs()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TSV"), (Object)DelimitedTextConverter$Formats$.MODULE$.Tabs()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TAB"), (Object)DelimitedTextConverter$Formats$.MODULE$.Tabs()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"RFC4180"), (Object)DelimitedTextConverter$Formats$.MODULE$.Rfc4180()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"QUOTED"), (Object)DelimitedTextConverter$Formats$.MODULE$.Quoted()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"QUOTE_ESCAPE"), (Object)DelimitedTextConverter$Formats$.MODULE$.QuoteEscape()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"QUOTED_WITH_QUOTE_ESCAPE"), (Object)DelimitedTextConverter$Formats$.MODULE$.QuotedQuoteEscape()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"QUOTED_MINIMAL"), (Object)DelimitedTextConverter$Formats$.MODULE$.QuotedMinimal()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TSV_QUOTED_MINIMAL"), (Object)DelimitedTextConverter$Formats$.MODULE$.TabsQuotedMinimal())}));
        this.inferences = package$.MODULE$.Stream().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CSVFormat[]{DelimitedTextConverter$Formats$.MODULE$.Tabs(), DelimitedTextConverter$Formats$.MODULE$.Quoted(), DelimitedTextConverter$Formats$.MODULE$.Default()}));
    }

    public static final /* synthetic */ String $anonfun$magicParsing$2$adapted(CSVRecord header$1, Object x$1) {
        return header$1.get(BoxesRunTime.unboxToInt((Object)x$1));
    }
}

