/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.text;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.IOUtils;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.convert.EvaluationContext$;
import org.locationtech.geomesa.convert.Modes;
import org.locationtech.geomesa.convert.text.DelimitedTextConverter;
import org.locationtech.geomesa.convert.text.DelimitedTextConverter$;
import org.locationtech.geomesa.convert.text.DelimitedTextConverter$CharNotSpecified$;
import org.locationtech.geomesa.convert.text.DelimitedTextConverter$Formats$;
import org.locationtech.geomesa.convert.text.DelimitedTextConverterFactory$;
import org.locationtech.geomesa.convert.text.DelimitedTextConverterFactory$DelimitedTextConfigConvert$;
import org.locationtech.geomesa.convert.text.DelimitedTextConverterFactory$DelimitedTextOptionsConvert$;
import org.locationtech.geomesa.convert2.AbstractConverter;
import org.locationtech.geomesa.convert2.AbstractConverterFactory;
import org.locationtech.geomesa.convert2.AbstractConverterFactory$;
import org.locationtech.geomesa.convert2.TypeInference;
import org.locationtech.geomesa.convert2.TypeInference$;
import org.locationtech.geomesa.convert2.package;
import org.locationtech.geomesa.convert2.transforms.Expression;
import org.locationtech.geomesa.convert2.transforms.Expression$;
import org.locationtech.geomesa.convert2.validators.SimpleFeatureValidator$;
import org.locationtech.geomesa.utils.geotools.ObjectType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.text.TextTools$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tmc\u0001B\u000b\u0017\u0001\u0005BQ\u0001\u0014\u0001\u0005\u00025CQa\u0014\u0001\u0005BACaa\u0014\u0001\u0005B\u0005E\u0001BB(\u0001\t\u0013\t\u0019\u0004C\u0004\u0002f\u0001!I!a\u001a\b\u000f\u00055d\u0003#\u0001\u0002p\u00191QC\u0006E\u0001\u0003cBa\u0001T\u0004\u0005\u0002\u0005M\u0004\"CA;\u000f\t\u0007I\u0011AA<\u0011!\t\u0019i\u0002Q\u0001\n\u0005etaBAC\u000f!\u0005\u0011q\u0011\u0004\b\u0003\u0017;\u0001\u0012AAG\u0011\u0019aE\u0002\"\u0001\u0002\u001e\"9\u0011q\u0014\u0007\u0005R\u0005\u0005\u0006bBAt\u0019\u0011E\u0013\u0011^\u0004\b\u0003\u007f<\u0001\u0012\u0001B\u0001\r\u001d\u0011\u0019a\u0002E\u0001\u0005\u000bAa\u0001T\t\u0005\u0002\t5\u0001b\u0002B\b#\u0011E#\u0011\u0003\u0005\b\u0005#\nB\u0011\u000bB*\u0005u!U\r\\5nSR,G\rV3yi\u000e{gN^3si\u0016\u0014h)Y2u_JL(BA\f\u0019\u0003\u0011!X\r\u001f;\u000b\u0005eQ\u0012aB2p]Z,'\u000f\u001e\u0006\u00037q\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\u001e=\u0005aAn\\2bi&|g\u000e^3dQ*\tq$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001EA11E\n\u0015-\u0001&k\u0011\u0001\n\u0006\u0003Ki\t\u0001bY8om\u0016\u0014HOM\u0005\u0003O\u0011\u0012\u0001$\u00112tiJ\f7\r^\"p]Z,'\u000f^3s\r\u0006\u001cGo\u001c:z!\tI#&D\u0001\u0017\u0013\tYcC\u0001\fEK2LW.\u001b;fIR+\u0007\u0010^\"p]Z,'\u000f^3s!\tiSH\u0004\u0002/w9\u0011qF\u000f\b\u0003aer!!\r\u001d\u000f\u0005I:dBA\u001a7\u001b\u0005!$BA\u001b!\u0003\u0019a$o\\8u}%\tq$\u0003\u0002\u001e=%\u00111\u0004H\u0005\u00033iI!a\u0006\r\n\u0005q2\u0012A\u0006#fY&l\u0017\u000e^3e)\u0016DHoQ8om\u0016\u0014H/\u001a:\n\u0005yz$a\u0005#fY&l\u0017\u000e^3e)\u0016DHoQ8oM&<'B\u0001\u001f\u0017!\t\teI\u0004\u0002C\t:\u0011\u0001gQ\u0005\u0003KiI!!\u0012\u0013\u0002#\u0005\u00137\u000f\u001e:bGR\u001cuN\u001c<feR,'/\u0003\u0002H\u0011\nQ!)Y:jG\u001aKW\r\u001c3\u000b\u0005\u0015#\u0003CA\u0017K\u0013\tYuH\u0001\u000bEK2LW.\u001b;fIR+\u0007\u0010^(qi&|gn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00039\u0003\"!\u000b\u0001\u0002\u000b%tg-\u001a:\u0015\tE\u0003(0 \t\u0004%V;V\"A*\u000b\u0003Q\u000bQa]2bY\u0006L!AV*\u0003\r=\u0003H/[8o!\u0011\u0011\u0006L\u00174\n\u0005e\u001b&A\u0002+va2,'\u0007\u0005\u0002\\I6\tAL\u0003\u0002^=\u000611/[7qY\u0016T!a\u00181\u0002\u000f\u0019,\u0017\r^;sK*\u0011\u0011MY\u0001\u0004CBL'BA2\u001f\u0003!9Wm\u001c;p_2\u001c\u0018BA3]\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\t\u0003O:l\u0011\u0001\u001b\u0006\u0003S*\faaY8oM&<'BA6m\u0003!!\u0018\u0010]3tC\u001a,'\"A7\u0002\u0007\r|W.\u0003\u0002pQ\n11i\u001c8gS\u001eDQ!\u001d\u0002A\u0002I\f!![:\u0011\u0005MDX\"\u0001;\u000b\u0005U4\u0018AA5p\u0015\u00059\u0018\u0001\u00026bm\u0006L!!\u001f;\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\bw\n\u0001\n\u00111\u0001}\u0003\r\u0019h\r\u001e\t\u0004%VS\u0006b\u0002@\u0003!\u0003\u0005\ra`\u0001\u0005a\u0006$\b\u000e\u0005\u0003S+\u0006\u0005\u0001\u0003BA\u0002\u0003\u0017qA!!\u0002\u0002\bA\u00111gU\u0005\u0004\u0003\u0013\u0019\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002\u000e\u0005=!AB*ue&twMC\u0002\u0002\nM#\u0002\"a\u0005\u0002 \u0005\u0005\u00121\u0005\t\u0006\u0003+\tYbV\u0007\u0003\u0003/Q1!!\u0007T\u0003\u0011)H/\u001b7\n\t\u0005u\u0011q\u0003\u0002\u0004)JL\b\"B9\u0004\u0001\u0004\u0011\b\"B>\u0004\u0001\u0004a\bbBA\u0013\u0007\u0001\u0007\u0011qE\u0001\u0006Q&tGo\u001d\t\t\u0003\u0007\tI#!\u0001\u0002.%!\u00111FA\b\u0005\ri\u0015\r\u001d\t\u0004%\u0006=\u0012bAA\u0019'\n1\u0011I\\=SK\u001a$\u0002\"a\u0005\u00026\u00055\u00131\r\u0005\b\u0003o!\u0001\u0019AA\u001d\u0003\u00191wN]7biB!\u00111HA%\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013aA2tm*!\u00111IA#\u0003\u001d\u0019w.\\7p]NT1!a\u0012\u001f\u0003\u0019\t\u0007/Y2iK&!\u00111JA\u001f\u0005%\u00195K\u0016$pe6\fG\u000fC\u0004\u0002P\u0011\u0001\r!!\u0015\u0002\u000b1Lg.Z:\u0011\r\u0005M\u0013QLA\u0001\u001d\u0011\t)&!\u0017\u000f\u0007M\n9&C\u0001U\u0013\r\tYfU\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty&!\u0019\u0003\u0007M+\u0017OC\u0002\u0002\\MCQa\u001f\u0003A\u0002q\fQ!\\1hS\u000e$b!a\u0005\u0002j\u0005-\u0004bBA(\u000b\u0001\u0007\u0011\u0011\u000b\u0005\u0006w\u0016\u0001\r\u0001`\u0001\u001e\t\u0016d\u0017.\\5uK\u0012$V\r\u001f;D_:4XM\u001d;fe\u001a\u000b7\r^8ssB\u0011\u0011fB\n\u0004\u000f\u00055BCAA8\u00035!\u0016\u0010]3U_B\u0013xnY3tgV\u0011\u0011\u0011\u0010\t\u0005\u0003w\n\t)\u0004\u0002\u0002~)\u0019\u0011q\u0010<\u0002\t1\fgnZ\u0005\u0005\u0003\u001b\ti(\u0001\bUsB,Gk\u001c)s_\u000e,7o\u001d\u0011\u00025\u0011+G.[7ji\u0016$G+\u001a=u\u0007>tg-[4D_:4XM\u001d;\u0011\u0007\u0005%E\"D\u0001\b\u0005i!U\r\\5nSR,G\rV3yi\u000e{gNZ5h\u0007>tg/\u001a:u'\ra\u0011q\u0012\t\u0006\u0003#\u000b9\n\f\b\u0004\u0005\u0006M\u0015bAAKI\u0005A\u0012IY:ue\u0006\u001cGoQ8om\u0016\u0014H/\u001a:GC\u000e$xN]=\n\t\u0005e\u00151\u0014\u0002\u0017\u0007>tg/\u001a:uKJ\u001cuN\u001c4jO\u000e{gN^3si*\u0019\u0011Q\u0013\u0013\u0015\u0005\u0005\u001d\u0015\u0001\u00043fG>$WmQ8oM&<G\u0003DAR\u0003s\u000b)-!3\u0002\\\u0006\u0005\bcBA*\u0003K\u000bI\u000bL\u0005\u0005\u0003O\u000b\tG\u0001\u0004FSRDWM\u001d\t\u0005\u0003W\u000b),\u0004\u0002\u0002.*!\u0011qVAY\u0003\u0015)'O]8s\u0015\t\t\u0019,\u0001\u0006qkJ,7m\u001c8gS\u001eLA!a.\u0002.\n!2i\u001c8gS\u001e\u0014V-\u00193fe\u001a\u000b\u0017\u000e\\;sKNDq!a/\u000f\u0001\u0004\ti,A\u0002dkJ\u0004B!a0\u0002B6\u0011\u0011\u0011W\u0005\u0005\u0003\u0007\f\tL\u0001\nD_:4\u0017nZ(cU\u0016\u001cGoQ;sg>\u0014\bbBAd\u001d\u0001\u0007\u0011\u0011A\u0001\u0005if\u0004X\rC\u0004\u0002L:\u0001\r!!4\u0002\u000f%$g)[3mIB!!+VAh!\u0011\t\t.a6\u000e\u0005\u0005M'bAAkI\u0005QAO]1og\u001a|'/\\:\n\t\u0005e\u00171\u001b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007bBAo\u001d\u0001\u0007\u0011q\\\u0001\u0007G\u0006\u001c\u0007.Z:\u0011\u000f\u0005\r\u0011\u0011FA\u0001M\"9\u00111\u001d\bA\u0002\u0005\u0015\u0018\u0001C;tKJ$\u0015\r^1\u0011\u0011\u0005\r\u0011\u0011FA\u0001\u0003\u001f\fA\"\u001a8d_\u0012,7i\u001c8gS\u001e$b!a;\u0002r\u0006M\bc\u0001*\u0002n&\u0019\u0011q^*\u0003\tUs\u0017\u000e\u001e\u0005\u0006S>\u0001\r\u0001\f\u0005\b\u0003k|\u0001\u0019AA|\u0003\u0011\u0011\u0017m]3\u0011\u0011\u0005e\u0018Q`A\u0001\u0003[i!!a?\u000b\u0007\u0005ea/\u0003\u0003\u0002,\u0005m\u0018a\u0007#fY&l\u0017\u000e^3e)\u0016DHo\u00149uS>t7oQ8om\u0016\u0014H\u000fE\u0002\u0002\nF\u00111\u0004R3mS6LG/\u001a3UKb$x\n\u001d;j_:\u001c8i\u001c8wKJ$8cA\t\u0003\bA)\u0011\u0011\u0013B\u0005\u0013&!!1BAN\u0005]\u0019uN\u001c<feR,'o\u00149uS>t7oQ8om\u0016\u0014H\u000f\u0006\u0002\u0003\u0002\u0005iA-Z2pI\u0016|\u0005\u000f^5p]N$bBa\u0005\u0003\u0016\t]!1\u0004B\u0011\u0005g\u0011i\u0004E\u0004\u0002T\u0005\u0015\u0016\u0011V%\t\u000f\u0005m6\u00031\u0001\u0002>\"9!\u0011D\nA\u0002\u0005E\u0013A\u0003<bY&$\u0017\r^8sg\"9!QD\nA\u0002\t}\u0011!\u0003:fa>\u0014H/\u001a:t!\u0015\t\u0019&!\u0018g\u0011\u001d\u0011\u0019c\u0005a\u0001\u0005K\t\u0011\u0002]1sg\u0016lu\u000eZ3\u0011\t\t\u001d\"Q\u0006\b\u0004_\t%\u0012b\u0001B\u00161\u0005)Qj\u001c3fg&!!q\u0006B\u0019\u0005%\u0001\u0016M]:f\u001b>$WMC\u0002\u0003,aAqA!\u000e\u0014\u0001\u0004\u00119$A\u0005feJ|'/T8eKB!!q\u0005B\u001d\u0013\u0011\u0011YD!\r\u0003\u0013\u0015\u0013(o\u001c:N_\u0012,\u0007b\u0002B '\u0001\u0007!\u0011I\u0001\tK:\u001cw\u000eZ5oOB!!1\tB'\u001b\t\u0011)E\u0003\u0003\u0003H\t%\u0013aB2iCJ\u001cX\r\u001e\u0006\u0004\u0005\u00172\u0018a\u00018j_&!!q\nB#\u0005\u001d\u0019\u0005.\u0019:tKR\fQ\"\u001a8d_\u0012,w\n\u001d;j_:\u001cHCBAv\u0005+\u0012I\u0006\u0003\u0004\u0003XQ\u0001\r!S\u0001\b_B$\u0018n\u001c8t\u0011\u001d\t)\u0010\u0006a\u0001\u0003o\u0004")
public class DelimitedTextConverterFactory
extends AbstractConverterFactory<DelimitedTextConverter, DelimitedTextConverter.DelimitedTextConfig, AbstractConverter.BasicField, DelimitedTextConverter.DelimitedTextOptions> {
    public static String TypeToProcess() {
        return DelimitedTextConverterFactory$.MODULE$.TypeToProcess();
    }

    public Option<Tuple2<SimpleFeatureType, Config>> infer(InputStream is, Option<SimpleFeatureType> sft, Option<String> path) {
        return this.infer(is, sft, (Map<String, Object>)((Map)path.map((Function1 & Serializable & scala.Serializable)file -> EvaluationContext$.MODULE$.inputFileParam(file)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty()))).toOption();
    }

    public Try<Tuple2<SimpleFeatureType, Config>> infer(InputStream is, Option<SimpleFeatureType> sft, Map<String, Object> hints) {
        Try tryLines = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            int sampleSize = AbstractConverterFactory$.MODULE$.inferSampleSize();
            return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)IOUtils.lineIterator((InputStream)is, (String)StandardCharsets.UTF_8.displayName())).asScala()).take(sampleSize).toSeq();
        });
        return tryLines.flatMap((Function1 & Serializable & scala.Serializable)lines -> {
            if (lines.lengthCompare(2) < 0) {
                return new Failure((Throwable)new RuntimeException("Not enough lines in input data"));
            }
            Iterator attempts = package$.MODULE$.Iterator().single(this.magic((Seq<String>)lines, sft)).$plus$plus((Function0 & Serializable & scala.Serializable)() -> DelimitedTextConverter$.MODULE$.inferences().iterator().map((Function1 & Serializable & scala.Serializable)x$1 -> this.infer((CSVFormat)x$1, (Seq<String>)lines, sft)));
            return org.locationtech.geomesa.convert2.package$.MODULE$.multiTry(attempts, (Throwable)new RuntimeException("Could not parse input as delimited text"));
        });
    }

    private Try<Tuple2<SimpleFeatureType, Config>> infer(CSVFormat format, Seq<String> lines, Option<SimpleFeatureType> sft) {
        Seq rows = (Seq)lines.flatMap((Function1 & Serializable & scala.Serializable)line -> {
            if (TextTools$.MODULE$.isWhitespace(line)) {
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return Option$.MODULE$.option2Iterable(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((CSVRecord)format.parse((Reader)new StringReader((String)line)).iterator().next()).iterator()).asScala()).toList()).toOption());
        }, Seq$.MODULE$.canBuildFrom());
        Seq counts = (Seq)((SeqLike)rows.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.length()), Seq$.MODULE$.canBuildFrom())).distinct();
        if (counts.isEmpty() || counts.lengthCompare(3) > 0 || BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) < 2) {
            String string;
            CSVFormat cSVFormat = format;
            CSVFormat cSVFormat2 = DelimitedTextConverter$Formats$.MODULE$.Tabs();
            if (!(cSVFormat != null ? !cSVFormat.equals(cSVFormat2) : cSVFormat2 != null)) {
                string = "tsv";
            } else {
                CSVFormat cSVFormat3 = format;
                CSVFormat cSVFormat4 = DelimitedTextConverter$Formats$.MODULE$.Quoted();
                string = !(cSVFormat3 != null ? !cSVFormat3.equals(cSVFormat4) : cSVFormat4 != null) ? "quoted csv" : "csv";
            }
            String f = string;
            return new Failure((Throwable)new RuntimeException(new StringBuilder(46).append("Not a valid delimited text file using format: ").append(f).toString()));
        }
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Seq seq;
            Option option = sft;
            if (option instanceof Some) {
                Some some = (Some)option;
                SimpleFeatureType s = (SimpleFeatureType)some.value();
                seq = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(s.getAttributeDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getLocalName(), Buffer$.MODULE$.canBuildFrom());
            } else if (None$.MODULE$.equals(option)) {
                List values = (List)((List)rows.head()).map((Function1 & Serializable & scala.Serializable)v -> new TypeInference.PathWithValues("", (Iterable)new .colon.colon(v, (List)Nil$.MODULE$)), List$.MODULE$.canBuildFrom());
                seq = TypeInference$.MODULE$.infer((Seq)values, (Either)package$.MODULE$.Left().apply((Object)""), TypeInference$.MODULE$.infer$default$3(), TypeInference$.MODULE$.infer$default$4()).types().forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DelimitedTextConverterFactory.$anonfun$infer$13(x$4))) ? (Seq)rows.head() : (Seq)Nil$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            Seq names = seq;
            Iterator nameIter = names.iterator();
            Seq pathsAndValues = (Seq)Seq$.MODULE$.tabulate(BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)), (Function1 & Serializable & scala.Serializable)col -> DelimitedTextConverterFactory.$anonfun$infer$14(rows, nameIter, BoxesRunTime.unboxToInt((Object)col)));
            TypeInference.InferredTypesWithPaths inferred = TypeInference$.MODULE$.infer(pathsAndValues, sft.toRight((Function0 & Serializable & scala.Serializable)() -> {
                CSVFormat cSVFormat = format;
                CSVFormat cSVFormat2 = DelimitedTextConverter$Formats$.MODULE$.Tabs();
                return new StringBuilder(9).append("inferred-").append((Object)(!(cSVFormat != null ? !cSVFormat.equals(cSVFormat2) : cSVFormat2 != null) ? "tsv" : "csv")).toString();
            }), TypeInference$.MODULE$.infer$default$3(), TypeInference$.MODULE$.infer$default$4());
            DelimitedTextConverter.DelimitedTextConfig converterConfig = new DelimitedTextConverter.DelimitedTextConfig(this.typeToProcess(), (Option<String>)None$.MODULE$, (String)((Tuple2)DelimitedTextConverter$.MODULE$.formats().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DelimitedTextConverterFactory.$anonfun$infer$17(format, x$5))).get())._1(), (Option<Expression>)new Some((Object)Expression$.MODULE$.apply("md5(string2bytes($0))")), (Map<String, Config>)Predef$.MODULE$.Map().empty(), (Map<String, Expression>)Predef$.MODULE$.Map().empty());
            IntRef i = IntRef.create((int)0);
            Seq fields = (Seq)inferred.types().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TypeInference.TypeWithPath typeWithPath = x0$1;
                if (typeWithPath != null) {
                    TypeInference.InferredType inferredType = typeWithPath.inferredType();
                    ++i$1.elem;
                    return new AbstractConverter.BasicField(inferredType.name(), (Option)new Some((Object)Expression$.MODULE$.apply(inferredType.transform().apply(i$1.elem))));
                }
                throw new MatchError((Object)typeWithPath);
            }, Seq$.MODULE$.canBuildFrom());
            DelimitedTextConverter.DelimitedTextOptions options = new DelimitedTextConverter.DelimitedTextOptions((Option<Object>)None$.MODULE$, DelimitedTextConverter$CharNotSpecified$.MODULE$, DelimitedTextConverter$CharNotSpecified$.MODULE$, (Option<Object>)None$.MODULE$, (Seq<String>)SimpleFeatureValidator$.MODULE$.default(), (Seq<Config>)((Seq)Nil$.MODULE$), Modes.ParseMode$.MODULE$.Default(), (Enumeration.Value)Modes.ErrorMode$.MODULE$.apply(), StandardCharsets.UTF_8);
            Config config = this.configConvert().to((package.ConverterConfig)converterConfig).withFallback((ConfigMergeable)this.fieldConvert().to(fields.toSeq())).withFallback((ConfigMergeable)this.optsConvert().to((package.ConverterOptions)options)).toConfig();
            return new Tuple2((Object)inferred.sft(), (Object)config);
        });
    }

    private Try<Tuple2<SimpleFeatureType, Config>> magic(Seq<String> lines, Option<SimpleFeatureType> sft) {
        if (!((String)lines.head()).startsWith("id,")) {
            return new Failure((Throwable)new RuntimeException("Not a geomesa delimited export"));
        }
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String spec = (String)package.WithClose$.MODULE$.apply((Object)DelimitedTextConverter$Formats$.MODULE$.QuotedMinimal().parse((Reader)new StringReader((String)new StringOps(Predef$.MODULE$.augmentString((String)lines.head())).drop(3))), (Function1 & Serializable & scala.Serializable)result -> ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)result.iterator().next()).asScala()).mkString(","), IsCloseable$.MODULE$.closeableIsCloseable());
            SimpleFeatureType schema = SimpleFeatureTypes$.MODULE$.createType("", spec);
            DelimitedTextConverter.DelimitedTextConfig converterConfig = new DelimitedTextConverter.DelimitedTextConfig(this.typeToProcess(), (Option<String>)None$.MODULE$, (String)((Tuple2)DelimitedTextConverter$.MODULE$.formats().find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DelimitedTextConverterFactory.$anonfun$magic$3(x$6))).get())._1(), (Option<Expression>)new Some((Object)Expression$.MODULE$.apply("$1")), (Map<String, Config>)Predef$.MODULE$.Map().empty(), (Map<String, Expression>)Predef$.MODULE$.Map().empty());
            IntRef i = IntRef.create((int)1);
            Buffer fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getAttributeDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)d -> {
                TypeInference.IdentityTransform$ identityTransform$;
                Seq bindings = ObjectType$.MODULE$.selectType(d);
                Enumeration.Value value = (Enumeration.Value)bindings.head();
                Enumeration.Value value2 = ObjectType$.MODULE$.STRING();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    identityTransform$ = TypeInference.IdentityTransform$.MODULE$;
                } else {
                    Enumeration.Value value4 = ObjectType$.MODULE$.INT();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        identityTransform$ = TypeInference.CastToInt$.MODULE$;
                    } else {
                        Enumeration.Value value6 = ObjectType$.MODULE$.LONG();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            identityTransform$ = TypeInference.CastToLong$.MODULE$;
                        } else {
                            Enumeration.Value value8 = ObjectType$.MODULE$.FLOAT();
                            Enumeration.Value value9 = value;
                            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                                identityTransform$ = TypeInference.CastToFloat$.MODULE$;
                            } else {
                                Enumeration.Value value10 = ObjectType$.MODULE$.DOUBLE();
                                Enumeration.Value value11 = value;
                                if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                                    identityTransform$ = TypeInference.CastToDouble$.MODULE$;
                                } else {
                                    Enumeration.Value value12 = ObjectType$.MODULE$.BOOLEAN();
                                    Enumeration.Value value13 = value;
                                    if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                        identityTransform$ = TypeInference.CastToBoolean$.MODULE$;
                                    } else {
                                        Enumeration.Value value14 = ObjectType$.MODULE$.DATE();
                                        Enumeration.Value value15 = value;
                                        if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                                            identityTransform$ = new TypeInference.FunctionTransform("datetime(", ")");
                                        } else {
                                            Enumeration.Value value16 = ObjectType$.MODULE$.UUID();
                                            Enumeration.Value value17 = value;
                                            if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                                                identityTransform$ = TypeInference.IdentityTransform$.MODULE$;
                                            } else {
                                                Enumeration.Value value18 = ObjectType$.MODULE$.LIST();
                                                Enumeration.Value value19 = value;
                                                if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
                                                    identityTransform$ = new TypeInference.FunctionTransform(new StringBuilder(13).append("parseList('").append(bindings.apply(1)).append("',").toString(), ")");
                                                } else {
                                                    Enumeration.Value value20 = ObjectType$.MODULE$.MAP();
                                                    Enumeration.Value value21 = value;
                                                    if (!(value20 != null ? !value20.equals(value21) : value21 != null)) {
                                                        identityTransform$ = new TypeInference.FunctionTransform(new StringBuilder(14).append("parseMap('").append(bindings.apply(1)).append("->").append(bindings.apply(2)).append("',").toString(), ")");
                                                    } else {
                                                        Enumeration.Value value22 = ObjectType$.MODULE$.BYTES();
                                                        Enumeration.Value value23 = value;
                                                        if (!(value22 != null ? !value22.equals(value23) : value23 != null)) {
                                                            identityTransform$ = TypeInference.IdentityTransform$.MODULE$;
                                                        } else {
                                                            Enumeration.Value value24 = ObjectType$.MODULE$.GEOMETRY();
                                                            Enumeration.Value value25 = value;
                                                            if (!(value24 != null ? !value24.equals(value25) : value25 != null)) {
                                                                Enumeration.Value value26 = (Enumeration.Value)((TraversableLike)bindings.drop(1)).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> ObjectType$.MODULE$.GEOMETRY());
                                                                Enumeration.Value value27 = ObjectType$.MODULE$.POINT();
                                                                Enumeration.Value value28 = value26;
                                                                if (!(value27 != null ? !value27.equals(value28) : value28 != null)) {
                                                                    identityTransform$ = new TypeInference.FunctionTransform("point(", ")");
                                                                } else {
                                                                    Enumeration.Value value29 = ObjectType$.MODULE$.LINESTRING();
                                                                    Enumeration.Value value30 = value26;
                                                                    if (!(value29 != null ? !value29.equals(value30) : value30 != null)) {
                                                                        identityTransform$ = new TypeInference.FunctionTransform("linestring(", ")");
                                                                    } else {
                                                                        Enumeration.Value value31 = ObjectType$.MODULE$.POLYGON();
                                                                        Enumeration.Value value32 = value26;
                                                                        if (!(value31 != null ? !value31.equals(value32) : value32 != null)) {
                                                                            identityTransform$ = new TypeInference.FunctionTransform("polygon(", ")");
                                                                        } else {
                                                                            Enumeration.Value value33 = ObjectType$.MODULE$.MULTIPOINT();
                                                                            Enumeration.Value value34 = value26;
                                                                            if (!(value33 != null ? !value33.equals(value34) : value34 != null)) {
                                                                                identityTransform$ = new TypeInference.FunctionTransform("multipoint(", ")");
                                                                            } else {
                                                                                Enumeration.Value value35 = ObjectType$.MODULE$.MULTILINESTRING();
                                                                                Enumeration.Value value36 = value26;
                                                                                if (!(value35 != null ? !value35.equals(value36) : value36 != null)) {
                                                                                    identityTransform$ = new TypeInference.FunctionTransform("multilinestring(", ")");
                                                                                } else {
                                                                                    Enumeration.Value value37 = ObjectType$.MODULE$.MULTIPOLYGON();
                                                                                    Enumeration.Value value38 = value26;
                                                                                    if (!(value37 != null ? !value37.equals(value38) : value38 != null)) {
                                                                                        identityTransform$ = new TypeInference.FunctionTransform("multipolygon(", ")");
                                                                                    } else {
                                                                                        Enumeration.Value value39 = ObjectType$.MODULE$.GEOMETRY_COLLECTION();
                                                                                        Enumeration.Value value40 = value26;
                                                                                        identityTransform$ = !(value39 != null ? !value39.equals(value40) : value40 != null) ? new TypeInference.FunctionTransform("geometrycollection(", ")") : new TypeInference.FunctionTransform("geometry(", ")");
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            } else {
                                                                throw new IllegalStateException(new StringBuilder(20).append("Unexpected binding: ").append(bindings).toString());
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                TypeInference.IdentityTransform$ transform = identityTransform$;
                ++i$2.elem;
                return new AbstractConverter.BasicField(d.getLocalName(), (Option)new Some((Object)new Expression.TryExpression(Expression$.MODULE$.apply(((TypeInference.InferredTransform)transform).apply(i$2.elem)), (Expression)Expression.LiteralNull$.MODULE$)));
            }, Buffer$.MODULE$.canBuildFrom());
            DelimitedTextConverter.DelimitedTextOptions options = new DelimitedTextConverter.DelimitedTextOptions((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)1)), DelimitedTextConverter$CharNotSpecified$.MODULE$, DelimitedTextConverter$CharNotSpecified$.MODULE$, (Option<Object>)None$.MODULE$, (Seq<String>)SimpleFeatureValidator$.MODULE$.default(), (Seq<Config>)((Seq)Nil$.MODULE$), Modes.ParseMode$.MODULE$.Default(), (Enumeration.Value)Modes.ErrorMode$.MODULE$.apply(), StandardCharsets.UTF_8);
            Config config = this.configConvert().to((package.ConverterConfig)converterConfig).withFallback((ConfigMergeable)this.fieldConvert().to(fields.toSeq())).withFallback((ConfigMergeable)this.optsConvert().to((package.ConverterOptions)options)).toConfig();
            return new Tuple2(sft.getOrElse((Function0 & Serializable & scala.Serializable)() -> schema), (Object)config);
        });
    }

    public static final /* synthetic */ boolean $anonfun$infer$13(TypeInference.TypeWithPath x$4) {
        Enumeration.Value value = x$4.inferredType().typed();
        Enumeration.Value value2 = ObjectType$.MODULE$.STRING();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ TypeInference.PathWithValues $anonfun$infer$14(Seq rows$1, Iterator nameIter$1, int col) {
        Seq values = (Seq)((TraversableLike)rows$1.drop(1)).map((Function1 & Serializable & scala.Serializable)vals -> {
            if (vals.lengthCompare(col) > 0) {
                return (String)vals.apply(col);
            }
            return null;
        }, Seq$.MODULE$.canBuildFrom());
        return new TypeInference.PathWithValues(nameIter$1.hasNext() ? (String)nameIter$1.next() : "", (Iterable)values);
    }

    public static final /* synthetic */ boolean $anonfun$infer$17(CSVFormat format$1, Tuple2 x$5) {
        Object object = x$5._2();
        CSVFormat cSVFormat = format$1;
        return !(object != null ? !object.equals(cSVFormat) : cSVFormat != null);
    }

    public static final /* synthetic */ boolean $anonfun$magic$3(Tuple2 x$6) {
        Object object = x$6._2();
        CSVFormat cSVFormat = DelimitedTextConverter$Formats$.MODULE$.QuotedMinimal();
        return !(object != null ? !object.equals(cSVFormat) : cSVFormat != null);
    }

    public DelimitedTextConverterFactory() {
        super(DelimitedTextConverterFactory$.MODULE$.TypeToProcess(), (AbstractConverterFactory.ConverterConfigConvert)DelimitedTextConverterFactory$DelimitedTextConfigConvert$.MODULE$, (AbstractConverterFactory.FieldConvert)AbstractConverterFactory.BasicFieldConvert$.MODULE$, (AbstractConverterFactory.ConverterOptionsConvert)DelimitedTextConverterFactory$DelimitedTextOptionsConvert$.MODULE$, ClassTag$.MODULE$.apply(DelimitedTextConverter.class), ClassTag$.MODULE$.apply(DelimitedTextConverter.DelimitedTextConfig.class), ClassTag$.MODULE$.apply(AbstractConverter.BasicField.class), ClassTag$.MODULE$.apply(DelimitedTextConverter.DelimitedTextOptions.class));
    }
}

