/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.memory.cqengine.index;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.support.AbstractAttributeIndex;
import com.googlecode.cqengine.index.support.indextype.OnHeapTypeIndex;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.ResultSet;
import java.util.HashSet;
import java.util.Set;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.memory.cqengine.query.Intersects;
import org.locationtech.geomesa.utils.index.SpatialIndex;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.collection.Iterator;
import scala.runtime.AbstractFunction1;

public abstract class AbstractGeoIndex<A extends Geometry, O extends SimpleFeature>
extends AbstractAttributeIndex<A, O>
implements OnHeapTypeIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGeoIndex.class);
    private static final int INDEX_RETRIEVAL_COST = 40;
    private final SpatialIndex<O> index;
    private final int geomAttributeIndex;
    public static final ThreadLocal<SpatialIndex<? extends SimpleFeature>> lastUsed = new ThreadLocal();
    static Set<Class<? extends Query>> supportedQueries = new HashSet<Class<? extends Query>>(){
        {
            this.add(Intersects.class);
        }
    };

    AbstractGeoIndex(SimpleFeatureType sft, Attribute<O, A> attribute, SpatialIndex<O> index) {
        super(attribute, supportedQueries);
        this.index = index;
        this.geomAttributeIndex = sft.indexOf(attribute.getAttributeName());
    }

    public void init(ObjectStore<O> objectStore, QueryOptions queryOptions) {
        this.addAll(ObjectSet.fromObjectStore(objectStore, (QueryOptions)queryOptions), queryOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        try {
            boolean modified = false;
            for (SimpleFeature object : objectSet) {
                Geometry geom = (Geometry)object.getDefaultGeometry();
                this.index.insert(geom, object.getID(), (Object)object);
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            objectSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        try {
            boolean modified = false;
            for (SimpleFeature object : objectSet) {
                Geometry geom = (Geometry)object.getDefaultGeometry();
                this.index.remove(geom, object.getID());
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            objectSet.close();
        }
    }

    public void clear(QueryOptions queryOptions) {
        this.index.clear();
    }

    public void destroy(QueryOptions queryOptions) {
        this.index.clear();
    }

    public ResultSet<O> retrieve(Query<O> query, QueryOptions queryOptions) {
        lastUsed.set(this.index);
        return new GeoIndexResultSet(query, queryOptions);
    }

    private Iterator<O> getSimpleFeatureIteratorInternal(Intersects query, final QueryOptions queryOptions) {
        final Intersects intersects = query;
        Envelope queryEnvelope = intersects.getEnvelope();
        return this.index.query(queryEnvelope).filter((Function1)new AbstractFunction1<SimpleFeature, Object>(){

            public Object apply(SimpleFeature feature) {
                try {
                    Geometry geom = (Geometry)feature.getAttribute(AbstractGeoIndex.this.geomAttributeIndex);
                    return intersects.matchesValue(geom, queryOptions);
                }
                catch (Exception e) {
                    LOGGER.warn("Caught exception while trying to look up geometry", (Throwable)e);
                    return false;
                }
            }
        });
    }

    public boolean isMutable() {
        return true;
    }

    public boolean isQuantized() {
        return false;
    }

    public Index<O> getEffectiveIndex() {
        return this;
    }

    public class GeoIndexResultSet
    extends ResultSet<O> {
        private final Query<O> query;
        private final QueryOptions queryOptions;

        public GeoIndexResultSet(Query<O> query, QueryOptions queryOptions) {
            this.query = query;
            this.queryOptions = queryOptions;
        }

        public java.util.Iterator<O> iterator() {
            final Iterator iter = AbstractGeoIndex.this.getSimpleFeatureIteratorInternal((Intersects)this.query, this.queryOptions);
            return new java.util.Iterator<O>(){

                @Override
                public boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public O next() {
                    return (SimpleFeature)iter.next();
                }
            };
        }

        public boolean contains(O object) {
            Intersects intersects = (Intersects)this.query;
            Geometry geom = (Geometry)object.getAttribute(AbstractGeoIndex.this.geomAttributeIndex);
            return intersects.matchesValue(geom, this.queryOptions);
        }

        public boolean matches(O object) {
            return this.query.matches(object, this.queryOptions);
        }

        public Query<O> getQuery() {
            return this.query;
        }

        public QueryOptions getQueryOptions() {
            return this.queryOptions;
        }

        public int getRetrievalCost() {
            return 40;
        }

        public int getMergeCost() {
            return this.size();
        }

        public int size() {
            return AbstractGeoIndex.this.getSimpleFeatureIteratorInternal((Intersects)this.query, this.queryOptions).size();
        }

        public void close() {
        }
    }
}

