/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.memory.cqengine.utils;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.simple.All;
import com.googlecode.cqengine.query.simple.Between;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.query.simple.GreaterThan;
import com.googlecode.cqengine.query.simple.Has;
import com.googlecode.cqengine.query.simple.In;
import com.googlecode.cqengine.query.simple.LessThan;
import com.googlecode.cqengine.query.simple.None;
import com.googlecode.cqengine.query.simple.StringMatchesRegex;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.regex.Pattern;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.And;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNil;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.BinaryTemporalOperator;
import org.geotools.api.filter.temporal.During;
import org.geotools.filter.LikeToRegexConverter;
import org.geotools.filter.visitor.AbstractFilterVisitor;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.Bounds$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.memory.cqengine.query.GeoToolsFilterQuery;
import org.locationtech.geomesa.memory.cqengine.utils.BuildDateBetweenQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildDateGTEQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildDateGTQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildDateLTEQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildDateLTQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildDoubleBetweenQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildDoubleGTEQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildDoubleGTQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildDoubleLTEQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildDoubleLTQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildFloatBetweenQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildFloatGTEQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildFloatGTQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildFloatLTEQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildFloatLTQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildIntBetweenQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildIntGTEQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildIntGTQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildIntLTEQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildIntLTQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildLongBetweenQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildLongGTEQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildLongGTQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildLongLTEQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildLongLTQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildStringBetweenQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildStringGTEQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildStringGTQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildStringLTEQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.BuildStringLTQuery$;
import org.locationtech.geomesa.memory.cqengine.utils.SFTAttributes;
import org.locationtech.geomesa.memory.cqengine.utils.SFTAttributes$;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits$;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$;
import org.locationtech.jts.geom.Geometry;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\rb\u0001\u0002\u0010 \u00011B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\u0006\u0005\u0002!\ta\u0011\u0005\b\u000f\u0002\u0011\r\u0011b\u0001I\u0011\u0019a\u0005\u0001)A\u0005\u0013\")Q\n\u0001C!\u001d\")Q\n\u0001C!A\")Q\n\u0001C!M\")Q\n\u0001C!Y\")Q\n\u0001C!g\")Q\n\u0001C!u\"1Q\n\u0001C!\u0003\u0003Aa!\u0014\u0001\u0005B\u00055\u0001BB'\u0001\t\u0003\nI\u0002\u0003\u0004N\u0001\u0011\u0005\u0013Q\u0005\u0005\u0007\u001b\u0002!\t%!\r\t\r5\u0003A\u0011IA\u001f\u0011\u0019i\u0005\u0001\"\u0011\u0002J!1Q\n\u0001C!\u0003+Ba!\u0014\u0001\u0005B\u0005\u0005\u0004BB'\u0001\t\u0003\ni\u0007\u0003\u0004N\u0001\u0011\u0005\u0013\u0011\u0010\u0005\u0007\u001b\u0002!\t%a#\t\r5\u0003A\u0011IAL\u0011\u0019i\u0005\u0001\"\u0011\u0002$\"1Q\n\u0001C!\u0003oCa!\u0014\u0001\u0005B\u0005\u0015\u0007BB'\u0001\t\u0003\n\u0019\u000eC\u0004\u0002`\u0002!\t!!9\t\u000f\t\u001d\u0001\u0001\"\u0001\u0003\n\t!2)U#oO&tW-U;fef4\u0016n]5u_JT!\u0001I\u0011\u0002\u000bU$\u0018\u000e\\:\u000b\u0005\t\u001a\u0013\u0001C2rK:<\u0017N\\3\u000b\u0005\u0011*\u0013AB7f[>\u0014\u0018P\u0003\u0002'O\u00059q-Z8nKN\f'B\u0001\u0015*\u00031awnY1uS>tG/Z2i\u0015\u0005Q\u0013aA8sO\u000e\u00011C\u0001\u0001.!\tqS'D\u00010\u0015\t\u0001\u0014'A\u0004wSNLGo\u001c:\u000b\u0005I\u001a\u0014A\u00024jYR,'O\u0003\u00025S\u0005Aq-Z8u_>d7/\u0003\u00027_\t)\u0012IY:ue\u0006\u001cGOR5mi\u0016\u0014h+[:ji>\u0014\u0018aA:giB\u0011\u0011\bQ\u0007\u0002u)\u00111\bP\u0001\u0007g&l\u0007\u000f\\3\u000b\u0005ur\u0014a\u00024fCR,(/\u001a\u0006\u0003\u007fM\n1!\u00199j\u0013\t\t%HA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016\fa\u0001P5oSRtDC\u0001#G!\t)\u0005!D\u0001 \u0011\u00159$\u00011\u00019\u0003\u0019awn\\6vaV\t\u0011\n\u0005\u0002F\u0015&\u00111j\b\u0002\u000e'\u001a#\u0016\t\u001e;sS\n,H/Z:\u0002\u000f1|wn[;qA\u0005)a/[:jiR\u0019q*V.\u0011\u0005A\u001bV\"A)\u000b\u0003I\u000bQa]2bY\u0006L!\u0001V)\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0011T\u00011\u0001W!\t9\u0016,D\u0001Y\u0015\t\u0011d(\u0003\u0002[1\n\u0019\u0011I\u001c3\t\u000bq+\u0001\u0019A/\u0002\t\u0011\fG/\u0019\t\u0003!zK!aX)\u0003\u0007\u0005s\u0017\u0010F\u0002PC\u0016DQA\r\u0004A\u0002\t\u0004\"aV2\n\u0005\u0011D&AA(s\u0011\u0015af\u00011\u0001^)\ryum\u001b\u0005\u0006e\u001d\u0001\r\u0001\u001b\t\u0003/&L!A\u001b-\u0003\u00079{G\u000fC\u0003]\u000f\u0001\u0007Q\fF\u0002P[FDQA\r\u0005A\u00029\u0004\"aV8\n\u0005AD&AA%e\u0011\u0015\u0011\b\u00021\u0001P\u0003-)\u0007\u0010\u001e:bGR$\u0015\r^1\u0015\u0007=#\b\u0010C\u00033\u0013\u0001\u0007Q\u000f\u0005\u0002Xm&\u0011q\u000f\u0017\u0002\u000e!J|\u0007/\u001a:us&\u001bh*\u001b7\t\u000beL\u0001\u0019A/\u0002\u0013\u0015DHO]1ECR\fGcA(|\u007f\")!G\u0003a\u0001yB\u0011q+`\u0005\u0003}b\u0013a\u0002\u0015:pa\u0016\u0014H/_%t\u001dVdG\u000eC\u0003]\u0015\u0001\u0007Q\fF\u0003P\u0003\u0007\tY\u0001\u0003\u00043\u0017\u0001\u0007\u0011Q\u0001\t\u0004/\u0006\u001d\u0011bAA\u00051\niQ\t_2mk\u0012,g)\u001b7uKJDQ\u0001X\u0006A\u0002u#RaTA\b\u0003/AaA\r\u0007A\u0002\u0005E\u0001cA,\u0002\u0014%\u0019\u0011Q\u0003-\u0003\u001b%s7\r\\;eK\u001aKG\u000e^3s\u0011\u0015aF\u00021\u0001^)\u0015y\u00151DA\u0012\u0011\u0019\u0011T\u00021\u0001\u0002\u001eA\u0019q+a\b\n\u0007\u0005\u0005\u0002LA\tQe>\u0004XM\u001d;z\u0013N,\u0015/^1m)>DQ\u0001X\u0007A\u0002u#RaTA\u0014\u0003_AaA\r\bA\u0002\u0005%\u0002cA,\u0002,%\u0019\u0011Q\u0006-\u0003+A\u0013x\u000e]3sifL5o\u0012:fCR,'\u000f\u00165b]\")AL\u0004a\u0001;R)q*a\r\u0002<!1!g\u0004a\u0001\u0003k\u00012aVA\u001c\u0013\r\tI\u0004\u0017\u0002\u001f!J|\u0007/\u001a:us&\u001bxI]3bi\u0016\u0014H\u000b[1o\u001fJ,\u0015/^1m)>DQ\u0001X\bA\u0002u#RaTA \u0003\u000fBaA\r\tA\u0002\u0005\u0005\u0003cA,\u0002D%\u0019\u0011Q\t-\u0003%A\u0013x\u000e]3sifL5\u000fT3tgRC\u0017M\u001c\u0005\u00069B\u0001\r!\u0018\u000b\u0006\u001f\u0006-\u00131\u000b\u0005\u0007eE\u0001\r!!\u0014\u0011\u0007]\u000by%C\u0002\u0002Ra\u00131\u0004\u0015:pa\u0016\u0014H/_%t\u0019\u0016\u001c8\u000f\u00165b]>\u0013X)];bYR{\u0007\"\u0002/\u0012\u0001\u0004iF#B(\u0002X\u0005}\u0003B\u0002\u001a\u0013\u0001\u0004\tI\u0006E\u0002X\u00037J1!!\u0018Y\u0005Q\u0001&o\u001c9feRL\u0018j\u001d(pi\u0016\u000bX/\u00197U_\")AL\u0005a\u0001;R)q*a\u0019\u0002l!1!g\u0005a\u0001\u0003K\u00022aVA4\u0013\r\tI\u0007\u0017\u0002\u0012!J|\u0007/\u001a:us&\u001b()\u001a;xK\u0016t\u0007\"\u0002/\u0014\u0001\u0004iF#B(\u0002p\u0005]\u0004B\u0002\u001a\u0015\u0001\u0004\t\t\bE\u0002X\u0003gJ1!!\u001eY\u00059\u0001&o\u001c9feRL\u0018j\u001d'jW\u0016DQ\u0001\u0018\u000bA\u0002u#RaTA>\u0003\u0013CaAM\u000bA\u0002\u0005u\u0004\u0003BA@\u0003\u000bk!!!!\u000b\u0007\u0005\r\u0005,A\u0004ta\u0006$\u0018.\u00197\n\t\u0005\u001d\u0015\u0011\u0011\u0002\u0005\u0005\n{\u0005\fC\u0003]+\u0001\u0007Q\fF\u0003P\u0003\u001b\u000b)\n\u0003\u00043-\u0001\u0007\u0011q\u0012\t\u0005\u0003\u007f\n\t*\u0003\u0003\u0002\u0014\u0006\u0005%AC%oi\u0016\u00148/Z2ug\")AL\u0006a\u0001;R)q*!'\u0002\"\"1!g\u0006a\u0001\u00037\u0003B!a \u0002\u001e&!\u0011qTAA\u0005U\u0011\u0015N\\1ssN\u0003\u0018\r^5bY>\u0003XM]1u_JDQ\u0001X\fA\u0002u#RaTAS\u0003kCq!a*\u0019\u0001\u0004\tI+A\u0003bMR,'\u000f\u0005\u0003\u0002,\u0006EVBAAW\u0015\r\ty\u000bW\u0001\ti\u0016l\u0007o\u001c:bY&!\u00111WAW\u0005\u0015\te\r^3s\u0011\u0015I\b\u00041\u0001^)\u0015y\u0015\u0011XAb\u0011\u001d\tY,\u0007a\u0001\u0003{\u000baAY3g_J,\u0007\u0003BAV\u0003\u007fKA!!1\u0002.\n1!)\u001a4pe\u0016DQ!_\rA\u0002u#RaTAd\u0003#Dq!!3\u001b\u0001\u0004\tY-\u0001\u0004ekJLgn\u001a\t\u0005\u0003W\u000bi-\u0003\u0003\u0002P\u00065&A\u0002#ve&tw\rC\u0003z5\u0001\u0007Q\fF\u0003P\u0003+\fi\u000e\u0003\u000437\u0001\u0007\u0011q\u001b\t\u0005\u0003W\u000bI.\u0003\u0003\u0002\\\u00065&A\u0006\"j]\u0006\u0014\u0018\u0010V3na>\u0014\u0018\r\\(qKJ\fGo\u001c:\t\u000bq[\u0002\u0019A/\u0002-!\fg\u000e\u001a7f\u000f\u0016tWM]1m\u0007Fce)\u001b7uKJ$B!a9\u0002\u0000B1\u0011Q]A{\u0003sl!!a:\u000b\t\u0005%\u00181^\u0001\u0006cV,'/\u001f\u0006\u0004E\u00055(\u0002BAx\u0003c\f!bZ8pO2,7m\u001c3f\u0015\t\t\u00190A\u0002d_6LA!a>\u0002h\n)\u0011+^3ssB\u0019\u0011(a?\n\u0007\u0005u(HA\u0007TS6\u0004H.\u001a$fCR,(/\u001a\u0005\u0007eq\u0001\rA!\u0001\u0011\u0007]\u0013\u0019!C\u0002\u0003\u0006a\u0013aAR5mi\u0016\u0014\u0018\u0001D4fi\u0006#HO]5ckR,G\u0003\u0002B\u0006\u0005C\u0001BA!\u0004\u0003\u001c9!!q\u0002B\f!\r\u0011\t\"U\u0007\u0003\u0005'Q1A!\u0006,\u0003\u0019a$o\\8u}%\u0019!\u0011D)\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011iBa\b\u0003\rM#(/\u001b8h\u0015\r\u0011I\"\u0015\u0005\u0007eu\u0001\rA!\u0001")
public class CQEngineQueryVisitor
extends AbstractFilterVisitor {
    private final SimpleFeatureType sft;
    private final SFTAttributes lookup;

    public SFTAttributes lookup() {
        return this.lookup;
    }

    public Object visit(And filter, Object data) {
        java.util.List children = filter.getChildren();
        List query = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(children).asScala()).map((Function1 & Serializable)f -> {
            Object object = f.accept((FilterVisitor)this, null);
            if (object instanceof Query) {
                Query query = (Query)object;
                return query;
            }
            throw new RuntimeException(new StringBuilder(21).append("Can't parse filter: ").append(f).append(".").toString());
        })).toList();
        if (query.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CQEngineQueryVisitor.$anonfun$visit$2(x$1)))) {
            return new All(SimpleFeature.class);
        }
        return new com.googlecode.cqengine.query.logical.And((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)query).asJava());
    }

    public Object visit(Or filter, Object data) {
        java.util.List children = filter.getChildren();
        List query = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(children).asScala()).map((Function1 & Serializable)f -> {
            Object object = f.accept((FilterVisitor)this, null);
            if (object instanceof Query) {
                Query query = (Query)object;
                return query;
            }
            throw new RuntimeException(new StringBuilder(21).append("Can't parse filter: ").append(f).append(".").toString());
        })).toList();
        if (query.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CQEngineQueryVisitor.$anonfun$visit$4(x$2)))) {
            return new All(SimpleFeature.class);
        }
        return new com.googlecode.cqengine.query.logical.Or((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)query).asJava());
    }

    public Object visit(Not filter, Object data) {
        Filter subfilter = filter.getFilter();
        Object object = subfilter.accept((FilterVisitor)this, null);
        if (!(object instanceof Query)) {
            throw new RuntimeException(new StringBuilder(21).append("Can't parse filter: ").append(subfilter).append(".").toString());
        }
        Query query = (Query)object;
        Query subquery = query;
        if (subquery instanceof All) {
            return subquery;
        }
        return new com.googlecode.cqengine.query.logical.Not(subquery);
    }

    public Object visit(Id filter, Object extractData) {
        Attribute<SimpleFeature, String> attr = SFTAttributes$.MODULE$.fidAttribute();
        scala.collection.mutable.Set values = (scala.collection.mutable.Set)((IterableOps)JavaConverters$.MODULE$.asScalaSetConverter(filter.getIDs()).asScala()).map((Function1 & Serializable)x$3 -> x$3.toString());
        return new In(attr, true, (Set)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(values).asJava());
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        String name = this.getAttribute((Filter)filter);
        Attribute attr = this.lookup().lookup(name);
        return new com.googlecode.cqengine.query.logical.Not((Query)new Has(attr));
    }

    public Object visit(PropertyIsNull filter, Object data) {
        String name = this.getAttribute((Filter)filter);
        Attribute attr = this.lookup().lookup(name);
        return new com.googlecode.cqengine.query.logical.Not((Query)new Has(attr));
    }

    public Object visit(ExcludeFilter filter, Object data) {
        return new None(SimpleFeature.class);
    }

    public Object visit(IncludeFilter filter, Object data) {
        return new All(SimpleFeature.class);
    }

    public Object visit(PropertyIsEqualTo filter, Object data) {
        Attribute attribute;
        String name = this.getAttribute((Filter)filter);
        Bounds bounds = (Bounds)FilterHelper$.MODULE$.extractAttributeBounds((Filter)filter, name, (attribute = this.lookup().lookup(name)).getAttributeType()).values().headOption().getOrElse((Function0 & Serializable)() -> Bounds$.MODULE$.everything());
        if (!bounds.isBounded()) {
            return new All(SimpleFeature.class);
        }
        return new Equal(attribute, bounds.lower().value().get());
    }

    public Object visit(PropertyIsGreaterThan filter, Object data) {
        Class binding;
        String name = this.getAttribute((Filter)filter);
        Tuple2 tuple2 = ((Bounds)FilterHelper$.MODULE$.extractAttributeBounds((Filter)filter, name, binding = this.sft.getDescriptor(name).getType().getBinding()).values().headOption().getOrElse((Function0 & Serializable)() -> Bounds$.MODULE$.everything())).bounds();
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object lo = some.value();
                if (None$.MODULE$.equals(option2)) {
                    Class clazz = binding;
                    if (Integer.class.isAssignableFrom(clazz)) {
                        return BuildIntGTQuery$.MODULE$.apply(name, (Integer)lo, this.lookup());
                    }
                    if (Long.class.isAssignableFrom(clazz)) {
                        return BuildLongGTQuery$.MODULE$.apply(name, (Long)lo, this.lookup());
                    }
                    if (Float.class.isAssignableFrom(clazz)) {
                        return BuildFloatGTQuery$.MODULE$.apply(name, (Float)lo, this.lookup());
                    }
                    if (Double.class.isAssignableFrom(clazz)) {
                        return BuildDoubleGTQuery$.MODULE$.apply(name, (Double)lo, this.lookup());
                    }
                    if (Date.class.isAssignableFrom(clazz)) {
                        return BuildDateGTQuery$.MODULE$.apply(name, (Date)lo, this.lookup());
                    }
                    if (String.class.isAssignableFrom(clazz)) {
                        return BuildStringGTQuery$.MODULE$.apply(name, (String)lo, this.lookup());
                    }
                    throw new RuntimeException(new StringBuilder(37).append("PropertyIsGreaterThan: ").append(clazz).append(" not supported").toString());
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && option3 instanceof Some) {
                Some some = (Some)option3;
                Object hi = some.value();
                Class clazz = binding;
                if (Integer.class.isAssignableFrom(clazz)) {
                    return BuildIntLTQuery$.MODULE$.apply(name, (Integer)hi, this.lookup());
                }
                if (Long.class.isAssignableFrom(clazz)) {
                    return BuildLongLTQuery$.MODULE$.apply(name, (Long)hi, this.lookup());
                }
                if (Float.class.isAssignableFrom(clazz)) {
                    return BuildFloatLTQuery$.MODULE$.apply(name, (Float)hi, this.lookup());
                }
                if (Double.class.isAssignableFrom(clazz)) {
                    return BuildDoubleLTQuery$.MODULE$.apply(name, (Double)hi, this.lookup());
                }
                if (Date.class.isAssignableFrom(clazz)) {
                    return BuildDateLTQuery$.MODULE$.apply(name, (Date)hi, this.lookup());
                }
                if (String.class.isAssignableFrom(clazz)) {
                    return BuildStringLTQuery$.MODULE$.apply(name, (String)hi, this.lookup());
                }
                throw new RuntimeException(new StringBuilder(37).append("PropertyIsGreaterThan: ").append(clazz).append(" not supported").toString());
            }
        }
        return new All(SimpleFeature.class);
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object data) {
        Class binding;
        String name = this.getAttribute((Filter)filter);
        Tuple2 tuple2 = ((Bounds)FilterHelper$.MODULE$.extractAttributeBounds((Filter)filter, name, binding = this.sft.getDescriptor(name).getType().getBinding()).values().headOption().getOrElse((Function0 & Serializable)() -> Bounds$.MODULE$.everything())).bounds();
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object lo = some.value();
                if (None$.MODULE$.equals(option2)) {
                    Class clazz = binding;
                    if (Integer.class.isAssignableFrom(clazz)) {
                        return BuildIntGTEQuery$.MODULE$.apply(name, (Integer)lo, this.lookup());
                    }
                    if (Long.class.isAssignableFrom(clazz)) {
                        return BuildLongGTEQuery$.MODULE$.apply(name, (Long)lo, this.lookup());
                    }
                    if (Float.class.isAssignableFrom(clazz)) {
                        return BuildFloatGTEQuery$.MODULE$.apply(name, (Float)lo, this.lookup());
                    }
                    if (Double.class.isAssignableFrom(clazz)) {
                        return BuildDoubleGTEQuery$.MODULE$.apply(name, (Double)lo, this.lookup());
                    }
                    if (Date.class.isAssignableFrom(clazz)) {
                        return BuildDateGTEQuery$.MODULE$.apply(name, (Date)lo, this.lookup());
                    }
                    if (String.class.isAssignableFrom(clazz)) {
                        return BuildStringGTEQuery$.MODULE$.apply(name, (String)lo, this.lookup());
                    }
                    throw new RuntimeException(new StringBuilder(46).append("PropertyIsGreaterThanOrEqualTo: ").append(clazz).append(" not supported").toString());
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && option3 instanceof Some) {
                Some some = (Some)option3;
                Object hi = some.value();
                Class clazz = binding;
                if (Integer.class.isAssignableFrom(clazz)) {
                    return BuildIntLTEQuery$.MODULE$.apply(name, (Integer)hi, this.lookup());
                }
                if (Long.class.isAssignableFrom(clazz)) {
                    return BuildLongLTEQuery$.MODULE$.apply(name, (Long)hi, this.lookup());
                }
                if (Float.class.isAssignableFrom(clazz)) {
                    return BuildFloatLTEQuery$.MODULE$.apply(name, (Float)hi, this.lookup());
                }
                if (Double.class.isAssignableFrom(clazz)) {
                    return BuildDoubleLTEQuery$.MODULE$.apply(name, (Double)hi, this.lookup());
                }
                if (Date.class.isAssignableFrom(clazz)) {
                    return BuildDateLTEQuery$.MODULE$.apply(name, (Date)hi, this.lookup());
                }
                if (String.class.isAssignableFrom(clazz)) {
                    return BuildStringLTEQuery$.MODULE$.apply(name, (String)hi, this.lookup());
                }
                throw new RuntimeException(new StringBuilder(46).append("PropertyIsGreaterThanOrEqualTo: ").append(clazz).append(" not supported").toString());
            }
        }
        return new All(SimpleFeature.class);
    }

    public Object visit(PropertyIsLessThan filter, Object data) {
        Class binding;
        String name = this.getAttribute((Filter)filter);
        Tuple2 tuple2 = ((Bounds)FilterHelper$.MODULE$.extractAttributeBounds((Filter)filter, name, binding = this.sft.getDescriptor(name).getType().getBinding()).values().headOption().getOrElse((Function0 & Serializable)() -> Bounds$.MODULE$.everything())).bounds();
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object lo = some.value();
                if (None$.MODULE$.equals(option2)) {
                    Class clazz = binding;
                    if (Integer.class.isAssignableFrom(clazz)) {
                        return BuildIntGTQuery$.MODULE$.apply(name, (Integer)lo, this.lookup());
                    }
                    if (Long.class.isAssignableFrom(clazz)) {
                        return BuildLongGTQuery$.MODULE$.apply(name, (Long)lo, this.lookup());
                    }
                    if (Float.class.isAssignableFrom(clazz)) {
                        return BuildFloatGTQuery$.MODULE$.apply(name, (Float)lo, this.lookup());
                    }
                    if (Double.class.isAssignableFrom(clazz)) {
                        return BuildDoubleGTQuery$.MODULE$.apply(name, (Double)lo, this.lookup());
                    }
                    if (Date.class.isAssignableFrom(clazz)) {
                        return BuildDateGTQuery$.MODULE$.apply(name, (Date)lo, this.lookup());
                    }
                    if (String.class.isAssignableFrom(clazz)) {
                        return BuildStringGTQuery$.MODULE$.apply(name, (String)lo, this.lookup());
                    }
                    throw new RuntimeException(new StringBuilder(34).append("PropertyIsLessThan: ").append(clazz).append(" not supported").toString());
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && option3 instanceof Some) {
                Some some = (Some)option3;
                Object hi = some.value();
                Class clazz = binding;
                if (Integer.class.isAssignableFrom(clazz)) {
                    return BuildIntLTQuery$.MODULE$.apply(name, (Integer)hi, this.lookup());
                }
                if (Long.class.isAssignableFrom(clazz)) {
                    return BuildLongLTQuery$.MODULE$.apply(name, (Long)hi, this.lookup());
                }
                if (Float.class.isAssignableFrom(clazz)) {
                    return BuildFloatLTQuery$.MODULE$.apply(name, (Float)hi, this.lookup());
                }
                if (Double.class.isAssignableFrom(clazz)) {
                    return BuildDoubleLTQuery$.MODULE$.apply(name, (Double)hi, this.lookup());
                }
                if (Date.class.isAssignableFrom(clazz)) {
                    return BuildDateLTQuery$.MODULE$.apply(name, (Date)hi, this.lookup());
                }
                if (String.class.isAssignableFrom(clazz)) {
                    return BuildStringLTQuery$.MODULE$.apply(name, (String)hi, this.lookup());
                }
                throw new RuntimeException(new StringBuilder(34).append("PropertyIsLessThan: ").append(clazz).append(" not supported").toString());
            }
        }
        return new All(SimpleFeature.class);
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object data) {
        Class binding;
        String name = this.getAttribute((Filter)filter);
        Tuple2 tuple2 = ((Bounds)FilterHelper$.MODULE$.extractAttributeBounds((Filter)filter, name, binding = this.sft.getDescriptor(name).getType().getBinding()).values().headOption().getOrElse((Function0 & Serializable)() -> Bounds$.MODULE$.everything())).bounds();
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object lo = some.value();
                if (None$.MODULE$.equals(option2)) {
                    Class clazz = binding;
                    if (Integer.class.isAssignableFrom(clazz)) {
                        return BuildIntGTEQuery$.MODULE$.apply(name, (Integer)lo, this.lookup());
                    }
                    if (Long.class.isAssignableFrom(clazz)) {
                        return BuildLongGTEQuery$.MODULE$.apply(name, (Long)lo, this.lookup());
                    }
                    if (Float.class.isAssignableFrom(clazz)) {
                        return BuildFloatGTEQuery$.MODULE$.apply(name, (Float)lo, this.lookup());
                    }
                    if (Double.class.isAssignableFrom(clazz)) {
                        return BuildDoubleGTEQuery$.MODULE$.apply(name, (Double)lo, this.lookup());
                    }
                    if (Date.class.isAssignableFrom(clazz)) {
                        return BuildDateGTEQuery$.MODULE$.apply(name, (Date)lo, this.lookup());
                    }
                    if (String.class.isAssignableFrom(clazz)) {
                        return BuildStringGTEQuery$.MODULE$.apply(name, (String)lo, this.lookup());
                    }
                    throw new RuntimeException(new StringBuilder(43).append("PropertyIsLessThanOrEqualTo: ").append(clazz).append(" not supported").toString());
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && option3 instanceof Some) {
                Some some = (Some)option3;
                Object hi = some.value();
                Class clazz = binding;
                if (Integer.class.isAssignableFrom(clazz)) {
                    return BuildIntLTEQuery$.MODULE$.apply(name, (Integer)hi, this.lookup());
                }
                if (Long.class.isAssignableFrom(clazz)) {
                    return BuildLongLTEQuery$.MODULE$.apply(name, (Long)hi, this.lookup());
                }
                if (Float.class.isAssignableFrom(clazz)) {
                    return BuildFloatLTEQuery$.MODULE$.apply(name, (Float)hi, this.lookup());
                }
                if (Double.class.isAssignableFrom(clazz)) {
                    return BuildDoubleLTEQuery$.MODULE$.apply(name, (Double)hi, this.lookup());
                }
                if (Date.class.isAssignableFrom(clazz)) {
                    return BuildDateLTEQuery$.MODULE$.apply(name, (Date)hi, this.lookup());
                }
                if (String.class.isAssignableFrom(clazz)) {
                    return BuildStringLTEQuery$.MODULE$.apply(name, (String)hi, this.lookup());
                }
                throw new RuntimeException(new StringBuilder(43).append("PropertyIsLessThanOrEqualTo: ").append(clazz).append(" not supported").toString());
            }
        }
        return new All(SimpleFeature.class);
    }

    public Object visit(PropertyIsNotEqualTo filter, Object data) {
        String name = this.getAttribute((Filter)filter);
        Attribute attribute = this.lookup().lookup(name);
        Object value = ScalaImplicits.RichIterator$.MODULE$.headOption$extension(ScalaImplicits$.MODULE$.RichIterator(package$.MODULE$.Iterator().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{filter.getExpression1(), filter.getExpression2()})).collect((PartialFunction)new Serializable(null, attribute){
            private static final long serialVersionUID = 0L;
            private final Attribute attribute$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Literal) {
                    Literal literal = (Literal)A1;
                    return (B1)FastConverter$.MODULE$.evaluate((Expression)literal, this.attribute$1.getAttributeType());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                return expression instanceof Literal;
            }
            {
                this.attribute$1 = attribute$1;
            }
        }))).getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException(new StringBuilder(32).append("Can't parse not equal to values ").append(org.locationtech.geomesa.filter.package$.MODULE$.filterToString((Filter)filter)).toString());
        });
        return new com.googlecode.cqengine.query.logical.Not((Query)new Equal(attribute, value));
    }

    public Object visit(PropertyIsBetween filter, Object data) {
        String name = this.getAttribute((Filter)filter);
        Class binding = this.sft.getDescriptor(name).getType().getBinding();
        Bounds values = (Bounds)FilterHelper$.MODULE$.extractAttributeBounds((Filter)filter, name, binding).values().headOption().getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException(new StringBuilder(41).append("Can't parse less than or equal to values ").append(org.locationtech.geomesa.filter.package$.MODULE$.filterToString((Filter)filter)).toString());
        });
        Tuple2 between = new Tuple2(values.lower().value().get(), values.upper().value().get());
        Class clazz = binding;
        if (Integer.class.isAssignableFrom(clazz)) {
            return BuildIntBetweenQuery$.MODULE$.apply(name, between, this.lookup());
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return BuildLongBetweenQuery$.MODULE$.apply(name, between, this.lookup());
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return BuildFloatBetweenQuery$.MODULE$.apply(name, between, this.lookup());
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return BuildDoubleBetweenQuery$.MODULE$.apply(name, between, this.lookup());
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return BuildDateBetweenQuery$.MODULE$.apply(name, between, this.lookup());
        }
        if (String.class.isAssignableFrom(clazz)) {
            return BuildStringBetweenQuery$.MODULE$.apply(name, between, this.lookup());
        }
        throw new RuntimeException(new StringBuilder(33).append("PropertyIsBetween: ").append(clazz).append(" not supported").toString());
    }

    public Object visit(PropertyIsLike filter, Object data) {
        String name = this.getAttribute((Filter)filter);
        Attribute attr = this.lookup().lookup(name);
        LikeToRegexConverter converter = new LikeToRegexConverter(filter);
        Pattern pattern = filter.isMatchingCase() ? Pattern.compile(converter.getPattern()) : Pattern.compile(converter.getPattern(), 2);
        return new StringMatchesRegex(attr, pattern);
    }

    public Object visit(BBOX filter, Object data) {
        String name = this.getAttribute((Filter)filter);
        Geometry geom = (Geometry)FilterHelper$.MODULE$.extractGeometries((Filter)filter, name, FilterHelper$.MODULE$.extractGeometries$default$3()).values().headOption().getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException(new StringBuilder(24).append("Can't parse bbox values ").append(org.locationtech.geomesa.filter.package$.MODULE$.filterToString((Filter)filter)).toString());
        });
        Attribute geomAttribute = this.lookup().lookup(name);
        return new org.locationtech.geomesa.memory.cqengine.query.Intersects<SimpleFeature, Geometry>(geomAttribute, geom);
    }

    public Object visit(Intersects filter, Object data) {
        String name = this.getAttribute((Filter)filter);
        Geometry geom = (Geometry)FilterHelper$.MODULE$.extractGeometries((Filter)filter, name, FilterHelper$.MODULE$.extractGeometries$default$3()).values().headOption().getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException(new StringBuilder(30).append("Can't parse intersects values ").append(org.locationtech.geomesa.filter.package$.MODULE$.filterToString((Filter)filter)).toString());
        });
        Attribute geomAttribute = this.lookup().lookup(name);
        return new org.locationtech.geomesa.memory.cqengine.query.Intersects<SimpleFeature, Geometry>(geomAttribute, geom);
    }

    public Object visit(BinarySpatialOperator filter, Object data) {
        return this.handleGeneralCQLFilter((Filter)filter);
    }

    public Object visit(After after, Object extraData) {
        String name = this.getAttribute((Filter)after);
        Class clazz = this.sft.getDescriptor(name).getType().getBinding();
        if (Date.class.isAssignableFrom(clazz)) {
            Attribute attr = this.lookup().lookup(name);
            Tuple2 tuple2 = ((Bounds)FilterHelper$.MODULE$.extractIntervals((Filter)after, name, FilterHelper$.MODULE$.extractIntervals$default$3()).values().headOption().getOrElse((Function0 & Serializable)() -> {
                throw new RuntimeException(new StringBuilder(25).append("Can't parse after values ").append(org.locationtech.geomesa.filter.package$.MODULE$.filterToString((Filter)after)).toString());
            })).bounds();
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    ZonedDateTime lo = (ZonedDateTime)some.value();
                    if (None$.MODULE$.equals(option2)) {
                        return new GreaterThan(attr, (Comparable)Date.from(lo.toInstant()), false);
                    }
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && option3 instanceof Some) {
                    Some some = (Some)option3;
                    ZonedDateTime hi = (ZonedDateTime)some.value();
                    return new LessThan(attr, (Comparable)Date.from(hi.toInstant()), false);
                }
            }
            throw new MatchError((Object)tuple2);
        }
        throw new RuntimeException(new StringBuilder(21).append("After: ").append(clazz).append(" not supported").toString());
    }

    public Object visit(Before before, Object extraData) {
        String name = this.getAttribute((Filter)before);
        Class clazz = this.sft.getDescriptor(name).getType().getBinding();
        if (Date.class.isAssignableFrom(clazz)) {
            Attribute attr = this.lookup().lookup(name);
            Tuple2 tuple2 = ((Bounds)FilterHelper$.MODULE$.extractIntervals((Filter)before, name, FilterHelper$.MODULE$.extractIntervals$default$3()).values().headOption().getOrElse((Function0 & Serializable)() -> {
                throw new RuntimeException(new StringBuilder(26).append("Can't parse before values ").append(org.locationtech.geomesa.filter.package$.MODULE$.filterToString((Filter)before)).toString());
            })).bounds();
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    ZonedDateTime lo = (ZonedDateTime)some.value();
                    if (None$.MODULE$.equals(option2)) {
                        return new GreaterThan(attr, (Comparable)Date.from(lo.toInstant()), false);
                    }
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && option3 instanceof Some) {
                    Some some = (Some)option3;
                    ZonedDateTime hi = (ZonedDateTime)some.value();
                    return new LessThan(attr, (Comparable)Date.from(hi.toInstant()), false);
                }
            }
            throw new MatchError((Object)tuple2);
        }
        throw new RuntimeException(new StringBuilder(22).append("Before: ").append(clazz).append(" not supported").toString());
    }

    public Object visit(During during, Object extraData) {
        String name = this.getAttribute((Filter)during);
        Class clazz = this.sft.getDescriptor(name).getType().getBinding();
        if (Date.class.isAssignableFrom(clazz)) {
            Attribute attr = this.lookup().lookup(name);
            Bounds bounds = (Bounds)FilterHelper$.MODULE$.extractIntervals((Filter)during, name, FilterHelper$.MODULE$.extractIntervals$default$3()).values().headOption().getOrElse((Function0 & Serializable)() -> {
                throw new RuntimeException(new StringBuilder(26).append("Can't parse during values ").append(org.locationtech.geomesa.filter.package$.MODULE$.filterToString((Filter)during)).toString());
            });
            return new Between(attr, (Comparable)Date.from(((ChronoZonedDateTime)bounds.lower().value().get()).toInstant()), bounds.lower().inclusive(), (Comparable)Date.from(((ChronoZonedDateTime)bounds.upper().value().get()).toInstant()), bounds.upper().inclusive());
        }
        throw new RuntimeException(new StringBuilder(22).append("During: ").append(clazz).append(" not supported").toString());
    }

    public Object visit(BinaryTemporalOperator filter, Object data) {
        return this.handleGeneralCQLFilter((Filter)filter);
    }

    public Query<SimpleFeature> handleGeneralCQLFilter(Filter filter) {
        return new GeoToolsFilterQuery(filter);
    }

    public String getAttribute(Filter filter) {
        return (String)FilterHelper$.MODULE$.propertyNames(filter, null).headOption().getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException(new StringBuilder(19).append("Can't parse filter ").append(org.locationtech.geomesa.filter.package$.MODULE$.filterToString(filter)).toString());
        });
    }

    public static final /* synthetic */ boolean $anonfun$visit$2(Query x$1) {
        return x$1 instanceof All;
    }

    public static final /* synthetic */ boolean $anonfun$visit$4(Query x$2) {
        return x$2 instanceof All;
    }

    public CQEngineQueryVisitor(SimpleFeatureType sft) {
        this.sft = sft;
        this.lookup = new SFTAttributes(sft);
    }
}

