/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.avro.serialization;

import java.io.Serializable;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.SerializationOption$;
import org.locationtech.geomesa.features.avro.FieldNameEncoder;
import org.locationtech.geomesa.features.avro.FieldNameEncoder$;
import org.locationtech.geomesa.features.avro.package$;
import org.locationtech.geomesa.features.avro.package$SerializationVersions$;
import org.locationtech.geomesa.features.avro.serialization.AvroField;
import org.locationtech.geomesa.features.avro.serialization.AvroField$;
import org.locationtech.geomesa.features.avro.serialization.AvroField$FidField$;
import org.locationtech.geomesa.features.avro.serialization.AvroField$UserDataField$;
import org.locationtech.geomesa.features.avro.serialization.AvroField$VersionField$;
import org.locationtech.geomesa.features.avro.serialization.AvroSerialization;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple5;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class AvroSerialization$
implements Serializable {
    public static final AvroSerialization$ MODULE$ = new AvroSerialization$();
    private static final FieldNameEncoder[] nameEncoders = (FieldNameEncoder[])Array$.MODULE$.tabulate(package$SerializationVersions$.MODULE$.MaxVersion(), (Function1 & Serializable)i -> AvroSerialization$.$anonfun$nameEncoders$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(FieldNameEncoder.class));

    private FieldNameEncoder[] nameEncoders() {
        return nameEncoders;
    }

    public AvroSerialization apply(SimpleFeatureType sft, Set<Enumeration.Value> opts) {
        int version = SerializationOption.SerializationOptions$.MODULE$.useNativeCollections$extension(SerializationOption$.MODULE$.SerializationOptions(opts)) && ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).exists((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)AvroSerialization$.$anonfun$apply$1(d))) ? package$SerializationVersions$.MODULE$.NativeCollectionVersion() : package$SerializationVersions$.MODULE$.DefaultVersion();
        Seq fields = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1 & Serializable)x$1 -> AvroField$.MODULE$.apply((AttributeDescriptor)x$1).withVersion(version))).toSeq();
        None$ fid = SerializationOption.SerializationOptions$.MODULE$.withoutId$extension(SerializationOption$.MODULE$.SerializationOptions(opts)) ? None$.MODULE$ : new Some(AvroField$FidField$.MODULE$.withVersion(version));
        None$ userData = SerializationOption.SerializationOptions$.MODULE$.withUserData$extension(SerializationOption$.MODULE$.SerializationOptions(opts)) ? new Some(AvroField$UserDataField$.MODULE$.withVersion(version)) : None$.MODULE$;
        Schema schema = this.schema(sft, version, (Seq<AvroField<Object>>)fields, fid.isDefined(), userData.isDefined());
        return new AvroSerialization(version, schema, (Option<AvroField<String>>)fid, (Seq<AvroField<Object>>)fields, (Option<AvroField<Map<Object, Object>>>)userData);
    }

    public Schema schema(SimpleFeatureType sft, int version, Seq<AvroField<Object>> fields, boolean includeFid, boolean includeUserData) {
        Predef$.MODULE$.require(version > 0 && version <= package$SerializationVersions$.MODULE$.MaxVersion(), (Function0 & Serializable)() -> new StringBuilder(43).append("Unknown version ").append(version).append(" - valid versions are 1 to ").append(package$SerializationVersions$.MODULE$.MaxVersion()).toString());
        Predef$.MODULE$.require(fields.length() == sft.getAttributeCount(), (Function0 & Serializable)() -> "Mismatch between fields and feature type");
        FieldNameEncoder nameEncoder = this.nameEncoders()[version - 1];
        SchemaBuilder.FieldAssembler builder = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)nameEncoder.encode(sft.getTypeName())).namespace((String)Option$.MODULE$.apply((Object)sft.getName().getNamespaceURI()).getOrElse((Function0 & Serializable)() -> package$.MODULE$.AvroNamespace()))).fields();
        builder.name(AvroField$VersionField$.MODULE$.name()).type(AvroField$VersionField$.MODULE$.schema()).withDefault((Object)BoxesRunTime.boxToInteger((int)version));
        Object object = includeFid ? builder.name(AvroField$FidField$.MODULE$.name()).type(AvroField$FidField$.MODULE$.schema()).noDefault() : BoxedUnit.UNIT;
        Iterator types = ((IterableOnce)fields.map((Function1 & Serializable)x$2 -> x$2.schema())).iterator();
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).foreach((Function1 & Serializable)d -> builder.name(nameEncoder.encode(d.getLocalName())).type((Schema)types.next()).noDefault());
        Object object2 = includeUserData ? builder.name(AvroField$UserDataField$.MODULE$.name()).type(AvroField$UserDataField$.MODULE$.schema()).noDefault() : BoxedUnit.UNIT;
        return (Schema)builder.endRecord();
    }

    public boolean usesNativeCollections(Schema schema) {
        return Option$.MODULE$.apply((Object)schema.getField(AvroField$VersionField$.MODULE$.name())).exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AvroSerialization$.$anonfun$usesNativeCollections$1(x$3)));
    }

    public AvroSerialization apply(int version, Schema schema, Option<AvroField<String>> fid, Seq<AvroField<Object>> fields, Option<AvroField<Map<Object, Object>>> userData) {
        return new AvroSerialization(version, schema, fid, fields, userData);
    }

    public Option<Tuple5<Object, Schema, Option<AvroField<String>>, Seq<AvroField<Object>>, Option<AvroField<Map<Object, Object>>>>> unapply(AvroSerialization x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)x$0.version()), (Object)x$0.schema(), x$0.fid(), x$0.fields(), x$0.userData()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AvroSerialization$.class);
    }

    public static final /* synthetic */ FieldNameEncoder $anonfun$nameEncoders$1(int i) {
        return new FieldNameEncoder(i + 1, FieldNameEncoder$.MODULE$.$lessinit$greater$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(AttributeDescriptor d) {
        return RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(d)) || RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isMap$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(d));
    }

    public static final /* synthetic */ boolean $anonfun$usesNativeCollections$1(Schema.Field x$3) {
        return BoxesRunTime.equals((Object)x$3.defaultVal(), (Object)BoxesRunTime.boxToInteger((int)package$SerializationVersions$.MODULE$.NativeCollectionVersion()));
    }

    private AvroSerialization$() {
    }
}

