/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.exporters;

import java.io.OutputStream;
import java.io.Serializable;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.arrow.io.DictionaryBuildingWriter;
import org.locationtech.geomesa.arrow.io.DictionaryBuildingWriter$;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter$;
import org.locationtech.geomesa.arrow.io.package;
import org.locationtech.geomesa.arrow.package;
import org.locationtech.geomesa.arrow.package$;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.features.exporters.FeatureExporter;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\rf\u0001\u0002#F\u0001AC\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\tI\u0002\u0011\t\u0011)A\u0005K\")q\u000e\u0001C\u0001a\"AA\u000f\u0001EC\u0002\u0013%Q\u000f\u0003\u0006\u0002\u001c\u0001A)\u0019!C\u0005\u0003;A!\"!\u0013\u0001\u0011\u000b\u0007I\u0011BA&\u0011)\ti\u0005\u0001EC\u0002\u0013%\u0011q\n\u0005\u000b\u0003/\u0002\u0001R1A\u0005\n\u0005e\u0003BCA7\u0001!\u0015\r\u0011\"\u0003\u0002p!Y\u0011\u0011\u000f\u0001A\u0002\u0003\u0007I\u0011BA:\u0011-\t)\b\u0001a\u0001\u0002\u0004%I!a\u001e\t\u0015\u0005\r\u0005\u00011A\u0001B\u0003&\u0011\fC\u0004\u0002\u0006\u0002!\t%a\"\t\u000f\u0005\u0005\u0006\u0001\"\u0011\u0002$\"9\u00111\u0018\u0001\u0005B\u0005uvaBA`\u000b\"\u0005\u0011\u0011\u0019\u0004\u0007\t\u0016C\t!a1\t\r=\fB\u0011AAf\r\u0019\ti-\u0005\u0003\u0002P\"I\u0011\u0011[\n\u0003\u0002\u0003\u0006IA\u0018\u0005\u0007_N!\t!a5\t\u000f\u0005\u00155\u0003\"\u0011\u0002\\\"9\u0011\u0011U\n\u0005B\u0005}\u0007bBA^'\u0011\u0005\u0013Q\u0018\u0004\u0007\u0003G\fB!!:\t\u0013\u0005E\u0017D!A!\u0002\u0013q\u0006BCA,3\t\u0005\t\u0015!\u0003\u0002\\!Q\u00111D\r\u0003\u0002\u0003\u0006I!a\b\t\u0015\u0005\u001d\u0018D!A!\u0002\u0013\tI\u000f\u0003\u0006\u0002Ne\u0011\t\u0011)A\u0005\u0003#B!\"a@\u001a\u0005\u0003\u0005\u000b\u0011BA\u000b\u0011\u0019y\u0017\u0004\"\u0001\u0003\u0002!Y!\u0011C\rA\u0002\u0003\u0007I\u0011\u0002B\n\u0011-\u0011y\"\u0007a\u0001\u0002\u0004%IA!\t\t\u0017\t\u0015\u0012\u00041A\u0001B\u0003&!Q\u0003\u0005\n\u0005OI\u0002\u0019!C\u0005\u0005SA\u0011Ba\u000b\u001a\u0001\u0004%IA!\f\t\u0011\tE\u0012\u0004)Q\u0005\u0003OCq!!\"\u001a\t\u0003\u0012\u0019\u0004C\u0004\u0002\"f!\tEa\u000e\t\u000f\u0005m\u0016\u0004\"\u0011\u0002>\u001eI!1H\t\u0002\u0002#%!Q\b\u0004\n\u0003G\f\u0012\u0011!E\u0005\u0005\u007fAaa\\\u0016\u0005\u0002\t\u0005\u0003\"\u0003B\"WE\u0005I\u0011\u0001B#\r\u0019\u0011Y&\u0005\u0003\u0003^!I\u0011\u0011\u001b\u0018\u0003\u0002\u0003\u0006IA\u0018\u0005\u000b\u00037q#\u0011!Q\u0001\n\u0005}\u0001BCAt]\t\u0005\t\u0015!\u0003\u0002j\"AAO\fB\u0001B\u0003%a\u000f\u0003\u0006\u0002N9\u0012\t\u0011)A\u0005\u0003#B!Ba\u0018/\u0005\u0003\u0005\u000b\u0011\u0002B1\u0011)\tyP\fB\u0001B\u0003%\u0011Q\u0003\u0005\u0007_:\"\tAa\u001c\t\u0017\tEa\u00061AA\u0002\u0013%!\u0011\u0011\u0005\f\u0005?q\u0003\u0019!a\u0001\n\u0013\u0011I\tC\u0006\u0003&9\u0002\r\u0011!Q!\n\t\r\u0005\"\u0003B\u0014]\u0001\u0007I\u0011\u0002B\u0015\u0011%\u0011YC\fa\u0001\n\u0013\u0011i\t\u0003\u0005\u000329\u0002\u000b\u0015BAT\u0011\u001d\t)I\fC!\u0005#Cq!!)/\t\u0003\u0012)\nC\u0004\u0002<:\"\t%!0\b\u0013\te\u0015#!A\t\n\tme!\u0003B.#\u0005\u0005\t\u0012\u0002BO\u0011\u0019y\u0017\t\"\u0001\u0003 \"I!\u0011U!\u0012\u0002\u0013\u0005!Q\t\u0002\u000e\u0003J\u0014xn^#ya>\u0014H/\u001a:\u000b\u0005\u0019;\u0015!C3ya>\u0014H/\u001a:t\u0015\tA\u0015*\u0001\u0005gK\u0006$XO]3t\u0015\tQ5*A\u0004hK>lWm]1\u000b\u00051k\u0015\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001(\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\t\u0016\f\u0005\u0002S/6\t1K\u0003\u0002U+\u0006!A.\u00198h\u0015\u00051\u0016\u0001\u00026bm\u0006L!\u0001W*\u0003\r=\u0013'.Z2u!\tQ6,D\u0001F\u0013\taVIA\bGK\u0006$XO]3FqB|'\u000f^3s\u0003\ryW\u000f\u001e\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003CV\u000b!![8\n\u0005\r\u0004'\u0001D(viB,Ho\u0015;sK\u0006l\u0017!\u00025j]R\u001c\bC\u00014n\u001b\u00059'B\u00015j\u0003\u001d1\u0017m\u0019;pefT!A[6\u0002\tU$\u0018\u000e\u001c\u0006\u0003Y6\u000b\u0001bZ3pi>|Gn]\u0005\u0003]\u001e\u0014Q\u0001S5oiN\fa\u0001P5oSRtDcA9sgB\u0011!\f\u0001\u0005\u0006;\u000e\u0001\rA\u0018\u0005\u0006I\u000e\u0001\r!Z\u0001\u0005g>\u0014H/F\u0001w!\r9(\u0010`\u0007\u0002q*\t\u00110A\u0003tG\u0006d\u0017-\u0003\u0002|q\n1q\n\u001d;j_:\u0004Ra^?\u0000\u0003+I!A =\u0003\rQ+\b\u000f\\33!\u0011\t\t!a\u0004\u000f\t\u0005\r\u00111\u0002\t\u0004\u0003\u000bAXBAA\u0004\u0015\r\tIaT\u0001\u0007yI|w\u000e\u001e \n\u0007\u00055\u00010\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003#\t\u0019B\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001bA\bcA<\u0002\u0018%\u0019\u0011\u0011\u0004=\u0003\u000f\t{w\u000e\\3b]\u0006AQM\\2pI&tw-\u0006\u0002\u0002 A!\u0011\u0011EA\"\u001d\u0011\t\u0019#!\u0010\u000f\t\u0005\u0015\u0012q\u0007\b\u0005\u0003O\t\u0019D\u0004\u0003\u0002*\u0005Eb\u0002BA\u0016\u0003_qA!!\u0002\u0002.%\ta*\u0003\u0002M\u001b&\u0011!jS\u0005\u0004\u0003kI\u0015!B1se><\u0018\u0002BA\u001d\u0003w\taA^3di>\u0014(bAA\u001b\u0013&!\u0011qHA!\u0003M\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKZ+7\r^8s\u0015\u0011\tI$a\u000f\n\t\u0005\u0015\u0013q\t\u0002\u0016'&l\u0007\u000f\\3GK\u0006$XO]3F]\u000e|G-\u001b8h\u0015\u0011\ty$!\u0011\u0002\u0007%\u00048-F\u0001\u0000\u0003%\u0011\u0017\r^2i'&TX-\u0006\u0002\u0002RA\u0019q/a\u0015\n\u0007\u0005U\u0003PA\u0002J]R\f\u0001\u0003Z5di&|g.\u0019:z\r&,G\u000eZ:\u0016\u0005\u0005m\u0003#BA/\u0003Ozh\u0002BA0\u0003GrA!!\u0002\u0002b%\t\u00110C\u0002\u0002fa\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002j\u0005-$aA*fc*\u0019\u0011Q\r=\u0002\u001b\u0019d\u0017\r\u001e;f]\u001aKW\r\u001c3t+\t\t)\"\u0001\u0005eK2,w-\u0019;f+\u0005I\u0016\u0001\u00043fY\u0016<\u0017\r^3`I\u0015\fH\u0003BA=\u0003\u007f\u00022a^A>\u0013\r\ti\b\u001f\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0002.\t\t\u00111\u0001Z\u0003\rAH%M\u0001\nI\u0016dWmZ1uK\u0002\nQa\u001d;beR$B!!\u001f\u0002\n\"9\u00111R\u0007A\u0002\u00055\u0015aA:giB!\u0011qRAO\u001b\t\t\tJ\u0003\u0003\u0002\u0014\u0006U\u0015AB:j[BdWM\u0003\u0003\u0002\u0018\u0006e\u0015a\u00024fCR,(/\u001a\u0006\u0004\u00037[\u0017aA1qS&!\u0011qTAI\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/Z\u0001\u0007Kb\u0004xN\u001d;\u0015\t\u0005\u0015\u0016Q\u0016\t\u0005oj\f9\u000bE\u0002x\u0003SK1!a+y\u0005\u0011auN\\4\t\r!s\u0001\u0019AAX!\u0019\ti&!-\u00026&!\u00111WA6\u0005!IE/\u001a:bi>\u0014\b\u0003BAH\u0003oKA!!/\u0002\u0012\ni1+[7qY\u00164U-\u0019;ve\u0016\fQa\u00197pg\u0016$\"!!\u001f\u0002\u001b\u0005\u0013(o\\<FqB|'\u000f^3s!\tQ\u0016cE\u0002\u0012\u0003\u000b\u00042a^Ad\u0013\r\tI\r\u001f\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005\u0005'aD#oG>$W\r\u001a#fY\u0016<\u0017\r^3\u0014\u0007M\t\u0016,\u0001\u0002pgR!\u0011Q[Am!\r\t9nE\u0007\u0002#!1\u0011\u0011[\u000bA\u0002y#B!!\u001f\u0002^\"9\u00111\u0012\fA\u0002\u00055E\u0003BAS\u0003CDa\u0001S\fA\u0002\u0005=&A\u0005#jGRLwN\\1ss\u0012+G.Z4bi\u0016\u001c2!G)Z\u0003\u001dI\u0007oY(qiN\u0004B!a;\u0002|6\u0011\u0011Q\u001e\u0006\u0005\u0003_\f\t0A\u0004nKN\u001c\u0018mZ3\u000b\t\u0005%\u00131\u001f\u0006\u0005\u0003s\t)P\u0003\u0003\u00026\u0005](bAA}\u001b\u00061\u0011\r]1dQ\u0016LA!!@\u0002n\nI\u0011\n]2PaRLwN\\\u0001\u000eM2\fG\u000f^3o'R\u0014Xo\u0019;\u0015\u001d\t\r!Q\u0001B\u0004\u0005\u0013\u0011YA!\u0004\u0003\u0010A\u0019\u0011q[\r\t\r\u0005E\u0007\u00051\u0001_\u0011\u001d\t9\u0006\ta\u0001\u00037Bq!a\u0007!\u0001\u0004\ty\u0002C\u0004\u0002h\u0002\u0002\r!!;\t\u000f\u00055\u0003\u00051\u0001\u0002R!I\u0011q \u0011\u0011\u0002\u0003\u0007\u0011QC\u0001\u0007oJLG/\u001a:\u0016\u0005\tU\u0001\u0003\u0002B\f\u00057i!A!\u0007\u000b\u0007\u0005\fY$\u0003\u0003\u0003\u001e\te!\u0001\u0007#jGRLwN\\1ss\n+\u0018\u000e\u001c3j]\u001e<&/\u001b;fe\u0006QqO]5uKJ|F%Z9\u0015\t\u0005e$1\u0005\u0005\n\u0003\u0003\u0013\u0013\u0011!a\u0001\u0005+\tqa\u001e:ji\u0016\u0014\b%A\u0003d_VtG/\u0006\u0002\u0002(\u0006I1m\\;oi~#S-\u001d\u000b\u0005\u0003s\u0012y\u0003C\u0005\u0002\u0002\u0016\n\t\u00111\u0001\u0002(\u000611m\\;oi\u0002\"B!!\u001f\u00036!9\u00111R\u0014A\u0002\u00055E\u0003BAS\u0005sAa\u0001\u0013\u0015A\u0002\u0005=\u0016A\u0005#jGRLwN\\1ss\u0012+G.Z4bi\u0016\u00042!a6,'\rY\u0013Q\u0019\u000b\u0003\u0005{\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u00122TC\u0001B$U\u0011\t)B!\u0013,\u0005\t-\u0003\u0003\u0002B'\u0005/j!Aa\u0014\u000b\t\tE#1K\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0016y\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00053\u0012yEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0014QBQ1uG\"$U\r\\3hCR,7c\u0001\u0018R3\u0006aA-[2uS>t\u0017M]5fgB9\u0011\u0011\u0001B2\u007f\n\u001d\u0014\u0002\u0002B3\u0003'\u00111!T1q!\u0011\u0011IGa\u001b\u000e\u0005\u0005\u0005\u0013\u0002\u0002B7\u0003\u0003\u0012q\"\u0011:s_^$\u0015n\u0019;j_:\f'/\u001f\u000b\u0011\u0005c\u0012\u0019H!\u001e\u0003x\te$1\u0010B?\u0005\u007f\u00022!a6/\u0011\u0019\t\tN\u000ea\u0001=\"9\u00111\u0004\u001cA\u0002\u0005}\u0001bBAtm\u0001\u0007\u0011\u0011\u001e\u0005\u0006iZ\u0002\rA\u001e\u0005\b\u0003\u001b2\u0004\u0019AA)\u0011\u001d\u0011yF\u000ea\u0001\u0005CB\u0011\"a@7!\u0003\u0005\r!!\u0006\u0016\u0005\t\r\u0005\u0003\u0002B\f\u0005\u000bKAAa\"\u0003\u001a\ta2+[7qY\u00164U-\u0019;ve\u0016\f%O]8x\r&dWm\u0016:ji\u0016\u0014H\u0003BA=\u0005\u0017C\u0011\"!!9\u0003\u0003\u0005\rAa!\u0015\t\u0005e$q\u0012\u0005\n\u0003\u0003[\u0014\u0011!a\u0001\u0003O#B!!\u001f\u0003\u0014\"9\u00111R\u001fA\u0002\u00055E\u0003BAS\u0005/Ca\u0001\u0013 A\u0002\u0005=\u0016!\u0004\"bi\u000eDG)\u001a7fO\u0006$X\rE\u0002\u0002X\u0006\u001b2!QAc)\t\u0011Y*A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\u000e")
public class ArrowExporter
implements FeatureExporter {
    private Option<Tuple2<String, Object>> sort;
    private SimpleFeatureVector.SimpleFeatureEncoding encoding;
    private String ipc;
    private int batchSize;
    private Seq<String> dictionaryFields;
    private boolean flattenFields;
    private final OutputStream out;
    private final Hints hints;
    private FeatureExporter delegate;
    private volatile byte bitmap$0;

    private Option<Tuple2<String, Object>> sort$lzycompute() {
        ArrowExporter arrowExporter = this;
        synchronized (arrowExporter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sort = QueryHints$.MODULE$.RichHints(this.hints).getArrowSort();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sort;
    }

    private Option<Tuple2<String, Object>> sort() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.sort$lzycompute();
        }
        return this.sort;
    }

    private SimpleFeatureVector.SimpleFeatureEncoding encoding$lzycompute() {
        ArrowExporter arrowExporter = this;
        synchronized (arrowExporter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.encoding = SimpleFeatureVector.SimpleFeatureEncoding$.MODULE$.min(QueryHints$.MODULE$.RichHints(this.hints).isArrowIncludeFid(), QueryHints$.MODULE$.RichHints(this.hints).isArrowProxyFid(), QueryHints$.MODULE$.RichHints(this.hints).isFlipAxisOrder());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.encoding;
    }

    private SimpleFeatureVector.SimpleFeatureEncoding encoding() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.encoding$lzycompute();
        }
        return this.encoding;
    }

    private String ipc$lzycompute() {
        ArrowExporter arrowExporter = this;
        synchronized (arrowExporter) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.ipc = (String)QueryHints$.MODULE$.RichHints(this.hints).getArrowFormatVersion().getOrElse((Function0 & Serializable)() -> package.FormatVersion$.MODULE$.ArrowFormatVersion().get());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.ipc;
    }

    private String ipc() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.ipc$lzycompute();
        }
        return this.ipc;
    }

    private int batchSize$lzycompute() {
        ArrowExporter arrowExporter = this;
        synchronized (arrowExporter) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.batchSize = BoxesRunTime.unboxToInt((Object)QueryHints$.MODULE$.RichHints(this.hints).getArrowBatchSize().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(package.ArrowProperties$.MODULE$.BatchSize().get()))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.batchSize;
    }

    private int batchSize() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.batchSize$lzycompute();
        }
        return this.batchSize;
    }

    private Seq<String> dictionaryFields$lzycompute() {
        ArrowExporter arrowExporter = this;
        synchronized (arrowExporter) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.dictionaryFields = QueryHints$.MODULE$.RichHints(this.hints).getArrowDictionaryFields();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.dictionaryFields;
    }

    private Seq<String> dictionaryFields() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.dictionaryFields$lzycompute();
        }
        return this.dictionaryFields;
    }

    private boolean flattenFields$lzycompute() {
        ArrowExporter arrowExporter = this;
        synchronized (arrowExporter) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.flattenFields = QueryHints$.MODULE$.RichHints(this.hints).isArrowFlatten();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.flattenFields;
    }

    private boolean flattenFields() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.flattenFields$lzycompute();
        }
        return this.flattenFields;
    }

    private FeatureExporter delegate() {
        return this.delegate;
    }

    private void delegate_$eq(FeatureExporter x$1) {
        this.delegate = x$1;
    }

    @Override
    public void start(SimpleFeatureType sft) {
        FeatureExporter featureExporter;
        SimpleFeatureType simpleFeatureType = sft;
        SimpleFeatureType simpleFeatureType2 = package$.MODULE$.ArrowEncodedSft();
        if (!(simpleFeatureType != null ? !simpleFeatureType.equals(simpleFeatureType2) : simpleFeatureType2 != null)) {
            featureExporter = new EncodedDelegate(this.out);
        } else if (this.dictionaryFields().isEmpty()) {
            featureExporter = new BatchDelegate(this.out, this.encoding(), package.FormatVersion$.MODULE$.options(this.ipc()), this.sort(), this.batchSize(), (Map<String, ArrowDictionary>)Predef$.MODULE$.Map().empty(), this.flattenFields());
        } else {
            if (this.sort().isDefined()) {
                throw new NotImplementedError("Sorting and calculating dictionaries at the same time is not supported");
            }
            featureExporter = new DictionaryDelegate(this.out, this.dictionaryFields(), this.encoding(), package.FormatVersion$.MODULE$.options(this.ipc()), this.batchSize(), this.flattenFields());
        }
        this.delegate_$eq(featureExporter);
        this.delegate().start(sft);
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        return this.delegate().export(features);
    }

    @Override
    public void close() {
        package.CloseWithLogging$.MODULE$.apply((Object)Option$.MODULE$.apply((Object)this.delegate()), (IsCloseable)IsCloseable$.MODULE$.optionIsCloseable());
        this.out.close();
    }

    public ArrowExporter(OutputStream out, Hints hints) {
        this.out = out;
        this.hints = hints;
    }

    private static class BatchDelegate
    implements FeatureExporter {
        private final OutputStream os;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final IpcOption ipcOpts;
        private final Option<Tuple2<String, Object>> sort;
        private final int batchSize;
        private final Map<String, ArrowDictionary> dictionaries;
        private final boolean flattenStruct;
        private SimpleFeatureArrowFileWriter writer;
        private long count;

        private SimpleFeatureArrowFileWriter writer() {
            return this.writer;
        }

        private void writer_$eq(SimpleFeatureArrowFileWriter x$1) {
            this.writer = x$1;
        }

        private long count() {
            return this.count;
        }

        private void count_$eq(long x$1) {
            this.count = x$1;
        }

        @Override
        public void start(SimpleFeatureType sft) {
            this.writer_$eq(SimpleFeatureArrowFileWriter$.MODULE$.apply(this.os, sft, this.dictionaries, this.encoding, this.ipcOpts, this.sort, this.flattenStruct));
        }

        @Override
        public Option<Object> export(Iterator<SimpleFeature> features) {
            long start = this.count();
            features.foreach((Function1 & Serializable)f -> {
                BatchDelegate.$anonfun$export$3(this, f);
                return BoxedUnit.UNIT;
            });
            return new Some((Object)BoxesRunTime.boxToLong((long)(this.count() - start)));
        }

        @Override
        public void close() {
            if (this.writer() != null) {
                package.CloseWithLogging$.MODULE$.apply((Object)this.writer(), IsCloseable$.MODULE$.closeableIsCloseable());
                return;
            }
        }

        public static final /* synthetic */ void $anonfun$export$3(BatchDelegate $this, SimpleFeature f) {
            $this.writer().add(f);
            $this.count_$eq($this.count() + 1L);
            if ($this.count() % (long)$this.batchSize == 0L) {
                $this.writer().flush();
                return;
            }
        }

        public BatchDelegate(OutputStream os, SimpleFeatureVector.SimpleFeatureEncoding encoding, IpcOption ipcOpts, Option<Tuple2<String, Object>> sort, int batchSize, Map<String, ArrowDictionary> dictionaries, boolean flattenStruct) {
            this.os = os;
            this.encoding = encoding;
            this.ipcOpts = ipcOpts;
            this.sort = sort;
            this.batchSize = batchSize;
            this.dictionaries = dictionaries;
            this.flattenStruct = flattenStruct;
            this.count = 0L;
        }
    }

    private static class DictionaryDelegate
    implements FeatureExporter {
        private final OutputStream os;
        private final Seq<String> dictionaryFields;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final IpcOption ipcOpts;
        private final int batchSize;
        private final boolean flattenStruct;
        private DictionaryBuildingWriter writer;
        private long count;

        private DictionaryBuildingWriter writer() {
            return this.writer;
        }

        private void writer_$eq(DictionaryBuildingWriter x$1) {
            this.writer = x$1;
        }

        private long count() {
            return this.count;
        }

        private void count_$eq(long x$1) {
            this.count = x$1;
        }

        @Override
        public void start(SimpleFeatureType sft) {
            SimpleFeatureType x$1 = sft;
            Seq<String> x$2 = this.dictionaryFields;
            SimpleFeatureVector.SimpleFeatureEncoding x$3 = this.encoding;
            IpcOption x$4 = this.ipcOpts;
            boolean x$5 = this.flattenStruct;
            int x$6 = DictionaryBuildingWriter$.MODULE$.$lessinit$greater$default$5();
            this.writer_$eq(new DictionaryBuildingWriter(x$1, x$2, x$3, x$4, x$6, x$5));
        }

        @Override
        public Option<Object> export(Iterator<SimpleFeature> features) {
            long start = this.count();
            features.foreach((Function1 & Serializable)f -> {
                DictionaryDelegate.$anonfun$export$2(this, f);
                return BoxedUnit.UNIT;
            });
            return new Some((Object)BoxesRunTime.boxToLong((long)(this.count() - start)));
        }

        @Override
        public void close() {
            if (this.writer() != null) {
                if (this.count() % (long)this.batchSize != 0L) {
                    this.writer().encode(this.os);
                    this.writer().clear();
                }
                package.CloseWithLogging$.MODULE$.apply((Object)this.writer(), IsCloseable$.MODULE$.closeableIsCloseable());
                return;
            }
        }

        public static final /* synthetic */ void $anonfun$export$2(DictionaryDelegate $this, SimpleFeature f) {
            $this.writer().add(f);
            $this.count_$eq($this.count() + 1L);
            if ($this.count() % (long)$this.batchSize == 0L) {
                $this.writer().encode($this.os);
                $this.writer().clear();
                return;
            }
        }

        public DictionaryDelegate(OutputStream os, Seq<String> dictionaryFields, SimpleFeatureVector.SimpleFeatureEncoding encoding, IpcOption ipcOpts, int batchSize, boolean flattenStruct) {
            this.os = os;
            this.dictionaryFields = dictionaryFields;
            this.encoding = encoding;
            this.ipcOpts = ipcOpts;
            this.batchSize = batchSize;
            this.flattenStruct = flattenStruct;
            this.count = 0L;
        }
    }

    private static class EncodedDelegate
    implements FeatureExporter {
        private final OutputStream os;

        @Override
        public void start(SimpleFeatureType sft) {
        }

        @Override
        public Option<Object> export(Iterator<SimpleFeature> features) {
            features.foreach((Function1 & Serializable)f -> {
                this.os.write((byte[])f.getAttribute(0));
                return BoxedUnit.UNIT;
            });
            return None$.MODULE$;
        }

        @Override
        public void close() {
        }

        public EncodedDelegate(OutputStream os) {
            this.os = os;
        }
    }
}

