/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.exporters;

import java.io.OutputStream;
import java.io.Serializable;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.features.exporters.FeatureExporter;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001\u0002\u0007\u000e\u0001aA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!)q\u0007\u0001C\u0001q!9A\b\u0001b\u0001\n\u0013i\u0004B\u0002#\u0001A\u0003%a\bC\u0004F\u0001\u0001\u0007I\u0011\u0002$\t\u000fI\u0003\u0001\u0019!C\u0005'\"1\u0011\f\u0001Q!\n\u001dCQA\u0017\u0001\u0005BmCQ\u0001\u001b\u0001\u0005B%DQA \u0001\u0005B}\u00141BQ5o\u000bb\u0004xN\u001d;fe*\u0011abD\u0001\nKb\u0004xN\u001d;feNT!\u0001E\t\u0002\u0011\u0019,\u0017\r^;sKNT!AE\n\u0002\u000f\u001d,w.\\3tC*\u0011A#F\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002-\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!G\u0011\u0011\u0005iyR\"A\u000e\u000b\u0005qi\u0012\u0001\u00027b]\u001eT\u0011AH\u0001\u0005U\u00064\u0018-\u0003\u0002!7\t1qJ\u00196fGR\u0004\"AI\u0012\u000e\u00035I!\u0001J\u0007\u0003\u001f\u0019+\u0017\r^;sK\u0016C\bo\u001c:uKJ\f1a\\;u!\t9#&D\u0001)\u0015\tIS$\u0001\u0002j_&\u00111\u0006\u000b\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\u0006Q&tGo\u001d\t\u0003]Uj\u0011a\f\u0006\u0003aE\nqAZ1di>\u0014\u0018P\u0003\u00023g\u0005!Q\u000f^5m\u0015\t!T#\u0001\u0005hK>$xn\u001c7t\u0013\t1tFA\u0003IS:$8/\u0001\u0004=S:LGO\u0010\u000b\u0004siZ\u0004C\u0001\u0012\u0001\u0011\u0015)3\u00011\u0001'\u0011\u0015a3\u00011\u0001.\u0003\u0015a\u0017MY3m+\u0005q\u0004CA C\u001b\u0005\u0001%\"A!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0003%a\u0002\"p_2,\u0017M\\\u0001\u0007Y\u0006\u0014W\r\u001c\u0011\u0002\u000f\u0015t7m\u001c3feV\tq\tE\u0002@\u0011*K!!\u0013!\u0003\r=\u0003H/[8o!\tY\u0005+D\u0001M\u0015\tie*A\u0002cS:T!aT\t\u0002\u000bU$\u0018\u000e\\:\n\u0005Ec%a\u0005\"j]\u0006\u0014\u0018pT;uaV$XI\\2pI\u0016\u0014\u0018aC3oG>$WM]0%KF$\"\u0001V,\u0011\u0005}*\u0016B\u0001,A\u0005\u0011)f.\u001b;\t\u000fa;\u0011\u0011!a\u0001\u000f\u0006\u0019\u0001\u0010J\u0019\u0002\u0011\u0015t7m\u001c3fe\u0002\nQa\u001d;beR$\"\u0001\u0016/\t\u000buK\u0001\u0019\u00010\u0002\u0007M4G\u000f\u0005\u0002`M6\t\u0001M\u0003\u0002bE\u000611/[7qY\u0016T!a\u00193\u0002\u000f\u0019,\u0017\r^;sK*\u0011QmM\u0001\u0004CBL\u0017BA4a\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/Z\u0001\u0007Kb\u0004xN\u001d;\u0015\u0005)t\u0007cA IWB\u0011q\b\\\u0005\u0003[\u0002\u0013A\u0001T8oO\")\u0001C\u0003a\u0001_B\u0019\u0001\u000f_>\u000f\u0005E4hB\u0001:v\u001b\u0005\u0019(B\u0001;\u0018\u0003\u0019a$o\\8u}%\t\u0011)\u0003\u0002x\u0001\u00069\u0001/Y2lC\u001e,\u0017BA={\u0005!IE/\u001a:bi>\u0014(BA<A!\tyF0\u0003\u0002~A\ni1+[7qY\u00164U-\u0019;ve\u0016\fQa\u00197pg\u0016$\u0012\u0001\u0016")
public class BinExporter
implements FeatureExporter {
    private final OutputStream out;
    private final Hints hints;
    private final boolean label;
    private Option<BinaryOutputEncoder> encoder;

    private boolean label() {
        return this.label;
    }

    private Option<BinaryOutputEncoder> encoder() {
        return this.encoder;
    }

    private void encoder_$eq(Option<BinaryOutputEncoder> x$1) {
        this.encoder = x$1;
    }

    @Override
    public void start(SimpleFeatureType sft) {
        SimpleFeatureType simpleFeatureType = sft;
        SimpleFeatureType simpleFeatureType2 = BinaryOutputEncoder$.MODULE$.BinEncodedSft();
        if (!(simpleFeatureType != null ? !simpleFeatureType.equals(simpleFeatureType2) : simpleFeatureType2 != null)) {
            this.encoder_$eq((Option<BinaryOutputEncoder>)None$.MODULE$);
            return;
        }
        Option geom = QueryHints$.MODULE$.RichHints(this.hints).getBinGeomField().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)sft.indexOf(x$1)));
        Option dtg = QueryHints$.MODULE$.RichHints(this.hints).getBinDtgField().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)sft.indexOf(x$1)));
        Option track = Option$.MODULE$.apply((Object)QueryHints$.MODULE$.RichHints(this.hints).getBinTrackIdField()).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BinExporter.$anonfun$start$3(x$1))).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)sft.indexOf(x$1)));
        BinaryOutputEncoder.EncodingOptions options = new BinaryOutputEncoder.EncodingOptions(geom, dtg, track, QueryHints$.MODULE$.RichHints(this.hints).getBinLabelField().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)sft.indexOf(x$1))), BinaryOutputEncoder.EncodingOptions$.MODULE$.apply$default$5());
        this.encoder_$eq((Option<BinaryOutputEncoder>)new Some((Object)BinaryOutputEncoder$.MODULE$.apply(sft, options)));
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        long l;
        Option<BinaryOutputEncoder> option = this.encoder();
        if (option instanceof Some) {
            Some some = (Some)option;
            BinaryOutputEncoder e = (BinaryOutputEncoder)some.value();
            l = e.encode(features, this.out);
        } else if (None$.MODULE$.equals(option)) {
            LongRef numBytes = LongRef.create((long)0L);
            features.foreach((Function1 & Serializable)f -> {
                BinExporter.$anonfun$export$1(this, numBytes, f);
                return BoxedUnit.UNIT;
            });
            l = numBytes.elem / (long)(this.label() ? 24 : 16);
        } else {
            throw new MatchError(option);
        }
        long count = l;
        this.out.flush();
        return new Some((Object)BoxesRunTime.boxToLong((long)count));
    }

    @Override
    public void close() {
        this.out.close();
    }

    public static final /* synthetic */ boolean $anonfun$start$3(String x$1) {
        String string = x$1;
        String string2 = "id";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$export$1(BinExporter $this, LongRef numBytes$1, SimpleFeature f) {
        byte[] bytes = (byte[])f.getAttribute(0);
        $this.out.write(bytes);
        numBytes$1.elem += (long)bytes.length;
    }

    public BinExporter(OutputStream out, Hints hints) {
        this.out = out;
        this.hints = hints;
        this.label = QueryHints$.MODULE$.RichHints(hints).getBinLabelField().isDefined();
        this.encoder = None$.MODULE$;
    }
}

