/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.exporters;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.locationtech.geomesa.features.exporters.DelimitedExporter$;
import org.locationtech.geomesa.features.exporters.FeatureExporter;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.jts.geom.Geometry;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0005\u0005]d\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!A\u0011\n\u0001B\u0001B\u0003%!\n\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003K\u0011\u0015\t\u0006\u0001\"\u0001S\u0011%A\u0006\u00011AA\u0002\u0013%\u0011\fC\u0005^\u0001\u0001\u0007\t\u0019!C\u0005=\"IA\r\u0001a\u0001\u0002\u0003\u0006KA\u0017\u0005\u0006K\u0002!\tE\u001a\u0005\u0006k\u0002!\tE\u001e\u0005\b\u00037\u0001A\u0011IA\u000f\u0011\u001d\ty\u0002\u0001C\u0005\u0003C9q!!\u0010\u0016\u0011\u0003\tyD\u0002\u0004\u0015+!\u0005\u0011\u0011\t\u0005\u0007#:!\t!!\u0013\t\r\tsA\u0011AA&\u0011%\t\u0019FDI\u0001\n\u0003\t)\u0006C\u0004\u0002l9!\t!!\u001c\t\u0013\u0005Ud\"%A\u0005\u0002\u0005U#!\u0005#fY&l\u0017\u000e^3e\u000bb\u0004xN\u001d;fe*\u0011acF\u0001\nKb\u0004xN\u001d;feNT!\u0001G\r\u0002\u0011\u0019,\u0017\r^;sKNT!AG\u000e\u0002\u000f\u001d,w.\\3tC*\u0011A$H\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002=\u0005\u0019qN]4\u0004\u0001M!\u0001!I\u0015.!\t\u0011s%D\u0001$\u0015\t!S%\u0001\u0003mC:<'\"\u0001\u0014\u0002\t)\fg/Y\u0005\u0003Q\r\u0012aa\u00142kK\u000e$\bC\u0001\u0016,\u001b\u0005)\u0012B\u0001\u0017\u0016\u0005=1U-\u0019;ve\u0016,\u0005\u0010]8si\u0016\u0014\bC\u0001\u00186\u001b\u0005y#B\u0001\u00192\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\u00114'\u0001\u0005usB,7/\u00194f\u0015\u0005!\u0014aA2p[&\u0011ag\f\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-A\u0002pkR\u0004\"!\u000f\u001f\u000e\u0003iR!aO\u0013\u0002\u0005%|\u0017BA\u001f;\u00051yU\u000f\u001e9viN#(/Z1n\u0003\u00191wN]7biB\u0011\u0001iR\u0007\u0002\u0003*\u0011!iQ\u0001\u0004GN4(B\u0001#F\u0003\u001d\u0019w.\\7p]NT!AR\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tA\u0015IA\u0005D'Z3uN]7bi\u0006Qq/\u001b;i\u0011\u0016\fG-\u001a:\u0011\u0005-sU\"\u0001'\u000b\u00035\u000bQa]2bY\u0006L!a\u0014'\u0003\u000f\t{w\u000e\\3b]\u0006Q\u0011N\\2mk\u0012,\u0017\nZ:\u0002\rqJg.\u001b;?)\u0015\u0019F+\u0016,X!\tQ\u0003\u0001C\u00038\u000b\u0001\u0007\u0001\bC\u0003?\u000b\u0001\u0007q\bC\u0003J\u000b\u0001\u0007!\nC\u0003Q\u000b\u0001\u0007!*A\u0004qe&tG/\u001a:\u0016\u0003i\u0003\"\u0001Q.\n\u0005q\u000b%AC\"T-B\u0013\u0018N\u001c;fe\u0006Y\u0001O]5oi\u0016\u0014x\fJ3r)\ty&\r\u0005\u0002LA&\u0011\u0011\r\u0014\u0002\u0005+:LG\u000fC\u0004d\u000f\u0005\u0005\t\u0019\u0001.\u0002\u0007a$\u0013'\u0001\u0005qe&tG/\u001a:!\u0003\u0015\u0019H/\u0019:u)\tyv\rC\u0003i\u0013\u0001\u0007\u0011.A\u0002tMR\u0004\"A[:\u000e\u0003-T!\u0001\\7\u0002\rMLW\u000e\u001d7f\u0015\tqw.A\u0004gK\u0006$XO]3\u000b\u0005A\f\u0018aA1qS*\u0011!/H\u0001\tO\u0016|Go\\8mg&\u0011Ao\u001b\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017AB3ya>\u0014H\u000f\u0006\u0002x{B\u00191\n\u001f>\n\u0005ed%AB(qi&|g\u000e\u0005\u0002Lw&\u0011A\u0010\u0014\u0002\u0005\u0019>tw\rC\u0003\u0019\u0015\u0001\u0007a\u0010E\u0003\u0000\u0003\u001f\t)B\u0004\u0003\u0002\u0002\u0005-a\u0002BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001dq$\u0001\u0004=e>|GOP\u0005\u0002\u001b&\u0019\u0011Q\u0002'\u0002\u000fA\f7m[1hK&!\u0011\u0011CA\n\u0005!IE/\u001a:bi>\u0014(bAA\u0007\u0019B\u0019!.a\u0006\n\u0007\u0005e1NA\u0007TS6\u0004H.\u001a$fCR,(/Z\u0001\u0006G2|7/\u001a\u000b\u0002?\u0006I1\u000f\u001e:j]\u001eLg-\u001f\u000b\u0005\u0003G\t\u0019\u0004\u0005\u0003\u0002&\u00055b\u0002BA\u0014\u0003S\u00012!a\u0001M\u0013\r\tY\u0003T\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0012\u0011\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005-B\nC\u0004\u000261\u0001\r!a\u000e\u0002\u0007=\u0014'\u000eE\u0002L\u0003sI1!a\u000fM\u0005\r\te._\u0001\u0012\t\u0016d\u0017.\\5uK\u0012,\u0005\u0010]8si\u0016\u0014\bC\u0001\u0016\u000f'\rq\u00111\t\t\u0004\u0017\u0006\u0015\u0013bAA$\u0019\n1\u0011I\\=SK\u001a$\"!a\u0010\u0015\u000fM\u000bi%a\u0014\u0002R!)q\u0007\u0005a\u0001q!)\u0011\n\u0005a\u0001\u0015\"9\u0001\u000b\u0005I\u0001\u0002\u0004Q\u0015!D2tm\u0012\"WMZ1vYR$3'\u0006\u0002\u0002X)\u001a!*!\u0017,\u0005\u0005m\u0003\u0003BA/\u0003Oj!!a\u0018\u000b\t\u0005\u0005\u00141M\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001aM\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003S\nyFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0001^:w)\u001d\u0019\u0016qNA9\u0003gBQa\u000e\nA\u0002aBQ!\u0013\nA\u0002)Cq\u0001\u0015\n\u0011\u0002\u0003\u0007!*A\u0007ugZ$C-\u001a4bk2$He\r")
public class DelimitedExporter
implements FeatureExporter,
LazyLogging {
    private final OutputStream out;
    private final CSVFormat format;
    private final boolean withHeader;
    private final boolean includeIds;
    private CSVPrinter printer;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static boolean tsv$default$3() {
        return DelimitedExporter$.MODULE$.tsv$default$3();
    }

    public static DelimitedExporter tsv(OutputStream out, boolean withHeader, boolean includeIds) {
        return DelimitedExporter$.MODULE$.tsv(out, withHeader, includeIds);
    }

    public static boolean csv$default$3() {
        return DelimitedExporter$.MODULE$.csv$default$3();
    }

    public static DelimitedExporter csv(OutputStream out, boolean withHeader, boolean includeIds) {
        return DelimitedExporter$.MODULE$.csv(out, withHeader, includeIds);
    }

    private Logger logger$lzycompute() {
        DelimitedExporter delimitedExporter = this;
        synchronized (delimitedExporter) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private CSVPrinter printer() {
        return this.printer;
    }

    private void printer_$eq(CSVPrinter x$1) {
        this.printer = x$1;
    }

    @Override
    public void start(SimpleFeatureType sft) {
        this.printer_$eq(this.format.print((Appendable)new OutputStreamWriter(this.out, StandardCharsets.UTF_8)));
        if (this.withHeader) {
            if (this.includeIds) {
                this.printer().print((Object)"id");
            }
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).foreach((Function1 & Serializable)descriptor -> {
                DelimitedExporter.$anonfun$start$1(this, sft, descriptor);
                return BoxedUnit.UNIT;
            });
            this.printer().println();
            this.printer().flush();
            return;
        }
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        BoxedUnit boxedUnit;
        LongRef count = LongRef.create((long)0L);
        features.foreach((Function1 & Serializable)sf -> {
            DelimitedExporter.$anonfun$export$1(this, count, sf);
            return BoxedUnit.UNIT;
        });
        this.printer().flush();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Exported {} features", (Object)BoxesRunTime.boxToLong((long)count.elem));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)count.elem));
    }

    @Override
    public void close() {
        if (this.printer() != null) {
            this.printer().close();
            return;
        }
    }

    private String stringify(Object obj2) {
        Object object = obj2;
        if (object == null) {
            return "";
        }
        if (object instanceof Geometry) {
            Geometry geometry = (Geometry)object;
            return WKTUtils$.MODULE$.write(geometry);
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return package$.MODULE$.GeoToolsDateFormat().format(Instant.ofEpochMilli(date.getTime()).atZone(ZoneOffset.UTC));
        }
        if (object instanceof List) {
            List list = (List)object;
            return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).map((Function1 & Serializable)obj -> this.stringify(obj))).mkString(",");
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    return new StringBuilder(2).append(this.stringify(k)).append("->").append(this.stringify(v)).toString();
                }
                throw new MatchError((Object)tuple2);
            })).mkString(",");
        }
        return obj2.toString();
    }

    public static final /* synthetic */ void $anonfun$start$1(DelimitedExporter $this, SimpleFeatureType sft$1, AttributeDescriptor descriptor) {
        $this.printer().print((Object)SimpleFeatureTypes$.MODULE$.encodeDescriptor(sft$1, descriptor));
    }

    public static final /* synthetic */ void $anonfun$export$1(DelimitedExporter $this, LongRef count$1, SimpleFeature sf) {
        if ($this.includeIds) {
            $this.printer().print((Object)sf.getID());
        }
        for (int i = 0; i < sf.getAttributeCount(); ++i) {
            $this.printer().print((Object)$this.stringify(sf.getAttribute(i)));
        }
        $this.printer().println();
        ++count$1.elem;
        if (count$1.elem % 10000L == 0L) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("wrote {} features", (Object)BoxesRunTime.boxToLong((long)count$1.elem));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public DelimitedExporter(OutputStream out, CSVFormat format, boolean withHeader, boolean includeIds) {
        this.out = out;
        this.format = format;
        this.withHeader = withHeader;
        this.includeIds = includeIds;
        LazyLogging.$init$((LazyLogging)this);
    }
}

