/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.exporters;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.features.exporters.FeatureExporter;
import org.locationtech.geomesa.features.exporters.FileSystemExporter$;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.orc.OrcFileSystemWriter;
import org.locationtech.geomesa.fs.storage.orc.OrcFileSystemWriter$;
import org.locationtech.geomesa.fs.storage.parquet.ParquetFileSystemStorage;
import org.locationtech.geomesa.utils.io.PathUtils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0005\u0005]c!\u0002\u000b\u0016\u0003\u0003\u0001\u0003\"B\u0017\u0001\t\u0003q\u0003\"\u0003\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u00032\u0011%q\u0005\u00011AA\u0002\u0013%q\nC\u0005Y\u0001\u0001\u0007\t\u0011)Q\u0005e!)\u0011\f\u0001D\t5\")\u0001\u000e\u0001C!S\")1\u000e\u0001C!Y\"9\u0011\u0011\u0001\u0001\u0005B\u0005\rqaBA\u0003+!\u0005\u0011q\u0001\u0004\u0007)UA\t!!\u0003\t\r5RA\u0011AA\u0013\r\u0019\t9C\u0003\u0001\u0002*!Q\u00111\u0006\u0007\u0003\u0002\u0003\u0006I!!\f\t\r5bA\u0011AA\u001f\u0011\u0019IF\u0002\"\u0015\u0002F\u00191\u0011\u0011\n\u0006\u0001\u0003\u0017B!\"a\u000b\u0011\u0005\u0003\u0005\u000b\u0011BA\u0017\u0011\u0019i\u0003\u0003\"\u0001\u0002N!1\u0011\f\u0005C)\u0003'\u0012!CR5mKNK8\u000f^3n\u000bb\u0004xN\u001d;fe*\u0011acF\u0001\nKb\u0004xN\u001d;feNT!\u0001G\r\u0002\u0011\u0019,\u0017\r^;sKNT!AG\u000e\u0002\u000f\u001d,w.\\3tC*\u0011A$H\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002=\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!I\u0015\u0011\u0005\t:S\"A\u0012\u000b\u0005\u0011*\u0013\u0001\u00027b]\u001eT\u0011AJ\u0001\u0005U\u00064\u0018-\u0003\u0002)G\t1qJ\u00196fGR\u0004\"AK\u0016\u000e\u0003UI!\u0001L\u000b\u0003\u001f\u0019+\u0017\r^;sK\u0016C\bo\u001c:uKJ\fa\u0001P5oSRtD#A\u0018\u0011\u0005)\u0002\u0011AB<sSR,'/F\u00013!\t\u00194J\u0004\u00025\u0011:\u0011Q'\u0012\b\u0003m\ts!a\u000e!\u000f\u0005azdBA\u001d?\u001d\tQT(D\u0001<\u0015\tat$\u0001\u0004=e>|GOP\u0005\u0002=%\u0011A$H\u0005\u00035mI!!Q\r\u0002\u0005\u0019\u001c\u0018BA\"E\u0003\u001d\u0019Ho\u001c:bO\u0016T!!Q\r\n\u0005\u0019;\u0015aA1qS*\u00111\tR\u0005\u0003\u0013*\u000b\u0011CR5mKNK8\u000f^3n'R|'/Y4f\u0015\t1u)\u0003\u0002M\u001b\n\u0001b)\u001b7f'f\u001cH/Z7Xe&$XM\u001d\u0006\u0003\u0013*\u000b!b\u001e:ji\u0016\u0014x\fJ3r)\t\u0001f\u000b\u0005\u0002R)6\t!KC\u0001T\u0003\u0015\u00198-\u00197b\u0013\t)&K\u0001\u0003V]&$\bbB,\u0004\u0003\u0003\u0005\rAM\u0001\u0004q\u0012\n\u0014aB<sSR,'\u000fI\u0001\rGJ,\u0017\r^3Xe&$XM\u001d\u000b\u0003emCQ\u0001X\u0003A\u0002u\u000b1a\u001d4u!\tqf-D\u0001`\u0015\t\u0001\u0017-\u0001\u0004tS6\u0004H.\u001a\u0006\u0003E\u000e\fqAZ3biV\u0014XM\u0003\u0002GI*\u0011Q-H\u0001\tO\u0016|Go\\8mg&\u0011qm\u0018\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017!B:uCJ$HC\u0001)k\u0011\u0015af\u00011\u0001^\u0003\u0019)\u0007\u0010]8siR\u0011Qn\u001d\t\u0004#:\u0004\u0018BA8S\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011+]\u0005\u0003eJ\u0013A\u0001T8oO\")\u0001d\u0002a\u0001iB\u0019QO_?\u000f\u0005YDhB\u0001\u001ex\u0013\u0005\u0019\u0016BA=S\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001f?\u0003\u0011%#XM]1u_JT!!\u001f*\u0011\u0005ys\u0018BA@`\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\u0006)1\r\\8tKR\t\u0001+\u0001\nGS2,7+_:uK6,\u0005\u0010]8si\u0016\u0014\bC\u0001\u0016\u000b'\u0015Q\u00111BA\t!\r\t\u0016QB\u0005\u0004\u0003\u001f\u0011&AB!osJ+g\r\u0005\u0003\u0002\u0014\u0005\u0005RBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\t\u0005m\u0011QD\u0001\tif\u0004Xm]1gK*\u0011\u0011qD\u0001\u0004G>l\u0017\u0002BA\u0012\u0003+\u00111\u0002T1{s2{wmZ5oOR\u0011\u0011q\u0001\u0002\u001a!\u0006\u0014\u0018/^3u\r&dWmU=ti\u0016lW\t\u001f9peR,'o\u0005\u0002\r_\u0005!\u0001/\u0019;i!\u0011\ty#a\u000e\u000f\t\u0005E\u00121\u0007\t\u0003uIK1!!\u000eS\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011HA\u001e\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0007*\u0015\t\u0005}\u00121\t\t\u0004\u0003\u0003bQ\"\u0001\u0006\t\u000f\u0005-b\u00021\u0001\u0002.Q\u0019!'a\u0012\t\u000bq{\u0001\u0019A/\u0003+=\u00138MR5mKNK8\u000f^3n\u000bb\u0004xN\u001d;feN\u0011\u0001c\f\u000b\u0005\u0003\u001f\n\t\u0006E\u0002\u0002BAAq!a\u000b\u0013\u0001\u0004\ti\u0003F\u00023\u0003+BQ\u0001X\nA\u0002u\u0003")
public abstract class FileSystemExporter
implements FeatureExporter {
    private FileSystemStorage.FileSystemWriter writer;

    private FileSystemStorage.FileSystemWriter writer() {
        return this.writer;
    }

    private void writer_$eq(FileSystemStorage.FileSystemWriter x$1) {
        this.writer = x$1;
    }

    public abstract FileSystemStorage.FileSystemWriter createWriter(SimpleFeatureType var1);

    @Override
    public void start(SimpleFeatureType sft) {
        if (this.writer() != null) {
            this.writer().close();
        }
        this.writer_$eq(this.createWriter(sft));
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        Predef$.MODULE$.require(this.writer() != null, (Function0 & Serializable)() -> "Must call 'start' before 'export'");
        LongRef i = LongRef.create((long)0L);
        features.foreach((Function1 & Serializable)f -> {
            FileSystemExporter.$anonfun$export$2(this, i, f);
            return BoxedUnit.UNIT;
        });
        return new Some((Object)BoxesRunTime.boxToLong((long)i.elem));
    }

    @Override
    public void close() {
        if (this.writer() != null) {
            this.writer().close();
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$export$2(FileSystemExporter $this, LongRef i$1, SimpleFeature f) {
        $this.writer().write(f);
        ++i$1.elem;
    }

    public static class OrcFileSystemExporter
    extends FileSystemExporter {
        private final String path;

        @Override
        public FileSystemStorage.FileSystemWriter createWriter(SimpleFeatureType sft) {
            Path file = new Path(PathUtils$.MODULE$.getUrl(this.path).toURI());
            return new OrcFileSystemWriter(sft, package.FileSystemContext$.MODULE$.apply(file, new Configuration()), file, OrcFileSystemWriter$.MODULE$.$lessinit$greater$default$4());
        }

        public OrcFileSystemExporter(String path) {
            this.path = path;
        }
    }

    public static class ParquetFileSystemExporter
    extends FileSystemExporter {
        private final String path;

        @Override
        public FileSystemStorage.FileSystemWriter createWriter(SimpleFeatureType sft) {
            BoxedUnit boxedUnit;
            Path file = new Path(PathUtils$.MODULE$.getUrl(this.path).toURI());
            Configuration conf = new Configuration();
            try {
                boxedUnit = Class.forName("org.xerial.snappy.Snappy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                BoxedUnit boxedUnit2;
                if (FileSystemExporter$.MODULE$.logger().underlying().isWarnEnabled()) {
                    FileSystemExporter$.MODULE$.logger().underlying().warn("SNAPPY compression is not available on the classpath - falling back to GZIP");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                conf.set("parquet.compression", "GZIP");
                boxedUnit = BoxedUnit.UNIT;
            }
            return new ParquetFileSystemStorage.ParquetFileSystemWriter(sft, package.FileSystemContext$.MODULE$.apply(file, conf), file, ParquetFileSystemStorage.ParquetFileSystemWriter$.MODULE$.$lessinit$greater$default$4());
        }

        public ParquetFileSystemExporter(String path) {
            this.path = path;
        }
    }
}

