/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.exporters;

import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.WfsFactory;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.DataFeatureCollection;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.wfs.WFS;
import org.geotools.wfs.WFSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.locationtech.geomesa.features.exporters.FeatureExporter;
import org.locationtech.geomesa.features.exporters.GmlExporter$;
import org.locationtech.geomesa.utils.geotools.package$;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0005\t-a\u0001B\u0014)\u0001MB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\")\u0001\u000b\u0001C\u0005#\"9Q\u000b\u0001b\u0001\n\u00131\u0006BB/\u0001A\u0003%q\u000bC\u0004_\u0001\t\u0007I\u0011B0\t\r!\u0004\u0001\u0015!\u0003a\u0011%I\u0007\u00011AA\u0002\u0013%!\u000eC\u0006\u0002h\u0002\u0001\r\u00111A\u0005\n\u0005%\bBCAx\u0001\u0001\u0007\t\u0011)Q\u0005W\"9\u0011\u0011\u001f\u0001\u0005B\u0005M\bbBA|\u0001\u0011\u0005\u0013\u0011 \u0005\b\u0005\u0013\u0001A\u0011IAc\u000f\u0015Q\b\u0006#\u0001|\r\u00159\u0003\u0006#\u0001}\u0011\u0019\u0001v\u0002\"\u0001\u0002\b!I\u0011\u0011B\bC\u0002\u0013%\u00111\u0002\u0005\t\u0003'y\u0001\u0015!\u0003\u0002\u000e!9\u0011QC\b\u0005\u0002\u0005]\u0001bBA\u000e\u001f\u0011\u0005\u0011Q\u0004\u0004\u0007\u0003CyA!a\t\t\u0015\u0005URC!A!\u0002\u0013\t9\u0004\u0003\u0004Q+\u0011\u0005\u00111\n\u0005\n\u0003'*\"\u0019!C\u0005\u0003+B\u0001\"a\u0019\u0016A\u0003%\u0011q\u000b\u0005\n\u0003K*\"\u0019!C\u0005\u0003OB\u0001\"!\u001e\u0016A\u0003%\u0011\u0011\u000e\u0005\n\u0003o*\"\u0019!C\u0005\u0003sB\u0001\"a\"\u0016A\u0003%\u00111\u0010\u0005\n\u0003\u0013+\"\u0019!C\u0005\u0003\u0017C\u0001\"a%\u0016A\u0003%\u0011Q\u0012\u0005\n\u0003++\"\u0019!C\u0005\u0003/C\u0001\"a)\u0016A\u0003%\u0011\u0011\u0014\u0005\b\u0003K+B\u0011AAT\u0011\u001d\t\u0019-\u0006C\u0001\u0003\u000bDaaK\u000b\u0005B\u0005\u001d\u0007bBAe+\u0011\u0005\u00131\u001a\u0005\b\u0003;,B\u0011IAp\u0005-9U\u000e\\#ya>\u0014H/\u001a:\u000b\u0005%R\u0013!C3ya>\u0014H/\u001a:t\u0015\tYC&\u0001\u0005gK\u0006$XO]3t\u0015\tic&A\u0004hK>lWm]1\u000b\u0005=\u0002\u0014\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001!D\b\u0005\u00026u5\taG\u0003\u00028q\u0005!A.\u00198h\u0015\u0005I\u0014\u0001\u00026bm\u0006L!a\u000f\u001c\u0003\r=\u0013'.Z2u!\tid(D\u0001)\u0013\ty\u0004FA\bGK\u0006$XO]3FqB|'\u000f^3s\u0003\ryW\u000f\u001e\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\tb\n!![8\n\u0005\u0019\u001b%\u0001D(viB,Ho\u0015;sK\u0006l\u0017!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u0006\u0019qOZ:\u000b\u00055\u0003\u0014\u0001C4f_R|w\u000e\\:\n\u0005=S%\u0001E,G'\u000e{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q\u0019!k\u0015+\u0011\u0005u\u0002\u0001\"\u0002!\u0004\u0001\u0004\t\u0005\"B$\u0004\u0001\u0004A\u0015aB3oG>$WM]\u000b\u0002/B\u0011\u0001lW\u0007\u00023*\u0011!\fT\u0001\u0004qN$\u0017B\u0001/Z\u0005\u001d)enY8eKJ\f\u0001\"\u001a8d_\u0012,'\u000fI\u0001\u0003KN,\u0012\u0001\u0019\t\u0003C\u001al\u0011A\u0019\u0006\u0003G\u0012\f!bY8oGV\u0014(/\u001a8u\u0015\t)\u0007(\u0001\u0003vi&d\u0017BA4c\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017aA3tA\u0005\u0011amY\u000b\u0002WB\u0011A.\u0006\b\u0003[:q!A\\=\u000f\u0005=DhB\u00019x\u001d\t\thO\u0004\u0002sk6\t1O\u0003\u0002ue\u00051AH]8pizJ\u0011!M\u0005\u0003_AJ!!\f\u0018\n\u0005-b\u0013BA\u0015+\u0003-9U\u000e\\#ya>\u0014H/\u001a:\u0011\u0005uz1CA\b~!\rq\u00181A\u0007\u0002\u007f*\u0011\u0011\u0011A\u0001\u0006g\u000e\fG.Y\u0005\u0004\u0003\u000by(AB!osJ+g\rF\u0001|\u0003M!&/\u00198tM>\u0014X.\u001a:Qe>\u0004XM\u001d;z+\t\ti\u0001E\u00026\u0003\u001fI1!!\u00057\u0005\u0019\u0019FO]5oO\u0006!BK]1og\u001a|'/\\3s!J|\u0007/\u001a:us\u0002\nQ!\u00199qYf$2AUA\r\u0011\u0015\u00015\u00031\u0001B\u0003\u00119W\u000e\u001c\u001a\u0015\u0007I\u000by\u0002C\u0003A)\u0001\u0007\u0011I\u0001\fBgft7MR3biV\u0014XmQ8mY\u0016\u001cG/[8o'\r)\u0012Q\u0005\t\u0005\u0003O\t\t$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003\u0015\u0019Ho\u001c:f\u0015\r\ty\u0003T\u0001\u0005I\u0006$\u0018-\u0003\u0003\u00024\u0005%\"!\u0006#bi\u00064U-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\\\u0001\u0004g\u001a$\b\u0003BA\u001d\u0003\u000fj!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u0007g&l\u0007\u000f\\3\u000b\t\u0005\u0005\u00131I\u0001\bM\u0016\fG/\u001e:f\u0015\r\t)\u0005T\u0001\u0004CBL\u0017\u0002BA%\u0003w\u0011\u0011cU5na2,g)Z1ukJ,G+\u001f9f)\u0011\ti%!\u0015\u0011\u0007\u0005=S#D\u0001\u0010\u0011\u001d\t)d\u0006a\u0001\u0003o\taAY;gM\u0016\u0014XCAA,!\u0015\t\u0017\u0011LA/\u0013\r\tYF\u0019\u0002\u0016\u0007>t7-\u001e:sK:$H*\u001b8lK\u0012\fV/Z;f!\u0011\tI$a\u0018\n\t\u0005\u0005\u00141\b\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\u0002\u000f\t,hMZ3sA\u0005!Am\u001c8f+\t\tI\u0007\u0005\u0003\u0002l\u0005ETBAA7\u0015\r\tyGY\u0001\u0007CR|W.[2\n\t\u0005M\u0014Q\u000e\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u000b\u0011|g.\u001a\u0011\u0002\t1|7m[\u000b\u0003\u0003w\u0002B!! \u0002\u00046\u0011\u0011q\u0010\u0006\u0004\u0003\u0003\u0013\u0017!\u00027pG.\u001c\u0018\u0002BAC\u0003\u007f\u0012QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0017!\u00027pG.\u0004\u0013!C2p]\u0012LG/[8o+\t\ti\t\u0005\u0003\u0002~\u0005=\u0015\u0002BAI\u0003\u007f\u0012\u0011bQ8oI&$\u0018n\u001c8\u0002\u0015\r|g\u000eZ5uS>t\u0007%\u0001\u0003ji\u0016\u0014XCAAM!\u0011\tY*a(\u000e\u0005\u0005u%\u0002BA\u001f\u0003[IA!!)\u0002\u001e\n)2+[7qY\u00164U-\u0019;ve\u0016LE/\u001a:bi>\u0014\u0018!B5uKJ\u0004\u0013\u0001C1eI\u0006\u001b\u0018P\\2\u0015\t\u0005%\u0016q\u0016\t\u0004}\u0006-\u0016bAAW\u007f\n!QK\\5u\u0011\u0019Y#\u00051\u0001\u00022B1\u00111WA_\u0003;rA!!.\u0002::\u0019!/a.\n\u0005\u0005\u0005\u0011bAA^\u007f\u00069\u0001/Y2lC\u001e,\u0017\u0002BA`\u0003\u0003\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003w{\u0018\u0001C3oI\u0006\u001b\u0018P\\2\u0015\u0005\u0005%FCAAM\u0003%9W\r\u001e\"pk:$7\u000f\u0006\u0002\u0002NB!\u0011qZAm\u001b\t\t\tN\u0003\u0003\u0002T\u0006U\u0017a\u00016ug*\u0019\u0011q\u001b'\u0002\u0011\u001d,w.\\3uefLA!a7\u0002R\n\u0011\"+\u001a4fe\u0016t7-\u001a3F]Z,Gn\u001c9f\u0003!9W\r^\"pk:$HCAAq!\rq\u00181]\u0005\u0004\u0003K|(aA%oi\u00061amY0%KF$B!!+\u0002l\"A\u0011Q^\u0005\u0002\u0002\u0003\u00071.A\u0002yIE\n1AZ2!\u0003\u0015\u0019H/\u0019:u)\u0011\tI+!>\t\u000f\u0005U2\u00021\u0001\u00028\u00051Q\r\u001f9peR$B!a?\u0003\bA)a0!@\u0003\u0002%\u0019\u0011q`@\u0003\r=\u0003H/[8o!\rq(1A\u0005\u0004\u0005\u000by(\u0001\u0002'p]\u001eDaa\u000b\u0007A\u0002\u0005E\u0016!B2m_N,\u0007")
public class GmlExporter
implements FeatureExporter {
    private final OutputStream out;
    private final Encoder encoder;
    private final ExecutorService es;
    private AsyncFeatureCollection fc;

    public static GmlExporter gml2(OutputStream out) {
        return GmlExporter$.MODULE$.gml2(out);
    }

    public static GmlExporter apply(OutputStream out) {
        return GmlExporter$.MODULE$.apply(out);
    }

    private Encoder encoder() {
        return this.encoder;
    }

    private ExecutorService es() {
        return this.es;
    }

    private AsyncFeatureCollection fc() {
        return this.fc;
    }

    private void fc_$eq(AsyncFeatureCollection x$1) {
        this.fc = x$1;
    }

    @Override
    public void start(SimpleFeatureType sft) {
        AsyncFeatureCollection asyncFeatureCollection;
        this.fc_$eq(new AsyncFeatureCollection(sft));
        if (sft.getName().getNamespaceURI() != null) {
            asyncFeatureCollection = this.fc();
        } else {
            SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
            builder.init(sft);
            builder.setNamespaceURI("http://geomesa.org");
            asyncFeatureCollection = new ReTypingFeatureCollection((SimpleFeatureCollection)this.fc(), builder.buildFeatureType());
        }
        AsyncFeatureCollection features = asyncFeatureCollection;
        FeatureCollectionType collection = WfsFactory.eINSTANCE.createFeatureCollectionType();
        collection.getFeature().add((Object)features);
        Runnable runnable = new Runnable(this, collection){
            private final /* synthetic */ GmlExporter $outer;
            private final FeatureCollectionType collection$1;

            public void run() {
                if (System.getProperty(GmlExporter$.MODULE$.org$locationtech$geomesa$features$exporters$GmlExporter$$TransformerProperty()) != null) {
                    this.$outer.org$locationtech$geomesa$features$exporters$GmlExporter$$encode$1(this.collection$1);
                    return;
                }
                System.setProperty(GmlExporter$.MODULE$.org$locationtech$geomesa$features$exporters$GmlExporter$$TransformerProperty(), "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
                try {
                    this.$outer.org$locationtech$geomesa$features$exporters$GmlExporter$$encode$1(this.collection$1);
                }
                finally {
                    System.clearProperty(GmlExporter$.MODULE$.org$locationtech$geomesa$features$exporters$GmlExporter$$TransformerProperty());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.collection$1 = collection$1;
            }
        };
        this.es().execute(runnable);
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        LongRef count = LongRef.create((long)0L);
        Iterator counting = features.map((Function1 & Serializable)f -> {
            ++count$1.elem;
            return f;
        });
        while (counting.nonEmpty()) {
            this.fc().addAsync((Iterator<SimpleFeature>)counting.take(100));
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)count.elem));
    }

    @Override
    public void close() {
        try {
            if (this.fc() != null) {
                this.fc().endAsync();
            }
            this.es().shutdown();
            this.es().awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        finally {
            this.out.close();
        }
    }

    public final void org$locationtech$geomesa$features$exporters$GmlExporter$$encode$1(FeatureCollectionType collection$1) {
        this.encoder().encode((Object)collection$1, WFS.FeatureCollection, this.out);
    }

    public GmlExporter(OutputStream out, WFSConfiguration configuration) {
        this.out = out;
        Set props = configuration.getProperties();
        props.add(GMLConfiguration.OPTIMIZED_ENCODING);
        props.add(GMLConfiguration.NO_FEATURE_BOUNDS);
        Encoder e = new Encoder((Configuration)configuration);
        e.getNamespaces().declarePrefix("geomesa", "http://geomesa.org");
        e.setEncoding(StandardCharsets.UTF_8);
        e.setIndenting(true);
        this.encoder = e;
        this.es = Executors.newSingleThreadExecutor();
    }

    private static class AsyncFeatureCollection
    extends DataFeatureCollection {
        private final ConcurrentLinkedQueue<SimpleFeature> org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$buffer = new ConcurrentLinkedQueue();
        private final AtomicBoolean org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$done = new AtomicBoolean(false);
        private final ReentrantLock org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$lock = new ReentrantLock();
        private final Condition org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$condition = this.org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$lock().newCondition();
        private final SimpleFeatureIterator iter = new SimpleFeatureIterator(this){
            private SimpleFeature current;
            private final /* synthetic */ AsyncFeatureCollection $outer;

            private SimpleFeature current() {
                return this.current;
            }

            private void current_$eq(SimpleFeature x$1) {
                this.current = x$1;
            }

            public boolean hasNext() {
                boolean bl;
                block7: {
                    boolean bl2;
                    block6: {
                        if (this.current() != null) {
                            return true;
                        }
                        this.$outer.org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$lock().lock();
                        try {
                            this.current_$eq(this.$outer.org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$buffer().poll());
                            while (this.current() == null) {
                                if (this.$outer.org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$done().get()) {
                                    bl2 = false;
                                    break block6;
                                }
                                this.$outer.org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$condition().await();
                                this.current_$eq(this.$outer.org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$buffer().poll());
                            }
                            bl = true;
                            break block7;
                        }
                        finally {
                            this.$outer.org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$lock().unlock();
                        }
                    }
                    return bl2;
                }
                return bl;
            }

            public SimpleFeature next() {
                SimpleFeature result = this.current();
                this.current_$eq(null);
                return result;
            }

            public void close() {
                this.$outer.endAsync();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };

        public ConcurrentLinkedQueue<SimpleFeature> org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$buffer() {
            return this.org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$buffer;
        }

        public AtomicBoolean org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$done() {
            return this.org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$done;
        }

        public ReentrantLock org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$lock() {
            return this.org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$lock;
        }

        public Condition org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$condition() {
            return this.org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$condition;
        }

        private SimpleFeatureIterator iter() {
            return this.iter;
        }

        public void addAsync(Iterator<SimpleFeature> features) {
            this.org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$lock().lock();
            try {
                features.foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AsyncFeatureCollection.$anonfun$addAsync$1(this, x$1)));
                this.org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$condition().signal();
            }
            finally {
                this.org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$lock().unlock();
            }
        }

        public void endAsync() {
            this.org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$lock().lock();
            try {
                this.org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$done().set(true);
                this.org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$condition().signal();
            }
            finally {
                this.org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$lock().unlock();
            }
        }

        public SimpleFeatureIterator features() {
            return this.iter();
        }

        public ReferencedEnvelope getBounds() {
            return package$.MODULE$.wholeWorldEnvelope();
        }

        public int getCount() {
            return 0;
        }

        public static final /* synthetic */ boolean $anonfun$addAsync$1(AsyncFeatureCollection $this, SimpleFeature x$1) {
            return $this.org$locationtech$geomesa$features$exporters$GmlExporter$AsyncFeatureCollection$$buffer().add(x$1);
        }

        public AsyncFeatureCollection(SimpleFeatureType sft) {
            super(null, sft);
        }
    }
}

