/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.exporters;

import com.google.gson.stream.JsonWriter;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.features.exporters.FeatureExporter;
import org.locationtech.geomesa.features.exporters.LeafletMapExporter$;
import org.locationtech.geomesa.features.serialization.GeoJsonSerializer;
import org.locationtech.geomesa.features.serialization.GeoJsonSerializer$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ef\u0001B\u000f\u001f\u0001%B\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\u0006\u000f\u0002!\t\u0001\u0013\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003M\u0011\u0019\u0019\u0007\u0001)A\u0005\u001b\"IA\r\u0001a\u0001\u0002\u0004%I!\u001a\u0005\nS\u0002\u0001\r\u00111A\u0005\n)D\u0011\u0002\u001d\u0001A\u0002\u0003\u0005\u000b\u0015\u00024\t\u0013E\u0004\u0001\u0019!a\u0001\n\u0013\u0011\b\"C?\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u007f\u0011)\t\t\u0001\u0001a\u0001\u0002\u0003\u0006Ka\u001d\u0005\f\u0003\u0007\u0001\u0001\u0019!a\u0001\n\u0013\t)\u0001C\u0006\u0002\u0014\u0001\u0001\r\u00111A\u0005\n\u0005U\u0001bCA\r\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u000fA\u0011\"a\u0007\u0001\u0001\u0004%I!!\b\t\u0013\u0005\u0015\u0002\u00011A\u0005\n\u0005\u001d\u0002\u0002CA\u0016\u0001\u0001\u0006K!a\b\t\u000f\u00055\u0002\u0001\"\u0011\u00020!9\u0011Q\n\u0001\u0005B\u0005=\u0003bBA?\u0001\u0011\u0005\u0013qP\u0004\b\u0003\u0003s\u0002\u0012AAB\r\u0019ib\u0004#\u0001\u0002\u0006\"1q)\u0006C\u0001\u0003\u001bC\u0011\"a$\u0016\u0005\u0004%\t!!%\t\u000f\u0005MU\u0003)A\u0005?\"Q\u0011QS\u000b\t\u0006\u0004%I!a&\t\u0015\u00055V\u0003#b\u0001\n\u0013\ty\u000b\u0003\u0006\u00022VA)\u0019!C\u0005\u0003_Cq!a-\u0016\t\u0013\t)L\u0001\nMK\u00064G.\u001a;NCB,\u0005\u0010]8si\u0016\u0014(BA\u0010!\u0003%)\u0007\u0010]8si\u0016\u00148O\u0003\u0002\"E\u0005Aa-Z1ukJ,7O\u0003\u0002$I\u00059q-Z8nKN\f'BA\u0013'\u00031awnY1uS>tG/Z2i\u0015\u00059\u0013aA8sO\u000e\u00011\u0003\u0002\u0001+eY\u0002\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\t1\fgn\u001a\u0006\u0002_\u0005!!.\u0019<b\u0013\t\tDF\u0001\u0004PE*,7\r\u001e\t\u0003gQj\u0011AH\u0005\u0003ky\u0011qBR3biV\u0014X-\u0012=q_J$XM\u001d\t\u0003oyj\u0011\u0001\u000f\u0006\u0003si\nAb]2bY\u0006dwnZ4j]\u001eT!a\u000f\u001f\u0002\u0011QL\b/Z:bM\u0016T\u0011!P\u0001\u0004G>l\u0017BA 9\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\u0007=,H\u000f\u0005\u0002C\u000b6\t1I\u0003\u0002E]\u0005\u0011\u0011n\\\u0005\u0003\r\u000e\u0013AbT;uaV$8\u000b\u001e:fC6\fa\u0001P5oSRtDCA%K!\t\u0019\u0004\u0001C\u0003A\u0005\u0001\u0007\u0011)\u0001\u0005d_>\u0014H-T1q+\u0005i\u0005\u0003\u0002(V/~k\u0011a\u0014\u0006\u0003!F\u000bq!\\;uC\ndWM\u0003\u0002S'\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003Q\u000bQa]2bY\u0006L!AV(\u0003\u00075\u000b\u0007\u000f\u0005\u0002Y;6\t\u0011L\u0003\u0002[7\u0006!q-Z8n\u0015\taF%A\u0002kiNL!AX-\u0003\u0015\r{wN\u001d3j]\u0006$X\r\u0005\u0002aC6\t1+\u0003\u0002c'\n\u0019\u0011J\u001c;\u0002\u0013\r|wN\u001d3NCB\u0004\u0013AB<sSR,'/F\u0001g!\t\u0011u-\u0003\u0002i\u0007\n\u0011r*\u001e;qkR\u001cFO]3b[^\u0013\u0018\u000e^3s\u0003)9(/\u001b;fe~#S-\u001d\u000b\u0003W:\u0004\"\u0001\u00197\n\u00055\u001c&\u0001B+oSRDqa\u001c\u0004\u0002\u0002\u0003\u0007a-A\u0002yIE\nqa\u001e:ji\u0016\u0014\b%\u0001\u0006kg>twK]5uKJ,\u0012a\u001d\t\u0003inl\u0011!\u001e\u0006\u0003m^\faa\u001d;sK\u0006l'B\u0001=z\u0003\u001197o\u001c8\u000b\u0005id\u0014AB4p_\u001edW-\u0003\u0002}k\nQ!j]8o/JLG/\u001a:\u0002\u001d)\u001cxN\\,sSR,'o\u0018\u0013fcR\u00111n \u0005\b_&\t\t\u00111\u0001t\u0003-Q7o\u001c8Xe&$XM\u001d\u0011\u0002\u001d)\u001cxN\\*fe&\fG.\u001b>feV\u0011\u0011q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u0002\u0011\u0002\u001bM,'/[1mSj\fG/[8o\u0013\u0011\t\t\"a\u0003\u0003#\u001d+wNS:p]N+'/[1mSj,'/\u0001\nkg>t7+\u001a:jC2L'0\u001a:`I\u0015\fHcA6\u0002\u0018!Aq\u000eDA\u0001\u0002\u0004\t9!A\bkg>t7+\u001a:jC2L'0\u001a:!\u0003-1W-\u0019;ve\u0016LeNZ8\u0016\u0005\u0005}\u0001cA\u0016\u0002\"%\u0019\u00111\u0005\u0017\u0003\rM#(/\u001b8h\u0003=1W-\u0019;ve\u0016LeNZ8`I\u0015\fHcA6\u0002*!AqnDA\u0001\u0002\u0004\ty\"\u0001\u0007gK\u0006$XO]3J]\u001a|\u0007%A\u0003ti\u0006\u0014H\u000fF\u0002l\u0003cAq!a\r\u0012\u0001\u0004\t)$A\u0002tMR\u0004B!a\u000e\u0002J5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0004tS6\u0004H.\u001a\u0006\u0005\u0003\u007f\t\t%A\u0004gK\u0006$XO]3\u000b\t\u0005\r\u0013QI\u0001\u0004CBL'bAA$M\u0005Aq-Z8u_>d7/\u0003\u0003\u0002L\u0005e\"!E*j[BdWMR3biV\u0014X\rV=qK\u00061Q\r\u001f9peR$B!!\u0015\u0002^A)\u0001-a\u0015\u0002X%\u0019\u0011QK*\u0003\r=\u0003H/[8o!\r\u0001\u0017\u0011L\u0005\u0004\u00037\u001a&\u0001\u0002'p]\u001eDa!\t\nA\u0002\u0005}\u0003CBA1\u0003c\n9H\u0004\u0003\u0002d\u00055d\u0002BA3\u0003Wj!!a\u001a\u000b\u0007\u0005%\u0004&\u0001\u0004=e>|GOP\u0005\u0002)&\u0019\u0011qN*\u0002\u000fA\f7m[1hK&!\u00111OA;\u0005!IE/\u001a:bi>\u0014(bAA8'B!\u0011qGA=\u0013\u0011\tY(!\u000f\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0003\u0015\u0019Gn\\:f)\u0005Y\u0017A\u0005'fC\u001adW\r^'ba\u0016C\bo\u001c:uKJ\u0004\"aM\u000b\u0014\u0007U\t9\tE\u0002a\u0003\u0013K1!a#T\u0005\u0019\te.\u001f*fMR\u0011\u00111Q\u0001\f\u001b\u0006Dh)Z1ukJ,7/F\u0001`\u00031i\u0015\r\u001f$fCR,(/Z:!\u0003!!V-\u001c9mCR,WCAAM!\u0015\u0001\u00171TAP\u0013\r\tij\u0015\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003C\u000bIK\u0004\u0003\u0002$\u0006\u0015\u0006cAA3'&\u0019\u0011qU*\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019#a+\u000b\u0007\u0005\u001d6+A\u0005J]\u0012,\u0007\u0010S3bIV\u0011\u0011qT\u0001\n\u0013:$W\r\u001f+bS2\fabZ3u\r\u0016\fG/\u001e:f\u0013:4w\u000e\u0006\u0003\u0002 \u0006]\u0006bBA\u001a9\u0001\u0007\u0011Q\u0007")
public class LeafletMapExporter
implements FeatureExporter,
LazyLogging {
    private final OutputStream out;
    private final Map<Coordinate, Object> coordMap;
    private OutputStreamWriter writer;
    private JsonWriter jsonWriter;
    private GeoJsonSerializer jsonSerializer;
    private String featureInfo;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static int MaxFeatures() {
        return LeafletMapExporter$.MODULE$.MaxFeatures();
    }

    private Logger logger$lzycompute() {
        LeafletMapExporter leafletMapExporter = this;
        synchronized (leafletMapExporter) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Map<Coordinate, Object> coordMap() {
        return this.coordMap;
    }

    private OutputStreamWriter writer() {
        return this.writer;
    }

    private void writer_$eq(OutputStreamWriter x$1) {
        this.writer = x$1;
    }

    private JsonWriter jsonWriter() {
        return this.jsonWriter;
    }

    private void jsonWriter_$eq(JsonWriter x$1) {
        this.jsonWriter = x$1;
    }

    private GeoJsonSerializer jsonSerializer() {
        return this.jsonSerializer;
    }

    private void jsonSerializer_$eq(GeoJsonSerializer x$1) {
        this.jsonSerializer = x$1;
    }

    private String featureInfo() {
        return this.featureInfo;
    }

    private void featureInfo_$eq(String x$1) {
        this.featureInfo = x$1;
    }

    @Override
    public void start(SimpleFeatureType sft) {
        this.featureInfo_$eq(LeafletMapExporter$.MODULE$.org$locationtech$geomesa$features$exporters$LeafletMapExporter$$getFeatureInfo(sft));
        this.writer_$eq(new OutputStreamWriter(this.out, StandardCharsets.UTF_8));
        this.jsonWriter_$eq(GeoJsonSerializer$.MODULE$.writer((Writer)this.writer()));
        this.writer().write(LeafletMapExporter$.MODULE$.org$locationtech$geomesa$features$exporters$LeafletMapExporter$$IndexHead());
        this.writer().write("var points = ");
        this.writer().flush();
        this.jsonSerializer_$eq(new GeoJsonSerializer(sft));
        this.jsonSerializer().startFeatureCollection(this.jsonWriter());
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        long count = 0L;
        while (features.hasNext()) {
            SimpleFeature feature = (SimpleFeature)features.next();
            this.jsonSerializer().write(this.jsonWriter(), feature);
            Geometry geom = (Geometry)feature.getDefaultGeometry();
            if (geom != null) {
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])geom.getCoordinates()), (Function1 & Serializable)c -> {
                    LeafletMapExporter.$anonfun$export$1(this, c);
                    return BoxedUnit.UNIT;
                });
            }
            ++count;
        }
        this.jsonWriter().flush();
        return new Some((Object)BoxesRunTime.boxToLong((long)count));
    }

    @Override
    public void close() {
        if (this.writer() != null) {
            try {
                BoxedUnit boxedUnit;
                this.jsonSerializer().endFeatureCollection(this.jsonWriter());
                this.jsonWriter().flush();
                this.writer().write(";\n\n");
                this.writer().write(this.featureInfo());
                this.writer().write("var heat = L.heatLayer([\n");
                if (this.coordMap().isEmpty()) {
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("No features were exported - the map will not render correctly");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    int max = ((Tuple2)this.coordMap().maxBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$))._2$mcI$sp();
                    Iterator iter = this.coordMap().iterator();
                    iter.take(1).foreach((Function1 & Serializable)x0$1 -> {
                        LeafletMapExporter.$anonfun$close$2(this, max, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    iter.foreach((Function1 & Serializable)x0$2 -> {
                        LeafletMapExporter.$anonfun$close$3(this, max, x0$2);
                        return BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.writer().write("\n    ], { radius: 25 });\n\n");
                this.writer().write(LeafletMapExporter$.MODULE$.org$locationtech$geomesa$features$exporters$LeafletMapExporter$$IndexTail());
            }
            finally {
                this.jsonWriter().close();
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$export$1(LeafletMapExporter $this, Coordinate c) {
        $this.coordMap().update((Object)c, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)$this.coordMap().apply((Object)c)) + 1)));
    }

    public static final /* synthetic */ void $anonfun$close$2(LeafletMapExporter $this, int max$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Coordinate coord = (Coordinate)tuple2._1();
            int weight = tuple2._2$mcI$sp();
            $this.writer().write(new StringBuilder(14).append("        [").append(coord.y).append(", ").append(coord.x).append(", ").append(weight / max$1).append("]").toString());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$close$3(LeafletMapExporter $this, int max$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Coordinate coord = (Coordinate)tuple2._1();
            int weight = tuple2._2$mcI$sp();
            $this.writer().write(new StringBuilder(16).append(",\n        [").append(coord.y).append(", ").append(coord.x).append(", ").append(weight / max$1).append("]").toString());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public LeafletMapExporter(OutputStream out) {
        this.out = out;
        LazyLogging.$init$((LazyLogging)this);
        this.coordMap = ((Map)Map$.MODULE$.empty()).withDefaultValue((Object)BoxesRunTime.boxToInteger((int)0));
        this.featureInfo = "";
    }
}

