/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.exporters;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.util.URLs;
import org.locationtech.geomesa.features.exporters.FeatureExporter;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.jts.geom.Geometry;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0005\u0005ua\u0001B\b\u0011\u0001mA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\u0006_\u0001!\t\u0001\r\u0005\bg\u0001\u0011\r\u0011\"\u00035\u0011\u0019Y\u0004\u0001)A\u0005k!IA\b\u0001a\u0001\u0002\u0004%I!\u0010\u0005\n\u0011\u0002\u0001\r\u00111A\u0005\n%C\u0011B\u0015\u0001A\u0002\u0003\u0005\u000b\u0015\u0002 \t\u0013M\u0003\u0001\u0019!a\u0001\n\u0013!\u0006\"C2\u0001\u0001\u0004\u0005\r\u0011\"\u0003e\u0011%1\u0007\u00011A\u0001B\u0003&Q\u000bC\u0003h\u0001\u0011\u0005\u0003\u000eC\u0003v\u0001\u0011\u0005c\u000fC\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005e\u0001\u0001\"\u0011\u0002\u001c\t\t2\u000b[1qK\u001aLG.Z#ya>\u0014H/\u001a:\u000b\u0005E\u0011\u0012!C3ya>\u0014H/\u001a:t\u0015\t\u0019B#\u0001\u0005gK\u0006$XO]3t\u0015\t)b#A\u0004hK>lWm]1\u000b\u0005]A\u0012\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001aB\u0005\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005!A.\u00198h\u0015\u0005\t\u0013\u0001\u00026bm\u0006L!a\t\u0010\u0003\r=\u0013'.Z2u!\t)c%D\u0001\u0011\u0013\t9\u0003CA\bGK\u0006$XO]3FqB|'\u000f^3s\u0003\u00111\u0017\u000e\\3\u0011\u0005)jS\"A\u0016\u000b\u00051\u0002\u0013AA5p\u0013\tq3F\u0001\u0003GS2,\u0017A\u0002\u001fj]&$h\b\u0006\u00022eA\u0011Q\u0005\u0001\u0005\u0006Q\t\u0001\r!K\u0001\u0004kJdW#A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0005a\u0002\u0013a\u00018fi&\u0011!h\u000e\u0002\u0004+Jc\u0015\u0001B;sY\u0002\n!\u0001Z:\u0016\u0003y\u0002\"a\u0010$\u000e\u0003\u0001S!!\u0011\"\u0002\u0013MD\u0017\r]3gS2,'BA\"E\u0003\u0011!\u0017\r^1\u000b\u0005\u0015C\u0012\u0001C4f_R|w\u000e\\:\n\u0005\u001d\u0003%AE*iCB,g-\u001b7f\t\u0006$\u0018m\u0015;pe\u0016\fa\u0001Z:`I\u0015\fHC\u0001&Q!\tYe*D\u0001M\u0015\u0005i\u0015!B:dC2\f\u0017BA(M\u0005\u0011)f.\u001b;\t\u000fE3\u0011\u0011!a\u0001}\u0005\u0019\u0001\u0010J\u0019\u0002\u0007\u0011\u001c\b%\u0001\u0005nCB\u0004\u0018N\\4t+\u0005)\u0006\u0003\u0002,^A\u0002t!aV.\u0011\u0005acU\"A-\u000b\u0005iS\u0012A\u0002\u001fs_>$h(\u0003\u0002]\u0019\u00061\u0001K]3eK\u001aL!AX0\u0003\u00075\u000b\u0007O\u0003\u0002]\u0019B\u00111*Y\u0005\u0003E2\u00131!\u00138u\u00031i\u0017\r\u001d9j]\u001e\u001cx\fJ3r)\tQU\rC\u0004R\u0013\u0005\u0005\t\u0019A+\u0002\u00135\f\u0007\u000f]5oON\u0004\u0013!B:uCJ$HC\u0001&j\u0011\u0015Q7\u00021\u0001l\u0003\r\u0019h\r\u001e\t\u0003YNl\u0011!\u001c\u0006\u0003]>\faa]5na2,'B\u00019r\u0003\u001d1W-\u0019;ve\u0016T!A\u001d#\u0002\u0007\u0005\u0004\u0018.\u0003\u0002u[\n\t2+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3\u0002\r\u0015D\bo\u001c:u)\t9X\u0010E\u0002LqjL!!\u001f'\u0003\r=\u0003H/[8o!\tY50\u0003\u0002}\u0019\n!Aj\u001c8h\u0011\u0015\u0019B\u00021\u0001\u007f!\u0015y\u0018\u0011BA\b\u001d\u0011\t\t!!\u0002\u000f\u0007a\u000b\u0019!C\u0001N\u0013\r\t9\u0001T\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY!!\u0004\u0003\u0011%#XM]1u_JT1!a\u0002M!\ra\u0017\u0011C\u0005\u0004\u0003'i'!D*j[BdWMR3biV\u0014X-A\u0003csR,7/F\u0001{\u0003\u0015\u0019Gn\\:f)\u0005Q\u0005")
public class ShapefileExporter
implements FeatureExporter {
    private final File file;
    private final URL url;
    private ShapefileDataStore ds;
    private Map<Object, Object> mappings;

    private URL url() {
        return this.url;
    }

    private ShapefileDataStore ds() {
        return this.ds;
    }

    private void ds_$eq(ShapefileDataStore x$1) {
        this.ds = x$1;
    }

    private Map<Object, Object> mappings() {
        return this.mappings;
    }

    private void mappings_$eq(Map<Object, Object> x$1) {
        this.mappings = x$1;
    }

    @Override
    public void start(SimpleFeatureType sft) {
        Option$.MODULE$.apply((Object)this.file.getParentFile()).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.exists())).foreach((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.mkdirs()));
        this.ds_$eq((ShapefileDataStore)new ShapefileDataStoreFactory().createDataStore(this.url()));
        this.ds().createSchema(sft);
        IntRef i = IntRef.create((int)-1);
        IntRef j = IntRef.create((int)0);
        Buffer attributes = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).flatMap((Function1 & Serializable)d -> {
            block3: {
                block2: {
                    ++i$1.elem;
                    Class binding = d.getType().getBinding();
                    if (Geometry.class.isAssignableFrom(binding)) break block2;
                    Class clazz = binding;
                    Class<byte[]> clazz2 = byte[].class;
                    if (clazz != null ? !clazz.equals(clazz2) : clazz2 != null) break block3;
                }
                return None$.MODULE$;
            }
            ++j$1.elem;
            return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i$1.elem)), (Object)BoxesRunTime.boxToInteger((int)j$1.elem)));
        });
        this.mappings_$eq((Map<Object, Object>)((Map)attributes.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)sft.indexOf(sft.getGeometryDescriptor().getLocalName()))), (Object)BoxesRunTime.boxToInteger((int)0)))));
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        LongRef count = LongRef.create((long)0L);
        package.WithClose$.MODULE$.apply((Object)this.ds().getFeatureWriterAppend(Transaction.AUTO_COMMIT), (Function1 & Serializable)writer -> {
            features.foreach((Function1 & Serializable)feature -> {
                ShapefileExporter.$anonfun$export$2($this, writer, count$1, feature);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
        return new Some((Object)BoxesRunTime.boxToLong((long)count.elem));
    }

    public long bytes() {
        long l;
        ShpFiles files = new ShpFiles(this.url());
        try {
            LongRef sum = LongRef.create((long)0L);
            ((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(files.getFileNames()).asScala()).values().foreach((Function1 & Serializable)file -> {
                ShapefileExporter.$anonfun$bytes$1(sum, file);
                return BoxedUnit.UNIT;
            });
            l = sum.elem;
        }
        finally {
            files.dispose();
        }
        return l;
    }

    @Override
    public void close() {
        Option$.MODULE$.apply((Object)this.ds()).foreach((Function1 & Serializable)x$5 -> {
            x$5.dispose();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$export$3(SimpleFeature toWrite$1, SimpleFeature feature$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int from = tuple2._1$mcI$sp();
            int to = tuple2._2$mcI$sp();
            toWrite$1.setAttribute(to, feature$1.getAttribute(from));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$export$2(ShapefileExporter $this, FeatureWriter writer$1, LongRef count$1, SimpleFeature feature) {
        SimpleFeature toWrite = (SimpleFeature)writer$1.next();
        $this.mappings().foreach((Function1 & Serializable)x0$1 -> {
            ShapefileExporter.$anonfun$export$3(toWrite, feature, x0$1);
            return BoxedUnit.UNIT;
        });
        toWrite.getUserData().putAll(feature.getUserData());
        writer$1.write();
        ++count$1.elem;
    }

    public static final /* synthetic */ void $anonfun$bytes$1(LongRef sum$1, String file) {
        sum$1.elem += URLs.urlToFile((URL)new URL(file)).length();
    }

    public ShapefileExporter(File file) {
        this.file = file;
        this.url = URLs.fileToUrl((File)file);
    }
}

