/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.kryo.impl;

import com.esotericsoftware.kryo.io.Input;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.features.kryo.impl.ActiveDeserialization;
import org.locationtech.geomesa.features.kryo.impl.KryoFeatureDeserialization$;
import org.locationtech.geomesa.features.kryo.package;
import org.locationtech.geomesa.features.kryo.package$Metadata$;
import org.locationtech.geomesa.features.kryo.serialization.KryoUserDataSerialization$;
import org.opengis.feature.simple.SimpleFeature;
import scala.Array$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public abstract class ActiveDeserialization$class {
    public static SimpleFeature deserialize(ActiveDeserialization $this, byte[] bytes) {
        return ActiveDeserialization$class.readFeature($this, "", KryoFeatureDeserialization$.MODULE$.getInput(bytes, 0, bytes.length));
    }

    public static SimpleFeature deserialize(ActiveDeserialization $this, String id, byte[] bytes) {
        return ActiveDeserialization$class.readFeature($this, id, KryoFeatureDeserialization$.MODULE$.getInput(bytes, 0, bytes.length));
    }

    public static SimpleFeature deserialize(ActiveDeserialization $this, byte[] bytes, int offset, int length) {
        return ActiveDeserialization$class.readFeature($this, "", KryoFeatureDeserialization$.MODULE$.getInput(bytes, offset, length));
    }

    public static SimpleFeature deserialize(ActiveDeserialization $this, String id, byte[] bytes, int offset, int length) {
        return ActiveDeserialization$class.readFeature($this, id, KryoFeatureDeserialization$.MODULE$.getInput(bytes, offset, length));
    }

    public static SimpleFeature deserialize(ActiveDeserialization $this, InputStream in) {
        return ActiveDeserialization$class.readFeature($this, "", KryoFeatureDeserialization$.MODULE$.getInput(in));
    }

    public static SimpleFeature deserialize(ActiveDeserialization $this, String id, InputStream in) {
        return ActiveDeserialization$class.readFeature($this, id, KryoFeatureDeserialization$.MODULE$.getInput(in));
    }

    private static SimpleFeature readFeature(ActiveDeserialization $this, String id, Input input) {
        byte by;
        block4: {
            SimpleFeature simpleFeature;
            block3: {
                block2: {
                    by = input.readByte();
                    if (KryoFeatureSerializer$.MODULE$.Version3() != by) break block2;
                    simpleFeature = ActiveDeserialization$class.readFeatureV3($this, id, input);
                    break block3;
                }
                if (KryoFeatureSerializer$.MODULE$.Version2() != by) break block4;
                simpleFeature = ActiveDeserialization$class.readFeatureV2($this, id, input);
            }
            return simpleFeature;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't process features serialized with version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)by)})));
    }

    private static SimpleFeature readFeatureV3(ActiveDeserialization $this, String id, Input input) {
        package.Metadata metadata = package$Metadata$.MODULE$.apply(input);
        String finalId = $this.withoutId() ? id : input.readString();
        Object[] attributes = (Object[])Array$.MODULE$.ofDim($this.out().getAttributeCount(), ClassTag$.MODULE$.AnyRef());
        for (int i = 0; i < metadata.count(); ++i) {
            if (metadata.nulls().contains(i)) continue;
            attributes[i] = $this.readers()[i].apply(input);
        }
        HashMap<Object, Object> userData = $this.withoutUserData() ? new HashMap(1) : KryoUserDataSerialization$.MODULE$.deserialize(input);
        return $this.createFeature(finalId, attributes, userData);
    }

    private static SimpleFeature readFeatureV2(ActiveDeserialization $this, String id, Input input) {
        Map<Object, Object> map;
        int i;
        int offset = input.position() - 1;
        int limit = offset + input.readInt();
        String finalId = $this.withoutId() ? id : input.readString();
        Object[] attributes = (Object[])Array$.MODULE$.ofDim($this.readersV2().length, ClassTag$.MODULE$.AnyRef());
        for (i = 0; i < $this.readersV2().length && input.position() < limit; ++i) {
            attributes[i] = $this.readersV2()[i].apply((Object)input);
        }
        if ($this.withoutUserData()) {
            map = new HashMap<Object, Object>();
        } else {
            try {
                for (i = 0; i < $this.readersV2().length; ++i) {
                    input.readInt(true);
                }
                map = KryoUserDataSerialization$.MODULE$.deserialize(input);
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                if ($this.logger().underlying().isErrorEnabled()) {
                    $this.logger().underlying().error("Error reading serialized kryo user data:", e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                HashMap hashMap = new HashMap();
                map = hashMap;
            }
        }
        HashMap<Object, Object> userData = map;
        return $this.createFeature(finalId, attributes, userData);
    }

    public static void $init$(ActiveDeserialization $this) {
    }
}

