/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.kryo.serialization;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.features.kryo.serialization.KryoGeometrySerialization$;
import org.locationtech.geomesa.features.serialization.HintKeySerialization$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map$;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.SortedSet$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class KryoUserDataSerialization$
implements LazyLogging {
    public static final KryoUserDataSerialization$ MODULE$;
    private final String org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$nullMapping;
    private final scala.collection.immutable.Map<Class<?>, String> org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$baseClassMappings;
    private final scala.collection.immutable.Map<String, Class<?>> baseClassLookups;
    private final Ordering<Tuple2<Object, Object>> ordering;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new KryoUserDataSerialization$();
    }

    private Logger logger$lzycompute() {
        KryoUserDataSerialization$ kryoUserDataSerialization$ = this;
        synchronized (kryoUserDataSerialization$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$nullMapping() {
        return this.org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$nullMapping;
    }

    public scala.collection.immutable.Map<Class<?>, String> org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$baseClassMappings() {
        return this.org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$baseClassMappings;
    }

    private scala.collection.immutable.Map<String, Class<?>> baseClassLookups() {
        return this.baseClassLookups;
    }

    private Ordering<Tuple2<Object, Object>> ordering() {
        return this.ordering;
    }

    public void serialize(Output out, Map<?, ?> javaMap) {
        SortedSet toWrite = SortedSet$.MODULE$.empty(this.ordering());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(javaMap).asScala()).foreach((Function1)new Serializable(toWrite){
            public static final long serialVersionUID = 0L;
            private final SortedSet toWrite$1;

            public final Object apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    if (k == null || k instanceof Hints.Key) {
                        if (KryoUserDataSerialization$.MODULE$.logger().underlying().isWarnEnabled()) {
                            KryoUserDataSerialization$.MODULE$.logger().underlying().warn("Skipping serialization of entry: {} -> {}", new Object[]{k, v});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = this.toWrite$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), v));
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return boxedUnit2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.toWrite$1 = toWrite$1;
            }
        });
        out.writeInt(toWrite.size());
        toWrite.foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final Output out$1;

            public final void apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    Object key = tuple2._1();
                    Object value = tuple2._2();
                    this.out$1.writeString((String)KryoUserDataSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$baseClassMappings().getOrElse(key.getClass(), (Function0)new Serializable(this, key){
                        public static final long serialVersionUID = 0L;
                        private final Object key$1;

                        public final String apply() {
                            return this.key$1.getClass().getName();
                        }
                        {
                            this.key$1 = key$1;
                        }
                    }));
                    KryoUserDataSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$write(this.out$1, key);
                    if (value == null) {
                        this.out$1.writeString(KryoUserDataSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$nullMapping());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.out$1.writeString((String)KryoUserDataSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$baseClassMappings().getOrElse(value.getClass(), (Function0)new Serializable(this, value){
                            public static final long serialVersionUID = 0L;
                            private final Object value$1;

                            public final String apply() {
                                return this.value$1.getClass().getName();
                            }
                            {
                                this.value$1 = value$1;
                            }
                        }));
                        KryoUserDataSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$write(this.out$1, value);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.out$1 = out$1;
            }
        });
    }

    public Map<Object, Object> deserialize(Input in) {
        HashMap<Object, Object> hashMap;
        try {
            int size = in.readInt();
            HashMap<Object, Object> map = new HashMap<Object, Object>(size);
            this.deserializeWithSize(in, map, size);
            hashMap = map;
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Error reading serialized kryo user data:", e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            HashMap hashMap2 = new HashMap();
            hashMap = hashMap2;
        }
        return hashMap;
    }

    public void deserialize(Input in, Map<Object, Object> map) {
        try {
            this.deserializeWithSize(in, map, in.readInt());
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Error reading serialized kryo user data:", e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            new HashMap();
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        }
    }

    private void deserializeWithSize(Input in, Map<Object, Object> map, int size) {
        for (int i = 0; i < size; ++i) {
            String valueClass;
            String keyClass = in.readString();
            Object key = this.read(in, (Class)this.baseClassLookups().getOrElse((Object)keyClass, (Function0)new Serializable(keyClass){
                public static final long serialVersionUID = 0L;
                private final String keyClass$1;

                public final Class<Object> apply() {
                    return Class.forName(this.keyClass$1);
                }
                {
                    this.keyClass$1 = keyClass$1;
                }
            }));
            String string = valueClass = in.readString();
            String string2 = this.org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$nullMapping();
            Object value = !(string != null ? !string.equals(string2) : string2 != null) ? null : this.read(in, (Class)this.baseClassLookups().getOrElse((Object)valueClass, (Function0)new Serializable(valueClass){
                public static final long serialVersionUID = 0L;
                private final String valueClass$1;

                public final Class<Object> apply() {
                    return Class.forName(this.valueClass$1);
                }
                {
                    this.valueClass$1 = valueClass$1;
                }
            }));
            map.put(key, value);
        }
    }

    public void org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$write(Output out, Object value) {
        block13: {
            block3: {
                Object object;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block6: {
                                            block5: {
                                                block4: {
                                                    block2: {
                                                        object = value;
                                                        if (!(object instanceof String)) break block2;
                                                        String string = (String)object;
                                                        out.writeString(string);
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        break block3;
                                                    }
                                                    if (!(object instanceof Integer)) break block4;
                                                    Integer n = (Integer)object;
                                                    out.writeInt(Predef$.MODULE$.Integer2int(n));
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block3;
                                                }
                                                if (!(object instanceof Long)) break block5;
                                                Long l = (Long)object;
                                                out.writeLong(Predef$.MODULE$.Long2long(l));
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block3;
                                            }
                                            if (!(object instanceof Float)) break block6;
                                            Float f = (Float)object;
                                            out.writeFloat(Predef$.MODULE$.Float2float(f));
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        if (!(object instanceof Double)) break block7;
                                        Double d = (Double)object;
                                        out.writeDouble(Predef$.MODULE$.Double2double(d));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    if (!(object instanceof Boolean)) break block8;
                                    Boolean bl = (Boolean)object;
                                    out.writeBoolean(Predef$.MODULE$.Boolean2boolean(bl));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!(object instanceof Date)) break block9;
                                Date date = (Date)object;
                                out.writeLong(date.getTime());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!(object instanceof byte[])) break block10;
                            byte[] byArray = (byte[])object;
                            this.writeBytes(out, byArray);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(object instanceof Geometry)) break block11;
                        Geometry geometry = (Geometry)object;
                        KryoGeometrySerialization$.MODULE$.serializeWkb(out, geometry);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(object instanceof UUID)) break block12;
                    UUID uUID = (UUID)object;
                    out.writeLong(uUID.getMostSignificantBits());
                    out.writeLong(uUID.getLeastSignificantBits());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(object instanceof List)) break block13;
                List list = (List)object;
                this.writeList(out, list);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported value: ", " (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value, value.getClass()})));
    }

    private Object read(Input in, Class<?> clas) {
        block14: {
            Object object;
            block3: {
                Class<?> clazz;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            clazz = clas;
                                                            if (!String.class.isAssignableFrom(clazz)) break block2;
                                                            object = in.readString().intern();
                                                            break block3;
                                                        }
                                                        if (!Integer.class.isAssignableFrom(clazz)) break block4;
                                                        object = BoxesRunTime.boxToInteger((int)in.readInt());
                                                        break block3;
                                                    }
                                                    if (!Long.class.isAssignableFrom(clazz)) break block5;
                                                    object = BoxesRunTime.boxToLong((long)in.readLong());
                                                    break block3;
                                                }
                                                if (!Float.class.isAssignableFrom(clazz)) break block6;
                                                object = BoxesRunTime.boxToFloat((float)in.readFloat());
                                                break block3;
                                            }
                                            if (!Double.class.isAssignableFrom(clazz)) break block7;
                                            object = BoxesRunTime.boxToDouble((double)in.readDouble());
                                            break block3;
                                        }
                                        if (!Boolean.class.isAssignableFrom(clazz)) break block8;
                                        object = BoxesRunTime.boxToBoolean((boolean)in.readBoolean());
                                        break block3;
                                    }
                                    if (!Date.class.isAssignableFrom(clazz)) break block9;
                                    object = new Date(in.readLong());
                                    break block3;
                                }
                                if (!byte[].class.equals(clazz)) break block10;
                                object = this.readBytes(in);
                                break block3;
                            }
                            if (!Geometry.class.isAssignableFrom(clazz)) break block11;
                            object = KryoGeometrySerialization$.MODULE$.deserializeWkb(in, true);
                            break block3;
                        }
                        if (!UUID.class.isAssignableFrom(clazz)) break block12;
                        object = new UUID(in.readLong(), in.readLong());
                        break block3;
                    }
                    if (!List.class.isAssignableFrom(clazz)) break block13;
                    object = this.readList(in);
                    break block3;
                }
                if (!Hints.Key.class.isAssignableFrom(clazz)) break block14;
                object = HintKeySerialization$.MODULE$.idToKey().apply((Object)in.readString());
            }
            return object;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported value class: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clas})));
    }

    private void writeBytes(Output out, byte[] bytes) {
        out.writeInt(bytes.length);
        out.writeBytes(bytes);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] readBytes(Input in) {
        void var2_2;
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(in.readInt(), ClassTag$.MODULE$.Byte());
        in.readBytes(bytes);
        return var2_2;
    }

    private void writeList(Output out, List<Object> list) {
        out.writeInt(list.size());
        for (Object value : list) {
            if (value == null) {
                out.writeString(this.org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$nullMapping());
                continue;
            }
            out.writeString((String)this.org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$baseClassMappings().getOrElse(value.getClass(), (Function0)new Serializable(value){
                public static final long serialVersionUID = 0L;
                private final Object value$2;

                public final String apply() {
                    return this.value$2.getClass().getName();
                }
                {
                    this.value$2 = value$2;
                }
            }));
            this.org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$write(out, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<Object> readList(Input in) {
        void var3_3;
        int size = in.readInt();
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            String clas;
            String string = clas = in.readString();
            String string2 = this.org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$nullMapping();
            boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? list.add(null) : list.add(this.read(in, (Class)this.baseClassLookups().getOrElse((Object)clas, (Function0)new Serializable(clas){
                public static final long serialVersionUID = 0L;
                private final String clas$1;

                public final Class<Object> apply() {
                    return Class.forName(this.clas$1);
                }
                {
                    this.clas$1 = clas$1;
                }
            })));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private KryoUserDataSerialization$() {
        void var2_2;
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$nullMapping = "$_";
        this.org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$baseClassMappings = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(String.class), (Object)"$s"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Integer.TYPE), (Object)"$i"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Integer.class), (Object)"$i"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Long.TYPE), (Object)"$l"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Long.class), (Object)"$l"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Float.TYPE), (Object)"$f"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Float.class), (Object)"$f"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Double.TYPE), (Object)"$d"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Double.class), (Object)"$d"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Boolean.TYPE), (Object)"$b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Boolean.class), (Object)"$b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Date.class), (Object)"$D"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(byte[].class), (Object)"$B"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(UUID.class), (Object)"$u"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Point.class), (Object)"$pt"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(LineString.class), (Object)"$ls"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Polygon.class), (Object)"$pl"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Hints.Key.class), (Object)"$h")}));
        scala.collection.immutable.Map m1 = (scala.collection.immutable.Map)this.org$locationtech$geomesa$features$kryo$serialization$KryoUserDataSerialization$$baseClassMappings().filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Class<?>, String> x$1) {
                return ((Class)x$1._1()).isPrimitive();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Class<?>> apply(Tuple2<Class<?>, String> x$2) {
                return x$2.swap();
            }
        }, Map$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map m2 = m1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.geotools.factory.Hints$Key"), Hints.Key.class));
        this.baseClassLookups = var2_2;
        this.ordering = package$.MODULE$.Ordering().by((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<Object, Object> x$3) {
                return x$3._1().toString();
            }
        }, (Ordering)Ordering.String$.MODULE$);
    }
}

