/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.kryo.json;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.native.JsonMethods$;
import org.json4s.package$;
import org.locationtech.geomesa.features.kryo.json.JsonPathParser;
import org.locationtech.geomesa.features.kryo.json.JsonPathParser$JsonPathFunction$;
import org.locationtech.geomesa.features.kryo.json.JsonPathParser$PathAttributeWildCard$;
import org.locationtech.geomesa.features.kryo.json.JsonPathParser$PathDeepScan$;
import org.locationtech.geomesa.features.kryo.json.JsonPathParser$PathIndexWildCard$;
import org.locationtech.geomesa.features.kryo.json.KryoJsonSerialization;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public final class KryoJsonSerialization$
implements LazyLogging {
    public static KryoJsonSerialization$ MODULE$;
    private final byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$TerminalByte;
    private final byte DoubleByte;
    private final byte StringByte;
    private final byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte;
    private final byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte;
    private final byte BooleanByte;
    private final byte NullByte;
    private final byte IntByte;
    private final byte LongByte;
    private final byte BooleanFalse;
    private final byte BooleanTrue;
    private final byte NonDoc;
    private final ThreadLocal<byte[]> org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$nameBuffers;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new KryoJsonSerialization$();
    }

    private Logger logger$lzycompute() {
        KryoJsonSerialization$ kryoJsonSerialization$ = this;
        synchronized (kryoJsonSerialization$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$TerminalByte() {
        return this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$TerminalByte;
    }

    private byte DoubleByte() {
        return this.DoubleByte;
    }

    private byte StringByte() {
        return this.StringByte;
    }

    public byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte() {
        return this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte;
    }

    public byte org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte() {
        return this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte;
    }

    private byte BooleanByte() {
        return this.BooleanByte;
    }

    private byte NullByte() {
        return this.NullByte;
    }

    private byte IntByte() {
        return this.IntByte;
    }

    private byte LongByte() {
        return this.LongByte;
    }

    private byte BooleanFalse() {
        return this.BooleanFalse;
    }

    private byte BooleanTrue() {
        return this.BooleanTrue;
    }

    private byte NonDoc() {
        return this.NonDoc;
    }

    public ThreadLocal<byte[]> org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$nameBuffers() {
        return this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$nameBuffers;
    }

    public void serialize(Output out, String json) {
        JsonAST.JValue jValue;
        if (json == null) {
            jValue = null;
        } else {
            try {
                jValue = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable e = (Throwable)option.get();
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringBuilder(20).append("Error parsing json:\n").append(json).toString(), e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw throwable;
                }
                Object var3_7 = null;
                jValue = var3_7;
            }
        }
        JsonAST.JValue obj = jValue;
        this.serialize(out, obj);
    }

    public void serialize(Output out, JsonAST.JValue json) {
        JsonAST.JValue jValue = json;
        boolean bl = jValue == null ? true : JsonAST.JNull$.MODULE$.equals(jValue);
        if (bl) {
            out.write((int)this.BooleanFalse());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jValue instanceof JsonAST.JObject) {
            JsonAST.JObject jObject = (JsonAST.JObject)jValue;
            out.write((int)this.BooleanTrue());
            this.writeDocument(out, jObject);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            out.write((int)this.NonDoc());
            this.writeValue(out, "", jValue);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public String deserializeAndRender(Input in) {
        String string;
        JsonAST.JValue json = this.deserialize(in);
        if (json == null) {
            string = null;
        } else {
            JsonAST.JValue x$1 = json;
            Formats x$2 = JsonMethods$.MODULE$.render$default$2(x$1);
            string = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$1, x$2));
        }
        return string;
    }

    public JsonAST.JValue deserialize(Input in) {
        JsonAST.JObject jObject;
        try {
            JsonAST.JObject jObject2;
            byte by = in.readByte();
            if (this.BooleanFalse() == by) {
                jObject2 = null;
            } else if (this.BooleanTrue() == by) {
                jObject2 = this.readDocument(in);
            } else if (this.NonDoc() == by) {
                jObject2 = (JsonAST.JValue)this.readValue(in)._2();
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
            jObject = jObject2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Error reading serialized kryo json", e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            Object var2_8 = null;
            jObject = var2_8;
        }
        return jObject;
    }

    public Object deserialize(Input in, Seq<JsonPathParser.PathElement> path) {
        Object object;
        block28: {
            if (path.isEmpty()) {
                object = this.deserializeAndRender(in);
            } else {
                try {
                    Seq seq;
                    Seq<Tuple2<Object, Object>> seq2;
                    byte by = in.readByte();
                    if (this.BooleanTrue() == by) {
                        seq2 = (Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte()), (Object)BoxesRunTime.boxToInteger((int)in.position())), (List)Nil$.MODULE$);
                    } else if (this.BooleanFalse() == by) {
                        seq2 = (Seq<Tuple2<Object, Object>>)Nil$.MODULE$;
                    } else if (this.NonDoc() == by) {
                        byte by2 = in.readByte();
                        this.RichInput(in).readName();
                        seq2 = (Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)by2), (Object)BoxesRunTime.boxToInteger((int)in.position())), (List)Nil$.MODULE$);
                    } else {
                        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
                    }
                    Seq<Tuple2<Object, Object>> matches = seq2;
                    None$ function = None$.MODULE$;
                    Iterator paths = path.iterator();
                    while (paths.hasNext() && matches.nonEmpty()) {
                        JsonPathParser.PathIndices pathIndices;
                        Seq<Object> indices;
                        BoxedUnit boxedUnit;
                        JsonPathParser.PathAttribute pathAttribute;
                        String name;
                        JsonPathParser.PathElement pathElement = (JsonPathParser.PathElement)paths.next();
                        if (pathElement instanceof JsonPathParser.PathAttribute && (name = (pathAttribute = (JsonPathParser.PathAttribute)pathElement).name()) != null) {
                            String string = name;
                            matches = this.matchPathAttribute(in, matches, (Option<String>)new Some((Object)string));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (JsonPathParser$PathAttributeWildCard$.MODULE$.equals(pathElement)) {
                            matches = this.matchPathAttribute(in, matches, (Option<String>)None$.MODULE$);
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (pathElement instanceof JsonPathParser.PathIndex) {
                            int index;
                            JsonPathParser.PathIndex pathIndex = (JsonPathParser.PathIndex)pathElement;
                            int n = index = pathIndex.index();
                            matches = this.matchPathIndex(in, matches, (Option<Seq<Object>>)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{n}))));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (pathElement instanceof JsonPathParser.PathIndices && (indices = (pathIndices = (JsonPathParser.PathIndices)pathElement).indices()) != null) {
                            Seq<Object> seq3 = indices;
                            matches = this.matchPathIndex(in, matches, (Option<Seq<Object>>)new Some(seq3));
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (JsonPathParser$PathIndexWildCard$.MODULE$.equals(pathElement)) {
                            matches = this.matchPathIndex(in, matches, (Option<Seq<Object>>)None$.MODULE$);
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (JsonPathParser$PathDeepScan$.MODULE$.equals(pathElement)) {
                            matches = this.matchDeep(in, matches);
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (pathElement instanceof JsonPathParser.PathFunction) {
                            JsonPathParser.PathFunction pathFunction = (JsonPathParser.PathFunction)pathElement;
                            Enumeration.Value f = pathFunction.function();
                            function = new Some((Object)f);
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        throw new MatchError((Object)pathElement);
                    }
                    Seq values = (Seq)matches.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        byte t = BoxesRunTime.unboxToByte((Object)tuple2._1());
                        int p = tuple2._2$mcI$sp();
                        Object object = MODULE$.readPathValue(in, t, p);
                        return object;
                    }, Seq$.MODULE$.canBuildFrom());
                    None$ none$ = function;
                    if (None$.MODULE$.equals(none$)) {
                        seq = values;
                    } else if (none$ instanceof Some) {
                        Some some = (Some)none$;
                        Enumeration.Value f = (Enumeration.Value)some.value();
                        seq = (Seq)values.map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.applyPathFunction(f, x$1), Seq$.MODULE$.canBuildFrom());
                    } else {
                        throw new MatchError((Object)none$);
                    }
                    Seq mapped = seq;
                    if (mapped.isEmpty()) {
                        object = null;
                        break block28;
                    }
                    if (values.length() == 1) {
                        object = mapped.head();
                        break block28;
                    }
                    object = mapped;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        BoxedUnit boxedUnit;
                        Throwable e = (Throwable)option.get();
                        if (this.logger().underlying().isErrorEnabled()) {
                            this.logger().underlying().error("Error reading serialized kryo json", e);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        throw throwable;
                    }
                    Object var3_32 = null;
                    object = var3_32;
                }
            }
        }
        return object;
    }

    private void writeDocument(Output out, String name, JsonAST.JObject value) {
        out.writeByte(this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte());
        this.RichOutput(out).writeName(name);
        this.writeDocument(out, value);
    }

    private void writeDocument(Output out, JsonAST.JObject value) {
        int start = out.position();
        out.writeInt(0);
        value.obj().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KryoJsonSerialization$.$anonfun$writeDocument$1(out, x0$1);
            return BoxedUnit.UNIT;
        });
        out.writeByte(this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$TerminalByte());
        int end = out.position();
        out.setPosition(start);
        out.writeInt(end - start);
        out.setPosition(end);
    }

    private void writeValue(Output out, String name, JsonAST.JValue value) {
        JsonAST.JValue jValue = value;
        if (jValue instanceof JsonAST.JString) {
            JsonAST.JString jString = (JsonAST.JString)jValue;
            this.writeString(out, name, jString);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jValue instanceof JsonAST.JObject) {
            JsonAST.JObject jObject = (JsonAST.JObject)jValue;
            this.writeDocument(out, name, jObject);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jValue instanceof JsonAST.JArray) {
            JsonAST.JArray jArray = (JsonAST.JArray)jValue;
            this.writeArray(out, name, jArray);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jValue instanceof JsonAST.JDouble) {
            JsonAST.JDouble jDouble = (JsonAST.JDouble)jValue;
            this.writeDouble(out, name, jDouble);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jValue instanceof JsonAST.JInt) {
            JsonAST.JInt jInt = (JsonAST.JInt)jValue;
            this.writeInt(out, name, jInt);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (JsonAST.JNull$.MODULE$.equals(jValue)) {
            this.writeNull(out, name);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jValue instanceof JsonAST.JBool) {
            JsonAST.JBool jBool = (JsonAST.JBool)jValue;
            this.writeBoolean(out, name, jBool);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jValue instanceof JsonAST.JDecimal) {
            JsonAST.JDecimal jDecimal = (JsonAST.JDecimal)jValue;
            this.writeDecimal(out, name, jDecimal);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)jValue);
        }
    }

    private void writeArray(Output out, String name, JsonAST.JArray value) {
        out.writeByte(this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte());
        this.RichOutput(out).writeName(name);
        IntRef i = IntRef.create((int)-1);
        List withKeys = (List)value.arr().map((Function1 & Serializable & scala.Serializable)element -> {
            ++i$1.elem;
            return new Tuple2((Object)Integer.toString(i$1.elem), element);
        }, List$.MODULE$.canBuildFrom());
        this.writeDocument(out, new JsonAST.JObject(withKeys));
    }

    private void writeString(Output out, String name, JsonAST.JString value) {
        out.writeByte(this.StringByte());
        this.RichOutput(out).writeName(name);
        byte[] bytes = value.values().getBytes(StandardCharsets.UTF_8);
        out.writeInt(bytes.length);
        out.write(bytes);
        out.writeByte(this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$TerminalByte());
    }

    private void writeDecimal(Output out, String name, JsonAST.JDecimal value) {
        out.writeByte(this.DoubleByte());
        this.RichOutput(out).writeName(name);
        out.writeDouble(value.values().toDouble());
    }

    private void writeDouble(Output out, String name, JsonAST.JDouble value) {
        out.writeByte(this.DoubleByte());
        this.RichOutput(out).writeName(name);
        out.writeDouble(value.values());
    }

    private void writeInt(Output out, String name, JsonAST.JInt value) {
        BoxedUnit boxedUnit;
        if (value.values().isValidInt()) {
            out.writeByte(this.IntByte());
            this.RichOutput(out).writeName(name);
            out.writeInt(value.values().intValue());
        } else if (value.values().isValidLong()) {
            out.writeByte(this.LongByte());
            this.RichOutput(out).writeName(name);
            out.writeLong(value.values().longValue());
        } else if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Skipping int value that does not fit in a long: {}", new Object[]{value});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void writeBoolean(Output out, String name, JsonAST.JBool v) {
        out.writeByte(this.BooleanByte());
        this.RichOutput(out).writeName(name);
        out.writeByte(v.values() ? this.BooleanTrue() : this.BooleanFalse());
    }

    private void writeNull(Output out, String name) {
        out.writeByte(this.NullByte());
        this.RichOutput(out).writeName(name);
    }

    private JsonAST.JObject readDocument(Input in) {
        int end = in.position() + in.readInt() - 1;
        ArrayBuffer elements = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (in.position() < end) {
            elements.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.readValue(in)}));
        }
        in.skip(1);
        return new JsonAST.JObject(elements.toList());
    }

    private Tuple2<String, JsonAST.JValue> readValue(Input in) {
        JsonAST.JString jString;
        byte by = in.readByte();
        String name = this.RichInput(in).readName();
        byte by2 = by;
        if (this.StringByte() == by2) {
            jString = new JsonAST.JString(this.readString(in));
        } else if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte() == by2) {
            jString = this.readDocument(in);
        } else if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte() == by2) {
            jString = this.readArray(in);
        } else if (this.DoubleByte() == by2) {
            jString = new JsonAST.JDouble(in.readDouble());
        } else if (this.IntByte() == by2) {
            jString = new JsonAST.JInt(BigInt$.MODULE$.int2bigInt(in.readInt()));
        } else if (this.LongByte() == by2) {
            jString = new JsonAST.JInt(BigInt$.MODULE$.long2bigInt(in.readLong()));
        } else if (this.NullByte() == by2) {
            jString = JsonAST.JNull$.MODULE$;
        } else if (this.BooleanByte() == by2) {
            jString = new JsonAST.JBool(this.readBoolean(in));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by2));
        }
        JsonAST.JString value = jString;
        return JsonAST.JField$.MODULE$.apply(name, (JsonAST.JValue)value);
    }

    private JsonAST.JArray readArray(Input in) {
        return new JsonAST.JArray((List)this.readDocument(in).obj().map((Function1 & Serializable & scala.Serializable)x$2 -> (JsonAST.JValue)x$2._2(), List$.MODULE$.canBuildFrom()));
    }

    private void skipDocument(Input in) {
        in.skip(in.readInt() - 4);
    }

    private String readString(Input in) {
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(in.readInt(), ClassTag$.MODULE$.Byte());
        in.read(bytes);
        in.skip(1);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private void skipString(Input in) {
        in.skip(in.readInt() + 1);
    }

    private boolean readBoolean(Input in) {
        return in.readByte() == this.BooleanTrue();
    }

    private void skipBoolean(Input in) {
        in.skip(1);
    }

    private Seq<Tuple2<Object, Object>> matchPathAttribute(Input in, Seq<Tuple2<Object, Object>> positions, Option<String> name) {
        Seq docs = (Seq)positions.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    byte t = BoxesRunTime.unboxToByte((Object)A1._1());
                    int p = A1._2$mcI$sp();
                    if (t == KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte()) {
                        object = BoxesRunTime.boxToInteger((int)p);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                byte t;
                Tuple2<Object, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (t = BoxesRunTime.unboxToByte((Object)tuple2._1())) == KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte();
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        JFunction0.mcZ.sp & Serializable & scala.Serializable predicate = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)name.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KryoJsonSerialization$.$anonfun$matchPathAttribute$2(in, x$3))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            MODULE$.RichInput(in).skipName();
            return true;
        }));
        return this.matchObjectPath(in, (Seq<Object>)docs, (Function0<Object>)predicate);
    }

    private Seq<Tuple2<Object, Object>> matchPathIndex(Input in, Seq<Tuple2<Object, Object>> positions, Option<Seq<Object>> indices) {
        Seq arrays = (Seq)positions.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    byte t = BoxesRunTime.unboxToByte((Object)A1._1());
                    int p = A1._2$mcI$sp();
                    if (t == KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte()) {
                        object = BoxesRunTime.boxToInteger((int)p);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                byte t;
                Tuple2<Object, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (t = BoxesRunTime.unboxToByte((Object)tuple2._1())) == KryoJsonSerialization$.MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte();
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        JFunction0.mcZ.sp & Serializable & scala.Serializable predicate = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)indices.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.contains((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(KryoJsonSerialization$.MODULE$.RichInput(in).readName())).toInt())))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            MODULE$.RichInput(in).skipName();
            return true;
        }));
        return this.matchObjectPath(in, (Seq<Object>)arrays, (Function0<Object>)predicate);
    }

    private Seq<Tuple2<Object, Object>> matchObjectPath(Input in, Seq<Object> positions, Function0<Object> nameConsumingPredicate) {
        ArrayBuffer elements = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        positions.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)position -> {
            in.setPosition(position);
            int end = position + in.readInt() - 1;
            while (in.position() < end) {
                BoxedUnit boxedUnit;
                byte by = in.readByte();
                if (nameConsumingPredicate.apply$mcZ$sp()) {
                    elements.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToByte((byte)by), (Object)BoxesRunTime.boxToInteger((int)in.position()))}));
                }
                byte by2 = by;
                if (MODULE$.StringByte() == by2) {
                    MODULE$.skipString(in);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte() == by2) {
                    MODULE$.skipDocument(in);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (MODULE$.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte() == by2) {
                    MODULE$.skipDocument(in);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (MODULE$.DoubleByte() == by2) {
                    in.skip(8);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (MODULE$.IntByte() == by2) {
                    in.skip(4);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (MODULE$.LongByte() == by2) {
                    in.skip(8);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (MODULE$.NullByte() == by2) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (MODULE$.BooleanByte() == by2) {
                    MODULE$.skipBoolean(in);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by2));
            }
        });
        return elements.toSeq();
    }

    private Seq<Tuple2<Object, Object>> matchDeep(Input in, Seq<Tuple2<Object, Object>> positions) {
        Queue toSearch = (Queue)Queue$.MODULE$.apply(positions);
        ArrayBuffer elements = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (toSearch.nonEmpty()) {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = (Tuple2)toSearch.dequeue();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte typ = BoxesRunTime.unboxToByte((Object)tuple2._1());
            int position = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToByte((byte)typ), (Object)BoxesRunTime.boxToInteger((int)position));
            Tuple2 tuple23 = tuple22;
            byte typ2 = BoxesRunTime.unboxToByte((Object)tuple23._1());
            int position2 = tuple23._2$mcI$sp();
            elements.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToByte((byte)typ2), (Object)BoxesRunTime.boxToInteger((int)position2))}));
            in.setPosition(position2);
            byte by = typ2;
            boolean bl = this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte() == by ? true : this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte() == by;
            if (bl) {
                this.matchObjectPath(in, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{position2}))), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.predicate$1(in)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    KryoJsonSerialization$.$anonfun$matchDeep$2(toSearch, x0$1);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boolean bl2 = this.StringByte() == by ? true : (this.DoubleByte() == by ? true : (this.IntByte() == by ? true : (this.LongByte() == by ? true : (this.NullByte() == by ? true : this.BooleanByte() == by))));
            if (bl2) {
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
        }
        return elements.toSeq();
    }

    private Object readPathValue(Input in, byte typed, int position) {
        Object object;
        in.setPosition(position);
        byte by = typed;
        if (this.StringByte() == by) {
            object = this.readString(in);
        } else if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte() == by) {
            JsonAST.JObject x$1 = this.readDocument(in);
            Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
            object = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2));
        } else if (this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte() == by) {
            object = this.unwrapArray(this.readArray(in));
        } else if (this.DoubleByte() == by) {
            object = BoxesRunTime.boxToDouble((double)in.readDouble());
        } else if (this.IntByte() == by) {
            object = BoxesRunTime.boxToInteger((int)in.readInt());
        } else if (this.LongByte() == by) {
            object = BoxesRunTime.boxToLong((long)in.readLong());
        } else if (this.NullByte() == by) {
            object = null;
        } else if (this.BooleanByte() == by) {
            object = BoxesRunTime.boxToBoolean((boolean)this.readBoolean(in));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
        }
        return object;
    }

    private Seq<Object> unwrapArray(JsonAST.JArray array) {
        return (Seq)array.arr().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            JsonAST.JValue jValue = x0$1;
            if (jValue instanceof JsonAST.JString) {
                Seq<Object> s;
                JsonAST.JString jString = (JsonAST.JString)jValue;
                object = s = jString.s();
            } else if (jValue instanceof JsonAST.JObject) {
                JsonAST.JObject jObject;
                JsonAST.JObject x$1 = jObject = (JsonAST.JObject)jValue;
                Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
                object = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2));
            } else if (jValue instanceof JsonAST.JArray) {
                JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                object = MODULE$.unwrapArray(jArray);
            } else if (jValue instanceof JsonAST.JDouble) {
                JsonAST.JDouble jDouble = (JsonAST.JDouble)jValue;
                double d = jDouble.num();
                object = BoxesRunTime.boxToDouble((double)d);
            } else if (jValue instanceof JsonAST.JInt) {
                JsonAST.JInt jInt = (JsonAST.JInt)jValue;
                BigInt i = jInt.num();
                object = i.isValidInt() ? BoxesRunTime.boxToLong((long)i.toInt()) : BoxesRunTime.boxToLong((long)i.toLong());
            } else if (JsonAST.JNull$.MODULE$.equals(jValue)) {
                object = null;
            } else if (jValue instanceof JsonAST.JBool) {
                JsonAST.JBool jBool = (JsonAST.JBool)jValue;
                boolean b = jBool.value();
                object = BoxesRunTime.boxToBoolean((boolean)b);
            } else {
                throw new MatchError((Object)jValue);
            }
            return object;
        }, List$.MODULE$.canBuildFrom());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object applyPathFunction(Enumeration.Value function, Object value) {
        Object object = value;
        if (object instanceof Seq) {
            Object object2;
            Seq seq = (Seq)object;
            Enumeration.Value value2 = function;
            Enumeration.Value value3 = JsonPathParser$JsonPathFunction$.MODULE$.length();
            Enumeration.Value value4 = value2;
            if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                object2 = BoxesRunTime.boxToInteger((int)seq.length());
                return object2;
            }
            Enumeration.Value value5 = JsonPathParser$JsonPathFunction$.MODULE$.avg();
            Enumeration.Value value6 = value2;
            if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                object2 = BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToDouble((double)KryoJsonSerialization$.toNum$1(v)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)seq.length()));
                return object2;
            }
            Enumeration.Value value7 = JsonPathParser$JsonPathFunction$.MODULE$.min();
            Enumeration.Value value8 = value2;
            if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                object2 = ((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToDouble((double)KryoJsonSerialization$.toNum$1(v)), Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Double$.MODULE$);
                return object2;
            }
            Enumeration.Value value9 = JsonPathParser$JsonPathFunction$.MODULE$.max();
            Enumeration.Value value10 = value2;
            if (value9 == null) {
                if (value10 != null) {
                    throw new MatchError((Object)value2);
                }
            } else if (!value9.equals(value10)) throw new MatchError((Object)value2);
            object2 = ((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToDouble((double)KryoJsonSerialization$.toNum$1(v)), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$);
            return object2;
        }
        if (!(object instanceof String)) return null;
        String string = (String)object;
        Enumeration.Value value11 = function;
        Enumeration.Value value12 = JsonPathParser$JsonPathFunction$.MODULE$.length();
        if (value11 != null) {
            if (!value11.equals(value12)) return null;
            return BoxesRunTime.boxToInteger((int)string.length());
        }
        if (value12 == null) return BoxesRunTime.boxToInteger((int)string.length());
        return null;
    }

    private KryoJsonSerialization.RichOutput RichOutput(Output out) {
        return new KryoJsonSerialization.RichOutput(out);
    }

    private KryoJsonSerialization.RichInput RichInput(Input in) {
        return new KryoJsonSerialization.RichInput(in);
    }

    public static final /* synthetic */ void $anonfun$writeDocument$1(Output out$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        JsonAST.JValue elem = (JsonAST.JValue)tuple2._2();
        MODULE$.writeValue(out$1, name, elem);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$matchPathAttribute$2(Input in$2, String x$3) {
        String string = x$3;
        String string2 = MODULE$.RichInput(in$2).readName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final boolean predicate$1(Input in$5) {
        this.RichInput(in$5).skipName();
        return true;
    }

    public static final /* synthetic */ void $anonfun$matchDeep$2(Queue toSearch$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        byte val1 = BoxesRunTime.unboxToByte((Object)tuple2._1());
        int val2 = tuple2._2$mcI$sp();
        byte by = val1;
        int n = val2;
        toSearch$1.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToByte((byte)by), (Object)BoxesRunTime.boxToInteger((int)n))}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final double toNum$1(Object v) {
        double d;
        Object object = v;
        if (object instanceof Number) {
            Number number = (Number)object;
            d = number.doubleValue();
        } else {
            d = object == null ? 0.0 : new StringOps(Predef$.MODULE$.augmentString(object.toString())).toDouble();
        }
        return d;
    }

    private KryoJsonSerialization$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$TerminalByte = 0;
        this.DoubleByte = 1;
        this.StringByte = (byte)2;
        this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$DocByte = (byte)3;
        this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$ArrayByte = (byte)4;
        this.BooleanByte = (byte)8;
        this.NullByte = (byte)10;
        this.IntByte = (byte)16;
        this.LongByte = (byte)18;
        this.BooleanFalse = 0;
        this.BooleanTrue = 1;
        this.NonDoc = (byte)2;
        this.org$locationtech$geomesa$features$kryo$json$KryoJsonSerialization$$nameBuffers = new ThreadLocal<byte[]>(){

            public byte[] initialValue() {
                return (byte[])Array$.MODULE$.ofDim(32, ClassTag$.MODULE$.Byte());
            }
        };
    }
}

