/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.kryo.serialization;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.features.kryo.serialization.KryoGeometrySerialization$;
import org.locationtech.geomesa.features.serialization.HintKeySerialization$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map$;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.SortedSet$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class KryoUserDataSerialization$
implements LazyLogging {
    public static KryoUserDataSerialization$ MODULE$;
    private final String nullMapping;
    private final scala.collection.immutable.Map<Class<?>, String> baseClassMappings;
    private final scala.collection.immutable.Map<String, Class<?>> baseClassLookups;
    private final Ordering<Tuple2<Object, Object>> ordering;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new KryoUserDataSerialization$();
    }

    private Logger logger$lzycompute() {
        KryoUserDataSerialization$ kryoUserDataSerialization$ = this;
        synchronized (kryoUserDataSerialization$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private String nullMapping() {
        return this.nullMapping;
    }

    private scala.collection.immutable.Map<Class<?>, String> baseClassMappings() {
        return this.baseClassMappings;
    }

    private scala.collection.immutable.Map<String, Class<?>> baseClassLookups() {
        return this.baseClassLookups;
    }

    private Ordering<Tuple2<Object, Object>> ordering() {
        return this.ordering;
    }

    public void serialize(Output out, Map<?, ?> javaMap) {
        this.serialize(out, javaMap, false, false);
    }

    public void serialize(Output out, Map<?, ?> javaMap, boolean withoutFidHints) {
        this.serialize(out, javaMap, withoutFidHints, false);
    }

    public void serializeAscii(Output out, Map<?, ?> javaMap) {
        this.serialize(out, javaMap, true, true);
    }

    private void serialize(Output out, Map<?, ?> javaMap, boolean withoutFidHints, boolean writeAscii) {
        SortedSet toWrite = SortedSet$.MODULE$.empty(this.ordering());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(javaMap).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                Object v = tuple2._2();
                if (k != null && !(k instanceof Hints.Key)) {
                    return toWrite.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), v));
                }
            }
            if (tuple2 != null) {
                Object object = tuple2._1();
                Hints.Key key = Hints.USE_PROVIDED_FID;
                Object object2 = object;
                if (!(key != null ? !key.equals(object2) : object2 != null) && withoutFidHints) {
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 != null) {
                Object object = tuple2._1();
                Hints.Key key = Hints.PROVIDED_FID;
                Object object3 = object;
                if (!(key != null ? !key.equals(object3) : object3 != null) && withoutFidHints) {
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Object k = tuple2._1();
            Object v = tuple2._2();
            if (MODULE$.logger().underlying().isWarnEnabled()) {
                MODULE$.logger().underlying().warn("Skipping serialization of entry: {} -> {}", new Object[]{k, v});
                boxedUnit = BoxedUnit.UNIT;
                return boxedUnit;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        out.writeInt(toWrite.size());
        toWrite.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            KryoUserDataSerialization$.$anonfun$serialize$2(out, writeAscii, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public Map<Object, Object> deserialize(Input in) {
        HashMap<Object, Object> hashMap;
        try {
            int size = in.readInt();
            HashMap<Object, Object> map = new HashMap<Object, Object>(size);
            this.deserializeWithSize(in, map, size);
            hashMap = map;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Error reading serialized kryo user data:", e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            HashMap hashMap2 = new HashMap();
            hashMap = hashMap2;
        }
        return hashMap;
    }

    public void deserialize(Input in, Map<Object, Object> map) {
        try {
            this.deserializeWithSize(in, map, in.readInt());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Error reading serialized kryo user data:", e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                new HashMap();
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private void deserializeWithSize(Input in, Map<Object, Object> map, int size) {
        for (int i = 0; i < size; ++i) {
            String valueClass;
            String keyClass = in.readString();
            Object key = this.read(in, (Class)this.baseClassLookups().getOrElse((Object)keyClass, (Function0 & Serializable & scala.Serializable)() -> Class.forName(keyClass)));
            String string = valueClass = in.readString();
            String string2 = this.nullMapping();
            Object value = !(string != null ? !string.equals(string2) : string2 != null) ? null : this.read(in, (Class)this.baseClassLookups().getOrElse((Object)valueClass, (Function0 & Serializable & scala.Serializable)() -> Class.forName(valueClass)));
            map.put(key, value);
        }
    }

    private void write(Output out, Object value, boolean writeAscii) {
        Object object = value;
        if (object instanceof String) {
            BoxedUnit boxedUnit;
            String string = (String)object;
            if (writeAscii) {
                out.writeAscii(string);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                out.writeString(string);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (object instanceof Integer) {
            Integer n = (Integer)object;
            out.writeInt(Predef$.MODULE$.Integer2int(n));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Long) {
            Long l = (Long)object;
            out.writeLong(Predef$.MODULE$.Long2long(l));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Float) {
            Float f = (Float)object;
            out.writeFloat(Predef$.MODULE$.Float2float(f));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Double) {
            Double d = (Double)object;
            out.writeDouble(Predef$.MODULE$.Double2double(d));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            out.writeBoolean(Predef$.MODULE$.Boolean2boolean(bl));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Date) {
            Date date = (Date)object;
            out.writeLong(date.getTime());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            this.writeBytes(out, byArray);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Geometry) {
            Geometry geometry = (Geometry)object;
            KryoGeometrySerialization$.MODULE$.serializeWkb(out, geometry);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof UUID) {
            UUID uUID = (UUID)object;
            out.writeLong(uUID.getMostSignificantBits());
            out.writeLong(uUID.getLeastSignificantBits());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof List) {
            List list = (List)object;
            this.writeList(out, list);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported value: ").append(value).append(" (").append(value.getClass()).append(")").toString());
        }
    }

    private boolean write$default$3() {
        return false;
    }

    private Object read(Input in, Class<?> clas) {
        Object object;
        Class<?> clazz = clas;
        if (String.class.isAssignableFrom(clazz)) {
            object = in.readString().intern();
        } else if (Integer.class.isAssignableFrom(clazz)) {
            object = BoxesRunTime.boxToInteger((int)in.readInt());
        } else if (Long.class.isAssignableFrom(clazz)) {
            object = BoxesRunTime.boxToLong((long)in.readLong());
        } else if (Float.class.isAssignableFrom(clazz)) {
            object = BoxesRunTime.boxToFloat((float)in.readFloat());
        } else if (Double.class.isAssignableFrom(clazz)) {
            object = BoxesRunTime.boxToDouble((double)in.readDouble());
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            object = BoxesRunTime.boxToBoolean((boolean)in.readBoolean());
        } else if (Date.class.isAssignableFrom(clazz)) {
            object = new Date(in.readLong());
        } else if (byte[].class.equals(clazz)) {
            object = this.readBytes(in);
        } else if (Geometry.class.isAssignableFrom(clazz)) {
            object = KryoGeometrySerialization$.MODULE$.deserializeWkb(in, true);
        } else if (UUID.class.isAssignableFrom(clazz)) {
            object = new UUID(in.readLong(), in.readLong());
        } else if (List.class.isAssignableFrom(clazz)) {
            object = this.readList(in);
        } else if (Hints.Key.class.isAssignableFrom(clazz)) {
            object = HintKeySerialization$.MODULE$.idToKey().apply((Object)in.readString());
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unsupported value class: ").append(clas).toString());
        }
        return object;
    }

    private void writeBytes(Output out, byte[] bytes) {
        out.writeInt(bytes.length);
        out.writeBytes(bytes);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] readBytes(Input in) {
        void var2_2;
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(in.readInt(), ClassTag$.MODULE$.Byte());
        in.readBytes(bytes);
        return var2_2;
    }

    private void writeList(Output out, List<Object> list) {
        out.writeInt(list.size());
        for (Object value : list) {
            if (value == null) {
                out.writeString(this.nullMapping());
                continue;
            }
            out.writeString((String)this.baseClassMappings().getOrElse(value.getClass(), (Function0 & Serializable & scala.Serializable)() -> value.getClass().getName()));
            this.write(out, value, this.write$default$3());
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<Object> readList(Input in) {
        void var3_3;
        int size = in.readInt();
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            String clas;
            String string = clas = in.readString();
            String string2 = this.nullMapping();
            boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? list.add(null) : list.add(this.read(in, (Class)this.baseClassLookups().getOrElse((Object)clas, (Function0 & Serializable & scala.Serializable)() -> Class.forName(clas))));
        }
        return var3_3;
    }

    public static final /* synthetic */ boolean $anonfun$baseClassLookups$1(Tuple2 x$1) {
        return ((Class)x$1._1()).isPrimitive();
    }

    public static final /* synthetic */ void $anonfun$serialize$2(Output out$1, boolean writeAscii$1, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Object key = tuple2._1();
            Object value = tuple2._2();
            out$1.writeString((String)MODULE$.baseClassMappings().getOrElse(key.getClass(), (Function0 & Serializable & scala.Serializable)() -> key.getClass().getName()));
            MODULE$.write(out$1, key, writeAscii$1);
            if (value == null) {
                out$1.writeString(MODULE$.nullMapping());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                out$1.writeString((String)MODULE$.baseClassMappings().getOrElse(value.getClass(), (Function0 & Serializable & scala.Serializable)() -> value.getClass().getName()));
                MODULE$.write(out$1, value, writeAscii$1);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    /*
     * WARNING - void declaration
     */
    private KryoUserDataSerialization$() {
        void var2_2;
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.nullMapping = "$_";
        this.baseClassMappings = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(String.class), (Object)"$s"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Integer.TYPE), (Object)"$i"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Integer.class), (Object)"$i"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Long.TYPE), (Object)"$l"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Long.class), (Object)"$l"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Float.TYPE), (Object)"$f"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Float.class), (Object)"$f"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Double.TYPE), (Object)"$d"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Double.class), (Object)"$d"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Boolean.TYPE), (Object)"$b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Boolean.class), (Object)"$b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Date.class), (Object)"$D"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(byte[].class), (Object)"$B"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(UUID.class), (Object)"$u"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Point.class), (Object)"$pt"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(LineString.class), (Object)"$ls"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Polygon.class), (Object)"$pl"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Hints.Key.class), (Object)"$h")}));
        scala.collection.immutable.Map m1 = (scala.collection.immutable.Map)this.baseClassMappings().filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KryoUserDataSerialization$.$anonfun$baseClassLookups$1(x$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.swap(), Map$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map m2 = m1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.geotools.factory.Hints$Key"), Hints.Key.class));
        this.baseClassLookups = var2_2;
        this.ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$3 -> x$3._1().toString(), (Ordering)Ordering.String$.MODULE$);
    }
}

