/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.junit.runner.RunWith;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.fs.data.FileSystemDataStore;
import org.locationtech.geomesa.fs.storage.common.package;
import org.locationtech.geomesa.fs.storage.common.package$;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.specs2.matcher.MatchResult$;
import org.specs2.matcher.ValueCheck;
import org.specs2.matcher.ValueCheck$;
import org.specs2.matcher.describe.Diffable$;
import org.specs2.mutable.Specification;
import org.specs2.runner.JUnitRunner;
import org.specs2.specification.core.AsExecution$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0005\u000b\u0001MAQ\u0001\b\u0001\u0005\u0002uA\u0011\u0002\t\u0001A\u0002\u0003\u0007I\u0011A\u0011\t\u00131\u0002\u0001\u0019!a\u0001\n\u0003i\u0003\"\u0003\u001c\u0001\u0001\u0004\u0005\t\u0015)\u0003#\u0011\u00159\u0004\u0001\"\u00019\u0011!\u0011\u0006\u0001#b\u0001\n\u0003\u0019\u0006\"\u0002.\u0001\t\u0003Y\u0006\"B5\u0001\t\u0003Q'a\u0006\"vG.,GOV:MK\u000647\u000b^8sC\u001e,G+Z:u\u0015\tYA\"\u0001\u0002gg*\u0011QBD\u0001\bO\u0016|W.Z:b\u0015\ty\u0001#\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001655\taC\u0003\u0002\u00181\u00059Q.\u001e;bE2,'BA\r\u0011\u0003\u0019\u0019\b/Z2te%\u00111D\u0006\u0002\u000e'B,7-\u001b4jG\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\u0005q\u0002CA\u0010\u0001\u001b\u0005Q\u0011a\u0002;f[B$\u0015N]\u000b\u0002EA\u00111EK\u0007\u0002I)\u0011QEJ\u0001\u0005M&dWM\u0003\u0002(Q\u0005\u0019a.[8\u000b\u0003%\nAA[1wC&\u00111\u0006\n\u0002\u0005!\u0006$\b.A\u0006uK6\u0004H)\u001b:`I\u0015\fHC\u0001\u00185!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u0011)f.\u001b;\t\u000fU\u001a\u0011\u0011!a\u0001E\u0005\u0019\u0001\u0010J\u0019\u0002\u0011Q,W\u000e\u001d#je\u0002\nQ!\\6TMR$\"!O#\u0011\u0005i\u001aU\"A\u001e\u000b\u0005qj\u0014AB:j[BdWM\u0003\u0002?\u007f\u00059a-Z1ukJ,'B\u0001!B\u0003\r\t\u0007/\u001b\u0006\u0003\u0005B\t\u0001bZ3pi>|Gn]\u0005\u0003\tn\u0012\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0011\u00151U\u00011\u0001H\u0003\u0011q\u0017-\\3\u0011\u0005!{eBA%N!\tQ\u0005'D\u0001L\u0015\ta%#\u0001\u0004=e>|GOP\u0005\u0003\u001dB\na\u0001\u0015:fI\u00164\u0017B\u0001)R\u0005\u0019\u0019FO]5oO*\u0011a\nM\u0001\u0003IN,\u0012\u0001\u0016\t\u0003+bk\u0011A\u0016\u0006\u0003/*\tA\u0001Z1uC&\u0011\u0011L\u0016\u0002\u0014\r&dWmU=ti\u0016lG)\u0019;b'R|'/Z\u0001\tM\u0016\fG/\u001e:fgR\u0011Al\u001a\t\u0004;\n$W\"\u00010\u000b\u0005}\u0003\u0017!C5n[V$\u0018M\u00197f\u0015\t\t\u0007'\u0001\u0006d_2dWm\u0019;j_:L!a\u00190\u0003\t1K7\u000f\u001e\t\u0003u\u0015L!AZ\u001e\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0011\u0015Aw\u00011\u0001:\u0003\r\u0019h\r^\u0001\u0007i>d\u0015n\u001d;\u0015\u0005-\u001c\bc\u00017rI:\u0011Qn\u001c\b\u0003\u0015:L\u0011!M\u0005\u0003aB\nq\u0001]1dW\u0006<W-\u0003\u0002de*\u0011\u0001\u000f\r\u0005\u0006i\"\u0001\r!^\u0001\u0004g\u001aL\u0007C\u0001<z\u001b\u00059(B\u0001\u001fy\u0015\t9\u0016)\u0003\u0002{o\n)2+[7qY\u00164U-\u0019;ve\u0016LE/\u001a:bi>\u0014\bF\u0002\u0001}\u0003\u0013\tY\u0001E\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011A\u0002:v]:,'OC\u0002\u0002\u0004A\tQA[;oSRL1!a\u0002\u007f\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c#!!\u0004\u0011\t\u0005=\u00111C\u0007\u0003\u0003#Q!a \r\n\t\u0005U\u0011\u0011\u0003\u0002\f\u0015Vs\u0017\u000e\u001e*v]:,'\u000f")
public class BucketVsLeafStorageTest
extends Specification {
    private FileSystemDataStore ds;
    private Path tempDir;
    private volatile boolean bitmap$0;

    public Path tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(Path x$1) {
        this.tempDir = x$1;
    }

    public SimpleFeatureType mkSft(String name) {
        return SimpleFeatureTypes$.MODULE$.createType(name, "attr:String,dtg:Date,*geom:Point:srid=4326");
    }

    private FileSystemDataStore ds$lzycompute() {
        BucketVsLeafStorageTest bucketVsLeafStorageTest = this;
        synchronized (bucketVsLeafStorageTest) {
            if (!this.bitmap$0) {
                this.ds = (FileSystemDataStore)DataStoreFinder.getDataStore((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.path"), (Object)this.tempDir().toFile().getPath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.encoding"), (Object)"parquet"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.config.xml"), (Object)"<configuration><property><name>parquet.compression</name><value>gzip</value></property></configuration>")}))).asJava()));
                this.bitmap$0 = true;
            }
        }
        return this.ds;
    }

    public FileSystemDataStore ds() {
        if (!this.bitmap$0) {
            return this.ds$lzycompute();
        }
        return this.ds;
    }

    public List<SimpleFeature> features(SimpleFeatureType sft) {
        return new .colon.colon((Object)ScalaSimpleFeature$.MODULE$.create(sft, "1", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"first", "2016-01-01", "POINT (-5 5)"})), (List)new .colon.colon((Object)ScalaSimpleFeature$.MODULE$.create(sft, "2", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"second", "2016-01-02", "POINT (5 5)"})), (List)new .colon.colon((Object)ScalaSimpleFeature$.MODULE$.create(sft, "3", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"third", "2016-01-03", "POINT (5 -5)"})), (List)new .colon.colon((Object)ScalaSimpleFeature$.MODULE$.create(sft, "3", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fourth", "2016-01-04", "POINT (-5 -5)"})), (List)Nil$.MODULE$))));
    }

    public List<SimpleFeature> toList(SimpleFeatureIterator sfi) {
        return SelfClosingIterator$.MODULE$.apply(sfi).toList();
    }

    public static final /* synthetic */ boolean $anonfun$new$19(String f$1, Path x$2) {
        return ((Object)x$2).toString().matches(f$1);
    }

    public static final /* synthetic */ boolean $anonfun$new$27(String f$2, Path x$4) {
        return ((Object)x$4).toString().matches(f$2);
    }

    public static final /* synthetic */ boolean $anonfun$new$35(String f$3, Path x$6) {
        return ((Object)x$6).toString().matches(f$3);
    }

    public static final /* synthetic */ boolean $anonfun$new$50(String f$4, Path x) {
        return ((Object)x).toString().matches(f$4);
    }

    public static final /* synthetic */ boolean $anonfun$new$58(String f$5, Path x) {
        return ((Object)x).toString().matches(f$5);
    }

    public static final /* synthetic */ boolean $anonfun$new$72(String f$6, Path x$10) {
        return ((Object)x$10).toString().matches(f$6);
    }

    public static final /* synthetic */ boolean $anonfun$new$80(String f$7, Path x$12) {
        return ((Object)x$12).toString().matches(f$7);
    }

    public static final /* synthetic */ boolean $anonfun$new$88(String f$8, Path x$14) {
        return ((Object)x$14).toString().matches(f$8);
    }

    public static final /* synthetic */ boolean $anonfun$new$103(String f$9, Path x$16) {
        return ((Object)x$16).toString().matches(f$9);
    }

    public static final /* synthetic */ boolean $anonfun$new$110(String f$10, Path x$18) {
        return ((Object)x$18).toString().matches(f$10);
    }

    public BucketVsLeafStorageTest() {
        this.sequential();
        this.step((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.tempDir_$eq(Files.createTempDirectory("geomesa", new FileAttribute[0])));
        this.blockExample("DataStores").should((Function0 & Serializable & scala.Serializable)() -> {
            this.blockExample("store data in leaves").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("in one scheme").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String typeName = "leaf-one";
                    SimpleFeatureType sft = this.mkSft(typeName);
                    SimpleFeatureType qual$1 = package$.MODULE$.RichSimpleFeatureType(sft);
                    String x$12 = "daily";
                    scala.collection.immutable.Map x$2 = package.RichSimpleFeatureType$.MODULE$.setScheme$default$2$extension(qual$1);
                    package.RichSimpleFeatureType$.MODULE$.setScheme$extension(qual$1, x$12, x$2);
                    this.ds().createSchema(sft);
                    this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.ds().getTypeNames().length).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1);
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.ds().getTypeNames())).head()).mustEqual((Function0 & Serializable & scala.Serializable)() -> typeName);
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.ds().storage(typeName).metadata().leafStorage()).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                    ((SimpleFeatureStore)this.ds().getFeatureSource(sft.getTypeName())).addFeatures((FeatureCollection)new ListFeatureCollection(sft, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.features(sft).take(2)).asJava()));
                    Path fp = this.tempDir().resolve("leaf-one");
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> fp.toFile().exists()).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> fp.resolve("2016/01").toFile().exists()).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                    ((IterableLike)((TraversableLike)new .colon.colon((Object)"2016/01/01_W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/02_W[0-9a-f]{32}\\.parquet", (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append(((Object)fp).toString()).append("/").append((String)x$1).toString(), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.fromMatchResult((Function0 & Serializable & scala.Serializable)() -> $this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(fp$1, new FileVisitOption[0]).iterator()).asScala()).count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BucketVsLeafStorageTest.$anonfun$new$19(f, x$2)))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1))));
                    this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.toList(this.ds().getFeatureSource(sft.getTypeName()).getFeatures().features()).size()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 2);
                    ((SimpleFeatureStore)this.ds().getFeatureSource(sft.getTypeName())).addFeatures((FeatureCollection)new ListFeatureCollection(sft, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.features(sft).drop(2)).asJava()));
                    ((IterableLike)((TraversableLike)new .colon.colon((Object)"2016/01/01_W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/02_W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/03_W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/04_W[0-9a-f]{32}\\.parquet", (List)Nil$.MODULE$))))).map((Function1 & Serializable & scala.Serializable)x$3 -> new StringBuilder(1).append(((Object)fp).toString()).append("/").append((String)x$3).toString(), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.fromMatchResult((Function0 & Serializable & scala.Serializable)() -> $this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(fp$1, new FileVisitOption[0]).iterator()).asScala()).count((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)BucketVsLeafStorageTest.$anonfun$new$27(f, x$4)))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1))));
                    this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> CloseableIterator$.MODULE$.apply((FeatureIterator)this.ds().getFeatureSource(sft.getTypeName()).getFeatures().features()).toSeq().size()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 4);
                    ((SimpleFeatureStore)this.ds().getFeatureSource(sft.getTypeName())).addFeatures((FeatureCollection)new ListFeatureCollection(sft, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.features(sft)).asJava()));
                    ((IterableLike)((TraversableLike)new .colon.colon((Object)"2016/01/01_W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/02_W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/03_W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/04_W[0-9a-f]{32}\\.parquet", (List)Nil$.MODULE$))))).map((Function1 & Serializable & scala.Serializable)x$5 -> new StringBuilder(1).append(((Object)fp).toString()).append("/").append((String)x$5).toString(), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.fromMatchResult((Function0 & Serializable & scala.Serializable)() -> $this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(fp$1, new FileVisitOption[0]).iterator()).asScala()).count((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)BucketVsLeafStorageTest.$anonfun$new$35(f, x$6)))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 2))));
                    return this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> CloseableIterator$.MODULE$.apply((FeatureIterator)this.ds().getFeatureSource(sft.getTypeName()).getFeatures().features()).toSeq().size()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 8);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("in two schemes").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String typeName = "leaf-two";
                    SimpleFeatureType sft = this.mkSft(typeName);
                    SimpleFeatureType qual$2 = package$.MODULE$.RichSimpleFeatureType(sft);
                    String x$3 = "daily,z2-2bits";
                    scala.collection.immutable.Map x$4 = package.RichSimpleFeatureType$.MODULE$.setScheme$default$2$extension(qual$2);
                    package.RichSimpleFeatureType$.MODULE$.setScheme$extension(qual$2, x$3, x$4);
                    this.ds().createSchema(sft);
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.ds().getTypeNames())).toSeq()).must((Function0 & Serializable & scala.Serializable)() -> this.contain((ValueCheck)ValueCheck$.MODULE$.typedValueCheck((Object)typeName, Diffable$.MODULE$.stringDiffable())));
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.ds().storage(typeName).metadata().leafStorage()).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                    ((SimpleFeatureStore)this.ds().getFeatureSource(sft.getTypeName())).addFeatures((FeatureCollection)new ListFeatureCollection(sft, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.features(sft)).asJava()));
                    Path fp = this.tempDir().resolve("leaf-two");
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> fp.toFile().exists()).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                    ((IterableLike)((TraversableLike)new .colon.colon((Object)"2016/01/01/2_W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/02/3_W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/03/1_W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/04/0_W[0-9a-f]{32}\\.parquet", (List)Nil$.MODULE$))))).map((Function1 & Serializable & scala.Serializable)x$7 -> new StringBuilder(1).append(((Object)fp).toString()).append("/").append((String)x$7).toString(), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.fromMatchResult((Function0 & Serializable & scala.Serializable)() -> $this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(fp$2, new FileVisitOption[0]).iterator()).asScala()).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)BucketVsLeafStorageTest.$anonfun$new$50(f, x)))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1))));
                    this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> CloseableIterator$.MODULE$.apply((FeatureIterator)this.ds().getFeatureSource(sft.getTypeName()).getFeatures().features()).toList().size()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 4);
                    ((SimpleFeatureStore)this.ds().getFeatureSource(sft.getTypeName())).addFeatures((FeatureCollection)new ListFeatureCollection(sft, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.features(sft)).asJava()));
                    ((IterableLike)((TraversableLike)new .colon.colon((Object)"2016/01/01/2_W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/02/3_W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/03/1_W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/04/0_W[0-9a-f]{32}\\.parquet", (List)Nil$.MODULE$))))).map((Function1 & Serializable & scala.Serializable)x$8 -> new StringBuilder(1).append(((Object)fp).toString()).append("/").append((String)x$8).toString(), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.fromMatchResult((Function0 & Serializable & scala.Serializable)() -> $this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(fp$2, new FileVisitOption[0]).iterator()).asScala()).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)BucketVsLeafStorageTest.$anonfun$new$58(f, x)))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 2))));
                    return this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> CloseableIterator$.MODULE$.apply((FeatureIterator)this.ds().getFeatureSource(sft.getTypeName()).getFeatures().features()).toList().size()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 8);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
            return this.blockExample("store data in buckets").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("in one scheme").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String typeName = "bucket-one";
                    SimpleFeatureType sft = this.mkSft(typeName);
                    SimpleFeatureType qual$3 = package$.MODULE$.RichSimpleFeatureType(sft);
                    String x$5 = "daily";
                    scala.collection.immutable.Map x$6 = package.RichSimpleFeatureType$.MODULE$.setScheme$default$2$extension(qual$3);
                    package.RichSimpleFeatureType$.MODULE$.setScheme$extension(qual$3, x$5, x$6);
                    package.RichSimpleFeatureType$.MODULE$.setLeafStorage$extension(package$.MODULE$.RichSimpleFeatureType(sft), false);
                    this.ds().createSchema(sft);
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.ds().getTypeNames())).toSeq()).must((Function0 & Serializable & scala.Serializable)() -> this.contain((ValueCheck)ValueCheck$.MODULE$.typedValueCheck((Object)typeName, Diffable$.MODULE$.stringDiffable())));
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.ds().storage(typeName).metadata().leafStorage()).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                    ((SimpleFeatureStore)this.ds().getFeatureSource(sft.getTypeName())).addFeatures((FeatureCollection)new ListFeatureCollection(sft, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.features(sft).take(2)).asJava()));
                    Path fp = this.tempDir().resolve("bucket-one");
                    ((IterableLike)((TraversableLike)new .colon.colon((Object)"2016/01/01/W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/02/W[0-9a-f]{32}\\.parquet", (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$9 -> new StringBuilder(1).append(((Object)fp).toString()).append("/").append((String)x$9).toString(), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.fromMatchResult((Function0 & Serializable & scala.Serializable)() -> $this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(fp$3, new FileVisitOption[0]).iterator()).asScala()).count((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)BucketVsLeafStorageTest.$anonfun$new$72(f, x$10)))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1))));
                    this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.toList(this.ds().getFeatureSource(sft.getTypeName()).getFeatures().features()).size()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 2);
                    ((SimpleFeatureStore)this.ds().getFeatureSource(sft.getTypeName())).addFeatures((FeatureCollection)new ListFeatureCollection(sft, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.features(sft).drop(2)).asJava()));
                    ((IterableLike)((TraversableLike)new .colon.colon((Object)"2016/01/01/W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/02/W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/03/W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/04/W[0-9a-f]{32}\\.parquet", (List)Nil$.MODULE$))))).map((Function1 & Serializable & scala.Serializable)x$11 -> new StringBuilder(1).append(((Object)fp).toString()).append("/").append((String)x$11).toString(), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.fromMatchResult((Function0 & Serializable & scala.Serializable)() -> $this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(fp$3, new FileVisitOption[0]).iterator()).asScala()).count((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)BucketVsLeafStorageTest.$anonfun$new$80(f, x$12)))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1))));
                    this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> CloseableIterator$.MODULE$.apply((FeatureIterator)this.ds().getFeatureSource(sft.getTypeName()).getFeatures().features()).toSeq().size()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 4);
                    ((SimpleFeatureStore)this.ds().getFeatureSource(sft.getTypeName())).addFeatures((FeatureCollection)new ListFeatureCollection(sft, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.features(sft)).asJava()));
                    ((IterableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2016/01/01/W[0-9a-f]{32}\\.parquet", "2016/01/02/W[0-9a-f]{32}\\.parquet", "2016/01/03/W[0-9a-f]{32}\\.parquet", "2016/01/04/W[0-9a-f]{32}\\.parquet", "2016/01/01/W[0-9a-f]{32}\\.parquet", "2016/01/02/W[0-9a-f]{32}\\.parquet", "2016/01/03/W[0-9a-f]{32}\\.parquet", "2016/01/04/W[0-9a-f]{32}\\.parquet"}))).map((Function1 & Serializable & scala.Serializable)x$13 -> new StringBuilder(1).append(((Object)fp).toString()).append("/").append((String)x$13).toString(), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.fromMatchResult((Function0 & Serializable & scala.Serializable)() -> $this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(fp$3, new FileVisitOption[0]).iterator()).asScala()).count((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)BucketVsLeafStorageTest.$anonfun$new$88(f, x$14)))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 2))));
                    return this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> CloseableIterator$.MODULE$.apply((FeatureIterator)this.ds().getFeatureSource(sft.getTypeName()).getFeatures().features()).toSeq().size()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 8);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("with two schemes").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String typeName = "bucket-two";
                    SimpleFeatureType sft = this.mkSft(typeName);
                    SimpleFeatureType qual$4 = package$.MODULE$.RichSimpleFeatureType(sft);
                    String x$7 = "daily,z2-2bits";
                    scala.collection.immutable.Map x$8 = package.RichSimpleFeatureType$.MODULE$.setScheme$default$2$extension(qual$4);
                    package.RichSimpleFeatureType$.MODULE$.setScheme$extension(qual$4, x$7, x$8);
                    package.RichSimpleFeatureType$.MODULE$.setLeafStorage$extension(package$.MODULE$.RichSimpleFeatureType(sft), false);
                    this.ds().createSchema(sft);
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.ds().getTypeNames())).toSeq()).must((Function0 & Serializable & scala.Serializable)() -> this.contain((ValueCheck)ValueCheck$.MODULE$.typedValueCheck((Object)typeName, Diffable$.MODULE$.stringDiffable())));
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.ds().storage(typeName).metadata().leafStorage()).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                    ((SimpleFeatureStore)this.ds().getFeatureSource(sft.getTypeName())).addFeatures((FeatureCollection)new ListFeatureCollection(sft, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.features(sft)).asJava()));
                    Path fp = this.tempDir().resolve(typeName);
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> fp.toFile().exists()).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                    ((IterableLike)((TraversableLike)new .colon.colon((Object)"2016/01/01/2/W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/02/3/W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/03/1/W[0-9a-f]{32}\\.parquet", (List)new .colon.colon((Object)"2016/01/04/0/W[0-9a-f]{32}\\.parquet", (List)Nil$.MODULE$))))).map((Function1 & Serializable & scala.Serializable)x$15 -> new StringBuilder(1).append(((Object)fp).toString()).append("/").append((String)x$15).toString(), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.fromMatchResult((Function0 & Serializable & scala.Serializable)() -> $this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(fp$4, new FileVisitOption[0]).iterator()).asScala()).count((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)BucketVsLeafStorageTest.$anonfun$new$103(f, x$16)))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1))));
                    this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> CloseableIterator$.MODULE$.apply((FeatureIterator)this.ds().getFeatureSource(sft.getTypeName()).getFeatures().features()).toList().size()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 4);
                    ((SimpleFeatureStore)this.ds().getFeatureSource(sft.getTypeName())).addFeatures((FeatureCollection)new ListFeatureCollection(sft, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.features(sft)).asJava()));
                    this.forall((Traversable)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2016/01/01/2/W[0-9a-f]{32}\\.parquet", "2016/01/02/3/W[0-9a-f]{32}\\.parquet", "2016/01/03/1/W[0-9a-f]{32}\\.parquet", "2016/01/04/0/W[0-9a-f]{32}\\.parquet", "2016/01/01/2/W[0-9a-f]{32}\\.parquet", "2016/01/02/3/W[0-9a-f]{32}\\.parquet", "2016/01/03/1/W[0-9a-f]{32}\\.parquet", "2016/01/04/0/W[0-9a-f]{32}\\.parquet"}))).map((Function1 & Serializable & scala.Serializable)x$17 -> new StringBuilder(1).append(((Object)fp).toString()).append("/").append((String)x$17).toString(), Seq$.MODULE$.canBuildFrom()), (Function1 & Serializable & scala.Serializable)f -> this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(fp, new FileVisitOption[0]).iterator()).asScala()).count((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)BucketVsLeafStorageTest.$anonfun$new$110(f, x$18)))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 2), MatchResult$.MODULE$.matchResultAsResult());
                    return this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> CloseableIterator$.MODULE$.apply((FeatureIterator)this.ds().getFeatureSource(sft.getTypeName()).getFeatures().features()).toList().size()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 8);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("support deprecated leaf-storage config").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    SimpleFeatureType sft = this.mkSft("bucket-three");
                    package.RichSimpleFeatureType$.MODULE$.setScheme$extension(package$.MODULE$.RichSimpleFeatureType(sft), "daily", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leaf-storage"), (Object)"false")})));
                    this.ds().createSchema(sft);
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.ds().storage("bucket-three").metadata().leafStorage()).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
        });
        this.step((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> FileUtils.deleteDirectory((File)this.tempDir().toFile()));
    }
}

