/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.junit.runner.RunWith;
import org.locationtech.geomesa.features.AbstractSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.fs.data.FileSystemDataStore;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.package;
import org.locationtech.geomesa.fs.storage.common.package$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.jts.geom.Geometry;
import org.specs2.data.Sized$;
import org.specs2.matcher.MatchResult;
import org.specs2.matcher.MatchResult$;
import org.specs2.matcher.Matcher;
import org.specs2.matcher.ValueCheck;
import org.specs2.matcher.ValueCheck$;
import org.specs2.matcher.describe.Diffable$;
import org.specs2.mutable.Specification;
import org.specs2.runner.JUnitRunner;
import org.specs2.specification.core.AsExecution$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001\u0002\u000b\u0016\u0001yAQa\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005\u00021BqA\u0019\u0001\u0012\u0002\u0013\u00051\rC\u0004o\u0001E\u0005I\u0011A8\t\u000bE\u0004A\u0011\u0002:\t\u000bU\u0004A\u0011\u0002<\t\u000ba\u0004A\u0011B=\t\u000fm\u0004!\u0019!C\u0005y\"9\u0011Q\u0002\u0001!\u0002\u0013i\b\"CA\b\u0001\t\u0007I\u0011AA\t\u0011!\tY\u0003\u0001Q\u0001\n\u0005M\u0001\"CA\u0017\u0001\t\u0007I\u0011AA\u0018\u0011!\t\u0019\u0004\u0001Q\u0001\n\u0005E\u0002\"CA\u001b\u0001\t\u0007I\u0011AA\u001c\u0011!\ty\u0005\u0001Q\u0001\n\u0005e\u0002\"CA)\u0001\t\u0007I\u0011AA*\u0011!\t\u0019\u0007\u0001Q\u0001\n\u0005U\u0003\"CA3\u0001\t\u0007I\u0011AA4\u0011!\tI\u0007\u0001Q\u0001\n\u0005u!a\u0006$jY\u0016\u001c\u0016p\u001d;f[\u0012\u000bG/Y*u_J,G+Z:u\u0015\t1r#\u0001\u0002gg*\u0011\u0001$G\u0001\bO\u0016|W.Z:b\u0015\tQ2$\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0004\u0005\u0002!K5\t\u0011E\u0003\u0002#G\u00059Q.\u001e;bE2,'B\u0001\u0013\u001c\u0003\u0019\u0019\b/Z2te%\u0011a%\t\u0002\u000e'B,7-\u001b4jG\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\u0005I\u0003C\u0001\u0016\u0001\u001b\u0005)\u0012\u0001D2sK\u0006$XMR8s[\u0006$H\u0003B\u0017W1j\u0003RAL\u00194})k\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\u0007)V\u0004H.Z\u001a\u0011\u0005QZdBA\u001b:!\t1t&D\u00018\u0015\tAT$\u0001\u0004=e>|GOP\u0005\u0003u=\na\u0001\u0015:fI\u00164\u0017B\u0001\u001f>\u0005\u0019\u0019FO]5oO*\u0011!h\f\t\u0003\u007f!k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000baa]5na2,'BA\"E\u0003\u001d1W-\u0019;ve\u0016T!!\u0012$\u0002\u0007\u0005\u0004\u0018N\u0003\u0002H7\u0005Aq-Z8u_>d7/\u0003\u0002J\u0001\n\t2+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3\u0011\u0007-\u00036K\u0004\u0002M\u001d:\u0011a'T\u0005\u0002a%\u0011qjL\u0001\ba\u0006\u001c7.Y4f\u0013\t\t&KA\u0002TKFT!aT\u0018\u0011\u0005}\"\u0016BA+A\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\")qK\u0001a\u0001g\u00051am\u001c:nCRDq!\u0017\u0002\u0011\u0002\u0003\u00071'\u0001\u0003hK>l\u0007bB.\u0003!\u0003\u0005\r\u0001X\u0001\u000bGJ,\u0017\r^3HK>l\u0007\u0003\u0002\u0018^?NJ!AX\u0018\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\u0018a\u0013\t\twFA\u0002J]R\fac\u0019:fCR,gi\u001c:nCR$C-\u001a4bk2$HEM\u000b\u0002I*\u00121'Z\u0016\u0002MB\u0011q\r\\\u0007\u0002Q*\u0011\u0011N[\u0001\nk:\u001c\u0007.Z2lK\u0012T!a[\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002nQ\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002-\r\u0014X-\u0019;f\r>\u0014X.\u0019;%I\u00164\u0017-\u001e7uIM*\u0012\u0001\u001d\u0016\u00039\u0016\f1b\u0019:fCR,\u0007k\\5oiR\u00111g\u001d\u0005\u0006i\u0016\u0001\raX\u0001\u0002S\u0006Q1M]3bi\u0016d\u0015N\\3\u0015\u0005M:\b\"\u0002;\u0007\u0001\u0004y\u0016!D2sK\u0006$X\rU8ms\u001e|g\u000e\u0006\u00024u\")Ao\u0002a\u0001?\u00061!-Z+V\u0013\u0012+\u0012! \t\u0006}\u0006\r\u0011qA\u0007\u0002\u007f*\u0019\u0011\u0011A\u0012\u0002\u000f5\fGo\u00195fe&\u0019\u0011QA@\u0003\u000f5\u000bGo\u00195feB\u0019a&!\u0003\n\u0007\u0005-qFA\u0002B]f\fqAY3V+&#\u0005%A\u0005f]\u000e|G-\u001b8hgV\u0011\u00111\u0003\t\u0007\u0003+\tY\"!\b\u000e\u0005\u0005]!bAA\r_\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007E\u000b9\u0002\u0005\u0003\u0002 \u0005%RBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\t1\fgn\u001a\u0006\u0003\u0003O\tAA[1wC&\u0019A(!\t\u0002\u0015\u0015t7m\u001c3j]\u001e\u001c\b%A\u0004g_Jl\u0017\r^:\u0016\u0005\u0005E\u0002#BA\u000b\u00037i\u0013\u0001\u00034pe6\fGo\u001d\u0011\u0002\t\u0011L'o]\u000b\u0003\u0003s\u0001r!a\u000f\u0002@M\n\u0019%\u0004\u0002\u0002>)\u0019!%a\u0006\n\t\u0005\u0005\u0013Q\b\u0002\u0004\u001b\u0006\u0004\b\u0003BA#\u0003\u0017j!!a\u0012\u000b\t\u0005%\u0013QE\u0001\u0003S>LA!!\u0014\u0002H\t!a)\u001b7f\u0003\u0015!\u0017N]:!\u0003\u001d1\u0017\u000e\u001c;feN,\"!!\u0016\u0011\r\u0005U\u00111DA,!\u0011\tI&a\u0018\u000e\u0005\u0005m#bAA/\t\u00061a-\u001b7uKJLA!!\u0019\u0002\\\t1a)\u001b7uKJ\f\u0001BZ5mi\u0016\u00148\u000fI\u0001\u0005OjL\u0007/\u0006\u0002\u0002\u001e\u0005)qM_5qA!:\u0001!!\u001c\u0002~\u0005}\u0004\u0003BA8\u0003sj!!!\u001d\u000b\t\u0005M\u0014QO\u0001\u0007eVtg.\u001a:\u000b\u0007\u0005]4$A\u0003kk:LG/\u0003\u0003\u0002|\u0005E$a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0003\u0003\u0003\u0003B!a!\u0002\b6\u0011\u0011Q\u0011\u0006\u0004\u0003g\u001a\u0013\u0002BAE\u0003\u000b\u00131BS+oSR\u0014VO\u001c8fe\u0002")
public class FileSystemDataStoreTest
extends Specification {
    private final Matcher<Object> beUUID;
    private final Seq<String> encodings;
    private final Seq<Tuple3<String, SimpleFeatureType, Seq<SimpleFeature>>> formats;
    private final scala.collection.mutable.Map<String, File> dirs;
    private final Seq<Filter> filters;
    private final String gzip;

    public Tuple3<String, SimpleFeatureType, Seq<SimpleFeature>> createFormat(String format, String geom, Function1<Object, String> createGeom) {
        SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType(format, new StringBuilder(45).append("name:String,age:Int,dtg:Date,*geom:").append(geom).append(":srid=4326").toString());
        SimpleFeatureType qual$1 = package$.MODULE$.RichSimpleFeatureType(sft);
        String x$1 = "daily";
        scala.collection.immutable.Map x$2 = package.RichSimpleFeatureType$.MODULE$.setScheme$default$2$extension(qual$1);
        package.RichSimpleFeatureType$.MODULE$.setScheme$extension(qual$1, x$1, x$2);
        package.RichSimpleFeatureType$.MODULE$.setLeafStorage$extension(package$.MODULE$.RichSimpleFeatureType(sft), false);
        Seq features = (Seq)Seq$.MODULE$.tabulate(10, (Function1 & Serializable & scala.Serializable)i -> ScalaSimpleFeature$.MODULE$.create(sft, String.valueOf(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(4).append("test").append(BoxesRunTime.unboxToInt((Object)i)).toString(), BoxesRunTime.boxToInteger((int)(100 + BoxesRunTime.unboxToInt((Object)i))), new StringBuilder(24).append("2017-06-0").append(5 + BoxesRunTime.unboxToInt((Object)i) % 3).append("T04:03:02.0001Z").toString(), createGeom.apply((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)))})));
        return new Tuple3((Object)format, (Object)sft, (Object)features);
    }

    public String createFormat$default$2() {
        return "Point";
    }

    public Function1<Object, String> createFormat$default$3() {
        return (Function1 & Serializable & scala.Serializable)i -> this.createPoint(BoxesRunTime.unboxToInt((Object)i));
    }

    private String createPoint(int i) {
        return new StringBuilder(13).append("POINT(10 10.").append(i).append(")").toString();
    }

    private String createLine(int i) {
        return new StringBuilder(25).append("LINESTRING(10 10, 11 12.").append(i).append(")").toString();
    }

    private String createPolygon(int i) {
        return new StringBuilder(41).append("POLYGON((3").append(i).append(" 28, 41 28, 41 29, 3").append(i).append(" 29, 3").append(i).append(" 28))").toString();
    }

    private Matcher<Object> beUUID() {
        return this.beUUID;
    }

    public Seq<String> encodings() {
        return this.encodings;
    }

    public Seq<Tuple3<String, SimpleFeatureType, Seq<SimpleFeature>>> formats() {
        return this.formats;
    }

    public scala.collection.mutable.Map<String, File> dirs() {
        return this.dirs;
    }

    public Seq<Filter> filters() {
        return this.filters;
    }

    public String gzip() {
        return this.gzip;
    }

    public static final /* synthetic */ boolean $anonfun$beUUID$1(Object x$1) {
        Object object = x$1;
        if (object instanceof String) {
            boolean bl;
            String string = (String)object;
            try {
                UUID.fromString(string);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$new$102(SimpleFeature result$1, SimpleFeature x$9) {
        String string = x$9.getID();
        String string2 = result$1.getID();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$99(FileSystemDataStoreTest $this, String[] transform$1, Seq features$5, SimpleFeature result) {
        $this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> result.getAttributeCount()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> transform$1.length);
        SimpleFeature matched = (SimpleFeature)features$5.find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)FileSystemDataStoreTest.$anonfun$new$102(result, x$9))).get();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])transform$1)).foreach((Function1 & Serializable & scala.Serializable)t -> $this.theValue((Function0 & Serializable & scala.Serializable)() -> result.getAttribute(t)).mustEqual((Function0 & Serializable & scala.Serializable)() -> matched.getAttribute(t)));
    }

    private static final void modify$1(SimpleFeature f, FeatureWriter writer$3) {
        String string = f.getID();
        if ("0".equals(string)) {
            writer$3.remove();
            return;
        }
        if ("1".equals(string)) {
            f.setAttribute("dtg", (Object)"2017-06-05T04:03:02.0001Z");
            writer$3.write();
            return;
        }
        if ("2".equals(string)) {
            f.setAttribute("name", (Object)"test0");
            writer$3.write();
            return;
        }
        throw new MatchError((Object)string);
    }

    public static final /* synthetic */ MatchResult $anonfun$new$117(FileSystemDataStoreTest $this, FeatureWriter writer$3, int x$12) {
        $this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> writer$3.hasNext()).must((Function0 & Serializable & scala.Serializable)() -> $this.beTrue());
        FileSystemDataStoreTest.modify$1((SimpleFeature)writer$3.next(), writer$3);
        return $this.ok();
    }

    public static final /* synthetic */ String $anonfun$new$129(FileSystemDataStoreTest $this, int i) {
        if (i % 2 == 0) {
            return $this.createLine(i);
        }
        return $this.createPoint(i);
    }

    public static final /* synthetic */ void $anonfun$new$154(Tuple2 x0$13) {
        Tuple2 tuple2 = x0$13;
        if (tuple2 != null) {
            File dir = (File)tuple2._2();
            FileUtils.deleteDirectory((File)dir);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public FileSystemDataStoreTest() {
        this.sequential();
        this.beUUID = this.functionAndKoMessageToMatcher(new Tuple2((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileSystemDataStoreTest.$anonfun$beUUID$1(x$1)), (Function1 & Serializable & scala.Serializable)x$2 -> Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(x$2), " is not valid UUID")));
        this.encodings = (Seq)new .colon.colon((Object)"parquet", (List)new .colon.colon((Object)"orc", (List)Nil$.MODULE$));
        this.formats = (Seq)this.encodings().map((Function1 & Serializable & scala.Serializable)x$3 -> this.createFormat((String)x$3, this.createFormat$default$2(), this.createFormat$default$3()), Seq$.MODULE$.canBuildFrom());
        this.dirs = Map$.MODULE$.empty();
        this.filters = (Seq)((TraversableLike)new .colon.colon((Object)"INCLUDE", (List)new .colon.colon((Object)new StringBuilder(8).append("name IN ").append(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).mkString("('test", "','test", "')")).toString(), (List)new .colon.colon((Object)"bbox(geom, 5, 5, 15, 15)", (List)new .colon.colon((Object)"dtg DURING 2017-06-05T04:03:00.0000Z/2017-06-07T04:04:00.0000Z", (List)new .colon.colon((Object)"dtg > '2017-06-05T04:03:00.0000Z' AND dtg < '2017-06-07T04:04:00.0000Z'", (List)new .colon.colon((Object)"dtg DURING 2017-06-05T04:03:00.0000Z/2017-06-07T04:04:00.0000Z and bbox(geom, 5, 5, 15, 15)", (List)Nil$.MODULE$))))))).map((Function1 & Serializable & scala.Serializable)x$1 -> ECQL.toFilter((String)x$1), Seq$.MODULE$.canBuildFrom());
        this.gzip = "<configuration><property><name>parquet.compression</name><value>gzip</value></property></configuration>";
        this.step((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.formats().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                String f = (String)tuple3._1();
                return this.dirs().put((Object)f, (Object)Files.createTempDirectory(new StringBuilder(10).append("fsds-test-").append(f).toString(), new FileAttribute[0]).toFile());
            }
            throw new MatchError((Object)tuple3);
        }));
        this.blockExample("FileSystemDataStore").should((Function0 & Serializable & scala.Serializable)() -> {
            this.blockExample("create a DS").$greater$greater((Function0 & Serializable & scala.Serializable)() -> this.foreach((Traversable)this.formats(), (Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple3 tuple3 = x0$2;
                if (tuple3 != null) {
                    String format = (String)tuple3._1();
                    SimpleFeatureType sft = (SimpleFeatureType)tuple3._2();
                    Seq features = (Seq)tuple3._3();
                    File dir = (File)this.dirs().apply((Object)format);
                    scala.collection.immutable.Map dsParams = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.path"), (Object)dir.getPath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.encoding"), (Object)format), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.config.xml"), (Object)this.gzip())}));
                    FileSystemDataStore ds = (FileSystemDataStore)DataStoreFinder.getDataStore((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)dsParams).asJava()));
                    ds.createSchema(sft);
                    package.WithClose$.MODULE$.apply((Object)ds.getFeatureWriterAppend(format, Transaction.AUTO_COMMIT), (Function1 & Serializable & scala.Serializable)writer -> {
                        features.foreach((Function1 & Serializable & scala.Serializable)x$4 -> FeatureUtils$.MODULE$.write(writer, x$4, true));
                        return BoxedUnit.UNIT;
                    }, IsCloseable$.MODULE$.closeableIsCloseable());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new File(dir, new StringBuilder(9).append(format).append("/metadata").toString()).exists()).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new File(dir, new StringBuilder(9).append(format).append("/metadata").toString()).isDirectory()).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                    Seq expected = (Seq)new .colon.colon((Object)"2017/06/05", (List)new .colon.colon((Object)"2017/06/06", (List)new .colon.colon((Object)"2017/06/07", (List)Nil$.MODULE$)));
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ds.storage(sft.getTypeName()).getPartitions()).must((Function0 & Serializable & scala.Serializable)() -> this.haveLength(3, Sized$.MODULE$.scalaTraversableIsSized()));
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Seq)ds.storage(sft.getTypeName()).getPartitions().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), Seq$.MODULE$.canBuildFrom())).must((Function0 & Serializable & scala.Serializable)() -> this.containTheSameElementsAs(expected, this.containTheSameElementsAs$default$2()));
                    this.foreach((Traversable)expected, (Function1 & Serializable & scala.Serializable)name -> this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new File(dir, new StringBuilder(1).append(format).append("/").append((String)name).toString()).isDirectory()).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue()), MatchResult$.MODULE$.matchResultAsResult());
                    this.sized(this.theValue((Function0 & Serializable & scala.Serializable)() -> ds.getTypeNames()).must((Function0 & Serializable & scala.Serializable)() -> this.have()), Sized$.MODULE$.scalaArrayIsSized()).size(1);
                    ContentFeatureSource fs = ds.getFeatureSource(format);
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> fs).must((Function0 & Serializable & scala.Serializable)() -> this.not((Matcher)this.beNull()));
                    this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> fs.getCount(Query.ALL)).must((Function0 & Serializable & scala.Serializable)() -> this.beEqualTo((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 10));
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> fs.getBounds()).must((Function0 & Serializable & scala.Serializable)() -> this.equalTo((Function0 & Serializable & scala.Serializable)() -> new ReferencedEnvelope(10.0, 10.0, 10.0, 10.9, org.locationtech.geomesa.utils.geotools.package$.MODULE$.CRS_EPSG_4326())));
                    List results = SelfClosingIterator$.MODULE$.apply(fs.getFeatures(new Query(format)).features()).toList();
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> results).must((Function0 & Serializable & scala.Serializable)() -> this.containTheSameElementsAs(features, this.containTheSameElementsAs$default$2()));
                    DataStore ds2 = DataStoreFinder.getDataStore((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)dsParams).asJava()));
                    SimpleFeatureSource fs2 = ds2.getFeatureSource(format);
                    this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> fs2.getCount(Query.ALL)).must((Function0 & Serializable & scala.Serializable)() -> this.beEqualTo((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 10));
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> fs2.getBounds()).must((Function0 & Serializable & scala.Serializable)() -> this.equalTo((Function0 & Serializable & scala.Serializable)() -> new ReferencedEnvelope(10.0, 10.0, 10.0, 10.9, org.locationtech.geomesa.utils.geotools.package$.MODULE$.CRS_EPSG_4326())));
                }
                throw new MatchError((Object)tuple3);
            }, MatchResult$.MODULE$.matchResultAsResult()), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("create a second ds with the same path").$greater$greater((Function0 & Serializable & scala.Serializable)() -> this.foreach((Traversable)this.formats(), (Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple3 tuple3 = x0$3;
                if (tuple3 != null) {
                    String format = (String)tuple3._1();
                    Seq features = (Seq)tuple3._3();
                    File dir = (File)this.dirs().apply((Object)format);
                    DataStore ds = DataStoreFinder.getDataStore(Collections.singletonMap("fs.path", dir.getPath()));
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ds.getTypeNames())).toList()).must((Function0 & Serializable & scala.Serializable)() -> this.containTheSameElementsAs((Seq)new .colon.colon((Object)format, (List)Nil$.MODULE$), this.containTheSameElementsAs$default$2()));
                    List results = SelfClosingIterator$.MODULE$.apply(ds.getFeatureReader(new Query(format), Transaction.AUTO_COMMIT)).toList();
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> results).must((Function0 & Serializable & scala.Serializable)() -> this.containTheSameElementsAs(features, this.containTheSameElementsAs$default$2()));
                }
                throw new MatchError((Object)tuple3);
            }, MatchResult$.MODULE$.matchResultAsResult()), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("query with multiple threads").$greater$greater((Function0 & Serializable & scala.Serializable)() -> this.foreach((Traversable)this.formats(), (Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple3 tuple3 = x0$4;
                if (tuple3 != null) {
                    String format = (String)tuple3._1();
                    SimpleFeatureType sft = (SimpleFeatureType)tuple3._2();
                    Seq features = (Seq)tuple3._3();
                    File dir = (File)this.dirs().apply((Object)format);
                    DataStore ds = DataStoreFinder.getDataStore((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.path"), (Object)dir.getPath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.read-threads"), (Object)"4")}))).asJava()));
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ds.getTypeNames())).toList()).must((Function0 & Serializable & scala.Serializable)() -> this.containTheSameElementsAs((Seq)new .colon.colon((Object)format, (List)Nil$.MODULE$), this.containTheSameElementsAs$default$2()));
                    List results = SelfClosingIterator$.MODULE$.apply(ds.getFeatureReader(new Query(format), Transaction.AUTO_COMMIT)).toList();
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> results).must((Function0 & Serializable & scala.Serializable)() -> this.containTheSameElementsAs(features, this.containTheSameElementsAs$default$2()));
                    DataStore dsWithNs = DataStoreFinder.getDataStore((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.path"), (Object)dir.getPath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.read-threads"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"namespace"), (Object)"ns0")}))).asJava()));
                    Name name = dsWithNs.getSchema(sft.getTypeName()).getName();
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> name.getNamespaceURI()).mustEqual((Function0 & Serializable & scala.Serializable)() -> "ns0");
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> name.getLocalPart()).mustEqual((Function0 & Serializable & scala.Serializable)() -> sft.getTypeName());
                    Seq queries = (Seq)new .colon.colon((Object)new Query(sft.getTypeName()), (List)new .colon.colon((Object)new Query(sft.getTypeName(), (Filter)Filter.INCLUDE, new String[]{"geom"}), (List)Nil$.MODULE$));
                    return this.foreach((Traversable)queries, (Function1 & Serializable & scala.Serializable)query -> {
                        FeatureReader reader = dsWithNs.getFeatureReader(query, Transaction.AUTO_COMMIT);
                        this.theValue((Function0 & Serializable & scala.Serializable)() -> reader.getFeatureType().getName()).mustEqual((Function0 & Serializable & scala.Serializable)() -> name);
                        List features = SelfClosingIterator$.MODULE$.apply(reader).toList();
                        this.theValue((Function0 & Serializable & scala.Serializable)() -> features).must((Function0 & Serializable & scala.Serializable)() -> this.not(this.beEmpty((Function1)Predef$.MODULE$.$conforms())));
                        return this.foreach((Traversable)features, (Function1 & Serializable & scala.Serializable)x$6 -> this.theValue((Function0 & Serializable & scala.Serializable)() -> x$6.getFeatureType().getName()).mustEqual((Function0 & Serializable & scala.Serializable)() -> name), MatchResult$.MODULE$.matchResultAsResult());
                    }, MatchResult$.MODULE$.matchResultAsResult());
                }
                throw new MatchError((Object)tuple3);
            }, MatchResult$.MODULE$.matchResultAsResult()), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("support query timeouts").$greater$greater((Function0 & Serializable & scala.Serializable)() -> this.foreach((Traversable)this.formats(), (Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple3 tuple3 = x0$5;
                if (tuple3 != null) {
                    MatchResult matchResult;
                    String format = (String)tuple3._1();
                    File dir = (File)this.dirs().apply((Object)format);
                    java.util.Map<String, String> params = java.util.Map.of("fs.path", dir.getPath(), "fs.read-threads", "2", "geomesa.query.timeout", "200ms");
                    DataStore ds = DataStoreFinder.getDataStore(params);
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ds.getTypeNames())).toList()).must((Function0 & Serializable & scala.Serializable)() -> this.containTheSameElementsAs((Seq)new .colon.colon((Object)format, (List)Nil$.MODULE$), this.containTheSameElementsAs$default$2()));
                    try (FeatureReader reader = ds.getFeatureReader(new Query(format), Transaction.AUTO_COMMIT);){
                        matchResult = (MatchResult)this.eventually(10, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(200)).millis(), (Function0 & Serializable & scala.Serializable)() -> {
                            this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> reader.hasNext()).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                            return this.theValue((Function0 & Serializable & scala.Serializable)() -> (SimpleFeature)reader.next()).must((Function0 & Serializable & scala.Serializable)() -> this.throwA(ClassTag$.MODULE$.apply(RuntimeException.class)));
                        }, MatchResult$.MODULE$.matchResultAsResult());
                    }
                    return matchResult;
                }
                throw new MatchError((Object)tuple3);
            }, MatchResult$.MODULE$.matchResultAsResult()), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("call create schema on existing type").$greater$greater((Function0 & Serializable & scala.Serializable)() -> this.foreach((Traversable)this.formats(), (Function1 & Serializable & scala.Serializable)x0$6 -> {
                Tuple3 tuple3 = x0$6;
                if (tuple3 != null) {
                    String format = (String)tuple3._1();
                    File dir = (File)this.dirs().apply((Object)format);
                    DataStore ds = DataStoreFinder.getDataStore(Collections.singletonMap("fs.path", dir.getPath()));
                    SimpleFeatureType sameSft = SimpleFeatureTypes$.MODULE$.createType(format, "name:String,age:Int,dtg:Date,*geom:Point:srid=4326");
                    SimpleFeatureType qual$1 = package$.MODULE$.RichSimpleFeatureType(sameSft);
                    String x$1 = "daily";
                    scala.collection.immutable.Map x$2 = package.RichSimpleFeatureType$.MODULE$.setScheme$default$2$extension(qual$1);
                    package.RichSimpleFeatureType$.MODULE$.setScheme$extension(qual$1, x$1, x$2);
                    return this.theValue((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.createSchema((FeatureType)sameSft)).must((Function0 & Serializable & scala.Serializable)() -> this.not((Matcher)this.throwA(ClassTag$.MODULE$.apply(Throwable.class))));
                }
                throw new MatchError((Object)tuple3);
            }, MatchResult$.MODULE$.matchResultAsResult()), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("not modify feature type in create schema").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                MatchResult matchResult;
                String format = (String)((Tuple3)this.formats().head())._1();
                File dir = Files.createTempDirectory(new StringBuilder(10).append("fsds-test-").append(format).toString(), new FileAttribute[0]).toFile();
                try {
                    SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType(format, "name:String,age:Int,dtg:Date,*geom:Point:srid=4326");
                    SimpleFeatureType qual$2 = package$.MODULE$.RichSimpleFeatureType(sft);
                    String x$3 = "daily";
                    scala.collection.immutable.Map x$4 = package.RichSimpleFeatureType$.MODULE$.setScheme$default$2$extension(qual$2);
                    package.RichSimpleFeatureType$.MODULE$.setScheme$extension(qual$2, x$3, x$4);
                    package.RichSimpleFeatureType$.MODULE$.setEncoding$extension(package$.MODULE$.RichSimpleFeatureType(sft), format);
                    package.WithClose$.MODULE$.apply((Object)DataStoreFinder.getDataStore(Collections.singletonMap("fs.path", dir.getPath())), (Function1 & Serializable & scala.Serializable)ds -> {
                        ds.createSchema((FeatureType)sft);
                        return BoxedUnit.UNIT;
                    }, (IsCloseable)IsCloseable$.MODULE$.dataStoreIsCloseable());
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> package.RichSimpleFeatureType$.MODULE$.removeScheme$extension(package$.MODULE$.RichSimpleFeatureType(sft))).must((Function0 & Serializable & scala.Serializable)() -> this.beSome((ValueCheck)ValueCheck$.MODULE$.typedValueCheck((Object)new package.NamedOptions("daily", Predef$.MODULE$.Map().empty()), Diffable$.MODULE$.fallbackDiffable())));
                    matchResult = this.theValue((Function0 & Serializable & scala.Serializable)() -> package.RichSimpleFeatureType$.MODULE$.removeEncoding$extension(package$.MODULE$.RichSimpleFeatureType(sft))).must((Function0 & Serializable & scala.Serializable)() -> this.beSome((ValueCheck)ValueCheck$.MODULE$.typedValueCheck((Object)format, Diffable$.MODULE$.stringDiffable())));
                }
                finally {
                    FileUtils.deleteDirectory((File)dir);
                }
                return matchResult;
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("reject schemas with reserved words").$greater$greater((Function0 & Serializable & scala.Serializable)() -> this.foreach((Traversable)this.formats(), (Function1 & Serializable & scala.Serializable)x0$7 -> {
                Tuple3 tuple3 = x0$7;
                if (tuple3 != null) {
                    String format = (String)tuple3._1();
                    File dir = (File)this.dirs().apply((Object)format);
                    SimpleFeatureType reserved = SimpleFeatureTypes$.MODULE$.createType("reserved", "dtg:Date,*point:Point:srid=4326");
                    SimpleFeatureType qual$3 = package$.MODULE$.RichSimpleFeatureType(reserved);
                    String x$5 = "daily";
                    scala.collection.immutable.Map x$6 = package.RichSimpleFeatureType$.MODULE$.setScheme$default$2$extension(qual$3);
                    package.RichSimpleFeatureType$.MODULE$.setScheme$extension(qual$3, x$5, x$6);
                    DataStore ds = DataStoreFinder.getDataStore((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.path"), (Object)dir.getPath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.encoding"), (Object)format), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.config.xml"), (Object)this.gzip())}))).asJava()));
                    this.theValue((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.createSchema((FeatureType)reserved)).must((Function0 & Serializable & scala.Serializable)() -> this.throwAn(ClassTag$.MODULE$.apply(IllegalArgumentException.class)));
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> ds.getSchema(reserved.getTypeName())).must((Function0 & Serializable & scala.Serializable)() -> this.throwAn(ClassTag$.MODULE$.apply(IOException.class)));
                }
                throw new MatchError((Object)tuple3);
            }, MatchResult$.MODULE$.matchResultAsResult()), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("support transforms").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                Seq transforms = (Seq)new .colon.colon(null, (List)new .colon.colon((Object)((String[])((Object[])new String[]{"name"})), (List)new .colon.colon((Object)((String[])((Object[])new String[]{"dtg", "geom"})), (List)Nil$.MODULE$)));
                return this.foreach((Traversable)this.formats(), (Function1 & Serializable & scala.Serializable)x0$8 -> {
                    Tuple3 tuple3 = x0$8;
                    if (tuple3 != null) {
                        String format = (String)tuple3._1();
                        Seq features = (Seq)tuple3._3();
                        File dir = (File)this.dirs().apply((Object)format);
                        DataStore ds = DataStoreFinder.getDataStore(Collections.singletonMap("fs.path", dir.getPath()));
                        this.filters().foreach((Function1 & Serializable & scala.Serializable)filter -> {
                            transforms.foreach((Function1 & Serializable & scala.Serializable)transform -> {
                                Query query = new Query(format$6, filter, transform);
                                List results = SelfClosingIterator$.MODULE$.apply(ds$7.getFeatureReader(query, Transaction.AUTO_COMMIT)).toList();
                                $this.theValue((Function0 & Serializable & scala.Serializable)() -> results).must((Function0 & Serializable & scala.Serializable)() -> $this.haveLength(features$5.length(), Sized$.MODULE$.scalaTraversableIsSized()));
                                if (transform == null) {
                                    return $this.theValue((Function0 & Serializable & scala.Serializable)() -> results).must((Function0 & Serializable & scala.Serializable)() -> $this.containTheSameElementsAs(features$5, $this.containTheSameElementsAs$default$2()));
                                }
                                $this.theValue((Function0 & Serializable & scala.Serializable)() -> (List)results.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getID(), List$.MODULE$.canBuildFrom())).must((Function0 & Serializable & scala.Serializable)() -> $this.containTheSameElementsAs((Seq)features$5.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getID(), Seq$.MODULE$.canBuildFrom()), $this.containTheSameElementsAs$default$2()));
                                results.foreach((Function1 & Serializable & scala.Serializable)result -> {
                                    FileSystemDataStoreTest.$anonfun$new$99($this, transform, features$5, result);
                                    return BoxedUnit.UNIT;
                                });
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                        return this.ok();
                    }
                    throw new MatchError((Object)tuple3);
                }, MatchResult$.MODULE$.matchResultAsResult());
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("support append without fid").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                Seq formats = (Seq)this.encodings().map((Function1 & Serializable & scala.Serializable)x$10 -> this.createFormat((String)x$10, this.createFormat$default$2(), this.createFormat$default$3()), Seq$.MODULE$.canBuildFrom());
                return this.foreach((Traversable)formats, (Function1 & Serializable & scala.Serializable)x0$9 -> {
                    Tuple3 tuple3 = x0$9;
                    if (tuple3 != null) {
                        String format = (String)tuple3._1();
                        SimpleFeatureType sft = (SimpleFeatureType)tuple3._2();
                        Seq features = (Seq)tuple3._3();
                        File dir = Files.createTempDirectory(new StringBuilder(29).append("fsds-test-append-without-fid-").append(format).toString(), new FileAttribute[0]).toFile();
                        this.dirs().put((Object)dir.getName(), (Object)dir);
                        scala.collection.immutable.Map dsParams = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.path"), (Object)dir.getPath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.encoding"), (Object)format), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.config.xml"), (Object)this.gzip())}));
                        FileSystemDataStore ds = (FileSystemDataStore)DataStoreFinder.getDataStore((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)dsParams).asJava()));
                        ds.createSchema(sft);
                        package.WithClose$.MODULE$.apply((Object)ds.getFeatureWriterAppend(format, Transaction.AUTO_COMMIT), (Function1 & Serializable & scala.Serializable)writer -> {
                            features.foreach((Function1 & Serializable & scala.Serializable)feature -> {
                                ScalaSimpleFeature featureWithEmptyFid = ScalaSimpleFeature$.MODULE$.copy(feature);
                                featureWithEmptyFid.setId("");
                                return FeatureUtils$.MODULE$.write(writer, (SimpleFeature)featureWithEmptyFid, FeatureUtils$.MODULE$.write$default$3());
                            });
                            return BoxedUnit.UNIT;
                        }, IsCloseable$.MODULE$.closeableIsCloseable());
                        List results = SelfClosingIterator$.MODULE$.apply(ds.getFeatureReader(new Query(format), Transaction.AUTO_COMMIT)).toList();
                        return this.theValue((Function0 & Serializable & scala.Serializable)() -> (List)results.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.getID(), List$.MODULE$.canBuildFrom())).must((Function0 & Serializable & scala.Serializable)() -> this.contain(this.allOf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ValueCheck[]{this.matcherIsValueCheck(this.beUUID())}))));
                    }
                    throw new MatchError((Object)tuple3);
                }, MatchResult$.MODULE$.matchResultAsResult());
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("support updates").$greater$greater((Function0 & Serializable & scala.Serializable)() -> this.foreach((Traversable)this.formats(), (Function1 & Serializable & scala.Serializable)x0$10 -> {
                Tuple3 tuple3 = x0$10;
                if (tuple3 != null) {
                    String format = (String)tuple3._1();
                    Seq features = (Seq)tuple3._3();
                    scala.collection.immutable.Map dsParams = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.path"), (Object)((File)this.dirs().apply((Object)format)).getPath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.config.xml"), (Object)this.gzip())}));
                    FileSystemDataStore ds = (FileSystemDataStore)DataStoreFinder.getDataStore((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)dsParams).asJava()));
                    package.WithClose$.MODULE$.apply((Object)ds.getFeatureWriter(format, ECQL.toFilter((String)"IN ('0', '1', '2')"), Transaction.AUTO_COMMIT), (Function1 & Serializable & scala.Serializable)writer -> {
                        this.foreach((Traversable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2), (Function1 & Serializable & scala.Serializable)x$12 -> FileSystemDataStoreTest.$anonfun$new$117(this, writer, BoxesRunTime.unboxToInt((Object)x$12)), MatchResult$.MODULE$.matchResultAsResult());
                        return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> writer.hasNext()).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                    }, IsCloseable$.MODULE$.closeableIsCloseable());
                    Seq expected = (Seq)((TraversableLike)features.drop(1)).map((Function1 & Serializable & scala.Serializable)in -> ScalaSimpleFeature$.MODULE$.copy(in), Seq$.MODULE$.canBuildFrom());
                    ((AbstractSimpleFeature.AbstractMutableSimpleFeature)expected.head()).setAttribute("dtg", (Object)"2017-06-05T04:03:02.0001Z");
                    ((AbstractSimpleFeature.AbstractMutableSimpleFeature)expected.apply(1)).setAttribute("name", (Object)"test0");
                    return this.foreach((Traversable)this.filters(), (Function1 & Serializable & scala.Serializable)filter -> {
                        Query query = new Query(format, filter);
                        List results = SelfClosingIterator$.MODULE$.apply(ds.getFeatureReader(query, Transaction.AUTO_COMMIT)).toList();
                        return this.theValue((Function0 & Serializable & scala.Serializable)() -> results).must((Function0 & Serializable & scala.Serializable)() -> this.containTheSameElementsAs(expected, this.containTheSameElementsAs$default$2()));
                    }, MatchResult$.MODULE$.matchResultAsResult());
                }
                throw new MatchError((Object)tuple3);
            }, MatchResult$.MODULE$.matchResultAsResult()), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            return this.blockExample("support different geometry types").in((Function0 & Serializable & scala.Serializable)() -> {
                Seq types = (Seq)new .colon.colon((Object)new Tuple2((Object)"LineString", (Function1 & Serializable & scala.Serializable)i -> this.createLine(BoxesRunTime.unboxToInt((Object)i))), (List)new .colon.colon((Object)new Tuple2((Object)"Polygon", (Function1 & Serializable & scala.Serializable)i -> this.createPolygon(BoxesRunTime.unboxToInt((Object)i))), (List)new .colon.colon((Object)new Tuple2((Object)"Geometry", (Function1 & Serializable & scala.Serializable)i -> FileSystemDataStoreTest.$anonfun$new$129(this, BoxesRunTime.unboxToInt((Object)i))), (List)Nil$.MODULE$)));
                Seq all = (Seq)types.flatMap((Function1 & Serializable & scala.Serializable)x0$11 -> {
                    Tuple2 tuple2 = x0$11;
                    if (tuple2 != null) {
                        String geom = (String)tuple2._1();
                        Function1 createGeom = (Function1)tuple2._2();
                        return (Seq)this.encodings().map((Function1 & Serializable & scala.Serializable)x$13 -> this.createFormat((String)x$13, geom, (Function1<Object, String>)createGeom), Seq$.MODULE$.canBuildFrom());
                    }
                    throw new MatchError((Object)tuple2);
                }, Seq$.MODULE$.canBuildFrom());
                return this.foreach((Traversable)all, (Function1 & Serializable & scala.Serializable)x0$12 -> {
                    Tuple3 tuple3 = x0$12;
                    if (tuple3 != null) {
                        MatchResult matchResult;
                        String format = (String)tuple3._1();
                        SimpleFeatureType sft = (SimpleFeatureType)tuple3._2();
                        Seq features = (Seq)tuple3._3();
                        File dir = Files.createTempDirectory(new StringBuilder(10).append("fsds-test-").append(format).toString(), new FileAttribute[0]).toFile();
                        try {
                            scala.collection.immutable.Map dsParams = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.path"), (Object)dir.getPath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.encoding"), (Object)format), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.config.xml"), (Object)this.gzip())}));
                            FileSystemDataStore ds = (FileSystemDataStore)DataStoreFinder.getDataStore((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)dsParams).asJava()));
                            this.theValue((Function0 & Serializable & scala.Serializable)() -> ds).must((Function0 & Serializable & scala.Serializable)() -> this.not((Matcher)this.beNull()));
                            try {
                                sft.getUserData().put("geomesa.mixed.geometries", "true");
                                ds.createSchema(sft);
                                package.WithClose$.MODULE$.apply((Object)ds.getFeatureWriterAppend(format, Transaction.AUTO_COMMIT), (Function1 & Serializable & scala.Serializable)writer -> {
                                    features.foreach((Function1 & Serializable & scala.Serializable)x$14 -> FeatureUtils$.MODULE$.write(writer, x$14, true));
                                    return BoxedUnit.UNIT;
                                }, IsCloseable$.MODULE$.closeableIsCloseable());
                                this.sized(this.theValue((Function0 & Serializable & scala.Serializable)() -> ds.getTypeNames()).must((Function0 & Serializable & scala.Serializable)() -> this.have()), Sized$.MODULE$.scalaArrayIsSized()).size(1);
                                ContentFeatureSource fs = ds.getFeatureSource(format);
                                this.theValue((Function0 & Serializable & scala.Serializable)() -> fs).must((Function0 & Serializable & scala.Serializable)() -> this.not((Matcher)this.beNull()));
                                this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> fs.getCount(Query.ALL)).must((Function0 & Serializable & scala.Serializable)() -> this.beEqualTo((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 10));
                                ReferencedEnvelope env = new ReferencedEnvelope(org.locationtech.geomesa.utils.geotools.package$.MODULE$.CRS_EPSG_4326());
                                features.foreach((Function1 & Serializable & scala.Serializable)f -> {
                                    env.expandToInclude(((Geometry)f.getDefaultGeometry()).getEnvelopeInternal());
                                    return BoxedUnit.UNIT;
                                });
                                this.theValue((Function0 & Serializable & scala.Serializable)() -> fs.getBounds()).mustEqual((Function0 & Serializable & scala.Serializable)() -> env);
                                matchResult = this.foreach((Traversable)new .colon.colon((Object)"INCLUDE", (List)new .colon.colon((Object)new StringBuilder(14).append("bbox(geom,").append(env.getMinX()).append(",").append(env.getMinY()).append(",").append(env.getMaxX()).append(",").append(env.getMaxY()).append(")").toString(), (List)Nil$.MODULE$)), (Function1 & Serializable & scala.Serializable)filter -> {
                                    Query query = new Query(format, ECQL.toFilter((String)filter));
                                    this.theValue((Function0 & Serializable & scala.Serializable)() -> SelfClosingIterator$.MODULE$.apply(fs.getFeatures(query).features()).toList()).must((Function0 & Serializable & scala.Serializable)() -> this.containTheSameElementsAs(features, this.containTheSameElementsAs$default$2()));
                                    Query transform = new Query(format, ECQL.toFilter((String)filter), new String[]{"dtg", "geom"});
                                    SimpleFeatureType transformSft = SimpleFeatureTypes$.MODULE$.createType(format, new StringBuilder(15).append("dtg:Date,*geom:").append(sft.getGeometryDescriptor().getType().getBinding().getSimpleName()).toString());
                                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> SelfClosingIterator$.MODULE$.apply(fs.getFeatures(transform).features()).toList()).must((Function0 & Serializable & scala.Serializable)() -> this.containTheSameElementsAs((Seq)features.map((Function1 & Serializable & scala.Serializable)x$15 -> ScalaSimpleFeature$.MODULE$.retype(transformSft, x$15), Seq$.MODULE$.canBuildFrom()), this.containTheSameElementsAs$default$2()));
                                }, MatchResult$.MODULE$.matchResultAsResult());
                            }
                            finally {
                                ds.dispose();
                            }
                        }
                        finally {
                            FileUtils.deleteDirectory((File)dir);
                        }
                        return matchResult;
                    }
                    throw new MatchError((Object)tuple3);
                }, MatchResult$.MODULE$.matchResultAsResult());
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
        });
        this.step((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.dirs().foreach((Function1 & Serializable & scala.Serializable)x0$13 -> {
            FileSystemDataStoreTest.$anonfun$new$154(x0$13);
            return BoxedUnit.UNIT;
        }));
    }
}

