/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.geomesa.testcontainers.HadoopContainer;
import org.testcontainers.utility.DockerImageName;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Try;
import scala.util.Try$;

public final class HadoopSharedCluster$
implements StrictLogging {
    public static HadoopSharedCluster$ MODULE$;
    private HadoopContainer Container;
    private Configuration ContainerConfiguration;
    private String ContainerConfig;
    private Try<HadoopContainer> tryContainer;
    private final DockerImageName ImageName;
    private final AtomicBoolean initialized;
    private final Logger logger;
    private volatile byte bitmap$0;

    static {
        new HadoopSharedCluster$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public DockerImageName ImageName() {
        return this.ImageName;
    }

    private HadoopContainer Container$lzycompute() {
        HadoopSharedCluster$ hadoopSharedCluster$ = this;
        synchronized (hadoopSharedCluster$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.Container = (HadoopContainer)this.tryContainer().get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.Container;
    }

    public HadoopContainer Container() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.Container$lzycompute();
        }
        return this.Container;
    }

    /*
     * WARNING - void declaration
     */
    private Configuration ContainerConfiguration$lzycompute() {
        HadoopSharedCluster$ hadoopSharedCluster$ = this;
        synchronized (hadoopSharedCluster$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                void var2_2;
                Configuration conf = new Configuration(false);
                conf.addResource((InputStream)new ByteArrayInputStream(this.Container().getConfigurationXml().getBytes(StandardCharsets.UTF_8)), "");
                conf.set("parquet.compression", "GZIP", "");
                this.ContainerConfiguration = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.ContainerConfiguration;
    }

    public Configuration ContainerConfiguration() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.ContainerConfiguration$lzycompute();
        }
        return this.ContainerConfiguration;
    }

    private String ContainerConfig$lzycompute() {
        HadoopSharedCluster$ hadoopSharedCluster$ = this;
        synchronized (hadoopSharedCluster$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                StringWriter writer = new StringWriter();
                this.ContainerConfiguration().writeXml((Writer)writer);
                this.ContainerConfig = writer.toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.ContainerConfig;
    }

    public String ContainerConfig() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.ContainerConfig$lzycompute();
        }
        return this.ContainerConfig;
    }

    private Try<HadoopContainer> tryContainer$lzycompute() {
        HadoopSharedCluster$ hadoopSharedCluster$ = this;
        synchronized (hadoopSharedCluster$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.tryContainer = Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> {
                    BoxedUnit boxedUnit;
                    BoxedUnit boxedUnit2;
                    if (MODULE$.logger().underlying().isInfoEnabled()) {
                        MODULE$.logger().underlying().info("Starting Hadoop container");
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    HadoopContainer container = new HadoopContainer(MODULE$.ImageName());
                    MODULE$.initialized().getAndSet(true);
                    container.start();
                    if (MODULE$.logger().underlying().isInfoEnabled()) {
                        MODULE$.logger().underlying().info("Started Hadoop container");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return container;
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.tryContainer;
    }

    private Try<HadoopContainer> tryContainer() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.tryContainer$lzycompute();
        }
        return this.tryContainer;
    }

    private AtomicBoolean initialized() {
        return this.initialized;
    }

    private HadoopSharedCluster$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.ImageName = DockerImageName.parse((String)"ghcr.io/geomesa/accumulo-uno").withTag((String)package$.MODULE$.props().getOrElse((Object)"accumulo.docker.tag", (Function0 & java.io.Serializable & Serializable)() -> "2.1.3"));
        this.initialized = new AtomicBoolean(false);
        package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            if (MODULE$.initialized().get()) {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("Stopping Hadoop container");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                MODULE$.tryContainer().foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
                    x$1.stop();
                    return BoxedUnit.UNIT;
                });
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("Stopped Hadoop container");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
        });
    }
}

