/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.converter;

import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.function.Consumer;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.data.Query;
import org.geotools.api.data.Transaction;
import org.geotools.api.filter.Filter;
import org.junit.runner.RunWith;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.slf4j.LoggerFactory;
import org.specs2.data.Sized$;
import org.specs2.matcher.MatchResult;
import org.specs2.matcher.MatchResult$;
import org.specs2.matcher.Matcher;
import org.specs2.mutable.Specification;
import org.specs2.runner.JUnitRunner;
import org.specs2.specification.BeforeAfterAll;
import org.specs2.specification.core.AsExecution$;
import org.specs2.specification.core.Fragments;
import org.specs2.specification.core.SpecificationStructure;
import org.testcontainers.containers.MinIOContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.utility.DockerImageName;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001\u0002\t\u0012\u0001qAQa\u000b\u0001\u0005\u00021B\u0011b\f\u0001A\u0002\u0003\u0007I\u0011\u0001\u0019\t\u0013e\u0002\u0001\u0019!a\u0001\n\u0003Q\u0004\"C\"\u0001\u0001\u0004\u0005\t\u0015)\u00032\u0011\u001d!\u0005A1A\u0005\u0002\u0015CaA\u0014\u0001!\u0002\u00131\u0005\"B(\u0001\t\u0003\u0002\u0006\"B)\u0001\t\u0003\u0002\u0006\"\u0002*\u0001\t\u0003\u0019\u0006\"B1\u0001\t\u0003\u0011\u0007\"B3\u0001\t\u00031\u0007\"B5\u0001\t\u0003Q\u0007\"B8\u0001\t\u0013\u0001\bbBA\u000b\u0001\u0011%\u0011q\u0003\u0005\b\u0003C\u0001A\u0011BA\u0012\u0005Y\u0019uN\u001c<feR,'\u000fR1uCN#xN]3UKN$(B\u0001\n\u0014\u0003%\u0019wN\u001c<feR,'O\u0003\u0002\u0015+\u0005\u0011am\u001d\u0006\u0003-]\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\u00193\u0005aAn\\2bi&|g\u000e^3dQ*\t!$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001;\u0015\u0002\"AH\u0012\u000e\u0003}Q!\u0001I\u0011\u0002\u000f5,H/\u00192mK*\u0011!%G\u0001\u0007gB,7m\u001d\u001a\n\u0005\u0011z\"!D*qK\u000eLg-[2bi&|g\u000e\u0005\u0002'S5\tqE\u0003\u0002)C\u0005i1\u000f]3dS\u001aL7-\u0019;j_:L!AK\u0014\u0003\u001d\t+gm\u001c:f\u0003\u001a$XM]!mY\u00061A(\u001b8jiz\"\u0012!\f\t\u0003]\u0001i\u0011!E\u0001\u0006[&t\u0017n\\\u000b\u0002cA\u0011!gN\u0007\u0002g)\u0011A'N\u0001\u000bG>tG/Y5oKJ\u001c(B\u0001\u001c\u001a\u00039!Xm\u001d;d_:$\u0018-\u001b8feNL!\u0001O\u001a\u0003\u001d5Kg.S(D_:$\u0018-\u001b8fe\u0006IQ.\u001b8j_~#S-\u001d\u000b\u0003w\u0005\u0003\"\u0001P \u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012A!\u00168ji\"9!iAA\u0001\u0002\u0004\t\u0014a\u0001=%c\u00051Q.\u001b8j_\u0002\naAY;dW\u0016$X#\u0001$\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015\u0001\u00027b]\u001eT\u0011aS\u0001\u0005U\u00064\u0018-\u0003\u0002N\u0011\n11\u000b\u001e:j]\u001e\fqAY;dW\u0016$\b%A\u0005cK\u001a|'/Z!mYR\t1(\u0001\u0005bMR,'/\u00117m\u0003!17oQ8oM&<Gc\u0001+_?B\u0011Q\u000b\u0018\b\u0003-j\u0003\"aV\u001f\u000e\u0003aS!!W\u000e\u0002\rq\u0012xn\u001c;?\u0013\tYV(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001bvS!aW\u001f\t\u000bII\u0001\u0019\u0001+\t\u000b\u0001L\u0001\u0019\u0001+\u0002\tA\fG\u000f[\u0001\ng\u001a$()\u001f(b[\u0016$\"\u0001V2\t\u000b\u0011T\u0001\u0019\u0001+\u0002\t9\fW.Z\u0001\ng\u001a$()_\"p]\u001a$\"\u0001V4\t\u000b!\\\u0001\u0019\u0001+\u0002\t\r|gNZ\u0001\u0005aJ|\u0007\u000fF\u0002UW6DQ\u0001\u001c\u0007A\u0002Q\u000b1a[3z\u0011\u0015qG\u00021\u0001U\u0003\u00151\u0018\r\\;f\u0003)9(/\u001b;f!2\f\u0017N\u001c\u000b\u0007wEdX0a\u0003\t\u000bIl\u0001\u0019A:\u0002\u0005\u0019\u001c\u0007C\u0001;{\u001b\u0005)(B\u0001\u000bw\u0015\t9\b0\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0003sf\ta!\u00199bG\",\u0017BA>v\u0005-1\u0015\u000e\\3D_:$X\r\u001f;\t\u000b\u0001l\u0001\u0019\u0001+\t\u000byl\u0001\u0019A@\u0002\u0011\r|g\u000e^3oiN\u0004R\u0001PA\u0001\u0003\u000bI1!a\u0001>\u0005\u0015\t%O]1z!\ra\u0014qA\u0005\u0004\u0003\u0013i$\u0001\u0002\"zi\u0016Dq!!\u0004\u000e\u0001\u0004\ty!\u0001\u0006nk2$\u0018\u000e\u001d7jKJ\u00042\u0001PA\t\u0013\r\t\u0019\"\u0010\u0002\u0004\u0013:$\u0018\u0001D<sSR,\u0007\u000b\\1j]\u001eSH#C\u001e\u0002\u001a\u0005m\u0011QDA\u0010\u0011\u0015\u0011h\u00021\u0001t\u0011\u0015\u0001g\u00021\u0001U\u0011\u0015qh\u00021\u0001\u0000\u0011\u001d\tiA\u0004a\u0001\u0003\u001f\t!b\u001e:ji\u0016$\u0016M]${)%Y\u0014QEA\u0014\u0003S\tY\u0003C\u0003s\u001f\u0001\u00071\u000fC\u0003a\u001f\u0001\u0007A\u000bC\u0003\u007f\u001f\u0001\u0007q\u0010C\u0004\u0002\u000e=\u0001\r!a\u0004)\r\u0001\tyC\\A !\u0011\t\t$a\u000f\u000e\u0005\u0005M\"\u0002BA\u001b\u0003o\taA];o]\u0016\u0014(bAA\u001d3\u0005)!.\u001e8ji&!\u0011QHA\u001a\u0005\u001d\u0011VO\\,ji\"\u001c#!!\u0011\u0011\t\u0005\r\u0013qI\u0007\u0003\u0003\u000bR1!!\u000e\"\u0013\u0011\tI%!\u0012\u0003\u0017)+f.\u001b;Sk:tWM\u001d")
public class ConverterDataStoreTest
extends Specification
implements BeforeAfterAll {
    private MinIOContainer minio;
    private final String bucket;

    public /* synthetic */ Fragments org$specs2$specification$BeforeAfterAll$$super$map(Function0 fs) {
        return SpecificationStructure.map$((SpecificationStructure)this, (Function0)fs);
    }

    public Fragments map(Function0<Fragments> fs) {
        return BeforeAfterAll.map$((BeforeAfterAll)this, fs);
    }

    public MinIOContainer minio() {
        return this.minio;
    }

    public void minio_$eq(MinIOContainer x$1) {
        this.minio = x$1;
    }

    public String bucket() {
        return this.bucket;
    }

    public void beforeAll() {
        this.minio_$eq(new MinIOContainer(DockerImageName.parse((String)"minio/minio").withTag((String)scala.sys.package$.MODULE$.props().getOrElse((Object)"minio.docker.tag", (Function0 & Serializable & scala.Serializable)() -> "RELEASE.2024-10-29T16-01-48Z"))));
        this.minio().start();
        this.minio().followOutput((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)"minio")));
        this.minio().execInContainer(new String[]{"mc", "alias", "set", "localhost", "http://localhost:9000", this.minio().getUserName(), this.minio().getPassword()});
        this.minio().execInContainer(new String[]{"mc", "mb", new StringBuilder(10).append("localhost/").append(this.bucket()).toString()});
    }

    public void afterAll() {
        if (this.minio() != null) {
            this.minio().close();
            return;
        }
    }

    public String fsConfig(String converter, String path) {
        Seq props = (Seq)new .colon.colon((Object)this.prop("fs.options.converter.path", path), (List)new .colon.colon((Object)this.prop("fs.partition-scheme.name", "datetime"), (List)new .colon.colon((Object)this.prop("fs.partition-scheme.opts.datetime-format", "yyyy/DDD/HH/mm"), (List)new .colon.colon((Object)this.prop("fs.partition-scheme.opts.step-unit", "MINUTES"), (List)new .colon.colon((Object)this.prop("fs.partition-scheme.opts.step", "15"), (List)new .colon.colon((Object)this.prop("fs.partition-scheme.opts.dtg-attribute", "dtg"), (List)new .colon.colon((Object)this.prop("fs.options.leaf-storage", "true"), (List)Nil$.MODULE$)))))));
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("<configuration>\n      |").append(converter).append("\n      |").append(props.mkString("\n")).append("\n      |</configuration>\n      |").toString())).stripMargin();
    }

    public String sftByName(String name) {
        return ((TraversableOnce)new .colon.colon((Object)this.prop("fs.options.sft.name", name), (List)new .colon.colon((Object)this.prop("fs.options.converter.name", name), (List)Nil$.MODULE$))).mkString("\n");
    }

    public String sftByConf(String conf) {
        return ((TraversableOnce)new .colon.colon((Object)this.prop("fs.options.sft.conf", conf), (List)new .colon.colon((Object)this.prop("fs.options.converter.conf", conf), (List)Nil$.MODULE$))).mkString("\n");
    }

    public String prop(String key, String value) {
        return new StringBuilder(51).append("  <property><name>").append(key).append("</name><value>").append(value).append("</value></property>").toString();
    }

    private void writePlain(FileContext fc, String path, byte[] contents, int multiplier) {
        package.WithClose$.MODULE$.apply((Object)fc.create(new Path(path), EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()}), (Function1 & Serializable & scala.Serializable)os -> {
            package.WithClose$.MODULE$.apply((Object)new BufferedOutputStream((OutputStream)os), (Function1 & Serializable & scala.Serializable)buf -> {
                ConverterDataStoreTest.$anonfun$writePlain$2(multiplier$2, contents$1, buf);
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
    }

    private void writePlainGz(FileContext fc, String path, byte[] contents, int multiplier) {
        package.WithClose$.MODULE$.apply((Object)fc.create(new Path(new StringBuilder(3).append(path).append(".gz").toString()), EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()}), (Function1 & Serializable & scala.Serializable)os -> {
            package.WithClose$.MODULE$.apply((Object)new BufferedOutputStream((OutputStream)os), (Function1 & Serializable & scala.Serializable)buf -> {
                package.WithClose$.MODULE$.apply((Object)new GzipCompressorOutputStream((OutputStream)buf), (Function1 & Serializable & scala.Serializable)gz -> {
                    ConverterDataStoreTest.$anonfun$writePlainGz$3(multiplier$3, contents$2, gz);
                    return BoxedUnit.UNIT;
                }, IsCloseable$.MODULE$.closeableIsCloseable());
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
    }

    private void writeTarGz(FileContext fc, String path, byte[] contents, int multiplier) {
        package.WithClose$.MODULE$.apply((Object)fc.create(new Path(new StringBuilder(4).append(path).append(".tgz").toString()), EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()}), (Function1 & Serializable & scala.Serializable)os -> {
            package.WithClose$.MODULE$.apply((Object)new BufferedOutputStream((OutputStream)os), (Function1 & Serializable & scala.Serializable)buf -> {
                package.WithClose$.MODULE$.apply((Object)new GzipCompressorOutputStream((OutputStream)buf), (Function1 & Serializable & scala.Serializable)gz -> {
                    package.WithClose$.MODULE$.apply((Object)new TarArchiveOutputStream((OutputStream)gz), (Function1 & Serializable & scala.Serializable)tar -> {
                        ConverterDataStoreTest.$anonfun$writeTarGz$4(contents$3, multiplier$4, tar);
                        return BoxedUnit.UNIT;
                    }, IsCloseable$.MODULE$.closeableIsCloseable());
                    return BoxedUnit.UNIT;
                }, IsCloseable$.MODULE$.closeableIsCloseable());
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public static final /* synthetic */ void $anonfun$new$22(ConverterDataStoreTest $this, FileContext fc$1, String bucket$1, int multiplier$1, String file) {
        String path = new StringBuilder(23).append("datastore1/2017/001/01/").append(file).toString();
        byte[] contents = (byte[])package.WithClose$.MODULE$.apply((Object)$this.getClass().getClassLoader().getResourceAsStream(new StringBuilder(8).append("example/").append(path).toString()), (Function1 & Serializable & scala.Serializable)x$1 -> IOUtils.toByteArray((InputStream)x$1), IsCloseable$.MODULE$.closeableIsCloseable());
        $this.writePlain(fc$1, new StringBuilder(0).append(bucket$1).append(path).toString(), contents, multiplier$1);
        $this.writePlainGz(fc$1, new StringBuilder(0).append(bucket$1).append(path).toString(), contents, multiplier$1);
        $this.writeTarGz(fc$1, new StringBuilder(0).append(bucket$1).append(path).toString(), contents, multiplier$1);
    }

    public static final /* synthetic */ MatchResult $anonfun$new$32(ConverterDataStoreTest $this, DataStore ds$3, boolean expectTimeout$1, int multiplier$1, int x$1) {
        int count;
        int n;
        try {
            Query q = new Query("fs-test", (Filter)Filter.INCLUDE);
            n = BoxesRunTime.unboxToInt((Object)package.WithClose$.MODULE$.apply((Object)CloseableIterator$.MODULE$.apply(ds$3.getFeatureReader(q, Transaction.AUTO_COMMIT)), (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.length()), IsCloseable$.MODULE$.closeableIsCloseable()));
        }
        catch (RuntimeException runtimeException) {
            n = count = -1;
        }
        if (expectTimeout$1) {
            return $this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> count).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1);
        }
        return $this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> count).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> multiplier$1 * 12);
    }

    public static final /* synthetic */ void $anonfun$writePlain$2(int multiplier$2, byte[] contents$1, BufferedOutputStream buf) {
        for (int i = 0; i < multiplier$2; ++i) {
            buf.write(contents$1);
        }
    }

    public static final /* synthetic */ void $anonfun$writePlainGz$3(int multiplier$3, byte[] contents$2, GzipCompressorOutputStream gz) {
        for (int i = 0; i < multiplier$3; ++i) {
            gz.write(contents$2);
        }
    }

    public static final /* synthetic */ void $anonfun$writeTarGz$4(byte[] contents$3, int multiplier$4, TarArchiveOutputStream tar) {
        TarArchiveEntry entry = new TarArchiveEntry("file");
        entry.setSize((long)(contents$3.length * multiplier$4));
        tar.putArchiveEntry(entry);
        for (int i = 0; i < multiplier$4; ++i) {
            tar.write(contents$3);
        }
        tar.closeArchiveEntry();
        tar.finish();
    }

    public ConverterDataStoreTest() {
        BeforeAfterAll.$init$((BeforeAfterAll)this);
        this.sequential();
        this.bucket = "geomesa";
        this.blockExample("ConverterDataStore").should((Function0 & Serializable & scala.Serializable)() -> {
            this.blockExample("work with one datastore").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                DataStore ds = DataStoreFinder.getDataStore((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.path"), (Object)this.getClass().getClassLoader().getResource("example").getFile()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.encoding"), (Object)"converter"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.config.xml"), (Object)this.fsConfig(this.sftByName("fs-test"), "datastore1"))}))).asJava()));
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ds).must((Function0 & Serializable & scala.Serializable)() -> this.not((Matcher)this.beNull()));
                String[] types = ds.getTypeNames();
                this.theValue((Function0 & Serializable & scala.Serializable)() -> types).must((Function0 & Serializable & scala.Serializable)() -> this.haveSize(1, Sized$.MODULE$.scalaArrayIsSized()));
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])types)).head()).mustEqual((Function0 & Serializable & scala.Serializable)() -> "fs-test");
                Query q = new Query("fs-test", (Filter)Filter.INCLUDE);
                List feats = SelfClosingIterator$.MODULE$.apply(ds.getFeatureReader(q, Transaction.AUTO_COMMIT)).toList();
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> feats).must((Function0 & Serializable & scala.Serializable)() -> this.haveLength(4, Sized$.MODULE$.scalaTraversableIsSized()));
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("work with something else").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                scala.collection.immutable.Map params = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.path"), (Object)this.getClass().getClassLoader().getResource("example").getFile()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.encoding"), (Object)"converter"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.config.xml"), (Object)this.fsConfig(this.sftByName("fs-test"), "datastore2"))}));
                return (MatchResult)package.WithClose$.MODULE$.apply((Object)DataStoreFinder.getDataStore((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)params).asJava())), (Function1 & Serializable & scala.Serializable)ds -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ds).must((Function0 & Serializable & scala.Serializable)() -> this.not((Matcher)this.beNull()));
                    String[] types = ds.getTypeNames();
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> types).must((Function0 & Serializable & scala.Serializable)() -> this.haveSize(1, Sized$.MODULE$.scalaArrayIsSized()));
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])types)).head()).mustEqual((Function0 & Serializable & scala.Serializable)() -> "fs-test");
                    Query q = new Query("fs-test", (Filter)Filter.INCLUDE);
                    List feats = SelfClosingIterator$.MODULE$.apply(ds.getFeatureReader(q, Transaction.AUTO_COMMIT)).toList();
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> feats).must((Function0 & Serializable & scala.Serializable)() -> this.haveLength(4, Sized$.MODULE$.scalaTraversableIsSized()));
                }, (IsCloseable)IsCloseable$.MODULE$.dataStoreIsCloseable());
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("read tar.gz files from s3 storage").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                String bucket = new StringBuilder(7).append("s3a://").append(this.bucket()).append("/").toString();
                String props = ((TraversableOnce)new .colon.colon((Object)this.sftByName("fs-test"), (List)new .colon.colon((Object)this.prop("fs.s3a.endpoint", this.minio().getS3URL()), (List)new .colon.colon((Object)this.prop("fs.s3a.access.key", this.minio().getUserName()), (List)new .colon.colon((Object)this.prop("fs.s3a.secret.key", this.minio().getPassword()), (List)new .colon.colon((Object)this.prop("fs.s3a.path.style.access", "true"), (List)new .colon.colon((Object)this.prop("dfs.client.use.datanode.hostname", "true"), (List)new .colon.colon((Object)this.prop("fs.s3a.connection.maximum", "20"), (List)Nil$.MODULE$)))))))).mkString("\n");
                String config = this.fsConfig(props, "datastore1");
                Configuration conf = new Configuration();
                conf.addResource((InputStream)new ByteArrayInputStream(config.getBytes(StandardCharsets.UTF_8)));
                FileContext fc = FileContext.getFileContext((Configuration)conf);
                int multiplier = 177156;
                ((IterableLike)new .colon.colon((Object)"00", (List)new .colon.colon((Object)"15", (List)new .colon.colon((Object)"30", (List)new .colon.colon((Object)"45", (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)file -> {
                    ConverterDataStoreTest.$anonfun$new$22(this, fc, bucket, multiplier, file);
                    return BoxedUnit.UNIT;
                });
                return this.foreach((Traversable)new .colon.colon((Object)new Tuple2((Object)"100 millis", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"5 minutes", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$)), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String timeout = (String)tuple2._1();
                        boolean expectTimeout = tuple2._2$mcZ$sp();
                        scala.collection.immutable.Map params = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.path"), (Object)bucket), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.encoding"), (Object)"converter"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.config.xml"), (Object)config), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.read-threads"), (Object)"12"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"geomesa.query.timeout"), (Object)timeout)}));
                        return (MatchResult)package.WithClose$.MODULE$.apply((Object)DataStoreFinder.getDataStore((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)params).asJava())), (Function1 & Serializable & scala.Serializable)ds -> {
                            this.theValue((Function0 & Serializable & scala.Serializable)() -> ds).must((Function0 & Serializable & scala.Serializable)() -> this.not((Matcher)this.beNull()));
                            String[] types = ds.getTypeNames();
                            this.theValue((Function0 & Serializable & scala.Serializable)() -> types).must((Function0 & Serializable & scala.Serializable)() -> this.haveSize(1, Sized$.MODULE$.scalaArrayIsSized()));
                            this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])types)).head()).mustEqual((Function0 & Serializable & scala.Serializable)() -> "fs-test");
                            return this.foreach((Traversable)package$.MODULE$.Range().apply(0, 5), (Function1 & Serializable & scala.Serializable)x$1 -> ConverterDataStoreTest.$anonfun$new$32(this, ds, expectTimeout, multiplier, BoxesRunTime.unboxToInt((Object)x$1)), MatchResult$.MODULE$.matchResultAsResult());
                        }, (IsCloseable)IsCloseable$.MODULE$.dataStoreIsCloseable());
                    }
                    throw new MatchError((Object)tuple2);
                }, MatchResult$.MODULE$.matchResultAsResult());
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            return this.blockExample("load sft as a string").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                String conf = ConfigFactory.parseString((String)new StringOps(Predef$.MODULE$.augmentString("\n          |geomesa {\n          |  sfts {\n          |    \"fs-test\" = {\n          |      attributes = [\n          |        { name = \"name\", type = \"String\", index = true                              }\n          |        { name = \"dtg\",  type = \"Date\",   index = false                             }\n          |        { name = \"geom\", type = \"Point\",  index = true, srid = 4326, default = true }\n          |      ]\n          |    }\n          |  }\n          |  converters {\n          |    \"fs-test\" {\n          |      type   = \"delimited-text\",\n          |      format = \"CSV\",\n          |      options {\n          |        skip-lines = 0\n          |      },\n          |      id-field = \"toString($name)\",\n          |      fields = [\n          |        { name = \"name\", transform = \"$1::string\"   }\n          |        { name = \"dtg\",  transform = \"dateTime($2)\" }\n          |        { name = \"geom\", transform = \"point($3)\"    }\n          |      ]\n          |    }\n          |\n          |  }\n          |}\n        ")).stripMargin()).root().render(ConfigRenderOptions.concise());
                scala.collection.immutable.Map params = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.path"), (Object)this.getClass().getClassLoader().getResource("example").getFile()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.encoding"), (Object)"converter"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fs.config.xml"), (Object)this.fsConfig(this.sftByConf(conf), "datastore1"))}));
                return (MatchResult)package.WithClose$.MODULE$.apply((Object)DataStoreFinder.getDataStore((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)params).asJava())), (Function1 & Serializable & scala.Serializable)ds -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ds).must((Function0 & Serializable & scala.Serializable)() -> this.not((Matcher)this.beNull()));
                    String[] types = ds.getTypeNames();
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> types).must((Function0 & Serializable & scala.Serializable)() -> this.haveSize(1, Sized$.MODULE$.scalaArrayIsSized()));
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])types)).head()).mustEqual((Function0 & Serializable & scala.Serializable)() -> "fs-test");
                    Query q = new Query("fs-test", (Filter)Filter.INCLUDE);
                    List feats = SelfClosingIterator$.MODULE$.apply(ds.getFeatureReader(q, Transaction.AUTO_COMMIT)).toList();
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> feats).must((Function0 & Serializable & scala.Serializable)() -> this.haveSize(4, Sized$.MODULE$.scalaTraversableIsSized()));
                }, (IsCloseable)IsCloseable$.MODULE$.dataStoreIsCloseable());
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
        });
    }
}

