/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.jobs;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorageFactory$;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.StorageMetadataFactory$;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.SizeableFileSystemStorage;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$Counters$;
import org.locationtech.geomesa.fs.storage.common.utils.StorageUtils$;
import org.locationtech.geomesa.utils.io.FileSizeEstimator;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.StructuralCallSite;

@ScalaSignature(bytes="\u0006\u0001\rMb\u0001B&M\u0001mC\u0001\u0002\u001f\u0001\u0003\u0002\u0003\u0006I!\u001f\u0005\b\u0003[\u0001A\u0011AA7\u0011\u001d\tY\u0005\u0001C!\u0003gBq!a\u001e\u0001\t\u0003\nI\bC\u0004\u0002\u0004\u0002!\t%!\"\u0007\r\u0005]\u0005\u0001AAM\u0011)\t9F\u0002B\u0001B\u0003%\u0011\u0011\f\u0005\b\u0003[1A\u0011AAX\u0011!\tfA1A\u0005\n\u0005]\u0006\u0002CAc\r\u0001\u0006I!!/\t\u0013\u0005\u001dgA1A\u0005\n\u0005%\u0007\u0002CAn\r\u0001\u0006I!a3\t\u0013\u0005ugA1A\u0005\n\u0005}\u0007\u0002CAt\r\u0001\u0006I!!9\t\u0013\u0005%hA1A\u0005\n\u0005-\b\u0002\u0003B\u0006\r\u0001\u0006I!!<\t\u0013\t5aA1A\u0005\n\t=\u0001\u0002\u0003B\u000f\r\u0001\u0006IA!\u0005\t\u0013\t}aA1A\u0005\n\t\u0005\u0002\u0002\u0003B\u0015\r\u0001\u0006IAa\t\t\u0013\t-bA1A\u0005\n\t5\u0002\u0002CB\u000f\r\u0001\u0006IAa\f\t\u0013\r}aA1A\u0005\n\t%\b\u0002CB\u0011\r\u0001\u0006I!a\u0019\t\u000f\r\rb\u0001\"\u0003\u0004&!9!Q\u0010\u0004\u0005B\r%\u0002b\u0002BP\r\u0011\u00053q\u0006\u0004\b\u0005\u00072\u0011\u0011\u0005B#\u0011)\u00119\u0005\bB\u0001B\u0003%\u00111\u001a\u0005\b\u0003[aB\u0011\u0001B%\u0011%\u0011i\u0005\ba\u0001\n\u0013\u0011y\u0005C\u0005\u0003Rq\u0001\r\u0011\"\u0003\u0003T!A!\u0011\f\u000f!B\u0013\u00119\u0002C\u0005\u0003\\q\u0011\r\u0011\"\u0003\u0003^!A!q\u000e\u000f!\u0002\u0013\u0011y\u0006C\u0005\u0003rq\u0011\r\u0011\"\u0003\u0003t!A!1\u0010\u000f!\u0002\u0013\u0011)\bC\u0004\u0003~q!\tAa \t\u000f\t%E\u0004\"\u0001\u0003\f\"9!q\u0014\u000f\u0005\u0002\t\u0005\u0006b\u0002BS9\u0011E!q\u0015\u0004\u0007\u0007\u00131Aaa\u0003\t\u0015\t\u001d#F!A!\u0002\u0013\tY\rC\u0004\u0002.)\"\ta!\u0004\t\u0013\tM(F1A\u0005\n\tU\b\u0002\u0003B\u007fU\u0001\u0006I!a\u0014\t\u000f\tu$\u0006\"\u0011\u0004\u0014!9!q\u0014\u0016\u0005B\reaA\u0002BY\r\u0011\u0011\u0019\f\u0003\u0006\u0003HE\u0012\t\u0011)A\u0005\u0003\u0017D!B!.2\u0005\u0003\u0005\u000b\u0011\u0002B\\\u0011)\t9&\rB\u0001B\u0003%\u0011\u0011\f\u0005\b\u0003[\tD\u0011\u0001Bc\u0011%\u0011i%\ra\u0001\n\u0013\u0011y\u0005C\u0005\u0003RE\u0002\r\u0011\"\u0003\u0003P\"A!\u0011L\u0019!B\u0013\u00119\u0002C\u0005\u0003TF\u0002\r\u0011\"\u0003\u0003P!I!Q[\u0019A\u0002\u0013%!q\u001b\u0005\t\u00057\f\u0004\u0015)\u0003\u0003\u0018!I!Q\\\u0019A\u0002\u0013%!q\n\u0005\n\u0005?\f\u0004\u0019!C\u0005\u0005CD\u0001B!:2A\u0003&!q\u0003\u0005\f\u0005O\f\u0004\u0019!a\u0001\n\u0013\u0011I\u000fC\u0006\u0003lF\u0002\r\u00111A\u0005\n\t5\bb\u0003Byc\u0001\u0007\t\u0011)Q\u0005\u0003GB1Ba=2\u0001\u0004\u0005\r\u0011\"\u0003\u0003v\"Y!q_\u0019A\u0002\u0003\u0007I\u0011\u0002B}\u0011-\u0011i0\ra\u0001\u0002\u0003\u0006K!a\u0014\t\u000f\tu\u0014\u0007\"\u0011\u0003\u0000\"9!qT\u0019\u0005B\r\u0015qaBA\r\u0019\"\u0005\u00111\u0004\u0004\u0007\u00172C\t!a\b\t\u000f\u00055\u0002\n\"\u0001\u00020\u00151\u0011\u0011\u0007%\u0001\u0003g\u0011Q\u0003U1si&$\u0018n\u001c8PkR\u0004X\u000f\u001e$pe6\fGO\u0003\u0002N\u001d\u0006!!n\u001c2t\u0015\ty\u0005+\u0001\u0004d_6lwN\u001c\u0006\u0003#J\u000bqa\u001d;pe\u0006<WM\u0003\u0002T)\u0006\u0011am\u001d\u0006\u0003+Z\u000bqaZ3p[\u0016\u001c\u0018M\u0003\u0002X1\u0006aAn\\2bi&|g\u000e^3dQ*\t\u0011,A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00019B!Q\f\u001a4o\u001b\u0005q&BA0a\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0002bE\u00061\u0001.\u00193p_BT!a\u0019-\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t)gL\u0001\u0007PkR\u0004X\u000f\u001e$pe6\fG\u000f\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006!A.\u00198h\u0015\u0005Y\u0017\u0001\u00026bm\u0006L!!\u001c5\u0003\tY{\u0017\u000e\u001a\t\u0003_Zl\u0011\u0001\u001d\u0006\u0003cJ\faa]5na2,'BA:u\u0003\u001d1W-\u0019;ve\u0016T!!\u001e-\u0002\u000f=\u0004XM\\4jg&\u0011q\u000f\u001d\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\u0002\u0011\u0011,G.Z4bi\u0016\u0004\"A\u001f&\u000f\u0005m<eb\u0001?\u0002\u00189\u0019Q0!\u0006\u000f\u0007y\f\u0019BD\u0002\u0000\u0003#qA!!\u0001\u0002\u00109!\u00111AA\u0007\u001d\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u00055\u00061AH]8pizJ\u0011!W\u0005\u0003/bK!!\u0016,\n\u0005M#\u0016BA)S\u0013\ty\u0005+\u0003\u0002N\u001d\u0006)\u0002+\u0019:uSRLwN\\(viB,HOR8s[\u0006$\bcAA\u000f\u00116\tAjE\u0002I\u0003C\u0001B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0003\u0003O\tQa]2bY\u0006LA!a\u000b\u0002&\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtDCAA\u000e\u0005Y\u0019\u0016N\\4mK\u001aKG.Z(viB,HOR8s[\u0006$(\u0003BA\u001b\u0003s1a!a\u000eI\u0001\u0005M\"\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004CBA\u001e\u0003\u000b2g.\u0004\u0002\u0002>)!\u0011qHA!\u0003\u0019yW\u000f\u001e9vi*\u0019\u00111\t0\u0002\u00071L'-\u0003\u0003\u0002H\u0005u\"\u0001\u0005$jY\u0016|U\u000f\u001e9vi\u001a{'/\\1u\u0011!\tY%!\u000e\u0007\u0002\u00055\u0013aD4fiJ+7m\u001c:e/JLG/\u001a:\u0015\r\u0005=\u0013QKA0!\u0015i\u0016\u0011\u000b4o\u0013\r\t\u0019F\u0018\u0002\r%\u0016\u001cwN\u001d3Xe&$XM\u001d\u0005\t\u0003/\nI\u00051\u0001\u0002Z\u000591m\u001c8uKb$\bcA/\u0002\\%\u0019\u0011Q\f0\u0003%Q\u000b7o[!ui\u0016l\u0007\u000f^\"p]R,\u0007\u0010\u001e\u0005\t\u0003C\nI\u00051\u0001\u0002d\u0005!a-\u001b7f!\u0011\t)'!\u001b\u000e\u0005\u0005\u001d$BA*a\u0013\u0011\tY'a\u001a\u0003\tA\u000bG\u000f\u001b\u000b\u0005\u0003_\n\t\bE\u0002\u0002\u001e\u0001AQ\u0001\u001f\u0002A\u0002e$B!a\u0014\u0002v!9\u0011qK\u0002A\u0002\u0005e\u0013AE4fi>+H\u000f];u\u0007>lW.\u001b;uKJ$B!a\u001f\u0002\u0002B\u0019Q,! \n\u0007\u0005}dLA\bPkR\u0004X\u000f^\"p[6LG\u000f^3s\u0011\u001d\t9\u0006\u0002a\u0001\u00033\n\u0001c\u00195fG.|U\u000f\u001e9viN\u0003XmY:\u0015\t\u0005\u001d\u0015Q\u0012\t\u0005\u0003G\tI)\u0003\u0003\u0002\f\u0006\u0015\"\u0001B+oSRDq!a$\u0006\u0001\u0004\t\t*A\u0002k_\n\u00042!XAJ\u0013\r\t)J\u0018\u0002\u000b\u0015>\u00147i\u001c8uKb$(a\u0007)beRLG/[8o'\u000eDW-\\3SK\u000e|'\u000fZ,sSR,'oE\u0003\u0007\u0003\u001f\nY\n\u0005\u0003\u0002\u001e\u0006-VBAAP\u0015\u0011\t\t+a)\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\t\u0005\u0015\u0016qU\u0001\tif\u0004Xm]1gK*\u0011\u0011\u0011V\u0001\u0004G>l\u0017\u0002BAW\u0003?\u00131\u0002T1{s2{wmZ5oOR!\u0011\u0011WA[!\r\t\u0019LB\u0007\u0002\u0001!9\u0011q\u000b\u0005A\u0002\u0005eSCAA]!\u0011\tY,!1\u000e\u0005\u0005u&bAA`!\u0006\u0019\u0011\r]5\n\t\u0005\r\u0017Q\u0018\u0002\u0012\r&dWmU=ti\u0016l7\u000b^8sC\u001e,\u0017\u0001C:u_J\fw-\u001a\u0011\u0002\u0011\u0015t7m\u001c3j]\u001e,\"!a3\u0011\t\u00055\u0017Q\u001b\b\u0005\u0003\u001f\f\t\u000e\u0005\u0003\u0002\u0006\u0005\u0015\u0012\u0002BAj\u0003K\ta\u0001\u0015:fI\u00164\u0017\u0002BAl\u00033\u0014aa\u0015;sS:<'\u0002BAj\u0003K\t\u0011\"\u001a8d_\u0012Lgn\u001a\u0011\u0002\t1,\u0017MZ\u000b\u0003\u0003C\u0004B!a\t\u0002d&!\u0011Q]A\u0013\u0005\u001d\u0011un\u001c7fC:\fQ\u0001\\3bM\u0002\n\u0001BZ5mKRK\b/Z\u000b\u0003\u0003[\u0004B!a<\u0003\u00069!\u0011\u0011_A\u0000\u001d\u0011\t\u00190!?\u000f\u0007q\f)0C\u0002\u0002x:\u000bQ!\u001e;jYNLA!a?\u0002~\u0006a1\u000b^8sC\u001e,W\u000b^5mg*\u0019\u0011q\u001f(\n\t\t\u0005!1A\u0001\t\r&dW\rV=qK*!\u00111`A\u007f\u0013\u0011\u00119A!\u0003\u0003\u0011\u0019KG.\u001a+za\u0016TAA!\u0001\u0003\u0004\u0005Ia-\u001b7f)f\u0004X\rI\u0001\tM&dWmU5{KV\u0011!\u0011\u0003\t\u0007\u0003G\u0011\u0019Ba\u0006\n\t\tU\u0011Q\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\r\"\u0011D\u0005\u0005\u00057\t)C\u0001\u0003M_:<\u0017!\u00034jY\u0016\u001c\u0016N_3!\u0003\u001d\u0019w.\u001e8uKJ,\"Aa\t\u0011\u0007u\u0013)#C\u0002\u0003(y\u0013qaQ8v]R,'/\u0001\u0005d_VtG/\u001a:!\u0003\u0015\u0019\u0017m\u00195f+\t\u0011y\u0003\u0005\u0005\u00032\tm\u00121\u001aB \u001b\t\u0011\u0019D\u0003\u0003\u00036\t]\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0005\u0005s\t)#\u0001\u0006d_2dWm\u0019;j_:LAA!\u0010\u00034\t\u0019Q*\u00199\u0011\u0007\t\u0005C$D\u0001\u0007\u00059\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001c2\u0001HA\u0011\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0006\u0003\u0003@\t-\u0003b\u0002B$=\u0001\u0007\u00111Z\u0001\u0006G>,h\u000e^\u000b\u0003\u0005/\t\u0011bY8v]R|F%Z9\u0015\t\u0005\u001d%Q\u000b\u0005\n\u0005/\u0002\u0013\u0011!a\u0001\u0005/\t1\u0001\u001f\u00132\u0003\u0019\u0019w.\u001e8uA\u00051!m\\;oIN,\"Aa\u0018\u0011\t\t\u0005$1N\u0007\u0003\u0005GRAA!\u001a\u0003h\u0005!q-Z8n\u0015\r\u0011IGV\u0001\u0004UR\u001c\u0018\u0002\u0002B7\u0005G\u0012\u0001\"\u00128wK2|\u0007/Z\u0001\bE>,h\u000eZ:!\u0003\u00151\u0017\u000e\\3t+\t\u0011)\b\u0005\u0004\u00032\t]\u00141Z\u0005\u0005\u0005s\u0012\u0019DA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\u0018A\u00024jY\u0016\u001c\b%A\u0003xe&$X\r\u0006\u0004\u0002\b\n\u0005%Q\u0011\u0005\u0007\u0005\u00073\u0003\u0019\u00014\u0002\u0007-,\u0017\u0010\u0003\u0004\u0003\b\u001a\u0002\rA\\\u0001\u0006m\u0006dW/Z\u0001\u0005[\u0016$\u0018-\u0006\u0002\u0003\u000eB!!q\u0012BM\u001d\u0011\u0011\tJ!&\u000f\u0007u\u0014\u0019*C\u0002\u0002@BKAAa&\u0002>\u0006y1\u000b^8sC\u001e,W*\u001a;bI\u0006$\u0018-\u0003\u0003\u0003\u001c\nu%!\u0005)beRLG/[8o\u001b\u0016$\u0018\rZ1uC*!!qSA_\u0003\u0015\u0019Gn\\:f)\u0011\t9Ia)\t\u000f\u0005]\u0003\u00061\u0001\u0002Z\u0005Ia.Z<Xe&$XM\u001d\u000b\u0003\u0005S\u0003\u0002\"a\t\u0003,\u0006\r\u0014qJ\u0005\u0005\u0005[\u000b)C\u0001\u0004UkBdWMM\u0015\u00049ER#!F\"ik:\\W\r\u001a)beRLG/[8o'R\fG/Z\n\u0004c\t}\u0012!C3ti&l\u0017\r^8s!\u0011\u0011IL!1\u000e\u0005\tm&\u0002\u0002B_\u0005\u007f\u000b!![8\u000b\u0007\u0005]H+\u0003\u0003\u0003D\nm&!\u0005$jY\u0016\u001c\u0016N_3FgRLW.\u0019;peRA!q\u0019Be\u0005\u0017\u0014i\rE\u0002\u0003BEBqAa\u00126\u0001\u0004\tY\rC\u0004\u00036V\u0002\rAa.\t\u000f\u0005]S\u00071\u0001\u0002ZQ!\u0011q\u0011Bi\u0011%\u00119fNA\u0001\u0002\u0004\u00119\"A\u0003u_R\fG.A\u0005u_R\fGn\u0018\u0013fcR!\u0011q\u0011Bm\u0011%\u00119FOA\u0001\u0002\u0004\u00119\"\u0001\u0004u_R\fG\u000eI\u0001\ne\u0016l\u0017-\u001b8j]\u001e\fQB]3nC&t\u0017N\\4`I\u0015\fH\u0003BAD\u0005GD\u0011Ba\u0016>\u0003\u0003\u0005\rAa\u0006\u0002\u0015I,W.Y5oS:<\u0007%\u0001\u0003qCRDWCAA2\u0003!\u0001\u0018\r\u001e5`I\u0015\fH\u0003BAD\u0005_D\u0011Ba\u0016A\u0003\u0003\u0005\r!a\u0019\u0002\u000bA\fG\u000f\u001b\u0011\u0002\r]\u0014\u0018\u000e^3s+\t\ty%\u0001\u0006xe&$XM]0%KF$B!a\"\u0003|\"I!qK\"\u0002\u0002\u0003\u0007\u0011qJ\u0001\boJLG/\u001a:!)\u0019\t9i!\u0001\u0004\u0004!1!1Q#A\u0002\u0019DaAa\"F\u0001\u0004qG\u0003BAD\u0007\u000fAq!a\u0016G\u0001\u0004\tIF\u0001\u000bTS:<G.\u001a)beRLG/[8o'R\fG/Z\n\u0004U\t}B\u0003BB\b\u0007#\u00012A!\u0011+\u0011\u001d\u00119\u0005\fa\u0001\u0003\u0017$b!a\"\u0004\u0016\r]\u0001B\u0002BB_\u0001\u0007a\r\u0003\u0004\u0003\b>\u0002\rA\u001c\u000b\u0005\u0003\u000f\u001bY\u0002C\u0004\u0002XA\u0002\r!!\u0017\u0002\r\r\f7\r[3!\u0003!9xN]6QCRD\u0017!C<pe.\u0004\u0016\r\u001e5!\u0003!qWm^*uCR,G\u0003\u0002B \u0007OAqAa\u0012\u001a\u0001\u0004\tY\r\u0006\u0004\u0002\b\u000e-2Q\u0006\u0005\u0007\u0005\u0007S\u0002\u0019\u00014\t\r\t\u001d%\u00041\u0001o)\u0011\t9i!\r\t\u000f\u0005]3\u00041\u0001\u0002Z\u0001")
public class PartitionOutputFormat
extends OutputFormat<Void, SimpleFeature> {
    public final FileOutputFormat<Void, SimpleFeature> org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$$delegate;

    public RecordWriter<Void, SimpleFeature> getRecordWriter(TaskAttemptContext context) {
        return new PartitionSchemeRecordWriter(this, context);
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) {
        return this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$$delegate.getOutputCommitter(context);
    }

    public void checkOutputSpecs(JobContext job) {
        Path outDir = FileOutputFormat.getOutputPath((JobContext)job);
        if (outDir == null) {
            throw new InvalidJobConfException("Output directory not set");
        }
        TokenCache.obtainTokensForNamenodes((Credentials)job.getCredentials(), (Path[])((Path[])((Object[])new Path[]{outDir})), (Configuration)job.getConfiguration());
    }

    public PartitionOutputFormat(FileOutputFormat<Void, SimpleFeature> delegate) {
        this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$$delegate = delegate;
    }

    public class PartitionSchemeRecordWriter
    extends RecordWriter<Void, SimpleFeature>
    implements LazyLogging {
        public final TaskAttemptContext org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$context;
        private final FileSystemStorage org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage;
        private final String org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$encoding;
        private final boolean org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$leaf;
        private final Enumeration.Value org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$fileType;
        private final Option<Object> fileSize;
        private final Counter counter;
        private final Map<String, PartitionState> cache;
        private final Path org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$workPath;
        private Logger logger;
        private volatile boolean bitmap$0;
        public final /* synthetic */ PartitionOutputFormat $outer;

        private Logger logger$lzycompute() {
            PartitionSchemeRecordWriter partitionSchemeRecordWriter = this;
            synchronized (partitionSchemeRecordWriter) {
                if (!this.bitmap$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
        }

        public FileSystemStorage org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage() {
            return this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage;
        }

        public String org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$encoding() {
            return this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$encoding;
        }

        public boolean org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$leaf() {
            return this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$leaf;
        }

        public Enumeration.Value org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$fileType() {
            return this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$fileType;
        }

        private Option<Object> fileSize() {
            return this.fileSize;
        }

        private Counter counter() {
            return this.counter;
        }

        private Map<String, PartitionState> cache() {
            return this.cache;
        }

        public Path org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$workPath() {
            return this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$workPath;
        }

        private PartitionState newState(String partition) {
            PartitionState partitionState;
            None$ estimator;
            None$ none$;
            FileSystemStorage fileSystemStorage = this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage();
            if (fileSystemStorage instanceof SizeableFileSystemStorage) {
                SizeableFileSystemStorage sizeableFileSystemStorage = (SizeableFileSystemStorage)fileSystemStorage;
                none$ = sizeableFileSystemStorage.targetSize(this.fileSize()).map((Function1 & Serializable & scala.Serializable)size -> sizeableFileSystemStorage.estimator(BoxesRunTime.unboxToLong((Object)size)));
            } else {
                none$ = None$.MODULE$;
            }
            None$ none$2 = estimator = none$;
            if (None$.MODULE$.equals(none$2)) {
                partitionState = new SinglePartitionState(this, partition);
            } else if (none$2 instanceof Some) {
                Some some = (Some)none$2;
                FileSizeEstimator e = (FileSizeEstimator)some.value();
                partitionState = new ChunkedPartitionState(this, partition, e, this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$context);
            } else {
                throw new MatchError((Object)none$2);
            }
            return partitionState;
        }

        public void write(Void key, SimpleFeature value) {
            String partition = this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage().metadata().scheme().getPartitionName(value);
            PartitionState state = (PartitionState)this.cache().getOrElseUpdate((Object)partition, (Function0 & Serializable & scala.Serializable)() -> this.newState(partition));
            state.write(key, value);
            this.counter().increment(1L);
        }

        public void close(TaskAttemptContext context) {
            this.cache().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                PartitionSchemeRecordWriter.$anonfun$close$1(this, context, x0$1);
                return BoxedUnit.UNIT;
            });
            package.CloseWithLogging$.MODULE$.apply((Object)this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage(), IsCloseable$.MODULE$.closeableIsCloseable());
        }

        public /* synthetic */ PartitionOutputFormat org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$close$1(PartitionSchemeRecordWriter $this, TaskAttemptContext context$1, Tuple2 x0$1) {
            PartitionState state;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                String partition = (String)tuple2._1();
                state = (PartitionState)tuple2._2();
                if ($this.logger().underlying().isDebugEnabled()) {
                    $this.logger().underlying().debug("Closing writer for {}", new Object[]{partition});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            state.close(context$1);
            $this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage().metadata().addPartition(state.meta());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public PartitionSchemeRecordWriter(PartitionOutputFormat $outer, TaskAttemptContext context) {
            this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$context = context;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            LazyLogging.$init$((LazyLogging)this);
            Configuration conf = context.getConfiguration();
            Path root = StorageConfiguration$.MODULE$.getRootPath(conf);
            package.FileSystemContext fsc = new package.FileSystemContext(FileContext.getFileContext((URI)root.toUri(), (Configuration)conf), conf, root, package.FileSystemContext$.MODULE$.apply$default$4());
            StorageMetadata metadata = (StorageMetadata)StorageMetadataFactory$.MODULE$.load(fsc).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(32).append("No storage defined under path '").append(root).append("'").toString());
            });
            this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage = FileSystemStorageFactory$.MODULE$.apply(fsc, metadata);
            this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$encoding = this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage().metadata().encoding();
            this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$leaf = this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage().metadata().leafStorage();
            this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$fileType = StorageConfiguration$.MODULE$.getFileType(context.getConfiguration());
            this.fileSize = StorageConfiguration$.MODULE$.getTargetFileSize(context.getConfiguration());
            this.counter = context.getCounter(StorageConfiguration$Counters$.MODULE$.Group(), StorageConfiguration$Counters$.MODULE$.Features());
            this.cache = Map$.MODULE$.empty();
            this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$workPath = ((FileOutputCommitter)$outer.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$$delegate.getOutputCommitter(context)).getWorkPath();
        }

        private class ChunkedPartitionState
        extends PartitionState {
            private final FileSizeEstimator estimator;
            private final TaskAttemptContext context;
            private long count;
            private long total;
            private long remaining;
            private Path path;
            private RecordWriter<Void, SimpleFeature> writer;

            private long count() {
                return this.count;
            }

            private void count_$eq(long x$1) {
                this.count = x$1;
            }

            private long total() {
                return this.total;
            }

            private void total_$eq(long x$1) {
                this.total = x$1;
            }

            private long remaining() {
                return this.remaining;
            }

            private void remaining_$eq(long x$1) {
                this.remaining = x$1;
            }

            private Path path() {
                return this.path;
            }

            private void path_$eq(Path x$1) {
                this.path = x$1;
            }

            private RecordWriter<Void, SimpleFeature> writer() {
                return this.writer;
            }

            private void writer_$eq(RecordWriter<Void, SimpleFeature> x$1) {
                this.writer = x$1;
            }

            @Override
            public void write(Void key, SimpleFeature value) {
                if (this.writer() == null) {
                    Tuple2<Path, RecordWriter<Void, SimpleFeature>> tuple2 = this.newWriter();
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Path p = (Path)tuple2._1();
                    RecordWriter w = (RecordWriter)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)p, (Object)w);
                    Tuple2 tuple23 = tuple22;
                    Path p2 = (Path)tuple23._1();
                    RecordWriter w2 = (RecordWriter)tuple23._2();
                    this.path_$eq(p2);
                    this.writer_$eq((RecordWriter<Void, SimpleFeature>)w2);
                }
                this.writer().write((Object)key, (Object)value);
                this.count_$eq(this.count() + 1L);
                this.remaining_$eq(this.remaining() - 1L);
                if (this.remaining() == 0L) {
                    this.writer().close(this.context);
                    this.writer_$eq(null);
                    this.total_$eq(this.total() + this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$ChunkedPartitionState$$$outer().org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage().context().fc().getFileStatus(this.path()).getLen());
                    this.estimator.update(this.total(), this.count());
                    this.remaining_$eq(this.estimator.estimate(0L));
                }
                super.write(key, value);
            }

            @Override
            public void close(TaskAttemptContext context) {
                if (this.writer() != null) {
                    this.writer().close(context);
                }
                super.close(context);
            }

            public /* synthetic */ PartitionSchemeRecordWriter org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$ChunkedPartitionState$$$outer() {
                return this.$outer;
            }

            public ChunkedPartitionState(PartitionSchemeRecordWriter $outer, String partition, FileSizeEstimator estimator, TaskAttemptContext context) {
                this.estimator = estimator;
                this.context = context;
                super($outer, partition);
                this.count = 0L;
                this.total = 0L;
                this.remaining = estimator.estimate(0L);
            }
        }

        public abstract class PartitionState {
            private final String partition;
            private long count;
            private final Envelope bounds;
            private final ArrayBuffer<String> files;
            public final /* synthetic */ PartitionSchemeRecordWriter $outer;

            public static Method reflMethod$Method1(Class x$1) {
                CallSite methodCache1 = StructuralCallSite.bootstrap("apply", (Lorg/apache/hadoop/mapreduce/TaskAttemptContext;Lorg/apache/hadoop/fs/Path;)Ljava/lang/Object;);
                Method method1 = methodCache1.find(x$1);
                if (method1 != null) {
                    return method1;
                }
                method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("getRecordWriter", methodCache1.parameterTypes()));
                methodCache1.add(x$1, method1);
                return method1;
            }

            private long count() {
                return this.count;
            }

            private void count_$eq(long x$1) {
                this.count = x$1;
            }

            private Envelope bounds() {
                return this.bounds;
            }

            private ArrayBuffer<String> files() {
                return this.files;
            }

            public void write(Void key, SimpleFeature value) {
                Geometry geom = (Geometry)value.getDefaultGeometry();
                if (geom != null) {
                    this.bounds().expandToInclude(geom.getEnvelopeInternal());
                }
                this.count_$eq(this.count() + 1L);
            }

            public StorageMetadata.PartitionMetadata meta() {
                long millis = System.currentTimeMillis();
                ArrayBuffer f = (ArrayBuffer)this.files().map((Function1 & Serializable & scala.Serializable)x$1 -> new StorageMetadata.StorageFile(x$1, millis, StorageMetadata.StorageFile$.MODULE$.apply$default$3(), StorageMetadata.StorageFile$.MODULE$.apply$default$4(), StorageMetadata.StorageFile$.MODULE$.apply$default$5()), ArrayBuffer$.MODULE$.canBuildFrom());
                return new StorageMetadata.PartitionMetadata(this.partition, (Seq)f, StorageMetadata.PartitionBounds$.MODULE$.apply(this.bounds()), this.count());
            }

            public void close(TaskAttemptContext context) {
                context.getCounter(StorageConfiguration$Counters$.MODULE$.Group(), StorageConfiguration$Counters$.MODULE$.partition(this.partition)).increment(this.count());
            }

            public Tuple2<Path, RecordWriter<Void, SimpleFeature>> newWriter() {
                Object object;
                BoxedUnit boxedUnit;
                Path file = StorageUtils$.MODULE$.nextFile(this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$PartitionState$$$outer().org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$workPath(), this.partition, this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$PartitionState$$$outer().org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$leaf(), this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$PartitionState$$$outer().org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$encoding(), this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$PartitionState$$$outer().org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$fileType(), StorageUtils$.MODULE$.nextFile$default$6());
                if (this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$PartitionState$$$outer().logger().underlying().isDebugEnabled()) {
                    this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$PartitionState$$$outer().logger().underlying().debug("Creating record writer at path {}", new Object[]{file});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.files().$plus$eq((Object)file.getName());
                FileOutputFormat<Void, SimpleFeature> qual1 = this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$PartitionState$$$outer().org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$$outer().org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$$delegate;
                try {
                    object = PartitionState.reflMethod$Method1(qual1.getClass()).invoke(qual1, this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$PartitionState$$$outer().org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$context, file);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
                return new Tuple2((Object)file, (Object)((RecordWriter)object));
            }

            public /* synthetic */ PartitionSchemeRecordWriter org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$PartitionState$$$outer() {
                return this.$outer;
            }

            public PartitionState(PartitionSchemeRecordWriter $outer, String partition) {
                this.partition = partition;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.count = 0L;
                this.bounds = new Envelope();
                this.files = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            }
        }

        private class SinglePartitionState
        extends PartitionState {
            private final RecordWriter<Void, SimpleFeature> writer = (RecordWriter)this.newWriter()._2();

            private RecordWriter<Void, SimpleFeature> writer() {
                return this.writer;
            }

            @Override
            public void write(Void key, SimpleFeature value) {
                this.writer().write((Object)key, (Object)value);
                super.write(key, value);
            }

            @Override
            public void close(TaskAttemptContext context) {
                this.writer().close(context);
                super.close(context);
            }

            public /* synthetic */ PartitionSchemeRecordWriter org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$SinglePartitionState$$$outer() {
                return this.$outer;
            }

            public SinglePartitionState(PartitionSchemeRecordWriter $outer, String partition) {
                super($outer, partition);
            }
        }
    }
}

