/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.metadata;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.EnumSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.metadata.FileBasedMetadata;
import org.locationtech.geomesa.fs.storage.common.metadata.FileBasedMetadata$Config$;
import org.locationtech.geomesa.fs.storage.common.metadata.MetadataSerialization$;
import org.locationtech.geomesa.fs.storage.common.metadata.package;
import org.locationtech.geomesa.fs.storage.common.metadata.package$;
import org.locationtech.geomesa.fs.storage.common.metadata.package$MetadataConverter$;
import org.locationtech.geomesa.fs.storage.common.metadata.package$RenderPretty$;
import org.locationtech.geomesa.fs.storage.common.utils.PathCache$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

public final class FileBasedMetadataFactory$
implements MethodProfiling {
    public static FileBasedMetadataFactory$ MODULE$;
    private final String MetadataDirectory;
    private final String StoragePath;
    private final ConcurrentHashMap<String, FileBasedMetadata> org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$cache;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new FileBasedMetadataFactory$();
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        FileBasedMetadataFactory$ fileBasedMetadataFactory$ = this;
        synchronized (fileBasedMetadataFactory$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String MetadataDirectory() {
        return this.MetadataDirectory;
    }

    public String StoragePath() {
        return this.StoragePath;
    }

    public ConcurrentHashMap<String, FileBasedMetadata> org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$cache() {
        return this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$cache;
    }

    public String org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$key(package.FileSystemContext context) {
        return (String)context.namespace().map((Function1 & Serializable & scala.Serializable)ns -> new StringBuilder(1).append((String)ns).append(":").append(context.root().toUri()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> context.root().toUri().toString());
    }

    public Option<FileBasedMetadata> org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$cached(package.FileSystemContext context, Map<String, String> config) {
        Function<String, FileBasedMetadata> loader = new Function<String, FileBasedMetadata>(context, config){
            private final package.FileSystemContext context$3;
            private final Map config$1;

            public <V> Function<V, FileBasedMetadata> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super FileBasedMetadata, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public FileBasedMetadata apply(String ignored) {
                FileBasedMetadata fileBasedMetadata;
                Path file = new Path(this.context$3.root(), FileBasedMetadataFactory$.MODULE$.StoragePath());
                if (!PathCache$.MODULE$.exists(this.context$3.fc(), file, PathCache$.MODULE$.exists$default$3())) {
                    fileBasedMetadata = null;
                } else {
                    Path directory = new Path(this.context$3.root(), FileBasedMetadataFactory$.MODULE$.MetadataDirectory());
                    package.Metadata meta = (package.Metadata)package.WithClose$.MODULE$.apply((Object)this.context$3.fc().open(file), (Function1 & Serializable & scala.Serializable)in -> MetadataSerialization$.MODULE$.deserialize((InputStream)in), IsCloseable$.MODULE$.closeableIsCloseable());
                    SimpleFeatureType sft = package$.MODULE$.namespaced(meta.sft(), (Option<String>)this.context$3.namespace());
                    package.MetadataConverter renderer = (package.MetadataConverter)this.config$1.get((Object)FileBasedMetadata$Config$.MODULE$.RenderKey()).map((Function1 & Serializable & scala.Serializable)name -> package$MetadataConverter$.MODULE$.apply((String)name)).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$RenderPretty$.MODULE$);
                    fileBasedMetadata = new FileBasedMetadata(this.context$3.fc(), directory, sft, meta, renderer);
                }
                return fileBasedMetadata;
            }
            {
                this.context$3 = context$3;
                this.config$1 = config$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$1(java.io.InputStream ), $anonfun$apply$2(java.lang.String ), $anonfun$apply$3()}, serializedLambda);
            }
        };
        return Option$.MODULE$.apply((Object)this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$cache().computeIfAbsent(this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$key(context), loader));
    }

    public void write(FileContext fc, Path root, package.Metadata metadata) {
        Path file = new Path(root, this.StoragePath());
        EnumSet<CreateFlag> flags = EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE);
        package.WithClose$.MODULE$.apply((Object)fc.create(file, flags, new Options.CreateOpts[]{Options.CreateOpts.createParent()}), (Function1 & Serializable & scala.Serializable)out -> {
            FileBasedMetadataFactory$.$anonfun$write$1(metadata, out);
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
        PathCache$.MODULE$.register(fc, file, PathCache$.MODULE$.register$default$3(), PathCache$.MODULE$.register$default$4());
    }

    public static final /* synthetic */ void $anonfun$write$1(package.Metadata metadata$1, FSDataOutputStream out) {
        MetadataSerialization$.MODULE$.serialize((OutputStream)out, metadata$1);
        out.hflush();
        out.hsync();
    }

    private FileBasedMetadataFactory$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        MethodProfiling.$init$((MethodProfiling)this);
        this.MetadataDirectory = "metadata";
        this.StoragePath = new StringBuilder(13).append(this.MetadataDirectory()).append("/storage.json").toString();
        this.org$locationtech$geomesa$fs$storage$common$metadata$FileBasedMetadataFactory$$cache = new ConcurrentHashMap();
    }
}

