/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.partitions;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.geomesa.curve.Z2SFC;
import org.locationtech.geomesa.fs.storage.common.partitions.SpatialScheme;
import org.locationtech.geomesa.fs.storage.common.partitions.Z2Scheme$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.jts.geom.Point;
import org.locationtech.sfcurve.IndexRange;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001\u0002\u0017.\u0001rB\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0001\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005^\u0001\tE\t\u0015!\u0003S\u0011!q\u0006A!f\u0001\n\u0003Y\u0005\u0002C0\u0001\u0005#\u0005\u000b\u0011\u0002'\t\u000b\u0001\u0004A\u0011A1\t\u000f\u0019\u0004!\u0019!C\u0005\u0017\"1q\r\u0001Q\u0001\n1Cq\u0001\u001b\u0001C\u0002\u0013%\u0011\u000e\u0003\u0004q\u0001\u0001\u0006IA\u001b\u0005\bc\u0002\u0011\r\u0011\"\u0003s\u0011\u00191\b\u0001)A\u0005g\"9q\u000f\u0001b\u0001\n\u0013\u0011\bB\u0002=\u0001A\u0003%1\u000fC\u0003z\u0001\u0011\u0005\u0013\u000bC\u0003{\u0001\u0011\u00053\u0010C\u0004\u0002\u0010\u0001!\t%!\u0005\t\u000f\u0005\r\u0002\u0001\"\u0015\u0002&!9\u0011\u0011\u0006\u0001\u0005R\u0005-\u0002\"CA,\u0001\u0005\u0005I\u0011AA-\u0011%\t\t\u0007AI\u0001\n\u0003\t\u0019\u0007C\u0005\u0002z\u0001\t\n\u0011\"\u0001\u0002|!I\u0011q\u0010\u0001\u0012\u0002\u0013\u0005\u00111\r\u0005\n\u0003\u0003\u0003\u0011\u0011!C!\u0003\u0007C\u0001\"a%\u0001\u0003\u0003%\ta\u0013\u0005\n\u0003+\u0003\u0011\u0011!C\u0001\u0003/C\u0011\"a)\u0001\u0003\u0003%\t%!*\t\u0013\u0005M\u0006!!A\u0005\u0002\u0005U\u0006\"CA`\u0001\u0005\u0005I\u0011IAa\u0011%\t\u0019\rAA\u0001\n\u0003\n)\rC\u0005\u0002H\u0002\t\t\u0011\"\u0011\u0002J\u001e9\u0011QZ\u0017\t\u0002\u0005=gA\u0002\u0017.\u0011\u0003\t\t\u000e\u0003\u0004aE\u0011\u0005\u0011\u0011\u001c\u0005\n\u00037\u0014#\u0019!C\u0001\u0003\u0007C\u0001\"!8#A\u0003%\u0011Q\u0011\u0004\u0007\u0003?\u0014\u0003!!9\t\r\u00014C\u0011\u0001B\u0007\u0011\u001d\u0011\u0019B\nC!\u0005+A\u0011B!\b#\u0003\u0003%\tIa\b\t\u0013\t\u001d\"%!A\u0005\u0002\n%\u0002\"\u0003B\u001eE\u0005\u0005I\u0011\u0002B\u001f\u0005!Q&gU2iK6,'B\u0001\u00180\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\u0006\u0003aE\naaY8n[>t'B\u0001\u001a4\u0003\u001d\u0019Ho\u001c:bO\u0016T!\u0001N\u001b\u0002\u0005\u0019\u001c(B\u0001\u001c8\u0003\u001d9Wm\\7fg\u0006T!\u0001O\u001d\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003i\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u001fB\u000fB\u0011ahP\u0007\u0002[%\u0011\u0001)\f\u0002\u000e'B\fG/[1m'\u000eDW-\\3\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\u000fA\u0013x\u000eZ;diB\u0011!\tS\u0005\u0003\u0013\u000e\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fAAY5ugV\tA\n\u0005\u0002C\u001b&\u0011aj\u0011\u0002\u0004\u0013:$\u0018!\u00022jiN\u0004\u0013\u0001B4f_6,\u0012A\u0015\t\u0003'js!\u0001\u0016-\u0011\u0005U\u001bU\"\u0001,\u000b\u0005][\u0014A\u0002\u001fs_>$h(\u0003\u0002Z\u0007\u00061\u0001K]3eK\u001aL!a\u0017/\u0003\rM#(/\u001b8h\u0015\tI6)A\u0003hK>l\u0007%A\u0005hK>l\u0017J\u001c3fq\u0006Qq-Z8n\u0013:$W\r\u001f\u0011\u0002\rqJg.\u001b;?)\u0011\u00117\rZ3\u0011\u0005y\u0002\u0001\"\u0002&\b\u0001\u0004a\u0005\"\u0002)\b\u0001\u0004\u0011\u0006\"\u00020\b\u0001\u0004a\u0015A\u0002=z\u0005&$8/A\u0004ys\nKGo\u001d\u0011\u0002\u0005i\u0014T#\u00016\u0011\u0005-tW\"\u00017\u000b\u00055,\u0014!B2veZ,\u0017BA8m\u0005\u0015Q&g\u0015$D\u0003\rQ(\u0007I\u0001\bqJ\u000bG-[;t+\u0005\u0019\bC\u0001\"u\u0013\t)8I\u0001\u0004E_V\u0014G.Z\u0001\tqJ\u000bG-[;tA\u00059\u0011PU1eSV\u001c\u0018\u0001C=SC\u0012LWo\u001d\u0011\u0002\u000fA\fG\u000f^3s]\u0006\u0001r-\u001a;QCJ$\u0018\u000e^5p]:\u000bW.\u001a\u000b\u0003%rDQ!`\tA\u0002y\fqAZ3biV\u0014X\rE\u0002\u0000\u0003\u0017i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0007g&l\u0007\u000f\\3\u000b\u0007u\f9AC\u0002\u0002\ne\nqa\u001c9f]\u001eL7/\u0003\u0003\u0002\u000e\u0005\u0005!!D*j[BdWMR3biV\u0014X-A\thKR\u001cuN^3sS:<g)\u001b7uKJ$B!a\u0005\u0002 A!\u0011QCA\u000e\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005\u001d\u0011A\u00024jYR,'/\u0003\u0003\u0002\u001e\u0005]!A\u0002$jYR,'\u000f\u0003\u0004\u0002\"I\u0001\rAU\u0001\na\u0006\u0014H/\u001b;j_:\fa\u0001Z5hSR\u001cHc\u0001'\u0002(!)!j\u0005a\u0001\u0019\u0006qq-\u001a8fe\u0006$XMU1oO\u0016\u001cH\u0003BA\u0017\u0003\u0017\u0002b!a\f\u0002:\u0005}b\u0002BA\u0019\u0003kq1!VA\u001a\u0013\u0005!\u0015bAA\u001c\u0007\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u001e\u0003{\u00111aU3r\u0015\r\t9d\u0011\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011QI\u001c\u0002\u000fM47-\u001e:wK&!\u0011\u0011JA\"\u0005)Ie\u000eZ3y%\u0006tw-\u001a\u0005\b\u0003\u001b\"\u0002\u0019AA(\u0003\tA\u0018\u0010\u0005\u0004\u00020\u0005e\u0012\u0011\u000b\t\b\u0005\u0006M3o]:t\u0013\r\t)f\u0011\u0002\u0007)V\u0004H.\u001a\u001b\u0002\t\r|\u0007/\u001f\u000b\bE\u0006m\u0013QLA0\u0011\u001dQU\u0003%AA\u00021Cq\u0001U\u000b\u0011\u0002\u0003\u0007!\u000bC\u0004_+A\u0005\t\u0019\u0001'\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\r\u0016\u0004\u0019\u0006\u001d4FAA5!\u0011\tY'!\u001e\u000e\u0005\u00055$\u0002BA8\u0003c\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005M4)\u0001\u0006b]:|G/\u0019;j_:LA!a\u001e\u0002n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0010\u0016\u0004%\u0006\u001d\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0015\u0005\u0003BAD\u0003#k!!!#\u000b\t\u0005-\u0015QR\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0010\u0006!!.\u0019<b\u0013\rY\u0016\u0011R\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tI*a(\u0011\u0007\t\u000bY*C\u0002\u0002\u001e\u000e\u00131!\u00118z\u0011!\t\tkGA\u0001\u0002\u0004a\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002(B1\u0011\u0011VAX\u00033k!!a+\u000b\u0007\u000556)\u0001\u0006d_2dWm\u0019;j_:LA!!-\u0002,\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t9,!0\u0011\u0007\t\u000bI,C\u0002\u0002<\u000e\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002\"v\t\t\u00111\u0001\u0002\u001a\u0006A\u0001.Y:i\u0007>$W\rF\u0001M\u0003!!xn\u0015;sS:<GCAAC\u0003\u0019)\u0017/^1mgR!\u0011qWAf\u0011%\t\t\u000bIA\u0001\u0002\u0004\tI*\u0001\u0005[eM\u001b\u0007.Z7f!\tq$e\u0005\u0003#\u0003'<\u0005c\u0001\"\u0002V&\u0019\u0011q[\"\u0003\r\u0005s\u0017PU3g)\t\ty-\u0001\u0003OC6,\u0017!\u0002(b[\u0016\u0004#\u0001\u0007.3!\u0006\u0014H/\u001b;j_:\u001c6\r[3nK\u001a\u000b7\r^8ssN\u0019a%a9\u0011\t\u0005\u0015(q\u0001\b\u0005\u0003O\u0014\u0019A\u0004\u0003\u0002j\n\u0005a\u0002BAv\u0003\u007ftA!!<\u0002~:!\u0011q^A~\u001d\u0011\t\t0!?\u000f\t\u0005M\u0018q\u001f\b\u0004+\u0006U\u0018\"\u0001\u001e\n\u0005aJ\u0014B\u0001\u001c8\u0013\t!T'\u0003\u00023g%\u0011\u0001'M\u0005\u0003]=J1A!\u0002.\u00035\u0019\u0006/\u0019;jC2\u001c6\r[3nK&!!\u0011\u0002B\u0006\u0005u\u0019\u0006/\u0019;jC2\u0004\u0016M\u001d;ji&|gnU2iK6,g)Y2u_JL(b\u0001B\u0003[Q\u0011!q\u0002\t\u0004\u0005#1S\"\u0001\u0012\u0002)\t,\u0018\u000e\u001c3QCJ$\u0018\u000e^5p]N\u001b\u0007.Z7f)\u001di$q\u0003B\r\u00057AQA\u0013\u0015A\u00021CQ\u0001\u0015\u0015A\u0002ICQA\u0018\u0015A\u00021\u000bQ!\u00199qYf$rA\u0019B\u0011\u0005G\u0011)\u0003C\u0003KS\u0001\u0007A\nC\u0003QS\u0001\u0007!\u000bC\u0003_S\u0001\u0007A*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t-\"q\u0007\t\u0006\u0005\n5\"\u0011G\u0005\u0004\u0005_\u0019%AB(qi&|g\u000e\u0005\u0004C\u0005ga%\u000bT\u0005\u0004\u0005k\u0019%A\u0002+va2,7\u0007\u0003\u0005\u0003:)\n\t\u00111\u0001c\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003@A!\u0011q\u0011B!\u0013\u0011\u0011\u0019%!#\u0003\r=\u0013'.Z2u\u0001")
public class Z2Scheme
extends SpatialScheme
implements Product,
Serializable {
    private final int bits;
    private final String geom;
    private final int geomIndex;
    private final int xyBits;
    private final Z2SFC z2;
    private final double xRadius;
    private final double yRadius;

    public static Option<Tuple3<Object, String, Object>> unapply(Z2Scheme z2Scheme) {
        return Z2Scheme$.MODULE$.unapply(z2Scheme);
    }

    public static Z2Scheme apply(int n, String string, int n2) {
        return Z2Scheme$.MODULE$.apply(n, string, n2);
    }

    public static String Name() {
        return Z2Scheme$.MODULE$.Name();
    }

    public int bits() {
        return this.bits;
    }

    public String geom() {
        return this.geom;
    }

    public int geomIndex() {
        return this.geomIndex;
    }

    private int xyBits() {
        return this.xyBits;
    }

    private Z2SFC z2() {
        return this.z2;
    }

    private double xRadius() {
        return this.xRadius;
    }

    private double yRadius() {
        return this.yRadius;
    }

    @Override
    public String pattern() {
        return new StringBuilder(7).append(this.bits()).append("-bit-z2").toString();
    }

    public String getPartitionName(SimpleFeature feature) {
        Point pt = (Point)feature.getAttribute(this.geomIndex());
        return Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToLong((long)this.z2().index(pt.getX(), pt.getY(), this.z2().index$default$3()))), this.format());
    }

    @Override
    public Filter getCoveringFilter(String partition) {
        Tuple2 tuple2 = this.z2().invert(new StringOps(Predef$.MODULE$.augmentString(partition)).toLong());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double x = tuple2._1$mcD$sp();
        double y = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x, y);
        Tuple2.mcDD.sp sp3 = sp2;
        double x2 = sp3._1$mcD$sp();
        double y2 = sp3._2$mcD$sp();
        Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(x2 - this.xRadius(), x2 + this.xRadius());
        if (sp4 == null) {
            throw new MatchError((Object)sp4);
        }
        double xmin = sp4._1$mcD$sp();
        double xmax = sp4._2$mcD$sp();
        Tuple2.mcDD.sp sp5 = new Tuple2.mcDD.sp(xmin, xmax);
        Tuple2.mcDD.sp sp6 = sp5;
        double xmin2 = sp6._1$mcD$sp();
        double xmax2 = sp6._2$mcD$sp();
        Tuple2.mcDD.sp sp7 = new Tuple2.mcDD.sp(y2 - this.yRadius(), y2 + this.yRadius());
        if (sp7 == null) {
            throw new MatchError((Object)sp7);
        }
        double ymin = sp7._1$mcD$sp();
        double ymax = sp7._2$mcD$sp();
        Tuple2.mcDD.sp sp8 = new Tuple2.mcDD.sp(ymin, ymax);
        Tuple2.mcDD.sp sp9 = sp8;
        double ymin2 = sp9._1$mcD$sp();
        double ymax2 = sp9._2$mcD$sp();
        BBOX bbox = org.locationtech.geomesa.filter.package$.MODULE$.ff().bbox((Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().property(this.geom()), (BoundingBox)new ReferencedEnvelope(xmin2, xmax2, ymin2, ymax2, package$.MODULE$.CRS_EPSG_4326()));
        None$ xExclusive = xmax2 == this.z2().lon().max() ? None$.MODULE$ : new Some((Object)org.locationtech.geomesa.filter.package$.MODULE$.ff().less((Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().function("getX", new Expression[]{org.locationtech.geomesa.filter.package$.MODULE$.ff().property(this.geom())}), (Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().literal(xmax2)));
        None$ yExclusive = ymax2 == this.z2().lat().max() ? None$.MODULE$ : new Some((Object)org.locationtech.geomesa.filter.package$.MODULE$.ff().less((Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().function("getY", new Expression[]{org.locationtech.geomesa.filter.package$.MODULE$.ff().property(this.geom())}), (Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().literal(ymax2)));
        return org.locationtech.geomesa.filter.package$.MODULE$.andFilters((Seq)((TraversableLike)((TraversableLike)new .colon.colon((Object)bbox, (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable((Option)xExclusive), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable((Option)yExclusive), Seq$.MODULE$.canBuildFrom()), (FilterFactory)org.locationtech.geomesa.filter.package$.MODULE$.ff());
    }

    @Override
    public int digits(int bits) {
        return (int)scala.math.package$.MODULE$.ceil((double)bits * scala.math.package$.MODULE$.log10(2.0));
    }

    @Override
    public Seq<IndexRange> generateRanges(Seq<Tuple4<Object, Object, Object, Object>> xy) {
        return this.z2().ranges(xy, this.z2().ranges$default$2(), this.z2().ranges$default$3());
    }

    public Z2Scheme copy(int bits, String geom, int geomIndex) {
        return new Z2Scheme(bits, geom, geomIndex);
    }

    public int copy$default$1() {
        return this.bits();
    }

    public String copy$default$2() {
        return this.geom();
    }

    public int copy$default$3() {
        return this.geomIndex();
    }

    public String productPrefix() {
        return "Z2Scheme";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.bits());
                break;
            }
            case 1: {
                object = this.geom();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.geomIndex());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Z2Scheme;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.bits());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.geom()));
        n = Statics.mix((int)n, (int)this.geomIndex());
        return Statics.finalizeHash((int)n, (int)3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Z2Scheme)) return false;
        boolean bl = true;
        if (!bl) return false;
        Z2Scheme z2Scheme = (Z2Scheme)x$1;
        if (this.bits() != z2Scheme.bits()) return false;
        String string = this.geom();
        String string2 = z2Scheme.geom();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.geomIndex() != z2Scheme.geomIndex()) return false;
        if (!z2Scheme.canEqual(this)) return false;
        return true;
    }

    public Z2Scheme(int bits, String geom, int geomIndex) {
        this.bits = bits;
        this.geom = geom;
        this.geomIndex = geomIndex;
        super(bits, geom);
        Product.$init$((Product)this);
        this.xyBits = bits / 2;
        this.z2 = new Z2SFC(this.xyBits());
        this.xRadius = 360.0 / scala.math.package$.MODULE$.pow(2.0, (double)this.xyBits()) / (double)2;
        this.yRadius = 180.0 / scala.math.package$.MODULE$.pow(2.0, (double)this.xyBits()) / (double)2;
    }

    public static class Z2PartitionSchemeFactory
    extends SpatialScheme.SpatialPartitionSchemeFactory {
        @Override
        public SpatialScheme buildPartitionScheme(int bits, String geom, int geomIndex) {
            return new Z2Scheme(bits, geom, geomIndex);
        }

        public Z2PartitionSchemeFactory() {
            super(Z2Scheme$.MODULE$.Name());
        }
    }
}

