/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.metadata;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Properties;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.locationtech.geomesa.fs.storage.common.metadata.JdbcMetadata$Config$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public final class JdbcMetadataFactory$
implements MethodProfiling {
    public static JdbcMetadataFactory$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new JdbcMetadataFactory$();
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        JdbcMetadataFactory$ jdbcMetadataFactory$ = this;
        synchronized (jdbcMetadataFactory$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public PoolingDataSource<PoolableConnection> createDataSource(Map<String, String> config) {
        String url = (String)config.getOrElse((Object)JdbcMetadata$Config$.MODULE$.UrlKey(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(24).append("JdbcMetadata requires '").append(JdbcMetadata$Config$.MODULE$.UrlKey()).append("'").toString());
        });
        config.get((Object)JdbcMetadata$Config$.MODULE$.DriverKey()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> Class.forName(x$1));
        Properties props = new Properties();
        config.get((Object)JdbcMetadata$Config$.MODULE$.UserKey()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> props.put("user", x$1));
        config.get((Object)JdbcMetadata$Config$.MODULE$.PasswordKey()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> props.put("password", x$2));
        DriverManagerConnectionFactory driver = new DriverManagerConnectionFactory(url, props);
        package.WithClose$.MODULE$.apply((Object)driver.createConnection(), (Function1 & Serializable & scala.Serializable)connection -> {
            JdbcMetadataFactory$.$anonfun$createDataSource$5(config, connection);
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        JdbcMetadataFactory$.setPoolConfig$1(JdbcMetadata$Config$.MODULE$.MaxIdleKey(), (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)JdbcMetadataFactory$.$anonfun$createDataSource$7(x$3)), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> poolConfig.setMaxIdle(x$1), config);
        JdbcMetadataFactory$.setPoolConfig$1(JdbcMetadata$Config$.MODULE$.MinIdleKey(), (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)JdbcMetadataFactory$.$anonfun$createDataSource$9(x$4)), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> poolConfig.setMinIdle(x$1), config);
        JdbcMetadataFactory$.setPoolConfig$1(JdbcMetadata$Config$.MODULE$.MaxSizeKey(), (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)JdbcMetadataFactory$.$anonfun$createDataSource$11(x$5)), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> poolConfig.setMaxTotal(x$1), config);
        JdbcMetadataFactory$.setPoolConfig$1(JdbcMetadata$Config$.MODULE$.FairnessKey(), (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)JdbcMetadataFactory$.$anonfun$createDataSource$13(x$6)), (Function1 & Serializable & scala.Serializable)x$1 -> {
            poolConfig.setFairness(BoxesRunTime.unboxToBoolean((Object)x$1));
            return BoxedUnit.UNIT;
        }, config);
        JdbcMetadataFactory$.setPoolConfig$1(JdbcMetadata$Config$.MODULE$.TestOnBorrowKey(), (Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)JdbcMetadataFactory$.$anonfun$createDataSource$15(x$7)), (Function1 & Serializable & scala.Serializable)x$1 -> {
            poolConfig.setTestOnBorrow(BoxesRunTime.unboxToBoolean((Object)x$1));
            return BoxedUnit.UNIT;
        }, config);
        JdbcMetadataFactory$.setPoolConfig$1(JdbcMetadata$Config$.MODULE$.TestOnCreateKey(), (Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)JdbcMetadataFactory$.$anonfun$createDataSource$17(x$8)), (Function1 & Serializable & scala.Serializable)x$1 -> {
            poolConfig.setTestOnCreate(BoxesRunTime.unboxToBoolean((Object)x$1));
            return BoxedUnit.UNIT;
        }, config);
        JdbcMetadataFactory$.setPoolConfig$1(JdbcMetadata$Config$.MODULE$.TestWhileIdlKey(), (Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)JdbcMetadataFactory$.$anonfun$createDataSource$19(x$9)), (Function1 & Serializable & scala.Serializable)x$1 -> {
            poolConfig.setTestWhileIdle(BoxesRunTime.unboxToBoolean((Object)x$1));
            return BoxedUnit.UNIT;
        }, config);
        PoolableConnectionFactory factory = new PoolableConnectionFactory((ConnectionFactory)driver, null);
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)factory, poolConfig);
        factory.setPool((ObjectPool)pool);
        return new PoolingDataSource((ObjectPool)pool);
    }

    public static final /* synthetic */ void $anonfun$createDataSource$5(Map config$1, Connection connection) {
        if (!connection.isValid(10)) {
            throw new IllegalArgumentException(new StringBuilder(54).append("Could not create valid connection using configuration ").append(config$1.mkString(", ")).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$createDataSource$6(Function1 method$1, Function1 conversion$1, String key$1, String v) {
        try {
            method$1.apply(conversion$1.apply((Object)v));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (MODULE$.logger().underlying().isWarnEnabled()) {
                    MODULE$.logger().underlying().warn("Invalid configuration value '{}' for key {}: {}", new Object[]{v, key$1, e});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            throw throwable;
        }
    }

    private static final void setPoolConfig$1(String key, Function1 conversion, Function1 method, Map config$1) {
        config$1.get((Object)key).foreach((Function1 & Serializable & scala.Serializable)v -> {
            JdbcMetadataFactory$.$anonfun$createDataSource$6(method, conversion, key, v);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$createDataSource$7(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
    }

    public static final /* synthetic */ int $anonfun$createDataSource$9(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
    }

    public static final /* synthetic */ int $anonfun$createDataSource$11(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$createDataSource$13(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$createDataSource$15(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$createDataSource$17(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$createDataSource$19(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toBoolean();
    }

    private JdbcMetadataFactory$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        MethodProfiling.$init$((MethodProfiling)this);
    }
}

