/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.metadata;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.metadata.FileBasedMetadata;
import org.locationtech.geomesa.fs.storage.common.metadata.FileBasedMetadata$;
import org.locationtech.geomesa.fs.storage.common.metadata.FileBasedMetadataFactory;
import org.locationtech.geomesa.fs.storage.common.package$;
import org.locationtech.geomesa.fs.storage.common.utils.PathCache$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.feature.simple.SimpleFeatureType;
import pureconfig.ConfigWriter$;
import pureconfig.Derivation;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class MetadataJson$
implements MethodProfiling {
    public static MetadataJson$ MODULE$;
    private final String MetadataPath;
    private final ConcurrentHashMap<String, package.NamedOptions> cache;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new MetadataJson$();
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        MetadataJson$ metadataJson$ = this;
        synchronized (metadataJson$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String MetadataPath() {
        return this.MetadataPath;
    }

    private ConcurrentHashMap<String, package.NamedOptions> cache() {
        return this.cache;
    }

    public Option<package.NamedOptions> readMetadata(package.FileSystemContext context) {
        BoxedUnit boxedUnit;
        String key = context.root().toUri().toString();
        ObjectRef cached = ObjectRef.create((Object)this.cache().get(key));
        if ((package.NamedOptions)cached.elem == null) {
            Path file = new Path(context.root(), this.MetadataPath());
            if (PathCache$.MODULE$.exists(context.fc(), file, PathCache$.MODULE$.exists$default$3())) {
                Config config = (Config)this.profile("Loaded metadata configuration", (Function0 & Serializable & scala.Serializable)() -> (Config)package.WithClose$.MODULE$.apply((Object)new InputStreamReader((InputStream)context.fc().open(file), StandardCharsets.UTF_8), (Function1 & Serializable & scala.Serializable)in -> ConfigFactory.parseReader((Reader)in, (ConfigParseOptions)package$.MODULE$.ParseOptions()), IsCloseable$.MODULE$.closeableIsCloseable()));
                if (config.hasPath("name")) {
                    cached.elem = (package.NamedOptions)this.profile("Parsed metadata configuration", (Function0 & Serializable & scala.Serializable)() -> (package.NamedOptions)pureconfig.package$.MODULE$.loadConfigOrThrow(config, ClassTag$.MODULE$.apply(package.NamedOptions.class), (Derivation)new Derivation.Successful(package$.MODULE$.NamedOptionsConvert())));
                    boxedUnit = this.cache().put(key, (package.NamedOptions)cached.elem);
                } else {
                    context.fc().rename(file, new Path(context.root(), new StringBuilder(4).append(this.MetadataPath()).append(".bak").toString()), new Options.Rename[0]);
                    PathCache$.MODULE$.invalidate(context.fc(), file);
                    this.transitionMetadata(context, config).foreach((Function1 & Serializable & scala.Serializable)meta -> {
                        cached.elem = meta;
                        return BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)((package.NamedOptions)cached.elem));
    }

    public void writeMetadata(package.FileSystemContext context, package.NamedOptions metadata) {
        Path file = new Path(context.root(), this.MetadataPath());
        if (PathCache$.MODULE$.exists(context.fc(), file, true)) {
            throw new IllegalArgumentException(new StringBuilder(73).append("Trying to create a new storage instance but metadata already exists at '").append(file).append("'").toString());
        }
        String data = (String)this.profile("Serialized metadata configuration", (Function0 & Serializable & scala.Serializable)() -> ConfigWriter$.MODULE$.apply((Derivation)new Derivation.Successful(package$.MODULE$.NamedOptionsConvert())).to((Object)metadata).render(package$.MODULE$.RenderOptions()));
        this.profile("Persisted metadata configuration", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package.WithClose$.MODULE$.apply((Object)context.fc().create(file, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()}), (Function1 & Serializable & scala.Serializable)out -> {
            MetadataJson$.$anonfun$writeMetadata$3(data, out);
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable()));
        this.cache().put(context.root().toUri().toString(), metadata);
        PathCache$.MODULE$.register(context.fc(), file, PathCache$.MODULE$.register$default$3(), PathCache$.MODULE$.register$default$4());
    }

    private Option<package.NamedOptions> transitionMetadata(package.FileSystemContext context, Config config) {
        None$ none$;
        try {
            Config x$12 = config.getConfig("featureType");
            None$ x$2 = None$.MODULE$;
            Option x$3 = SimpleFeatureTypes$.MODULE$.createType$default$2();
            SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType(x$12, x$3, (Option)x$2);
            String encoding = config.getString("encoding");
            Config schemeConfig = config.getConfig("partitionScheme");
            Config schemeOpts = schemeConfig.getConfig("options");
            package.NamedOptions scheme = new package.NamedOptions(schemeConfig.getString("scheme"), ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(schemeOpts.entrySet()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getKey()), (Object)schemeOpts.getString((String)e.getKey())), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            boolean leafStorage = scheme.options().get((Object)"leaf-storage").forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataJson$.$anonfun$transitionMetadata$2(x$1)));
            package.Metadata meta = package.Metadata$.MODULE$.apply(sft, encoding, scheme, leafStorage, package.Metadata$.MODULE$.apply$default$5());
            Config partitionConfig = config.getConfig("partitions");
            package.NamedOptions defaults = FileBasedMetadata$.MODULE$.LegacyOptions();
            package.WithClose$.MODULE$.apply((Object)new FileBasedMetadataFactory().create(context, defaults.options(), meta), (Function1 & Serializable & scala.Serializable)metadata -> {
                MetadataJson$.$anonfun$transitionMetadata$3(partitionConfig, metadata);
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
            none$ = new Some((Object)defaults);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e2 = (Throwable)option.get();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error transitioning old metadata format: ", e2);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            None$ none$2 = None$.MODULE$;
            none$ = none$2;
        }
        return none$;
    }

    public static final /* synthetic */ void $anonfun$writeMetadata$3(String data$1, FSDataOutputStream out) {
        out.write(data$1.getBytes(StandardCharsets.UTF_8));
        out.hflush();
        out.hsync();
    }

    public static final /* synthetic */ boolean $anonfun$transitionMetadata$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
    }

    public static final /* synthetic */ void $anonfun$transitionMetadata$4(Config partitionConfig$1, FileBasedMetadata metadata$2, Map.Entry e) {
        String name = (String)e.getKey();
        Buffer files = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionConfig$1.getStringList(name)).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> new StorageMetadata.StorageFile(x$2, 0L, StorageMetadata.StorageFile$.MODULE$.apply$default$3(), StorageMetadata.StorageFile$.MODULE$.apply$default$4(), StorageMetadata.StorageFile$.MODULE$.apply$default$5()), Buffer$.MODULE$.canBuildFrom());
        metadata$2.addPartition(new StorageMetadata.PartitionMetadata(name, (Seq)files, (Option)None$.MODULE$, 0L));
    }

    public static final /* synthetic */ void $anonfun$transitionMetadata$3(Config partitionConfig$1, FileBasedMetadata metadata) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(partitionConfig$1.root().entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)e -> {
            MetadataJson$.$anonfun$transitionMetadata$4(partitionConfig$1, metadata, e);
            return BoxedUnit.UNIT;
        });
    }

    private MetadataJson$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        MethodProfiling.$init$((MethodProfiling)this);
        this.MetadataPath = "metadata.json";
        this.cache = new ConcurrentHashMap();
    }
}

