/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.utils;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.storage.common.utils.PathCache$RemoteIterator$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;

public final class PathCache$ {
    public static PathCache$ MODULE$;
    private final GeoMesaSystemProperties.SystemProperty CacheDurationProperty;
    private final long duration;
    private final LoadingCache<Tuple2<FileContext, Path>, Boolean> pathCache;
    private final LoadingCache<Tuple2<FileContext, Path>, FileStatus> statusCache;
    private final LoadingCache<Tuple2<FileContext, Path>, Stream<FileStatus>> listCache;

    static {
        new PathCache$();
    }

    public GeoMesaSystemProperties.SystemProperty CacheDurationProperty() {
        return this.CacheDurationProperty;
    }

    private long duration() {
        return this.duration;
    }

    private LoadingCache<Tuple2<FileContext, Path>, Boolean> pathCache() {
        return this.pathCache;
    }

    private LoadingCache<Tuple2<FileContext, Path>, FileStatus> statusCache() {
        return this.statusCache;
    }

    private LoadingCache<Tuple2<FileContext, Path>, Stream<FileStatus>> listCache() {
        return this.listCache;
    }

    public void register(FileContext fc, Path path, Option<FileStatus> status, Option<Stream<FileStatus>> list) {
        this.pathCache().put((Object)new Tuple2((Object)fc, (Object)path), (Object)Boolean.TRUE);
        status.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            PathCache$.$anonfun$register$1(fc, path, x$1);
            return BoxedUnit.UNIT;
        });
        list.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            PathCache$.$anonfun$register$2(fc, path, x$2);
            return BoxedUnit.UNIT;
        });
    }

    public Option<FileStatus> register$default$3() {
        return None$.MODULE$;
    }

    public Option<Stream<FileStatus>> register$default$4() {
        return None$.MODULE$;
    }

    public boolean exists(FileContext fc, Path path, boolean reload) {
        if (reload) {
            this.invalidate(fc, path);
        }
        return (Boolean)this.pathCache().get((Object)new Tuple2((Object)fc, (Object)path));
    }

    public boolean exists$default$3() {
        return false;
    }

    public FileStatus status(FileContext fc, Path path, boolean reload) {
        if (reload) {
            this.invalidate(fc, path);
        }
        return (FileStatus)this.statusCache().get((Object)new Tuple2((Object)fc, (Object)path));
    }

    public boolean status$default$3() {
        return false;
    }

    public Iterator<FileStatus> list(FileContext fc, Path dir, boolean reload) {
        if (reload) {
            this.invalidate(fc, dir);
        }
        return ((Stream)this.listCache().get((Object)new Tuple2((Object)fc, (Object)dir))).iterator();
    }

    public boolean list$default$3() {
        return false;
    }

    public void invalidate(FileContext fc, Path path) {
        ((IterableLike)new .colon.colon(this.pathCache(), (List)new .colon.colon(this.statusCache(), (List)new .colon.colon(this.listCache(), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.invalidate((Object)new Tuple2((Object)fc, (Object)path));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$register$1(FileContext fc$1, Path path$1, FileStatus x$1) {
        MODULE$.statusCache().put((Object)new Tuple2((Object)fc$1, (Object)path$1), (Object)x$1);
    }

    public static final /* synthetic */ void $anonfun$register$2(FileContext fc$1, Path path$1, Stream x$2) {
        MODULE$.listCache().put((Object)new Tuple2((Object)fc$1, (Object)path$1), (Object)x$2);
    }

    private PathCache$() {
        MODULE$ = this;
        this.CacheDurationProperty = new GeoMesaSystemProperties.SystemProperty("geomesa.fs.file.cache.duration", "15 minutes");
        this.duration = ((Duration)this.CacheDurationProperty().toDuration().get()).toMillis();
        this.pathCache = Caffeine.newBuilder().expireAfterWrite(this.duration(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<Tuple2<FileContext, Path>, Boolean>(){

            @Nonnull
            public Map<Tuple2<FileContext, Path>, Boolean> loadAll(Iterable<? extends Tuple2<FileContext, Path>> x$1) throws Exception {
                return super.loadAll(x$1);
            }

            @Nonnull
            public CompletableFuture asyncLoad(Object x$1, Executor x$2) {
                return super.asyncLoad(x$1, x$2);
            }

            @Nonnull
            public CompletableFuture<Map<Tuple2<FileContext, Path>, Boolean>> asyncLoadAll(Iterable<? extends Tuple2<FileContext, Path>> x$1, Executor x$2) {
                return super.asyncLoadAll(x$1, x$2);
            }

            @CheckForNull
            public Object reload(Object x$1, Object x$2) throws Exception {
                return super.reload(x$1, x$2);
            }

            @Nonnull
            public CompletableFuture asyncReload(Object x$1, Object x$2, Executor x$3) {
                return super.asyncReload(x$1, x$2, x$3);
            }

            public Boolean load(Tuple2<FileContext, Path> key) {
                return Predef$.MODULE$.boolean2Boolean(((FileContext)key._1()).util().exists((Path)key._2()));
            }
        });
        this.statusCache = Caffeine.newBuilder().expireAfterWrite(this.duration(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<Tuple2<FileContext, Path>, FileStatus>(){

            @Nonnull
            public Map<Tuple2<FileContext, Path>, FileStatus> loadAll(Iterable<? extends Tuple2<FileContext, Path>> x$1) throws Exception {
                return super.loadAll(x$1);
            }

            @Nonnull
            public CompletableFuture asyncLoad(Object x$1, Executor x$2) {
                return super.asyncLoad(x$1, x$2);
            }

            @Nonnull
            public CompletableFuture<Map<Tuple2<FileContext, Path>, FileStatus>> asyncLoadAll(Iterable<? extends Tuple2<FileContext, Path>> x$1, Executor x$2) {
                return super.asyncLoadAll(x$1, x$2);
            }

            @CheckForNull
            public Object reload(Object x$1, Object x$2) throws Exception {
                return super.reload(x$1, x$2);
            }

            @Nonnull
            public CompletableFuture asyncReload(Object x$1, Object x$2, Executor x$3) {
                return super.asyncReload(x$1, x$2, x$3);
            }

            public FileStatus load(Tuple2<FileContext, Path> key) {
                return ((FileContext)key._1()).getFileStatus((Path)key._2());
            }
        });
        this.listCache = Caffeine.newBuilder().expireAfterWrite(this.duration(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<Tuple2<FileContext, Path>, Stream<FileStatus>>(){

            @Nonnull
            public Map<Tuple2<FileContext, Path>, Stream<FileStatus>> loadAll(Iterable<? extends Tuple2<FileContext, Path>> x$1) throws Exception {
                return super.loadAll(x$1);
            }

            @Nonnull
            public CompletableFuture asyncLoad(Object x$1, Executor x$2) {
                return super.asyncLoad(x$1, x$2);
            }

            @Nonnull
            public CompletableFuture<Map<Tuple2<FileContext, Path>, Stream<FileStatus>>> asyncLoadAll(Iterable<? extends Tuple2<FileContext, Path>> x$1, Executor x$2) {
                return super.asyncLoadAll(x$1, x$2);
            }

            @CheckForNull
            public Object reload(Object x$1, Object x$2) throws Exception {
                return super.reload(x$1, x$2);
            }

            @Nonnull
            public CompletableFuture asyncReload(Object x$1, Object x$2, Executor x$3) {
                return super.asyncReload(x$1, x$2, x$3);
            }

            public Stream<FileStatus> load(Tuple2<FileContext, Path> key) {
                return PathCache$RemoteIterator$.MODULE$.apply(((FileContext)key._1()).listStatus((Path)key._2())).toStream();
            }
        });
    }
}

