/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.geotools.data.Query;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.FileSystemThreadedReader$;
import org.locationtech.geomesa.fs.storage.common.SizeableFileSystemStorage;
import org.locationtech.geomesa.fs.storage.common.observer.FileSystemObserver;
import org.locationtech.geomesa.fs.storage.common.observer.FileSystemObserverFactory;
import org.locationtech.geomesa.fs.storage.common.package$;
import org.locationtech.geomesa.fs.storage.common.package$RichSimpleFeatureType$;
import org.locationtech.geomesa.fs.storage.common.utils.PathCache$;
import org.locationtech.geomesa.fs.storage.common.utils.StorageUtils$;
import org.locationtech.geomesa.fs.storage.common.utils.StorageUtils$FileType$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.planning.QueryRunner$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.io.FileSizeEstimator;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.IsFlushable;
import org.locationtech.geomesa.utils.io.IsFlushable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0011mf!B6m\u0003\u0003I\bBCA\u001d\u0001\t\u0015\r\u0011\"\u0001\u0002<!Q\u0011\u0011\u000e\u0001\u0003\u0002\u0003\u0006I!!\u0010\t\u0015\u0005-\u0004A!b\u0001\n\u0003\ti\u0007\u0003\u0006\u0002v\u0001\u0011\t\u0011)A\u0005\u0003_B!\"a\u001e\u0001\u0005\u0003\u0005\u000b\u0011BA=\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017C!\"!&\u0001\u0011\u000b\u0007I\u0011BAL\u0011\u001d\t\t\f\u0001D\t\u0003gCq!!9\u0001\r#\t\u0019\u000fC\u0004\u0004X\u0001!\te!\u0017\t\u000f\rm\u0004\u0001\"\u0011\u0004~!91\u0011\u0015\u0001\u0005B\r\r\u0006bBBQ\u0001\u0011\u00053q\u0015\u0005\b\u0007k\u0003A\u0011IB\\\u0011\u001d\u0019)\f\u0001C!\u0007{Cq!!-\u0001\t\u0013\u0019I\rC\u0005\u0005\u0004\u0001\t\n\u0011\"\u0003\u0005\u0006!9\u0011\u0011\u0017\u0001\u0005\n\u0011%aA\u0002C\t\u0001\u0001!\u0019\u0002\u0003\u0006\u0005\u0016M\u0011\t\u0011)A\u0005\t/A!\u0002b\u0007\u0014\u0005\u0003\u0005\u000b\u0011\u0002C\u000f\u0011\u001d\tIi\u0005C\u0001\tSA\u0011B!\u000f\u0014\u0001\u0004%IAa\u000f\t\u0013\t\r3\u00031A\u0005\n\u0011M\u0002\u0002\u0003B)'\u0001\u0006KA!\u0010\t\u0013\u0011]2\u00031A\u0005\n\tm\u0002\"\u0003C\u001d'\u0001\u0007I\u0011\u0002C\u001e\u0011!!yd\u0005Q!\n\tu\u0002\"\u0003C!'\u0001\u0007I\u0011\u0002B\u001e\u0011%!\u0019e\u0005a\u0001\n\u0013!)\u0005\u0003\u0005\u0005JM\u0001\u000b\u0015\u0002B\u001f\u0011-\u0011ib\u0005a\u0001\u0002\u0004%IA!$\t\u0017\u0011-3\u00031AA\u0002\u0013%AQ\n\u0005\f\u0005\u001f\u001b\u0002\u0019!A!B\u0013\t9\rC\u0006\u0005RM\u0001\r\u00111A\u0005\n\u0011M\u0003b\u0003C+'\u0001\u0007\t\u0019!C\u0005\t/B1\u0002b\u0017\u0014\u0001\u0004\u0005\t\u0015)\u0003\u00026\"9!\u0011N\n\u0005B\u0011u\u0003b\u0002B8'\u0011\u0005#\u0011\u000f\u0005\b\u0005g\u001aB\u0011\tB9\r\u0019!\t\u0007\u0001\u0001\u0005d!QAQM\u0015\u0003\u0002\u0003\u0006Iaa \t\u0015\u0011\u001d\u0014F!A!\u0002\u0013\u0019Y\nC\u0004\u0002\n&\"\t\u0001\"\u001b\t\u0013\u0011E\u0014F1A\u0005\n\u0011M\u0004\u0002\u0003CAS\u0001\u0006I\u0001\"\u001e\t\u0013\u0011\r\u0015F1A\u0005\n\u0011M\u0004\u0002\u0003CCS\u0001\u0006I\u0001\"\u001e\t\u0017\tE\u0011\u00061AA\u0002\u0013%Aq\u0011\u0005\f\t\u0013K\u0003\u0019!a\u0001\n\u0013!Y\tC\u0006\u0005\u0010&\u0002\r\u0011!Q!\n\t\u001d\u0001bCB=S\u0001\u0007\t\u0019!C\u0005\t#C1\u0002b%*\u0001\u0004\u0005\r\u0011\"\u0003\u0005\u0016\"YA\u0011T\u0015A\u0002\u0003\u0005\u000b\u0015BA=\u0011\u001d\u0011I'\u000bC!\u0005cBq\u0001b'*\t\u0003\u0012\t\bC\u0004\u0005\u001e&\"\t\u0005b(\t\u000f\u0011\u0005\u0016\u0006\"\u0011\u0005$\"9!qN\u0015\u0005B\tE\u0004b\u0002B:S\u0011\u0005#\u0011\u000f\u0004\u0007\tK\u0003\u0001\u0001b*\t\u0015\reTH!A!\u0002\u0013\tI\b\u0003\u0006\u0002Fv\u0012\t\u0011)A\u0005\u0003\u000fD!ba4>\u0005\u0003\u0005\u000b\u0011BBi\u0011\u001d\tI)\u0010C\u0001\tWCqA!\u001e>\t#\")lB\u0004\u0002n2D\t!a<\u0007\r-d\u0007\u0012AAy\u0011\u001d\tI\t\u0012C\u0001\u0003g4\u0011\"!>E!\u0003\r\n!a>\t\u000f\u0005ehI\"\u0001\u0002|\u001a9!q\u0004#\u0002\u0002\t\u0005\u0002bBAE\u0011\u0012\u0005!1\u0007\u0005\n\u0005sA\u0005\u0019!C\u0005\u0005wA\u0011Ba\u0011I\u0001\u0004%IA!\u0012\t\u0011\tE\u0003\n)Q\u0005\u0005{A\u0011Ba\u0015I\u0005\u0004%IA!\u0016\t\u0011\t\u001d\u0004\n)A\u0005\u0005/BqA!\u001bI\t\u0003\u0012Y\u0007C\u0004\u0003p!#\tE!\u001d\t\u000f\tM\u0004\n\"\u0011\u0003r!9!Q\u000f%\u0007\u0012\t]dA\u0002B?\t\u0012\u0013y\b\u0003\u0006\u0003\u001eM\u0013)\u001a!C\u0001\u0005\u001bC!Ba$T\u0005#\u0005\u000b\u0011BAd\u0011)\tYk\u0015BK\u0002\u0013\u0005!\u0011\u0013\u0005\u000b\u0005'\u001b&\u0011#Q\u0001\n\u0005m\u0007bBAE'\u0012\u0005!Q\u0013\u0005\n\u0005;\u001b\u0016\u0011!C\u0001\u0005?C\u0011B!*T#\u0003%\tAa*\t\u0013\tu6+%A\u0005\u0002\t}\u0006\"\u0003Bb'\u0006\u0005I\u0011\tBc\u0011%\u0011YmUA\u0001\n\u0003\u0011i\rC\u0005\u0003VN\u000b\t\u0011\"\u0001\u0003X\"I!\u0011]*\u0002\u0002\u0013\u0005#1\u001d\u0005\n\u0005W\u001c\u0016\u0011!C\u0001\u0005[D\u0011Ba>T\u0003\u0003%\tE!?\t\u0013\tm8+!A\u0005B\tu\b\"\u0003B\u0000'\u0006\u0005I\u0011IB\u0001\u000f%\u0019)\u0001RA\u0001\u0012\u0013\u00199AB\u0005\u0003~\u0011\u000b\t\u0011#\u0003\u0004\n!9\u0011\u0011R3\u0005\u0002\r]\u0001\"\u0003B~K\u0006\u0005IQ\tB\u007f\u0011%\u0019I\"ZA\u0001\n\u0003\u001bY\u0002C\u0005\u0004\"\u0015\f\t\u0011\"!\u0004$!I1QG3\u0002\u0002\u0013%1q\u0007\u0002\u001a\u0003\n\u001cHO]1di\u001aKG.Z*zgR,Wn\u0015;pe\u0006<WM\u0003\u0002n]\u000611m\\7n_:T!a\u001c9\u0002\u000fM$xN]1hK*\u0011\u0011O]\u0001\u0003MNT!a\u001d;\u0002\u000f\u001d,w.\\3tC*\u0011QO^\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002o\u0006\u0019qN]4\u0004\u0001MQ\u0001A_A\u0001\u0003\u001b\t)\"!\n\u0011\u0005mtX\"\u0001?\u000b\u0003u\fQa]2bY\u0006L!a ?\u0003\r\u0005s\u0017PU3g!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004]\u0006\u0019\u0011\r]5\n\t\u0005-\u0011Q\u0001\u0002\u0012\r&dWmU=ti\u0016l7\u000b^8sC\u001e,\u0007\u0003BA\b\u0003#i\u0011\u0001\\\u0005\u0004\u0003'a'!G*ju\u0016\f'\r\\3GS2,7+_:uK6\u001cFo\u001c:bO\u0016\u0004B!a\u0006\u0002\"5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"A\u0003ti\u0006$8OC\u0002\u0002 I\fQ!\u001e;jYNLA!a\t\u0002\u001a\tyQ*\u001a;i_\u0012\u0004&o\u001c4jY&tw\r\u0005\u0003\u0002(\u0005URBAA\u0015\u0015\u0011\tY#!\f\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\t\u0005=\u0012\u0011G\u0001\tif\u0004Xm]1gK*\u0011\u00111G\u0001\u0004G>l\u0017\u0002BA\u001c\u0003S\u00111\u0002T1{s2{wmZ5oO\u000691m\u001c8uKb$XCAA\u001f!\u0011\ty$a\u0019\u000f\t\u0005\u0005\u0013q\f\b\u0005\u0003\u0007\niF\u0004\u0003\u0002F\u0005mc\u0002BA$\u00033rA!!\u0013\u0002X9!\u00111JA+\u001d\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)q\u00061AH]8pizJ\u0011a^\u0005\u0003kZL!a\u001d;\n\u0005E\u0014\u0018BA8q\u0013\r\t9A\\\u0005\u0005\u0003C\n)!A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0014q\r\u0002\u0012\r&dWmU=ti\u0016l7i\u001c8uKb$(\u0002BA1\u0003\u000b\t\u0001bY8oi\u0016DH\u000fI\u0001\t[\u0016$\u0018\rZ1uCV\u0011\u0011q\u000e\t\u0005\u0003\u0007\t\t(\u0003\u0003\u0002t\u0005\u0015!aD*u_J\fw-Z'fi\u0006$\u0017\r^1\u0002\u00135,G/\u00193bi\u0006\u0004\u0013!C3yi\u0016t7/[8o!\u0011\tY(a!\u000f\t\u0005u\u0014q\u0010\t\u0004\u0003\u001bb\u0018bAAAy\u00061\u0001K]3eK\u001aLA!!\"\u0002\b\n11\u000b\u001e:j]\u001eT1!!!}\u0003\u0019a\u0014N\\5u}QA\u0011QRAH\u0003#\u000b\u0019\nE\u0002\u0002\u0010\u0001Aq!!\u000f\u0007\u0001\u0004\ti\u0004C\u0004\u0002l\u0019\u0001\r!a\u001c\t\u000f\u0005]d\u00011\u0001\u0002z\u0005IqNY:feZ,'o]\u000b\u0003\u00033\u0003b!a'\u0002\"\u0006\u0015VBAAO\u0015\r\ty\n`\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAR\u0003;\u00131aU3r!\u0011\t9+!,\u000e\u0005\u0005%&bAAVY\u0006AqNY:feZ,'/\u0003\u0003\u00020\u0006%&!\u0007$jY\u0016\u001c\u0016p\u001d;f[>\u00137/\u001a:wKJ4\u0015m\u0019;pef\fAb\u0019:fCR,wK]5uKJ$b!!.\u0002D\u0006e\u0007\u0003BA\\\u0003{sA!!\u0011\u0002:&!\u00111XA\u0003\u0003E1\u0015\u000e\\3TsN$X-\\*u_J\fw-Z\u0005\u0005\u0003\u007f\u000b\tM\u0001\tGS2,7+_:uK6<&/\u001b;fe*!\u00111XA\u0003\u0011\u001d\t)\r\u0003a\u0001\u0003\u000f\fAAZ5mKB!\u0011\u0011ZAk\u001b\t\tYMC\u0002r\u0003\u001bTA!a4\u0002R\u00061\u0001.\u00193p_BT1!a5w\u0003\u0019\t\u0007/Y2iK&!\u0011q[Af\u0005\u0011\u0001\u0016\r\u001e5\t\u000f\u0005-\u0006\u00021\u0001\u0002\\B!\u0011qUAo\u0013\u0011\ty.!+\u0003%\u0019KG.Z*zgR,Wn\u00142tKJ4XM]\u0001\rGJ,\u0017\r^3SK\u0006$WM\u001d\u000b\u0007\u0003K\u001cId!\u0013\u0011\u0007\u0005\u001dhID\u0002\u0002j\u000esA!a\u0011\u0002l&\u0011QN\\\u0001\u001a\u0003\n\u001cHO]1di\u001aKG.Z*zgR,Wn\u0015;pe\u0006<W\rE\u0002\u0002\u0010\u0011\u001b\"\u0001\u0012>\u0015\u0005\u0005=(\u0001\u0006$jY\u0016\u001c\u0016p\u001d;f[B\u000bG\u000f\u001b*fC\u0012,'o\u0005\u0002Gu\u0006!!/Z1e)\u0011\tiPa\u0007\u0011\r\u0005}(1\u0001B\u0004\u001b\t\u0011\tA\u0003\u0003\u0002 \u0006u\u0011\u0002\u0002B\u0003\u0005\u0003\u0011\u0011c\u00117pg\u0016\f'\r\\3Ji\u0016\u0014\u0018\r^8s!\u0011\u0011IAa\u0006\u000e\u0005\t-!\u0002\u0002B\u0007\u0005\u001f\taa]5na2,'\u0002\u0002B\t\u0005'\tqAZ3biV\u0014XMC\u0002\u0003\u0016Y\fqa\u001c9f]\u001eL7/\u0003\u0003\u0003\u001a\t-!!D*j[BdWMR3biV\u0014X\rC\u0004\u0003\u001e\u001d\u0003\r!a2\u0002\tA\fG\u000f\u001b\u0002\u0011\u001b\u0016$\u0018\rZ1uC>\u00137/\u001a:wKJ\u001cR\u0001\u0013B\u0012\u00037\u0004BA!\n\u000305\u0011!q\u0005\u0006\u0005\u0005S\u0011Y#\u0001\u0003mC:<'B\u0001B\u0017\u0003\u0011Q\u0017M^1\n\t\tE\"q\u0005\u0002\u0007\u001f\nTWm\u0019;\u0015\u0005\tU\u0002c\u0001B\u001c\u00116\tA)A\u0003d_VtG/\u0006\u0002\u0003>A\u00191Pa\u0010\n\u0007\t\u0005CP\u0001\u0003M_:<\u0017!C2pk:$x\fJ3r)\u0011\u00119E!\u0014\u0011\u0007m\u0014I%C\u0002\u0003Lq\u0014A!\u00168ji\"I!qJ&\u0002\u0002\u0003\u0007!QH\u0001\u0004q\u0012\n\u0014AB2pk:$\b%\u0001\u0004c_VtGm]\u000b\u0003\u0005/\u0002BA!\u0017\u0003d5\u0011!1\f\u0006\u0005\u0005;\u0012y&\u0001\u0003hK>l'b\u0001B1i\u0006\u0019!\u000e^:\n\t\t\u0015$1\f\u0002\t\u000b:4X\r\\8qK\u00069!m\\;oIN\u0004\u0013!B<sSR,G\u0003\u0002B$\u0005[BqA!\u0005P\u0001\u0004\u00119!A\u0003gYV\u001c\b\u000e\u0006\u0002\u0003H\u0005)1\r\\8tK\u00069qN\\\"m_N,GC\u0002B$\u0005s\u0012Y\bC\u0004\u0003TI\u0003\rAa\u0016\t\u000f\te\"\u000b1\u0001\u0003>\taqK]5uKJ\u001cuN\u001c4jON11K\u001fBA\u0005\u000f\u00032a\u001fBB\u0013\r\u0011)\t \u0002\b!J|G-^2u!\rY(\u0011R\u0005\u0004\u0005\u0017c(\u0001D*fe&\fG.\u001b>bE2,WCAAd\u0003\u0015\u0001\u0018\r\u001e5!+\t\tY.A\u0005pEN,'O^3sAQ1!q\u0013BM\u00057\u00032Aa\u000eT\u0011\u001d\u0011i\u0002\u0017a\u0001\u0003\u000fDq!a+Y\u0001\u0004\tY.\u0001\u0003d_BLHC\u0002BL\u0005C\u0013\u0019\u000bC\u0005\u0003\u001ee\u0003\n\u00111\u0001\u0002H\"I\u00111V-\u0011\u0002\u0003\u0007\u00111\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011IK\u000b\u0003\u0002H\n-6F\u0001BW!\u0011\u0011yK!/\u000e\u0005\tE&\u0002\u0002BZ\u0005k\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t]F0\u0001\u0006b]:|G/\u0019;j_:LAAa/\u00032\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u0019\u0016\u0005\u00037\u0014Y+A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u000f\u0004BA!\n\u0003J&!\u0011Q\u0011B\u0014\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011y\rE\u0002|\u0005#L1Aa5}\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011INa8\u0011\u0007m\u0014Y.C\u0002\u0003^r\u00141!\u00118z\u0011%\u0011yEXA\u0001\u0002\u0004\u0011y-A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011)\u000f\u0005\u0004\u0002\u001c\n\u001d(\u0011\\\u0005\u0005\u0005S\fiJ\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002Bx\u0005k\u00042a\u001fBy\u0013\r\u0011\u0019\u0010 \u0002\b\u0005>|G.Z1o\u0011%\u0011y\u0005YA\u0001\u0002\u0004\u0011I.\u0001\u0005iCND7i\u001c3f)\t\u0011y-\u0001\u0005u_N#(/\u001b8h)\t\u00119-\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005_\u001c\u0019\u0001C\u0005\u0003P\r\f\t\u00111\u0001\u0003Z\u0006aqK]5uKJ\u001cuN\u001c4jOB\u0019!qG3\u0014\u000b\u0015\u001cYAa\"\u0011\u0015\r511CAd\u00037\u00149*\u0004\u0002\u0004\u0010)\u00191\u0011\u0003?\u0002\u000fI,h\u000e^5nK&!1QCB\b\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0007\u000f\tQ!\u00199qYf$bAa&\u0004\u001e\r}\u0001b\u0002B\u000fQ\u0002\u0007\u0011q\u0019\u0005\b\u0003WC\u0007\u0019AAn\u0003\u001d)h.\u00199qYf$Ba!\n\u00042A)1pa\n\u0004,%\u00191\u0011\u0006?\u0003\r=\u0003H/[8o!\u001dY8QFAd\u00037L1aa\f}\u0005\u0019!V\u000f\u001d7fe!I11G5\u0002\u0002\u0003\u0007!qS\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\t\t\u000f\rm\u0012\u00021\u0001\u0004>\u00051a-\u001b7uKJ\u0004Ra_B\u0014\u0007\u007f\u0001Ba!\u0011\u0004F5\u001111\t\u0006\u0005\u0007w\u0011\u0019\"\u0003\u0003\u0004H\r\r#A\u0002$jYR,'\u000fC\u0004\u0004L%\u0001\ra!\u0014\u0002\u0013Q\u0014\u0018M\\:g_Jl\u0007#B>\u0004(\r=\u0003cB>\u0004.\u0005e4\u0011\u000b\t\u0005\u0005\u0013\u0019\u0019&\u0003\u0003\u0004V\t-!!E*j[BdWMR3biV\u0014X\rV=qK\u0006aq-\u001a;GS2,\u0007+\u0019;igR!11LB<!\u0019\u0019if!\u001a\u0004j9!1qLB2\u001d\u0011\tie!\u0019\n\u0003uL1!!\u0019}\u0013\u0011\t\u0019ka\u001a\u000b\u0007\u0005\u0005D\u0010\u0005\u0003\u0004l\rEd\u0002BA!\u0007[JAaa\u001c\u0002\u0006\u0005y1\u000b^8sC\u001e,W*\u001a;bI\u0006$\u0018-\u0003\u0003\u0004t\rU$aD*u_J\fw-\u001a$jY\u0016\u0004\u0016\r\u001e5\u000b\t\r=\u0014Q\u0001\u0005\b\u0007sR\u0001\u0019AA=\u0003%\u0001\u0018M\u001d;ji&|g.A\u0005hKR\u0014V-\u00193feRA1qPBC\u00073\u001bi\n\u0005\u0003\u0002@\r\u0005\u0015\u0002BBB\u0003O\u0012\u0001d\u00117pg\u0016\f'\r\\3GK\u0006$XO]3Ji\u0016\u0014\u0018\r^8s\u0011\u001d\u00199i\u0003a\u0001\u0007\u0013\u000b\u0001b\u001c:jO&t\u0017\r\u001c\t\u0005\u0007\u0017\u001b)*\u0004\u0002\u0004\u000e*!1qRBI\u0003\u0011!\u0017\r^1\u000b\u0007\rMe/\u0001\u0005hK>$xn\u001c7t\u0013\u0011\u00199j!$\u0003\u000bE+XM]=\t\u0013\re4\u0002%AA\u0002\rm\u0005#B>\u0004(\u0005e\u0004\"CBP\u0017A\u0005\t\u0019\u0001Bh\u0003\u001d!\bN]3bIN\f\u0011bZ3u/JLG/\u001a:\u0015\t\u0005U6Q\u0015\u0005\b\u0007sb\u0001\u0019AA=)!\u0019Ika,\u00042\u000eM\u0006\u0003BA\\\u0007WKAa!,\u0002B\n1b)\u001b7f'f\u001cH/Z7Va\u0012\fG/Z,sSR,'\u000fC\u0004\u0004<5\u0001\raa\u0010\t\u0013\reT\u0002%AA\u0002\rm\u0005\"CBP\u001bA\u0005\t\u0019\u0001Bh\u0003\u001d\u0019w.\u001c9bGR$bAa\u0012\u0004:\u000em\u0006bBB=\u001d\u0001\u000711\u0014\u0005\b\u0007?s\u0001\u0019\u0001Bh)!\u00119ea0\u0004B\u000e\u001d\u0007bBB=\u001f\u0001\u000711\u0014\u0005\n\u0007\u0007|\u0001\u0013!a\u0001\u0007\u000b\f\u0001BZ5mKNK'0\u001a\t\u0006w\u000e\u001d\"Q\b\u0005\n\u0007?{\u0001\u0013!a\u0001\u0005\u001f$\"\"!.\u0004L\u000e57q\\B\u0000\u0011\u001d\u0019I\b\u0005a\u0001\u0003sBqaa4\u0011\u0001\u0004\u0019\t.\u0001\u0004bGRLwN\u001c\t\u0005\u0007'\u001cIN\u0004\u0003\u0004l\rU\u0017\u0002BBl\u0007k\n\u0011c\u0015;pe\u0006<WMR5mK\u0006\u001bG/[8o\u0013\u0011\u0019Yn!8\u0003#M#xN]1hK\u001aKG.Z!di&|gN\u0003\u0003\u0004X\u000eU\u0004bBBq!\u0001\u000711]\u0001\tM&dW\rV=qKB!1Q]B}\u001d\u0011\u00199oa=\u000f\t\r%8Q\u001e\b\u0005\u0003S\u001cY/C\u0002\u0002 1LAaa<\u0004r\u0006a1\u000b^8sC\u001e,W\u000b^5mg*\u0019\u0011q\u00047\n\t\rU8q_\u0001\t\r&dW\rV=qK*!1q^By\u0013\u0011\u0019Yp!@\u0003\u0011\u0019KG.\u001a+za\u0016TAa!>\u0004x\"IA\u0011\u0001\t\u0011\u0002\u0003\u00071QY\u0001\u000fi\u0006\u0014x-\u001a;GS2,7+\u001b>f\u0003Y\u0019'/Z1uK^\u0013\u0018\u000e^3sI\u0011,g-Y;mi\u0012\"TC\u0001C\u0004U\u0011\u0019)Ma+\u0015\t\u0005UF1\u0002\u0005\b\t\u001b\u0011\u0002\u0019\u0001C\b\u0003\u0019\u0019wN\u001c4jOB\u0019\u0011q]*\u0003/\rCWO\\6fI\u001aKG.Z*zgR,Wn\u0016:ji\u0016\u00148#B\n\u0003$\u0005U\u0016!\u00029bi\"\u001c\bCBB/\t3!y!\u0003\u0003\u0003j\u000e\u001d\u0014!C3ti&l\u0017\r^8s!\u0011!y\u0002\"\n\u000e\u0005\u0011\u0005\"\u0002\u0002C\u0012\u0003;\t!![8\n\t\u0011\u001dB\u0011\u0005\u0002\u0012\r&dWmU5{K\u0016\u001bH/[7bi>\u0014HC\u0002C\u0016\t_!\t\u0004E\u0002\u0005.Mi\u0011\u0001\u0001\u0005\b\t+1\u0002\u0019\u0001C\f\u0011\u001d!YB\u0006a\u0001\t;!BAa\u0012\u00056!I!q\n\r\u0002\u0002\u0003\u0007!QH\u0001\u0006i>$\u0018\r\\\u0001\ni>$\u0018\r\\0%KF$BAa\u0012\u0005>!I!qJ\u000e\u0002\u0002\u0003\u0007!QH\u0001\u0007i>$\u0018\r\u001c\u0011\u0002\u0013I,W.Y5oS:<\u0017!\u0004:f[\u0006Lg.\u001b8h?\u0012*\u0017\u000f\u0006\u0003\u0003H\u0011\u001d\u0003\"\u0003B(=\u0005\u0005\t\u0019\u0001B\u001f\u0003)\u0011X-\\1j]&tw\rI\u0001\ta\u0006$\bn\u0018\u0013fcR!!q\tC(\u0011%\u0011y%IA\u0001\u0002\u0004\t9-\u0001\u0004xe&$XM]\u000b\u0003\u0003k\u000b!b\u001e:ji\u0016\u0014x\fJ3r)\u0011\u00119\u0005\"\u0017\t\u0013\t=C%!AA\u0002\u0005U\u0016aB<sSR,'\u000f\t\u000b\u0005\u0005\u000f\"y\u0006C\u0004\u0003\u0012\u0019\u0002\rAa\u0002\u00035\u0019KG.Z*zgR,W.\u00169eCR,wK]5uKJLU\u000e\u001d7\u0014\t%R8\u0011V\u0001\u0007e\u0016\fG-\u001a:\u0002\u001bI,\u0017\r\u001a)beRLG/[8o)\u0019!Y\u0007\"\u001c\u0005pA\u0019AQF\u0015\t\u000f\u0011\u0015D\u00061\u0001\u0004\u0000!9Aq\r\u0017A\u0002\rm\u0015!C7pI&4\u0017.\u001a:t+\t!)\b\u0005\u0005\u0005x\u0011u\u0014\u0011PA[\u001b\t!IH\u0003\u0003\u0005|\u0005u\u0015aB7vi\u0006\u0014G.Z\u0005\u0005\t\u007f\"IHA\u0002NCB\f!\"\\8eS\u001aLWM]:!\u0003!!W\r\\3uKJ\u001c\u0018!\u00033fY\u0016$XM]:!+\t\u00119!A\u0006gK\u0006$XO]3`I\u0015\fH\u0003\u0002B$\t\u001bC\u0011Ba\u00143\u0003\u0003\u0005\rAa\u0002\u0002\u0011\u0019,\u0017\r^;sK\u0002*\"!!\u001f\u0002\u001bA\f'\u000f^5uS>tw\fJ3r)\u0011\u00119\u0005b&\t\u0013\t=S'!AA\u0002\u0005e\u0014A\u00039beRLG/[8oA\u00051!/Z7pm\u0016\fq\u0001[1t\u001d\u0016DH/\u0006\u0002\u0003p\u0006!a.\u001a=u)\t\u00119A\u0001\bVa\u0012\fG/Z(cg\u0016\u0014h/\u001a:\u0014\u0007u\"I\u000bE\u0002\u0002h\"#\u0002\u0002\",\u00050\u0012EF1\u0017\t\u0004\t[i\u0004bBB=\u0003\u0002\u0007\u0011\u0011\u0010\u0005\b\u0003\u000b\f\u0005\u0019AAd\u0011\u001d\u0019y-\u0011a\u0001\u0007#$bAa\u0012\u00058\u0012e\u0006b\u0002B*\u0005\u0002\u0007!q\u000b\u0005\b\u0005s\u0011\u0005\u0019\u0001B\u001f\u0001")
public abstract class AbstractFileSystemStorage
implements SizeableFileSystemStorage,
MethodProfiling {
    private Seq<FileSystemObserverFactory> org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers;
    private final package.FileSystemContext context;
    private final StorageMetadata metadata;
    private final String extension;
    private Logger logger;
    private final float org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$fileSizeError;
    private float org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$averageBytesPerFeature;
    private volatile byte bitmap$0;

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, (String)message, code);
    }

    @Override
    public Option<Object> targetSize(Option<Object> size) {
        return SizeableFileSystemStorage.targetSize$(this, size);
    }

    @Override
    public boolean fileIsSized(Path path, long target) {
        return SizeableFileSystemStorage.fileIsSized$(this, path, target);
    }

    @Override
    public FileSizeEstimator estimator(long size) {
        return SizeableFileSystemStorage.estimator$(this, size);
    }

    @Override
    public void updateFileSize(FileSizeEstimator estimator) {
        SizeableFileSystemStorage.updateFileSize$(this, estimator);
    }

    public Seq<StorageMetadata.PartitionMetadata> getPartitions() {
        return FileSystemStorage.getPartitions$((FileSystemStorage)this);
    }

    public Seq<StorageMetadata.PartitionMetadata> getPartitions(Filter filter) {
        return FileSystemStorage.getPartitions$((FileSystemStorage)this, (Filter)filter);
    }

    public Seq<package.PartitionFilter> getPartitionFilters(Filter filter, Option<String> partition) {
        return FileSystemStorage.getPartitionFilters$((FileSystemStorage)this, (Filter)filter, partition);
    }

    public Option<String> getPartitionFilters$default$2() {
        return FileSystemStorage.getPartitionFilters$default$2$((FileSystemStorage)this);
    }

    public Option<String> getReader$default$2() {
        return FileSystemStorage.getReader$default$2$((FileSystemStorage)this);
    }

    public int getReader$default$3() {
        return FileSystemStorage.getReader$default$3$((FileSystemStorage)this);
    }

    public Option<String> getWriter$default$2() {
        return FileSystemStorage.getWriter$default$2$((FileSystemStorage)this);
    }

    public int getWriter$default$3() {
        return FileSystemStorage.getWriter$default$3$((FileSystemStorage)this);
    }

    public void close() {
        FileSystemStorage.close$((FileSystemStorage)this);
    }

    public Option<Object> compact$default$2() {
        return package.Compactable.compact$default$2$((package.Compactable)this);
    }

    public int compact$default$3() {
        return package.Compactable.compact$default$3$((package.Compactable)this);
    }

    private Logger logger$lzycompute() {
        AbstractFileSystemStorage abstractFileSystemStorage = this;
        synchronized (abstractFileSystemStorage) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public float org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$fileSizeError() {
        return this.org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$fileSizeError;
    }

    @Override
    public float org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$averageBytesPerFeature() {
        return this.org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$averageBytesPerFeature;
    }

    @Override
    public void org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$averageBytesPerFeature_$eq(float x$1) {
        this.org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$averageBytesPerFeature = x$1;
    }

    @Override
    public final void org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$_setter_$org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$fileSizeError_$eq(float x$1) {
        this.org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$fileSizeError = x$1;
    }

    public package.FileSystemContext context() {
        return this.context;
    }

    public StorageMetadata metadata() {
        return this.metadata;
    }

    private Seq<FileSystemObserverFactory> observers$lzycompute() {
        AbstractFileSystemStorage abstractFileSystemStorage = this;
        synchronized (abstractFileSystemStorage) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Builder builder = Seq$.MODULE$.newBuilder();
                package$RichSimpleFeatureType$.MODULE$.getObservers$extension(package$.MODULE$.RichSimpleFeatureType(this.metadata().sft())).foreach((Function1 & Serializable & scala.Serializable)c -> {
                    AbstractFileSystemStorage.$anonfun$observers$1(this, builder, c);
                    return BoxedUnit.UNIT;
                });
                this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers = (Seq)builder.result();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers;
    }

    public Seq<FileSystemObserverFactory> org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.observers$lzycompute() : this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers;
    }

    public abstract FileSystemStorage.FileSystemWriter createWriter(Path var1, FileSystemObserver var2);

    public abstract FileSystemPathReader createReader(Option<Filter> var1, Option<Tuple2<String, SimpleFeatureType>> var2);

    public Seq<StorageMetadata.StorageFilePath> getFilePaths(String partition) {
        Seq seq;
        Option option = this.metadata().getPartition(partition);
        if (None$.MODULE$.equals(option)) {
            seq = (Seq)Nil$.MODULE$;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            StorageMetadata.PartitionMetadata p = (StorageMetadata.PartitionMetadata)some.value();
            Path baseDir = StorageUtils$.MODULE$.baseDirectory(this.context().root(), partition, this.metadata().leafStorage());
            seq = (Seq)p.files().flatMap((Function1 & Serializable & scala.Serializable)file -> {
                Seq seq;
                Path path = new Path(baseDir, file.name());
                if (PathCache$.MODULE$.exists(this.context().fc(), path, PathCache$.MODULE$.exists$default$3())) {
                    seq = (Seq)new .colon.colon((Object)new StorageMetadata.StorageFilePath(file, path), (List)Nil$.MODULE$);
                } else {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Inconsistent metadata for {}: {}", new Object[]{this.metadata().sft().getTypeName(), path});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    seq = (Seq)Nil$.MODULE$;
                }
                return seq;
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError((Object)option);
        }
        return seq;
    }

    public Iterator<SimpleFeature> getReader(Query original, Option<String> partition, int threads) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        Query query = QueryRunner$.MODULE$.configureDefaultQuery(this.metadata().sft(), original);
        Option transform = QueryHints$.MODULE$.RichHints(query.getHints()).getTransform();
        Filter filter = (Filter)Option$.MODULE$.apply((Object)query.getFilter()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Filter.INCLUDE);
        Seq<package.PartitionFilter> filters = this.getPartitionFilters(filter, partition);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running query '{}' {}", (Object[])new String[]{query.getTypeName(), ECQL.toCQL((Filter)query.getFilter())});
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("  Original filter: {}", new Object[]{ECQL.toCQL((Filter)original.getFilter())});
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new java.lang.StringBuilder(14).append("  Transforms: ").append(QueryHints$.MODULE$.RichHints(query.getHints()).getTransformDefinition().map((Function1 & Serializable & scala.Serializable)t -> t.isEmpty() ? "empty" : t).getOrElse((Function0 & Serializable & scala.Serializable)() -> "none")).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new java.lang.StringBuilder(56).append("  Threading the read of ").append(((TraversableOnce)filters.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)AbstractFileSystemStorage.$anonfun$getReader$4(x$1)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)).append(" partitions with ").append(threads).append(" reader threads").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Iterator readers = filters.iterator().flatMap((Function1 & Serializable & scala.Serializable)fp -> {
            LazyRef reader$lzy = new LazyRef();
            return fp.partitions().iterator().flatMap((Function1 & Serializable & scala.Serializable)p -> {
                Seq<StorageMetadata.StorageFilePath> files = this.getFilePaths((String)p);
                return files.isEmpty() ? scala.package$.MODULE$.Iterator().empty() : scala.package$.MODULE$.Iterator().single((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.reader$1(reader$lzy, (package.PartitionFilter)fp, transform)), files));
            });
        });
        return readers.isEmpty() ? CloseableIterator$.MODULE$.empty() : FileSystemThreadedReader$.MODULE$.apply((Iterator<Tuple2<FileSystemPathReader, Seq<StorageMetadata.StorageFilePath>>>)readers, threads);
    }

    public FileSystemStorage.FileSystemWriter getWriter(String partition) {
        return this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(partition, StorageMetadata.StorageFileAction$.MODULE$.Append(), StorageUtils$FileType$.MODULE$.Written(), this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter$default$4());
    }

    public FileSystemStorage.FileSystemUpdateWriter getWriter(Filter filter, Option<String> partition, int threads) {
        Query query = new Query(this.metadata().sft().getTypeName(), filter);
        return new FileSystemUpdateWriterImpl(this, this.getReader(query, partition, threads), partition);
    }

    public void compact(Option<String> partition, int threads) {
        this.compact(partition, (Option<Object>)None$.MODULE$, threads);
    }

    public void compact(Option<String> partition2, Option<Object> fileSize, int threads) {
        Option<Object> target = this.targetSize(fileSize);
        ((IterableLike)partition2.map((Function1 & Serializable & scala.Serializable)x$3 -> (Seq)new .colon.colon(x$3, (List)Nil$.MODULE$)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)this.metadata().getPartitions(this.metadata().getPartitions$default$1()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Seq$.MODULE$.canBuildFrom()))).foreach((Function1 & Serializable & scala.Serializable)partition -> {
            AbstractFileSystemStorage.$anonfun$compact$4(this, target, threads, partition);
            return BoxedUnit.UNIT;
        });
    }

    public FileSystemStorage.FileSystemWriter org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(String partition, Enumeration.Value action, Enumeration.Value fileType, Option<Object> targetFileSize) {
        FileSystemStorage.FileSystemWriter fileSystemWriter;
        Option<Object> option = this.targetSize(targetFileSize);
        if (None$.MODULE$.equals(option)) {
            fileSystemWriter = this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(this.pathAndObserver$1(partition, fileType, action));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            long s = BoxesRunTime.unboxToLong((Object)some.value());
            fileSystemWriter = new ChunkedFileSystemWriter(this, (Iterator<WriterConfig>)scala.package$.MODULE$.Iterator().continually((Function0 & Serializable & scala.Serializable)() -> this.pathAndObserver$1(partition, fileType, action)), this.estimator(s));
        } else {
            throw new MatchError(option);
        }
        return fileSystemWriter;
    }

    public FileSystemStorage.FileSystemWriter org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(WriterConfig config) {
        return this.createWriter(config.path(), config.observer());
    }

    public Option<Object> org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter$default$4() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$observers$1(AbstractFileSystemStorage $this, Builder builder$1, String c) {
        try {
            ClassLoader cl = (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ClassLoader.getSystemClassLoader());
            FileSystemObserverFactory observer = (FileSystemObserverFactory)cl.loadClass(c).newInstance();
            builder$1.$plus$eq((Object)observer);
            observer.init($this.context().conf(), $this.context().root(), $this.metadata().sft());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                package.CloseQuietly$.MODULE$.apply(builder$1.result(), (IsCloseable)IsCloseable$.MODULE$.iterableIsCloseable()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    e.addSuppressed(x$1);
                    return BoxedUnit.UNIT;
                });
                throw e;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ int $anonfun$getReader$4(package.PartitionFilter x$1) {
        return x$1.partitions().size();
    }

    public static final /* synthetic */ boolean $anonfun$getReader$6(Filter x$2) {
        Filter filter = x$2;
        IncludeFilter includeFilter = Filter.INCLUDE;
        return filter == null ? includeFilter != null : !filter.equals(includeFilter);
    }

    private final /* synthetic */ FileSystemPathReader reader$lzycompute$1(LazyRef reader$lzy$1, package.PartitionFilter fp$1, Option transform$1) {
        FileSystemPathReader fileSystemPathReader;
        LazyRef lazyRef = reader$lzy$1;
        synchronized (lazyRef) {
            FileSystemPathReader fileSystemPathReader2;
            if (reader$lzy$1.initialized()) {
                fileSystemPathReader2 = (FileSystemPathReader)reader$lzy$1.value();
            } else {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                Option filter = Option$.MODULE$.apply((Object)fp$1.filter()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractFileSystemStorage.$anonfun$getReader$6(x$2)));
                FileSystemPathReader reader = this.createReader((Option<Filter>)filter, (Option<Tuple2<String, SimpleFeatureType>>)transform$1);
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new java.lang.StringBuilder(35).append("  Reading ").append(fp$1.partitions().size()).append(" partitions with filter: ").append(filter.map((Function1 & Serializable & scala.Serializable)x$1 -> ECQL.toCQL((Filter)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "INCLUDE")).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace(new java.lang.StringBuilder(23).append("  Filter: ").append(filter.map((Function1 & Serializable & scala.Serializable)x$1 -> ECQL.toCQL((Filter)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "INCLUDE")).append(" Partitions: ").append(fp$1.partitions().mkString(", ")).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                fileSystemPathReader2 = (FileSystemPathReader)reader$lzy$1.initialize((Object)reader);
            }
            fileSystemPathReader = fileSystemPathReader2;
        }
        return fileSystemPathReader;
    }

    private final FileSystemPathReader reader$1(LazyRef reader$lzy$1, package.PartitionFilter fp$1, Option transform$1) {
        return reader$lzy$1.initialized() ? (FileSystemPathReader)reader$lzy$1.value() : this.reader$lzycompute$1(reader$lzy$1, fp$1, transform$1);
    }

    public static final /* synthetic */ boolean $anonfun$compact$5(AbstractFileSystemStorage $this, long t$1, StorageMetadata.StorageFilePath p) {
        boolean bl;
        if ($this.fileIsSized(p.path(), t$1)) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("Skipping compaction for file [{}] (already target size)", new Object[]{p.path()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private final FileSystemStorage.FileSystemWriter writer$1(String partition$1, Option target$1) {
        return this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(partition$1, StorageMetadata.StorageFileAction$.MODULE$.Append(), StorageUtils$FileType$.MODULE$.Compacted(), (Option<Object>)target$1);
    }

    private static final CloseableIterator threaded$1(FileSystemPathReader reader$2, Seq toCompact$1, int threads$1) {
        return FileSystemThreadedReader$.MODULE$.apply((Iterator<Tuple2<FileSystemPathReader, Seq<StorageMetadata.StorageFilePath>>>)scala.package$.MODULE$.Iterator().single((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reader$2), (Object)toCompact$1)), threads$1);
    }

    public static final /* synthetic */ void $anonfun$compact$8(LongRef written$1, Envelope bounds$1, FileSystemStorage.FileSystemWriter x0$1, CloseableIterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            FileSystemStorage.FileSystemWriter writer = (FileSystemStorage.FileSystemWriter)tuple2._1();
            CloseableIterator features = (CloseableIterator)tuple2._2();
            while (features.hasNext()) {
                SimpleFeature feature = (SimpleFeature)features.next();
                writer.write(feature);
                ++written$1.elem;
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                if (geom == null) continue;
                bounds$1.expandToInclude(geom.getEnvelopeInternal());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$compact$10(AbstractFileSystemStorage $this, ListBuffer failures$1, StorageMetadata.StorageFilePath file) {
        if (!$this.context().fc().delete(file.path(), false)) {
            failures$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{file.path()}));
        }
        PathCache$.MODULE$.invalidate($this.context().fc(), file.path());
    }

    public static final /* synthetic */ void $anonfun$compact$4(AbstractFileSystemStorage $this, Option target$1, int threads$1, String partition) {
        Seq seq;
        Seq paths = $this.getFilePaths(partition);
        Option option = target$1;
        if (None$.MODULE$.equals(option)) {
            seq = paths;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            long t = BoxesRunTime.unboxToLong((Object)some.value());
            seq = (Seq)paths.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AbstractFileSystemStorage.$anonfun$compact$5($this, t, p)));
        } else {
            throw new MatchError((Object)option);
        }
        Seq toCompact = seq;
        if (toCompact.isEmpty()) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("Skipping compaction - no files to compact");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else if (toCompact.lengthCompare(1) == 0 && target$1.forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$5 -> $this.fileIsSized(((StorageMetadata.StorageFilePath)toCompact.head()).path(), x$5))) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("Skipping compaction for single data file [{}]", new Object[]{toCompact.mkString()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            BoxedUnit boxedUnit4;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("Compacting data files: [{}]", new Object[]{toCompact.mkString(", ")});
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            LongRef written = LongRef.create((long)0L);
            Envelope bounds = new Envelope();
            FileSystemPathReader reader = $this.createReader((Option<Filter>)None$.MODULE$, (Option<Tuple2<String, SimpleFeatureType>>)None$.MODULE$);
            package.WithClose$.MODULE$.apply((Object)$this.writer$1(partition, target$1), (Function0 & Serializable & scala.Serializable)() -> AbstractFileSystemStorage.threaded$1(reader, toCompact, threads$1), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                AbstractFileSystemStorage.$anonfun$compact$8(written, bounds, x0$1, x1$1);
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable(), IsCloseable$.MODULE$.closeableIsCloseable());
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("Deleting old files [{}]", new Object[]{toCompact.mkString(", ")});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            $this.metadata().removePartition(new StorageMetadata.PartitionMetadata(partition, (Seq)toCompact.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.file(), Seq$.MODULE$.canBuildFrom()), StorageMetadata.PartitionBounds$.MODULE$.apply(bounds), written.elem));
            ListBuffer failures = (ListBuffer)ListBuffer$.MODULE$.empty();
            toCompact.foreach((Function1 & Serializable & scala.Serializable)file -> {
                AbstractFileSystemStorage.$anonfun$compact$10($this, failures, file);
                return BoxedUnit.UNIT;
            });
            if (failures.nonEmpty()) {
                if ($this.logger().underlying().isErrorEnabled()) {
                    $this.logger().underlying().error("Failed to delete some files: [{}]", new Object[]{failures.mkString(", ")});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("Compacted {} records", new Object[]{BoxesRunTime.boxToLong((long)written.elem)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private final WriterConfig pathAndObserver$1(String partition$2, Enumeration.Value fileType$1, Enumeration.Value action$1) {
        Path path = StorageUtils$.MODULE$.nextFile(this.context().root(), partition$2, this.metadata().leafStorage(), this.extension, fileType$1, StorageUtils$.MODULE$.nextFile$default$6());
        PathCache$.MODULE$.register(this.context().fc(), path, PathCache$.MODULE$.register$default$3(), PathCache$.MODULE$.register$default$4());
        UpdateObserver updateObserver = new UpdateObserver(this, partition$2, path, action$1);
        FileSystemObserver observer = this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers().isEmpty() ? updateObserver : new FileSystemObserverFactory.CompositeObserver((Seq<FileSystemObserver>)((Seq)((SeqLike)this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.apply(path), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)updateObserver, Seq$.MODULE$.canBuildFrom())));
        return new WriterConfig(path, observer);
    }

    public AbstractFileSystemStorage(package.FileSystemContext context, StorageMetadata metadata, String extension) {
        this.context = context;
        this.metadata = metadata;
        this.extension = extension;
        package.Compactable.$init$((package.Compactable)this);
        FileSystemStorage.$init$((FileSystemStorage)this);
        SizeableFileSystemStorage.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        MethodProfiling.$init$((MethodProfiling)this);
    }

    public class ChunkedFileSystemWriter
    implements FileSystemStorage.FileSystemWriter {
        private final Iterator<WriterConfig> paths;
        private final FileSizeEstimator estimator;
        private long count;
        private long total;
        private long remaining;
        private Path path;
        private FileSystemStorage.FileSystemWriter writer;
        public final /* synthetic */ AbstractFileSystemStorage $outer;

        private long count() {
            return this.count;
        }

        private void count_$eq(long x$1) {
            this.count = x$1;
        }

        private long total() {
            return this.total;
        }

        private void total_$eq(long x$1) {
            this.total = x$1;
        }

        private long remaining() {
            return this.remaining;
        }

        private void remaining_$eq(long x$1) {
            this.remaining = x$1;
        }

        private Path path() {
            return this.path;
        }

        private void path_$eq(Path x$1) {
            this.path = x$1;
        }

        private FileSystemStorage.FileSystemWriter writer() {
            return this.writer;
        }

        private void writer_$eq(FileSystemStorage.FileSystemWriter x$1) {
            this.writer = x$1;
        }

        public void write(SimpleFeature feature) {
            block1: {
                if (this.writer() == null) {
                    WriterConfig config = (WriterConfig)this.paths.next();
                    this.path_$eq(config.path());
                    this.writer_$eq(this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$ChunkedFileSystemWriter$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(config));
                }
                this.writer().write(feature);
                this.count_$eq(this.count() + 1L);
                this.remaining_$eq(this.remaining() - 1L);
                if (this.remaining() != 0L) break block1;
                this.writer().close();
                this.writer_$eq(null);
                this.total_$eq(this.total() + this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$ChunkedFileSystemWriter$$$outer().context().fc().getFileStatus(this.path()).getLen());
                this.estimator.update(this.total(), this.count());
                this.remaining_$eq(this.estimator.estimate(0L));
            }
        }

        public void flush() {
            block0: {
                if (this.writer() == null) break block0;
                this.writer().flush();
            }
        }

        public void close() {
            if (this.writer() != null) {
                this.writer().close();
            }
            this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$ChunkedFileSystemWriter$$$outer().updateFileSize(this.estimator);
        }

        public /* synthetic */ AbstractFileSystemStorage org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$ChunkedFileSystemWriter$$$outer() {
            return this.$outer;
        }

        public ChunkedFileSystemWriter(AbstractFileSystemStorage $outer, Iterator<WriterConfig> paths, FileSizeEstimator estimator) {
            this.paths = paths;
            this.estimator = estimator;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.count = 0L;
            this.total = 0L;
            this.remaining = estimator.estimate(0L);
        }
    }

    public static interface FileSystemPathReader {
        public CloseableIterator<SimpleFeature> read(Path var1);
    }

    public class FileSystemUpdateWriterImpl
    implements FileSystemStorage.FileSystemUpdateWriter {
        private final Iterator<SimpleFeature> reader;
        private final Option<String> readPartition;
        private final Map<String, FileSystemStorage.FileSystemWriter> modifiers;
        private final Map<String, FileSystemStorage.FileSystemWriter> deleters;
        private SimpleFeature feature;
        private String partition;
        public final /* synthetic */ AbstractFileSystemStorage $outer;

        public Iterator<SimpleFeature> seq() {
            return Iterator.seq$((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.isEmpty$((Iterator)this);
        }

        public boolean isTraversableAgain() {
            return Iterator.isTraversableAgain$((Iterator)this);
        }

        public boolean hasDefiniteSize() {
            return Iterator.hasDefiniteSize$((Iterator)this);
        }

        public Iterator<SimpleFeature> take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        public Iterator<SimpleFeature> drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        public Iterator<SimpleFeature> slice(int from, int until) {
            return Iterator.slice$((Iterator)this, (int)from, (int)until);
        }

        public Iterator<SimpleFeature> sliceIterator(int from, int until) {
            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<B> map(Function1<SimpleFeature, B> f) {
            return Iterator.map$((Iterator)this, f);
        }

        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
            return Iterator.$plus$plus$((Iterator)this, that);
        }

        public <B> Iterator<B> flatMap(Function1<SimpleFeature, GenTraversableOnce<B>> f) {
            return Iterator.flatMap$((Iterator)this, f);
        }

        public Iterator<SimpleFeature> filter(Function1<SimpleFeature, Object> p) {
            return Iterator.filter$((Iterator)this, p);
        }

        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<SimpleFeature, B, Object> p) {
            return Iterator.corresponds$((Iterator)this, that, p);
        }

        public Iterator<SimpleFeature> withFilter(Function1<SimpleFeature, Object> p) {
            return Iterator.withFilter$((Iterator)this, p);
        }

        public Iterator<SimpleFeature> filterNot(Function1<SimpleFeature, Object> p) {
            return Iterator.filterNot$((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<SimpleFeature, B> pf) {
            return Iterator.collect$((Iterator)this, pf);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, SimpleFeature, B> op) {
            return Iterator.scanLeft$((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<SimpleFeature, B, B> op) {
            return Iterator.scanRight$((Iterator)this, z, op);
        }

        public Iterator<SimpleFeature> takeWhile(Function1<SimpleFeature, Object> p) {
            return Iterator.takeWhile$((Iterator)this, p);
        }

        public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> partition(Function1<SimpleFeature, Object> p) {
            return Iterator.partition$((Iterator)this, p);
        }

        public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> span(Function1<SimpleFeature, Object> p) {
            return Iterator.span$((Iterator)this, p);
        }

        public Iterator<SimpleFeature> dropWhile(Function1<SimpleFeature, Object> p) {
            return Iterator.dropWhile$((Iterator)this, p);
        }

        public <B> Iterator<Tuple2<SimpleFeature, B>> zip(Iterator<B> that) {
            return Iterator.zip$((Iterator)this, that);
        }

        public <A1> Iterator<A1> padTo(int len, A1 elem) {
            return Iterator.padTo$((Iterator)this, (int)len, elem);
        }

        public Iterator<Tuple2<SimpleFeature, Object>> zipWithIndex() {
            return Iterator.zipWithIndex$((Iterator)this);
        }

        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
        }

        public <U> void foreach(Function1<SimpleFeature, U> f) {
            Iterator.foreach$((Iterator)this, f);
        }

        public boolean forall(Function1<SimpleFeature, Object> p) {
            return Iterator.forall$((Iterator)this, p);
        }

        public boolean exists(Function1<SimpleFeature, Object> p) {
            return Iterator.exists$((Iterator)this, p);
        }

        public boolean contains(Object elem) {
            return Iterator.contains$((Iterator)this, (Object)elem);
        }

        public Option<SimpleFeature> find(Function1<SimpleFeature, Object> p) {
            return Iterator.find$((Iterator)this, p);
        }

        public int indexWhere(Function1<SimpleFeature, Object> p) {
            return Iterator.indexWhere$((Iterator)this, p);
        }

        public int indexWhere(Function1<SimpleFeature, Object> p, int from) {
            return Iterator.indexWhere$((Iterator)this, p, (int)from);
        }

        public <B> int indexOf(B elem) {
            return Iterator.indexOf$((Iterator)this, elem);
        }

        public <B> int indexOf(B elem, int from) {
            return Iterator.indexOf$((Iterator)this, elem, (int)from);
        }

        public BufferedIterator<SimpleFeature> buffered() {
            return Iterator.buffered$((Iterator)this);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.grouped$((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
        }

        public <B> int sliding$default$2() {
            return Iterator.sliding$default$2$((Iterator)this);
        }

        public int length() {
            return Iterator.length$((Iterator)this);
        }

        public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> duplicate() {
            return Iterator.duplicate$((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <B> void copyToArray(Object xs, int start, int len) {
            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
        }

        public boolean sameElements(Iterator<?> that) {
            return Iterator.sameElements$((Iterator)this, that);
        }

        public Traversable<SimpleFeature> toTraversable() {
            return Iterator.toTraversable$((Iterator)this);
        }

        public Iterator<SimpleFeature> toIterator() {
            return Iterator.toIterator$((Iterator)this);
        }

        public Stream<SimpleFeature> toStream() {
            return Iterator.toStream$((Iterator)this);
        }

        public String toString() {
            return Iterator.toString$((Iterator)this);
        }

        public List<SimpleFeature> reversed() {
            return TraversableOnce.reversed$((TraversableOnce)this);
        }

        public int size() {
            return TraversableOnce.size$((TraversableOnce)this);
        }

        public boolean nonEmpty() {
            return TraversableOnce.nonEmpty$((TraversableOnce)this);
        }

        public int count(Function1<SimpleFeature, Object> p) {
            return TraversableOnce.count$((TraversableOnce)this, p);
        }

        public <B> Option<B> collectFirst(PartialFunction<SimpleFeature, B> pf) {
            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
        }

        public <B> B $div$colon(B z, Function2<B, SimpleFeature, B> op) {
            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
        }

        public <B> B $colon$bslash(B z, Function2<SimpleFeature, B, B> op) {
            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
        }

        public <B> B foldLeft(B z, Function2<B, SimpleFeature, B> op) {
            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
        }

        public <B> B foldRight(B z, Function2<SimpleFeature, B, B> op) {
            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
        }

        public <B> B reduceLeft(Function2<B, SimpleFeature, B> op) {
            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
        }

        public <B> B reduceRight(Function2<SimpleFeature, B, B> op) {
            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, SimpleFeature, B> op) {
            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<SimpleFeature, B, B> op) {
            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
        }

        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
        }

        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, SimpleFeature, B> seqop, Function2<B, B, B> combop) {
            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)TraversableOnce.product$((TraversableOnce)this, num);
        }

        public Object min(Ordering cmp) {
            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object max(Ordering cmp) {
            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object maxBy(Function1 f, Ordering cmp) {
            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public Object minBy(Function1 f, Ordering cmp) {
            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public <B> void copyToBuffer(Buffer<B> dest) {
            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
        }

        public <B> void copyToArray(Object xs, int start) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
        }

        public <B> void copyToArray(Object xs) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
        }

        public <B> Object toArray(ClassTag<B> evidence$1) {
            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
        }

        public List<SimpleFeature> toList() {
            return TraversableOnce.toList$((TraversableOnce)this);
        }

        public Iterable<SimpleFeature> toIterable() {
            return TraversableOnce.toIterable$((TraversableOnce)this);
        }

        public Seq<SimpleFeature> toSeq() {
            return TraversableOnce.toSeq$((TraversableOnce)this);
        }

        public IndexedSeq<SimpleFeature> toIndexedSeq() {
            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
        }

        public <B> Buffer<B> toBuffer() {
            return TraversableOnce.toBuffer$((TraversableOnce)this);
        }

        public <B> Set<B> toSet() {
            return TraversableOnce.toSet$((TraversableOnce)this);
        }

        public Vector<SimpleFeature> toVector() {
            return TraversableOnce.toVector$((TraversableOnce)this);
        }

        public <Col> Col to(CanBuildFrom<Nothing$, SimpleFeature, Col> cbf) {
            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
        }

        public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef$.less.colon.less<SimpleFeature, Tuple2<T, U>> ev) {
            return TraversableOnce.toMap$((TraversableOnce)this, ev);
        }

        public String mkString(String start, String sep, String end) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
        }

        public String mkString(String sep) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
        }

        public String mkString() {
            return TraversableOnce.mkString$((TraversableOnce)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public StringBuilder addString(StringBuilder b, String sep) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
        }

        public StringBuilder addString(StringBuilder b) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
        }

        public int sizeHintIfCheap() {
            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
        }

        private Map<String, FileSystemStorage.FileSystemWriter> modifiers() {
            return this.modifiers;
        }

        private Map<String, FileSystemStorage.FileSystemWriter> deleters() {
            return this.deleters;
        }

        private SimpleFeature feature() {
            return this.feature;
        }

        private void feature_$eq(SimpleFeature x$1) {
            this.feature = x$1;
        }

        private String partition() {
            return this.partition;
        }

        private void partition_$eq(String x$1) {
            this.partition = x$1;
        }

        public void write() {
            String update;
            if (this.feature() == null) {
                throw new IllegalArgumentException("Must call 'next' before calling 'write'");
            }
            String string = update = this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().metadata().scheme().getPartitionName(this.feature());
            String string2 = this.partition();
            if (string == null ? string2 != null : !string.equals(string2)) {
                ((FileSystemStorage.FileSystemWriter)this.deleters().getOrElseUpdate((Object)this.partition(), (Function0 & Serializable & scala.Serializable)() -> this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(this.partition(), StorageMetadata.StorageFileAction$.MODULE$.Delete(), StorageUtils$FileType$.MODULE$.Deleted(), this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter$default$4()))).write(this.feature());
            }
            ((FileSystemStorage.FileSystemWriter)this.modifiers().getOrElseUpdate((Object)update, (Function0 & Serializable & scala.Serializable)() -> this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(update, StorageMetadata.StorageFileAction$.MODULE$.Modify(), StorageUtils$FileType$.MODULE$.Modified(), this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter$default$4()))).write(this.feature());
            this.feature_$eq(null);
        }

        public void remove() {
            if (this.feature() == null) {
                throw new IllegalArgumentException("Must call 'next' before calling 'remove'");
            }
            ((FileSystemStorage.FileSystemWriter)this.deleters().getOrElseUpdate((Object)this.partition(), (Function0 & Serializable & scala.Serializable)() -> this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(this.partition(), StorageMetadata.StorageFileAction$.MODULE$.Delete(), StorageUtils$FileType$.MODULE$.Deleted(), this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter$default$4()))).write(this.feature());
            this.feature_$eq(null);
        }

        public boolean hasNext() {
            return this.reader.hasNext();
        }

        public SimpleFeature next() {
            this.feature_$eq((SimpleFeature)this.reader.next());
            this.partition_$eq((String)this.readPartition.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().metadata().scheme().getPartitionName(this.feature())));
            return this.feature();
        }

        public void flush() {
            package.FlushQuietly$.MODULE$.raise(this.modifiers().values().toSeq().$plus$plus((GenTraversableOnce)this.deleters().values(), Seq$.MODULE$.canBuildFrom()), (IsFlushable)IsFlushable$.MODULE$.iterableIsFlushable());
        }

        public void close() {
            package.CloseQuietly$.MODULE$.raise(((TraversableLike)((TraversableLike)((TraversableLike)new .colon.colon(this.reader, (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)this.modifiers().values(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.deleters().values(), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers(), Seq$.MODULE$.canBuildFrom()), (IsCloseable)IsCloseable$.MODULE$.iterableIsCloseable());
        }

        public /* synthetic */ AbstractFileSystemStorage org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer() {
            return this.$outer;
        }

        public FileSystemUpdateWriterImpl(AbstractFileSystemStorage $outer, Iterator<SimpleFeature> reader, Option<String> readPartition) {
            this.reader = reader;
            this.readPartition = readPartition;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            GenTraversableOnce.$init$((GenTraversableOnce)this);
            TraversableOnce.$init$((TraversableOnce)this);
            Iterator.$init$((Iterator)this);
            this.modifiers = Map$.MODULE$.empty();
            this.deleters = Map$.MODULE$.empty();
        }
    }

    public static abstract class MetadataObserver
    implements FileSystemObserver {
        private long count = 0L;
        private final Envelope bounds = new Envelope();

        private long count() {
            return this.count;
        }

        private void count_$eq(long x$1) {
            this.count = x$1;
        }

        private Envelope bounds() {
            return this.bounds;
        }

        public void write(SimpleFeature feature) {
            block0: {
                this.count_$eq(this.count() + 1L);
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                if (geom == null) break block0;
                this.bounds().expandToInclude(geom.getEnvelopeInternal());
            }
        }

        public void flush() {
        }

        public void close() {
            this.onClose(this.bounds(), this.count());
        }

        public abstract void onClose(Envelope var1, long var2);
    }

    public class UpdateObserver
    extends MetadataObserver {
        private final String partition;
        private final Path file;
        private final Enumeration.Value action;
        public final /* synthetic */ AbstractFileSystemStorage $outer;

        @Override
        public void onClose(Envelope bounds, long count) {
            Seq files = (Seq)new .colon.colon((Object)new StorageMetadata.StorageFile(this.file.getName(), System.currentTimeMillis(), this.action, StorageMetadata.StorageFile$.MODULE$.apply$default$4(), StorageMetadata.StorageFile$.MODULE$.apply$default$5()), (List)Nil$.MODULE$);
            this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$UpdateObserver$$$outer().metadata().addPartition(new StorageMetadata.PartitionMetadata(this.partition, files, StorageMetadata.PartitionBounds$.MODULE$.apply(bounds), count));
        }

        public /* synthetic */ AbstractFileSystemStorage org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$UpdateObserver$$$outer() {
            return this.$outer;
        }

        public UpdateObserver(AbstractFileSystemStorage $outer, String partition, Path file, Enumeration.Value action) {
            this.partition = partition;
            this.file = file;
            this.action = action;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    private static class WriterConfig
    implements Product,
    scala.Serializable {
        private final Path path;
        private final FileSystemObserver observer;

        public Path path() {
            return this.path;
        }

        public FileSystemObserver observer() {
            return this.observer;
        }

        public WriterConfig copy(Path path, FileSystemObserver observer) {
            return new WriterConfig(path, observer);
        }

        public Path copy$default$1() {
            return this.path();
        }

        public FileSystemObserver copy$default$2() {
            return this.observer();
        }

        public String productPrefix() {
            return "WriterConfig";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.path();
                    break;
                }
                case 1: {
                    object = this.observer();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof WriterConfig;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof WriterConfig)) return false;
            boolean bl = true;
            if (!bl) return false;
            WriterConfig writerConfig = (WriterConfig)x$1;
            Path path = this.path();
            Path path2 = writerConfig.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!path.equals(path2)) return false;
            FileSystemObserver fileSystemObserver = this.observer();
            FileSystemObserver fileSystemObserver2 = writerConfig.observer();
            if (fileSystemObserver == null) {
                if (fileSystemObserver2 != null) {
                    return false;
                }
            } else if (!fileSystemObserver.equals(fileSystemObserver2)) return false;
            if (!writerConfig.canEqual(this)) return false;
            return true;
        }

        public WriterConfig(Path path, FileSystemObserver observer) {
            this.path = path;
            this.observer = observer;
            Product.$init$((Product)this);
        }
    }
}

