/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.partitions;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.fs.storage.api.PartitionScheme;
import org.locationtech.geomesa.fs.storage.api.PartitionSchemeFactory;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.partitions.SpatialScheme$Config$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.sfcurve.IndexRange;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg!\u0002\u0012$\u0003\u0003\u0011\u0004\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011\r\u0003!\u0011!Q\u0001\n\u0011CQa\u0014\u0001\u0005\u0002ACq!\u0016\u0001C\u0002\u0013Ea\u000b\u0003\u0004X\u0001\u0001\u0006I\u0001\u0012\u0005\u00061\u00021\t\"\u0017\u0005\u00067\u00021\t\u0002\u0018\u0005\bk\u0002\u0011\r\u0011\"\u0011w\u0011\u00199\b\u0001)A\u0005\u0001\")\u0001\u0010\u0001C!s\"9\u00111\b\u0001\u0005B\u0005u\u0002bBA\u001e\u0001\u0011%\u0011QI\u0004\b\u0003\u0017\u001a\u0003\u0012AA'\r\u0019\u00113\u0005#\u0001\u0002P!1qJ\u0004C\u0001\u0003#:q!a\u0015\u000f\u0011\u0003\t)FB\u0004\u0002Z9A\t!a\u0017\t\r=\u000bB\u0011AA/\u0011!\ty&\u0005b\u0001\n\u00031\u0006bBA1#\u0001\u0006I\u0001\u0012\u0005\t\u0003G\n\"\u0019!C\u0001-\"9\u0011QM\t!\u0002\u0013!\u0005\u0002CA4#\t\u0007I\u0011\u0001,\t\u000f\u0005%\u0014\u0003)A\u0005\t\u001a9\u00111\u000e\b\u0002\u0002\u00055\u0004\"CA;3\t\u0005\t\u0015!\u0003E\u0011\u0019y\u0015\u0004\"\u0001\u0002x!I\u0011QP\rC\u0002\u0013%\u0011q\u0010\u0005\t\u0003+K\u0002\u0015!\u0003\u0002\u0002\"A\u0011qS\rC\u0002\u0013%a\u000bC\u0004\u0002\u001af\u0001\u000b\u0011\u0002#\t\u000f\u0005m\u0015\u0004\"\u0011\u0002\u001e\"9\u0011QY\r\u0007\u0002\u0005\u001d'!D*qCRL\u0017\r\\*dQ\u0016lWM\u0003\u0002%K\u0005Q\u0001/\u0019:uSRLwN\\:\u000b\u0005\u0019:\u0013AB2p[6|gN\u0003\u0002)S\u000591\u000f^8sC\u001e,'B\u0001\u0016,\u0003\t17O\u0003\u0002-[\u00059q-Z8nKN\f'B\u0001\u00180\u00031awnY1uS>tG/Z2i\u0015\u0005\u0001\u0014aA8sO\u000e\u00011c\u0001\u00014sA\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t1\u0011I\\=SK\u001a\u0004\"AO\u001f\u000e\u0003mR!\u0001P\u0014\u0002\u0007\u0005\u0004\u0018.\u0003\u0002?w\ty\u0001+\u0019:uSRLwN\\*dQ\u0016lW-\u0001\u0003cSR\u001c\bC\u0001\u001bB\u0013\t\u0011UGA\u0002J]R\fAaZ3p[B\u0011Q\t\u0014\b\u0003\r*\u0003\"aR\u001b\u000e\u0003!S!!S\u0019\u0002\rq\u0012xn\u001c;?\u0013\tYU'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u0013aa\u0015;sS:<'BA&6\u0003\u0019a\u0014N\\5u}Q\u0019\u0011k\u0015+\u0011\u0005I\u0003Q\"A\u0012\t\u000b}\u001a\u0001\u0019\u0001!\t\u000b\r\u001b\u0001\u0019\u0001#\u0002\r\u0019|'/\\1u+\u0005!\u0015a\u00024pe6\fG\u000fI\u0001\u0007I&<\u0017\u000e^:\u0015\u0005\u0001S\u0006\"B \u0007\u0001\u0004\u0001\u0015AD4f]\u0016\u0014\u0018\r^3SC:<Wm\u001d\u000b\u0003;2\u00042AX2g\u001d\ty\u0016M\u0004\u0002HA&\ta'\u0003\u0002ck\u00059\u0001/Y2lC\u001e,\u0017B\u00013f\u0005\r\u0019V-\u001d\u0006\u0003EV\u0002\"a\u001a6\u000e\u0003!T!![\u0017\u0002\u000fM47-\u001e:wK&\u00111\u000e\u001b\u0002\u000b\u0013:$W\r\u001f*b]\u001e,\u0007\"B7\b\u0001\u0004q\u0017A\u0001=z!\rq6m\u001c\t\u0007iA\u0014(O\u001d:\n\u0005E,$A\u0002+va2,G\u0007\u0005\u00025g&\u0011A/\u000e\u0002\u0007\t>,(\r\\3\u0002\u000b\u0011,\u0007\u000f\u001e5\u0016\u0003\u0001\u000ba\u0001Z3qi\"\u0004\u0013\u0001F4fiNKW\u000e\u001d7jM&,GMR5mi\u0016\u00148\u000fF\u0003{\u0003G\t)\u0004E\u00025wvL!\u0001`\u001b\u0003\r=\u0003H/[8o!\rq6M \t\u0004\u007f\u0006ua\u0002BA\u0001\u00033qA!a\u0001\u0002\u00189!\u0011QAA\u000b\u001d\u0011\t9!a\u0005\u000f\t\u0005%\u0011\u0011\u0003\b\u0005\u0003\u0017\tyAD\u0002H\u0003\u001bI\u0011\u0001M\u0005\u0003]=J!\u0001L\u0017\n\u0005)Z\u0013B\u0001\u0015*\u0013\tat%C\u0002\u0002\u001cm\nq\u0002U1si&$\u0018n\u001c8TG\",W.Z\u0005\u0005\u0003?\t\tC\u0001\tTS6\u0004H.\u001b4jK\u00124\u0015\u000e\u001c;fe*\u0019\u00111D\u001e\t\u000f\u0005\u0015\"\u00021\u0001\u0002(\u00051a-\u001b7uKJ\u0004B!!\u000b\u000225\u0011\u00111\u0006\u0006\u0005\u0003K\tiCC\u0002\u00020=\nqa\u001c9f]\u001eL7/\u0003\u0003\u00024\u0005-\"A\u0002$jYR,'\u000fC\u0005\u00028)\u0001\n\u00111\u0001\u0002:\u0005I\u0001/\u0019:uSRLwN\u001c\t\u0004im$\u0015!G4fi&sG/\u001a:tK\u000e$\u0018N\\4QCJ$\u0018\u000e^5p]N$B!a\u0010\u0002DA!Ag_A!!\rq6\r\u0012\u0005\b\u0003KY\u0001\u0019AA\u0014)\u0019\ty$a\u0012\u0002J!9\u0011Q\u0005\u0007A\u0002\u0005\u001d\u0002bBA\u001c\u0019\u0001\u0007\u0011\u0011H\u0001\u000e'B\fG/[1m'\u000eDW-\\3\u0011\u0005Is1C\u0001\b4)\t\ti%\u0001\u0004D_:4\u0017n\u001a\t\u0004\u0003/\nR\"\u0001\b\u0003\r\r{gNZ5h'\t\t2\u0007\u0006\u0002\u0002V\u0005iq)Z8n\u0003R$(/\u001b2vi\u0016\fabR3p[\u0006#HO]5ckR,\u0007%\u0001\u0007[eI+7o\u001c7vi&|g.A\u0007[eI+7o\u001c7vi&|g\u000eI\u0001\u000e1j\u0013$+Z:pYV$\u0018n\u001c8\u0002\u001daS&GU3t_2,H/[8oA\ti2\u000b]1uS\u0006d\u0007+\u0019:uSRLwN\\*dQ\u0016lWMR1di>\u0014\u0018p\u0005\u0003\u001ag\u0005=\u0004c\u0001\u001e\u0002r%\u0019\u00111O\u001e\u0003-A\u000b'\u000f^5uS>t7k\u00195f[\u00164\u0015m\u0019;pef\fAA\\1nKR!\u0011\u0011PA>!\r\t9&\u0007\u0005\u0007\u0003kZ\u0002\u0019\u0001#\u0002\u00179\fW.\u001a)biR,'O\\\u000b\u0003\u0003\u0003\u0003B!a!\u0002\u00126\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000bI)A\u0003sK\u001e,\u0007P\u0003\u0003\u0002\f\u00065\u0015\u0001B;uS2T!!a$\u0002\t)\fg/Y\u0005\u0005\u0003'\u000b)IA\u0004QCR$XM\u001d8\u0002\u00199\fW.\u001a)biR,'O\u001c\u0011\u0002\u0015I,7o\u001c7vi&|g.A\u0006sKN|G.\u001e;j_:\u0004\u0013\u0001\u00027pC\u0012$b!a(\u0002\"\u0006U\u0006c\u0001\u001b|s!9\u00111\u0015\u0011A\u0002\u0005\u0015\u0016aA:giB!\u0011qUAY\u001b\t\tIK\u0003\u0003\u0002,\u00065\u0016AB:j[BdWM\u0003\u0003\u00020\u00065\u0012a\u00024fCR,(/Z\u0005\u0005\u0003g\u000bIKA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016Dq!a.!\u0001\u0004\tI,\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003w\u000byL\u0004\u0003\u0002\u0002\u0005u\u0016B\u00012<\u0013\u0011\t\t-a1\u0003\u00199\u000bW.\u001a3PaRLwN\\:\u000b\u0005\t\\\u0014\u0001\u00062vS2$\u0007+\u0019:uSRLwN\\*dQ\u0016lW\rF\u0004R\u0003\u0013\fY-!4\t\u000b}\n\u0003\u0019\u0001!\t\u000b\r\u000b\u0003\u0019\u0001#\t\r\u0005=\u0017\u00051\u0001A\u0003%9Wm\\7J]\u0012,\u0007\u0010")
public abstract class SpatialScheme
implements PartitionScheme {
    private final String geom;
    private final String format;
    private final int depth;

    public String pattern() {
        return PartitionScheme.pattern$((PartitionScheme)this);
    }

    public Option<String> getSimplifiedFilters$default$2() {
        return PartitionScheme.getSimplifiedFilters$default$2$((PartitionScheme)this);
    }

    public Filter getCoveringFilter(String partition) {
        return PartitionScheme.getCoveringFilter$((PartitionScheme)this, (String)partition);
    }

    public String format() {
        return this.format;
    }

    public abstract int digits(int var1);

    public abstract Seq<IndexRange> generateRanges(Seq<Tuple4<Object, Object, Object, Object>> var1);

    public int depth() {
        return this.depth;
    }

    public Option<Seq<PartitionScheme.SimplifiedFilter>> getSimplifiedFilters(Filter filter, Option<String> partition) {
        return this.getIntersectingPartitions(filter, partition).map((Function1 & Serializable & scala.Serializable)partitions -> (Seq)new .colon.colon((Object)new PartitionScheme.SimplifiedFilter(filter, partitions, false), (List)Nil$.MODULE$));
    }

    public Option<Seq<String>> getIntersectingPartitions(Filter filter) {
        return this.getIntersectingPartitions(filter, (Option<String>)None$.MODULE$);
    }

    private Option<Seq<String>> getIntersectingPartitions(Filter filter, Option<String> partition) {
        Some some;
        FilterValues geometries = FilterHelper$.MODULE$.extractGeometries(filter, this.geom, true);
        if (geometries.disjoint()) {
            some = new Some((Object)Nil$.MODULE$);
        } else if (geometries.values().isEmpty()) {
            some = None$.MODULE$;
        } else {
            Seq partitions = (Seq)partition.map((Function1 & Serializable & scala.Serializable)x$1 -> (Seq)new .colon.colon(x$1, (List)Nil$.MODULE$)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                Seq<IndexRange> ranges = this.generateRanges((Seq<Tuple4<Object, Object, Object, Object>>)((Seq)geometries.values().map((Function1 & Serializable & scala.Serializable)geometry -> GeometryUtils$.MODULE$.bounds(geometry), Seq$.MODULE$.canBuildFrom())));
                return (Seq)((TraversableLike)((SeqLike)ranges.flatMap((Function1 & Serializable & scala.Serializable)r -> new RichLong(Predef$.MODULE$.longWrapper(r.lower())).to((Object)BoxesRunTime.boxToLong((long)r.upper())), Seq$.MODULE$.canBuildFrom())).distinct()).map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)x$2))), this.format()), Seq$.MODULE$.canBuildFrom());
            });
            some = new Some((Object)partitions);
        }
        return some;
    }

    public SpatialScheme(int bits, String geom) {
        this.geom = geom;
        PartitionScheme.$init$((PartitionScheme)this);
        Predef$.MODULE$.require(bits % 2 == 0, (Function0 & Serializable & scala.Serializable)() -> "Resolution must be an even number");
        this.format = new StringBuilder(3).append("%0").append(this.digits(bits)).append("d").toString();
        this.depth = 1;
    }

    public static abstract class SpatialPartitionSchemeFactory
    implements PartitionSchemeFactory {
        private final String name;
        private final Pattern namePattern;
        private final String resolution;

        private Pattern namePattern() {
            return this.namePattern;
        }

        private String resolution() {
            return this.resolution;
        }

        public Option<PartitionScheme> load(SimpleFeatureType sft, package.NamedOptions config) {
            None$ none$;
            Matcher matcher = this.namePattern().matcher(config.name());
            if (!matcher.matches()) {
                none$ = None$.MODULE$;
            } else {
                String geom = (String)config.options().getOrElse((Object)SpatialScheme$Config$.MODULE$.GeomAttribute(), (Function0 & Serializable & scala.Serializable)() -> RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
                int geomIndex = sft.indexOf(geom);
                if (geomIndex == -1) {
                    throw new IllegalArgumentException(new StringBuilder(40).append(this.name).append(" scheme requires valid geometry field '").append(SpatialScheme$Config$.MODULE$.GeomAttribute()).append("'").toString());
                }
                int res = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)matcher.group(2)).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty())).orElse((Function0 & Serializable & scala.Serializable)() -> config.options().get((Object)this.resolution())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)SpatialPartitionSchemeFactory.$anonfun$load$4(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalArgumentException(new StringBuilder(34).append($this.name).append(" scheme requires bit resolution '").append(this.resolution()).append("'").toString());
                }));
                none$ = new Some((Object)this.buildPartitionScheme(res, geom, geomIndex));
            }
            return none$;
        }

        public abstract SpatialScheme buildPartitionScheme(int var1, String var2, int var3);

        public static final /* synthetic */ int $anonfun$load$4(String x$1) {
            return Integer.parseInt(x$1);
        }

        public SpatialPartitionSchemeFactory(String name) {
            this.name = name;
            this.namePattern = Pattern.compile(new StringBuilder(17).append(name).append("(-([0-9]+)bits?)?").toString());
            this.resolution = new StringBuilder(11).append(name).append("-resolution").toString();
        }
    }
}

