/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.partitions;

import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.fs.storage.api.PartitionScheme;
import org.locationtech.geomesa.fs.storage.api.PartitionSchemeFactory;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.partitions.DateTimeScheme$;
import org.locationtech.geomesa.fs.storage.common.partitions.DateTimeScheme$Config$;
import org.locationtech.geomesa.fs.storage.common.partitions.DateTimeScheme$Formats$;
import org.locationtech.geomesa.utils.date.DateUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.text.DateParsing$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyInt;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r5g\u0001B7o\u0001vD!\"!\t\u0001\u0005+\u0007I\u0011AA\u0012\u0011)\tI\u0004\u0001B\tB\u0003%\u0011Q\u0005\u0005\u000b\u0003w\u0001!Q3A\u0005\u0002\u0005u\u0002BCA&\u0001\tE\t\u0015!\u0003\u0002@!Q\u0011Q\n\u0001\u0003\u0016\u0004%\t!a\u0014\t\u0015\u0005]\u0003A!E!\u0002\u0013\t\t\u0006\u0003\u0006\u0002Z\u0001\u0011)\u001a!C\u0001\u00037B!\"a\u001d\u0001\u0005#\u0005\u000b\u0011BA/\u0011)\t)\b\u0001BK\u0002\u0013\u0005\u0011q\n\u0005\u000b\u0003o\u0002!\u0011#Q\u0001\n\u0005E\u0003bBA=\u0001\u0011\u0005\u00111\u0010\u0005\n\u0003\u0017\u0003!\u0019!C\u0005\u0003\u001bC\u0001\"!(\u0001A\u0003%\u0011q\u0012\u0005\n\u0003?\u0003!\u0019!C!\u0003\u001fB\u0001\"!)\u0001A\u0003%\u0011\u0011\u000b\u0005\n\u0003G\u0003!\u0019!C!\u00037B\u0001\"!*\u0001A\u0003%\u0011Q\f\u0005\b\u0003O\u0003A\u0011IAU\u0011\u001d\t\t\r\u0001C!\u0003\u0007DqAa\u0006\u0001\t\u0003\u0012I\u0002C\u0004\u0003\"\u0001!\tEa\t\t\u000f\t\u001d\u0002\u0001\"\u0003\u0003*!I!Q\u0007\u0001\u0002\u0002\u0013\u0005!q\u0007\u0005\n\u0005\u0007\u0002\u0011\u0013!C\u0001\u0005\u000bB\u0011Ba\u0017\u0001#\u0003%\tA!\u0018\t\u0013\t\u0005\u0004!%A\u0005\u0002\t\r\u0004\"\u0003B4\u0001E\u0005I\u0011\u0001B5\u0011%\u0011i\u0007AI\u0001\n\u0003\u0011\u0019\u0007C\u0005\u0003p\u0001\t\t\u0011\"\u0011\u0003r!I!Q\u0010\u0001\u0002\u0002\u0013\u0005\u0011q\n\u0005\n\u0005\u007f\u0002\u0011\u0011!C\u0001\u0005\u0003C\u0011B!$\u0001\u0003\u0003%\tEa$\t\u0013\tu\u0005!!A\u0005\u0002\t}\u0005\"\u0003BU\u0001\u0005\u0005I\u0011\tBV\u0011%\u0011i\u000bAA\u0001\n\u0003\u0012y\u000bC\u0005\u00032\u0002\t\t\u0011\"\u0011\u00034\u001e9!q\u00178\t\u0002\tefAB7o\u0011\u0003\u0011Y\fC\u0004\u0002z\u0019\"\tA!0\t\u0013\t}fE1A\u0005\u0002\tE\u0004\u0002\u0003BaM\u0001\u0006IAa\u001d\t\u000f\t\rg\u0005\"\u0001\u0003F\u001e9!\u0011\u001b\u0014\t\u0002\tMga\u0002BlM!\u0005!\u0011\u001c\u0005\b\u0003sbC\u0011\u0001Bn\u0011%\u0011i\u000e\fb\u0001\n\u0003\tY\u0006\u0003\u0005\u0003`2\u0002\u000b\u0011BA/\u0011%\u0011\t\u000f\fb\u0001\n\u0003\tY\u0006\u0003\u0005\u0003d2\u0002\u000b\u0011BA/\u0011%\u0011)\u000f\fb\u0001\n\u0003\tY\u0006\u0003\u0005\u0003h2\u0002\u000b\u0011BA/\u0011%\u0011I\u000f\fb\u0001\n\u0003\tY\u0006\u0003\u0005\u0003l2\u0002\u000b\u0011BA/\u000f\u001d\u0011iO\nE\u0001\u0005_4qA!='\u0011\u0003\u0011\u0019\u0010C\u0004\u0002z]\"\tA!>\t\u000f\t\rw\u0007\"\u0001\u0003x\u001a1!q`\u001cA\u0007\u0003A!ba\u0001;\u0005+\u0007I\u0011AA.\u0011)\u0019)A\u000fB\tB\u0003%\u0011Q\f\u0005\u000b\u0003CQ$Q3A\u0005\u0002\u0005\r\u0002BCA\u001du\tE\t\u0015!\u0003\u0002&!Q1q\u0001\u001e\u0003\u0016\u0004%\t!!\u0010\t\u0015\r%!H!E!\u0002\u0013\ty\u0004\u0003\u0005\u0002zi\"\taNB\u0006\u0011%\u0011)DOA\u0001\n\u0003\u0019\u0019\u0002C\u0005\u0003Di\n\n\u0011\"\u0001\u0003j!I!1\f\u001e\u0012\u0002\u0013\u0005!Q\t\u0005\n\u0005CR\u0014\u0013!C\u0001\u0005;B\u0011Ba\u001c;\u0003\u0003%\tE!\u001d\t\u0013\tu$(!A\u0005\u0002\u0005=\u0003\"\u0003B@u\u0005\u0005I\u0011AB\u000e\u0011%\u0011iIOA\u0001\n\u0003\u0012y\tC\u0005\u0003\u001ej\n\t\u0011\"\u0001\u0004 !I!\u0011\u0016\u001e\u0002\u0002\u0013\u0005#1\u0016\u0005\n\u0005[S\u0014\u0011!C!\u0005_C\u0011B!-;\u0003\u0003%\tea\t\b\u0011\r%r\u0007#\u00018\u0007W1\u0001Ba@8\u0011\u000394Q\u0006\u0005\b\u0003szE\u0011AB\u0018\u0011\u001d\u0011\u0019m\u0014C\u0001\u0007cA\u0011Ba1P\u0003\u0003%\ti!\u000f\t\u0013\r\u0005s*!A\u0005\u0002\u000e\r\u0003\"CB)\u001f\u0006\u0005I\u0011BB*\u0011%\u0019Yf\u000eb\u0001\n\u0003\u0019i\u0006\u0003\u0005\u0004`]\u0002\u000b\u0011\u0002B~\u0011%\u0019\tg\u000eb\u0001\n\u0003\u0019i\u0006\u0003\u0005\u0004d]\u0002\u000b\u0011\u0002B~\u0011%\u0019)g\u000eb\u0001\n\u0003\u0019i\u0006\u0003\u0005\u0004h]\u0002\u000b\u0011\u0002B~\u0011%\u0019Ig\u000eb\u0001\n\u0003\u0019i\u0006\u0003\u0005\u0004l]\u0002\u000b\u0011\u0002B~\u0011%\u0019ig\u000eb\u0001\n\u0003\u0019i\u0006\u0003\u0005\u0004p]\u0002\u000b\u0011\u0002B~\u0011%\u0019\th\u000eb\u0001\n\u0003\u0019i\u0006\u0003\u0005\u0004t]\u0002\u000b\u0011\u0002B~\u0011%\u0019)h\u000eb\u0001\n\u0003\u0019i\u0006\u0003\u0005\u0004x]\u0002\u000b\u0011\u0002B~\u0011%\u0019Ih\u000eb\u0001\n\u0003\u0019i\u0006\u0003\u0005\u0004|]\u0002\u000b\u0011\u0002B~\u0011%\u0019ih\u000eb\u0001\n\u0013\u0019y\b\u0003\u0005\u0004\u0006^\u0002\u000b\u0011BBA\r\u0019\u00199I\n\u0001\u0004\n\"9\u0011\u0011P4\u0005\u0002\rE\u0005bBBKO\u0012\u00053q\u0013\u0005\n\u0005\u00074\u0013\u0011!CA\u0007kC\u0011b!\u0011'\u0003\u0003%\ti!1\t\u0013\rEc%!A\u0005\n\rM#A\u0004#bi\u0016$\u0016.\\3TG\",W.\u001a\u0006\u0003_B\f!\u0002]1si&$\u0018n\u001c8t\u0015\t\t(/\u0001\u0004d_6lwN\u001c\u0006\u0003gR\fqa\u001d;pe\u0006<WM\u0003\u0002vm\u0006\u0011am\u001d\u0006\u0003ob\fqaZ3p[\u0016\u001c\u0018M\u0003\u0002zu\u0006aAn\\2bi&|g\u000e^3dQ*\t10A\u0002pe\u001e\u001c\u0001a\u0005\u0005\u0001}\u0006%\u0011QCA\u000e!\ry\u0018QA\u0007\u0003\u0003\u0003Q!!a\u0001\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005\u001d\u0011\u0011\u0001\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004s\u0003\r\t\u0007/[\u0005\u0005\u0003'\tiAA\bQCJ$\u0018\u000e^5p]N\u001b\u0007.Z7f!\ry\u0018qC\u0005\u0005\u00033\t\tAA\u0004Qe>$Wo\u0019;\u0011\u0007}\fi\"\u0003\u0003\u0002 \u0005\u0005!\u0001D*fe&\fG.\u001b>bE2,\u0017!\u00034pe6\fG\u000f^3s+\t\t)\u0003\u0005\u0003\u0002(\u0005URBAA\u0015\u0015\u0011\tY#!\f\u0002\r\u0019|'/\\1u\u0015\u0011\ty#!\r\u0002\tQLW.\u001a\u0006\u0003\u0003g\tAA[1wC&!\u0011qGA\u0015\u0005E!\u0015\r^3US6,gi\u001c:nCR$XM]\u0001\u000bM>\u0014X.\u0019;uKJ\u0004\u0013\u0001C:uKB,f.\u001b;\u0016\u0005\u0005}\u0002\u0003BA!\u0003\u000fj!!a\u0011\u000b\t\u0005\u0015\u0013QF\u0001\ti\u0016l\u0007o\u001c:bY&!\u0011\u0011JA\"\u0005)\u0019\u0005N]8o_Vs\u0017\u000e^\u0001\ngR,\u0007/\u00168ji\u0002\nAa\u001d;faV\u0011\u0011\u0011\u000b\t\u0004\u007f\u0006M\u0013\u0002BA+\u0003\u0003\u00111!\u00138u\u0003\u0015\u0019H/\u001a9!\u0003\r!GoZ\u000b\u0003\u0003;\u0002B!a\u0018\u0002n9!\u0011\u0011MA5!\u0011\t\u0019'!\u0001\u000e\u0005\u0005\u0015$bAA4y\u00061AH]8pizJA!a\u001b\u0002\u0002\u00051\u0001K]3eK\u001aLA!a\u001c\u0002r\t11\u000b\u001e:j]\u001eTA!a\u001b\u0002\u0002\u0005!A\r^4!\u0003!!GoZ%oI\u0016D\u0018!\u00033uO&sG-\u001a=!\u0003\u0019a\u0014N\\5u}Qa\u0011QPAA\u0003\u0007\u000b))a\"\u0002\nB\u0019\u0011q\u0010\u0001\u000e\u00039Dq!!\t\f\u0001\u0004\t)\u0003C\u0004\u0002<-\u0001\r!a\u0010\t\u000f\u000553\u00021\u0001\u0002R!9\u0011\u0011L\u0006A\u0002\u0005u\u0003bBA;\u0017\u0001\u0007\u0011\u0011K\u0001\tiJ,hnY1uKV\u0011\u0011q\u0012\t\b\u007f\u0006E\u0015QSAK\u0013\u0011\t\u0019*!\u0001\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BAL\u00033k!!!\f\n\t\u0005m\u0015Q\u0006\u0002\u000e5>tW\r\u001a#bi\u0016$\u0016.\\3\u0002\u0013Q\u0014XO\\2bi\u0016\u0004\u0013!\u00023faRD\u0017A\u00023faRD\u0007%A\u0004qCR$XM\u001d8\u0002\u0011A\fG\u000f^3s]\u0002\n\u0001cZ3u!\u0006\u0014H/\u001b;j_:t\u0015-\\3\u0015\t\u0005u\u00131\u0016\u0005\b\u0003[\u0013\u0002\u0019AAX\u0003\u001d1W-\u0019;ve\u0016\u0004B!!-\u0002>6\u0011\u00111\u0017\u0006\u0005\u0003k\u000b9,\u0001\u0004tS6\u0004H.\u001a\u0006\u0005\u0003[\u000bILC\u0002\u0002<j\fqa\u001c9f]\u001eL7/\u0003\u0003\u0002@\u0006M&!D*j[BdWMR3biV\u0014X-\u0001\u000bhKR\u001c\u0016.\u001c9mS\u001aLW\r\u001a$jYR,'o\u001d\u000b\u0007\u0003\u000b\u0014\u0019A!\u0005\u0011\u000b}\f9-a3\n\t\u0005%\u0017\u0011\u0001\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\u00055\u0017q[Ao\u001d\u0011\ty-a5\u000f\t\u0005\r\u0014\u0011[\u0005\u0003\u0003\u0007IA!!6\u0002\u0002\u00059\u0001/Y2lC\u001e,\u0017\u0002BAm\u00037\u00141aU3r\u0015\u0011\t).!\u0001\u0011\t\u0005}\u0017Q \b\u0005\u0003C\fIP\u0004\u0003\u0002d\u0006]h\u0002BAs\u0003ktA!a:\u0002t:!\u0011\u0011^Ay\u001d\u0011\tY/a<\u000f\t\u0005\r\u0014Q^\u0005\u0002w&\u0011\u0011P_\u0005\u0003obL!!\u001e<\n\u0005M$\u0018bAA\be&!\u00111`A\u0007\u0003=\u0001\u0016M\u001d;ji&|gnU2iK6,\u0017\u0002BA\u0000\u0005\u0003\u0011\u0001cU5na2Lg-[3e\r&dG/\u001a:\u000b\t\u0005m\u0018Q\u0002\u0005\b\u0005\u000b\u0019\u0002\u0019\u0001B\u0004\u0003\u00191\u0017\u000e\u001c;feB!!\u0011\u0002B\u0007\u001b\t\u0011YA\u0003\u0003\u0003\u0006\u0005e\u0016\u0002\u0002B\b\u0005\u0017\u0011aAR5mi\u0016\u0014\b\"\u0003B\n'A\u0005\t\u0019\u0001B\u000b\u0003%\u0001\u0018M\u001d;ji&|g\u000eE\u0003\u0000\u0003\u000f\fi&A\rhKRLe\u000e^3sg\u0016\u001cG/\u001b8h!\u0006\u0014H/\u001b;j_:\u001cH\u0003\u0002B\u000e\u0005?\u0001Ra`Ad\u0005;\u0001b!!4\u0002X\u0006u\u0003b\u0002B\u0003)\u0001\u0007!qA\u0001\u0012O\u0016$8i\u001c<fe&twMR5mi\u0016\u0014H\u0003\u0002B\u0004\u0005KAqAa\u0005\u0016\u0001\u0004\ti&A\u000bhKR\u001cuN^3sS:<\u0007+\u0019:uSRLwN\\:\u0015\t\t-\"1\u0007\t\u0006\u007f\u0006\u001d'Q\u0006\t\b\u007f\n=\"Q\u0004B\u000f\u0013\u0011\u0011\t$!\u0001\u0003\rQ+\b\u000f\\33\u0011\u001d\u0011)A\u0006a\u0001\u0005\u000f\tAaY8qsRa\u0011Q\u0010B\u001d\u0005w\u0011iDa\u0010\u0003B!I\u0011\u0011E\f\u0011\u0002\u0003\u0007\u0011Q\u0005\u0005\n\u0003w9\u0002\u0013!a\u0001\u0003\u007fA\u0011\"!\u0014\u0018!\u0003\u0005\r!!\u0015\t\u0013\u0005es\u0003%AA\u0002\u0005u\u0003\"CA;/A\u0005\t\u0019AA)\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u0012+\t\u0005\u0015\"\u0011J\u0016\u0003\u0005\u0017\u0002BA!\u0014\u0003X5\u0011!q\n\u0006\u0005\u0005#\u0012\u0019&A\u0005v]\u000eDWmY6fI*!!QKA\u0001\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00053\u0012yEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003`)\"\u0011q\bB%\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"A!\u001a+\t\u0005E#\u0011J\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011YG\u000b\u0003\u0002^\t%\u0013AD2paf$C-\u001a4bk2$H%N\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tM\u0004\u0003\u0002B;\u0005wj!Aa\u001e\u000b\t\te\u0014\u0011G\u0001\u0005Y\u0006tw-\u0003\u0003\u0002p\t]\u0014\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u0007\u0013I\tE\u0002\u0000\u0005\u000bKAAa\"\u0002\u0002\t\u0019\u0011I\\=\t\u0013\t-u$!AA\u0002\u0005E\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u0012B1!1\u0013BM\u0005\u0007k!A!&\u000b\t\t]\u0015\u0011A\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BN\u0005+\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!\u0011\u0015BT!\ry(1U\u0005\u0005\u0005K\u000b\tAA\u0004C_>dW-\u00198\t\u0013\t-\u0015%!AA\u0002\t\r\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005E\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\tM\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0003\"\nU\u0006\"\u0003BFI\u0005\u0005\t\u0019\u0001BB\u00039!\u0015\r^3US6,7k\u00195f[\u0016\u00042!a ''\u00111c0a\u0007\u0015\u0005\te\u0016\u0001\u0002(b[\u0016\fQAT1nK\u0002\nQ!\u00199qYf$B\"! \u0003H\n%'1\u001aBg\u0005\u001fDq!a\u000b+\u0001\u0004\ti\u0006C\u0004\u0002<)\u0002\r!a\u0010\t\u000f\u00055#\u00061\u0001\u0002R!9\u0011\u0011\f\u0016A\u0002\u0005u\u0003bBA;U\u0001\u0007\u0011\u0011K\u0001\u0007\u0007>tg-[4\u0011\u0007\tUG&D\u0001'\u0005\u0019\u0019uN\u001c4jON\u0011AF \u000b\u0003\u0005'\f\u0011\u0003R1uKRKW.\u001a$pe6\fGo\u00149u\u0003I!\u0015\r^3US6,gi\u001c:nCR|\u0005\u000f\u001e\u0011\u0002\u0017M#X\r]+oSR|\u0005\u000f^\u0001\r'R,\u0007/\u00168ji>\u0003H\u000fI\u0001\b'R,\u0007o\u00149u\u0003!\u0019F/\u001a9PaR\u0004\u0013\u0001\u0004#uO\u0006#HO]5ckR,\u0017!\u0004#uO\u0006#HO]5ckR,\u0007%A\u0004G_Jl\u0017\r^:\u0011\u0007\tUwGA\u0004G_Jl\u0017\r^:\u0014\u0005]rHC\u0001Bx)\u0011\u0011Ipa\n\u0011\u000b}\f9Ma?\u0011\u0007\tu((D\u00018\u0005\u00191uN]7biN1!H`A\u000b\u00037\tAA\\1nK\u0006)a.Y7fA\u0005!QO\\5u\u0003\u0015)h.\u001b;!)!\u0011Yp!\u0004\u0004\u0010\rE\u0001bBB\u0002\u0003\u0002\u0007\u0011Q\f\u0005\b\u0003C\t\u0005\u0019AA\u0013\u0011\u001d\u00199!\u0011a\u0001\u0003\u007f!\u0002Ba?\u0004\u0016\r]1\u0011\u0004\u0005\n\u0007\u0007\u0011\u0005\u0013!a\u0001\u0003;B\u0011\"!\tC!\u0003\u0005\r!!\n\t\u0013\r\u001d!\t%AA\u0002\u0005}B\u0003\u0002BB\u0007;A\u0011Ba#I\u0003\u0003\u0005\r!!\u0015\u0015\t\t\u00056\u0011\u0005\u0005\n\u0005\u0017S\u0015\u0011!a\u0001\u0005\u0007#BA!)\u0004&!I!1R'\u0002\u0002\u0003\u0007!1\u0011\u0005\b\u0007\u0007I\u0004\u0019AA/\u0003\u00191uN]7biB\u0019!Q`(\u0014\t=s\u00181\u0004\u000b\u0003\u0007W!\u0002Ba?\u00044\rU2q\u0007\u0005\b\u0007\u0007\t\u0006\u0019AA/\u0011\u001d\tY#\u0015a\u0001\u0003;Bqaa\u0002R\u0001\u0004\ty\u0004\u0006\u0005\u0003|\u000em2QHB \u0011\u001d\u0019\u0019A\u0015a\u0001\u0003;Bq!!\tS\u0001\u0004\t)\u0003C\u0004\u0004\bI\u0003\r!a\u0010\u0002\u000fUt\u0017\r\u001d9msR!1QIB'!\u0015y\u0018qYB$!%y8\u0011JA/\u0003K\ty$\u0003\u0003\u0004L\u0005\u0005!A\u0002+va2,7\u0007C\u0005\u0004PM\u000b\t\u00111\u0001\u0003|\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007+\u0002BA!\u001e\u0004X%!1\u0011\fB<\u0005\u0019y%M[3di\u00061Q*\u001b8vi\u0016,\"Aa?\u0002\u000f5Kg.\u001e;fA\u00051\u0001j\\;sYf\fq\u0001S8ve2L\b%A\u0003EC&d\u00170\u0001\u0004EC&d\u0017\u0010I\u0001\b\u001b>tG\u000f\u001b7z\u0003!iuN\u001c;iYf\u0004\u0013\u0001\u0004&vY&\fg.T5okR,\u0017!\u0004&vY&\fg.T5okR,\u0007%\u0001\u0007Kk2L\u0017M\u001c%pkJd\u00170A\u0007Kk2L\u0017M\u001c%pkJd\u0017\u0010I\u0001\f\u0015Vd\u0017.\u00198EC&d\u00170\u0001\u0007Kk2L\u0017M\u001c#bS2L\b%\u0001\u0004XK\u0016\\G._\u0001\b/\u0016,7\u000e\\=!\u0003\r\tG\u000e\\\u000b\u0003\u0007\u0003\u0003bAa%\u0004\u0004\nm\u0018\u0002BAm\u0005+\u000bA!\u00197mA\tqB)\u0019;f)&lW\rU1si&$\u0018n\u001c8TG\",W.\u001a$bGR|'/_\n\u0005Oz\u001cY\t\u0005\u0003\u0002\f\r5\u0015\u0002BBH\u0003\u001b\u0011a\u0003U1si&$\u0018n\u001c8TG\",W.\u001a$bGR|'/\u001f\u000b\u0003\u0007'\u00032A!6h\u0003\u0011aw.\u00193\u0015\r\re51TBS!\u0015y\u0018qYA\u0005\u0011\u001d\u0019i*\u001ba\u0001\u0007?\u000b1a\u001d4u!\u0011\t\tl!)\n\t\r\r\u00161\u0017\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007bBBTS\u0002\u00071\u0011V\u0001\u0007G>tg-[4\u0011\t\r-6q\u0016\b\u0005\u0003C\u001ci+\u0003\u0003\u0002V\u00065\u0011\u0002BBY\u0007g\u0013ABT1nK\u0012|\u0005\u000f^5p]NTA!!6\u0002\u000eQa\u0011QPB\\\u0007s\u001bYl!0\u0004@\"9\u0011\u0011\u00056A\u0002\u0005\u0015\u0002bBA\u001eU\u0002\u0007\u0011q\b\u0005\b\u0003\u001bR\u0007\u0019AA)\u0011\u001d\tIF\u001ba\u0001\u0003;Bq!!\u001ek\u0001\u0004\t\t\u0006\u0006\u0003\u0004D\u000e-\u0007#B@\u0002H\u000e\u0015\u0007#D@\u0004H\u0006\u0015\u0012qHA)\u0003;\n\t&\u0003\u0003\u0004J\u0006\u0005!A\u0002+va2,W\u0007C\u0005\u0004P-\f\t\u00111\u0001\u0002~\u0001")
public class DateTimeScheme
implements PartitionScheme,
Product,
scala.Serializable {
    private final DateTimeFormatter formatter;
    private final ChronoUnit stepUnit;
    private final int step;
    private final String dtg;
    private final int dtgIndex;
    private final Function1<ZonedDateTime, ZonedDateTime> truncate;
    private final int depth;
    private final String pattern;

    public static Option<Tuple5<DateTimeFormatter, ChronoUnit, Object, String, Object>> unapply(DateTimeScheme dateTimeScheme) {
        return DateTimeScheme$.MODULE$.unapply(dateTimeScheme);
    }

    public static DateTimeScheme apply(DateTimeFormatter dateTimeFormatter, ChronoUnit chronoUnit, int n, String string, int n2) {
        return DateTimeScheme$.MODULE$.apply(dateTimeFormatter, chronoUnit, n, string, n2);
    }

    public static DateTimeScheme apply(String string, ChronoUnit chronoUnit, int n, String string2, int n2) {
        return DateTimeScheme$.MODULE$.apply(string, chronoUnit, n, string2, n2);
    }

    public static String Name() {
        return DateTimeScheme$.MODULE$.Name();
    }

    public Option<String> getSimplifiedFilters$default$2() {
        return PartitionScheme.getSimplifiedFilters$default$2$((PartitionScheme)this);
    }

    public DateTimeFormatter formatter() {
        return this.formatter;
    }

    public ChronoUnit stepUnit() {
        return this.stepUnit;
    }

    public int step() {
        return this.step;
    }

    public String dtg() {
        return this.dtg;
    }

    public int dtgIndex() {
        return this.dtgIndex;
    }

    private Function1<ZonedDateTime, ZonedDateTime> truncate() {
        return this.truncate;
    }

    public int depth() {
        return this.depth;
    }

    public String pattern() {
        return this.pattern;
    }

    public String getPartitionName(SimpleFeature feature) {
        return this.formatter().format(DateUtils$.MODULE$.toInstant((Date)feature.getAttribute(this.dtgIndex())).atZone(ZoneOffset.UTC));
    }

    public Option<Seq<PartitionScheme.SimplifiedFilter>> getSimplifiedFilters(Filter filter, Option<String> partition) {
        return this.getCoveringPartitions(filter).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                Seq covered = (Seq)tuple2._1();
                Seq intersecting = (Seq)tuple2._2();
                Builder result = Seq$.MODULE$.newBuilder();
                if (covered.nonEmpty()) {
                    Seq x$1 = (Seq)package$.MODULE$.partitionSubFilters(filter, (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)package$.MODULE$.isTemporalFilter(x$2, this.dtg())))._2();
                    FilterFactory x$22 = package$.MODULE$.andOption$default$2(x$1);
                    Option coveredFilter = package$.MODULE$.andOption(x$1, x$22);
                    boxedUnit = result.$plus$eq((Object)new PartitionScheme.SimplifiedFilter((Filter)coveredFilter.getOrElse((Function0 & Serializable & scala.Serializable)() -> Filter.INCLUDE), covered, false));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Object object = intersecting.nonEmpty() ? result.$plus$eq((Object)new PartitionScheme.SimplifiedFilter(filter, (Seq)intersecting.distinct(), false)) : BoxedUnit.UNIT;
                Option option = partition;
                if (None$.MODULE$.equals(option)) {
                    return (Seq)result.result();
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String p = (String)some.value();
                    Option matched = ((IterableLike)result.result()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DateTimeScheme.$anonfun$getSimplifiedFilters$4(p, x$3)));
                    return Option$.MODULE$.option2Iterable(matched.map((Function1 & Serializable & scala.Serializable)x$4 -> {
                        Seq x$3 = (Seq)new .colon.colon((Object)p, (List)Nil$.MODULE$);
                        Filter x$42 = x$4.copy$default$1();
                        boolean x$5 = x$4.copy$default$3();
                        return x$4.copy(x$42, x$3, x$5);
                    })).toSeq();
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Option<Seq<String>> getIntersectingPartitions(Filter filter) {
        return this.getCoveringPartitions(filter).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Seq covered = (Seq)tuple2._1();
                Seq intersecting = (Seq)tuple2._2();
                return (Seq)covered.$plus$plus((GenTraversableOnce)intersecting, Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Filter getCoveringFilter(String partition) {
        ZonedDateTime zdt = DateParsing$.MODULE$.parse(partition, this.formatter());
        String start = DateParsing$.MODULE$.format(zdt, DateParsing$.MODULE$.format$default$2());
        String end = DateParsing$.MODULE$.format(zdt.plus(1L, this.stepUnit()), DateParsing$.MODULE$.format$default$2());
        return FilterHelper$.MODULE$.ff().and((Filter)FilterHelper$.MODULE$.ff().greaterOrEqual((Expression)FilterHelper$.MODULE$.ff().property(this.dtg()), (Expression)FilterHelper$.MODULE$.ff().literal((Object)start)), (Filter)FilterHelper$.MODULE$.ff().less((Expression)FilterHelper$.MODULE$.ff().property(this.dtg()), (Expression)FilterHelper$.MODULE$.ff().literal((Object)end)));
    }

    private Option<Tuple2<Seq<String>, Seq<String>>> getCoveringPartitions(Filter filter) {
        Filter x$1 = filter;
        String x$2 = this.dtg();
        boolean x$3 = false;
        boolean x$4 = FilterHelper$.MODULE$.extractIntervals$default$3();
        FilterValues bounds = FilterHelper$.MODULE$.extractIntervals(x$1, x$2, x$4, x$3);
        if (bounds.disjoint()) {
            return new Some((Object)new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$));
        }
        if (bounds.isEmpty() || !bounds.forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isBoundedBothSides()))) {
            return None$.MODULE$;
        }
        ListBuffer covered = (ListBuffer)ListBuffer$.MODULE$.empty();
        ListBuffer intersecting = (ListBuffer)ListBuffer$.MODULE$.empty();
        bounds.values().foreach(arg_0 -> DateTimeScheme.$anonfun$getCoveringPartitions$2(this, covered, intersecting, arg_0));
        return new Some((Object)new Tuple2((Object)covered.toSeq(), (Object)intersecting.toSeq()));
    }

    public DateTimeScheme copy(DateTimeFormatter formatter, ChronoUnit stepUnit, int step, String dtg, int dtgIndex) {
        return new DateTimeScheme(formatter, stepUnit, step, dtg, dtgIndex);
    }

    public DateTimeFormatter copy$default$1() {
        return this.formatter();
    }

    public ChronoUnit copy$default$2() {
        return this.stepUnit();
    }

    public int copy$default$3() {
        return this.step();
    }

    public String copy$default$4() {
        return this.dtg();
    }

    public int copy$default$5() {
        return this.dtgIndex();
    }

    public String productPrefix() {
        return "DateTimeScheme";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.formatter();
            }
            case 1: {
                return this.stepUnit();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.step());
            }
            case 3: {
                return this.dtg();
            }
            case 4: {
                return BoxesRunTime.boxToInteger((int)this.dtgIndex());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DateTimeScheme;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.formatter()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.stepUnit()));
        n = Statics.mix((int)n, (int)this.step());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.dtg()));
        n = Statics.mix((int)n, (int)this.dtgIndex());
        return Statics.finalizeHash((int)n, (int)5);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DateTimeScheme)) return false;
        boolean bl = true;
        if (!bl) return false;
        DateTimeScheme dateTimeScheme = (DateTimeScheme)x$1;
        DateTimeFormatter dateTimeFormatter = this.formatter();
        DateTimeFormatter dateTimeFormatter2 = dateTimeScheme.formatter();
        if (dateTimeFormatter == null) {
            if (dateTimeFormatter2 != null) {
                return false;
            }
        } else if (!dateTimeFormatter.equals(dateTimeFormatter2)) return false;
        ChronoUnit chronoUnit = this.stepUnit();
        ChronoUnit chronoUnit2 = dateTimeScheme.stepUnit();
        if (chronoUnit == null) {
            if (chronoUnit2 != null) {
                return false;
            }
        } else if (!chronoUnit.equals(chronoUnit2)) return false;
        if (this.step() != dateTimeScheme.step()) return false;
        String string = this.dtg();
        String string2 = dateTimeScheme.dtg();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.dtgIndex() != dateTimeScheme.dtgIndex()) return false;
        if (!dateTimeScheme.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$depth$1(char x$1) {
        return x$1 == '/';
    }

    public static final /* synthetic */ boolean $anonfun$getSimplifiedFilters$4(String p$1, PartitionScheme.SimplifiedFilter x$3) {
        return x$3.partitions().contains((Object)p$1);
    }

    private final void addSteps$1(int step, ZonedDateTime current, int steps$1, boolean coveringLast$1, ListBuffer covered$1, ListBuffer intersecting$1) {
        while (true) {
            if (step == steps$1) {
                BoxedUnit boxedUnit;
                if (coveringLast$1) {
                    covered$1.$plus$eq((Object)this.formatter().format(current));
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                intersecting$1.$plus$eq((Object)this.formatter().format(current));
                boxedUnit = BoxedUnit.UNIT;
                break;
            }
            covered$1.$plus$eq((Object)this.formatter().format(current));
            current = current.plus(1L, this.stepUnit());
            ++step;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Object $anonfun$getCoveringPartitions$2(DateTimeScheme $this, ListBuffer covered$1, ListBuffer intersecting$1, Bounds bound) {
        block6: {
            lower = (ZonedDateTime)bound.lower().value().get();
            upper = (ZonedDateTime)bound.upper().value().get();
            start = (ZonedDateTime)$this.truncate().apply((Object)lower);
            end = (ZonedDateTime)$this.truncate().apply((Object)(bound.upper().inclusive() != false ? upper : upper.minus(1L, ChronoUnit.MILLIS)));
            steps = (int)$this.stepUnit().between(start, end);
            if (!bound.lower().inclusive()) ** GOTO lbl-1000
            v0 = lower;
            var10_9 = start;
            if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = coveringFirst = false;
            }
            if (!bound.upper().exclusive()) break block6;
            v2 = upper;
            var12_11 = end.plus(1L, $this.stepUnit());
            if (!(v2 == null ? var12_11 != null : v2.equals(var12_11) == false)) ** GOTO lbl-1000
        }
        if (bound.upper().inclusive() && !upper.isBefore(end.plus(1L, $this.stepUnit()).minus(1L, ChronoUnit.MILLIS))) lbl-1000:
        // 2 sources

        {
            v3 = true;
        } else {
            v3 = coveringLast = false;
        }
        if (steps == 0) {
            if (coveringFirst && coveringLast) {
                return covered$1.$plus$eq((Object)$this.formatter().format(start));
            }
            return intersecting$1.$plus$eq((Object)$this.formatter().format(start));
        }
        v4 = coveringFirst != false ? covered$1.$plus$eq((Object)$this.formatter().format(start)) : intersecting$1.$plus$eq((Object)$this.formatter().format(start));
        $this.addSteps$1(1, start.plus(1L, $this.stepUnit()), steps, coveringLast, covered$1, intersecting$1);
        return BoxedUnit.UNIT;
    }

    public DateTimeScheme(DateTimeFormatter formatter, ChronoUnit stepUnit, int step, String dtg, int dtgIndex) {
        Function1 & Serializable & scala.Serializable intersect;
        this.formatter = formatter;
        this.stepUnit = stepUnit;
        this.step = step;
        this.dtg = dtg;
        this.dtgIndex = dtgIndex;
        PartitionScheme.$init$((PartitionScheme)this);
        Product.$init$((Product)this);
        ChronoUnit chronoUnit = stepUnit;
        if (ChronoUnit.NANOS.equals(chronoUnit) ? true : (ChronoUnit.MICROS.equals(chronoUnit) ? true : (ChronoUnit.MILLIS.equals(chronoUnit) ? true : (ChronoUnit.SECONDS.equals(chronoUnit) ? true : (ChronoUnit.MINUTES.equals(chronoUnit) ? true : (ChronoUnit.HOURS.equals(chronoUnit) ? true : ChronoUnit.DAYS.equals(chronoUnit))))))) {
            intersect = (Function1 & Serializable & scala.Serializable)dt -> dt.truncatedTo(this.stepUnit());
        } else if (ChronoUnit.MONTHS.equals(chronoUnit)) {
            TemporalAdjuster adjuster = TemporalAdjusters.firstDayOfMonth();
            intersect = (Function1 & Serializable & scala.Serializable)dt -> dt.with(adjuster).truncatedTo(ChronoUnit.DAYS);
        } else if (ChronoUnit.YEARS.equals(chronoUnit)) {
            TemporalAdjuster adjuster = TemporalAdjusters.firstDayOfYear();
            intersect = (Function1 & Serializable & scala.Serializable)dt -> dt.with(adjuster).truncatedTo(ChronoUnit.DAYS);
        } else {
            intersect = (Function1 & Serializable & scala.Serializable)dt -> DateParsing$.MODULE$.parse(this.formatter().format((TemporalAccessor)dt), this.formatter());
        }
        this.truncate = intersect;
        this.depth = new StringOps(Predef$.MODULE$.augmentString(formatter.toString())).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DateTimeScheme.$anonfun$depth$1(BoxesRunTime.unboxToChar((Object)x$1)))) + 1;
        this.pattern = formatter.toString();
    }

    public static class DateTimePartitionSchemeFactory
    implements PartitionSchemeFactory {
        public Option<PartitionScheme> load(SimpleFeatureType sft, package.NamedOptions config) {
            LazyInt step$lzy = new LazyInt();
            LazyRef dtg$lzy = new LazyRef();
            LazyInt dtgIndex$lzy = new LazyInt();
            String string = config.name();
            String string2 = DateTimeScheme$.MODULE$.Name();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                DateTimeFormatter dateTimeFormatter;
                ChronoUnit unit = (ChronoUnit)config.options().get((Object)DateTimeScheme$Config$.MODULE$.StepUnitOpt()).map((Function1 & Serializable & scala.Serializable)c -> ChronoUnit.valueOf(c.toUpperCase())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalArgumentException(new StringBuilder(38).append("DateTime scheme requires valid unit '").append(DateTimeScheme$Config$.MODULE$.StepUnitOpt()).append("'").toString());
                });
                String format = (String)config.options().getOrElse((Object)DateTimeScheme$Config$.MODULE$.DateTimeFormatOpt(), (Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalArgumentException(new StringBuilder(40).append("DateTime scheme requires valid format '").append(DateTimeScheme$Config$.MODULE$.DateTimeFormatOpt()).append("'").toString());
                });
                Predef$.MODULE$.require(!format.endsWith("/"), (Function0 & Serializable & scala.Serializable)() -> "Format cannot end with a slash");
                try {
                    dateTimeFormatter = DateTimeFormatter.ofPattern(format);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        throw new IllegalArgumentException(new StringBuilder(23).append("Invalid date format '").append(format).append("':").toString(), e);
                    }
                    throw throwable;
                }
                DateTimeFormatter formatter = dateTimeFormatter;
                return new Some((Object)new DateTimeScheme(formatter, unit, DateTimePartitionSchemeFactory.step$1(step$lzy, config), DateTimePartitionSchemeFactory.dtg$1(dtg$lzy, config, sft), DateTimePartitionSchemeFactory.dtgIndex$1(dtgIndex$lzy, sft, dtg$lzy, config)));
            }
            return DateTimeScheme$Formats$.MODULE$.apply(config.name()).map((Function1 & Serializable & scala.Serializable)f -> new DateTimeScheme(f.formatter(), f.unit(), DateTimePartitionSchemeFactory.step$1(step$lzy, config), DateTimePartitionSchemeFactory.dtg$1(dtg$lzy, config, sft), DateTimePartitionSchemeFactory.dtgIndex$1(dtgIndex$lzy, sft, dtg$lzy, config)));
        }

        public static final /* synthetic */ int $anonfun$load$1(String x$7) {
            return new StringOps(Predef$.MODULE$.augmentString(x$7)).toInt();
        }

        private static final /* synthetic */ int step$lzycompute$1(LazyInt step$lzy$1, package.NamedOptions config$1) {
            int n;
            LazyInt lazyInt = step$lzy$1;
            synchronized (lazyInt) {
                n = step$lzy$1.initialized() ? step$lzy$1.value() : step$lzy$1.initialize(BoxesRunTime.unboxToInt((Object)config$1.options().get((Object)DateTimeScheme$Config$.MODULE$.StepOpt()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)DateTimePartitionSchemeFactory.$anonfun$load$1(x$7))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1)));
            }
            return n;
        }

        private static final int step$1(LazyInt step$lzy$1, package.NamedOptions config$1) {
            if (step$lzy$1.initialized()) {
                return step$lzy$1.value();
            }
            return DateTimePartitionSchemeFactory.step$lzycompute$1(step$lzy$1, config$1);
        }

        private static final /* synthetic */ String dtg$lzycompute$1(LazyRef dtg$lzy$1, package.NamedOptions config$1, SimpleFeatureType sft$1) {
            String string;
            LazyRef lazyRef = dtg$lzy$1;
            synchronized (lazyRef) {
                string = dtg$lzy$1.initialized() ? (String)dtg$lzy$1.value() : (String)dtg$lzy$1.initialize(config$1.options().get((Object)DateTimeScheme$Config$.MODULE$.DtgAttribute()).orElse((Function0 & Serializable & scala.Serializable)() -> RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalArgumentException(new StringBuilder(43).append("DateTime scheme requires valid attribute '").append(DateTimeScheme$Config$.MODULE$.DtgAttribute()).append("'").toString());
                }));
            }
            return string;
        }

        private static final String dtg$1(LazyRef dtg$lzy$1, package.NamedOptions config$1, SimpleFeatureType sft$1) {
            if (dtg$lzy$1.initialized()) {
                return (String)dtg$lzy$1.value();
            }
            return DateTimePartitionSchemeFactory.dtg$lzycompute$1(dtg$lzy$1, config$1, sft$1);
        }

        private static final /* synthetic */ int dtgIndex$lzycompute$1(LazyInt dtgIndex$lzy$1, SimpleFeatureType sft$1, LazyRef dtg$lzy$1, package.NamedOptions config$1) {
            int n;
            LazyInt lazyInt = dtgIndex$lzy$1;
            synchronized (lazyInt) {
                n = dtgIndex$lzy$1.initialized() ? dtgIndex$lzy$1.value() : dtgIndex$lzy$1.initialize(BoxesRunTime.unboxToInt((Object)new Some((Object)BoxesRunTime.boxToInteger((int)sft$1.indexOf(DateTimePartitionSchemeFactory.dtg$1(dtg$lzy$1, config$1, sft$1)))).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> x$8 != -1).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalArgumentException(new StringBuilder(44).append("Attribute '").append(DateTimePartitionSchemeFactory.dtg$1(dtg$lzy$1, config$1, sft$1)).append("' does not exist in feature type ").append(sft$1.getTypeName()).toString());
                })));
            }
            return n;
        }

        private static final int dtgIndex$1(LazyInt dtgIndex$lzy$1, SimpleFeatureType sft$1, LazyRef dtg$lzy$1, package.NamedOptions config$1) {
            if (dtgIndex$lzy$1.initialized()) {
                return dtgIndex$lzy$1.value();
            }
            return DateTimePartitionSchemeFactory.dtgIndex$lzycompute$1(dtgIndex$lzy$1, sft$1, dtg$lzy$1, config$1);
        }
    }
}

