/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.geotools.data.Query;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.FileSystemThreadedReader$;
import org.locationtech.geomesa.fs.storage.common.SizeableFileSystemStorage;
import org.locationtech.geomesa.fs.storage.common.observer.FileSystemObserver;
import org.locationtech.geomesa.fs.storage.common.observer.FileSystemObserverFactory;
import org.locationtech.geomesa.fs.storage.common.package$;
import org.locationtech.geomesa.fs.storage.common.package$RichSimpleFeatureType$;
import org.locationtech.geomesa.fs.storage.common.utils.PathCache$;
import org.locationtech.geomesa.fs.storage.common.utils.StorageUtils$;
import org.locationtech.geomesa.fs.storage.common.utils.StorageUtils$FileType$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.planning.QueryRunner$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.io.FileSizeEstimator;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.IsFlushable;
import org.locationtech.geomesa.utils.io.IsFlushable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0011Mf!\u00026l\u0003\u0003A\bBCA\u001c\u0001\t\u0015\r\u0011\"\u0001\u0002:!Q\u0011q\r\u0001\u0003\u0002\u0003\u0006I!a\u000f\t\u0015\u0005%\u0004A!b\u0001\n\u0003\tY\u0007\u0003\u0006\u0002t\u0001\u0011\t\u0011)A\u0005\u0003[B!\"!\u001e\u0001\u0005\u0003\u0005\u000b\u0011BA<\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013C!\"a%\u0001\u0011\u000b\u0007I\u0011BAK\u0011\u001d\ty\u000b\u0001D\t\u0003cCq!a8\u0001\r#\t\t\u000fC\u0004\u0004V\u0001!\tea\u0016\t\u000f\re\u0004\u0001\"\u0011\u0004|!91q\u0014\u0001\u0005B\r\u0005\u0006bBBP\u0001\u0011\u00053Q\u0015\u0005\b\u0007g\u0003A\u0011IB[\u0011\u001d\ty\u000b\u0001C\u0005\u0007\u0003D\u0011ba?\u0001#\u0003%Ia!@\t\u000f\u0005=\u0006\u0001\"\u0003\u0005\u0002\u00191A\u0011\u0002\u0001\u0001\t\u0017A!\u0002\"\u0004\u0013\u0005\u0003\u0005\u000b\u0011\u0002C\b\u0011)!\u0019B\u0005B\u0001B\u0003%AQ\u0003\u0005\b\u0003\u000f\u0013B\u0011\u0001C\u0011\u0011%\u00119D\u0005a\u0001\n\u0013\u0011I\u0004C\u0005\u0003BI\u0001\r\u0011\"\u0003\u0005,!A!q\n\n!B\u0013\u0011Y\u0004C\u0005\u00050I\u0001\r\u0011\"\u0003\u0003:!IA\u0011\u0007\nA\u0002\u0013%A1\u0007\u0005\t\to\u0011\u0002\u0015)\u0003\u0003<!IA\u0011\b\nA\u0002\u0013%!\u0011\b\u0005\n\tw\u0011\u0002\u0019!C\u0005\t{A\u0001\u0002\"\u0011\u0013A\u0003&!1\b\u0005\f\u00057\u0011\u0002\u0019!a\u0001\n\u0013\u0011Y\tC\u0006\u0005DI\u0001\r\u00111A\u0005\n\u0011\u0015\u0003b\u0003BG%\u0001\u0007\t\u0011)Q\u0005\u0003\u000bD1\u0002\"\u0013\u0013\u0001\u0004\u0005\r\u0011\"\u0003\u0005L!YAQ\n\nA\u0002\u0003\u0007I\u0011\u0002C(\u0011-!\u0019F\u0005a\u0001\u0002\u0003\u0006K!a-\t\u000f\t\u001d$\u0003\"\u0011\u0005V!9!Q\u000e\n\u0005B\t=\u0004b\u0002B9%\u0011\u0005#q\u000e\u0004\u0007\t3\u0002\u0001\u0001b\u0017\t\u0015\u0011u\u0003F!A!\u0002\u0013\u0019i\b\u0003\u0006\u0005`!\u0012\t\u0011)A\u0005\u00073Cq!a\")\t\u0003!\t\u0007C\u0005\u0005j!\u0012\r\u0011\"\u0003\u0005l!AA\u0011\u0010\u0015!\u0002\u0013!i\u0007C\u0005\u0005|!\u0012\r\u0011\"\u0003\u0005l!AAQ\u0010\u0015!\u0002\u0013!i\u0007C\u0006\u0003\u0010!\u0002\r\u00111A\u0005\n\u0011}\u0004b\u0003CAQ\u0001\u0007\t\u0019!C\u0005\t\u0007C1\u0002b\")\u0001\u0004\u0005\t\u0015)\u0003\u0003\u0006!Y1q\u000f\u0015A\u0002\u0003\u0007I\u0011\u0002CE\u0011-!Y\t\u000ba\u0001\u0002\u0004%I\u0001\"$\t\u0017\u0011E\u0005\u00061A\u0001B\u0003&\u0011q\u000f\u0005\b\u0005OBC\u0011\tB8\u0011\u001d!\u0019\n\u000bC!\u0005_Bq\u0001\"&)\t\u0003\"9\nC\u0004\u0005\u001a\"\"\t\u0005b'\t\u000f\t5\u0004\u0006\"\u0011\u0003p!9!\u0011\u000f\u0015\u0005B\t=dA\u0002CO\u0001\u0001!y\n\u0003\u0006\u0004xq\u0012\t\u0011)A\u0005\u0003oB!\"a1=\u0005\u0003\u0005\u000b\u0011BAc\u0011)\u00199\r\u0010B\u0001B\u0003%1\u0011\u001a\u0005\b\u0003\u000fcD\u0011\u0001CR\u0011\u001d\u0011\u0019\b\u0010C)\t[;q!a;l\u0011\u0003\tiO\u0002\u0004kW\"\u0005\u0011q\u001e\u0005\b\u0003\u000f\u001bE\u0011AAy\r%\t\u0019p\u0011I\u0001$\u0003\t)\u0010C\u0004\u0002x\u00163\t!!?\u0007\u000f\tu1)!\u0001\u0003 !9\u0011qQ$\u0005\u0002\tE\u0002\"\u0003B\u001c\u000f\u0002\u0007I\u0011\u0002B\u001d\u0011%\u0011\te\u0012a\u0001\n\u0013\u0011\u0019\u0005\u0003\u0005\u0003P\u001d\u0003\u000b\u0015\u0002B\u001e\u0011%\u0011\tf\u0012b\u0001\n\u0013\u0011\u0019\u0006\u0003\u0005\u0003f\u001d\u0003\u000b\u0011\u0002B+\u0011\u001d\u00119g\u0012C!\u0005SBqA!\u001cH\t\u0003\u0012y\u0007C\u0004\u0003r\u001d#\tEa\u001c\t\u000f\tMtI\"\u0005\u0003v\u00191!1P\"E\u0005{B!Ba\u0007S\u0005+\u0007I\u0011\u0001BF\u0011)\u0011iI\u0015B\tB\u0003%\u0011Q\u0019\u0005\u000b\u0003S\u0013&Q3A\u0005\u0002\t=\u0005B\u0003BI%\nE\t\u0015!\u0003\u0002Z\"9\u0011q\u0011*\u0005\u0002\tM\u0005\"\u0003BN%\u0006\u0005I\u0011\u0001BO\u0011%\u0011\u0019KUI\u0001\n\u0003\u0011)\u000bC\u0005\u0003<J\u000b\n\u0011\"\u0001\u0003>\"I!\u0011\u0019*\u0002\u0002\u0013\u0005#1\u0019\u0005\n\u0005\u0013\u0014\u0016\u0011!C\u0001\u0005\u0017D\u0011Ba5S\u0003\u0003%\tA!6\t\u0013\t}'+!A\u0005B\t\u0005\b\"\u0003Bu%\u0006\u0005I\u0011\u0001Bv\u0011%\u0011)PUA\u0001\n\u0003\u00129\u0010C\u0005\u0003zJ\u000b\t\u0011\"\u0011\u0003|\"I!Q *\u0002\u0002\u0013\u0005#q`\u0004\n\u0007\u0007\u0019\u0015\u0011!E\u0005\u0007\u000b1\u0011Ba\u001fD\u0003\u0003EIaa\u0002\t\u000f\u0005\u001dE\r\"\u0001\u0004\u0016!I!\u0011 3\u0002\u0002\u0013\u0015#1 \u0005\n\u0007/!\u0017\u0011!CA\u00073A\u0011ba\be\u0003\u0003%\ti!\t\t\u0013\rMB-!A\u0005\n\rU\"!G!cgR\u0014\u0018m\u0019;GS2,7+_:uK6\u001cFo\u001c:bO\u0016T!\u0001\\7\u0002\r\r|W.\\8o\u0015\tqw.A\u0004ti>\u0014\u0018mZ3\u000b\u0005A\f\u0018A\u00014t\u0015\t\u00118/A\u0004hK>lWm]1\u000b\u0005Q,\u0018\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001<\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0013\u0001Ix0a\u0003\u0002\u0014\u0005\r\u0002C\u0001>~\u001b\u0005Y(\"\u0001?\u0002\u000bM\u001c\u0017\r\\1\n\u0005y\\(AB!osJ+g\r\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)!\\\u0001\u0004CBL\u0017\u0002BA\u0005\u0003\u0007\u0011\u0011CR5mKNK8\u000f^3n'R|'/Y4f!\u0011\ti!a\u0004\u000e\u0003-L1!!\u0005l\u0005e\u0019\u0016N_3bE2,g)\u001b7f'f\u001cH/Z7Ti>\u0014\u0018mZ3\u0011\t\u0005U\u0011qD\u0007\u0003\u0003/QA!!\u0007\u0002\u001c\u0005)1\u000f^1ug*\u0019\u0011QD9\u0002\u000bU$\u0018\u000e\\:\n\t\u0005\u0005\u0012q\u0003\u0002\u0010\u001b\u0016$\bn\u001c3Qe>4\u0017\u000e\\5oOB!\u0011QEA\u001a\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012\u0001D:dC2\fGn\\4hS:<'\u0002BA\u0017\u0003_\t\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0003c\t1aY8n\u0013\u0011\t)$a\n\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\bG>tG/\u001a=u+\t\tY\u0004\u0005\u0003\u0002>\u0005\u0005d\u0002BA \u0003;rA!!\u0011\u0002\\9!\u00111IA-\u001d\u0011\t)%a\u0016\u000f\t\u0005\u001d\u0013Q\u000b\b\u0005\u0003\u0013\n\u0019F\u0004\u0003\u0002L\u0005ESBAA'\u0015\r\tye^\u0001\u0007yI|w\u000e\u001e \n\u0003YL!\u0001^;\n\u0005I\u001c\u0018B\u00019r\u0013\tqw.C\u0002\u0002\u00065LA!a\u0018\u0002\u0004\u00059\u0001/Y2lC\u001e,\u0017\u0002BA2\u0003K\u0012\u0011CR5mKNK8\u000f^3n\u0007>tG/\u001a=u\u0015\u0011\ty&a\u0001\u0002\u0011\r|g\u000e^3yi\u0002\n\u0001\"\\3uC\u0012\fG/Y\u000b\u0003\u0003[\u0002B!!\u0001\u0002p%!\u0011\u0011OA\u0002\u0005=\u0019Fo\u001c:bO\u0016lU\r^1eCR\f\u0017!C7fi\u0006$\u0017\r^1!\u0003%)\u0007\u0010^3og&|g\u000e\u0005\u0003\u0002z\u0005\u0005e\u0002BA>\u0003{\u00022!a\u0013|\u0013\r\tyh_\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0015Q\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005}40\u0001\u0004=S:LGO\u0010\u000b\t\u0003\u0017\u000bi)a$\u0002\u0012B\u0019\u0011Q\u0002\u0001\t\u000f\u0005]b\u00011\u0001\u0002<!9\u0011\u0011\u000e\u0004A\u0002\u00055\u0004bBA;\r\u0001\u0007\u0011qO\u0001\n_\n\u001cXM\u001d<feN,\"!a&\u0011\r\u0005e\u0015qTAR\u001b\t\tYJC\u0002\u0002\u001en\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t+a'\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002&\u0006-VBAAT\u0015\r\tIk[\u0001\t_\n\u001cXM\u001d<fe&!\u0011QVAT\u0005e1\u0015\u000e\\3TsN$X-\\(cg\u0016\u0014h/\u001a:GC\u000e$xN]=\u0002\u0019\r\u0014X-\u0019;f/JLG/\u001a:\u0015\r\u0005M\u0016\u0011YAl!\u0011\t),a/\u000f\t\u0005}\u0012qW\u0005\u0005\u0003s\u000b\u0019!A\tGS2,7+_:uK6\u001cFo\u001c:bO\u0016LA!!0\u0002@\n\u0001b)\u001b7f'f\u001cH/Z7Xe&$XM\u001d\u0006\u0005\u0003s\u000b\u0019\u0001C\u0004\u0002D\"\u0001\r!!2\u0002\t\u0019LG.\u001a\t\u0005\u0003\u000f\f\u0019.\u0004\u0002\u0002J*\u0019\u0001/a3\u000b\t\u00055\u0017qZ\u0001\u0007Q\u0006$wn\u001c9\u000b\u0007\u0005EW/\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003+\fIM\u0001\u0003QCRD\u0007bBAU\u0011\u0001\u0007\u0011\u0011\u001c\t\u0005\u0003K\u000bY.\u0003\u0003\u0002^\u0006\u001d&A\u0005$jY\u0016\u001c\u0016p\u001d;f[>\u00137/\u001a:wKJ\fAb\u0019:fCR,'+Z1eKJ$b!a9\u00048\r\u001d\u0003cAAs\u000b:\u0019\u0011q\u001d\"\u000f\t\u0005\u0005\u0013\u0011^\u0005\u0003Y6\f\u0011$\u00112tiJ\f7\r\u001e$jY\u0016\u001c\u0016p\u001d;f[N#xN]1hKB\u0019\u0011QB\"\u0014\u0005\rKHCAAw\u0005Q1\u0015\u000e\\3TsN$X-\u001c)bi\"\u0014V-\u00193feN\u0011Q)_\u0001\u0005e\u0016\fG\r\u0006\u0003\u0002|\ne\u0001CBA\u007f\u0005\u0003\u0011)!\u0004\u0002\u0002\u0000*!\u0011QTA\u000e\u0013\u0011\u0011\u0019!a@\u0003#\rcwn]3bE2,\u0017\n^3sCR|'\u000f\u0005\u0003\u0003\b\tUQB\u0001B\u0005\u0015\u0011\u0011YA!\u0004\u0002\rMLW\u000e\u001d7f\u0015\u0011\u0011yA!\u0005\u0002\u000f\u0019,\u0017\r^;sK*\u0019!1C;\u0002\u000f=\u0004XM\\4jg&!!q\u0003B\u0005\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\"9!1\u0004$A\u0002\u0005\u0015\u0017\u0001\u00029bi\"\u0014\u0001#T3uC\u0012\fG/Y(cg\u0016\u0014h/\u001a:\u0014\u000b\u001d\u0013\t#!7\u0011\t\t\r\"QF\u0007\u0003\u0005KQAAa\n\u0003*\u0005!A.\u00198h\u0015\t\u0011Y#\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0018\u0005K\u0011aa\u00142kK\u000e$HC\u0001B\u001a!\r\u0011)dR\u0007\u0002\u0007\u0006)1m\\;oiV\u0011!1\b\t\u0004u\nu\u0012b\u0001B w\n!Aj\u001c8h\u0003%\u0019w.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0003F\t-\u0003c\u0001>\u0003H%\u0019!\u0011J>\u0003\tUs\u0017\u000e\u001e\u0005\n\u0005\u001bR\u0015\u0011!a\u0001\u0005w\t1\u0001\u001f\u00132\u0003\u0019\u0019w.\u001e8uA\u00051!m\\;oIN,\"A!\u0016\u0011\t\t]#\u0011M\u0007\u0003\u00053RAAa\u0017\u0003^\u0005!q-Z8n\u0015\r\u0011yf]\u0001\u0004UR\u001c\u0018\u0002\u0002B2\u00053\u0012\u0001\"\u00128wK2|\u0007/Z\u0001\bE>,h\u000eZ:!\u0003\u00159(/\u001b;f)\u0011\u0011)Ea\u001b\t\u000f\t=a\n1\u0001\u0003\u0006\u0005)a\r\\;tQR\u0011!QI\u0001\u0006G2|7/Z\u0001\b_:\u001cEn\\:f)\u0019\u0011)Ea\u001e\u0003z!9!\u0011K)A\u0002\tU\u0003b\u0002B\u001c#\u0002\u0007!1\b\u0002\r/JLG/\u001a:D_:4\u0017nZ\n\u0007%f\u0014yH!\"\u0011\u0007i\u0014\t)C\u0002\u0003\u0004n\u0014q\u0001\u0015:pIV\u001cG\u000fE\u0002{\u0005\u000fK1A!#|\u00051\u0019VM]5bY&T\u0018M\u00197f+\t\t)-A\u0003qCRD\u0007%\u0006\u0002\u0002Z\u0006IqNY:feZ,'\u000f\t\u000b\u0007\u0005+\u00139J!'\u0011\u0007\tU\"\u000bC\u0004\u0003\u001c]\u0003\r!!2\t\u000f\u0005%v\u000b1\u0001\u0002Z\u0006!1m\u001c9z)\u0019\u0011)Ja(\u0003\"\"I!1\u0004-\u0011\u0002\u0003\u0007\u0011Q\u0019\u0005\n\u0003SC\u0006\u0013!a\u0001\u00033\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003(*\"\u0011Q\u0019BUW\t\u0011Y\u000b\u0005\u0003\u0003.\n]VB\u0001BX\u0015\u0011\u0011\tLa-\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B[w\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\te&q\u0016\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005\u007fSC!!7\u0003*\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"A!2\u0011\t\t\r\"qY\u0005\u0005\u0003\u0007\u0013)#\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003NB\u0019!Pa4\n\u0007\tE7PA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003X\nu\u0007c\u0001>\u0003Z&\u0019!1\\>\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003Nu\u000b\t\u00111\u0001\u0003N\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003dB1\u0011\u0011\u0014Bs\u0005/LAAa:\u0002\u001c\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011iOa=\u0011\u0007i\u0014y/C\u0002\u0003rn\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0003N}\u000b\t\u00111\u0001\u0003X\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0003N\u0006AAo\\*ue&tw\r\u0006\u0002\u0003F\u00061Q-];bYN$BA!<\u0004\u0002!I!Q\n2\u0002\u0002\u0003\u0007!q[\u0001\r/JLG/\u001a:D_:4\u0017n\u001a\t\u0004\u0005k!7#\u00023\u0004\n\t\u0015\u0005CCB\u0006\u0007#\t)-!7\u0003\u00166\u00111Q\u0002\u0006\u0004\u0007\u001fY\u0018a\u0002:v]RLW.Z\u0005\u0005\u0007'\u0019iAA\tBEN$(/Y2u\rVt7\r^5p]J\"\"a!\u0002\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\tU51DB\u000f\u0011\u001d\u0011Yb\u001aa\u0001\u0003\u000bDq!!+h\u0001\u0004\tI.A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r\r2q\u0006\t\u0006u\u000e\u00152\u0011F\u0005\u0004\u0007OY(AB(qi&|g\u000eE\u0004{\u0007W\t)-!7\n\u0007\r52P\u0001\u0004UkBdWM\r\u0005\n\u0007cA\u0017\u0011!a\u0001\u0005+\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u0005\u0002bBB\u001d\u0013\u0001\u000711H\u0001\u0007M&dG/\u001a:\u0011\u000bi\u001c)c!\u0010\u0011\t\r}21I\u0007\u0003\u0007\u0003RAa!\u000f\u0003\u0012%!1QIB!\u0005\u00191\u0015\u000e\u001c;fe\"91\u0011J\u0005A\u0002\r-\u0013!\u0003;sC:\u001chm\u001c:n!\u0015Q8QEB'!\u001dQ81FA<\u0007\u001f\u0002BAa\u0002\u0004R%!11\u000bB\u0005\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/Z\u0001\rO\u0016$h)\u001b7f!\u0006$\bn\u001d\u000b\u0005\u00073\u001a)\b\u0005\u0004\u0004\\\r\r4q\r\b\u0005\u0007;\u001a\tG\u0004\u0003\u0002L\r}\u0013\"\u0001?\n\u0007\u0005}30\u0003\u0003\u0002\"\u000e\u0015$bAA0wB!1\u0011NB8\u001d\u0011\tyda\u001b\n\t\r5\u00141A\u0001\u0010'R|'/Y4f\u001b\u0016$\u0018\rZ1uC&!1\u0011OB:\u0005=\u0019Fo\u001c:bO\u00164\u0015\u000e\\3QCRD'\u0002BB7\u0003\u0007Aqaa\u001e\u000b\u0001\u0004\t9(A\u0005qCJ$\u0018\u000e^5p]\u0006Iq-\u001a;SK\u0006$WM\u001d\u000b\t\u0007{\u001a\u0019ia&\u0004\u001cB!\u0011QHB@\u0013\u0011\u0019\t)!\u001a\u00031\rcwn]3bE2,g)Z1ukJ,\u0017\n^3sCR|'\u000fC\u0004\u0004\u0006.\u0001\raa\"\u0002\u0011=\u0014\u0018nZ5oC2\u0004Ba!#\u0004\u00146\u001111\u0012\u0006\u0005\u0007\u001b\u001by)\u0001\u0003eCR\f'bABIk\u0006Aq-Z8u_>d7/\u0003\u0003\u0004\u0016\u000e-%!B)vKJL\b\"CB<\u0017A\u0005\t\u0019ABM!\u0015Q8QEA<\u0011%\u0019ij\u0003I\u0001\u0002\u0004\u0011i-A\u0004uQJ,\u0017\rZ:\u0002\u0013\u001d,Go\u0016:ji\u0016\u0014H\u0003BAZ\u0007GCqaa\u001e\r\u0001\u0004\t9\b\u0006\u0005\u0004(\u000e56qVBY!\u0011\t)l!+\n\t\r-\u0016q\u0018\u0002\u0017\r&dWmU=ti\u0016lW\u000b\u001d3bi\u0016<&/\u001b;fe\"91\u0011H\u0007A\u0002\ru\u0002\"CB<\u001bA\u0005\t\u0019ABM\u0011%\u0019i*\u0004I\u0001\u0002\u0004\u0011i-A\u0004d_6\u0004\u0018m\u0019;\u0015\u0011\t\u00153qWB]\u0007\u007fCqaa\u001e\u000f\u0001\u0004\u0019I\nC\u0005\u0004<:\u0001\n\u00111\u0001\u0004>\u0006Aa-\u001b7f'&TX\rE\u0003{\u0007K\u0011Y\u0004C\u0005\u0004\u001e:\u0001\n\u00111\u0001\u0003NRQ\u00111WBb\u0007\u000b\u001c9na>\t\u000f\r]t\u00021\u0001\u0002x!91qY\bA\u0002\r%\u0017AB1di&|g\u000e\u0005\u0003\u0004L\u000eEg\u0002BB5\u0007\u001bLAaa4\u0004t\u0005\t2\u000b^8sC\u001e,g)\u001b7f\u0003\u000e$\u0018n\u001c8\n\t\rM7Q\u001b\u0002\u0012'R|'/Y4f\r&dW-Q2uS>t'\u0002BBh\u0007gBqa!7\u0010\u0001\u0004\u0019Y.\u0001\u0005gS2,G+\u001f9f!\u0011\u0019in!=\u000f\t\r}71\u001e\b\u0005\u0007C\u001c)O\u0004\u0003\u0002h\u000e\r\u0018bAA\u000fW&!1q]Bu\u00031\u0019Fo\u001c:bO\u0016,F/\u001b7t\u0015\r\tib[\u0005\u0005\u0007[\u001cy/\u0001\u0005GS2,G+\u001f9f\u0015\u0011\u00199o!;\n\t\rM8Q\u001f\u0002\t\r&dW\rV=qK*!1Q^Bx\u0011%\u0019Ip\u0004I\u0001\u0002\u0004\u0019i,\u0001\buCJ<W\r\u001e$jY\u0016\u001c\u0016N_3\u0002-\r\u0014X-\u0019;f/JLG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"aa@+\t\ru&\u0011\u0016\u000b\u0005\u0003g#\u0019\u0001C\u0004\u0005\u0006E\u0001\r\u0001b\u0002\u0002\r\r|gNZ5h!\r\t)O\u0015\u0002\u0018\u0007\",hn[3e\r&dWmU=ti\u0016lwK]5uKJ\u001cRA\u0005B\u0011\u0003g\u000bQ\u0001]1uQN\u0004baa\u0017\u0005\u0012\u0011\u001d\u0011\u0002\u0002Bt\u0007K\n\u0011\"Z:uS6\fGo\u001c:\u0011\t\u0011]AQD\u0007\u0003\t3QA\u0001b\u0007\u0002\u001c\u0005\u0011\u0011n\\\u0005\u0005\t?!IBA\tGS2,7+\u001b>f\u000bN$\u0018.\\1u_J$b\u0001b\t\u0005(\u0011%\u0002c\u0001C\u0013%5\t\u0001\u0001C\u0004\u0005\u000eU\u0001\r\u0001b\u0004\t\u000f\u0011MQ\u00031\u0001\u0005\u0016Q!!Q\tC\u0017\u0011%\u0011ieFA\u0001\u0002\u0004\u0011Y$A\u0003u_R\fG.A\u0005u_R\fGn\u0018\u0013fcR!!Q\tC\u001b\u0011%\u0011iEGA\u0001\u0002\u0004\u0011Y$\u0001\u0004u_R\fG\u000eI\u0001\ne\u0016l\u0017-\u001b8j]\u001e\fQB]3nC&t\u0017N\\4`I\u0015\fH\u0003\u0002B#\t\u007fA\u0011B!\u0014\u001e\u0003\u0003\u0005\rAa\u000f\u0002\u0015I,W.Y5oS:<\u0007%\u0001\u0005qCRDw\fJ3r)\u0011\u0011)\u0005b\u0012\t\u0013\t5\u0003%!AA\u0002\u0005\u0015\u0017AB<sSR,'/\u0006\u0002\u00024\u0006QqO]5uKJ|F%Z9\u0015\t\t\u0015C\u0011\u000b\u0005\n\u0005\u001b\u001a\u0013\u0011!a\u0001\u0003g\u000bqa\u001e:ji\u0016\u0014\b\u0005\u0006\u0003\u0003F\u0011]\u0003b\u0002B\bK\u0001\u0007!Q\u0001\u0002\u001b\r&dWmU=ti\u0016lW\u000b\u001d3bi\u0016<&/\u001b;fe&k\u0007\u000f\\\n\u0005Qe\u001c9+\u0001\u0004sK\u0006$WM]\u0001\u000ee\u0016\fG\rU1si&$\u0018n\u001c8\u0015\r\u0011\rDQ\rC4!\r!)\u0003\u000b\u0005\b\t;Z\u0003\u0019AB?\u0011\u001d!yf\u000ba\u0001\u00073\u000b\u0011\"\\8eS\u001aLWM]:\u0016\u0005\u00115\u0004\u0003\u0003C8\tk\n9(a-\u000e\u0005\u0011E$\u0002\u0002C:\u00037\u000bq!\\;uC\ndW-\u0003\u0003\u0005x\u0011E$aA'ba\u0006QQn\u001c3jM&,'o\u001d\u0011\u0002\u0011\u0011,G.\u001a;feN\f\u0011\u0002Z3mKR,'o\u001d\u0011\u0016\u0005\t\u0015\u0011a\u00034fCR,(/Z0%KF$BA!\u0012\u0005\u0006\"I!QJ\u0019\u0002\u0002\u0003\u0007!QA\u0001\tM\u0016\fG/\u001e:fAU\u0011\u0011qO\u0001\u000ea\u0006\u0014H/\u001b;j_:|F%Z9\u0015\t\t\u0015Cq\u0012\u0005\n\u0005\u001b\"\u0014\u0011!a\u0001\u0003o\n!\u0002]1si&$\u0018n\u001c8!\u0003\u0019\u0011X-\\8wK\u00069\u0001.Y:OKb$XC\u0001Bw\u0003\u0011qW\r\u001f;\u0015\u0005\t\u0015!AD+qI\u0006$Xm\u00142tKJ4XM]\n\u0004y\u0011\u0005\u0006cAAs\u000fRAAQ\u0015CT\tS#Y\u000bE\u0002\u0005&qBqaa\u001eA\u0001\u0004\t9\bC\u0004\u0002D\u0002\u0003\r!!2\t\u000f\r\u001d\u0007\t1\u0001\u0004JR1!Q\tCX\tcCqA!\u0015B\u0001\u0004\u0011)\u0006C\u0004\u00038\u0005\u0003\rAa\u000f")
public abstract class AbstractFileSystemStorage
implements SizeableFileSystemStorage,
MethodProfiling {
    private Seq<FileSystemObserverFactory> org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers;
    private final package.FileSystemContext context;
    private final StorageMetadata metadata;
    private final String extension;
    private transient Logger logger;
    private final float org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$fileSizeError;
    private float org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$averageBytesPerFeature;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, (String)message, code);
    }

    @Override
    public Option<Object> targetSize(Option<Object> size) {
        return SizeableFileSystemStorage.targetSize$(this, size);
    }

    @Override
    public boolean fileIsSized(Path path, long target) {
        return SizeableFileSystemStorage.fileIsSized$(this, path, target);
    }

    @Override
    public FileSizeEstimator estimator(long size) {
        return SizeableFileSystemStorage.estimator$(this, size);
    }

    @Override
    public void updateFileSize(FileSizeEstimator estimator) {
        SizeableFileSystemStorage.updateFileSize$(this, estimator);
    }

    public Seq<StorageMetadata.PartitionMetadata> getPartitions() {
        return FileSystemStorage.getPartitions$((FileSystemStorage)this);
    }

    public Seq<StorageMetadata.PartitionMetadata> getPartitions(Filter filter) {
        return FileSystemStorage.getPartitions$((FileSystemStorage)this, (Filter)filter);
    }

    public Seq<package.PartitionFilter> getPartitionFilters(Filter filter, Option<String> partition) {
        return FileSystemStorage.getPartitionFilters$((FileSystemStorage)this, (Filter)filter, partition);
    }

    public Option<String> getPartitionFilters$default$2() {
        return FileSystemStorage.getPartitionFilters$default$2$((FileSystemStorage)this);
    }

    public Option<String> getReader$default$2() {
        return FileSystemStorage.getReader$default$2$((FileSystemStorage)this);
    }

    public int getReader$default$3() {
        return FileSystemStorage.getReader$default$3$((FileSystemStorage)this);
    }

    public Option<String> getWriter$default$2() {
        return FileSystemStorage.getWriter$default$2$((FileSystemStorage)this);
    }

    public int getWriter$default$3() {
        return FileSystemStorage.getWriter$default$3$((FileSystemStorage)this);
    }

    public void close() {
        FileSystemStorage.close$((FileSystemStorage)this);
    }

    public Option<Object> compact$default$2() {
        return package.Compactable.compact$default$2$((package.Compactable)this);
    }

    public int compact$default$3() {
        return package.Compactable.compact$default$3$((package.Compactable)this);
    }

    private Logger logger$lzycompute() {
        AbstractFileSystemStorage abstractFileSystemStorage = this;
        synchronized (abstractFileSystemStorage) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public float org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$fileSizeError() {
        return this.org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$fileSizeError;
    }

    @Override
    public float org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$averageBytesPerFeature() {
        return this.org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$averageBytesPerFeature;
    }

    @Override
    public void org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$averageBytesPerFeature_$eq(float x$1) {
        this.org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$averageBytesPerFeature = x$1;
    }

    @Override
    public final void org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$_setter_$org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$fileSizeError_$eq(float x$1) {
        this.org$locationtech$geomesa$fs$storage$common$SizeableFileSystemStorage$$fileSizeError = x$1;
    }

    public package.FileSystemContext context() {
        return this.context;
    }

    public StorageMetadata metadata() {
        return this.metadata;
    }

    private Seq<FileSystemObserverFactory> observers$lzycompute() {
        AbstractFileSystemStorage abstractFileSystemStorage = this;
        synchronized (abstractFileSystemStorage) {
            if (!this.bitmap$0) {
                Builder builder = Seq$.MODULE$.newBuilder();
                package$RichSimpleFeatureType$.MODULE$.getObservers$extension(package$.MODULE$.RichSimpleFeatureType(this.metadata().sft())).foreach((Function1 & Serializable & scala.Serializable)c -> {
                    AbstractFileSystemStorage.$anonfun$observers$1(this, builder, c);
                    return BoxedUnit.UNIT;
                });
                this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers = (Seq)builder.result();
                this.bitmap$0 = true;
            }
        }
        return this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers;
    }

    public Seq<FileSystemObserverFactory> org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers() {
        if (!this.bitmap$0) {
            return this.observers$lzycompute();
        }
        return this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers;
    }

    public abstract FileSystemStorage.FileSystemWriter createWriter(Path var1, FileSystemObserver var2);

    public abstract FileSystemPathReader createReader(Option<Filter> var1, Option<Tuple2<String, SimpleFeatureType>> var2);

    public Seq<StorageMetadata.StorageFilePath> getFilePaths(String partition) {
        Option option = this.metadata().getPartition(partition);
        if (None$.MODULE$.equals(option)) {
            return (Seq)Nil$.MODULE$;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            StorageMetadata.PartitionMetadata p = (StorageMetadata.PartitionMetadata)some.value();
            Path baseDir = StorageUtils$.MODULE$.baseDirectory(this.context().root(), partition, this.metadata().leafStorage());
            return (Seq)p.files().flatMap((Function1 & Serializable & scala.Serializable)file -> {
                BoxedUnit boxedUnit;
                Path path = new Path(baseDir, file.name());
                if (PathCache$.MODULE$.exists(this.context().fc(), path, PathCache$.MODULE$.exists$default$3())) {
                    return (Seq)new .colon.colon((Object)new StorageMetadata.StorageFilePath(file, path), (List)Nil$.MODULE$);
                }
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Inconsistent metadata for {}: {}", new Object[]{this.metadata().sft().getTypeName(), path});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return (Seq)Nil$.MODULE$;
            }, Seq$.MODULE$.canBuildFrom());
        }
        throw new MatchError((Object)option);
    }

    public Iterator<SimpleFeature> getReader(Query original, Option<String> partition, int threads) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        Query query = QueryRunner$.MODULE$.configureDefaultQuery(this.metadata().sft(), original);
        Option transform = QueryHints$.MODULE$.RichHints(query.getHints()).getTransform();
        Filter filter = (Filter)Option$.MODULE$.apply((Object)query.getFilter()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Filter.INCLUDE);
        Seq<package.PartitionFilter> filters = this.getPartitionFilters(filter, partition);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running query '{}' {}", new Object[]{query.getTypeName(), ECQL.toCQL((Filter)query.getFilter())});
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("  Original filter: {}", new Object[]{ECQL.toCQL((Filter)original.getFilter())});
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new java.lang.StringBuilder(14).append("  Transforms: ").append(QueryHints$.MODULE$.RichHints(query.getHints()).getTransformDefinition().map((Function1 & Serializable & scala.Serializable)t -> {
                if (t.isEmpty()) {
                    return "empty";
                }
                return t;
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> "none")).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new java.lang.StringBuilder(56).append("  Threading the read of ").append(((TraversableOnce)filters.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)AbstractFileSystemStorage.$anonfun$getReader$4(x$1)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)).append(" partitions with ").append(threads).append(" reader threads").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Iterator readers = filters.iterator().flatMap((Function1 & Serializable & scala.Serializable)fp -> {
            LazyRef reader$lzy = new LazyRef();
            return fp.partitions().iterator().flatMap((Function1 & Serializable & scala.Serializable)p -> {
                Seq<StorageMetadata.StorageFilePath> files = this.getFilePaths((String)p);
                if (files.isEmpty()) {
                    return scala.package$.MODULE$.Iterator().empty();
                }
                return scala.package$.MODULE$.Iterator().single((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.reader$1(reader$lzy, (package.PartitionFilter)fp, transform)), files));
            });
        });
        if (readers.isEmpty()) {
            return CloseableIterator$.MODULE$.empty();
        }
        return FileSystemThreadedReader$.MODULE$.apply((Iterator<Tuple2<FileSystemPathReader, Seq<StorageMetadata.StorageFilePath>>>)readers, threads);
    }

    public FileSystemStorage.FileSystemWriter getWriter(String partition) {
        return this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(partition, StorageMetadata.StorageFileAction$.MODULE$.Append(), StorageUtils$FileType$.MODULE$.Written(), this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter$default$4());
    }

    public FileSystemStorage.FileSystemUpdateWriter getWriter(Filter filter, Option<String> partition, int threads) {
        Query query = new Query(this.metadata().sft().getTypeName(), filter);
        return new FileSystemUpdateWriterImpl(this, this.getReader(query, partition, threads), partition);
    }

    public void compact(Option<String> partition2, Option<Object> fileSize, int threads) {
        Option<Object> target = this.targetSize(fileSize);
        ((IterableLike)partition2.map((Function1 & Serializable & scala.Serializable)x$3 -> (Seq)new .colon.colon(x$3, (List)Nil$.MODULE$)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)this.metadata().getPartitions(this.metadata().getPartitions$default$1()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Seq$.MODULE$.canBuildFrom()))).foreach((Function1 & Serializable & scala.Serializable)partition -> {
            AbstractFileSystemStorage.$anonfun$compact$4(this, target, threads, partition);
            return BoxedUnit.UNIT;
        });
    }

    public FileSystemStorage.FileSystemWriter org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(String partition, Enumeration.Value action, Enumeration.Value fileType, Option<Object> targetFileSize) {
        Option<Object> option = this.targetSize(targetFileSize);
        if (None$.MODULE$.equals(option)) {
            return this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(this.pathAndObserver$1(partition, fileType, action));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            long s = BoxesRunTime.unboxToLong((Object)some.value());
            return new ChunkedFileSystemWriter(this, (Iterator<WriterConfig>)scala.package$.MODULE$.Iterator().continually((Function0 & Serializable & scala.Serializable)() -> this.pathAndObserver$1(partition, fileType, action)), this.estimator(s));
        }
        throw new MatchError(option);
    }

    public FileSystemStorage.FileSystemWriter org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(WriterConfig config) {
        return this.createWriter(config.path(), config.observer());
    }

    public Option<Object> org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter$default$4() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$observers$1(AbstractFileSystemStorage $this, Builder builder$1, String c) {
        try {
            ClassLoader cl = (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ClassLoader.getSystemClassLoader());
            FileSystemObserverFactory observer = (FileSystemObserverFactory)cl.loadClass(c).newInstance();
            builder$1.$plus$eq((Object)observer);
            observer.init($this.context().conf(), $this.context().root(), $this.metadata().sft());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                package.CloseQuietly$.MODULE$.apply(builder$1.result(), (IsCloseable)IsCloseable$.MODULE$.iterableIsCloseable()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    e.addSuppressed(x$1);
                    return BoxedUnit.UNIT;
                });
                throw e;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ int $anonfun$getReader$4(package.PartitionFilter x$1) {
        return x$1.partitions().size();
    }

    public static final /* synthetic */ boolean $anonfun$getReader$6(Filter x$2) {
        Filter filter = x$2;
        IncludeFilter includeFilter = Filter.INCLUDE;
        return filter == null ? includeFilter != null : !filter.equals(includeFilter);
    }

    private final /* synthetic */ FileSystemPathReader reader$lzycompute$1(LazyRef reader$lzy$1, package.PartitionFilter fp$1, Option transform$1) {
        FileSystemPathReader fileSystemPathReader;
        LazyRef lazyRef = reader$lzy$1;
        synchronized (lazyRef) {
            FileSystemPathReader fileSystemPathReader2;
            if (reader$lzy$1.initialized()) {
                fileSystemPathReader2 = (FileSystemPathReader)reader$lzy$1.value();
            } else {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                Option filter = Option$.MODULE$.apply((Object)fp$1.filter()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractFileSystemStorage.$anonfun$getReader$6(x$2)));
                FileSystemPathReader reader = this.createReader((Option<Filter>)filter, (Option<Tuple2<String, SimpleFeatureType>>)transform$1);
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new java.lang.StringBuilder(35).append("  Reading ").append(fp$1.partitions().size()).append(" partitions with filter: ").append(filter.map((Function1 & Serializable & scala.Serializable)x$1 -> ECQL.toCQL((Filter)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "INCLUDE")).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace(new java.lang.StringBuilder(23).append("  Filter: ").append(filter.map((Function1 & Serializable & scala.Serializable)x$1 -> ECQL.toCQL((Filter)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "INCLUDE")).append(" Partitions: ").append(fp$1.partitions().mkString(", ")).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                fileSystemPathReader2 = (FileSystemPathReader)reader$lzy$1.initialize((Object)reader);
            }
            fileSystemPathReader = fileSystemPathReader2;
        }
        return fileSystemPathReader;
    }

    private final FileSystemPathReader reader$1(LazyRef reader$lzy$1, package.PartitionFilter fp$1, Option transform$1) {
        if (reader$lzy$1.initialized()) {
            return (FileSystemPathReader)reader$lzy$1.value();
        }
        return this.reader$lzycompute$1(reader$lzy$1, fp$1, transform$1);
    }

    public static final /* synthetic */ boolean $anonfun$compact$5(AbstractFileSystemStorage $this, long t$1, StorageMetadata.StorageFilePath p) {
        if ($this.fileIsSized(p.path(), t$1)) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("Skipping compaction for file [{}] (already target size)", new Object[]{p.path()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return false;
        }
        return true;
    }

    private final FileSystemStorage.FileSystemWriter writer$1(String partition$1, Option target$1) {
        return this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(partition$1, StorageMetadata.StorageFileAction$.MODULE$.Append(), StorageUtils$FileType$.MODULE$.Compacted(), (Option<Object>)target$1);
    }

    private static final CloseableIterator threaded$1(FileSystemPathReader reader$2, Seq toCompact$1, int threads$1) {
        return FileSystemThreadedReader$.MODULE$.apply((Iterator<Tuple2<FileSystemPathReader, Seq<StorageMetadata.StorageFilePath>>>)scala.package$.MODULE$.Iterator().single((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reader$2), (Object)toCompact$1)), threads$1);
    }

    public static final /* synthetic */ void $anonfun$compact$8(LongRef written$1, Envelope bounds$1, FileSystemStorage.FileSystemWriter x0$1, CloseableIterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            FileSystemStorage.FileSystemWriter writer = (FileSystemStorage.FileSystemWriter)tuple2._1();
            CloseableIterator features = (CloseableIterator)tuple2._2();
            while (features.hasNext()) {
                SimpleFeature feature = (SimpleFeature)features.next();
                writer.write(feature);
                ++written$1.elem;
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                if (geom == null) continue;
                bounds$1.expandToInclude(geom.getEnvelopeInternal());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$compact$10(AbstractFileSystemStorage $this, ListBuffer failures$1, StorageMetadata.StorageFilePath file) {
        if (!$this.context().fc().delete(file.path(), false)) {
            failures$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{file.path()}));
        }
        PathCache$.MODULE$.invalidate($this.context().fc(), file.path());
    }

    public static final /* synthetic */ void $anonfun$compact$4(AbstractFileSystemStorage $this, Option target$1, int threads$1, String partition) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        Seq seq;
        Seq paths = $this.getFilePaths(partition);
        Option option = target$1;
        if (None$.MODULE$.equals(option)) {
            seq = paths;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            long t = BoxesRunTime.unboxToLong((Object)some.value());
            seq = (Seq)paths.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AbstractFileSystemStorage.$anonfun$compact$5($this, t, p)));
        } else {
            throw new MatchError((Object)option);
        }
        Seq toCompact = seq;
        if (toCompact.isEmpty()) {
            BoxedUnit boxedUnit5;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("Skipping compaction - no files to compact");
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            return;
        }
        if (toCompact.lengthCompare(1) == 0 && target$1.forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$5 -> $this.fileIsSized(((StorageMetadata.StorageFilePath)toCompact.head()).path(), x$5))) {
            BoxedUnit boxedUnit6;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("Skipping compaction for single data file [{}]", new Object[]{toCompact.mkString()});
                boxedUnit6 = BoxedUnit.UNIT;
            } else {
                boxedUnit6 = BoxedUnit.UNIT;
            }
            return;
        }
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Compacting data files: [{}]", new Object[]{toCompact.mkString(", ")});
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        LongRef written = LongRef.create((long)0L);
        Envelope bounds = new Envelope();
        FileSystemPathReader reader = $this.createReader((Option<Filter>)None$.MODULE$, (Option<Tuple2<String, SimpleFeatureType>>)None$.MODULE$);
        package.WithClose$.MODULE$.apply((Object)$this.writer$1(partition, target$1), (Function0 & Serializable & scala.Serializable)() -> AbstractFileSystemStorage.threaded$1(reader, toCompact, threads$1), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            AbstractFileSystemStorage.$anonfun$compact$8(written, bounds, x0$1, x1$1);
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable(), IsCloseable$.MODULE$.closeableIsCloseable());
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Deleting old files [{}]", new Object[]{toCompact.mkString(", ")});
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        $this.metadata().removePartition(new StorageMetadata.PartitionMetadata(partition, (Seq)toCompact.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.file(), Seq$.MODULE$.canBuildFrom()), StorageMetadata.PartitionBounds$.MODULE$.apply(bounds), written.elem));
        ListBuffer failures = (ListBuffer)ListBuffer$.MODULE$.empty();
        toCompact.foreach((Function1 & Serializable & scala.Serializable)file -> {
            AbstractFileSystemStorage.$anonfun$compact$10($this, failures, file);
            return BoxedUnit.UNIT;
        });
        if (failures.nonEmpty()) {
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("Failed to delete some files: [{}]", new Object[]{failures.mkString(", ")});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Compacted {} records", new Object[]{BoxesRunTime.boxToLong((long)written.elem)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final WriterConfig pathAndObserver$1(String partition$2, Enumeration.Value fileType$1, Enumeration.Value action$1) {
        Path path = StorageUtils$.MODULE$.nextFile(this.context().root(), partition$2, this.metadata().leafStorage(), this.extension, fileType$1, StorageUtils$.MODULE$.nextFile$default$6());
        PathCache$.MODULE$.register(this.context().fc(), path, PathCache$.MODULE$.register$default$3(), PathCache$.MODULE$.register$default$4());
        UpdateObserver updateObserver = new UpdateObserver(this, partition$2, path, action$1);
        FileSystemObserver observer = this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers().isEmpty() ? updateObserver : new FileSystemObserverFactory.CompositeObserver((Seq<FileSystemObserver>)((Seq)((SeqLike)this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.apply(path), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)updateObserver, Seq$.MODULE$.canBuildFrom())));
        return new WriterConfig(path, observer);
    }

    public AbstractFileSystemStorage(package.FileSystemContext context, StorageMetadata metadata, String extension) {
        this.context = context;
        this.metadata = metadata;
        this.extension = extension;
        FileSystemStorage.$init$((FileSystemStorage)this);
        SizeableFileSystemStorage.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        MethodProfiling.$init$((MethodProfiling)this);
    }

    public class ChunkedFileSystemWriter
    implements FileSystemStorage.FileSystemWriter {
        private final Iterator<WriterConfig> paths;
        private final FileSizeEstimator estimator;
        private long count;
        private long total;
        private long remaining;
        private Path path;
        private FileSystemStorage.FileSystemWriter writer;
        public final /* synthetic */ AbstractFileSystemStorage $outer;

        private long count() {
            return this.count;
        }

        private void count_$eq(long x$1) {
            this.count = x$1;
        }

        private long total() {
            return this.total;
        }

        private void total_$eq(long x$1) {
            this.total = x$1;
        }

        private long remaining() {
            return this.remaining;
        }

        private void remaining_$eq(long x$1) {
            this.remaining = x$1;
        }

        private Path path() {
            return this.path;
        }

        private void path_$eq(Path x$1) {
            this.path = x$1;
        }

        private FileSystemStorage.FileSystemWriter writer() {
            return this.writer;
        }

        private void writer_$eq(FileSystemStorage.FileSystemWriter x$1) {
            this.writer = x$1;
        }

        public void write(SimpleFeature feature) {
            if (this.writer() == null) {
                WriterConfig config = (WriterConfig)this.paths.next();
                this.path_$eq(config.path());
                this.writer_$eq(this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$ChunkedFileSystemWriter$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(config));
            }
            this.writer().write(feature);
            this.count_$eq(this.count() + 1L);
            this.remaining_$eq(this.remaining() - 1L);
            if (this.remaining() == 0L) {
                this.writer().close();
                this.writer_$eq(null);
                this.total_$eq(this.total() + this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$ChunkedFileSystemWriter$$$outer().context().fc().getFileStatus(this.path()).getLen());
                this.estimator.update(this.total(), this.count());
                this.remaining_$eq(this.estimator.estimate(0L));
                return;
            }
        }

        public void flush() {
            if (this.writer() != null) {
                this.writer().flush();
                return;
            }
        }

        public void close() {
            if (this.writer() != null) {
                this.writer().close();
            }
            this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$ChunkedFileSystemWriter$$$outer().updateFileSize(this.estimator);
        }

        public /* synthetic */ AbstractFileSystemStorage org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$ChunkedFileSystemWriter$$$outer() {
            return this.$outer;
        }

        public ChunkedFileSystemWriter(AbstractFileSystemStorage $outer, Iterator<WriterConfig> paths, FileSizeEstimator estimator) {
            this.paths = paths;
            this.estimator = estimator;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.count = 0L;
            this.total = 0L;
            this.remaining = estimator.estimate(0L);
        }
    }

    public static interface FileSystemPathReader {
        public CloseableIterator<SimpleFeature> read(Path var1);
    }

    public class FileSystemUpdateWriterImpl
    implements FileSystemStorage.FileSystemUpdateWriter {
        private final Iterator<SimpleFeature> reader;
        private final Option<String> readPartition;
        private final Map<String, FileSystemStorage.FileSystemWriter> modifiers;
        private final Map<String, FileSystemStorage.FileSystemWriter> deleters;
        private SimpleFeature feature;
        private String partition;
        public final /* synthetic */ AbstractFileSystemStorage $outer;

        public Iterator<SimpleFeature> seq() {
            return Iterator.seq$((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.isEmpty$((Iterator)this);
        }

        public boolean isTraversableAgain() {
            return Iterator.isTraversableAgain$((Iterator)this);
        }

        public boolean hasDefiniteSize() {
            return Iterator.hasDefiniteSize$((Iterator)this);
        }

        public Iterator<SimpleFeature> take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        public Iterator<SimpleFeature> drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        public Iterator<SimpleFeature> slice(int from, int until) {
            return Iterator.slice$((Iterator)this, (int)from, (int)until);
        }

        public Iterator<SimpleFeature> sliceIterator(int from, int until) {
            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<B> map(Function1<SimpleFeature, B> f) {
            return Iterator.map$((Iterator)this, f);
        }

        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
            return Iterator.$plus$plus$((Iterator)this, that);
        }

        public <B> Iterator<B> flatMap(Function1<SimpleFeature, GenTraversableOnce<B>> f) {
            return Iterator.flatMap$((Iterator)this, f);
        }

        public Iterator<SimpleFeature> filter(Function1<SimpleFeature, Object> p) {
            return Iterator.filter$((Iterator)this, p);
        }

        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<SimpleFeature, B, Object> p) {
            return Iterator.corresponds$((Iterator)this, that, p);
        }

        public Iterator<SimpleFeature> withFilter(Function1<SimpleFeature, Object> p) {
            return Iterator.withFilter$((Iterator)this, p);
        }

        public Iterator<SimpleFeature> filterNot(Function1<SimpleFeature, Object> p) {
            return Iterator.filterNot$((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<SimpleFeature, B> pf) {
            return Iterator.collect$((Iterator)this, pf);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, SimpleFeature, B> op) {
            return Iterator.scanLeft$((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<SimpleFeature, B, B> op) {
            return Iterator.scanRight$((Iterator)this, z, op);
        }

        public Iterator<SimpleFeature> takeWhile(Function1<SimpleFeature, Object> p) {
            return Iterator.takeWhile$((Iterator)this, p);
        }

        public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> partition(Function1<SimpleFeature, Object> p) {
            return Iterator.partition$((Iterator)this, p);
        }

        public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> span(Function1<SimpleFeature, Object> p) {
            return Iterator.span$((Iterator)this, p);
        }

        public Iterator<SimpleFeature> dropWhile(Function1<SimpleFeature, Object> p) {
            return Iterator.dropWhile$((Iterator)this, p);
        }

        public <B> Iterator<Tuple2<SimpleFeature, B>> zip(Iterator<B> that) {
            return Iterator.zip$((Iterator)this, that);
        }

        public <A1> Iterator<A1> padTo(int len, A1 elem) {
            return Iterator.padTo$((Iterator)this, (int)len, elem);
        }

        public Iterator<Tuple2<SimpleFeature, Object>> zipWithIndex() {
            return Iterator.zipWithIndex$((Iterator)this);
        }

        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
        }

        public <U> void foreach(Function1<SimpleFeature, U> f) {
            Iterator.foreach$((Iterator)this, f);
        }

        public boolean forall(Function1<SimpleFeature, Object> p) {
            return Iterator.forall$((Iterator)this, p);
        }

        public boolean exists(Function1<SimpleFeature, Object> p) {
            return Iterator.exists$((Iterator)this, p);
        }

        public boolean contains(Object elem) {
            return Iterator.contains$((Iterator)this, (Object)elem);
        }

        public Option<SimpleFeature> find(Function1<SimpleFeature, Object> p) {
            return Iterator.find$((Iterator)this, p);
        }

        public int indexWhere(Function1<SimpleFeature, Object> p) {
            return Iterator.indexWhere$((Iterator)this, p);
        }

        public int indexWhere(Function1<SimpleFeature, Object> p, int from) {
            return Iterator.indexWhere$((Iterator)this, p, (int)from);
        }

        public <B> int indexOf(B elem) {
            return Iterator.indexOf$((Iterator)this, elem);
        }

        public <B> int indexOf(B elem, int from) {
            return Iterator.indexOf$((Iterator)this, elem, (int)from);
        }

        public BufferedIterator<SimpleFeature> buffered() {
            return Iterator.buffered$((Iterator)this);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.grouped$((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
        }

        public <B> int sliding$default$2() {
            return Iterator.sliding$default$2$((Iterator)this);
        }

        public int length() {
            return Iterator.length$((Iterator)this);
        }

        public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> duplicate() {
            return Iterator.duplicate$((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <B> void copyToArray(Object xs, int start, int len) {
            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
        }

        public boolean sameElements(Iterator<?> that) {
            return Iterator.sameElements$((Iterator)this, that);
        }

        public Traversable<SimpleFeature> toTraversable() {
            return Iterator.toTraversable$((Iterator)this);
        }

        public Iterator<SimpleFeature> toIterator() {
            return Iterator.toIterator$((Iterator)this);
        }

        public Stream<SimpleFeature> toStream() {
            return Iterator.toStream$((Iterator)this);
        }

        public String toString() {
            return Iterator.toString$((Iterator)this);
        }

        public List<SimpleFeature> reversed() {
            return TraversableOnce.reversed$((TraversableOnce)this);
        }

        public int size() {
            return TraversableOnce.size$((TraversableOnce)this);
        }

        public boolean nonEmpty() {
            return TraversableOnce.nonEmpty$((TraversableOnce)this);
        }

        public int count(Function1<SimpleFeature, Object> p) {
            return TraversableOnce.count$((TraversableOnce)this, p);
        }

        public <B> Option<B> collectFirst(PartialFunction<SimpleFeature, B> pf) {
            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
        }

        public <B> B $div$colon(B z, Function2<B, SimpleFeature, B> op) {
            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
        }

        public <B> B $colon$bslash(B z, Function2<SimpleFeature, B, B> op) {
            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
        }

        public <B> B foldLeft(B z, Function2<B, SimpleFeature, B> op) {
            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
        }

        public <B> B foldRight(B z, Function2<SimpleFeature, B, B> op) {
            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
        }

        public <B> B reduceLeft(Function2<B, SimpleFeature, B> op) {
            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
        }

        public <B> B reduceRight(Function2<SimpleFeature, B, B> op) {
            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, SimpleFeature, B> op) {
            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<SimpleFeature, B, B> op) {
            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
        }

        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
        }

        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, SimpleFeature, B> seqop, Function2<B, B, B> combop) {
            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)TraversableOnce.product$((TraversableOnce)this, num);
        }

        public Object min(Ordering cmp) {
            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object max(Ordering cmp) {
            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object maxBy(Function1 f, Ordering cmp) {
            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public Object minBy(Function1 f, Ordering cmp) {
            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public <B> void copyToBuffer(Buffer<B> dest) {
            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
        }

        public <B> void copyToArray(Object xs, int start) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
        }

        public <B> void copyToArray(Object xs) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
        }

        public <B> Object toArray(ClassTag<B> evidence$1) {
            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
        }

        public List<SimpleFeature> toList() {
            return TraversableOnce.toList$((TraversableOnce)this);
        }

        public Iterable<SimpleFeature> toIterable() {
            return TraversableOnce.toIterable$((TraversableOnce)this);
        }

        public Seq<SimpleFeature> toSeq() {
            return TraversableOnce.toSeq$((TraversableOnce)this);
        }

        public IndexedSeq<SimpleFeature> toIndexedSeq() {
            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
        }

        public <B> Buffer<B> toBuffer() {
            return TraversableOnce.toBuffer$((TraversableOnce)this);
        }

        public <B> Set<B> toSet() {
            return TraversableOnce.toSet$((TraversableOnce)this);
        }

        public Vector<SimpleFeature> toVector() {
            return TraversableOnce.toVector$((TraversableOnce)this);
        }

        public <Col> Col to(CanBuildFrom<Nothing$, SimpleFeature, Col> cbf) {
            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
        }

        public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef$.less.colon.less<SimpleFeature, Tuple2<T, U>> ev) {
            return TraversableOnce.toMap$((TraversableOnce)this, ev);
        }

        public String mkString(String start, String sep, String end) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
        }

        public String mkString(String sep) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
        }

        public String mkString() {
            return TraversableOnce.mkString$((TraversableOnce)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public StringBuilder addString(StringBuilder b, String sep) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
        }

        public StringBuilder addString(StringBuilder b) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
        }

        public int sizeHintIfCheap() {
            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
        }

        private Map<String, FileSystemStorage.FileSystemWriter> modifiers() {
            return this.modifiers;
        }

        private Map<String, FileSystemStorage.FileSystemWriter> deleters() {
            return this.deleters;
        }

        private SimpleFeature feature() {
            return this.feature;
        }

        private void feature_$eq(SimpleFeature x$1) {
            this.feature = x$1;
        }

        private String partition() {
            return this.partition;
        }

        private void partition_$eq(String x$1) {
            this.partition = x$1;
        }

        public void write() {
            String update;
            if (this.feature() == null) {
                throw new IllegalArgumentException("Must call 'next' before calling 'write'");
            }
            String string = update = this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().metadata().scheme().getPartitionName(this.feature());
            String string2 = this.partition();
            if (string == null ? string2 != null : !string.equals(string2)) {
                ((FileSystemStorage.FileSystemWriter)this.deleters().getOrElseUpdate((Object)this.partition(), (Function0 & Serializable & scala.Serializable)() -> this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(this.partition(), StorageMetadata.StorageFileAction$.MODULE$.Delete(), StorageUtils$FileType$.MODULE$.Deleted(), this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter$default$4()))).write(this.feature());
            }
            ((FileSystemStorage.FileSystemWriter)this.modifiers().getOrElseUpdate((Object)update, (Function0 & Serializable & scala.Serializable)() -> this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(update, StorageMetadata.StorageFileAction$.MODULE$.Modify(), StorageUtils$FileType$.MODULE$.Modified(), this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter$default$4()))).write(this.feature());
            this.feature_$eq(null);
        }

        public void remove() {
            if (this.feature() == null) {
                throw new IllegalArgumentException("Must call 'next' before calling 'remove'");
            }
            ((FileSystemStorage.FileSystemWriter)this.deleters().getOrElseUpdate((Object)this.partition(), (Function0 & Serializable & scala.Serializable)() -> this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter(this.partition(), StorageMetadata.StorageFileAction$.MODULE$.Delete(), StorageUtils$FileType$.MODULE$.Deleted(), this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$createWriter$default$4()))).write(this.feature());
            this.feature_$eq(null);
        }

        public boolean hasNext() {
            return this.reader.hasNext();
        }

        public SimpleFeature next() {
            this.feature_$eq((SimpleFeature)this.reader.next());
            this.partition_$eq((String)this.readPartition.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().metadata().scheme().getPartitionName(this.feature())));
            return this.feature();
        }

        public void flush() {
            package.FlushQuietly$.MODULE$.raise(this.modifiers().values().toSeq().$plus$plus((GenTraversableOnce)this.deleters().values(), Seq$.MODULE$.canBuildFrom()), (IsFlushable)IsFlushable$.MODULE$.iterableIsFlushable());
        }

        public void close() {
            package.CloseQuietly$.MODULE$.raise(((TraversableLike)((TraversableLike)((TraversableLike)new .colon.colon(this.reader, (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)this.modifiers().values(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.deleters().values(), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer().org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$observers(), Seq$.MODULE$.canBuildFrom()), (IsCloseable)IsCloseable$.MODULE$.iterableIsCloseable());
        }

        public /* synthetic */ AbstractFileSystemStorage org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$FileSystemUpdateWriterImpl$$$outer() {
            return this.$outer;
        }

        public FileSystemUpdateWriterImpl(AbstractFileSystemStorage $outer, Iterator<SimpleFeature> reader, Option<String> readPartition) {
            this.reader = reader;
            this.readPartition = readPartition;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            GenTraversableOnce.$init$((GenTraversableOnce)this);
            TraversableOnce.$init$((TraversableOnce)this);
            Iterator.$init$((Iterator)this);
            this.modifiers = Map$.MODULE$.empty();
            this.deleters = Map$.MODULE$.empty();
        }
    }

    public static abstract class MetadataObserver
    implements FileSystemObserver {
        private long count = 0L;
        private final Envelope bounds = new Envelope();

        private long count() {
            return this.count;
        }

        private void count_$eq(long x$1) {
            this.count = x$1;
        }

        private Envelope bounds() {
            return this.bounds;
        }

        public void write(SimpleFeature feature) {
            this.count_$eq(this.count() + 1L);
            Geometry geom = (Geometry)feature.getDefaultGeometry();
            if (geom != null) {
                this.bounds().expandToInclude(geom.getEnvelopeInternal());
                return;
            }
        }

        public void flush() {
        }

        public void close() {
            this.onClose(this.bounds(), this.count());
        }

        public abstract void onClose(Envelope var1, long var2);
    }

    public class UpdateObserver
    extends MetadataObserver {
        private final String partition;
        private final Path file;
        private final Enumeration.Value action;
        public final /* synthetic */ AbstractFileSystemStorage $outer;

        @Override
        public void onClose(Envelope bounds, long count) {
            Seq files = (Seq)new .colon.colon((Object)new StorageMetadata.StorageFile(this.file.getName(), System.currentTimeMillis(), this.action, StorageMetadata.StorageFile$.MODULE$.apply$default$4(), StorageMetadata.StorageFile$.MODULE$.apply$default$5()), (List)Nil$.MODULE$);
            this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$UpdateObserver$$$outer().metadata().addPartition(new StorageMetadata.PartitionMetadata(this.partition, files, StorageMetadata.PartitionBounds$.MODULE$.apply(bounds), count));
        }

        public /* synthetic */ AbstractFileSystemStorage org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$UpdateObserver$$$outer() {
            return this.$outer;
        }

        public UpdateObserver(AbstractFileSystemStorage $outer, String partition, Path file, Enumeration.Value action) {
            this.partition = partition;
            this.file = file;
            this.action = action;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    private static class WriterConfig
    implements Product,
    scala.Serializable {
        private final Path path;
        private final FileSystemObserver observer;

        public Path path() {
            return this.path;
        }

        public FileSystemObserver observer() {
            return this.observer;
        }

        public WriterConfig copy(Path path, FileSystemObserver observer) {
            return new WriterConfig(path, observer);
        }

        public Path copy$default$1() {
            return this.path();
        }

        public FileSystemObserver copy$default$2() {
            return this.observer();
        }

        public String productPrefix() {
            return "WriterConfig";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.path();
                }
                case 1: {
                    return this.observer();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof WriterConfig;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof WriterConfig)) return false;
            boolean bl = true;
            if (!bl) return false;
            WriterConfig writerConfig = (WriterConfig)x$1;
            Path path = this.path();
            Path path2 = writerConfig.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!path.equals(path2)) return false;
            FileSystemObserver fileSystemObserver = this.observer();
            FileSystemObserver fileSystemObserver2 = writerConfig.observer();
            if (fileSystemObserver == null) {
                if (fileSystemObserver2 != null) {
                    return false;
                }
            } else if (!fileSystemObserver.equals(fileSystemObserver2)) return false;
            if (!writerConfig.canEqual(this)) return false;
            return true;
        }

        public WriterConfig(Path path, FileSystemObserver observer) {
            this.path = path;
            this.observer = observer;
            Product.$init$((Product)this);
        }
    }
}

