/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.partitions;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.fs.storage.api.PartitionScheme;
import org.locationtech.geomesa.fs.storage.api.PartitionSchemeFactory;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.partitions.SpatialScheme$Config$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.zorder.sfcurve.package;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h!\u0002\u0012$\u0003\u0003\u0011\u0004\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011\r\u0003!\u0011!Q\u0001\n\u0011CQa\u0014\u0001\u0005\u0002ACq!\u0016\u0001C\u0002\u0013Ea\u000b\u0003\u0004X\u0001\u0001\u0006I\u0001\u0012\u0005\u00061\u00021\t\"\u0017\u0005\u00067\u00021\t\u0002\u0018\u0005\n\u0003\u000f\u0001!\u0019!C!\u0003\u0013Aq!a\u0003\u0001A\u0003%\u0001\tC\u0004\u0002\u000e\u0001!\t%a\u0004\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N!9\u00111\n\u0001\u0005\n\u0005UsaBA.G!\u0005\u0011Q\f\u0004\u0007E\rB\t!a\u0018\t\r=sA\u0011AA1\u000f\u001d\t\u0019G\u0004E\u0001\u0003K2q!!\u001b\u000f\u0011\u0003\tY\u0007\u0003\u0004P#\u0011\u0005\u0011Q\u000e\u0005\t\u0003_\n\"\u0019!C\u0001-\"9\u0011\u0011O\t!\u0002\u0013!\u0005\u0002CA:#\t\u0007I\u0011\u0001,\t\u000f\u0005U\u0014\u0003)A\u0005\t\"A\u0011qO\tC\u0002\u0013\u0005a\u000bC\u0004\u0002zE\u0001\u000b\u0011\u0002#\u0007\u000f\u0005md\"!\u0001\u0002~!I\u0011QQ\r\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\u0007\u001ff!\t!a\"\t\u0013\u00055\u0015D1A\u0005\n\u0005=\u0005\u0002CAS3\u0001\u0006I!!%\t\u0011\u0005\u001d\u0016D1A\u0005\nYCq!!+\u001aA\u0003%A\tC\u0004\u0002,f!\t%!,\t\u000f\u0005U\u0017D\"\u0001\u0002X\ni1\u000b]1uS\u0006d7k\u00195f[\u0016T!\u0001J\u0013\u0002\u0015A\f'\u000f^5uS>t7O\u0003\u0002'O\u000511m\\7n_:T!\u0001K\u0015\u0002\u000fM$xN]1hK*\u0011!fK\u0001\u0003MNT!\u0001L\u0017\u0002\u000f\u001d,w.\\3tC*\u0011afL\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002a\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aM\u001d\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\r\u0005s\u0017PU3g!\tQT(D\u0001<\u0015\tat%A\u0002ba&L!AP\u001e\u0003\u001fA\u000b'\u000f^5uS>t7k\u00195f[\u0016\fAAY5ugB\u0011A'Q\u0005\u0003\u0005V\u00121!\u00138u\u0003\u00119Wm\\7\u0011\u0005\u0015ceB\u0001$K!\t9U'D\u0001I\u0015\tI\u0015'\u0001\u0004=e>|GOP\u0005\u0003\u0017V\na\u0001\u0015:fI\u00164\u0017BA'O\u0005\u0019\u0019FO]5oO*\u00111*N\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007E\u001bF\u000b\u0005\u0002S\u00015\t1\u0005C\u0003@\u0007\u0001\u0007\u0001\tC\u0003D\u0007\u0001\u0007A)\u0001\u0004g_Jl\u0017\r^\u000b\u0002\t\u00069am\u001c:nCR\u0004\u0013A\u00023jO&$8\u000f\u0006\u0002A5\")qH\u0002a\u0001\u0001\u0006qq-\u001a8fe\u0006$XMU1oO\u0016\u001cHCA/{!\rq6M\u001a\b\u0003?\u0006t!a\u00121\n\u0003YJ!AY\u001b\u0002\u000fA\f7m[1hK&\u0011A-\u001a\u0002\u0004'\u0016\f(B\u000126!\t9wO\u0004\u0002ik:\u0011\u0011N\u001d\b\u0003UBt!a[8\u000f\u00051tgBA$n\u0013\u0005\u0001\u0014B\u0001\u00180\u0013\taS&\u0003\u0002rW\u00051!p\u001c:eKJL!a\u001d;\u0002\u000fM47-\u001e:wK*\u0011\u0011oK\u0005\u0003EZT!a\u001d;\n\u0005aL(AC%oI\u0016D(+\u00198hK*\u0011!M\u001e\u0005\u0006w\u001e\u0001\r\u0001`\u0001\u0003qf\u00042AX2~!)!d0!\u0001\u0002\u0002\u0005\u0005\u0011\u0011A\u0005\u0003\u007fV\u0012a\u0001V;qY\u0016$\u0004c\u0001\u001b\u0002\u0004%\u0019\u0011QA\u001b\u0003\r\u0011{WO\u00197f\u0003\u0015!W\r\u001d;i+\u0005\u0001\u0015A\u00023faRD\u0007%\u0001\u000bhKR\u001c\u0016.\u001c9mS\u001aLW\r\u001a$jYR,'o\u001d\u000b\u0007\u0003#\t\u0019$!\u0012\u0011\u000bQ\n\u0019\"a\u0006\n\u0007\u0005UQG\u0001\u0004PaRLwN\u001c\t\u0005=\u000e\fI\u0002\u0005\u0003\u0002\u001c\u00055b\u0002BA\u000f\u0003SqA!a\b\u0002(9!\u0011\u0011EA\u0013\u001d\rQ\u00171E\u0005\u0003U-J!\u0001K\u0015\n\u0005q:\u0013bAA\u0016w\u0005y\u0001+\u0019:uSRLwN\\*dQ\u0016lW-\u0003\u0003\u00020\u0005E\"\u0001E*j[Bd\u0017NZ5fI\u001aKG\u000e^3s\u0015\r\tYc\u000f\u0005\b\u0003kQ\u0001\u0019AA\u001c\u0003\u00191\u0017\u000e\u001c;feB!\u0011\u0011HA!\u001b\t\tYD\u0003\u0003\u00026\u0005u\"bAA _\u00059q\u000e]3oO&\u001c\u0018\u0002BA\"\u0003w\u0011aAR5mi\u0016\u0014\b\"CA$\u0015A\u0005\t\u0019AA%\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u00035\u0003'!\u0015!G4fi&sG/\u001a:tK\u000e$\u0018N\\4QCJ$\u0018\u000e^5p]N$B!a\u0014\u0002TA)A'a\u0005\u0002RA\u0019al\u0019#\t\u000f\u0005U2\u00021\u0001\u00028Q1\u0011qJA,\u00033Bq!!\u000e\r\u0001\u0004\t9\u0004C\u0004\u0002H1\u0001\r!!\u0013\u0002\u001bM\u0003\u0018\r^5bYN\u001b\u0007.Z7f!\t\u0011fb\u0005\u0002\u000fgQ\u0011\u0011QL\u0001\u0007\u0007>tg-[4\u0011\u0007\u0005\u001d\u0014#D\u0001\u000f\u0005\u0019\u0019uN\u001c4jON\u0011\u0011c\r\u000b\u0003\u0003K\nQbR3p[\u0006#HO]5ckR,\u0017AD$f_6\fE\u000f\u001e:jEV$X\rI\u0001\r5J\u0012Vm]8mkRLwN\\\u0001\u000e5J\u0012Vm]8mkRLwN\u001c\u0011\u0002\u001baS&GU3t_2,H/[8o\u00039A&L\r*fg>dW\u000f^5p]\u0002\u0012Qd\u00159bi&\fG\u000eU1si&$\u0018n\u001c8TG\",W.\u001a$bGR|'/_\n\u00053M\ny\bE\u0002;\u0003\u0003K1!a!<\u0005Y\u0001\u0016M\u001d;ji&|gnU2iK6,g)Y2u_JL\u0018\u0001\u00028b[\u0016$B!!#\u0002\fB\u0019\u0011qM\r\t\r\u0005\u00155\u00041\u0001E\u0003-q\u0017-\\3QCR$XM\u001d8\u0016\u0005\u0005E\u0005\u0003BAJ\u0003Ck!!!&\u000b\t\u0005]\u0015\u0011T\u0001\u0006e\u0016<W\r\u001f\u0006\u0005\u00037\u000bi*\u0001\u0003vi&d'BAAP\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0016Q\u0013\u0002\b!\u0006$H/\u001a:o\u00031q\u0017-\\3QCR$XM\u001d8!\u0003)\u0011Xm]8mkRLwN\\\u0001\fe\u0016\u001cx\u000e\\;uS>t\u0007%\u0001\u0003m_\u0006$GCBAX\u0003c\u000b)\r\u0005\u00035\u0003'I\u0004bBAZA\u0001\u0007\u0011QW\u0001\u0004g\u001a$\b\u0003BA\\\u0003\u0003l!!!/\u000b\t\u0005m\u0016QX\u0001\u0007g&l\u0007\u000f\\3\u000b\t\u0005}\u0016QH\u0001\bM\u0016\fG/\u001e:f\u0013\u0011\t\u0019-!/\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X\rC\u0004\u0002H\u0002\u0002\r!!3\u0002\r\r|gNZ5h!\u0011\tY-a4\u000f\t\u0005u\u0011QZ\u0005\u0003EnJA!!5\u0002T\naa*Y7fI>\u0003H/[8og*\u0011!mO\u0001\u0015EVLG\u000e\u001a)beRLG/[8o'\u000eDW-\\3\u0015\u000fE\u000bI.a7\u0002^\")q(\ta\u0001\u0001\")1)\ta\u0001\t\"1\u0011q\\\u0011A\u0002\u0001\u000b\u0011bZ3p[&sG-\u001a=")
public abstract class SpatialScheme
implements PartitionScheme {
    private final String geom;
    private final String format;
    private final int depth;

    public Option<String> getSimplifiedFilters$default$2() {
        return PartitionScheme.getSimplifiedFilters$default$2$((PartitionScheme)this);
    }

    public String format() {
        return this.format;
    }

    public abstract int digits(int var1);

    public abstract Seq<package.IndexRange> generateRanges(Seq<Tuple4<Object, Object, Object, Object>> var1);

    public int depth() {
        return this.depth;
    }

    public Option<Seq<PartitionScheme.SimplifiedFilter>> getSimplifiedFilters(Filter filter, Option<String> partition) {
        return this.getIntersectingPartitions(filter, partition).map((Function1 & Serializable & scala.Serializable)partitions -> (Seq)new .colon.colon((Object)new PartitionScheme.SimplifiedFilter(filter, partitions, false), (List)Nil$.MODULE$));
    }

    public Option<Seq<String>> getIntersectingPartitions(Filter filter) {
        return this.getIntersectingPartitions(filter, (Option<String>)None$.MODULE$);
    }

    private Option<Seq<String>> getIntersectingPartitions(Filter filter, Option<String> partition) {
        FilterValues geometries = FilterHelper$.MODULE$.extractGeometries(filter, this.geom, true);
        if (geometries.disjoint()) {
            return new Some((Object)Nil$.MODULE$);
        }
        if (geometries.values().isEmpty()) {
            return None$.MODULE$;
        }
        Seq partitions = (Seq)partition.map((Function1 & Serializable & scala.Serializable)x$1 -> (Seq)new .colon.colon(x$1, (List)Nil$.MODULE$)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Seq<package.IndexRange> ranges = this.generateRanges((Seq<Tuple4<Object, Object, Object, Object>>)((Seq)geometries.values().map((Function1 & Serializable & scala.Serializable)geometry -> GeometryUtils$.MODULE$.bounds(geometry), Seq$.MODULE$.canBuildFrom())));
            return (Seq)((TraversableLike)((SeqLike)ranges.flatMap((Function1 & Serializable & scala.Serializable)r -> new RichLong(Predef$.MODULE$.longWrapper(r.lower())).to((Object)BoxesRunTime.boxToLong((long)r.upper())), Seq$.MODULE$.canBuildFrom())).distinct()).map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)x$2))), this.format()), Seq$.MODULE$.canBuildFrom());
        });
        return new Some((Object)partitions);
    }

    public SpatialScheme(int bits, String geom) {
        this.geom = geom;
        PartitionScheme.$init$((PartitionScheme)this);
        Predef$.MODULE$.require(bits % 2 == 0, (Function0 & Serializable & scala.Serializable)() -> "Resolution must be an even number");
        this.format = new StringBuilder(3).append("%0").append(this.digits(bits)).append("d").toString();
        this.depth = 1;
    }

    public static abstract class SpatialPartitionSchemeFactory
    implements PartitionSchemeFactory {
        private final String name;
        private final Pattern namePattern;
        private final String resolution;

        private Pattern namePattern() {
            return this.namePattern;
        }

        private String resolution() {
            return this.resolution;
        }

        public Option<PartitionScheme> load(SimpleFeatureType sft, package.NamedOptions config) {
            Matcher matcher = this.namePattern().matcher(config.name());
            if (!matcher.matches()) {
                return None$.MODULE$;
            }
            String geom = (String)config.options().getOrElse((Object)SpatialScheme$Config$.MODULE$.GeomAttribute(), (Function0 & Serializable & scala.Serializable)() -> RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
            int geomIndex = sft.indexOf(geom);
            if (geomIndex == -1) {
                throw new IllegalArgumentException(new StringBuilder(40).append(this.name).append(" scheme requires valid geometry field '").append(SpatialScheme$Config$.MODULE$.GeomAttribute()).append("'").toString());
            }
            int res = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)matcher.group(2)).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty())).orElse((Function0 & Serializable & scala.Serializable)() -> config.options().get((Object)this.resolution())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)SpatialPartitionSchemeFactory.$anonfun$load$4(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(34).append($this.name).append(" scheme requires bit resolution '").append(this.resolution()).append("'").toString());
            }));
            return new Some((Object)this.buildPartitionScheme(res, geom, geomIndex));
        }

        public abstract SpatialScheme buildPartitionScheme(int var1, String var2, int var3);

        public static final /* synthetic */ int $anonfun$load$4(String x$1) {
            return Integer.parseInt(x$1);
        }

        public SpatialPartitionSchemeFactory(String name) {
            this.name = name;
            this.namePattern = Pattern.compile(new StringBuilder(17).append(name).append("(-([0-9]+)bits?)?").toString());
            this.resolution = new StringBuilder(11).append(name).append("-resolution").toString();
        }
    }
}

